/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.glite.security.voms.admin.common.VOMSConfiguration;
import org.glite.security.voms.admin.common.VOMSException;
import org.glite.security.voms.admin.common.tasks.DatabaseSetupTask;
import org.glite.security.voms.admin.common.tasks.UpdateCATask;
import org.glite.security.voms.admin.dao.ACLDAO;
import org.glite.security.voms.admin.dao.VOMSAdminDAO;
import org.glite.security.voms.admin.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.dao.VOMSUserDAO;
import org.glite.security.voms.admin.database.HibernateFactory;
import org.glite.security.voms.admin.model.ACL;
import org.glite.security.voms.admin.model.VOMSAdmin;
import org.glite.security.voms.admin.model.VOMSGroup;
import org.glite.security.voms.admin.model.VOMSRole;
import org.glite.security.voms.admin.model.VOMSUser;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.tools.ACLMapper;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.type.LongType;
import org.hibernate.type.ShortType;
import org.hibernate.type.Type;

public class SchemaDeployer {
    public static final String ORACLE_PRODUCT_NAME = "Oracle";
    public static final String MYSQL_PRODUCT_NAME = "MySQL";
    private static final Log log = LogFactory.getLog(SchemaDeployer.class);
    protected CommandLineParser parser = new PosixParser();
    protected HelpFormatter helpFormatter = new HelpFormatter();
    protected Options options;
    String command;
    String vo;
    String hibernateConfigFile = null;
    String hibernatePropertiesFile = null;
    String adminDN = null;
    String adminCA = null;
    String adminEmailAddress = null;
    SessionFactory sf;

    public SchemaDeployer(String[] args) {
        this.setupCLParser();
        this.checkArguments(args);
        this.execute();
    }

    private void execute() {
        System.setProperty("voms.vo.name", this.vo);
        VOMSConfiguration.instance(false, null);
        if (this.command.equals("deploy")) {
            this.doDeploy();
        } else if (this.command.equals("undeploy")) {
            this.doUndeploy();
        } else if (this.command.equals("upgrade")) {
            this.doUpgrade();
        } else if (this.command.equals("add-admin")) {
            this.doAddAdmin();
        } else if (this.command.equals("remove-admin")) {
            this.doRemoveAdmin();
        } else {
            throw new VOMSException("Unknown command: " + this.command);
        }
        System.exit(0);
    }

    private boolean isOracleBackend() {
        Session s = HibernateFactory.getSession();
        Transaction t = s.beginTransaction();
        DatabaseMetaData dbMetadata = null;
        String dbProductName = null;
        try {
            dbMetadata = s.connection().getMetaData();
            dbProductName = dbMetadata.getDatabaseProductName();
        }
        catch (HibernateException e) {
            log.error((Object)"Hibernate error accessing database metadata from Hibernate connection!", (Throwable)e);
            System.exit(-1);
        }
        catch (SQLException e) {
            log.error((Object)"SQL error while accessing database metadata from Hibernate connection!", (Throwable)e);
            System.exit(-1);
        }
        log.debug((Object)("Detected database: " + dbProductName));
        return dbProductName.trim().equals(ORACLE_PRODUCT_NAME);
    }

    private void printExceptions(List l) {
        for (Throwable t : l) {
            log.fatal((Object)t.getMessage());
            if (!log.isDebugEnabled()) continue;
            log.fatal((Object)t, t);
        }
    }

    private int checkDatabaseExistence() {
        log.info((Object)"Checking database existence...");
        Session s = HibernateFactory.getSession();
        Transaction t = s.beginTransaction();
        DatabaseMetaData dbMetadata = null;
        try {
            dbMetadata = s.connection().getMetaData();
        }
        catch (HibernateException e) {
            log.error((Object)"Hibernate error accessing database metadata from Hibernate connection!", (Throwable)e);
            System.exit(-1);
        }
        catch (SQLException e) {
            log.error((Object)"SQL error while accessing database metadata from Hibernate connection!", (Throwable)e);
            System.exit(-1);
        }
        String[] names = new String[]{"TABLE"};
        ResultSet tableNames = null;
        try {
            tableNames = dbMetadata.getTables(null, "%", "%", names);
        }
        catch (SQLException e) {
            log.error((Object)"Error reading table names from database metadata object!", (Throwable)e);
            System.exit(-1);
        }
        boolean foundACL2 = false;
        boolean foundACL = false;
        try {
            while (tableNames.next()) {
                String tName = tableNames.getString("TABLE_NAME");
                if (tName.equals("ACL") || tName.equals("acl")) {
                    foundACL = true;
                }
                if (!tName.equals("ACL2") && !tName.equals("acl2")) continue;
                foundACL2 = true;
            }
            HibernateFactory.commitTransaction();
        }
        catch (SQLException e) {
            log.error((Object)"Error accessing table names result set!", (Throwable)e);
            System.exit(-1);
        }
        catch (HibernateException e) {
            log.error((Object)"Error committing read-only hibernate transaction!", (Throwable)e);
            System.exit(-1);
        }
        if (foundACL2) {
            log.info((Object)"Found existing voms-admin 2.0.x database...");
            return 2;
        }
        if (foundACL) {
            log.info((Object)"Found existing voms-admin 1.2.x database...");
            return 1;
        }
        return -1;
    }

    private void doUpgrade() {
        Configuration hibernateConfig = this.loadHibernateConfiguration();
        int existingDB = this.checkDatabaseExistence();
        if (existingDB == -1) {
            log.error((Object)"No voms-admin 1.2.x database found to upgrade!");
            System.exit(-1);
        }
        Session s = HibernateFactory.getSession();
        HibernateFactory.beginTransaction();
        try {
            log.info((Object)"Upgrading voms database...");
            this.renameOldTables();
            HibernateFactory.commitTransaction();
            HibernateFactory.beginTransaction();
            SchemaExport exporter = new SchemaExport(hibernateConfig);
            exporter.execute(true, true, false, true);
            log.info((Object)"Deploying voms 2 database...");
            List l = exporter.getExceptions();
            if (!l.isEmpty()) {
                log.fatal((Object)"Error deploying voms 2 database!");
                this.printExceptions(l);
                System.exit(2);
            }
            if (this.isOracleBackend()) {
                this.fixHibernateSequence();
            }
            this.migrateDbContents();
            this.migrateMappings();
            this.migrateACLs();
            this.dropOldTables();
            if (this.isOracleBackend()) {
                this.dropOldSequences();
            }
            HibernateFactory.commitTransaction();
            log.info((Object)"Database upgraded succesfully!");
        }
        catch (Throwable t) {
            log.error((Object)"Database upgrade failed!");
            log.error((Object)t, t);
            HibernateFactory.rollbackTransaction();
            HibernateFactory.closeSession();
            System.exit(2);
        }
    }

    private void doRemoveAdmin() {
        if (this.adminDN == null || this.adminCA == null) {
            throw new VOMSException("adminDN or adminCA is not set!");
        }
        try {
            VOMSAdmin a = VOMSAdminDAO.instance().getByName(this.adminDN, this.adminCA);
            if (a == null) {
                log.info((Object)("Admin '" + this.adminDN + "," + this.adminCA + "' does not exists in database..."));
                return;
            }
            ACLDAO.instance().deletePermissionsForAdmin(a);
            VOMSAdminDAO.instance().delete(a);
            HibernateFactory.commitTransaction();
        }
        catch (Throwable t) {
            log.error((Object)"Error removing administrator!");
            log.error((Object)t, t);
            System.exit(-1);
        }
    }

    private void doAddAdmin() {
        if (this.adminDN == null || this.adminCA == null || this.adminEmailAddress == null) {
            throw new VOMSException("adminDN or adminCA or adminEmailAddress is not set!");
        }
        try {
            VOMSAdmin a = VOMSAdminDAO.instance().getByName(this.adminDN, this.adminCA);
            if (a != null) {
                log.info((Object)("Admin '" + a.getDn() + "," + a.getCa().getDn() + "' already exists in database..."));
                return;
            }
            a = VOMSAdminDAO.instance().create(this.adminDN, this.adminCA, this.adminEmailAddress);
            Iterator i = VOMSGroupDAO.instance().findAll().iterator();
            Iterator rolesIter = VOMSRoleDAO.instance().findAll().iterator();
            while (i.hasNext()) {
                VOMSGroup g = (VOMSGroup)i.next();
                g.getACL().setPermissions(a, VOMSPermission.getAllPermissions());
                while (rolesIter.hasNext()) {
                    VOMSRole r = (VOMSRole)rolesIter.next();
                    VOMSContext.instance(g, r).getACL().setPermissions(a, VOMSPermission.getAllPermissions());
                    HibernateFactory.getSession().update((Object)r);
                }
                HibernateFactory.getSession().update((Object)g);
            }
            HibernateFactory.commitTransaction();
        }
        catch (Throwable t) {
            log.error((Object)"Error adding new administrator!");
            log.error((Object)t, t);
            System.exit(-1);
        }
    }

    private Configuration loadHibernateConfiguration() {
        Properties dbProperties = new Properties();
        try {
            if (this.hibernatePropertiesFile == null) {
                String f = System.getProperty("GLITE_LOCATION_VAR") + "/etc/voms-admin/" + this.vo + "/voms.database.properties";
                log.debug((Object)("Loading database properties from: " + f));
                dbProperties.load(new FileInputStream(f));
            } else {
                dbProperties.load(new FileInputStream(this.hibernatePropertiesFile));
            }
        }
        catch (IOException e) {
            log.error((Object)("Error loading hibernate properties: " + e.getMessage()), (Throwable)e);
            throw new VOMSException("Error loading hibernate properties: " + e.getMessage(), e);
        }
        return new Configuration().addProperties(dbProperties).configure();
    }

    private void doUndeploy() {
        log.info((Object)"Undeploying voms database...");
        Configuration hibernateConfig = this.loadHibernateConfiguration();
        int existingDB = this.checkDatabaseExistence();
        if (existingDB == 1) {
            log.error((Object)"This tool cannot undeploy voms-admin 1.2.x database! Please upgrade to voms-admin 2 or use voms-admin-configure 1.2.x tools to undeploy this database.");
            System.exit(-1);
        }
        if (existingDB < 0) {
            log.error((Object)"No voms-admin database found!");
            System.exit(-1);
        }
        SchemaExport export = new SchemaExport(hibernateConfig);
        export.drop(false, true);
        List l = export.getExceptions();
        if (!l.isEmpty()) {
            log.fatal((Object)"Error undeploying voms database!");
            this.printExceptions(l);
            System.exit(2);
        }
        log.info((Object)"Database undeployed correctly!");
    }

    private void doDeploy() {
        Configuration hibernateConfig = this.loadHibernateConfiguration();
        int existingDb = this.checkDatabaseExistence();
        if (existingDb > 0) {
            log.warn((Object)"Existing voms database found. Will not overwrite the database!");
            System.exit(0);
        }
        SchemaExport exporter = new SchemaExport(hibernateConfig);
        exporter.execute(true, true, false, true);
        log.info((Object)"Deploying voms database...");
        List l = exporter.getExceptions();
        if (!l.isEmpty()) {
            log.fatal((Object)"Error deploying voms database!");
            this.printExceptions(l);
            System.exit(2);
        }
        UpdateCATask caTask = UpdateCATask.instance(null);
        caTask.run();
        DatabaseSetupTask task = DatabaseSetupTask.instance();
        task.run();
        HibernateFactory.commitTransaction();
        log.info((Object)"Database deployed correctly!");
    }

    protected void setupCLParser() {
        this.options = new Options();
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Displays helps and exits.");
        this.options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)"command");
        OptionBuilder.withDescription((String)"Specifies the command to be executed: deploy,undeploy,upgrade,add-admin");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"command"));
        OptionBuilder.withLongOpt((String)"vo");
        OptionBuilder.withDescription((String)"Specifies the vo name.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"vo"));
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"Specifies the hibernate config file to be used.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"config"));
        OptionBuilder.withLongOpt((String)"properties");
        OptionBuilder.withDescription((String)"Specifies the hibernate properties file to be used.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"properties"));
        OptionBuilder.withLongOpt((String)"dn");
        OptionBuilder.withDescription((String)"Specifies the dn for the admin to add (valid only if add-admin command is given).");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"dn"));
        OptionBuilder.withLongOpt((String)"ca");
        OptionBuilder.withDescription((String)"Specifies the ca for the admin to add (valid only if add-admin command is given).");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"ca"));
        OptionBuilder.withLongOpt((String)"email");
        OptionBuilder.withDescription((String)"Specifies the email address for the admin to add (valid only if add-admin command is given).");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"email"));
    }

    protected void checkArguments(String[] args) {
        try {
            CommandLine line = this.parser.parse(this.options, args);
            if (line.hasOption("h")) {
                this.printHelpMessageAndExit(0);
            }
            if (!line.hasOption("command")) {
                System.err.println("No command specified!");
                this.printHelpMessageAndExit(1);
            }
            if (!line.hasOption("vo")) {
                System.err.println("No vo specified!");
                this.printHelpMessageAndExit(1);
            }
            this.command = line.getOptionValue("command");
            if (!(this.command.equals("deploy") || this.command.equals("upgrade") || this.command.equals("add-admin") || this.command.equals("remove-admin") || this.command.equals("undeploy"))) {
                throw new VOMSException("Unknown command specified!");
            }
            this.vo = line.getOptionValue("vo");
            if (line.hasOption("hb-config")) {
                this.hibernateConfigFile = line.getOptionValue("hb-config");
            }
            if (line.hasOption("hb-properties")) {
                this.hibernatePropertiesFile = line.getOptionValue("hb-properties");
            }
            if (line.hasOption("dn")) {
                this.adminDN = line.getOptionValue("dn");
            }
            if (line.hasOption("ca")) {
                this.adminCA = line.getOptionValue("ca");
            }
            if (line.hasOption("email")) {
                this.adminEmailAddress = line.getOptionValue("email");
            }
        }
        catch (ParseException e) {
            throw new VOMSException("Error parsing command-line arguments: " + e.getMessage(), e);
        }
    }

    private void printHelpMessageAndExit(int exitStatus) {
        this.helpFormatter.printHelp("SchemaDeployer", this.options);
        System.exit(exitStatus);
    }

    private int dropTable(String tableName) {
        Session s = HibernateFactory.getSession();
        String command = "drop table " + tableName;
        return s.createSQLQuery(command).executeUpdate();
    }

    private void dropOldTables() {
        String[] dTables = new String[]{"acl_old", "acld", "admins_old", "attributes_old", "ca_old", "capabilities_old", "capabilitiesd", "group_attrs_old", "groups_old", "groupsd", "m_old", "md", "periodicity", "realtime", "requests_old", "role_attrs_old", "roles_old", "rolesd", "seqnumber_old", "sequences", "usr_old", "usr_attrs_old", "usrd", "version_old", "validity"};
        for (int i = 0; i < dTables.length; ++i) {
            this.dropTable(dTables[i]);
        }
    }

    private int dropSequence(String sequenceName) {
        log.debug((Object)("Dropping sequence " + sequenceName));
        Session s = HibernateFactory.getSession();
        String command = "drop sequence " + sequenceName;
        return s.createSQLQuery(command).executeUpdate();
    }

    private void dropOldSequences() {
        log.info((Object)"Dropping old sequences...");
        String[] oldSequences = new String[]{"voms_seq_ca", "voms_seq_transaction", "voms_seq_admin", "voms_seq_acl", "voms_seq_role", "voms_seq_group", "voms_seq_user"};
        for (int i = 0; i < oldSequences.length; ++i) {
            this.dropSequence(oldSequences[i]);
        }
    }

    private int renameTable(String oldName) {
        Session s = HibernateFactory.getSession();
        String command = "alter table " + oldName + " rename to " + oldName + "_old";
        return s.createSQLQuery(command).executeUpdate();
    }

    private void renameOldTables() {
        String[] oldTables = new String[]{"ca", "acl", "admins", "attributes", "capabilities", "group_attrs", "groups", "role_attrs", "roles", "seqnumber", "usr", "usr_attrs", "m", "requests", "version"};
        for (int i = 0; i < oldTables.length; ++i) {
            this.renameTable(oldTables[i]);
        }
    }

    private void fixHibernateSequence() {
        log.info((Object)"Migrating sequences since on oracle backend...");
        Session s = HibernateFactory.getSession();
        Long maxSeqValue = (Long)s.createSQLQuery("select max(last_number) as max from user_sequences where sequence_name like 'VOMS_%'").addScalar("max", (Type)new LongType()).uniqueResult();
        String dropHibSeqStatement = "drop sequence HIBERNATE_SEQUENCE";
        String createHibSeqStatement = "create sequence HIBERNATE_SEQUENCE MINVALUE 1 MAXVALUE 999999999999999999999999999 INCREMENT BY 1 START WITH " + maxSeqValue + " CACHE 20 NOORDER NOCYCLE";
        s.createSQLQuery(dropHibSeqStatement).executeUpdate();
        s.createSQLQuery(createHibSeqStatement).executeUpdate();
        log.info((Object)"Sequences migration complete.");
    }

    private void migrateDbContents() {
        log.info((Object)"Migrating db contents...");
        Session s = HibernateFactory.getSession();
        s.createSQLQuery("insert into ca (cid, ca, cadescr) select cid, ca, cadescr from ca_old").executeUpdate();
        s.createSQLQuery("insert into admins(adminid,dn,ca) select adminid, dn,ca from admins_old").executeUpdate();
        s.createSQLQuery("insert into groups(gid,dn,parent,must) select gid,dn,parent,must from groups_old").executeUpdate();
        s.createSQLQuery("insert into roles(rid,role) select rid, role from roles_old").executeUpdate();
        s.createSQLQuery("insert into usr(userid,dn,ca,cn,mail,cauri) select userid, dn, ca, cn, mail, cauri from usr_old").executeUpdate();
        s.createSQLQuery("insert into version values('2')").executeUpdate();
        s.createSQLQuery("insert into attributes(a_id, a_name, a_desc) select a_id,a_name,a_desc from attributes_old").executeUpdate();
        s.createSQLQuery("insert into usr_attrs(u_id,a_id,a_value) select u_id,a_id,a_value from usr_attrs_old").executeUpdate();
        s.createSQLQuery("insert into group_attrs(g_id,a_id,a_value) select g_id,a_id,a_value from group_attrs_old").executeUpdate();
        s.createSQLQuery("insert into role_attrs(r_id,g_id,a_id,a_value) select r_id, g_id,a_id,a_value from role_attrs_old").executeUpdate();
        s.createSQLQuery("insert into seqnumber(seq) select seq from seqnumber_old").executeUpdate();
    }

    private void migrateMappings() {
        Object[] result;
        Session s = HibernateFactory.getSession();
        List oldMappings = s.createSQLQuery("select userid,gid,rid,cid from m_old").addScalar("userid", (Type)new LongType()).addScalar("gid", (Type)new LongType()).addScalar("rid", (Type)new LongType()).addScalar("cid", (Type)new LongType()).list();
        Iterator i = oldMappings.iterator();
        VOMSUserDAO dao = VOMSUserDAO.instance();
        while (i.hasNext() && (result = (Object[])i.next()) != null) {
            VOMSUser u = dao.findById((Long)result[0]);
            VOMSGroup g = VOMSGroupDAO.instance().findById((Long)result[1]);
            VOMSRole r = null;
            if (result[2] != null) {
                r = VOMSRoleDAO.instance().findById((Long)result[2]);
            }
            log.debug((Object)("Mapping: " + u + "," + g + "," + r));
            if (r == null) {
                if (!u.isMember(g)) {
                    dao.addToGroup(u, g);
                }
            } else {
                if (!u.isMember(g)) {
                    dao.addToGroup(u, g);
                }
                VOMSUserDAO.instance().assignRole(u, g, r);
            }
            s.save((Object)u);
        }
    }

    private void migrateACLs() {
        for (VOMSAdmin a : VOMSAdminDAO.instance().getAll()) {
            List perms;
            long adminId = a.getId();
            if (!a.getDn().equals("/O=VOMS/O=System/CN=Any Authenticated User") && a.getDn().startsWith("/O=VOMS")) continue;
            log.debug((Object)("Migrating acls for admin : " + a.getDn()));
            MultiHashMap m = this.loadDefaultACLEntriesForAdmin(adminId);
            if (m != null) {
                Iterator keys = m.keySet().iterator();
                while (keys.hasNext()) {
                    List perms2 = (List)m.get(keys.next());
                    this.setGlobalPermission(a, ACLMapper.translatePermissions(perms2));
                }
            }
            if ((m = this.loadGroupACLEntriesForAdmin(adminId)) != null) {
                for (Long groupId : m.keySet()) {
                    perms = (List)m.get((Object)groupId);
                    VOMSGroup targetGroup = VOMSGroupDAO.instance().findById(groupId);
                    targetGroup.getACL().setPermissions(a, ACLMapper.translatePermissions(perms));
                }
            }
            if ((m = this.loadRoleACLEntriesForAdmin(adminId)) == null) continue;
            for (Long roleId : m.keySet()) {
                perms = (List)m.get((Object)roleId);
                VOMSRole targetRole = VOMSRoleDAO.instance().findById(roleId);
                this.setPermissionOnRole(a, targetRole, ACLMapper.translatePermissions(perms));
            }
        }
    }

    public static void main(String[] args) throws ConfigurationException {
        if (System.getProperty("GLITE_LOCATION") == null) {
            throw new VOMSException("Please set the GLITE_LOCATION system property before running this utility.");
        }
        if (System.getProperty("GLITE_LOCATION_VAR") == null) {
            throw new VOMSException("Please set the GLITE_LOCATION_VAR system property before running this utility.");
        }
        PropertyConfigurator.configure((String)(System.getProperty("GLITE_LOCATION") + "/share/voms-admin/tools/classes/log4j.properties"));
        new SchemaDeployer(args);
    }

    private MultiHashMap buildACLEntries(List acl) {
        if (acl.isEmpty()) {
            return null;
        }
        MultiHashMap map = new MultiHashMap();
        for (Object[] res : acl) {
            map.put(res[0], res[1]);
        }
        return map;
    }

    private MultiHashMap loadGroupACLEntriesForAdmin(long adminid) {
        Session s = HibernateFactory.getSession();
        String query = "select groups.gid as gid, acl.operation as operation from acl_old acl, groups_old groups where acl.aid = groups.aclid and acl.allow = 1 and adminid = :adminId";
        List acls = s.createSQLQuery(query).addScalar("gid", (Type)new LongType()).addScalar("operation", (Type)new ShortType()).setLong("adminId", adminid).list();
        return this.buildACLEntries(acls);
    }

    private MultiHashMap loadDefaultACLEntriesForAdmin(long adminid) {
        Session s = HibernateFactory.getSession();
        String query = "select -1 as gid, acl.operation as operation from acl_old acl, groups_old groups where acl.aid = 0 and acl.allow = 1 and adminid = :adminId";
        List acls = s.createSQLQuery(query).addScalar("gid", (Type)new LongType()).addScalar("operation", (Type)new ShortType()).setLong("adminId", adminid).list();
        return this.buildACLEntries(acls);
    }

    private MultiHashMap loadRoleACLEntriesForAdmin(long adminid) {
        Session s = HibernateFactory.getSession();
        String query = "select roles.rid as rid, acl.operation as operation from acl_old acl, roles_old roles where acl.aid = roles.aclid and acl.allow = 1 and adminid = :adminId";
        List acls = s.createSQLQuery(query).addScalar("rid", (Type)new LongType()).addScalar("operation", (Type)new ShortType()).setLong("adminId", adminid).list();
        return this.buildACLEntries(acls);
    }

    private void setPermissionOnRole(VOMSAdmin a, VOMSRole r, VOMSPermission p) {
        log.debug((Object)("Setting permissions " + p.getCompactRepresentation() + " for admin " + a.getDn() + " on role " + r.getName()));
        List groups = VOMSGroupDAO.instance().findAll();
        for (VOMSGroup g : groups) {
            ACL roleACL = r.getACL(g);
            if (roleACL == null) {
                roleACL = new ACL(g, r, false);
                roleACL.setPermissions(a, p);
                r.getAcls().add(roleACL);
                continue;
            }
            roleACL.setPermissions(a, p);
        }
    }

    private void setGlobalPermission(VOMSAdmin a, VOMSPermission p) {
        log.debug((Object)("Setting global permissions " + p.getCompactRepresentation() + " for admin " + a.getDn()));
        List groups = VOMSGroupDAO.instance().findAll();
        List roles = VOMSRoleDAO.instance().getAll();
        for (VOMSGroup g : groups) {
            ACL acl = g.getACL();
            if (acl == null) {
                acl = new ACL(g, false);
                acl.setPermissions(a, p);
                g.getAcls().add(acl);
            } else {
                acl.setPermissions(a, p);
            }
            for (VOMSRole r : roles) {
                ACL roleACL = r.getACL(g);
                if (roleACL == null) {
                    roleACL = new ACL(g, r, false);
                    roleACL.setPermissions(a, p);
                    r.getAcls().add(roleACL);
                    continue;
                }
                roleACL.setPermissions(a, p);
            }
        }
    }
}

