/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.h2geodb;

import org.hibernate.HibernateException;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.spatial.GeometrySqlTypeDescriptor;
import org.hibernate.spatial.GeometryType;
import org.hibernate.spatial.SpatialDialect;
import org.hibernate.spatial.SpatialFunction;
import org.hibernate.spatial.dialect.h2geodb.GeoDBGeometryTypeDescriptor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class GeoDBDialect
extends H2Dialect
implements SpatialDialect {
    public GeoDBDialect() {
        this.registerColumnType(2003, "BLOB");
        this.registerFunction("geometrytype", (SQLFunction)new StandardSQLFunction("GeometryType", (Type)StandardBasicTypes.STRING));
        this.registerFunction("srid", (SQLFunction)new StandardSQLFunction("ST_SRID", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("envelope", (SQLFunction)new StandardSQLFunction("ST_Envelope", (Type)GeometryType.INSTANCE));
        this.registerFunction("astext", (SQLFunction)new StandardSQLFunction("ST_AsText", (Type)StandardBasicTypes.STRING));
        this.registerFunction("asbinary", (SQLFunction)new StandardSQLFunction("ST_AsEWKB", (Type)StandardBasicTypes.BINARY));
        this.registerFunction("isempty", (SQLFunction)new StandardSQLFunction("ST_IsEmpty", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("issimple", (SQLFunction)new StandardSQLFunction("ST_IsSimple", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("overlaps", (SQLFunction)new StandardSQLFunction("ST_Overlaps", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("intersects", (SQLFunction)new StandardSQLFunction("ST_Intersects", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("equals", (SQLFunction)new StandardSQLFunction("ST_Equals", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("contains", (SQLFunction)new StandardSQLFunction("ST_Contains", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("crosses", (SQLFunction)new StandardSQLFunction("ST_Crosses", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("disjoint", (SQLFunction)new StandardSQLFunction("ST_Disjoint", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("touches", (SQLFunction)new StandardSQLFunction("ST_Touches", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("within", (SQLFunction)new StandardSQLFunction("ST_Within", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("distance", (SQLFunction)new StandardSQLFunction("ST_Distance", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("buffer", (SQLFunction)new StandardSQLFunction("ST_Buffer", (Type)GeometryType.INSTANCE));
        this.registerFunction("dwithin", (SQLFunction)new StandardSQLFunction("ST_DWithin", (Type)StandardBasicTypes.BOOLEAN));
    }

    public String getTypeName(int code, long length, int precision, int scale) throws HibernateException {
        if (code == 3000) {
            return "GEOMETRY";
        }
        return super.getTypeName(code, length, precision, scale);
    }

    public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
        if (sqlTypeDescriptor instanceof GeometrySqlTypeDescriptor) {
            return GeoDBGeometryTypeDescriptor.INSTANCE;
        }
        return super.remapSqlTypeDescriptor(sqlTypeDescriptor);
    }

    @Override
    public String getSpatialAggregateSQL(String columnName, int aggregation) {
        switch (aggregation) {
            default: 
        }
        throw new IllegalArgumentException("Aggregations of type " + aggregation + " are not supported by this dialect");
    }

    @Override
    public String getDWithinSQL(String columnName) {
        return "ST_DWithin(" + columnName + ",?,?)";
    }

    @Override
    public String getHavingSridSQL(String columnName) {
        return "( ST_srid(" + columnName + ") = ?)";
    }

    @Override
    public String getIsEmptySQL(String columnName, boolean isEmpty) {
        String emptyExpr = " ST_IsEmpty(" + columnName + ") ";
        return isEmpty ? emptyExpr : "( NOT " + emptyExpr + ")";
    }

    @Override
    public String getSpatialFilterExpression(String columnName) {
        return "(" + columnName + " && ? ) ";
    }

    @Override
    public String getSpatialRelateSQL(String columnName, int spatialRelation) {
        switch (spatialRelation) {
            case 4: {
                return " ST_Within(" + columnName + ", ?)";
            }
            case 6: {
                return " ST_Contains(" + columnName + ", ?)";
            }
            case 3: {
                return " ST_Crosses(" + columnName + ", ?)";
            }
            case 5: {
                return " ST_Overlaps(" + columnName + ", ?)";
            }
            case 1: {
                return " ST_Disjoint(" + columnName + ", ?)";
            }
            case 7: {
                return " ST_Intersects(" + columnName + ", ?)";
            }
            case 2: {
                return " ST_Touches(" + columnName + ", ?)";
            }
            case 0: {
                return " ST_Equals(" + columnName + ", ?)";
            }
        }
        throw new IllegalArgumentException("Spatial relation is not known by this dialect");
    }

    public String getDbGeometryTypeName() {
        return "GEOM";
    }

    public boolean isTwoPhaseFiltering() {
        return false;
    }

    @Override
    public boolean supportsFiltering() {
        return false;
    }

    @Override
    public boolean supports(SpatialFunction function) {
        if (function == SpatialFunction.difference) {
            return false;
        }
        return this.getFunctions().get(function.toString()) != null;
    }
}

