/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.h2geodb;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;

class WKB {
    WKB() {
    }

    static Geometry fromWKB(byte[] bytes, GeometryFactory factory) throws ParseException {
        WKBReader reader = new WKBReader(factory);
        return reader.read(bytes);
    }

    static Geometry fromEWKB(byte[] bytes, GeometryFactory factory) throws ParseException {
        byte[] wkbBytes = new byte[bytes.length - 32];
        System.arraycopy(bytes, 32, wkbBytes, 0, bytes.length - 32);
        return WKB.fromWKB(wkbBytes, factory);
    }

    static byte[] toWKB(Geometry jtsGeom) {
        WKBWriter writer = new WKBWriter(2, true);
        return writer.write(jtsGeom);
    }
}

