/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.spatial.dialect.oracle.ConnectionFinder;
import org.hibernate.spatial.dialect.oracle.DefaultConnectionFinder;
import org.hibernate.spatial.dialect.oracle.ElemInfo;
import org.hibernate.spatial.dialect.oracle.Ordinates;
import org.hibernate.spatial.dialect.oracle.SDOGeometry;
import org.hibernate.spatial.dialect.oracle.SQLTypeFactory;
import org.hibernate.spatial.helper.FinderException;

public class OracleJDBCTypeFactory
implements SQLTypeFactory {
    private static Class<?> datumClass;
    private static Class<?> numberClass;
    private static Class<?> arrayClass;
    private static Class<?> structClass;
    private static Class<?> arrayDescriptorClass;
    private static Class<?> structDescriptorClass;
    private static Method structDescriptorCreator;
    private static Method arrayDescriptorCreator;
    private static Constructor<?> numberConstructor;
    private static Constructor<?> arrayConstructor;
    private static Constructor<?> structConstructor;
    private static ConnectionFinder connectionFinder;

    private static Constructor<?> findConstructor(Class clazz, Class<?> ... arguments) {
        try {
            return clazz.getConstructor(arguments);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException("Error finding constructor for oracle.sql type.", (Throwable)e);
        }
    }

    private static Class<?> findClass(String name) {
        try {
            return ReflectHelper.classForName((String)name);
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("Class 'oracle.sql.Datum' not found on class path");
        }
    }

    private static Object[] findDescriptorCreator(String className) {
        try {
            Class clazz = ReflectHelper.classForName((String)className);
            Method m = clazz.getMethod("createDescriptor", String.class, Connection.class);
            return new Object[]{clazz, m};
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("Class 'StructDescriptor' not found on classpath");
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException("Class 'StructDescriptor' has no method 'createDescriptor(String,Connection)'");
        }
    }

    static ConnectionFinder getConnectionFinder() {
        return connectionFinder;
    }

    static void setConnectionFinder(ConnectionFinder finder) {
        connectionFinder = finder;
    }

    @Override
    public Struct createStruct(SDOGeometry geom, Connection conn) throws SQLException {
        Connection oracleConnection = null;
        try {
            oracleConnection = (Connection)connectionFinder.find(conn);
        }
        catch (FinderException e) {
            throw new HibernateException("Problem finding Oracle Connection", (Throwable)e);
        }
        Object structDescriptor = this.createStructDescriptor(SDOGeometry.getTypeName(), oracleConnection);
        Object[] attributes = this.createDatumArray(5);
        attributes[0] = this.createNumber(geom.getGType().intValue());
        attributes[1] = geom.getSRID() > 0 ? this.createNumber(geom.getSRID()) : null;
        attributes[3] = this.createElemInfoArray(geom.getInfo(), oracleConnection);
        attributes[4] = this.createOrdinatesArray(geom.getOrdinates(), oracleConnection);
        return this.createStruct(structDescriptor, oracleConnection, attributes);
    }

    @Override
    public java.sql.Array createElemInfoArray(ElemInfo elemInfo, Connection conn) {
        Object arrayDescriptor = this.createArrayDescriptor("MDSYS.SDO_ELEM_INFO_ARRAY", conn);
        return this.createArray(arrayDescriptor, conn, elemInfo.getElements());
    }

    @Override
    public java.sql.Array createOrdinatesArray(Ordinates ordinates, Connection conn) throws SQLException {
        Object arrayDescriptor = this.createArrayDescriptor("MDSYS.SDO_ORDINATE_ARRAY", conn);
        return this.createArray(arrayDescriptor, conn, ordinates.getOrdinateArray());
    }

    private java.sql.Array createArray(Object descriptor, Connection conn, Object[] data) {
        try {
            return (java.sql.Array)arrayConstructor.newInstance(descriptor, conn, data);
        }
        catch (InstantiationException e) {
            throw new HibernateException("Problem creating ARRAY.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("Problem creating ARRAY.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new HibernateException("Problem creating ARRAY.", (Throwable)e);
        }
    }

    private Struct createStruct(Object descriptor, Connection conn, Object[] attributes) {
        try {
            return (Struct)structConstructor.newInstance(descriptor, conn, attributes);
        }
        catch (InstantiationException e) {
            throw new HibernateException("Problem creating STRUCT.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("Problem creating STRUCT.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new HibernateException("Problem creating STRUCT.", (Throwable)e);
        }
    }

    private Object createStructDescriptor(String sqlType, Connection conn) {
        try {
            return structDescriptorCreator.invoke(null, sqlType, conn);
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("Error creating oracle STRUCT", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new HibernateException("Error creating oracle STRUCT", (Throwable)e);
        }
    }

    private Object createArrayDescriptor(String name, Connection conn) {
        try {
            return arrayDescriptorCreator.invoke(null, name, conn);
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("Error creating oracle ARRAY", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new HibernateException("Error creating oracle ARRAY", (Throwable)e);
        }
    }

    private Object[] createDatumArray(int size) {
        return (Object[])Array.newInstance(datumClass, size);
    }

    private Object createNumber(int obj) {
        try {
            return numberConstructor.newInstance(obj);
        }
        catch (InvocationTargetException e) {
            throw new HibernateException("Error creating oracle NUMBER", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new HibernateException("Error creating oracle NUMBER", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("Error creating oracle NUMBER", (Throwable)e);
        }
    }

    static {
        Object[] obj = OracleJDBCTypeFactory.findDescriptorCreator("oracle.sql.StructDescriptor");
        structDescriptorClass = (Class)obj[0];
        structDescriptorCreator = (Method)obj[1];
        obj = OracleJDBCTypeFactory.findDescriptorCreator("oracle.sql.ArrayDescriptor");
        arrayDescriptorClass = (Class)obj[0];
        arrayDescriptorCreator = (Method)obj[1];
        datumClass = OracleJDBCTypeFactory.findClass("oracle.sql.Datum");
        numberClass = OracleJDBCTypeFactory.findClass("oracle.sql.NUMBER");
        arrayClass = OracleJDBCTypeFactory.findClass("oracle.sql.ARRAY");
        structClass = OracleJDBCTypeFactory.findClass("oracle.sql.STRUCT");
        numberConstructor = OracleJDBCTypeFactory.findConstructor(numberClass, Integer.TYPE);
        arrayConstructor = OracleJDBCTypeFactory.findConstructor(arrayClass, arrayDescriptorClass, Connection.class, Object.class);
        structConstructor = OracleJDBCTypeFactory.findConstructor(structClass, structDescriptorClass, Connection.class, Object[].class);
        connectionFinder = new DefaultConnectionFinder();
    }
}

