/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import org.hibernate.spatial.dialect.oracle.ElemInfo;
import org.hibernate.spatial.dialect.oracle.ElementType;
import org.hibernate.spatial.dialect.oracle.OracleJDBCTypeFactory;
import org.hibernate.spatial.dialect.oracle.Ordinates;
import org.hibernate.spatial.dialect.oracle.SDOGType;
import org.hibernate.spatial.dialect.oracle.SDOPoint;
import org.hibernate.spatial.dialect.oracle.SQLTypeFactory;
import org.hibernate.spatial.dialect.oracle.TypeGeometry;
import org.hibernate.spatial.helper.FinderException;

class SDOGeometry {
    private static final SQLTypeFactory TYPE_FACTORY = new OracleJDBCTypeFactory();
    private static final String SQL_TYPE_NAME = "MDSYS.SDO_GEOMETRY";
    private SDOGType gtype;
    private int srid;
    private SDOPoint point;
    private ElemInfo info;
    private Ordinates ordinates;

    public static String getTypeName() {
        return SQL_TYPE_NAME;
    }

    static String arrayToString(Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return "()";
        }
        int length = Array.getLength(array);
        StringBuilder stb = new StringBuilder();
        stb.append("(").append(Array.get(array, 0));
        for (int i = 1; i < length; ++i) {
            stb.append(",").append(Array.get(array, i));
        }
        stb.append(")");
        return stb.toString();
    }

    public static SDOGeometry join(SDOGeometry[] SDOElements) {
        SDOGeometry SDOCollection = new SDOGeometry();
        if (SDOElements == null || SDOElements.length == 0) {
            SDOCollection.setGType(new SDOGType(2, 0, TypeGeometry.COLLECTION));
        } else {
            SDOGeometry firstElement = SDOElements[0];
            int dim = firstElement.getGType().getDimension();
            int lrsDim = firstElement.getGType().getLRSDimension();
            SDOCollection.setGType(new SDOGType(dim, lrsDim, TypeGeometry.COLLECTION));
            int ordinatesOffset = 1;
            for (int i = 0; i < SDOElements.length; ++i) {
                ElemInfo element = SDOElements[i].getInfo();
                Double[] ordinates = SDOElements[i].getOrdinates().getOrdinateArray();
                if (element == null || element.getSize() <= 0) continue;
                int shift = ordinatesOffset - element.getOrdinatesOffset(0);
                SDOGeometry.shiftOrdinateOffset(element, shift);
                SDOCollection.addElement(element);
                SDOCollection.addOrdinates(ordinates);
                ordinatesOffset += ordinates.length;
            }
        }
        return SDOCollection;
    }

    public ElemInfo getInfo() {
        return this.info;
    }

    public void setInfo(ElemInfo info) {
        this.info = info;
    }

    public SDOGType getGType() {
        return this.gtype;
    }

    public void setGType(SDOGType gtype) {
        this.gtype = gtype;
    }

    public Ordinates getOrdinates() {
        return this.ordinates;
    }

    public void setOrdinates(Ordinates ordinates) {
        this.ordinates = ordinates;
    }

    public SDOPoint getPoint() {
        return this.point;
    }

    public void setPoint(SDOPoint point) {
        this.point = point;
    }

    public int getSRID() {
        return this.srid;
    }

    public void setSRID(int srid) {
        this.srid = srid;
    }

    public static SDOGeometry load(Struct struct) {
        Object[] data;
        try {
            data = struct.getAttributes();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        SDOGeometry geom = new SDOGeometry();
        geom.setGType(SDOGType.parse(data[0]));
        geom.setSRID(data[1]);
        if (data[2] != null) {
            geom.setPoint(new SDOPoint((Struct)data[2]));
        }
        geom.setInfo(new ElemInfo((java.sql.Array)data[3]));
        geom.setOrdinates(new Ordinates((java.sql.Array)data[4]));
        return geom;
    }

    public static Struct store(SDOGeometry geom, Connection conn) throws SQLException, FinderException {
        return TYPE_FACTORY.createStruct(geom, conn);
    }

    private void setSRID(Object datum) {
        if (datum == null) {
            this.srid = 0;
            return;
        }
        try {
            this.srid = new Integer(((Number)datum).intValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isLRSGeometry() {
        return this.gtype.isLRSGeometry();
    }

    public int getDimension() {
        return this.gtype.getDimension();
    }

    public int getLRSDimension() {
        return this.gtype.getLRSDimension();
    }

    public int getZDimension() {
        return this.gtype.getZDimension();
    }

    public int getNumElements() {
        int cnt = 0;
        int i = 0;
        while (i < this.info.getSize()) {
            if (this.info.getElementType(i).isCompound()) {
                int numCompounds = this.info.getNumCompounds(i);
                i += 1 + numCompounds;
            } else {
                ++i;
            }
            ++cnt;
        }
        return cnt;
    }

    public String toString() {
        StringBuilder stb = new StringBuilder();
        stb.append("(").append(this.gtype).append(",").append(this.srid).append(",").append(this.point).append(",").append(this.info).append(",").append(this.ordinates).append(")");
        return stb.toString();
    }

    public void addOrdinates(Double[] newOrdinates) {
        if (this.ordinates == null) {
            this.ordinates = new Ordinates(newOrdinates);
        } else {
            this.ordinates.addOrdinates(newOrdinates);
        }
    }

    public void addElement(ElemInfo element) {
        if (this.info == null) {
            this.info = element;
        } else {
            this.info.addElement(element);
        }
    }

    public SDOGeometry[] getElementGeometries() {
        if (this.getGType().getTypeGeometry() == TypeGeometry.COLLECTION) {
            ArrayList<SDOGeometry> elements = new ArrayList<SDOGeometry>();
            int i = 0;
            while (i < this.getNumElements()) {
                int next;
                ElementType et = this.getInfo().getElementType(i);
                if (et.isExteriorRing()) {
                    for (next = i + 1; next < this.getNumElements() && this.getInfo().getElementType(next).isInteriorRing(); ++next) {
                    }
                } else if (et.isCompound()) {
                    next = i + this.getInfo().getNumCompounds(i) + 1;
                }
                SDOGeometry elemGeom = new SDOGeometry();
                SDOGType elemGtype = SDOGeometry.deriveGTYPE(this.getInfo().getElementType(i), this);
                elemGeom.setGType(elemGtype);
                elemGeom.setSRID(this.getSRID());
                ElemInfo elemInfo = new ElemInfo(this.getInfo().getElement(i));
                SDOGeometry.shiftOrdinateOffset(elemInfo, -elemInfo.getOrdinatesOffset(0) + 1);
                elemGeom.setInfo(elemInfo);
                int startPosition = this.getInfo().getOrdinatesOffset(i);
                Ordinates elemOrdinates = null;
                if (next < this.getNumElements()) {
                    int endPosition = this.getInfo().getOrdinatesOffset(next);
                    elemOrdinates = new Ordinates(this.getOrdinates().getOrdinatesArray(startPosition, endPosition));
                } else {
                    elemOrdinates = new Ordinates(this.getOrdinates().getOrdinatesArray(startPosition));
                }
                elemGeom.setOrdinates(elemOrdinates);
                elements.add(elemGeom);
                i = next;
            }
            return elements.toArray(new SDOGeometry[elements.size()]);
        }
        return new SDOGeometry[]{this};
    }

    private static void shiftOrdinateOffset(ElemInfo elemInfo, int offset) {
        for (int i = 0; i < elemInfo.getSize(); ++i) {
            int newOffset = elemInfo.getOrdinatesOffset(i) + offset;
            elemInfo.setOrdinatesOffset(i, newOffset);
        }
    }

    private static SDOGType deriveGTYPE(ElementType elementType, SDOGeometry origGeom) {
        switch (elementType) {
            case POINT: 
            case ORIENTATION: {
                return new SDOGType(origGeom.getDimension(), origGeom.getLRSDimension(), TypeGeometry.POINT);
            }
            case POINT_CLUSTER: {
                return new SDOGType(origGeom.getDimension(), origGeom.getLRSDimension(), TypeGeometry.MULTIPOINT);
            }
            case LINE_ARC_SEGMENTS: 
            case LINE_STRAITH_SEGMENTS: 
            case COMPOUND_LINE: {
                return new SDOGType(origGeom.getDimension(), origGeom.getLRSDimension(), TypeGeometry.LINE);
            }
            case COMPOUND_EXTERIOR_RING: 
            case EXTERIOR_RING_ARC_SEGMENTS: 
            case EXTERIOR_RING_CIRCLE: 
            case EXTERIOR_RING_RECT: 
            case EXTERIOR_RING_STRAIGHT_SEGMENTS: {
                return new SDOGType(origGeom.getDimension(), origGeom.getLRSDimension(), TypeGeometry.POLYGON);
            }
        }
        return null;
    }
}

