/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.postgis;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Polygon;
import java.sql.SQLException;
import org.hibernate.spatial.dialect.AbstractJTSGeometryValueExtractor;
import org.hibernate.spatial.jts.mgeom.MCoordinate;
import org.hibernate.spatial.jts.mgeom.MLineString;
import org.hibernate.spatial.jts.mgeom.MultiMLineString;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.MultiPolygon;
import org.postgis.PGbox2d;
import org.postgis.PGboxbase;
import org.postgis.PGgeometry;
import org.postgis.Point;
import org.postgresql.util.PGobject;

public class PGGeometryValueExtractor
extends AbstractJTSGeometryValueExtractor {
    @Override
    public com.vividsolutions.jts.geom.Geometry toJTS(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Geometry) {
            object = new PGgeometry((Geometry)object);
        }
        if (object instanceof PGobject && ((PGobject)object).getType().equals("geography")) {
            try {
                PGgeometry g = new PGgeometry(((PGobject)object).getValue());
                object = g;
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (object instanceof PGgeometry) {
            PGgeometry geom = (PGgeometry)object;
            com.vividsolutions.jts.geom.Point out = null;
            switch (geom.getGeoType()) {
                case 1: {
                    out = this.convertPoint((Point)geom.getGeometry());
                    break;
                }
                case 2: {
                    out = this.convertLineString((LineString)geom.getGeometry());
                    break;
                }
                case 3: {
                    out = this.convertPolygon((org.postgis.Polygon)geom.getGeometry());
                    break;
                }
                case 5: {
                    out = this.convertMultiLineString((MultiLineString)geom.getGeometry());
                    break;
                }
                case 4: {
                    out = this.convertMultiPoint((org.postgis.MultiPoint)geom.getGeometry());
                    break;
                }
                case 6: {
                    out = this.convertMultiPolygon((MultiPolygon)geom.getGeometry());
                    break;
                }
                case 7: {
                    out = this.convertGeometryCollection((org.postgis.GeometryCollection)geom.getGeometry());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown type of PGgeometry");
                }
            }
            out.setSRID(geom.getGeometry().srid);
            return out;
        }
        if (object instanceof PGboxbase) {
            return this.convertBox((PGboxbase)object);
        }
        throw new IllegalArgumentException("Can't convert object of type " + object.getClass().getCanonicalName());
    }

    private com.vividsolutions.jts.geom.Geometry convertBox(PGboxbase box) {
        Point ll = box.getLLB();
        Point ur = box.getURT();
        Coordinate[] ringCoords = new Coordinate[5];
        if (box instanceof PGbox2d) {
            ringCoords[0] = new Coordinate(ll.x, ll.y);
            ringCoords[1] = new Coordinate(ur.x, ll.y);
            ringCoords[2] = new Coordinate(ur.x, ur.y);
            ringCoords[3] = new Coordinate(ll.x, ur.y);
            ringCoords[4] = new Coordinate(ll.x, ll.y);
        } else {
            ringCoords[0] = new Coordinate(ll.x, ll.y, ll.z);
            ringCoords[1] = new Coordinate(ur.x, ll.y, ll.z);
            ringCoords[2] = new Coordinate(ur.x, ur.y, ur.z);
            ringCoords[3] = new Coordinate(ll.x, ur.y, ur.z);
            ringCoords[4] = new Coordinate(ll.x, ll.y, ll.z);
        }
        LinearRing shell = this.getGeometryFactory().createLinearRing(ringCoords);
        return this.getGeometryFactory().createPolygon(shell, null);
    }

    private com.vividsolutions.jts.geom.Geometry convertGeometryCollection(org.postgis.GeometryCollection collection) {
        Geometry[] geometries = collection.getGeometries();
        com.vividsolutions.jts.geom.Geometry[] jtsGeometries = new com.vividsolutions.jts.geom.Geometry[geometries.length];
        for (int i = 0; i < geometries.length; ++i) {
            jtsGeometries[i] = this.toJTS(geometries[i]);
            jtsGeometries[i].setSRID(0);
        }
        GeometryCollection jtsGCollection = this.getGeometryFactory().createGeometryCollection(jtsGeometries);
        return jtsGCollection;
    }

    private com.vividsolutions.jts.geom.Geometry convertMultiPolygon(MultiPolygon pgMultiPolygon) {
        Polygon[] polygons = new Polygon[pgMultiPolygon.numPolygons()];
        for (int i = 0; i < polygons.length; ++i) {
            org.postgis.Polygon pgPolygon = pgMultiPolygon.getPolygon(i);
            polygons[i] = (Polygon)this.convertPolygon(pgPolygon);
        }
        com.vividsolutions.jts.geom.MultiPolygon out = this.getGeometryFactory().createMultiPolygon(polygons);
        return out;
    }

    private com.vividsolutions.jts.geom.Geometry convertMultiPoint(org.postgis.MultiPoint pgMultiPoint) {
        com.vividsolutions.jts.geom.Point[] points = new com.vividsolutions.jts.geom.Point[pgMultiPoint.numPoints()];
        for (int i = 0; i < points.length; ++i) {
            points[i] = this.convertPoint(pgMultiPoint.getPoint(i));
        }
        MultiPoint out = this.getGeometryFactory().createMultiPoint(points);
        out.setSRID(pgMultiPoint.srid);
        return out;
    }

    private com.vividsolutions.jts.geom.Geometry convertMultiLineString(MultiLineString mlstr) {
        MultiMLineString out;
        if (mlstr.haveMeasure) {
            MLineString[] lstrs = new MLineString[mlstr.numLines()];
            for (int i = 0; i < mlstr.numLines(); ++i) {
                MCoordinate[] coordinates = this.toJTSCoordinates(mlstr.getLine(i).getPoints());
                lstrs[i] = this.getGeometryFactory().createMLineString(coordinates);
            }
            out = this.getGeometryFactory().createMultiMLineString(lstrs);
        } else {
            com.vividsolutions.jts.geom.LineString[] lstrs = new com.vividsolutions.jts.geom.LineString[mlstr.numLines()];
            for (int i = 0; i < mlstr.numLines(); ++i) {
                lstrs[i] = this.getGeometryFactory().createLineString(this.toJTSCoordinates(mlstr.getLine(i).getPoints()));
            }
            out = this.getGeometryFactory().createMultiLineString(lstrs);
        }
        return out;
    }

    private com.vividsolutions.jts.geom.Geometry convertPolygon(org.postgis.Polygon polygon) {
        LinearRing shell = this.getGeometryFactory().createLinearRing(this.toJTSCoordinates(polygon.getRing(0).getPoints()));
        Polygon out = null;
        if (polygon.numRings() > 1) {
            LinearRing[] rings = new LinearRing[polygon.numRings() - 1];
            for (int r = 1; r < polygon.numRings(); ++r) {
                rings[r - 1] = this.getGeometryFactory().createLinearRing(this.toJTSCoordinates(polygon.getRing(r).getPoints()));
            }
            out = this.getGeometryFactory().createPolygon(shell, rings);
        } else {
            out = this.getGeometryFactory().createPolygon(shell, null);
        }
        return out;
    }

    private com.vividsolutions.jts.geom.Point convertPoint(Point pnt) {
        com.vividsolutions.jts.geom.Point g = this.getGeometryFactory().createPoint(this.toJTSCoordinate(pnt));
        return g;
    }

    private com.vividsolutions.jts.geom.LineString convertLineString(LineString lstr) {
        MLineString out = lstr.haveMeasure ? this.getGeometryFactory().createMLineString(this.toJTSCoordinates(lstr.getPoints())) : this.getGeometryFactory().createLineString(this.toJTSCoordinates(lstr.getPoints()));
        return out;
    }

    private MCoordinate[] toJTSCoordinates(Point[] points) {
        MCoordinate[] coordinates = new MCoordinate[points.length];
        for (int i = 0; i < points.length; ++i) {
            coordinates[i] = this.toJTSCoordinate(points[i]);
        }
        return coordinates;
    }

    private MCoordinate toJTSCoordinate(Point pt) {
        MCoordinate mc = pt.dimension == 2 ? (pt.haveMeasure ? MCoordinate.create2dWithMeasure(pt.getX(), pt.getY(), pt.getM()) : MCoordinate.create2d(pt.getX(), pt.getY())) : (pt.haveMeasure ? MCoordinate.create3dWithMeasure(pt.getX(), pt.getY(), pt.getZ(), pt.getM()) : MCoordinate.create3d(pt.getX(), pt.getY(), pt.getZ()));
        return mc;
    }
}

