/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver.convertors;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import org.hibernate.spatial.dialect.sqlserver.convertors.AbstractDecoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.IndexRange;
import org.hibernate.spatial.dialect.sqlserver.convertors.OpenGisType;
import org.hibernate.spatial.dialect.sqlserver.convertors.SqlServerGeometry;
import org.hibernate.spatial.jts.mgeom.MCoordinate;
import org.hibernate.spatial.jts.mgeom.MGeometryFactory;

class LineStringDecoder
extends AbstractDecoder<LineString> {
    public LineStringDecoder(MGeometryFactory factory) {
        super(factory);
    }

    @Override
    protected OpenGisType getOpenGisType() {
        return OpenGisType.LINESTRING;
    }

    @Override
    protected LineString createNullGeometry() {
        return this.getGeometryFactory().createLineString(null);
    }

    @Override
    protected LineString createGeometry(SqlServerGeometry nativeGeom) {
        return this.createLineString(nativeGeom, new IndexRange(0, nativeGeom.getNumPoints()));
    }

    @Override
    protected LineString createGeometry(SqlServerGeometry nativeGeom, int shapeIndex) {
        if (nativeGeom.isEmptyShape(shapeIndex)) {
            return this.createNullGeometry();
        }
        int figureOffset = nativeGeom.getFiguresForShape((int)shapeIndex).start;
        IndexRange pntIndexRange = nativeGeom.getPointsForFigure(figureOffset);
        return this.createLineString(nativeGeom, pntIndexRange);
    }

    protected LineString createLineString(SqlServerGeometry nativeGeom, IndexRange pntIndexRange) {
        Coordinate[] coordinates = nativeGeom.coordinateRange(pntIndexRange);
        return this.createLineString(coordinates, nativeGeom.hasMValues());
    }

    private LineString createLineString(Coordinate[] coords, boolean hasM) {
        if (hasM) {
            return this.getGeometryFactory().createMLineString((MCoordinate[])coords);
        }
        return this.getGeometryFactory().createLineString(coords);
    }
}

