/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.integration;

import java.lang.reflect.Field;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.spatial.GeometryType;
import org.hibernate.type.BasicType;
import org.hibernate.type.TypeResolver;

public class SpatialIntegrator
implements Integrator {
    private static final String UNLOCK_ERROR_MSG = "SpatialIntegrator failed to unlock BasicTypeRegistry";

    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.addType(sessionFactory.getTypeResolver());
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.addType(metadata.getTypeResolver());
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    private void addType(TypeResolver typeResolver) {
        this.unlock(typeResolver);
        typeResolver.registerTypeOverride((BasicType)GeometryType.INSTANCE);
        this.lock(typeResolver);
    }

    private void lock(TypeResolver typeResolver) {
        this.setLocked(typeResolver, true);
    }

    private void unlock(TypeResolver typeResolver) {
        this.setLocked(typeResolver, false);
    }

    private void setLocked(TypeResolver typeResolver, boolean locked) {
        try {
            Field registryFld = typeResolver.getClass().getDeclaredField("basicTypeRegistry");
            registryFld.setAccessible(true);
            Object registry = registryFld.get(typeResolver);
            Field lockedFld = registry.getClass().getDeclaredField("locked");
            lockedFld.setAccessible(true);
            lockedFld.setBoolean(registry, locked);
            lockedFld.setAccessible(false);
            registryFld.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(UNLOCK_ERROR_MSG, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(UNLOCK_ERROR_MSG, e);
        }
    }
}

