/*
 * Decompiled with CFR 0.152.
 */
package org.hibernatespatial.pojo;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernatespatial.pojo.ColumnMetaData;
import org.hibernatespatial.pojo.PKeyNotFoundException;
import org.hibernatespatial.pojo.TableNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMetaData {
    private String name;
    private List<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableMetaData load(String tableName, DatabaseMetaData dmd) throws SQLException, TableNotFoundException {
        ResultSet rs = null;
        try {
            rs = dmd.getColumns(null, null, tableName, null);
            TableMetaData tmd = new TableMetaData();
            boolean isLoaded = false;
            while (rs.next()) {
                if (tmd.getName() == null) {
                    tmd.setName((String)rs.getObject("TABLE_NAME"));
                }
                ColumnMetaData column = new ColumnMetaData();
                column.setName(rs.getString("COLUMN_NAME"));
                column.setDbType(rs.getString("TYPE_NAME"));
                column.setJavaType(rs.getInt("DATA_TYPE"));
                tmd.addColumn(column);
                isLoaded = true;
            }
            rs.close();
            if (!isLoaded) {
                throw new TableNotFoundException(tableName);
            }
            rs = dmd.getPrimaryKeys(null, null, tableName);
            boolean hasPkey = rs.next();
            if (hasPkey) {
                String pkn = rs.getString("COLUMN_NAME");
                for (ColumnMetaData c : tmd.getColumns()) {
                    if (!c.getName().equals(pkn)) continue;
                    c.setPkey(true);
                    break;
                }
            }
            TableMetaData tableMetaData = tmd;
            return tableMetaData;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {}
        }
    }

    public List<ColumnMetaData> getColumns() {
        return this.columns;
    }

    private void addColumn(ColumnMetaData column) {
        this.columns.add(column);
    }

    public ColumnMetaData getPrimaryKeyColumn() throws PKeyNotFoundException {
        for (ColumnMetaData c : this.getColumns()) {
            if (!c.isPkey()) continue;
            return c;
        }
        throw new PKeyNotFoundException(this.getName());
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }
}

