/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.algorithm.annotation;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import org.n52.wps.algorithm.annotation.Algorithm;
import org.n52.wps.algorithm.annotation.AnnotationBinding;
import org.n52.wps.algorithm.annotation.AnnotationParser;
import org.n52.wps.algorithm.descriptor.AlgorithmDescriptor;
import org.n52.wps.algorithm.descriptor.InputDescriptor;
import org.n52.wps.algorithm.descriptor.OutputDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedAlgorithmIntrospector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotatedAlgorithmIntrospector.class);
    private static final List<AnnotationParser.InputAnnotationParser<?, Field, ?>> INPUT_FIELD_PARSERS;
    private static final List<AnnotationParser.InputAnnotationParser<?, Method, ?>> INPUT_METHOD_PARSERS;
    private static final List<AnnotationParser.OutputAnnotationParser<?, Field, ?>> OUTPUT_FIELD_PARSERS;
    private static final List<AnnotationParser.OutputAnnotationParser<?, Method, ?>> OUTPUT_METHOD_PARSERS;
    private static final AnnotationParser.ExecuteAnnotationParser PROCESS_PARSER;
    private static final Map<Class<?>, AnnotatedAlgorithmIntrospector> INTROSPECTOR_MAP;
    private Class<?> algorithmClass;
    private AlgorithmDescriptor algorithmDescriptor;
    private AnnotationBinding.ExecuteMethodBinding executeMethodBinding;
    private Map<String, AnnotationBinding.InputBinding<?, ?>> inputBindingMap;
    private Map<String, AnnotationBinding.OutputBinding<?, ?>> outputBindingMap;

    static {
        ArrayList<AnnotationParser.InputAnnotationParser> inputFieldParsers = new ArrayList<AnnotationParser.InputAnnotationParser>();
        inputFieldParsers.add(new AnnotationParser.LiteralDataInputFieldAnnotationParser());
        inputFieldParsers.add(new AnnotationParser.ComplexDataInputFieldAnnotationParser());
        INPUT_FIELD_PARSERS = Collections.unmodifiableList(inputFieldParsers);
        ArrayList<AnnotationParser.InputAnnotationParser> inputMethodParsers = new ArrayList<AnnotationParser.InputAnnotationParser>();
        inputMethodParsers.add(new AnnotationParser.LiteralDataInputMethodAnnotationParser());
        inputMethodParsers.add(new AnnotationParser.ComplexDataInputMethodAnnotationParser());
        INPUT_METHOD_PARSERS = Collections.unmodifiableList(inputMethodParsers);
        ArrayList<AnnotationParser.OutputAnnotationParser> outputFieldParsers = new ArrayList<AnnotationParser.OutputAnnotationParser>();
        outputFieldParsers.add(new AnnotationParser.LiteralDataOutputFieldAnnotationParser());
        outputFieldParsers.add(new AnnotationParser.ComplexDataOutputFieldAnnotationParser());
        OUTPUT_FIELD_PARSERS = Collections.unmodifiableList(outputFieldParsers);
        ArrayList<AnnotationParser.OutputAnnotationParser> outputMethodParsers = new ArrayList<AnnotationParser.OutputAnnotationParser>();
        outputMethodParsers.add(new AnnotationParser.LiteralDataOutputMethodAnnotationParser());
        outputMethodParsers.add(new AnnotationParser.ComplexDataOutputMethodAnnotationParser());
        OUTPUT_METHOD_PARSERS = Collections.unmodifiableList(outputMethodParsers);
        PROCESS_PARSER = new AnnotationParser.ExecuteAnnotationParser();
        INTROSPECTOR_MAP = new HashMap();
    }

    public static synchronized AnnotatedAlgorithmIntrospector getInstrospector(Class<?> algorithmClass) {
        AnnotatedAlgorithmIntrospector introspector = INTROSPECTOR_MAP.get(algorithmClass);
        if (introspector == null) {
            introspector = new AnnotatedAlgorithmIntrospector(algorithmClass);
            INTROSPECTOR_MAP.put(algorithmClass, introspector);
        }
        return introspector;
    }

    public AnnotatedAlgorithmIntrospector(Class<?> algorithmClass) {
        this.algorithmClass = algorithmClass;
        this.inputBindingMap = new LinkedHashMap();
        this.outputBindingMap = new LinkedHashMap();
        this.parseClass();
        this.inputBindingMap = Collections.unmodifiableMap(this.inputBindingMap);
        this.outputBindingMap = Collections.unmodifiableMap(this.outputBindingMap);
    }

    /*
     * WARNING - void declaration
     */
    private void parseClass() {
        int n;
        if (!this.algorithmClass.isAnnotationPresent(Algorithm.class)) {
            throw new RuntimeException("Class isn't annotated with an Algorithm annotation");
        }
        boolean validContructor = false;
        try {
            Constructor<?> defaultConstructor = this.algorithmClass.getConstructor(new Class[0]);
            validContructor = (defaultConstructor.getModifiers() & 1) == 1;
        }
        catch (NoSuchMethodException defaultConstructor) {
        }
        catch (SecurityException ex) {
            throw new RuntimeException("Current security policy limits use of reflection, error introspecting " + this.algorithmClass.getName());
        }
        if (!validContructor) {
            throw new RuntimeException("Classes with Algorithm annotation require public no-arg constructor, error introspecting " + this.algorithmClass.getName());
        }
        AlgorithmDescriptor.Builder<?> algorithmBuilder = null;
        Algorithm algorithm = this.algorithmClass.getAnnotation(Algorithm.class);
        ArrayList<Method> sortedMethods = new ArrayList<Method>();
        ArrayList<Integer> methodsIdxs = new ArrayList<Integer>();
        try {
            void var7_13;
            Method[] methodArray = this.algorithmClass.getDeclaredMethods();
            n = methodArray.length;
            boolean n2 = false;
            while (var7_13 < n) {
                Method m = methodArray[var7_13];
                ClassPool pool = ClassPool.getDefault();
                ClassClassPath ccpath = new ClassClassPath(m.getDeclaringClass());
                pool.insertClassPath((ClassPath)ccpath);
                CtClass cc = pool.get(m.getDeclaringClass().getCanonicalName());
                CtMethod javassistMethod = cc.getDeclaredMethod(m.getName());
                int linenumber = javassistMethod.getMethodInfo().getLineNumber(0);
                int i = 0;
                for (Integer methodsIdx : methodsIdxs) {
                    if (methodsIdx > linenumber) break;
                    ++i;
                }
                sortedMethods.add(i, m);
                methodsIdxs.add(i, linenumber);
                ++var7_13;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AccessibleObject[] sMethods = sortedMethods.toArray(new Method[sortedMethods.size()]);
        algorithmBuilder = AlgorithmDescriptor.builder(algorithm.identifier().length() > 0 ? algorithm.identifier() : this.algorithmClass.getCanonicalName());
        ((AlgorithmDescriptor.Builder)((AlgorithmDescriptor.Builder)((AlgorithmDescriptor.Builder)((AlgorithmDescriptor.Builder)algorithmBuilder.title(algorithm.title())).abstrakt(algorithm.abstrakt())).version(algorithm.version())).storeSupported(algorithm.storeSupported())).statusSupported(algorithm.statusSupported());
        this.parseElements(sMethods, INPUT_METHOD_PARSERS, OUTPUT_METHOD_PARSERS);
        this.parseElements(this.algorithmClass.getDeclaredFields(), INPUT_FIELD_PARSERS, OUTPUT_FIELD_PARSERS);
        AccessibleObject[] accessibleObjectArray = sMethods;
        int n3 = sMethods.length;
        n = 0;
        while (n < n3) {
            AnnotationBinding.ExecuteMethodBinding executeMethodBinding;
            AccessibleObject accessibleObject = accessibleObjectArray[n];
            if (accessibleObject.isAnnotationPresent(PROCESS_PARSER.getSupportedAnnotation()) && (executeMethodBinding = (AnnotationBinding.ExecuteMethodBinding)PROCESS_PARSER.parse(accessibleObject)) != null) {
                if (this.executeMethodBinding != null) {
                    throw new RuntimeException("Multiple execute method bindings encountered for class " + this.getClass().getCanonicalName());
                }
                this.executeMethodBinding = executeMethodBinding;
            }
            ++n;
        }
        if (this.executeMethodBinding == null) {
            throw new RuntimeException("No execute method binding for class " + this.algorithmClass.getCanonicalName());
        }
        for (AnnotationBinding.InputBinding<?, ?> inputBinding : this.inputBindingMap.values()) {
            algorithmBuilder.addInputDescriptor((InputDescriptor)inputBinding.getDescriptor());
        }
        for (AnnotationBinding.OutputBinding outputBinding : this.outputBindingMap.values()) {
            algorithmBuilder.addOutputDescriptor((OutputDescriptor)outputBinding.getDescriptor());
        }
        this.algorithmDescriptor = algorithmBuilder.build();
    }

    public AlgorithmDescriptor getAlgorithmDescriptor() {
        return this.algorithmDescriptor;
    }

    public AnnotationBinding.ExecuteMethodBinding getExecuteMethodBinding() {
        return this.executeMethodBinding;
    }

    public Map<String, AnnotationBinding.InputBinding<?, ?>> getInputBindingMap() {
        return this.inputBindingMap;
    }

    public Map<String, AnnotationBinding.OutputBinding<?, ?>> getOutputBindingMap() {
        return this.outputBindingMap;
    }

    public <M extends AccessibleObject> void parseElements(M[] members, List<AnnotationParser.InputAnnotationParser<?, M, ?>> inputParser, List<AnnotationParser.OutputAnnotationParser<?, M, ?>> outputParser) {
        M[] MArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationBinding.DataBinding binding;
            M member = MArray[n2];
            for (AnnotationParser.OutputAnnotationParser<?, M, ?> outputAnnotationParser : outputParser) {
                if (!((AccessibleObject)member).isAnnotationPresent(outputAnnotationParser.getSupportedAnnotation()) || (binding = (AnnotationBinding.OutputBinding)outputAnnotationParser.parse(member)) == null) continue;
                this.outputBindingMap.put(((OutputDescriptor)binding.getDescriptor()).getIdentifier(), (AnnotationBinding.OutputBinding<?, ?>)binding);
            }
            for (AnnotationParser.InputAnnotationParser inputAnnotationParser : inputParser) {
                if (!((AccessibleObject)member).isAnnotationPresent(inputAnnotationParser.getSupportedAnnotation()) || (binding = (AnnotationBinding.InputBinding)inputAnnotationParser.parse(member)) == null) continue;
                this.inputBindingMap.put(((InputDescriptor)binding.getDescriptor()).getIdentifier(), (AnnotationBinding.InputBinding<?, ?>)binding);
            }
            ++n2;
        }
    }
}

