/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.algorithm.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import org.n52.wps.algorithm.annotation.AnnotationBinding;
import org.n52.wps.algorithm.annotation.ComplexDataInput;
import org.n52.wps.algorithm.annotation.ComplexDataOutput;
import org.n52.wps.algorithm.annotation.Execute;
import org.n52.wps.algorithm.annotation.LiteralDataInput;
import org.n52.wps.algorithm.annotation.LiteralDataOutput;
import org.n52.wps.algorithm.descriptor.BoundDescriptor;
import org.n52.wps.algorithm.descriptor.ComplexDataInputDescriptor;
import org.n52.wps.algorithm.descriptor.ComplexDataOutputDescriptor;
import org.n52.wps.algorithm.descriptor.InputDescriptor;
import org.n52.wps.algorithm.descriptor.LiteralDataInputDescriptor;
import org.n52.wps.algorithm.descriptor.LiteralDataOutputDescriptor;
import org.n52.wps.algorithm.descriptor.OutputDescriptor;
import org.n52.wps.algorithm.util.ClassUtil;
import org.n52.wps.io.BasicXMLTypeFactory;
import org.n52.wps.io.data.ILiteralData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnnotationParser<A extends Annotation, M extends AccessibleObject, B extends AnnotationBinding<M>> {
    public static final Logger LOGGER = LoggerFactory.getLogger(AnnotationParser.class);

    public B parse(M member) {
        A annotation = ((AccessibleObject)member).getAnnotation(this.getSupportedAnnotation());
        return annotation == null ? null : (B)this.parse(annotation, member);
    }

    public abstract B parse(A var1, M var2);

    public abstract Class<? extends A> getSupportedAnnotation();

    public static class ComplexDataInputAnnotationParser<M extends AccessibleObject, B extends AnnotationBinding.InputBinding<M, ComplexDataInputDescriptor>>
    extends InputAnnotationParser<ComplexDataInput, M, B> {
        @Override
        public B parse(ComplexDataInput annotation, M member) {
            AnnotationBinding.DataBinding annotatedBinding = this.createBinding((AccessibleObject)member);
            InputDescriptor descriptor = ((ComplexDataInputDescriptor.Builder)((ComplexDataInputDescriptor.Builder)((ComplexDataInputDescriptor.Builder)((ComplexDataInputDescriptor.Builder)((ComplexDataInputDescriptor.Builder)ComplexDataInputDescriptor.builder(annotation.identifier(), annotation.binding()).title(annotation.title())).abstrakt(annotation.abstrakt())).minOccurs(annotation.minOccurs())).maxOccurs(annotation.maxOccurs())).maximumMegaBytes(annotation.maximumMegaBytes())).build();
            annotatedBinding.setDescriptor(descriptor);
            return (B)(annotatedBinding.validate() ? annotatedBinding : null);
        }

        @Override
        public Class<? extends ComplexDataInput> getSupportedAnnotation() {
            return ComplexDataInput.class;
        }

        @Override
        protected B createBinding(M member) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class ComplexDataInputFieldAnnotationParser
    extends ComplexDataInputAnnotationParser<Field, AnnotationBinding.InputBinding<Field, ComplexDataInputDescriptor>> {
        @Override
        protected AnnotationBinding.InputBinding<Field, ComplexDataInputDescriptor> createBinding(Field member) {
            return new AnnotationBinding.InputFieldBinding<ComplexDataInputDescriptor>(member);
        }
    }

    public static class ComplexDataInputMethodAnnotationParser
    extends ComplexDataInputAnnotationParser<Method, AnnotationBinding.InputBinding<Method, ComplexDataInputDescriptor>> {
        @Override
        protected AnnotationBinding.InputBinding<Method, ComplexDataInputDescriptor> createBinding(Method member) {
            return new AnnotationBinding.InputMethodBinding<ComplexDataInputDescriptor>(member);
        }
    }

    public static abstract class ComplexDataOutputAnnotationParser<M extends AccessibleObject, B extends AnnotationBinding.OutputBinding<M, ComplexDataOutputDescriptor>>
    extends OutputAnnotationParser<ComplexDataOutput, M, B> {
        @Override
        public B parse(ComplexDataOutput annotation, M member) {
            AnnotationBinding.OutputBinding annotatedBinding = (AnnotationBinding.OutputBinding)this.createBinding(member);
            OutputDescriptor descriptor = ((ComplexDataOutputDescriptor.Builder)((ComplexDataOutputDescriptor.Builder)ComplexDataOutputDescriptor.builder(annotation.identifier(), annotation.binding()).title(annotation.title())).abstrakt(annotation.abstrakt())).build();
            annotatedBinding.setDescriptor(descriptor);
            return (B)(annotatedBinding.validate() ? annotatedBinding : null);
        }

        @Override
        public Class<? extends ComplexDataOutput> getSupportedAnnotation() {
            return ComplexDataOutput.class;
        }
    }

    public static class ComplexDataOutputFieldAnnotationParser
    extends ComplexDataOutputAnnotationParser<Field, AnnotationBinding.OutputBinding<Field, ComplexDataOutputDescriptor>> {
        @Override
        protected AnnotationBinding.OutputBinding<Field, ComplexDataOutputDescriptor> createBinding(Field member) {
            return new AnnotationBinding.OutputFieldBinding<ComplexDataOutputDescriptor>(member);
        }
    }

    public static class ComplexDataOutputMethodAnnotationParser
    extends ComplexDataOutputAnnotationParser<Method, AnnotationBinding.OutputBinding<Method, ComplexDataOutputDescriptor>> {
        @Override
        protected AnnotationBinding.OutputBinding<Method, ComplexDataOutputDescriptor> createBinding(Method member) {
            return new AnnotationBinding.OutputMethodBinding<ComplexDataOutputDescriptor>(member);
        }
    }

    public static abstract class DataAnnotationParser<A extends Annotation, M extends AccessibleObject, B extends AnnotationBinding.DataBinding<M, ? extends BoundDescriptor>>
    extends AnnotationParser<A, M, B> {
        protected abstract B createBinding(M var1);
    }

    public static class ExecuteAnnotationParser
    extends AnnotationParser<Execute, Method, AnnotationBinding.ExecuteMethodBinding> {
        @Override
        public AnnotationBinding.ExecuteMethodBinding parse(Execute annotation, Method member) {
            AnnotationBinding.ExecuteMethodBinding annotationBinding = new AnnotationBinding.ExecuteMethodBinding(member);
            return annotationBinding.validate() ? annotationBinding : null;
        }

        @Override
        public Class<? extends Execute> getSupportedAnnotation() {
            return Execute.class;
        }
    }

    public static abstract class InputAnnotationParser<A extends Annotation, M extends AccessibleObject, B extends AnnotationBinding.InputBinding<M, ? extends InputDescriptor>>
    extends DataAnnotationParser<A, M, B> {
    }

    public static abstract class LiteralDataInputAnnotationParser<M extends AccessibleObject, B extends AnnotationBinding.InputBinding<M, LiteralDataInputDescriptor>>
    extends InputAnnotationParser<LiteralDataInput, M, B> {
        @Override
        public B parse(LiteralDataInput annotation, M member) {
            AnnotationBinding.InputBinding annotatedBinding = (AnnotationBinding.InputBinding)this.createBinding(member);
            Type payloadType = annotatedBinding.getPayloadType();
            Class binding = annotation.binding();
            if (binding == null || ILiteralData.class.equals(binding)) {
                if (payloadType instanceof Class) {
                    binding = BasicXMLTypeFactory.getBindingForPayloadType((Class)((Class)payloadType));
                    if (binding == null) {
                        LOGGER.error("Unable to locate binding class for {}; binding not found.", (Object)payloadType);
                    }
                } else if (annotatedBinding.isMemberTypeList()) {
                    LOGGER.error("Unable to determine binding class for {}; List must be parameterized with a type matching a known binding payload to use auto-binding.", (Object)payloadType);
                } else {
                    LOGGER.error("Unable to determine binding class for {}; type must fully resolved to use auto-binding", (Object)payloadType);
                }
            }
            String[] allowedValues = annotation.allowedValues();
            String defaultValue = annotation.defaultValue();
            int maxOccurs = annotation.maxOccurs();
            Type inputType = annotatedBinding.getType();
            if (annotatedBinding.isTypeEnum()) {
                Class inputEnumClass = (Class)inputType;
                if (allowedValues.length > 0) {
                    ArrayList<String> invalidValues = new ArrayList<String>();
                    String[] stringArray = allowedValues;
                    int n = allowedValues.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String value = stringArray[n2];
                        try {
                            Enum.valueOf(inputEnumClass, value);
                        }
                        catch (IllegalArgumentException e) {
                            invalidValues.add(value);
                            LOGGER.warn("Invalid allowed value \"{}\" specified for for enumerated input type {}", (Object)value, (Object)inputType);
                        }
                        ++n2;
                    }
                    if (invalidValues.size() > 0) {
                        ArrayList<String> updatedValues = new ArrayList<String>(Arrays.asList(allowedValues));
                        updatedValues.removeAll(invalidValues);
                        allowedValues = updatedValues.toArray(new String[0]);
                    }
                }
                if (allowedValues.length == 0) {
                    allowedValues = ClassUtil.convertEnumToStringArray(inputEnumClass);
                }
                if (defaultValue.length() > 0) {
                    try {
                        Enum.valueOf(inputEnumClass, defaultValue);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.warn("Invalid default value \"{}\" specified for for enumerated input type {}, ignoring.", (Object)defaultValue, (Object)inputType);
                        defaultValue = "";
                    }
                }
                if (maxOccurs == -1) {
                    maxOccurs = ((Enum[])inputEnumClass.getEnumConstants()).length;
                }
            } else if (maxOccurs == -1) {
                maxOccurs = 1;
                LOGGER.warn("Invalid maxOccurs \"ENUM_COUNT\" specified for for input type {}, setting maxOccurs to {}", (Object)inputType, (Object)maxOccurs);
            }
            if (binding != null) {
                InputDescriptor descriptor = ((LiteralDataInputDescriptor.Builder)((LiteralDataInputDescriptor.Builder)((LiteralDataInputDescriptor.Builder)((LiteralDataInputDescriptor.Builder)((LiteralDataInputDescriptor.Builder)((LiteralDataInputDescriptor.Builder)LiteralDataInputDescriptor.builder(annotation.identifier(), binding).title(annotation.title())).abstrakt(annotation.abstrakt())).minOccurs(annotation.minOccurs())).maxOccurs(maxOccurs)).defaultValue(defaultValue)).allowedValues(allowedValues)).build();
                annotatedBinding.setDescriptor(descriptor);
            } else {
                LOGGER.error("Unable to generate binding for input identifier \"{}\"", (Object)annotation.identifier());
            }
            return (B)(annotatedBinding.validate() ? annotatedBinding : null);
        }

        @Override
        public Class<? extends LiteralDataInput> getSupportedAnnotation() {
            return LiteralDataInput.class;
        }
    }

    public static class LiteralDataInputFieldAnnotationParser
    extends LiteralDataInputAnnotationParser<Field, AnnotationBinding.InputBinding<Field, LiteralDataInputDescriptor>> {
        @Override
        protected AnnotationBinding.InputBinding<Field, LiteralDataInputDescriptor> createBinding(Field member) {
            return new AnnotationBinding.InputFieldBinding<LiteralDataInputDescriptor>(member);
        }
    }

    public static class LiteralDataInputMethodAnnotationParser
    extends LiteralDataInputAnnotationParser<Method, AnnotationBinding.InputBinding<Method, LiteralDataInputDescriptor>> {
        @Override
        protected AnnotationBinding.InputBinding<Method, LiteralDataInputDescriptor> createBinding(Method member) {
            return new AnnotationBinding.InputMethodBinding<LiteralDataInputDescriptor>(member);
        }
    }

    public static abstract class LiteralDataOutputAnnotationParser<M extends AccessibleObject, B extends AnnotationBinding.OutputBinding<M, LiteralDataOutputDescriptor>>
    extends OutputAnnotationParser<LiteralDataOutput, M, B> {
        @Override
        public B parse(LiteralDataOutput annotation, M member) {
            AnnotationBinding.OutputBinding annotatedBinding = (AnnotationBinding.OutputBinding)this.createBinding(member);
            Type payloadType = annotatedBinding.getPayloadType();
            Class binding = annotation.binding();
            if (binding == null || ILiteralData.class.equals(binding)) {
                if (payloadType instanceof Class) {
                    binding = BasicXMLTypeFactory.getBindingForPayloadType((Class)((Class)payloadType));
                    if (binding == null) {
                        LOGGER.error("Unable to locate binding class for {}; binding not found.", (Object)payloadType);
                    }
                } else {
                    LOGGER.error("Unable to determine binding class for {}; type must fully resolved to use auto-binding", (Object)payloadType);
                }
            }
            if (binding != null) {
                OutputDescriptor descriptor = ((LiteralDataOutputDescriptor.Builder)((LiteralDataOutputDescriptor.Builder)LiteralDataOutputDescriptor.builder(annotation.identifier(), binding).title(annotation.title())).abstrakt(annotation.abstrakt())).build();
                annotatedBinding.setDescriptor(descriptor);
            } else {
                LOGGER.error("Unable to generate binding for output identifier \"{}\"", (Object)annotation.identifier());
            }
            return (B)(annotatedBinding.validate() ? annotatedBinding : null);
        }

        @Override
        public Class<? extends LiteralDataOutput> getSupportedAnnotation() {
            return LiteralDataOutput.class;
        }
    }

    public static class LiteralDataOutputFieldAnnotationParser
    extends LiteralDataOutputAnnotationParser<Field, AnnotationBinding.OutputBinding<Field, LiteralDataOutputDescriptor>> {
        @Override
        protected AnnotationBinding.OutputBinding<Field, LiteralDataOutputDescriptor> createBinding(Field member) {
            return new AnnotationBinding.OutputFieldBinding<LiteralDataOutputDescriptor>(member);
        }
    }

    public static class LiteralDataOutputMethodAnnotationParser
    extends LiteralDataOutputAnnotationParser<Method, AnnotationBinding.OutputBinding<Method, LiteralDataOutputDescriptor>> {
        @Override
        protected AnnotationBinding.OutputBinding<Method, LiteralDataOutputDescriptor> createBinding(Method member) {
            return new AnnotationBinding.OutputMethodBinding<LiteralDataOutputDescriptor>(member);
        }
    }

    public static abstract class OutputAnnotationParser<A extends Annotation, M extends AccessibleObject, B extends AnnotationBinding.OutputBinding<M, ? extends OutputDescriptor>>
    extends DataAnnotationParser<A, M, B> {
    }
}

