/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.opengis.ows.x11.AllowedValuesDocument;
import net.opengis.wps.x100.ComplexDataCombinationType;
import net.opengis.wps.x100.ComplexDataCombinationsType;
import net.opengis.wps.x100.ComplexDataDescriptionType;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.LiteralInputType;
import net.opengis.wps.x100.OutputDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionsDocument;
import net.opengis.wps.x100.SupportedComplexDataInputType;
import net.opengis.wps.x100.SupportedComplexDataType;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlValidationError;
import org.n52.wps.FormatDocument;
import org.n52.wps.algorithm.descriptor.AlgorithmDescriptor;
import org.n52.wps.algorithm.descriptor.ComplexDataInputDescriptor;
import org.n52.wps.algorithm.descriptor.ComplexDataOutputDescriptor;
import org.n52.wps.algorithm.descriptor.InputDescriptor;
import org.n52.wps.algorithm.descriptor.LiteralDataInputDescriptor;
import org.n52.wps.algorithm.descriptor.LiteralDataOutputDescriptor;
import org.n52.wps.algorithm.descriptor.OutputDescriptor;
import org.n52.wps.io.GeneratorFactory;
import org.n52.wps.io.IGenerator;
import org.n52.wps.io.IOHandler;
import org.n52.wps.io.IParser;
import org.n52.wps.io.ParserFactory;
import org.n52.wps.io.data.IData;
import org.n52.wps.server.IAlgorithm;
import org.n52.wps.server.observerpattern.IObserver;
import org.n52.wps.server.observerpattern.ISubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDescriptorAlgorithm
implements IAlgorithm,
ISubject {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDescriptorAlgorithm.class);
    private AlgorithmDescriptor descriptor;
    private ProcessDescriptionType description;
    private List observers = new ArrayList();
    private Object state = null;
    List<String> errorList = new ArrayList<String>();

    @Override
    public synchronized ProcessDescriptionType getDescription() {
        if (this.description == null) {
            this.description = this.createProcessDescription();
        }
        return this.description;
    }

    @Override
    public String getWellKnownName() {
        return this.getAlgorithmDescriptor().getIdentifier();
    }

    private ProcessDescriptionType createProcessDescription() {
        AlgorithmDescriptor algorithmDescriptor = this.getAlgorithmDescriptor();
        ProcessDescriptionsDocument document = ProcessDescriptionsDocument.Factory.newInstance();
        ProcessDescriptionsDocument.ProcessDescriptions processDescriptions = document.addNewProcessDescriptions();
        ProcessDescriptionType processDescription = processDescriptions.addNewProcessDescription();
        if (algorithmDescriptor == null) {
            throw new IllegalStateException("Instance must have an algorithm descriptor");
        }
        processDescription.setStatusSupported(algorithmDescriptor.getStatusSupported());
        processDescription.setStoreSupported(algorithmDescriptor.getStoreSupported());
        processDescription.setProcessVersion(algorithmDescriptor.getVersion());
        processDescription.addNewIdentifier().setStringValue(algorithmDescriptor.getIdentifier());
        processDescription.addNewTitle().setStringValue(algorithmDescriptor.hasTitle() ? algorithmDescriptor.getTitle() : algorithmDescriptor.getIdentifier());
        if (algorithmDescriptor.hasAbstract()) {
            processDescription.addNewAbstract().setStringValue(algorithmDescriptor.getAbstract());
        }
        Collection<InputDescriptor> inputDescriptors = algorithmDescriptor.getInputDescriptors();
        ProcessDescriptionType.DataInputs dataInputs = null;
        if (inputDescriptors.size() > 0) {
            dataInputs = processDescription.addNewDataInputs();
        }
        for (InputDescriptor inputDescriptor : inputDescriptors) {
            InputDescriptionType dataInput = dataInputs.addNewInput();
            dataInput.setMinOccurs(inputDescriptor.getMinOccurs());
            dataInput.setMaxOccurs(inputDescriptor.getMaxOccurs());
            dataInput.addNewIdentifier().setStringValue(inputDescriptor.getIdentifier());
            dataInput.addNewTitle().setStringValue(inputDescriptor.hasTitle() ? inputDescriptor.getTitle() : inputDescriptor.getIdentifier());
            if (inputDescriptor.hasAbstract()) {
                dataInput.addNewAbstract().setStringValue(inputDescriptor.getAbstract());
            }
            if (inputDescriptor instanceof LiteralDataInputDescriptor) {
                LiteralDataInputDescriptor literalDescriptor = (LiteralDataInputDescriptor)inputDescriptor;
                LiteralInputType literalData = dataInput.addNewLiteralData();
                literalData.addNewDataType().setReference(literalDescriptor.getDataType());
                if (literalDescriptor.hasDefaultValue()) {
                    literalData.setDefaultValue(literalDescriptor.getDefaultValue());
                }
                if (literalDescriptor.hasAllowedValues()) {
                    AllowedValuesDocument.AllowedValues allowed = literalData.addNewAllowedValues();
                    for (String allowedValue : literalDescriptor.getAllowedValues()) {
                        allowed.addNewValue().setStringValue(allowedValue);
                    }
                    continue;
                }
                literalData.addNewAnyValue();
                continue;
            }
            if (!(inputDescriptor instanceof ComplexDataInputDescriptor)) continue;
            SupportedComplexDataInputType complexDataType = dataInput.addNewComplexData();
            ComplexDataInputDescriptor complexInputDescriptor = (ComplexDataInputDescriptor)inputDescriptor;
            if (complexInputDescriptor.hasMaximumMegaBytes()) {
                complexDataType.setMaximumMegabytes(complexInputDescriptor.getMaximumMegaBytes());
            }
            this.describeComplexDataInputType((SupportedComplexDataType)complexDataType, (Class)inputDescriptor.getBinding());
        }
        ProcessDescriptionType.ProcessOutputs dataOutputs = processDescription.addNewProcessOutputs();
        Collection<OutputDescriptor> outputDescriptors = algorithmDescriptor.getOutputDescriptors();
        if (outputDescriptors.size() < 1) {
            LOGGER.error("No outputs found for algorithm {}", (Object)algorithmDescriptor.getIdentifier());
        }
        for (OutputDescriptor outputDescriptor : outputDescriptors) {
            OutputDescriptionType dataOutput = dataOutputs.addNewOutput();
            dataOutput.addNewIdentifier().setStringValue(outputDescriptor.getIdentifier());
            dataOutput.addNewTitle().setStringValue(outputDescriptor.hasTitle() ? outputDescriptor.getTitle() : outputDescriptor.getIdentifier());
            if (outputDescriptor.hasAbstract()) {
                dataOutput.addNewAbstract().setStringValue(outputDescriptor.getAbstract());
            }
            if (outputDescriptor instanceof LiteralDataOutputDescriptor) {
                LiteralDataOutputDescriptor literalDescriptor = (LiteralDataOutputDescriptor)outputDescriptor;
                dataOutput.addNewLiteralOutput().addNewDataType().setReference(literalDescriptor.getDataType());
                continue;
            }
            if (!(outputDescriptor instanceof ComplexDataOutputDescriptor)) continue;
            this.describeComplexDataOutputType(dataOutput.addNewComplexOutput(), (Class)outputDescriptor.getBinding());
        }
        return document.getProcessDescriptions().getProcessDescriptionArray(0);
    }

    private void describeComplexDataInputType(SupportedComplexDataType complexData, Class dataTypeClass) {
        List parsers = ParserFactory.getInstance().getAllParsers();
        ArrayList<IParser> foundParsers = new ArrayList<IParser>();
        for (IParser parser : parsers) {
            Class[] supportedClasses;
            Class[] classArray = supportedClasses = parser.getSupportedDataBindings();
            int n = supportedClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class clazz = classArray[n2];
                if (dataTypeClass.isAssignableFrom(clazz)) {
                    foundParsers.add(parser);
                }
                ++n2;
            }
        }
        this.describeComplexDataType(complexData, foundParsers);
    }

    private void describeComplexDataOutputType(SupportedComplexDataType complexData, Class dataTypeClass) {
        List generators = GeneratorFactory.getInstance().getAllGenerators();
        ArrayList<IGenerator> foundGenerators = new ArrayList<IGenerator>();
        for (IGenerator generator : generators) {
            Class[] supportedClasses;
            Class[] classArray = supportedClasses = generator.getSupportedDataBindings();
            int n = supportedClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class clazz = classArray[n2];
                if (clazz.isAssignableFrom(dataTypeClass)) {
                    foundGenerators.add(generator);
                }
                ++n2;
            }
        }
        this.describeComplexDataType(complexData, foundGenerators);
    }

    private void describeComplexDataType(SupportedComplexDataType complexData, List<? extends IOHandler> handlers) {
        ComplexDataCombinationType defaultFormatType = complexData.addNewDefault();
        ComplexDataCombinationsType supportedFormatType = complexData.addNewSupported();
        boolean needDefault = true;
        for (IOHandler iOHandler : handlers) {
            String[] schemas;
            FormatDocument.Format[] fullFormats = iOHandler.getSupportedFullFormats();
            if (fullFormats != null && fullFormats.length > 0) {
                if (needDefault) {
                    needDefault = false;
                    this.describeComplexDataFormat(defaultFormatType.addNewFormat(), fullFormats[0]);
                }
                int formatIndex = 0;
                int formatCount = fullFormats.length;
                while (formatIndex < formatCount) {
                    this.describeComplexDataFormat(supportedFormatType.addNewFormat(), fullFormats[formatIndex]);
                    ++formatIndex;
                }
                continue;
            }
            String[] formats = iOHandler.getSupportedFormats();
            if (formats == null || formats.length == 0) {
                LOGGER.warn("Skipping IOHandler {} in ProcessDescription generation for {}, no formats specified", (Object)iOHandler.getClass().getSimpleName(), (Object)this.getWellKnownName());
                continue;
            }
            String[] encodings = iOHandler.getSupportedEncodings();
            if (encodings == null || encodings.length == 0) {
                encodings = new String[1];
            }
            if ((schemas = iOHandler.getSupportedSchemas()) == null || schemas.length == 0) {
                schemas = new String[1];
            }
            String[] stringArray = formats;
            int n = formats.length;
            int n2 = 0;
            while (n2 < n) {
                String format = stringArray[n2];
                String[] stringArray2 = encodings;
                int n3 = encodings.length;
                int n4 = 0;
                while (n4 < n3) {
                    String encoding = stringArray2[n4];
                    String[] stringArray3 = schemas;
                    int n5 = schemas.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String schema = stringArray3[n6];
                        if (needDefault) {
                            needDefault = false;
                            this.describeComplexDataFormat(defaultFormatType.addNewFormat(), format, encoding, schema);
                        }
                        this.describeComplexDataFormat(supportedFormatType.addNewFormat(), format, encoding, schema);
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void describeComplexDataFormat(ComplexDataDescriptionType description, FormatDocument.Format format) {
        this.describeComplexDataFormat(description, format.getMimetype(), format.getEncoding(), format.getSchema());
    }

    private void describeComplexDataFormat(ComplexDataDescriptionType description, String format, String encoding, String schema) {
        if (!Strings.isNullOrEmpty((String)format)) {
            description.setMimeType(format);
        }
        if (!Strings.isNullOrEmpty((String)encoding)) {
            description.setEncoding(encoding);
        }
        if (!Strings.isNullOrEmpty((String)schema)) {
            description.setSchema(schema);
        }
    }

    @Override
    public boolean processDescriptionIsValid() {
        XmlOptions xmlOptions = new XmlOptions();
        ArrayList xmlValidationErrorList = new ArrayList();
        xmlOptions.setErrorListener(xmlValidationErrorList);
        boolean valid = this.getDescription().validate(xmlOptions);
        if (!valid) {
            LOGGER.error("Error validating process description for " + this.getClass().getCanonicalName());
            for (XmlValidationError xmlValidationError : xmlValidationErrorList) {
                LOGGER.error("\tMessage: {}", (Object)xmlValidationError.getMessage());
                LOGGER.error("\tLocation of invalid XML: {}", (Object)xmlValidationError.getCursorLocation().xmlText());
            }
        }
        return valid;
    }

    protected final synchronized AlgorithmDescriptor getAlgorithmDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = this.createAlgorithmDescriptor();
        }
        return this.descriptor;
    }

    protected abstract AlgorithmDescriptor createAlgorithmDescriptor();

    public Class<? extends IData> getInputDataType(String identifier) {
        AlgorithmDescriptor algorithmDescriptor = this.getAlgorithmDescriptor();
        if (algorithmDescriptor != null) {
            return this.getAlgorithmDescriptor().getInputDescriptor(identifier).getBinding();
        }
        throw new IllegalStateException("Instance must have an algorithm descriptor");
    }

    public Class<? extends IData> getOutputDataType(String identifier) {
        AlgorithmDescriptor algorithmDescriptor = this.getAlgorithmDescriptor();
        if (algorithmDescriptor != null) {
            return this.getAlgorithmDescriptor().getOutputDescriptor(identifier).getBinding();
        }
        throw new IllegalStateException("Instance must have an algorithm descriptor");
    }

    public Object getState() {
        return this.state;
    }

    public void update(Object state) {
        this.state = state;
        this.notifyObservers();
    }

    public void addObserver(IObserver o) {
        this.observers.add(o);
    }

    public void removeObserver(IObserver o) {
        this.observers.remove(o);
    }

    public void notifyObservers() {
        for (IObserver o : this.observers) {
            o.update((ISubject)this);
        }
    }

    protected List<String> addError(String error) {
        this.errorList.add(error);
        return this.errorList;
    }

    @Override
    public List<String> getErrors() {
        return this.errorList;
    }
}

