/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionsDocument;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.n52.wps.server.AbstractAlgorithm;
import org.n52.wps.server.IAlgorithm;
import org.n52.wps.server.observerpattern.IObserver;
import org.n52.wps.server.observerpattern.ISubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObservableAlgorithm
implements IAlgorithm,
ISubject {
    protected ProcessDescriptionType description;
    protected final String wkName;
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractAlgorithm.class);
    private List observers = new ArrayList();
    private Object state = null;

    public AbstractObservableAlgorithm() {
        this.description = this.initializeDescription();
        this.wkName = "";
    }

    public AbstractObservableAlgorithm(ProcessDescriptionType description) {
        this.description = description;
        this.wkName = "";
    }

    public AbstractObservableAlgorithm(String wellKnownName) {
        this.wkName = wellKnownName;
        this.description = this.initializeDescription();
    }

    protected ProcessDescriptionType initializeDescription() {
        ProcessDescriptionsDocument doc;
        block5: {
            String className = this.getClass().getName().replace(".", "/");
            InputStream xmlDesc = this.getClass().getResourceAsStream("/" + className + ".xml");
            XmlOptions option = new XmlOptions();
            option.setLoadTrimTextBuffer();
            doc = ProcessDescriptionsDocument.Factory.parse((InputStream)xmlDesc, (XmlOptions)option);
            if (doc.getProcessDescriptions().getProcessDescriptionArray().length != 0) break block5;
            LOGGER.warn("ProcessDescription does not contain correct any description");
            return null;
        }
        try {
            if (!doc.getProcessDescriptions().getProcessDescriptionArray(0).getIdentifier().getStringValue().equals(this.getClass().getName()) && !doc.getProcessDescriptions().getProcessDescriptionArray(0).getIdentifier().getStringValue().equals(this.getWellKnownName())) {
                doc.getProcessDescriptions().getProcessDescriptionArray(0).getIdentifier().setStringValue(this.getClass().getName());
                LOGGER.warn("Identifier was not correct, was changed now temporary for server use to " + this.getClass().getName() + ". Please change it later in the description!");
            }
            return doc.getProcessDescriptions().getProcessDescriptionArray(0);
        }
        catch (IOException e) {
            LOGGER.warn("Could not initialize algorithm, parsing error: " + this.getClass().getName(), (Throwable)e);
        }
        catch (XmlException e) {
            LOGGER.warn("Could not initialize algorithm, parsing error: " + this.getClass().getName(), (Throwable)e);
        }
        return null;
    }

    @Override
    public ProcessDescriptionType getDescription() {
        return this.description;
    }

    @Override
    public boolean processDescriptionIsValid() {
        return this.description.validate();
    }

    @Override
    public String getWellKnownName() {
        return this.wkName;
    }

    public Object getState() {
        return this.state;
    }

    public void update(Object state) {
        this.state = state;
        this.notifyObservers();
    }

    public void addObserver(IObserver o) {
        this.observers.add(o);
    }

    public void removeObserver(IObserver o) {
        this.observers.remove(o);
    }

    public void notifyObservers() {
        for (IObserver o : this.observers) {
            o.update((ISubject)this);
        }
    }
}

