/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.locks.ReentrantLock;
import net.opengis.ows.x11.CodeType;
import net.opengis.ows.x11.DCPDocument;
import net.opengis.ows.x11.LanguageStringType;
import net.opengis.ows.x11.OperationDocument;
import net.opengis.ows.x11.RequestMethodType;
import net.opengis.wps.x100.CapabilitiesDocument;
import net.opengis.wps.x100.ProcessBriefType;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.ProcessOfferingsDocument;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.server.RepositoryManager;
import org.n52.wps.server.WebProcessingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilitiesConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CapabilitiesConfiguration.class);
    private static final ReentrantLock lock = new ReentrantLock();
    private static CapabilitiesDocument capabilitiesDocumentObj;
    private static CapabilitiesSkeletonLoadingStrategy loadingStrategy;
    public static String ENDPOINT_URL;

    private CapabilitiesConfiguration() {
    }

    public static CapabilitiesDocument getInstance(String filePath) throws XmlException, IOException {
        return CapabilitiesConfiguration.getInstance(new FileLoadingStrategy(filePath));
    }

    public static CapabilitiesDocument getInstance(File file) throws XmlException, IOException {
        return CapabilitiesConfiguration.getInstance(new FileLoadingStrategy(file));
    }

    public static CapabilitiesDocument getInstance(URL url) throws XmlException, IOException {
        return CapabilitiesConfiguration.getInstance(new URLLoadingStrategy(url));
    }

    public static CapabilitiesDocument getInstance(CapabilitiesDocument skel) throws XmlException, IOException {
        return CapabilitiesConfiguration.getInstance(new InstanceStrategy(skel));
    }

    private static CapabilitiesDocument getInstance(CapabilitiesSkeletonLoadingStrategy strategy) throws XmlException, IOException {
        Preconditions.checkNotNull((Object)strategy);
        lock.lock();
        try {
            if (strategy.equals(loadingStrategy)) {
                CapabilitiesDocument capabilitiesDocument = CapabilitiesConfiguration.getInstance(false);
                return capabilitiesDocument;
            }
            loadingStrategy = strategy;
            CapabilitiesDocument capabilitiesDocument = CapabilitiesConfiguration.getInstance(true);
            return capabilitiesDocument;
        }
        finally {
            lock.unlock();
        }
    }

    public static CapabilitiesDocument getInstance() throws XmlException, IOException {
        return CapabilitiesConfiguration.getInstance(!WPSConfig.getInstance().getWPSConfig().getServer().getCacheCapabilites());
    }

    public static CapabilitiesDocument getInstance(boolean reload) throws XmlException, IOException {
        lock.lock();
        try {
            if (capabilitiesDocumentObj == null || reload) {
                capabilitiesDocumentObj = loadingStrategy.loadSkeleton();
                CapabilitiesConfiguration.initSkeleton(capabilitiesDocumentObj);
            }
            CapabilitiesDocument capabilitiesDocument = capabilitiesDocumentObj;
            return capabilitiesDocument;
        }
        finally {
            lock.unlock();
        }
    }

    private static void initSkeleton(CapabilitiesDocument skel) throws UnknownHostException {
        ENDPOINT_URL = CapabilitiesConfiguration.getEndpointURL();
        if (skel.getCapabilities() == null) {
            skel.addNewCapabilities();
        }
        CapabilitiesConfiguration.initOperationsMetadata(skel, ENDPOINT_URL);
        CapabilitiesConfiguration.initProcessOfferings(skel);
    }

    private static void initProcessOfferings(CapabilitiesDocument skel) {
        ProcessOfferingsDocument.ProcessOfferings processes = skel.getCapabilities().addNewProcessOfferings();
        for (String algorithmName : RepositoryManager.getInstance().getAlgorithms()) {
            try {
                ProcessDescriptionType description = RepositoryManager.getInstance().getProcessDescription(algorithmName);
                if (description == null) continue;
                ProcessBriefType process = processes.addNewProcess();
                CodeType ct = process.addNewIdentifier();
                ct.setStringValue(algorithmName);
                LanguageStringType title = description.getTitle();
                String processVersion = description.getProcessVersion();
                process.setProcessVersion(processVersion);
                process.setTitle(title);
            }
            catch (RuntimeException e) {
                LOG.warn("Exception during instantiation of process {}", (Object)algorithmName, (Object)e);
            }
        }
    }

    private static void initOperationsMetadata(CapabilitiesDocument skel, String endpointUrl) {
        if (skel.getCapabilities().getOperationsMetadata() != null) {
            String endpointUrlGet = String.valueOf(endpointUrl) + "?";
            OperationDocument.Operation[] operationArray = skel.getCapabilities().getOperationsMetadata().getOperationArray();
            int n = operationArray.length;
            int n2 = 0;
            while (n2 < n) {
                OperationDocument.Operation op = operationArray[n2];
                DCPDocument.DCP[] dCPArray = op.getDCPArray();
                int n3 = dCPArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    DCPDocument.DCP dcp = dCPArray[n4];
                    RequestMethodType[] requestMethodTypeArray = dcp.getHTTP().getGetArray();
                    int n5 = requestMethodTypeArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        RequestMethodType get = requestMethodTypeArray[n6];
                        get.setHref(endpointUrlGet);
                        ++n6;
                    }
                    requestMethodTypeArray = dcp.getHTTP().getPostArray();
                    n5 = requestMethodTypeArray.length;
                    n6 = 0;
                    while (n6 < n5) {
                        RequestMethodType post = requestMethodTypeArray[n6];
                        post.setHref(endpointUrl);
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private static String getEndpointURL() throws UnknownHostException {
        WPSConfig config = WPSConfig.getInstance();
        String protocol = config.getWPSConfig().getServer().getProtocol();
        String host = config.getWPSConfig().getServer().getHostname();
        String port = config.getWPSConfig().getServer().getHostport();
        if (host == null) {
            host = InetAddress.getLocalHost().getCanonicalHostName();
        }
        StringBuilder url = new StringBuilder();
        url.append(protocol).append("://").append(host);
        url.append(':').append(port).append('/');
        if (WebProcessingService.WEBAPP_PATH != null && !WebProcessingService.WEBAPP_PATH.isEmpty()) {
            url.append(WebProcessingService.WEBAPP_PATH).append('/');
        }
        url.append(WebProcessingService.SERVLET_PATH);
        return url.toString();
    }

    public static void reloadSkeleton() throws XmlException, IOException {
        CapabilitiesConfiguration.getInstance(true);
    }

    public static boolean ready() {
        lock.lock();
        try {
            boolean bl = capabilitiesDocumentObj != null;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private static interface CapabilitiesSkeletonLoadingStrategy {
        public CapabilitiesDocument loadSkeleton() throws XmlException, IOException;
    }

    private static class FileLoadingStrategy
    extends URLLoadingStrategy {
        FileLoadingStrategy(File file) throws MalformedURLException {
            super(file.toURI().toURL());
        }

        FileLoadingStrategy(String file) throws MalformedURLException {
            this(new File((String)Preconditions.checkNotNull((Object)file)));
        }
    }

    private static class InstanceStrategy
    implements CapabilitiesSkeletonLoadingStrategy {
        private final CapabilitiesDocument instance;

        InstanceStrategy(CapabilitiesDocument instance) {
            this.instance = (CapabilitiesDocument)Preconditions.checkNotNull((Object)instance);
        }

        @Override
        public CapabilitiesDocument loadSkeleton() {
            return (CapabilitiesDocument)this.getInstance().copy();
        }

        public boolean equals(Object obj) {
            if (obj instanceof InstanceStrategy) {
                InstanceStrategy that = (InstanceStrategy)obj;
                return this.getInstance().equals(that.getInstance());
            }
            return false;
        }

        public int hashCode() {
            return this.getInstance().hashCode();
        }

        public CapabilitiesDocument getInstance() {
            return this.instance;
        }
    }

    private static class URLLoadingStrategy
    implements CapabilitiesSkeletonLoadingStrategy {
        private final URL url;

        URLLoadingStrategy(URL url) {
            this.url = (URL)Preconditions.checkNotNull((Object)url);
        }

        @Override
        public CapabilitiesDocument loadSkeleton() throws XmlException, IOException {
            XmlOptions options = new XmlOptions().setLoadStripComments();
            return CapabilitiesDocument.Factory.parse((URL)this.getUrl(), (XmlOptions)options);
        }

        public boolean equals(Object obj) {
            if (obj instanceof URLLoadingStrategy) {
                URLLoadingStrategy that = (URLLoadingStrategy)obj;
                return this.getUrl().equals(that.getUrl());
            }
            return false;
        }

        public int hashCode() {
            return this.getUrl().hashCode();
        }

        public URL getUrl() {
            return this.url;
        }
    }
}

