/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.UUID;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.n52.wps.commons.MIMEUtil;
import org.n52.wps.commons.XMLUtil;
import org.n52.wps.server.database.DatabaseFactory;
import org.n52.wps.server.database.IDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieveResultServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetrieveResultServlet.class);
    private static final long serialVersionUID = -268198171054599696L;
    public static final String SERVLET_PATH = "RetrieveResultServlet";
    private final boolean indentXML = false;
    private final int uuid_length = 36;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block20: {
            String id = request.getParameter("id");
            boolean altName = false;
            String alternateFilename = request.getParameter("filename");
            if (!StringUtils.isEmpty((String)alternateFilename)) {
                altName = true;
            }
            String attachment = request.getParameter("attachment");
            if (StringUtils.isEmpty((String)id)) {
                this.errorResponse("id parameter missing", response);
            } else {
                ServletOutputStream outputStream;
                InputStream inputStream;
                block19: {
                    if (!this.isIDValid(id)) {
                        this.errorResponse("id parameter not valid", response);
                    }
                    IDatabase db = DatabaseFactory.getDatabase();
                    String mimeType = db.getMimeTypeForStoreResponse(id);
                    long contentLength = db.getContentLengthForStoreResponse(id);
                    inputStream = null;
                    outputStream = null;
                    try {
                        try {
                            boolean useAttachment;
                            inputStream = db.lookupResponse(id);
                            if (inputStream == null) {
                                this.errorResponse("id " + id + " is unknown to server", response);
                                break block19;
                            }
                            if (mimeType == null) {
                                this.errorResponse("Unable to determine mime-type for id " + id, response);
                                break block19;
                            }
                            String suffix = MIMEUtil.getSuffixFromMIMEType((String)mimeType).toLowerCase();
                            boolean bl = useAttachment = StringUtils.isEmpty((String)attachment) && !"xml".equals(suffix) || Boolean.parseBoolean(attachment);
                            if (useAttachment) {
                                String attachmentName = id + '.' + suffix;
                                if (altName) {
                                    attachmentName = alternateFilename + '.' + suffix;
                                }
                                response.addHeader("Content-Disposition", "attachment; filename=\"" + attachmentName + "\"");
                            }
                            response.setContentType(mimeType);
                            if ("xml".equals(suffix)) {
                                response.addHeader("Cache-Control", "no-cache, no-store");
                                response.addHeader("Pragma", "no-cache");
                                response.addHeader("Expires", "-1");
                                try {
                                    outputStream = response.getOutputStream();
                                }
                                catch (IOException e) {
                                    throw new IOException("Error obtaining output stream for response", e);
                                }
                                this.copyResponseAsXML(inputStream, (OutputStream)outputStream, useAttachment, id);
                                break block19;
                            }
                            if (contentLength > -1L) {
                                response.setHeader("Content-Length", Long.toString(contentLength));
                            } else {
                                LOGGER.warn("Content-Length unknown for response to id {}", (Object)id);
                            }
                            try {
                                outputStream = response.getOutputStream();
                            }
                            catch (IOException e) {
                                throw new IOException("Error obtaining output stream for response", e);
                            }
                            this.copyResponseStream(inputStream, (OutputStream)outputStream, id, contentLength);
                        }
                        catch (Exception e) {
                            this.logException(e);
                            IOUtils.closeQuietly((InputStream)inputStream);
                            IOUtils.closeQuietly(outputStream);
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        IOUtils.closeQuietly(outputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly(outputStream);
            }
        }
    }

    protected void errorResponse(String error, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setStatus(400);
        PrintWriter writer = response.getWriter();
        writer.write("<html><title>Error</title><body>" + error + "</body></html>");
        writer.flush();
        LOGGER.warn("Error processing response: " + error);
    }

    protected void copyResponseStream(InputStream inputStream, OutputStream outputStream, String id, long contentLength) throws IOException {
        long contentWritten = 0L;
        try {
            int bufferRead;
            byte[] buffer = new byte[8192];
            while ((bufferRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bufferRead);
                contentWritten += (long)bufferRead;
            }
        }
        catch (IOException e) {
            String exceptionMessage = contentLength > -1L ? String.format("Error writing response to output stream for id %s, %d of %d bytes written", id, contentWritten, contentLength) : String.format("Error writing response to output stream for id %s, %d bytes written", id, contentWritten);
            throw new IOException(exceptionMessage, e);
        }
        LOGGER.info("{} bytes written in response to id {}", (Object)contentWritten, (Object)id);
    }

    protected void copyResponseAsXML(InputStream inputStream, OutputStream outputStream, boolean indent, String id) throws IOException {
        try {
            XMLUtil.copyXML((InputStream)inputStream, (OutputStream)outputStream, (boolean)indent);
        }
        catch (IOException e) {
            throw new IOException("Error writing XML response for id " + id, e);
        }
    }

    private void logException(Exception exception) {
        StringBuilder errorBuilder = new StringBuilder(exception.getMessage());
        Throwable cause = RetrieveResultServlet.getRootCause(exception);
        if (cause != exception) {
            errorBuilder.append(", exception message: ").append(cause.getMessage());
        }
        LOGGER.error(errorBuilder.toString());
    }

    public static Throwable getRootCause(Throwable t) {
        return t.getCause() == null ? t : RetrieveResultServlet.getRootCause(t.getCause());
    }

    public boolean isIDValid(String id) {
        if (id.length() <= 36) {
            try {
                UUID checkUUID = UUID.fromString(id);
                return checkUUID.toString().equals(id);
            }
            catch (Exception e) {
                return false;
            }
        }
        String uuidPartOne = id.substring(0, 36);
        String uuidPartTwo = id.substring(id.length() - 36, id.length());
        return this.isUUIDValid(uuidPartOne) && this.isUUIDValid(uuidPartTwo);
    }

    public boolean isUUIDValid(String uuid) {
        try {
            UUID checkUUID = UUID.fromString(uuid);
            return checkUUID.toString().equals(uuid);
        }
        catch (Exception e) {
            return false;
        }
    }
}

