/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server.request;

import java.util.ArrayList;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.request.Request;
import org.n52.wps.server.response.CapabilitiesResponse;
import org.n52.wps.server.response.Response;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CapabilitiesRequest
extends Request {
    private static final String ACCEPT_VERSIONS_ELEMENT_NAME = "AcceptVersions";
    private static final String PARAM_SERVICE = "service";
    private static final String PARAM_VERSION = "version";
    private static final Object REQUEST_DOC = "document";

    public CapabilitiesRequest(CaseInsensitiveMap ciMap) throws ExceptionReport {
        super(ciMap);
        String[] providedAcceptVersions;
        String providedAcceptVersionsString = Request.getMapValue("acceptversions", ciMap, false);
        if (providedAcceptVersionsString != null && (providedAcceptVersions = providedAcceptVersionsString.split(",")) != null) {
            this.map.put((Object)PARAM_VERSION, (Object)providedAcceptVersions);
        }
    }

    public CapabilitiesRequest(Document doc) throws ExceptionReport {
        super(doc);
        this.map = new CaseInsensitiveMap();
        Node fc = this.doc.getFirstChild();
        String name = fc.getNodeName();
        this.map.put(REQUEST_DOC, (Object)name);
        Node serviceItem = fc.getAttributes().getNamedItem(PARAM_SERVICE);
        if (serviceItem != null) {
            String service = serviceItem.getNodeValue();
            String[] serviceArray = new String[]{service};
            this.map.put((Object)PARAM_SERVICE, (Object)serviceArray);
        }
        NodeList nList = doc.getFirstChild().getChildNodes();
        ArrayList<String> versionList = new ArrayList<String>();
        int i = 0;
        while (i < nList.getLength()) {
            Node n = nList.item(i);
            if (n.getLocalName() != null && n.getLocalName().equalsIgnoreCase(ACCEPT_VERSIONS_ELEMENT_NAME)) {
                NodeList nList2 = n.getChildNodes();
                int j = 0;
                while (j < nList2.getLength()) {
                    Node n2 = nList2.item(j);
                    if (n2.getLocalName() != null && n2.getLocalName().equalsIgnoreCase(PARAM_VERSION)) {
                        versionList.add(n2.getTextContent());
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        if (!versionList.isEmpty()) {
            this.map.put((Object)PARAM_VERSION, (Object)versionList.toArray(new String[versionList.size()]));
        }
    }

    @Override
    public boolean validate() throws ExceptionReport {
        String services = this.getMapValue(PARAM_SERVICE, true);
        if (!services.equalsIgnoreCase("wps")) {
            throw new ExceptionReport("Parameter <service> is not correct, expected: WPS , got: " + services, "InvalidParameterValue", PARAM_SERVICE);
        }
        String[] versions = this.getMapArray(PARAM_VERSION, false);
        if (!this.requireVersion("1.0.0", false)) {
            throw new ExceptionReport("Requested versions are not supported, you requested: " + Request.accumulateString(versions), "VersionNegotiationFailed", PARAM_VERSION);
        }
        return true;
    }

    @Override
    public Response call() throws ExceptionReport {
        this.validate();
        LOGGER.info("Handled GetCapabilitiesRequest successfully!");
        return new CapabilitiesResponse(this);
    }

    @Override
    public Object getAttachedResult() {
        return null;
    }
}

