/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server.request;

import com.google.common.primitives.Doubles;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import net.opengis.ows.x11.BoundingBoxType;
import net.opengis.ows.x11.DomainMetadataType;
import net.opengis.ows.x11.RangeType;
import net.opengis.ows.x11.ValueType;
import net.opengis.wps.x100.ComplexDataDescriptionType;
import net.opengis.wps.x100.ComplexDataType;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.InputReferenceType;
import net.opengis.wps.x100.InputType;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.n52.wps.commons.XMLUtil;
import org.n52.wps.io.BasicXMLTypeFactory;
import org.n52.wps.io.IParser;
import org.n52.wps.io.ParserFactory;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.bbox.BoundingBoxData;
import org.n52.wps.io.data.binding.literal.AbstractLiteralDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralByteBinding;
import org.n52.wps.io.data.binding.literal.LiteralDoubleBinding;
import org.n52.wps.io.data.binding.literal.LiteralFloatBinding;
import org.n52.wps.io.data.binding.literal.LiteralIntBinding;
import org.n52.wps.io.data.binding.literal.LiteralLongBinding;
import org.n52.wps.io.data.binding.literal.LiteralShortBinding;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.RepositoryManager;
import org.n52.wps.server.handler.DataInputInterceptors;
import org.n52.wps.server.request.strategy.ReferenceInputStream;
import org.n52.wps.server.request.strategy.ReferenceStrategyRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class InputHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputHandler.class);
    private static final BigInteger INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private Map<String, List<IData>> inputData = new HashMap<String, List<IData>>();
    private ProcessDescriptionType processDesc;
    private String algorithmIdentifier = null;

    private InputHandler(Builder builder) throws ExceptionReport {
        this.algorithmIdentifier = builder.algorithmIdentifier;
        this.processDesc = RepositoryManager.getInstance().getProcessDescription(this.algorithmIdentifier);
        if (this.processDesc == null) {
            throw new ExceptionReport("Error while accessing the process description for " + this.algorithmIdentifier, "InvalidParameterValue");
        }
        Map<String, DataInputInterceptors.InterceptorInstance> inputInterceptors = this.resolveInputInterceptors(this.algorithmIdentifier);
        InputType[] inputTypeArray = builder.inputs;
        int n = builder.inputs.length;
        int n2 = 0;
        while (n2 < n) {
            DataInputInterceptors.InterceptorInstance interceptor;
            List<IData> result;
            InputType input = inputTypeArray[n2];
            String inputId = input.getIdentifier().getStringValue().trim();
            if (inputInterceptors.containsKey(inputId) && (result = (interceptor = inputInterceptors.get(inputId)).applyInterception(input)) != null && !result.isEmpty()) {
                this.inputData.put(inputId, result);
            } else if (input.getData() != null) {
                if (input.getData().getComplexData() != null) {
                    this.handleComplexData(input, inputId);
                } else if (input.getData().getLiteralData() != null) {
                    this.handleLiteralData(input);
                } else if (input.getData().getBoundingBoxData() != null) {
                    this.handleBBoxValue(input);
                }
            } else if (input.getReference() != null) {
                this.handleComplexValueReference(input);
            } else {
                throw new ExceptionReport("Error while accessing the inputValue: " + inputId, "InvalidParameterValue");
            }
            ++n2;
        }
    }

    Map<String, DataInputInterceptors.InterceptorInstance> resolveInputInterceptors(String algorithmClassName) {
        Class<?> clazz;
        HashMap<String, DataInputInterceptors.InterceptorInstance> result = new HashMap<String, DataInputInterceptors.InterceptorInstance>();
        try {
            clazz = Class.forName(algorithmClassName, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Could not find class {}", (Object)algorithmClassName);
            return result;
        }
        DataInputInterceptors.DataInputInterceptorImplementations annotation = clazz.getAnnotation(DataInputInterceptors.DataInputInterceptorImplementations.class);
        if (annotation != null) {
            Class<?> interceptorClazz;
            try {
                interceptorClazz = Class.forName(annotation.value());
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Could not find class " + annotation.value(), (Throwable)e);
                return result;
            }
            if (DataInputInterceptors.class.isAssignableFrom(interceptorClazz)) {
                DataInputInterceptors instance;
                try {
                    instance = (DataInputInterceptors)interceptorClazz.newInstance();
                }
                catch (InstantiationException e) {
                    LOGGER.warn("Could not instantiate class " + interceptorClazz, (Throwable)e);
                    return result;
                }
                catch (IllegalAccessException e) {
                    LOGGER.warn("Could not access class " + interceptorClazz, (Throwable)e);
                    return result;
                }
                return instance.getInterceptors();
            }
        }
        return result;
    }

    InputDescriptionType getInputReferenceDescriptionType(String inputId) {
        InputDescriptionType[] inputDescriptionTypeArray = this.processDesc.getDataInputs().getInputArray();
        int n = inputDescriptionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            InputDescriptionType tempDesc = inputDescriptionTypeArray[n2];
            if (inputId.equals(tempDesc.getIdentifier().getStringValue())) {
                return tempDesc;
            }
            ++n2;
        }
        return null;
    }

    ComplexDataDescriptionType getNonDefaultFormat(InputDescriptionType inputRefDesc, String dataMimeType, String dataSchema, String dataEncoding) {
        ComplexDataDescriptionType[] formats;
        if (inputRefDesc.getComplexData() == null) {
            return null;
        }
        ComplexDataDescriptionType[] complexDataDescriptionTypeArray = formats = inputRefDesc.getComplexData().getSupported().getFormatArray();
        int n = formats.length;
        int n2 = 0;
        while (n2 < n) {
            ComplexDataDescriptionType potentialFormat = complexDataDescriptionTypeArray[n2];
            String pFormatSchema = potentialFormat.getSchema();
            String pFormatEncoding = potentialFormat.getEncoding();
            if (potentialFormat.getMimeType().equalsIgnoreCase(dataMimeType)) {
                if (dataSchema != null && dataEncoding == null && dataSchema.equalsIgnoreCase(pFormatSchema)) {
                    return potentialFormat;
                }
                if (dataSchema == null && dataEncoding != null && dataEncoding.equalsIgnoreCase(pFormatEncoding)) {
                    return potentialFormat;
                }
                if (dataSchema != null && dataEncoding != null && dataSchema.equalsIgnoreCase(pFormatSchema) && dataEncoding.equalsIgnoreCase(pFormatEncoding)) {
                    return potentialFormat;
                }
                if (dataSchema == null && dataEncoding == null) {
                    return potentialFormat;
                }
            }
            ++n2;
        }
        return null;
    }

    protected String getComplexValueNodeString(Node complexValueNode) {
        String complexValue;
        try {
            complexValue = XMLUtil.nodeToString((Node)complexValueNode);
            complexValue = complexValue.substring(complexValue.indexOf(">") + 1, complexValue.lastIndexOf("</"));
        }
        catch (TransformerFactoryConfigurationError e1) {
            throw new TransformerFactoryConfigurationError("Could not parse inline data. Reason " + e1);
        }
        catch (TransformerException e1) {
            throw new TransformerFactoryConfigurationError("Could not parse inline data. Reason " + e1);
        }
        return complexValue;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleComplexData(InputType input, String inputId) throws ExceptionReport {
        void var17_35;
        ComplexDataDescriptionType format = null;
        String dataMimeType = null;
        String formatSchema = null;
        String formatEncoding = null;
        String potentialFormatSchema = null;
        String potentialFormatEncoding = null;
        InputDescriptionType inputReferenceDesc = this.getInputReferenceDescriptionType(inputId);
        if (inputReferenceDesc == null) {
            LOGGER.debug("Input cannot be found in description for " + this.processDesc.getIdentifier().getStringValue() + "," + inputId);
        }
        ComplexDataType data = input.getData().getComplexData();
        String dataSchema = data.getSchema();
        dataMimeType = data.getMimeType();
        String dataEncoding = data.getEncoding();
        Node complexValueNode = input.getData().getComplexData().getDomNode();
        String complexValue = this.getComplexValueNodeString(complexValueNode);
        if (data.isSetMimeType() && dataMimeType != null) {
            format = this.findComplexDataDescriptionType(inputReferenceDesc, dataMimeType, dataSchema, dataEncoding, potentialFormatSchema, potentialFormatEncoding);
            if (format == null) {
                throw new ExceptionReport("Could not determine intput format", "InvalidParameterValue");
            }
            dataMimeType = format.getMimeType();
            if (format.isSetEncoding()) {
                formatEncoding = format.getEncoding();
            }
            if (format.isSetSchema()) {
                formatSchema = format.getSchema();
            }
        } else if (StringUtils.isBlank((String)dataMimeType) && !data.isSetEncoding() && !data.isSetSchema()) {
            formatSchema = inputReferenceDesc.getComplexData().getDefault().getFormat().getSchema();
            dataMimeType = inputReferenceDesc.getComplexData().getDefault().getFormat().getMimeType();
            formatEncoding = inputReferenceDesc.getComplexData().getDefault().getFormat().getEncoding();
        } else if (StringUtils.isBlank((String)dataMimeType)) {
            if (data.isSetEncoding() && !data.isSetSchema()) {
                void var17_25;
                int foundCount = 0;
                String defaultEncoding = inputReferenceDesc.getComplexData().getDefault().getFormat().getEncoding();
                Object var17_21 = null;
                String foundEncoding = null;
                if (defaultEncoding.equalsIgnoreCase(data.getEncoding())) {
                    foundEncoding = inputReferenceDesc.getComplexData().getDefault().getFormat().getEncoding();
                    ComplexDataDescriptionType complexDataDescriptionType = inputReferenceDesc.getComplexData().getDefault().getFormat();
                    ++foundCount;
                } else {
                    ComplexDataDescriptionType[] formats;
                    ComplexDataDescriptionType[] complexDataDescriptionTypeArray = formats = inputReferenceDesc.getComplexData().getSupported().getFormatArray();
                    int n = formats.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ComplexDataDescriptionType tempFormat = complexDataDescriptionTypeArray[n2];
                        if (tempFormat.getEncoding().equalsIgnoreCase(data.getEncoding())) {
                            foundEncoding = tempFormat.getEncoding();
                            ComplexDataDescriptionType complexDataDescriptionType = tempFormat;
                            ++foundCount;
                        }
                        ++n2;
                    }
                }
                if (foundCount != 1) throw new ExceptionReport("Request incomplete. Could not determine a suitable input format based on the given input [mime Type missing and given encoding not unique]", "MissingParameterValue");
                formatEncoding = foundEncoding;
                dataMimeType = var17_25.getMimeType();
                if (var17_25.isSetSchema()) {
                    formatSchema = var17_25.getSchema();
                }
            } else if (data.isSetSchema() && !data.isSetEncoding()) {
                void var17_29;
                ComplexDataDescriptionType schemaFormat = null;
                String defaultSchema = inputReferenceDesc.getComplexData().getDefault().getFormat().getSchema();
                boolean bl = false;
                String foundSchema = null;
                if (!StringUtils.isBlank((String)defaultSchema) && defaultSchema.equalsIgnoreCase(data.getSchema())) {
                    void var17_27;
                    foundSchema = inputReferenceDesc.getComplexData().getDefault().getFormat().getSchema();
                    schemaFormat = inputReferenceDesc.getComplexData().getDefault().getFormat();
                    ++var17_27;
                } else {
                    ComplexDataDescriptionType[] formats;
                    ComplexDataDescriptionType[] complexDataDescriptionTypeArray = formats = inputReferenceDesc.getComplexData().getSupported().getFormatArray();
                    int n = formats.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ComplexDataDescriptionType tempFormat = complexDataDescriptionTypeArray[n3];
                        if (tempFormat.isSetSchema() && tempFormat.getSchema().equalsIgnoreCase(data.getSchema())) {
                            void var17_28;
                            foundSchema = tempFormat.getSchema();
                            schemaFormat = tempFormat;
                            ++var17_28;
                        }
                        ++n3;
                    }
                }
                if (var17_29 != true) throw new ExceptionReport("Request incomplete. Could not determine a suitable input format based on the given input [mime Type missing and given schema not unique]", "MissingParameterValue");
                formatSchema = foundSchema;
                dataMimeType = schemaFormat.getMimeType();
                if (schemaFormat.isSetEncoding()) {
                    formatEncoding = schemaFormat.getEncoding();
                }
            } else if (data.isSetEncoding() && data.isSetSchema()) {
                String defaultEncoding = inputReferenceDesc.getComplexData().getDefault().getFormat().getEncoding();
                ArrayList<ComplexDataDescriptionType> foundEncodingList = new ArrayList<ComplexDataDescriptionType>();
                if (defaultEncoding.equalsIgnoreCase(data.getEncoding())) {
                    foundEncodingList.add(inputReferenceDesc.getComplexData().getDefault().getFormat());
                } else {
                    ComplexDataDescriptionType[] complexDataDescriptionTypeArray;
                    ComplexDataDescriptionType[] complexDataDescriptionTypeArray2 = complexDataDescriptionTypeArray = inputReferenceDesc.getComplexData().getSupported().getFormatArray();
                    int tempFormat = complexDataDescriptionTypeArray.length;
                    int formats = 0;
                    while (formats < tempFormat) {
                        ComplexDataDescriptionType tempFormat2 = complexDataDescriptionTypeArray2[formats];
                        if (tempFormat2.getEncoding().equalsIgnoreCase(data.getEncoding())) {
                            foundEncodingList.add(tempFormat2);
                        }
                        ++formats;
                    }
                    ArrayList<ComplexDataDescriptionType> foundSchemaList = new ArrayList<ComplexDataDescriptionType>();
                    String defaultSchema = inputReferenceDesc.getComplexData().getDefault().getFormat().getSchema();
                    if (defaultSchema != null && defaultSchema.equalsIgnoreCase(data.getSchema())) {
                        foundSchemaList.add(inputReferenceDesc.getComplexData().getDefault().getFormat());
                    } else {
                        ComplexDataDescriptionType[] complexDataDescriptionTypeArray3;
                        ComplexDataDescriptionType[] complexDataDescriptionTypeArray4 = complexDataDescriptionTypeArray3 = inputReferenceDesc.getComplexData().getSupported().getFormatArray();
                        int n = complexDataDescriptionTypeArray3.length;
                        int n4 = 0;
                        while (n4 < n) {
                            ComplexDataDescriptionType tempFormat3 = complexDataDescriptionTypeArray4[n4];
                            if (tempFormat3.getSchema() != null && tempFormat3.getSchema().equalsIgnoreCase(data.getSchema())) {
                                foundSchemaList.add(tempFormat3);
                            }
                            ++n4;
                        }
                    }
                    ComplexDataDescriptionType foundCommonFormat = null;
                    for (ComplexDataDescriptionType encodingFormat : foundEncodingList) {
                        for (ComplexDataDescriptionType schemaFormat : foundSchemaList) {
                            if (!encodingFormat.equals(schemaFormat)) continue;
                            foundCommonFormat = encodingFormat;
                        }
                    }
                    if (foundCommonFormat == null) throw new ExceptionReport("Request incomplete. Could not determine a suitable input format based on the given input [mime Type missing and given encoding and schema are not unique]", "MissingParameterValue");
                    dataMimeType = foundCommonFormat.getMimeType();
                    if (foundCommonFormat.isSetEncoding()) {
                        formatEncoding = foundCommonFormat.getEncoding();
                    }
                    if (foundCommonFormat.isSetSchema()) {
                        formatSchema = foundCommonFormat.getSchema();
                    }
                }
            }
        }
        IParser parser = null;
        try {
            LOGGER.debug("Looking for matching Parser ... schema: " + formatSchema + " mimeType: " + dataMimeType + " encoding: " + formatEncoding);
            Class algorithmInput = RepositoryManager.getInstance().getInputDataTypeForAlgorithm(this.algorithmIdentifier, inputId);
            parser = ParserFactory.getInstance().getParser(formatSchema, dataMimeType, formatEncoding, algorithmInput);
        }
        catch (RuntimeException e) {
            throw new ExceptionReport("Error obtaining input data", "NoApplicableCode", (Throwable)e);
        }
        if (parser == null) {
            throw new ExceptionReport("Error. No applicable parser found for " + formatSchema + "," + dataMimeType + "," + formatEncoding, "NoApplicableCode");
        }
        IData collection = this.parseComplexValue(formatEncoding, complexValue, dataMimeType, formatSchema, parser);
        ArrayList arrayList = new ArrayList();
        if (this.inputData.containsKey(inputId)) {
            List<IData> list = this.inputData.get(inputId);
        }
        var17_35.add(collection);
        this.inputData.put(inputId, (List<IData>)var17_35);
    }

    protected ComplexDataDescriptionType findComplexDataDescriptionType(InputDescriptionType inputReferenceDesc, String dataMimeType, String dataSchema, String dataEncoding, String potentialFormatSchema, String potentialFormatEncoding) {
        ComplexDataDescriptionType result = null;
        boolean canUseDefault = false;
        String defaultMimeType = inputReferenceDesc.getComplexData().getDefault().getFormat().getMimeType();
        System.out.println("FindComplexDataDescriptionType->Default mime-type: " + defaultMimeType + " vs " + dataMimeType);
        if (defaultMimeType.equalsIgnoreCase(dataMimeType)) {
            ComplexDataDescriptionType potentialFormat = inputReferenceDesc.getComplexData().getDefault().getFormat();
            System.out.println("FindComplexDataDescriptionType->data schema: " + dataSchema + " data encoding " + dataEncoding);
            System.out.println("FindComplexDataDescriptionType->potential format schema : " + potentialFormatSchema);
            if (dataSchema != null && dataSchema.trim().length() == 0) {
                dataSchema = null;
            }
            if (dataSchema != null && dataEncoding == null) {
                if (dataSchema.equalsIgnoreCase(potentialFormatSchema)) {
                    canUseDefault = true;
                    result = potentialFormat;
                }
            } else if (dataSchema != null && dataEncoding != null) {
                if (dataSchema.equalsIgnoreCase(potentialFormatSchema) && dataEncoding.equalsIgnoreCase(potentialFormatEncoding)) {
                    canUseDefault = true;
                    result = potentialFormat;
                }
            } else if (dataSchema == null && dataEncoding != null) {
                if (dataEncoding.equalsIgnoreCase(potentialFormatEncoding)) {
                    canUseDefault = true;
                    result = potentialFormat;
                }
            } else {
                canUseDefault = true;
                result = potentialFormat;
            }
        }
        System.out.println("FindComplexDataDescriptionType->canUseDefault: " + canUseDefault);
        System.out.println("FindComplexDataDescriptionType->result: " + result);
        if (!canUseDefault) {
            result = this.getNonDefaultFormat(inputReferenceDesc, dataMimeType, dataSchema, dataEncoding);
            System.out.println("FindComplexDataDescriptionType->non default schema: " + result);
        }
        return result;
    }

    protected IData parseComplexValue(String formatEncoding, String complexValue, String dataMimeType, String formatSchema, IParser parser) throws ExceptionReport {
        IData idata;
        String complexValueCopy = complexValue.toString();
        if (StringUtils.isBlank((String)formatEncoding) || formatEncoding.equalsIgnoreCase("UTF-8")) {
            try {
                if (!complexValueCopy.contains("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"")) {
                    complexValueCopy = complexValueCopy.replace("xsi:schemaLocation", "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation");
                }
                idata = parser.parse((InputStream)new ByteArrayInputStream(complexValueCopy.getBytes()), dataMimeType, formatSchema);
            }
            catch (RuntimeException e) {
                throw new ExceptionReport("Error occured, while XML parsing", "NoApplicableCode", (Throwable)e);
            }
        } else if (formatEncoding.equalsIgnoreCase("base64")) {
            idata = this.getBase64EncodedData(complexValue, parser, dataMimeType, formatSchema);
        } else {
            throw new ExceptionReport("Unable to generate encoding " + formatEncoding, "NoApplicableCode");
        }
        return idata;
    }

    protected IData getBase64EncodedData(String complexValue, IParser parser, String dataMimeType, String formatSchema) throws ExceptionReport {
        IData iData;
        File f = null;
        String complexValueCopy = complexValue.toString();
        try {
            f = File.createTempFile("wps" + UUID.randomUUID(), "tmp");
            if (complexValueCopy.startsWith("<xml-fragment")) {
                int startIndex = complexValueCopy.indexOf(">");
                complexValueCopy = complexValueCopy.substring(startIndex + 1);
                int endIndex = complexValueCopy.indexOf("</xml-fragment");
                complexValueCopy = complexValueCopy.substring(0, endIndex);
            }
            FileUtils.write((File)f, (CharSequence)complexValueCopy);
            iData = parser.parseBase64((InputStream)new FileInputStream(f), dataMimeType, formatSchema);
        }
        catch (IOException e) {
            try {
                throw new ExceptionReport("Error occured, while Base64 extracting", "NoApplicableCode", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(f);
                System.gc();
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)f);
        System.gc();
        return iData;
    }

    private void handleLiteralData(InputType input) throws ExceptionReport {
        String inputID = input.getIdentifier().getStringValue();
        String parameter = input.getData().getLiteralData().getStringValue();
        String xmlDataType = input.getData().getLiteralData().getDataType();
        String uom = input.getData().getLiteralData().getUom();
        InputDescriptionType inputDesc = null;
        InputDescriptionType[] inputDescriptionTypeArray = this.processDesc.getDataInputs().getInputArray();
        int n = inputDescriptionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            InputDescriptionType tempDesc = inputDescriptionTypeArray[n2];
            if (inputID.equals(tempDesc.getIdentifier().getStringValue())) {
                inputDesc = tempDesc;
                break;
            }
            ++n2;
        }
        if (xmlDataType == null) {
            DomainMetadataType dataType = inputDesc.getLiteralData().getDataType();
            String string = xmlDataType = dataType != null ? dataType.getReference() : null;
        }
        if (xmlDataType == null) {
            xmlDataType = "xs:string";
        } else if (xmlDataType.contains("http://www.w3.org/TR/xmlschema-2#")) {
            xmlDataType = xmlDataType.replace("http://www.w3.org/TR/xmlschema-2#", "xs:");
        }
        xmlDataType = xmlDataType.toLowerCase();
        IData parameterObj = null;
        try {
            parameterObj = BasicXMLTypeFactory.getBasicJavaObject((String)xmlDataType, (String)parameter);
        }
        catch (RuntimeException e) {
            throw new ExceptionReport("The passed parameterValue: " + parameter + " for input " + inputID + " is not of type: " + xmlDataType, "InvalidParameterValue");
        }
        if (inputDesc.getLiteralData().isSetAllowedValues() && !inputDesc.getLiteralData().isSetAnyValue()) {
            ValueType[] allowedValues = inputDesc.getLiteralData().getAllowedValues().getValueArray();
            boolean foundAllowedValue = false;
            ValueType[] valueTypeArray = allowedValues;
            int n3 = allowedValues.length;
            int n4 = 0;
            while (n4 < n3) {
                ValueType allowedValue = valueTypeArray[n4];
                if (input.getData().getLiteralData().getStringValue().equals(allowedValue.getStringValue())) {
                    foundAllowedValue = true;
                }
                ++n4;
            }
            RangeType[] allowedRanges = new RangeType[]{};
            if (parameterObj instanceof LiteralIntBinding || parameterObj instanceof LiteralDoubleBinding || parameterObj instanceof LiteralShortBinding || parameterObj instanceof LiteralFloatBinding || parameterObj instanceof LiteralLongBinding || parameterObj instanceof LiteralByteBinding) {
                RangeType[] rangeTypeArray = allowedRanges = inputDesc.getLiteralData().getAllowedValues().getRangeArray();
                int n5 = allowedRanges.length;
                n3 = 0;
                while (n3 < n5) {
                    RangeType allowedRange = rangeTypeArray[n3];
                    foundAllowedValue = this.checkRange(parameterObj, allowedRange);
                    ++n3;
                }
            }
            if (!(foundAllowedValue || allowedValues.length == 0 && allowedRanges.length == 0)) {
                throw new ExceptionReport("Input with ID " + inputID + " does not contain an allowed value. See ProcessDescription.", "InvalidParameterValue");
            }
        }
        if (parameterObj == null) {
            throw new ExceptionReport("XML datatype as LiteralParameter is not supported by the server: dataType " + xmlDataType, "InvalidParameterValue");
        }
        if (uom != null && !uom.equals("") && parameterObj instanceof AbstractLiteralDataBinding) {
            ((AbstractLiteralDataBinding)parameterObj).setUnitOfMeasurement(uom);
        }
        if (this.inputData.containsKey(inputID)) {
            List<IData> list = this.inputData.get(inputID);
            list.add(parameterObj);
        } else {
            ArrayList<IData> list = new ArrayList<IData>();
            list.add(parameterObj);
            this.inputData.put(inputID, list);
        }
    }

    private boolean checkRange(IData parameterObj, RangeType allowedRange) {
        List l = allowedRange.getRangeClosure();
        if (l == null || l.isEmpty() || l.get(0).equals("closed")) {
            if (parameterObj instanceof LiteralIntBinding) {
                int min = new Integer(allowedRange.getMinimumValue().getStringValue());
                int max = new Integer(allowedRange.getMaximumValue().getStringValue());
                if ((Integer)parameterObj.getPayload() >= min && (Integer)parameterObj.getPayload() <= max) {
                    return true;
                }
            }
            if (parameterObj instanceof LiteralDoubleBinding) {
                Double min = new Double(allowedRange.getMinimumValue().getStringValue());
                Double max = new Double(allowedRange.getMaximumValue().getStringValue());
                if ((Double)parameterObj.getPayload() >= min && (Double)parameterObj.getPayload() <= max) {
                    return true;
                }
            }
            if (parameterObj instanceof LiteralShortBinding) {
                Short min = new Short(allowedRange.getMinimumValue().getStringValue());
                Short max = new Short(allowedRange.getMaximumValue().getStringValue());
                if ((Short)parameterObj.getPayload() >= min && (Short)parameterObj.getPayload() <= max) {
                    return true;
                }
            }
            if (parameterObj instanceof LiteralFloatBinding) {
                Float min = new Float(allowedRange.getMinimumValue().getStringValue());
                Float max = new Float(allowedRange.getMaximumValue().getStringValue());
                if (((Float)parameterObj.getPayload()).floatValue() >= min.floatValue() && ((Float)parameterObj.getPayload()).floatValue() <= max.floatValue()) {
                    return true;
                }
            }
            if (parameterObj instanceof LiteralLongBinding) {
                Long min = new Long(allowedRange.getMinimumValue().getStringValue());
                Long max = new Long(allowedRange.getMaximumValue().getStringValue());
                if ((Long)parameterObj.getPayload() >= min && (Long)parameterObj.getPayload() <= max) {
                    return true;
                }
            }
            if (parameterObj instanceof LiteralByteBinding) {
                Byte min = new Byte(allowedRange.getMinimumValue().getStringValue());
                Byte max = new Byte(allowedRange.getMaximumValue().getStringValue());
                if ((Byte)parameterObj.getPayload() >= min && (Byte)parameterObj.getPayload() <= max) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void handleComplexValueReference(InputType input) throws ExceptionReport {
        String defaultMimeType;
        ComplexDataDescriptionType format;
        String inputID = input.getIdentifier().getStringValue();
        ReferenceStrategyRegister register = ReferenceStrategyRegister.getInstance();
        ReferenceInputStream stream = register.resolveReference(input);
        String dataURLString = input.getReference().getHref();
        LOGGER.debug("Loading data from: " + dataURLString);
        InputDescriptionType inputPD = null;
        InputDescriptionType[] inputDescriptionTypeArray = this.processDesc.getDataInputs().getInputArray();
        int n = inputDescriptionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            InputDescriptionType tempDesc = inputDescriptionTypeArray[n2];
            if (inputID.equals(tempDesc.getIdentifier().getStringValue())) {
                inputPD = tempDesc;
                break;
            }
            ++n2;
        }
        if (inputPD == null) {
            LOGGER.debug("Input cannot be found in description for " + this.processDesc.getIdentifier().getStringValue() + "," + inputID);
            throw new RuntimeException("Input cannot be found in description for " + this.processDesc.getIdentifier().getStringValue() + "," + inputID);
        }
        String schema = null;
        String mimeType = null;
        String encoding = null;
        InputReferenceType referenceData = input.getReference();
        if (referenceData.isSetMimeType() && referenceData.getMimeType() != null) {
            mimeType = referenceData.getMimeType();
            format = null;
            defaultMimeType = inputPD.getComplexData().getDefault().getFormat().getMimeType();
            boolean canUseDefault = false;
            if (defaultMimeType.equalsIgnoreCase(mimeType)) {
                ComplexDataDescriptionType potentialFormat = inputPD.getComplexData().getDefault().getFormat();
                if (referenceData.getSchema() != null && referenceData.getEncoding() == null && referenceData.getSchema().equalsIgnoreCase(potentialFormat.getSchema())) {
                    canUseDefault = true;
                    format = potentialFormat;
                }
                if (referenceData.getSchema() == null && referenceData.getEncoding() != null && referenceData.getEncoding().equalsIgnoreCase(potentialFormat.getEncoding())) {
                    canUseDefault = true;
                    format = potentialFormat;
                }
                if (referenceData.getSchema() != null && referenceData.getEncoding() != null && referenceData.getSchema().equalsIgnoreCase(potentialFormat.getSchema()) && referenceData.getEncoding().equalsIgnoreCase(potentialFormat.getEncoding())) {
                    canUseDefault = true;
                    format = potentialFormat;
                }
                if (referenceData.getSchema() == null && referenceData.getEncoding() == null) {
                    canUseDefault = true;
                    format = potentialFormat;
                }
            }
            if (!canUseDefault) {
                ComplexDataDescriptionType[] formats;
                ComplexDataDescriptionType[] complexDataDescriptionTypeArray = formats = inputPD.getComplexData().getSupported().getFormatArray();
                int n3 = formats.length;
                int n4 = 0;
                while (n4 < n3) {
                    ComplexDataDescriptionType potentialFormat = complexDataDescriptionTypeArray[n4];
                    if (potentialFormat.getMimeType().equalsIgnoreCase(mimeType)) {
                        if (referenceData.getSchema() != null && referenceData.getEncoding() == null && referenceData.getSchema().equalsIgnoreCase(potentialFormat.getSchema())) {
                            format = potentialFormat;
                        }
                        if (referenceData.getSchema() == null && referenceData.getEncoding() != null && referenceData.getEncoding().equalsIgnoreCase(potentialFormat.getEncoding())) {
                            format = potentialFormat;
                        }
                        if (referenceData.getSchema() != null && referenceData.getEncoding() != null && referenceData.getSchema().equalsIgnoreCase(potentialFormat.getSchema()) && referenceData.getEncoding().equalsIgnoreCase(potentialFormat.getEncoding())) {
                            format = potentialFormat;
                        }
                        if (referenceData.getSchema() == null && referenceData.getEncoding() == null) {
                            format = potentialFormat;
                        }
                    }
                    ++n4;
                }
            }
            if (format == null) {
                throw new ExceptionReport("Possibly multiple or none matching generators found for the input data with id = \"" + inputPD.getIdentifier().getStringValue() + "\". Is the MimeType (\"" + referenceData.getMimeType() + "\") correctly set?", "InvalidParameterValue");
            }
            mimeType = format.getMimeType();
            if (format.isSetEncoding()) {
                encoding = format.getEncoding();
            }
            if (format.isSetSchema()) {
                schema = format.getSchema();
            }
        } else {
            mimeType = stream.getMimeType();
            if (mimeType.contains("GML2")) {
                mimeType = "text/xml; subtype=gml/2.0.0";
            }
            if (mimeType.contains("GML3")) {
                mimeType = "text/xml; subtype=gml/3.0.0";
            }
            format = null;
            if (mimeType != null) {
                defaultMimeType = inputPD.getComplexData().getDefault().getFormat().getMimeType();
                boolean canUseDefault = false;
                if (defaultMimeType.equalsIgnoreCase(mimeType)) {
                    ComplexDataDescriptionType potentialFormat = inputPD.getComplexData().getDefault().getFormat();
                    if (referenceData.getSchema() != null && referenceData.getEncoding() == null && referenceData.getSchema().equalsIgnoreCase(potentialFormat.getSchema())) {
                        canUseDefault = true;
                        format = potentialFormat;
                    }
                    if (referenceData.getSchema() == null && referenceData.getEncoding() != null && referenceData.getEncoding().equalsIgnoreCase(potentialFormat.getEncoding())) {
                        canUseDefault = true;
                        format = potentialFormat;
                    }
                    if (referenceData.getSchema() != null && referenceData.getEncoding() != null && referenceData.getSchema().equalsIgnoreCase(potentialFormat.getSchema()) && referenceData.getEncoding().equalsIgnoreCase(potentialFormat.getEncoding())) {
                        canUseDefault = true;
                        format = potentialFormat;
                    }
                    if (referenceData.getSchema() == null && referenceData.getEncoding() == null) {
                        canUseDefault = true;
                        format = potentialFormat;
                    }
                }
                if (!canUseDefault) {
                    ComplexDataDescriptionType[] formats;
                    ComplexDataDescriptionType[] complexDataDescriptionTypeArray = formats = inputPD.getComplexData().getSupported().getFormatArray();
                    int n5 = formats.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ComplexDataDescriptionType potentialFormat = complexDataDescriptionTypeArray[n6];
                        if (!StringUtils.isBlank((String)potentialFormat.getMimeType()) && potentialFormat.getMimeType().equalsIgnoreCase(mimeType)) {
                            if (referenceData.getSchema() != null && referenceData.getEncoding() == null && referenceData.getSchema().equalsIgnoreCase(potentialFormat.getSchema())) {
                                format = potentialFormat;
                            }
                            if (referenceData.getSchema() == null && referenceData.getEncoding() != null && referenceData.getEncoding().equalsIgnoreCase(potentialFormat.getEncoding())) {
                                format = potentialFormat;
                            }
                            if (referenceData.getSchema() != null && referenceData.getEncoding() != null && referenceData.getSchema().equalsIgnoreCase(potentialFormat.getSchema()) && referenceData.getEncoding().equalsIgnoreCase(potentialFormat.getEncoding())) {
                                format = potentialFormat;
                            }
                            if (referenceData.getSchema() == null && referenceData.getEncoding() == null) {
                                format = potentialFormat;
                            }
                        }
                        ++n6;
                    }
                }
                if (format == null) {
                    throw new ExceptionReport("Could not determine input format because none of the supported formats match the given schema (\"" + referenceData.getSchema() + "\") and encoding (\"" + referenceData.getEncoding() + "\"). (A mimetype was not specified)", "InvalidParameterValue");
                }
                mimeType = format.getMimeType();
                if (format.isSetEncoding()) {
                    encoding = format.getEncoding();
                }
                if (format.isSetSchema()) {
                    schema = format.getSchema();
                }
            }
            if (mimeType == null && !referenceData.isSetEncoding() && !referenceData.isSetSchema()) {
                schema = inputPD.getComplexData().getDefault().getFormat().getSchema();
                mimeType = inputPD.getComplexData().getDefault().getFormat().getMimeType();
                encoding = inputPD.getComplexData().getDefault().getFormat().getEncoding();
            } else if (mimeType == null) {
                int n7;
                ComplexDataDescriptionType[] complexDataDescriptionTypeArray;
                if (referenceData.isSetEncoding() && !referenceData.isSetSchema()) {
                    ComplexDataDescriptionType encodingFormat = null;
                    String defaultEncoding = inputPD.getComplexData().getDefault().getFormat().getEncoding();
                    int found = 0;
                    String foundEncoding = null;
                    if (defaultEncoding.equalsIgnoreCase(referenceData.getEncoding())) {
                        foundEncoding = inputPD.getComplexData().getDefault().getFormat().getEncoding();
                        encodingFormat = inputPD.getComplexData().getDefault().getFormat();
                        ++found;
                    } else {
                        ComplexDataDescriptionType[] formats;
                        complexDataDescriptionTypeArray = formats = inputPD.getComplexData().getSupported().getFormatArray();
                        n7 = formats.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            ComplexDataDescriptionType tempFormat = complexDataDescriptionTypeArray[n8];
                            if (tempFormat.getEncoding().equalsIgnoreCase(referenceData.getEncoding())) {
                                foundEncoding = tempFormat.getEncoding();
                                encodingFormat = tempFormat;
                                ++found;
                            }
                            ++n8;
                        }
                    }
                    if (found == 1) {
                        encoding = foundEncoding;
                        mimeType = encodingFormat.getMimeType();
                        if (encodingFormat.isSetSchema()) {
                            schema = encodingFormat.getSchema();
                        }
                    } else {
                        throw new ExceptionReport("Request incomplete. Could not determine a suitable input format based on the given input [mime Type missing and given encoding not unique]", "MissingParameterValue");
                    }
                }
                if (referenceData.isSetSchema() && !referenceData.isSetEncoding()) {
                    ComplexDataDescriptionType schemaFormat = null;
                    String defaultSchema = inputPD.getComplexData().getDefault().getFormat().getSchema();
                    int found = 0;
                    String foundSchema = null;
                    if (defaultSchema.equalsIgnoreCase(referenceData.getSchema())) {
                        foundSchema = inputPD.getComplexData().getDefault().getFormat().getSchema();
                        schemaFormat = inputPD.getComplexData().getDefault().getFormat();
                        ++found;
                    } else {
                        ComplexDataDescriptionType[] formats2;
                        complexDataDescriptionTypeArray = formats2 = inputPD.getComplexData().getSupported().getFormatArray();
                        n7 = formats2.length;
                        int n9 = 0;
                        while (n9 < n7) {
                            ComplexDataDescriptionType tempFormat = complexDataDescriptionTypeArray[n9];
                            if (tempFormat.getEncoding().equalsIgnoreCase(referenceData.getSchema())) {
                                foundSchema = tempFormat.getSchema();
                                schemaFormat = tempFormat;
                                ++found;
                            }
                            ++n9;
                        }
                    }
                    if (found == 1) {
                        schema = foundSchema;
                        mimeType = schemaFormat.getMimeType();
                        if (schemaFormat.isSetEncoding()) {
                            encoding = schemaFormat.getEncoding();
                        }
                    } else {
                        throw new ExceptionReport("Request incomplete. Could not determine a suitable input format based on the given input [mime Type missing and given schema not unique]", "MissingParameterValue");
                    }
                }
                if (referenceData.isSetEncoding() && referenceData.isSetSchema()) {
                    String defaultEncoding = inputPD.getComplexData().getDefault().getFormat().getEncoding();
                    ArrayList<ComplexDataDescriptionType> foundEncodingList = new ArrayList<ComplexDataDescriptionType>();
                    if (defaultEncoding.equalsIgnoreCase(referenceData.getEncoding())) {
                        foundEncodingList.add(inputPD.getComplexData().getDefault().getFormat());
                    } else {
                        ComplexDataDescriptionType[] formats;
                        ComplexDataDescriptionType[] complexDataDescriptionTypeArray2 = formats = inputPD.getComplexData().getSupported().getFormatArray();
                        int tempFormat = formats.length;
                        int formats2 = 0;
                        while (formats2 < tempFormat) {
                            ComplexDataDescriptionType tempFormat2 = complexDataDescriptionTypeArray2[formats2];
                            if (tempFormat2.getEncoding().equalsIgnoreCase(referenceData.getEncoding())) {
                                foundEncodingList.add(tempFormat2);
                            }
                            ++formats2;
                        }
                        ArrayList<ComplexDataDescriptionType> foundSchemaList = new ArrayList<ComplexDataDescriptionType>();
                        String defaultSchema = inputPD.getComplexData().getDefault().getFormat().getSchema();
                        if (defaultSchema.equalsIgnoreCase(referenceData.getSchema())) {
                            foundSchemaList.add(inputPD.getComplexData().getDefault().getFormat());
                        } else {
                            complexDataDescriptionTypeArray = formats = inputPD.getComplexData().getSupported().getFormatArray();
                            n7 = formats.length;
                            int n10 = 0;
                            while (n10 < n7) {
                                ComplexDataDescriptionType tempFormat3 = complexDataDescriptionTypeArray[n10];
                                if (tempFormat3.getEncoding().equalsIgnoreCase(referenceData.getSchema())) {
                                    foundSchemaList.add(tempFormat3);
                                }
                                ++n10;
                            }
                        }
                        ComplexDataDescriptionType foundCommonFormat = null;
                        for (ComplexDataDescriptionType encodingFormat : foundEncodingList) {
                            for (ComplexDataDescriptionType schemaFormat : foundSchemaList) {
                                if (!encodingFormat.equals(schemaFormat)) continue;
                                foundCommonFormat = encodingFormat;
                            }
                        }
                        if (foundCommonFormat != null) {
                            mimeType = foundCommonFormat.getMimeType();
                            if (foundCommonFormat.isSetEncoding()) {
                                encoding = foundCommonFormat.getEncoding();
                            }
                            if (foundCommonFormat.isSetSchema()) {
                                schema = foundCommonFormat.getSchema();
                            }
                        } else {
                            throw new ExceptionReport("Request incomplete. Could not determine a suitable input format based on the given input [mime Type missing and given encoding and schema are not unique]", "MissingParameterValue");
                        }
                    }
                }
            }
        }
        LOGGER.debug("Loading parser for: schema = \"" + schema + "\" , mimetype = \"" + mimeType + "\", encoding = \"" + encoding + "\"");
        IParser parser = null;
        try {
            Class algorithmInputClass = RepositoryManager.getInstance().getInputDataTypeForAlgorithm(this.algorithmIdentifier, inputID);
            if (algorithmInputClass == null) {
                throw new RuntimeException("Could not determine internal input class for input" + inputID);
            }
            LOGGER.info("Looking for matching Parser ... schema: \"" + schema + "\", mimeType: \"" + mimeType + "\", encoding: \"" + encoding + "\"");
            parser = ParserFactory.getInstance().getParser(schema, mimeType, encoding, algorithmInputClass);
            if (parser == null) {
                throw new ExceptionReport("Error. No applicable parser found for schema=\"" + schema + "\", mimeType=\"" + mimeType + "\", encoding=\"" + encoding + "\"", "NoApplicableCode");
            }
        }
        catch (RuntimeException e) {
            throw new ExceptionReport("Error obtaining input data", "NoApplicableCode", (Throwable)e);
        }
        IData parsedInputData = parser.parse((InputStream)stream, mimeType, schema);
        if (this.inputData.containsKey(inputID)) {
            List<IData> list = this.inputData.get(inputID);
            list.add(parsedInputData);
            this.inputData.put(inputID, list);
        } else {
            ArrayList<IData> list = new ArrayList<IData>();
            list.add(parsedInputData);
            this.inputData.put(inputID, list);
        }
    }

    private void handleBBoxValue(InputType input) throws ExceptionReport {
        IData envelope = this.parseBoundingBox(input.getData().getBoundingBoxData());
        List<IData> resultList = this.inputData.get(input.getIdentifier().getStringValue());
        if (resultList == null) {
            resultList = new ArrayList<IData>(1);
            this.inputData.put(input.getIdentifier().getStringValue(), resultList);
        }
        resultList.add(envelope);
    }

    private IData parseBoundingBox(BoundingBoxType bbt) throws ExceptionReport {
        double[] upper;
        double[] lower;
        BigInteger dim = bbt.getDimensions();
        if (dim != null && (dim.compareTo(INT_MAX) > 0 || dim.compareTo(INT_MIN) < 0)) {
            throw new ExceptionReport(String.format("Unsupported BoundingBox dimension %s. Has to be betweeen %s and %s!", dim, INT_MIN, INT_MAX), "InvalidParameterValue");
        }
        try {
            lower = this.parseCoordinate(bbt.getLowerCorner());
        }
        catch (NumberFormatException e) {
            throw new ExceptionReport("Invalid lower corner", "InvalidParameterValue", (Throwable)e);
        }
        try {
            upper = this.parseCoordinate(bbt.getUpperCorner());
        }
        catch (NumberFormatException e) {
            throw new ExceptionReport("Invalid upper corner", "InvalidParameterValue", (Throwable)e);
        }
        if (upper.length != lower.length) {
            throw new ExceptionReport(String.format("Mismatching BoundingBox dimensions: %s vs %s!", upper.length, lower.length), "InvalidParameterValue");
        }
        if (dim != null && lower.length != dim.intValue()) {
            throw new ExceptionReport(String.format("Mismatching BoundingBox dimensions: %s vs %s!", dim.intValue(), lower.length), "InvalidParameterValue");
        }
        return new BoundingBoxData(lower, upper, bbt.getCrs());
    }

    private double[] parseCoordinate(List<?> ordinates) throws NumberFormatException {
        ArrayList<Number> coordinate = new ArrayList<Number>(ordinates.size());
        for (Object o : ordinates) {
            if (o instanceof Number) {
                coordinate.add((Number)o);
                continue;
            }
            coordinate.add(Double.parseDouble(String.valueOf(o)));
        }
        return Doubles.toArray(coordinate);
    }

    public Map<String, List<IData>> getParsedInputData() {
        return this.inputData;
    }

    /* synthetic */ InputHandler(Builder builder, InputHandler inputHandler) throws ExceptionReport {
        this(builder);
    }

    public static class Builder {
        protected InputType[] inputs;
        protected String algorithmIdentifier = null;

        public Builder(InputType[] inputs, String algorithmIdentifier) {
            this.inputs = inputs;
            this.algorithmIdentifier = algorithmIdentifier;
        }

        public Builder inputs(InputType[] val) {
            this.inputs = val;
            return this;
        }

        public Builder algorithmIdentifier(String val) {
            this.algorithmIdentifier = val;
            return this;
        }

        public InputHandler build() throws ExceptionReport {
            return new InputHandler(this, null);
        }
    }
}

