/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server.response;

import com.google.common.primitives.Doubles;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.opengis.ows.x11.BoundingBoxType;
import net.opengis.ows.x11.CodeType;
import net.opengis.ows.x11.LanguageStringType;
import net.opengis.wps.x100.ComplexDataType;
import net.opengis.wps.x100.ExecuteResponseDocument;
import net.opengis.wps.x100.LiteralDataType;
import net.opengis.wps.x100.OutputDataType;
import net.opengis.wps.x100.OutputReferenceType;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.wps.io.BasicXMLTypeFactory;
import org.n52.wps.io.data.IBBOXData;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.literal.AbstractLiteralDataBinding;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.database.DatabaseFactory;
import org.n52.wps.server.database.IDatabase;
import org.n52.wps.server.response.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class OutputDataItem
extends ResponseData {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutputDataItem.class);
    private static final String COMPLEX_DATA_TYPE = "ComplexDataResponse";
    private LanguageStringType title;

    public OutputDataItem(IData obj, String id, String schema, String encoding, String mimeType, LanguageStringType title, String algorithmIdentifier, ProcessDescriptionType description) throws ExceptionReport {
        super(obj, id, schema, encoding, mimeType, algorithmIdentifier, description);
        this.title = title;
    }

    public void updateResponseForInlineComplexData(ExecuteResponseDocument res) throws ExceptionReport {
        OutputDataType output = this.prepareOutput(res);
        this.prepareGenerator();
        ComplexDataType complexData = null;
        try {
            InputStream stream = null;
            if (this.encoding == null || this.encoding.equals("") || this.encoding.equalsIgnoreCase("UTF-8")) {
                stream = this.generator.generateStream(this.obj, this.mimeType, this.schema);
            } else if (this.encoding.equalsIgnoreCase("base64")) {
                stream = this.generator.generateBase64Stream(this.obj, this.mimeType, this.schema);
            } else {
                throw new ExceptionReport("Unable to generate encoding " + this.encoding, "NoApplicableCode");
            }
            complexData = output.addNewData().addNewComplexData();
            if (this.mimeType.contains("xml") || this.mimeType.contains("XML")) {
                complexData.set(XmlObject.Factory.parse((InputStream)stream));
                stream.close();
            } else {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = builder.newDocument();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)stream, (OutputStream)baos);
                stream.close();
                String text = baos.toString();
                baos.close();
                Text dataNode = document.createTextNode(text);
                complexData.set(XmlObject.Factory.parse((Node)dataNode));
            }
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExceptionReport("Could not create Inline Complex Data from the process result", "NoApplicableCode", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExceptionReport("Could not create Inline Complex Data from the process result", "NoApplicableCode", (Throwable)e);
        }
        catch (XmlException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExceptionReport("Could not create Inline Complex Data from the process result. Check encoding (base64 for inline binary data or UTF-8 for XML based data)", "NoApplicableCode", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExceptionReport("Could not create Inline Base64 Complex Data from the process result", "NoApplicableCode", (Throwable)e);
        }
        if (complexData != null) {
            if (this.schema != null) {
                complexData.setSchema(this.schema);
            }
            if (this.encoding != null) {
                complexData.setEncoding(this.encoding);
            }
            if (this.mimeType != null) {
                complexData.setMimeType(this.mimeType);
            }
        }
    }

    public void updateResponseForLiteralData(ExecuteResponseDocument res, String dataTypeReference) {
        String uom;
        OutputDataType output = this.prepareOutput(res);
        String processValue = BasicXMLTypeFactory.getStringRepresentation((String)dataTypeReference, (IData)this.obj);
        LiteralDataType literalData = output.addNewData().addNewLiteralData();
        if (dataTypeReference != null) {
            literalData.setDataType(dataTypeReference);
        }
        literalData.setStringValue(processValue);
        if (this.obj instanceof AbstractLiteralDataBinding && (uom = ((AbstractLiteralDataBinding)this.obj).getUnitOfMeasurement()) != null && !uom.equals("")) {
            literalData.setUom(uom);
        }
    }

    public void updateResponseAsReference(ExecuteResponseDocument res, String reqID, String mimeType) throws ExceptionReport {
        InputStream stream;
        String storeID;
        IDatabase db;
        OutputReferenceType outReference;
        block7: {
            this.prepareGenerator();
            OutputDataType output = this.prepareOutput(res);
            outReference = output.addNewReference();
            if (this.schema != null) {
                outReference.setSchema(this.schema);
            }
            if (this.encoding != null) {
                outReference.setEncoding(this.encoding);
            }
            if (mimeType != null) {
                outReference.setMimeType(mimeType);
            }
            db = DatabaseFactory.getDatabase();
            storeID = String.valueOf(reqID) + this.id;
            try {
                if (this.encoding == null || this.encoding.equals("") || this.encoding.equalsIgnoreCase("UTF-8")) {
                    stream = this.generator.generateStream(this.obj, mimeType, this.schema);
                    break block7;
                }
                if (this.encoding.equalsIgnoreCase("base64")) {
                    stream = this.generator.generateBase64Stream(this.obj, mimeType, this.schema);
                    break block7;
                }
                throw new ExceptionReport("Unable to generate encoding " + this.encoding, "NoApplicableCode");
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new ExceptionReport("Error while generating Complex Data out of the process result", "NoApplicableCode", (Throwable)e);
            }
        }
        String storeReference = db.storeComplexValue(storeID, stream, COMPLEX_DATA_TYPE, mimeType);
        storeReference = storeReference.replace("#", "%23");
        outReference.setHref(storeReference);
        this.mimeType = "text/xml";
    }

    private OutputDataType prepareOutput(ExecuteResponseDocument res) {
        OutputDataType output = res.getExecuteResponse().getProcessOutputs().addNewOutput();
        CodeType identifierCode = output.addNewIdentifier();
        identifierCode.setStringValue(this.id);
        output.setTitle(this.title);
        return output;
    }

    public void updateResponseForBBOXData(ExecuteResponseDocument res, IBBOXData bbox) {
        OutputDataType output = this.prepareOutput(res);
        BoundingBoxType bboxData = output.addNewData().addNewBoundingBoxData();
        if (bbox.getCRS() != null) {
            bboxData.setCrs(bbox.getCRS());
        }
        bboxData.setLowerCorner(Doubles.asList((double[])bbox.getLowerCorner()));
        bboxData.setUpperCorner(Doubles.asList((double[])bbox.getUpperCorner()));
        bboxData.setDimensions(BigInteger.valueOf(bbox.getDimension()));
    }
}

