/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server.response;

import java.util.ArrayList;
import net.opengis.wps.x100.ComplexDataDescriptionType;
import net.opengis.wps.x100.OutputDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.n52.wps.io.GeneratorFactory;
import org.n52.wps.io.IGenerator;
import org.n52.wps.io.data.IData;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.RepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResponseData {
    private static Logger LOGGER = LoggerFactory.getLogger(ResponseData.class);
    protected IData obj = null;
    protected String id;
    protected String schema;
    protected String encoding;
    protected String mimeType;
    protected IGenerator generator = null;
    protected String algorithmIdentifier = null;
    protected ProcessDescriptionType description = null;

    public ResponseData(IData obj, String id, String schema, String encoding, String mimeType, String algorithmIdentifier, ProcessDescriptionType description) throws ExceptionReport {
        OutputDescriptionType[] describeProcessOutput;
        this.obj = obj;
        this.id = id;
        this.algorithmIdentifier = algorithmIdentifier;
        this.description = description;
        this.encoding = encoding;
        OutputDescriptionType outputType = null;
        OutputDescriptionType[] outputDescriptionTypeArray = describeProcessOutput = description.getProcessOutputs().getOutputArray();
        int n = describeProcessOutput.length;
        int n2 = 0;
        while (n2 < n) {
            OutputDescriptionType tempOutputType = outputDescriptionTypeArray[n2];
            if (tempOutputType.getIdentifier().getStringValue().equalsIgnoreCase(id)) {
                outputType = tempOutputType;
            }
            ++n2;
        }
        String finalSchema = null;
        String finalMimeType = null;
        String finalEncoding = null;
        if (outputType.isSetComplexOutput()) {
            if (mimeType != null) {
                ComplexDataDescriptionType format = null;
                String defaultMimeType = outputType.getComplexOutput().getDefault().getFormat().getMimeType();
                boolean canUseDefault = false;
                if (defaultMimeType.equalsIgnoreCase(mimeType)) {
                    ComplexDataDescriptionType potenitalFormat = outputType.getComplexOutput().getDefault().getFormat();
                    if (schema != null && encoding == null && schema.equalsIgnoreCase(potenitalFormat.getSchema())) {
                        canUseDefault = true;
                        format = potenitalFormat;
                    }
                    if (schema == null && encoding != null && encoding.equalsIgnoreCase(potenitalFormat.getEncoding())) {
                        canUseDefault = true;
                        format = potenitalFormat;
                    }
                    if (schema != null && encoding != null && schema.equalsIgnoreCase(potenitalFormat.getSchema()) && encoding.equalsIgnoreCase(potenitalFormat.getEncoding())) {
                        canUseDefault = true;
                        format = potenitalFormat;
                    }
                    if (schema == null && encoding == null) {
                        canUseDefault = true;
                        format = potenitalFormat;
                    }
                }
                if (!canUseDefault) {
                    ComplexDataDescriptionType[] formats;
                    ComplexDataDescriptionType[] complexDataDescriptionTypeArray = formats = outputType.getComplexOutput().getSupported().getFormatArray();
                    int n3 = formats.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ComplexDataDescriptionType potenitalFormat = complexDataDescriptionTypeArray[n4];
                        if (potenitalFormat.getMimeType().equalsIgnoreCase(mimeType)) {
                            if (schema != null && encoding == null && schema.equalsIgnoreCase(potenitalFormat.getSchema())) {
                                format = potenitalFormat;
                            }
                            if (schema == null && encoding != null && (encoding.equalsIgnoreCase(potenitalFormat.getEncoding()) || potenitalFormat.getEncoding() == null)) {
                                format = potenitalFormat;
                            }
                            if (schema != null && encoding != null && schema.equalsIgnoreCase(potenitalFormat.getSchema()) && (encoding.equalsIgnoreCase(potenitalFormat.getEncoding()) || potenitalFormat.getEncoding() == null)) {
                                format = potenitalFormat;
                            }
                            if (schema == null && encoding == null) {
                                format = potenitalFormat;
                            }
                        }
                        ++n4;
                    }
                }
                if (format == null) {
                    throw new ExceptionReport("Could not determine output format", "InvalidParameterValue");
                }
                finalMimeType = format.getMimeType();
                if (format.isSetEncoding()) {
                    finalEncoding = format.getEncoding();
                }
                if (format.isSetSchema()) {
                    finalSchema = format.getSchema();
                }
            } else if (mimeType == null && encoding == null && schema == null) {
                finalSchema = outputType.getComplexOutput().getDefault().getFormat().getSchema();
                finalMimeType = outputType.getComplexOutput().getDefault().getFormat().getMimeType();
                finalEncoding = outputType.getComplexOutput().getDefault().getFormat().getEncoding();
            } else if (mimeType == null) {
                ComplexDataDescriptionType tempFormat;
                int n5;
                int n6;
                ComplexDataDescriptionType[] complexDataDescriptionTypeArray;
                ComplexDataDescriptionType[] formats;
                int found;
                if (encoding != null && schema == null) {
                    ComplexDataDescriptionType encodingFormat = null;
                    String defaultEncoding = outputType.getComplexOutput().getDefault().getFormat().getEncoding();
                    found = 0;
                    String foundEncoding = null;
                    if (defaultEncoding.equalsIgnoreCase(encoding)) {
                        foundEncoding = outputType.getComplexOutput().getDefault().getFormat().getEncoding();
                        encodingFormat = outputType.getComplexOutput().getDefault().getFormat();
                        ++found;
                    } else {
                        complexDataDescriptionTypeArray = formats = outputType.getComplexOutput().getSupported().getFormatArray();
                        n6 = formats.length;
                        n5 = 0;
                        while (n5 < n6) {
                            tempFormat = complexDataDescriptionTypeArray[n5];
                            if (tempFormat.getEncoding().equalsIgnoreCase(encoding)) {
                                foundEncoding = tempFormat.getEncoding();
                                encodingFormat = tempFormat;
                                ++found;
                            }
                            ++n5;
                        }
                    }
                    if (found == 1) {
                        finalEncoding = foundEncoding;
                        finalMimeType = encodingFormat.getMimeType();
                        if (encodingFormat.isSetSchema()) {
                            finalSchema = encodingFormat.getSchema();
                        }
                    } else {
                        throw new ExceptionReport("Request incomplete. Could not determine a suitable input format based on the given input [mime Type missing and given encoding not unique]", "MissingParameterValue");
                    }
                }
                if (schema != null && encoding == null) {
                    ComplexDataDescriptionType schemaFormat = null;
                    String defaultSchema = outputType.getComplexOutput().getDefault().getFormat().getSchema();
                    found = 0;
                    String foundSchema = null;
                    if (defaultSchema.equalsIgnoreCase(schema)) {
                        foundSchema = outputType.getComplexOutput().getDefault().getFormat().getSchema();
                        schemaFormat = outputType.getComplexOutput().getDefault().getFormat();
                        ++found;
                    } else {
                        complexDataDescriptionTypeArray = formats = outputType.getComplexOutput().getSupported().getFormatArray();
                        n6 = formats.length;
                        n5 = 0;
                        while (n5 < n6) {
                            tempFormat = complexDataDescriptionTypeArray[n5];
                            if (tempFormat.getEncoding().equalsIgnoreCase(schema)) {
                                foundSchema = tempFormat.getSchema();
                                schemaFormat = tempFormat;
                                ++found;
                            }
                            ++n5;
                        }
                    }
                    if (found == 1) {
                        finalSchema = foundSchema;
                        finalMimeType = schemaFormat.getMimeType();
                        if (schemaFormat.isSetEncoding()) {
                            finalEncoding = schemaFormat.getEncoding();
                        }
                    } else {
                        throw new ExceptionReport("Request incomplete. Could not determine a suitable input format based on the given input [mime Type missing and given schema not unique]", "MissingParameterValue");
                    }
                }
                if (encoding != null && schema != null) {
                    String defaultEncoding = outputType.getComplexOutput().getDefault().getFormat().getEncoding();
                    ArrayList<ComplexDataDescriptionType> foundEncodingList = new ArrayList<ComplexDataDescriptionType>();
                    if (defaultEncoding.equalsIgnoreCase(encoding)) {
                        foundEncodingList.add(outputType.getComplexOutput().getDefault().getFormat());
                    } else {
                        ComplexDataDescriptionType[] formats2;
                        ComplexDataDescriptionType[] complexDataDescriptionTypeArray2 = formats2 = outputType.getComplexOutput().getSupported().getFormatArray();
                        int tempFormat2 = formats2.length;
                        int formats3 = 0;
                        while (formats3 < tempFormat2) {
                            ComplexDataDescriptionType tempFormat3 = complexDataDescriptionTypeArray2[formats3];
                            if (tempFormat3.getEncoding().equalsIgnoreCase(encoding)) {
                                foundEncodingList.add(tempFormat3);
                            }
                            ++formats3;
                        }
                        ArrayList<ComplexDataDescriptionType> foundSchemaList = new ArrayList<ComplexDataDescriptionType>();
                        String defaultSchema = outputType.getComplexOutput().getDefault().getFormat().getSchema();
                        if (defaultSchema.equalsIgnoreCase(schema)) {
                            foundSchemaList.add(outputType.getComplexOutput().getDefault().getFormat());
                        } else {
                            complexDataDescriptionTypeArray = formats2 = outputType.getComplexOutput().getSupported().getFormatArray();
                            n6 = formats2.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                ComplexDataDescriptionType tempFormat4 = complexDataDescriptionTypeArray[n7];
                                if (tempFormat4.getEncoding().equalsIgnoreCase(schema)) {
                                    foundSchemaList.add(tempFormat4);
                                }
                                ++n7;
                            }
                        }
                        ComplexDataDescriptionType foundCommonFormat = null;
                        for (ComplexDataDescriptionType encodingFormat : foundEncodingList) {
                            for (ComplexDataDescriptionType schemaFormat : foundSchemaList) {
                                if (!encodingFormat.equals(schemaFormat)) continue;
                                foundCommonFormat = encodingFormat;
                            }
                        }
                        if (foundCommonFormat != null) {
                            mimeType = foundCommonFormat.getMimeType();
                            if (foundCommonFormat.isSetEncoding()) {
                                finalEncoding = foundCommonFormat.getEncoding();
                            }
                            if (foundCommonFormat.isSetSchema()) {
                                finalSchema = foundCommonFormat.getSchema();
                            }
                        } else {
                            throw new ExceptionReport("Request incomplete. Could not determine a suitable input format based on the given input [mime Type missing and given encoding and schema are not unique]", "MissingParameterValue");
                        }
                    }
                }
            }
        }
        this.schema = finalSchema;
        if (this.encoding == null) {
            this.encoding = finalEncoding;
        }
        this.mimeType = finalMimeType;
    }

    protected void prepareGenerator() throws ExceptionReport {
        Class algorithmOutput = RepositoryManager.getInstance().getOutputDataTypeForAlgorithm(this.algorithmIdentifier, this.id);
        LOGGER.debug("Looking for matching Generator: schema: {}, mimeType {}, encoding: {}", new Object[]{this.schema, this.mimeType, this.encoding});
        GeneratorFactory factory = GeneratorFactory.getInstance();
        this.generator = factory.getGenerator(this.schema, this.mimeType, this.encoding, algorithmOutput);
        if (this.generator != null) {
            LOGGER.info("Using generator " + this.generator.getClass().getName() + " for Schema: " + this.schema);
        }
        if (this.generator == null) {
            throw new ExceptionReport("Could not find an appropriate generator based on given mimetype/schema/encoding for output", "NoApplicableCode");
        }
    }
}

