/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.OutputDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.apache.xmlbeans.XmlOptions;

public class XMLBeansHelper {
    public static final String NS_WPS_1_0_0 = "http://www.opengis.net/wps/1.0.0";
    public static final String NS_WPS_PREFIX = "wps";
    public static final String NS_OWS_1_1 = "http://www.opengis.net/ows/1.1";
    public static final String NS_OWS_PREFIX = "ows";
    public static final String NS_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String NS_XSI_PREFIX = "xsi";
    private static final ConcurrentMap<String, String> PREFIXES = Maps.newConcurrentMap();

    static {
        PREFIXES.put(NS_XSI, NS_XSI_PREFIX);
        PREFIXES.put(NS_WPS_1_0_0, NS_WPS_PREFIX);
        PREFIXES.put(NS_OWS_1_1, NS_OWS_PREFIX);
    }

    public static OutputDescriptionType findOutputByID(String outputID, OutputDescriptionType[] outputDescs) {
        OutputDescriptionType[] outputDescriptionTypeArray = outputDescs;
        int n = outputDescs.length;
        int n2 = 0;
        while (n2 < n) {
            OutputDescriptionType desc = outputDescriptionTypeArray[n2];
            if (desc.getIdentifier().getStringValue().equals(outputID)) {
                return desc;
            }
            ++n2;
        }
        return null;
    }

    public static InputDescriptionType findInputByID(String outputID, ProcessDescriptionType.DataInputs inputs) {
        InputDescriptionType[] inputDescriptionTypeArray = inputs.getInputArray();
        int n = inputDescriptionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            InputDescriptionType desc = inputDescriptionTypeArray[n2];
            if (desc.getIdentifier().getStringValue().equals(outputID)) {
                return desc;
            }
            ++n2;
        }
        return null;
    }

    public static XmlOptions getXmlOptions() {
        return new XmlOptions().setSaveNamespacesFirst().setSaveSuggestedPrefixes(PREFIXES).setSaveAggressiveNamespaces().setSavePrettyPrint();
    }

    public static void registerPrefix(String namespace, String prefix) {
        PREFIXES.put((String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)namespace)), (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)prefix)));
    }
}

