/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.distributions.GaussianDistribution;
import be.ac.ulg.montefiore.run.jahmm.ObservationReal;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpdfGaussian
implements Opdf<ObservationReal> {
    private GaussianDistribution distribution;
    private static final long serialVersionUID = 1L;

    public OpdfGaussian() {
        this.distribution = new GaussianDistribution();
    }

    public OpdfGaussian(double mean, double variance) {
        this.distribution = new GaussianDistribution(mean, variance);
    }

    public double mean() {
        return this.distribution.mean();
    }

    public double variance() {
        return this.distribution.variance();
    }

    @Override
    public double probability(ObservationReal o) {
        return this.distribution.probability(o.value);
    }

    @Override
    public ObservationReal generate() {
        return new ObservationReal(this.distribution.generate());
    }

    public void fit(ObservationReal ... oa) {
        this.fit((Collection<? extends ObservationReal>)Arrays.asList(oa));
    }

    @Override
    public void fit(Collection<? extends ObservationReal> co) {
        double[] weights = new double[co.size()];
        Arrays.fill(weights, 1.0 / (double)co.size());
        this.fit(co, weights);
    }

    public void fit(ObservationReal[] o, double[] weights) {
        this.fit((Collection<? extends ObservationReal>)Arrays.asList(o), weights);
    }

    @Override
    public void fit(Collection<? extends ObservationReal> co, double[] weights) {
        if (co.isEmpty() || co.size() != weights.length) {
            throw new IllegalArgumentException();
        }
        double mean = 0.0;
        int i = 0;
        for (ObservationReal observationReal : co) {
            mean += observationReal.value * weights[i++];
        }
        double d = 0.0;
        i = 0;
        for (ObservationReal observationReal : co) {
            double d2 = observationReal.value - mean;
            d += d2 * d2 * weights[i++];
        }
        this.distribution = new GaussianDistribution(mean, d);
    }

    public OpdfGaussian clone() {
        try {
            return (OpdfGaussian)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        return "Gaussian distribution --- Mean: " + numberFormat.format(this.distribution.mean()) + " Variance " + numberFormat.format(this.distribution.variance());
    }
}

