/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.distributions.GaussianDistribution;
import be.ac.ulg.montefiore.run.distributions.GaussianMixtureDistribution;
import be.ac.ulg.montefiore.run.jahmm.ObservationReal;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpdfGaussianMixture
implements Opdf<ObservationReal> {
    private GaussianMixtureDistribution distribution;
    private static final long serialVersionUID = 1L;

    public OpdfGaussianMixture(int nbGaussians) {
        this.distribution = new GaussianMixtureDistribution(nbGaussians);
    }

    public OpdfGaussianMixture(double[] means, double[] variances, double[] proportions) {
        this.distribution = new GaussianMixtureDistribution(means, variances, proportions);
    }

    @Override
    public double probability(ObservationReal o) {
        return this.distribution.probability(o.value);
    }

    @Override
    public ObservationReal generate() {
        return new ObservationReal(this.distribution.generate());
    }

    public int nbGaussians() {
        return this.distribution.nbGaussians();
    }

    public double[] proportions() {
        return this.distribution.proportions();
    }

    public double[] means() {
        double[] means = new double[this.nbGaussians()];
        GaussianDistribution[] distributions = this.distribution.distributions();
        int i = 0;
        while (i < distributions.length) {
            means[i] = distributions[i].mean();
            ++i;
        }
        return means;
    }

    public double[] variances() {
        double[] variances = new double[this.nbGaussians()];
        GaussianDistribution[] distributions = this.distribution.distributions();
        int i = 0;
        while (i < distributions.length) {
            variances[i] = distributions[i].variance();
            ++i;
        }
        return variances;
    }

    public void fit(ObservationReal ... oa) {
        this.fit((Collection<? extends ObservationReal>)Arrays.asList(oa));
    }

    @Override
    public void fit(Collection<? extends ObservationReal> co) {
        double[] weights = new double[co.size()];
        Arrays.fill(weights, 1.0 / (double)co.size());
        this.fit(co, weights);
    }

    public void fit(ObservationReal[] o, double[] weights) {
        this.fit((Collection<? extends ObservationReal>)Arrays.asList(o), weights);
    }

    @Override
    public void fit(Collection<? extends ObservationReal> co, double[] weights) {
        if (co.isEmpty() || co.size() != weights.length) {
            throw new IllegalArgumentException();
        }
        ObservationReal[] o = co.toArray(new ObservationReal[co.size()]);
        double[][] delta = this.getDelta(o);
        double[] newMixingProportions = this.computeNewMixingProportions(delta, o, weights);
        double[] newMeans = this.computeNewMeans(delta, o, weights);
        double[] newVariances = this.computeNewVariances(delta, o, weights);
        this.distribution = new GaussianMixtureDistribution(newMeans, newVariances, newMixingProportions);
    }

    private double[][] getDelta(ObservationReal[] o) {
        double[][] delta = new double[this.distribution.nbGaussians()][o.length];
        int i = 0;
        while (i < this.distribution.nbGaussians()) {
            double[] proportions = this.distribution.proportions();
            GaussianDistribution[] distributions = this.distribution.distributions();
            int t = 0;
            while (t < o.length) {
                delta[i][t] = proportions[i] * distributions[i].probability(o[t].value) / this.probability(o[t]);
                ++t;
            }
            ++i;
        }
        return delta;
    }

    private double[] computeNewMixingProportions(double[][] delta, ObservationReal[] o, double[] weights) {
        double[] num = new double[this.distribution.nbGaussians()];
        double sum = 0.0;
        Arrays.fill(num, 0.0);
        int i = 0;
        while (i < this.distribution.nbGaussians()) {
            int t = 0;
            while (t < weights.length) {
                int n = i;
                num[n] = num[n] + weights[t] * delta[i][t];
                sum += weights[t] * delta[i][t];
                ++t;
            }
            ++i;
        }
        double[] newMixingProportions = new double[this.distribution.nbGaussians()];
        int i2 = 0;
        while (i2 < this.distribution.nbGaussians()) {
            newMixingProportions[i2] = num[i2] / sum;
            ++i2;
        }
        return newMixingProportions;
    }

    private double[] computeNewMeans(double[][] delta, ObservationReal[] o, double[] weights) {
        double[] num = new double[this.distribution.nbGaussians()];
        double[] sum = new double[this.distribution.nbGaussians()];
        Arrays.fill(num, 0.0);
        Arrays.fill(sum, 0.0);
        int i = 0;
        while (i < this.distribution.nbGaussians()) {
            int t = 0;
            while (t < o.length) {
                int n = i;
                num[n] = num[n] + weights[t] * delta[i][t] * o[t].value;
                int n2 = i;
                sum[n2] = sum[n2] + weights[t] * delta[i][t];
                ++t;
            }
            ++i;
        }
        double[] newMeans = new double[this.distribution.nbGaussians()];
        int i2 = 0;
        while (i2 < this.distribution.nbGaussians()) {
            newMeans[i2] = num[i2] / sum[i2];
            ++i2;
        }
        return newMeans;
    }

    private double[] computeNewVariances(double[][] delta, ObservationReal[] o, double[] weights) {
        double[] num = new double[this.distribution.nbGaussians()];
        double[] sum = new double[this.distribution.nbGaussians()];
        Arrays.fill(num, 0.0);
        Arrays.fill(sum, 0.0);
        int i = 0;
        while (i < this.distribution.nbGaussians()) {
            GaussianDistribution[] distributions = this.distribution.distributions();
            int t = 0;
            while (t < o.length) {
                int n = i;
                num[n] = num[n] + weights[t] * delta[i][t] * (o[t].value - distributions[i].mean()) * (o[t].value - distributions[i].mean());
                int n2 = i;
                sum[n2] = sum[n2] + weights[t] * delta[i][t];
                ++t;
            }
            ++i;
        }
        double[] newVariances = new double[this.distribution.nbGaussians()];
        int i2 = 0;
        while (i2 < this.distribution.nbGaussians()) {
            newVariances[i2] = num[i2] / sum[i2];
            ++i2;
        }
        return newVariances;
    }

    public OpdfGaussianMixture clone() {
        try {
            return (OpdfGaussianMixture)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        String s = "Gaussian mixture distribution --- ";
        double[] proportions = this.proportions();
        double[] means = this.means();
        double[] variances = this.variances();
        int i = 0;
        while (i < this.distribution.nbGaussians()) {
            s = String.valueOf(s) + "Gaussian " + (i + 1) + ":\n";
            s = String.valueOf(s) + "\tMixing Prop = " + numberFormat.format(proportions[i]) + "\n";
            s = String.valueOf(s) + "\tMean = " + numberFormat.format(means[i]) + "\n";
            s = String.valueOf(s) + "\tVariance = " + numberFormat.format(variances[i]) + "\n";
            ++i;
        }
        return s;
    }
}

