/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.distributions.MultiGaussianDistribution;
import be.ac.ulg.montefiore.run.jahmm.ObservationVector;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpdfMultiGaussian
implements Opdf<ObservationVector> {
    private MultiGaussianDistribution distribution;
    private static final long serialVersionUID = 1L;

    public OpdfMultiGaussian(int dimension) {
        this.distribution = new MultiGaussianDistribution(dimension);
    }

    public OpdfMultiGaussian(double[] mean, double[][] covariance) {
        if (covariance.length == 0 || mean.length != covariance.length || covariance.length != covariance[0].length) {
            throw new IllegalArgumentException();
        }
        this.distribution = new MultiGaussianDistribution(mean, covariance);
    }

    public double[] mean() {
        return this.distribution.mean();
    }

    public double[][] covariance() {
        return this.distribution.covariance();
    }

    public int dimension() {
        return this.distribution.dimension();
    }

    @Override
    public double probability(ObservationVector o) {
        if (o.dimension() != this.distribution.dimension()) {
            throw new IllegalArgumentException("Vector has a wrong dimension");
        }
        return this.distribution.probability(o.value);
    }

    @Override
    public ObservationVector generate() {
        return new ObservationVector(this.distribution.generate());
    }

    public void fit(ObservationVector ... oa) {
        this.fit((Collection<? extends ObservationVector>)Arrays.asList(oa));
    }

    @Override
    public void fit(Collection<? extends ObservationVector> co) {
        if (co.isEmpty()) {
            throw new IllegalArgumentException("Empty observation set");
        }
        double[] weights = new double[co.size()];
        Arrays.fill(weights, 1.0 / (double)co.size());
        this.fit(co, weights);
    }

    public void fit(ObservationVector[] o, double[] weights) {
        this.fit((Collection<? extends ObservationVector>)Arrays.asList(o), weights);
    }

    @Override
    public void fit(Collection<? extends ObservationVector> co, double[] weights) {
        int i;
        if (co.isEmpty() || co.size() != weights.length) {
            throw new IllegalArgumentException();
        }
        double[] mean = new double[this.dimension()];
        int r = 0;
        while (r < this.dimension()) {
            i = 0;
            for (ObservationVector observationVector : co) {
                int n = r;
                mean[n] = mean[n] + observationVector.value[r] * weights[i++];
            }
            ++r;
        }
        double[][] covariance = new double[this.dimension()][this.dimension()];
        i = 0;
        for (ObservationVector observationVector : co) {
            double[] obs = observationVector.value;
            double[] omm = new double[obs.length];
            int j = 0;
            while (j < obs.length) {
                omm[j] = obs[j] - mean[j];
                ++j;
            }
            int r2 = 0;
            while (r2 < this.dimension()) {
                int c = 0;
                while (c < this.dimension()) {
                    double[] dArray = covariance[r2];
                    int n = c;
                    dArray[n] = dArray[n] + omm[r2] * omm[c] * weights[i];
                    ++c;
                }
                ++r2;
            }
            ++i;
        }
        this.distribution = new MultiGaussianDistribution(mean, covariance);
    }

    public OpdfMultiGaussian clone() {
        try {
            return (OpdfMultiGaussian)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        String s = "Multi-variate Gaussian distribution --- Mean: [ ";
        double[] mean = this.distribution.mean();
        int i = 0;
        while (i < mean.length) {
            s = String.valueOf(s) + numberFormat.format(mean[i]) + " ";
            ++i;
        }
        return String.valueOf(s) + "]";
    }
}

