/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.io;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HmmWriter {
    public static <O extends Observation> void write(Writer writer, OpdfWriter<? extends Opdf<O>> opdfWriter, Hmm<O> hmm) throws IOException {
        writer.write("Hmm v1.0\n\nNbStates " + hmm.nbStates() + "\n\n");
        int i = 0;
        while (i < hmm.nbStates()) {
            HmmWriter.writeState(writer, opdfWriter, hmm, i);
            ++i;
        }
    }

    private static <O extends Observation, D extends Opdf<O>> void writeState(Writer writer, OpdfWriter<D> opdfWriter, Hmm<O> hmm, int stateNb) throws IOException {
        DecimalFormat formatter = new DecimalFormat();
        writer.write("State\nPi " + formatter.format(hmm.getPi(stateNb)));
        writer.write("\nA ");
        int i = 0;
        while (i < hmm.nbStates()) {
            writer.write(String.valueOf(formatter.format(hmm.getAij(stateNb, i))) + " ");
            ++i;
        }
        writer.write("\n");
        Opdf<O> opdf = hmm.getOpdf(stateNb);
        opdfWriter.write(writer, opdf);
        writer.write("\n\n");
    }
}

