/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.io;

import be.ac.ulg.montefiore.run.jahmm.ObservationInteger;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationReader;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationSequencesReader;
import java.io.IOException;
import java.io.StreamTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservationIntegerReader
extends ObservationReader<ObservationInteger> {
    private int nbElements;

    public ObservationIntegerReader() {
        this.nbElements = Integer.MAX_VALUE;
    }

    public ObservationIntegerReader(int nbElements) {
        if (nbElements <= 0) {
            throw new IllegalArgumentException("Nb of elements must be positive");
        }
        this.nbElements = nbElements;
    }

    @Override
    public ObservationInteger read(StreamTokenizer st) throws IOException, FileFormatException {
        st.ordinaryChar(46);
        if (st.nextToken() == -2) {
            if (st.nval > (double)this.nbElements) {
                throw new FileFormatException(st.lineno(), "Integer higher than maximum value " + (this.nbElements - 1));
            }
        } else {
            throw new FileFormatException(st.lineno(), "Integer expected");
        }
        ObservationInteger oi = new ObservationInteger((int)st.nval);
        if (st.nextToken() != 59) {
            throw new FileFormatException(st.lineno(), "';' expected");
        }
        ObservationSequencesReader.initSyntaxTable(st);
        return oi;
    }
}

