/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.learn;

import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardCalculator;
import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardScaledCalculator;
import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.learn.BaumWelchLearner;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaumWelchScaledLearner
extends BaumWelchLearner {
    @Override
    protected <O extends Observation> ForwardBackwardCalculator generateForwardBackwardCalculator(List<? extends O> sequence, Hmm<O> hmm) {
        return new ForwardBackwardScaledCalculator(sequence, hmm, EnumSet.allOf(ForwardBackwardCalculator.Computation.class));
    }

    @Override
    protected <O extends Observation> double[][][] estimateXi(List<? extends O> sequence, ForwardBackwardCalculator fbc, Hmm<O> hmm) {
        if (sequence.size() <= 1) {
            throw new IllegalArgumentException("Observation sequence too short");
        }
        double[][][] xi = new double[sequence.size() - 1][hmm.nbStates()][hmm.nbStates()];
        Iterator<O> seqIterator = sequence.iterator();
        seqIterator.next();
        int t = 0;
        while (t < sequence.size() - 1) {
            Observation observation = (Observation)seqIterator.next();
            int i = 0;
            while (i < hmm.nbStates()) {
                int j = 0;
                while (j < hmm.nbStates()) {
                    xi[t][i][j] = fbc.alphaElement(t, i) * hmm.getAij(i, j) * hmm.getOpdf(j).probability(observation) * fbc.betaElement(t + 1, j);
                    ++j;
                }
                ++i;
            }
            ++t;
        }
        return xi;
    }
}

