/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.test;

import be.ac.ulg.montefiore.run.jahmm.apps.cli.AbnormalTerminationException;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.Cli;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import junit.framework.TestCase;

public class CliTest
extends TestCase {
    private InputStream origIn;
    private PrintStream origOut;
    private PrintStream origErr;

    protected void setUp() {
        this.origIn = System.in;
        this.origOut = System.out;
        this.origErr = System.err;
    }

    public void testCli() throws IOException {
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        System.setErr(new PrintStream(err));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        try {
            this.help();
            this.flush(out, err);
            this.create();
            String hmm = new String(out.toByteArray());
            this.flush(out, err);
            ByteArrayInputStream in = new ByteArrayInputStream(hmm.getBytes());
            System.setIn(in);
            this.print();
            this.flush(out, err);
        }
        catch (AbnormalTerminationException e) {
            throw new AssertionError((Object)("Unexpected exception: " + e));
        }
        System.setOut(this.origOut);
        System.setErr(this.origErr);
        System.setIn(this.origIn);
    }

    protected void flush(ByteArrayOutputStream out, ByteArrayOutputStream err) {
        CliTest.assertEquals((String)("Something has been written on the \"standard\" error stream ('" + err.toString() + "')"), (int)err.toString().length(), (int)0);
        out.reset();
        err.reset();
    }

    protected void help() throws IOException, AbnormalTerminationException {
        Cli.run("-help");
    }

    protected void create() throws IOException, AbnormalTerminationException {
        Cli.run("create", "-opdf", "integer", "-r", "4", "-n", "3", "-o", "-");
    }

    protected void print() throws IOException, AbnormalTerminationException {
        Cli.run("print", "-i", "-");
    }
}

