/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelApplier
extends Operator {
    public static final String PARAMETER_KEY = "key";
    public static final String PARAMETER_APPLICATION_PARAMETERS = "application_parameters";
    private static final String PARAMETER_CREATE_VIEW = "create_view";

    public ModelApplier(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet inputExampleSet = this.getInput(ExampleSet.class);
        Model model = this.getInput(Model.class);
        this.log("Set parameters for " + model.getClass().getName());
        List<String[]> modelParameters = this.getParameterList(PARAMETER_APPLICATION_PARAMETERS);
        for (String[] parameter : modelParameters) {
            model.setParameter(parameter[0], parameter[1]);
        }
        if (this.getParameterAsBoolean(PARAMETER_CREATE_VIEW)) {
            model.setParameter(PARAMETER_CREATE_VIEW, true);
        }
        this.log("Applying " + model.getClass().getName());
        ExampleSet result = inputExampleSet;
        try {
            result = model.apply(inputExampleSet);
        }
        catch (UserError e) {
            if (e.getOperator() == null) {
                e.setOperator(this);
            }
            throw e;
        }
        return new IOObject[]{result};
    }

    public InputDescription getInputDescription(Class cls) {
        if (Model.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{Model.class, ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeList(PARAMETER_APPLICATION_PARAMETERS, "Model parameters for application (usually not needed).", new ParameterTypeString(PARAMETER_KEY, "value")));
        types.add(new ParameterTypeBoolean(PARAMETER_CREATE_VIEW, "Indicates that preprocessing models should only create a new view on the data instead of actually changing the data itself.", false));
        return types;
    }
}

