/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Tools;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.GenerationException;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividual;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividualOperator;
import com.rapidminer.tools.RandomGenerator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedGeneratingMutation
extends ExampleSetBasedIndividualOperator {
    private List generators;
    private Attribute[] originalAttributes;
    private double p;
    private int maxGeneratedAttributes = 2;
    private int maxAddedOriginalAttributes = 2;
    private String[] unusableFunctions = new String[0];
    private RandomGenerator random;

    public DirectedGeneratingMutation(Attribute[] originalAttributes, double p, List generators, int maxGeneratedAttributes, int maxAddedOriginalAttributes, String[] unusableFunctions, RandomGenerator random) {
        this.originalAttributes = originalAttributes;
        this.p = p / (double)(maxGeneratedAttributes + maxAddedOriginalAttributes);
        this.generators = generators;
        this.maxGeneratedAttributes = maxGeneratedAttributes;
        this.maxAddedOriginalAttributes = maxAddedOriginalAttributes;
        this.unusableFunctions = unusableFunctions;
        this.random = random;
    }

    @Override
    public List<ExampleSetBasedIndividual> operate(ExampleSetBasedIndividual individual) throws Exception {
        LinkedList<ExampleSetBasedIndividual> l = new LinkedList<ExampleSetBasedIndividual>();
        AttributeWeightedExampleSet clone = (AttributeWeightedExampleSet)individual.getExampleSet().clone();
        try {
            this.addOriginalAttribute(clone);
            this.addGeneratedAttribute(clone);
            this.deselect(clone, this.maxGeneratedAttributes + this.maxAddedOriginalAttributes);
            if (clone.getNumberOfUsedAttributes() > 0) {
                l.add(new ExampleSetBasedIndividual(clone));
            }
        }
        catch (GenerationException e) {
            individual.getExampleSet().getLog().logWarning("DirectedGGA: Exception occured during generation of attributes, using only original example set instead.");
        }
        l.add(individual);
        return l;
    }

    private void addGeneratedAttribute(AttributeWeightedExampleSet exampleSet) throws GenerationException {
        int i = 0;
        while (i < this.maxGeneratedAttributes) {
            FeatureGenerator generator;
            if (this.random.nextDouble() < this.p && (generator = FeatureGenerator.selectGenerator(exampleSet, this.generators, this.unusableFunctions, this.random)) != null) {
                generator = generator.newInstance();
                Attribute[] args = Tools.getWeightedCompatibleAttributes(exampleSet, generator, this.unusableFunctions, this.random);
                generator.setArguments(args);
                LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
                generatorList.add(generator);
                List<Attribute> result = FeatureGenerator.generateAll(exampleSet.getExampleTable(), generatorList);
                double weightSum = 0.0;
                int j = 0;
                while (j < args.length) {
                    weightSum += exampleSet.getWeight(args[j]);
                    ++j;
                }
                weightSum /= (double)args.length;
                for (Attribute newAttribute : result) {
                    exampleSet.getAttributes().addRegular(newAttribute);
                }
                Iterator<Attribute> a = result.iterator();
                while (a.hasNext()) {
                    exampleSet.setWeight(a.next(), weightSum);
                }
            }
            ++i;
        }
    }

    private void addOriginalAttribute(AttributeWeightedExampleSet exampleSet) {
        int j = 0;
        while (j < this.maxAddedOriginalAttributes) {
            if (this.random.nextDouble() < this.p) {
                Attribute originalAttribute = this.originalAttributes[this.random.nextInt(this.originalAttributes.length)];
                double avgWeight = Tools.getAverageWeight(exampleSet);
                if (!exampleSet.getAttributes().contains(originalAttribute)) {
                    exampleSet.getAttributes().addRegular(originalAttribute);
                    exampleSet.setWeight(originalAttribute, avgWeight);
                }
            }
            ++j;
        }
    }

    private void deselect(AttributeWeightedExampleSet exampleSet, int numberNew) {
        double[] probs = Tools.getInverseProbabilitiesFromWeights(exampleSet.getAttributes().createRegularAttributeArray(), exampleSet);
        Iterator<Attribute> i = exampleSet.getAttributes().iterator();
        int index = 0;
        while (i.hasNext()) {
            i.next();
            int n = index++;
            if (!(this.random.nextDouble() < this.p * probs[n] * (double)numberNew)) continue;
            i.remove();
        }
    }
}

