/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.selection;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.FeatureOperator;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BruteForceSelection
extends FeatureOperator {
    public static final String PARAMETER_MAX_NUMBER_OF_ATTRIBUTES = "max_number_of_attributes";
    public static final String PARAMETER_MIN_NUMBER_OF_ATTRIBUTES = "min_number_of_attributes";
    public static final String PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES = "exact_number_of_attributes";

    public BruteForceSelection(OperatorDescription description) {
        super(description);
    }

    @Override
    public Population createInitialPopulation(ExampleSet es) throws OperatorException {
        int minNumberOfFeatures = this.getParameterAsInt(PARAMETER_MIN_NUMBER_OF_ATTRIBUTES);
        int maxNumberOfFeatures = this.getParameterAsInt(PARAMETER_MAX_NUMBER_OF_ATTRIBUTES);
        int exactNumberOfFeatures = this.getParameterAsInt(PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES);
        if (exactNumberOfFeatures > 0) {
            this.logNote("Using exact number of features for feature selection (" + exactNumberOfFeatures + "), ignoring possibly defined range for the number of features.");
        } else if (maxNumberOfFeatures > 0 && minNumberOfFeatures > maxNumberOfFeatures) {
            throw new UserError((Operator)this, 210, PARAMETER_MAX_NUMBER_OF_ATTRIBUTES, PARAMETER_MIN_NUMBER_OF_ATTRIBUTES);
        }
        Population pop = new Population();
        double[] weights = new double[es.getAttributes().size()];
        if (exactNumberOfFeatures > 0) {
            this.addAllWithExactNumber(pop, weights, 0, exactNumberOfFeatures);
        } else {
            this.addAllInRange(pop, weights, 0, minNumberOfFeatures, maxNumberOfFeatures);
        }
        return pop;
    }

    private void addAllWithExactNumber(Population pop, double[] weights, int startIndex, int exactNumberOfFeatures) {
        Individual individual = new Individual(weights);
        if (individual.getNumberOfUsedAttributes() > exactNumberOfFeatures) {
            return;
        }
        int i = startIndex;
        while (i < weights.length) {
            double[] clone = individual.getWeightsClone();
            clone[i] = 1.0;
            Individual newIndividual = new Individual(clone);
            if (newIndividual.getNumberOfUsedAttributes() == exactNumberOfFeatures) {
                pop.add(newIndividual);
            } else {
                this.addAllWithExactNumber(pop, clone, i + 1, exactNumberOfFeatures);
            }
            ++i;
        }
    }

    private void addAllInRange(Population pop, double[] weights, int startIndex, int minNumberOfFeatures, int maxNumberOfFeatures) {
        if (startIndex >= weights.length) {
            return;
        }
        Individual individual = new Individual(weights);
        int numberOfFeatures = individual.getNumberOfUsedAttributes();
        if (maxNumberOfFeatures > 0 && numberOfFeatures > maxNumberOfFeatures) {
            return;
        }
        double[] clone = individual.getWeightsClone();
        clone[startIndex] = 0.0;
        this.addAllInRange(pop, clone, startIndex + 1, minNumberOfFeatures, maxNumberOfFeatures);
        double[] clone2 = individual.getWeightsClone();
        clone2[startIndex] = 1.0;
        Individual newIndividual = new Individual(clone2);
        numberOfFeatures = newIndividual.getNumberOfUsedAttributes();
        if (numberOfFeatures > 0 && (maxNumberOfFeatures < 1 || numberOfFeatures <= maxNumberOfFeatures) && numberOfFeatures >= minNumberOfFeatures) {
            pop.add(newIndividual);
        }
        this.addAllInRange(pop, clone2, startIndex + 1, minNumberOfFeatures, maxNumberOfFeatures);
    }

    @Override
    public List<PopulationOperator> getPreEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    @Override
    public List<PopulationOperator> getPostEvaluationPopulationOperators(ExampleSet input) throws OperatorException {
        return new LinkedList<PopulationOperator>();
    }

    @Override
    public boolean solutionGoodEnough(Population pop) {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt(PARAMETER_MIN_NUMBER_OF_ATTRIBUTES, "Determines the minimum number of features used for the combinations.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_MAX_NUMBER_OF_ATTRIBUTES, "Determines the maximum number of features used for the combinations (-1: try all combinations up to possible maximum)", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_EXACT_NUMBER_OF_ATTRIBUTES, "Determines the exact number of features used for the combinations (-1: use the feature range defined by min and max).", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

