/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.viewer.ConfusionMatrixViewer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.report.Tableable;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.Averagable;
import java.awt.Component;

public class BinaryClassificationPerformance
extends MeasuredPerformance
implements Tableable {
    private static final long serialVersionUID = 7475134460409215015L;
    public static final int PRECISION = 0;
    public static final int RECALL = 1;
    public static final int LIFT = 2;
    public static final int FALLOUT = 3;
    public static final int F_MEASURE = 4;
    public static final int FALSE_POSITIVE = 5;
    public static final int FALSE_NEGATIVE = 6;
    public static final int TRUE_POSITIVE = 7;
    public static final int TRUE_NEGATIVE = 8;
    public static final int SENSITIVITY = 9;
    public static final int SPECIFICITY = 10;
    public static final int YOUDEN = 11;
    public static final int POSITIVE_PREDICTIVE_VALUE = 12;
    public static final int NEGATIVE_PREDICTIVE_VALUE = 13;
    public static final int PSEP = 14;
    private static final int N = 0;
    private static final int P = 1;
    public static final String[] NAMES = new String[]{"precision", "recall", "lift", "fallout", "f_measure", "false_positive", "false_negative", "true_positive", "true_negative", "sensitivity", "specificity", "youden", "positive_predictive_value", "negative_predictive_value", "psep"};
    public static final String[] DESCRIPTIONS = new String[]{"Relative number of correctly as positive classified examples among all examples classified as positive", "Relative number of correctly as positive classified examples among all positive examples", "The lift of the positive class", "Relative number of incorrectly as positive classified examples among all negative examples", "Combination of precision and recall: f=2pr/(p+r)", "Absolute number of incorrectly as positive classified examples", "Absolute number of incorrectly as negative classified examples", "Absolute number of correctly as positive classified examples", "Absolute number of correctly as negative classified examples", "Relative number of correctly as positive classified examples among all positive examples (like recall)", "Relative number of correctly as negative classified examples among all negative examples", "The sum of sensitivity and specificity minus 1", "Relative number of correctly as positive classified examples among all examples classified as positive (same as precision)", "Relative number of correctly as negative classified examples among all examples classified as negative", "The sum of the positive predicitve value and the negative predictive value minus 1"};
    private int type = 0;
    private double[][] counter = new double[2][2];
    private String positiveClassName = "";
    private String negativeClassName = "";
    private Attribute predictedLabelAttribute;
    private Attribute labelAttribute;
    private Attribute weightAttribute;
    private transient ConfusionMatrixViewer viewer;

    public BinaryClassificationPerformance() {
        this.type = -1;
    }

    public BinaryClassificationPerformance(BinaryClassificationPerformance o) {
        super(o);
        this.type = o.type;
        this.counter = new double[2][2];
        this.counter[0][0] = o.counter[0][0];
        this.counter[1][0] = o.counter[1][0];
        this.counter[0][1] = o.counter[0][1];
        this.counter[1][1] = o.counter[1][1];
        if (o.predictedLabelAttribute != null) {
            this.predictedLabelAttribute = (Attribute)o.predictedLabelAttribute.clone();
        }
        if (o.labelAttribute != null) {
            this.labelAttribute = (Attribute)o.labelAttribute.clone();
        }
        if (o.weightAttribute != null) {
            this.weightAttribute = (Attribute)o.weightAttribute.clone();
        }
        this.positiveClassName = o.positiveClassName;
        this.negativeClassName = o.negativeClassName;
    }

    public BinaryClassificationPerformance(int type) {
        this.type = type;
    }

    public BinaryClassificationPerformance(int type, double[][] counter) {
        this.type = type;
        this.counter[0][0] = counter[0][0];
        this.counter[0][1] = counter[0][1];
        this.counter[1][0] = counter[1][0];
        this.counter[1][1] = counter[1][1];
    }

    public static BinaryClassificationPerformance newInstance(String name) {
        int i = 0;
        while (i < NAMES.length) {
            if (NAMES[i].equals(name)) {
                return new BinaryClassificationPerformance(i);
            }
            ++i;
        }
        return null;
    }

    public double getExampleCount() {
        return this.counter[1][1] + this.counter[0][1] + this.counter[1][0] + this.counter[0][0];
    }

    public void startCounting(ExampleSet eSet, boolean useExampleWeights) throws OperatorException {
        super.startCounting(eSet, useExampleWeights);
        this.predictedLabelAttribute = eSet.getAttributes().getPredictedLabel();
        this.labelAttribute = eSet.getAttributes().getLabel();
        if (!this.labelAttribute.isNominal() || this.labelAttribute.getMapping().size() != 2) {
            throw new UserError(null, 118, "'" + this.labelAttribute.getName() + "'", this.labelAttribute.getMapping().getValues().size(), "2 for calculation of '" + this.getName() + "'");
        }
        this.negativeClassName = this.predictedLabelAttribute.getMapping().getNegativeString();
        this.positiveClassName = this.predictedLabelAttribute.getMapping().getPositiveString();
        if (useExampleWeights) {
            this.weightAttribute = eSet.getAttributes().getWeight();
        }
        this.counter = new double[2][2];
    }

    public void countExample(Example example) {
        String labelString = example.getNominalValue(this.labelAttribute);
        int label = this.predictedLabelAttribute.getMapping().getIndex(labelString);
        String predString = example.getNominalValue(this.predictedLabelAttribute);
        int plabel = this.predictedLabelAttribute.getMapping().getIndex(predString);
        double weight = 1.0;
        if (this.weightAttribute != null) {
            weight = example.getValue(this.weightAttribute);
        }
        double[] dArray = this.counter[label];
        int n = plabel;
        dArray[n] = dArray[n] + weight;
    }

    public double getMikroAverage() {
        double x = 0.0;
        double y = 0.0;
        switch (this.type) {
            case 0: {
                x = this.counter[1][1];
                y = this.counter[1][1] + this.counter[0][1];
                break;
            }
            case 1: {
                x = this.counter[1][1];
                y = this.counter[1][1] + this.counter[1][0];
                break;
            }
            case 2: {
                x = this.counter[1][1] / (this.counter[1][1] + this.counter[1][0]);
                y = (this.counter[1][1] + this.counter[0][1]) / (this.counter[1][1] + this.counter[1][0] + this.counter[0][1] + this.counter[0][0]);
                break;
            }
            case 3: {
                x = this.counter[0][1];
                y = this.counter[0][1] + this.counter[0][0];
                break;
            }
            case 4: {
                x = this.counter[1][1];
                x *= x;
                y = (x *= 2.0) + this.counter[1][1] * this.counter[1][0] + this.counter[1][1] * this.counter[0][1];
                break;
            }
            case 6: {
                x = this.counter[1][0];
                y = 1.0;
                break;
            }
            case 5: {
                x = this.counter[0][1];
                y = 1.0;
                break;
            }
            case 8: {
                x = this.counter[0][0];
                y = 1.0;
                break;
            }
            case 7: {
                x = this.counter[1][1];
                y = 1.0;
                break;
            }
            case 9: {
                x = this.counter[1][1];
                y = this.counter[1][1] + this.counter[1][0];
                break;
            }
            case 10: {
                x = this.counter[0][0];
                y = this.counter[0][0] + this.counter[0][1];
                break;
            }
            case 11: {
                x = this.counter[0][0] * this.counter[1][1] - this.counter[1][0] * this.counter[0][1];
                y = (this.counter[1][1] + this.counter[1][0]) * (this.counter[0][1] + this.counter[0][0]);
                break;
            }
            case 12: {
                x = this.counter[1][1];
                y = this.counter[1][1] + this.counter[0][1];
                break;
            }
            case 13: {
                x = this.counter[0][0];
                y = this.counter[0][0] + this.counter[1][0];
                break;
            }
            case 14: {
                x = this.counter[0][0] * this.counter[1][1] + this.counter[0][0] * this.counter[0][1] - this.counter[0][1] * this.counter[0][0] - this.counter[0][1] * this.counter[1][0];
                y = this.counter[1][1] * this.counter[0][0] + this.counter[1][1] * this.counter[1][0] + this.counter[0][1] * this.counter[0][0] + this.counter[0][1] * this.counter[1][0];
                break;
            }
            default: {
                throw new RuntimeException("Illegal value for type in BinaryClassificationPerformance: " + this.type);
            }
        }
        if (y == 0.0) {
            return Double.NaN;
        }
        return x / y;
    }

    public double getFitness() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return this.getAverage();
            }
            case 3: 
            case 5: 
            case 6: {
                if (this.getAverage() == 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                return 1.0 / this.getAverage();
            }
        }
        throw new RuntimeException("Illegal value for type in BinaryClassificationPerformance: " + this.type);
    }

    public double getMaxFitness() {
        switch (this.type) {
            case 0: 
            case 1: 
            case 4: 
            case 9: 
            case 10: {
                return 1.0;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return Double.POSITIVE_INFINITY;
            }
        }
        throw new RuntimeException("Illegal value for type in BinaryClassificationPerformance: " + this.type);
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public String getName() {
        return NAMES[this.type];
    }

    public String getDescription() {
        return DESCRIPTIONS[this.type];
    }

    public boolean formatPercent() {
        switch (this.type) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: {
                return false;
            }
        }
        return true;
    }

    public void buildSingleAverage(Averagable performance) {
        BinaryClassificationPerformance other = (BinaryClassificationPerformance)performance;
        if (this.type != other.type) {
            throw new RuntimeException("Cannot build average of different error types (" + NAMES[this.type] + "/" + NAMES[other.type] + ").");
        }
        if (!this.positiveClassName.equals(other.positiveClassName)) {
            throw new RuntimeException("Cannot build average for different positive classes (" + this.positiveClassName + "/" + other.positiveClassName + ").");
        }
        double[] dArray = this.counter[0];
        dArray[0] = dArray[0] + other.counter[0][0];
        double[] dArray2 = this.counter[0];
        dArray2[1] = dArray2[1] + other.counter[0][1];
        double[] dArray3 = this.counter[1];
        dArray3[0] = dArray3[0] + other.counter[1][0];
        double[] dArray4 = this.counter[1];
        dArray4[1] = dArray4[1] + other.counter[1][1];
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (positive class: " + this.positiveClassName + ")");
        result.append(String.valueOf(Tools.getLineSeparator()) + "ConfusionMatrix:" + Tools.getLineSeparator() + "True:");
        result.append("\t" + this.negativeClassName);
        result.append("\t" + this.positiveClassName);
        result.append(String.valueOf(Tools.getLineSeparator()) + this.negativeClassName + ":");
        result.append("\t" + Tools.formatIntegerIfPossible(this.counter[0][0]));
        result.append("\t" + Tools.formatIntegerIfPossible(this.counter[1][0]));
        result.append(String.valueOf(Tools.getLineSeparator()) + this.positiveClassName + ":");
        result.append("\t" + Tools.formatIntegerIfPossible(this.counter[0][1]));
        result.append("\t" + Tools.formatIntegerIfPossible(this.counter[1][1]));
        return result.toString();
    }

    public Component getVisualizationComponent(IOContainer ioContainer) {
        this.viewer = new ConfusionMatrixViewer(String.valueOf(super.toString()) + " (positive class: " + this.positiveClassName + ")", new String[]{this.negativeClassName, this.positiveClassName}, this.counter);
        return this.viewer;
    }

    public void prepareReporting() {
        if (this.viewer == null) {
            this.getVisualizationComponent(null);
            this.viewer.prepareReporting();
        }
    }

    public void finishReporting() {
        this.viewer.finishReporting();
        this.viewer = null;
    }

    public String getColumnName(int columnIndex) {
        return this.viewer.getColumnName(columnIndex);
    }

    public String getCell(int row, int column) {
        return this.viewer.getCell(row, column);
    }

    public int getColumnNumber() {
        return this.viewer.getColumnNumber();
    }

    public int getRowNumber() {
        return this.viewer.getRowNumber();
    }

    public boolean isFirstLineHeader() {
        return true;
    }

    public boolean isFirstColumnHeader() {
        return true;
    }
}

