/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi;

import com.adventnet.swissqlapi.config.datatypes.DatatypeMapping;
import com.adventnet.swissqlapi.config.metadata.MetaDataProperties;
import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.parser.ALLSQL;
import com.adventnet.swissqlapi.sql.parser.ParseException;
import com.adventnet.swissqlapi.sql.statement.SwisSQLStatement;
import com.adventnet.swissqlapi.sql.statement.create.CreateQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.util.SwisSQLUtils;
import com.adventnet.swissqlapi.util.database.MetaDataUtility;
import com.adventnet.swissqlapi.util.misc.BuiltInFunctionDetails;
import com.adventnet.swissqlapi.util.misc.StringFunctions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SwisSQLAPI {
    private ALLSQL vembuParser = null;
    private boolean constructed = false;
    private SwisSQLStatement currentSwisSQLStatement = null;
    private boolean reInitToBeDone = true;
    private Hashtable dbCumDatatypeMapping = new Hashtable();
    private HashMap objectNames = new HashMap();
    public static boolean ANSIJOIN_ForOracle = false;
    public static Hashtable dataTypesFromMetaDataHT = new Hashtable();
    public static Hashtable columnDatatypes = new Hashtable();
    public static Hashtable tableColumnListMetadata = new Hashtable();
    public static Hashtable targetDataTypesMetaDataHash = new Hashtable();
    public static Hashtable identityMapping = new Hashtable();
    public static Hashtable primaryKeyMetaData = new Hashtable();
    public static final int GIVENSQL = 0;
    public static final int ORACLE = 1;
    public static final int MSSQLSERVER = 2;
    public static final int DB2 = 3;
    public static final int POSTGRESQL = 4;
    public static final int MYSQL = 5;
    public static final int INFORMIX = 6;
    public static final int SYBASE = 7;
    public static final int ANSISQL = 8;
    public static final int COMMON = 9;
    public static final int TIMESTEN = 10;
    public static final int NETEZZA = 11;
    public static final int TERADATA = 12;
    public static boolean MSSQLSERVER_THETA = false;
    public static boolean convert_OracleThetaJOIN_To_ANSIJOIN = false;
    public static HashMap variableDatatypeMapping = null;
    public static UserObjectContext objectContext = null;
    private Hashtable dbCumDatatypeMappingFile = new Hashtable();
    private Hashtable dbCumDatatypeMappingStream = new Hashtable();
    public static boolean convertCaseToDecode = true;
    public static boolean quotedOracleIdentifier = false;
    public static boolean enableObjectMapping = false;
    public static boolean convertToTeradata = true;
    public static BuiltInFunctionDetails builtInFunctionDetails;
    public static boolean tozohodb;
    public static HashMap objectsOwnerName;
    public static HashMap targetDBMappedFunctionNames;
    public static String targetDBFunctionMappingFile;
    public static boolean truncateTableNameForDB2;
    public static boolean truncateTableNameForOracle;
    public static int truncateTableCount;
    public static int truncateIndexCount;
    public static int truncateConstraintCount;

    public static void setMSSQLServerThetaConversion(boolean flag) {
        MSSQLSERVER_THETA = flag;
    }

    public static void setQuotedOracleIdentifier(boolean flag) {
        quotedOracleIdentifier = flag;
    }

    public SwisSQLAPI() {
        this.resetStaticVariables();
    }

    public SwisSQLAPI(String sql) {
        if (!this.constructed) {
            this.vembuParser = new ALLSQL(new StringReader(sql));
            this.reInitToBeDone = false;
            this.constructed = true;
        } else {
            this.vembuParser.ReInit(new StringReader(sql));
            this.reInitToBeDone = false;
        }
        this.resetStaticVariables();
    }

    public SwisSQLAPI(InputStream stream) {
        if (!this.constructed) {
            this.vembuParser = new ALLSQL(stream);
            this.reInitToBeDone = false;
            this.constructed = true;
        } else {
            this.vembuParser.ReInit(stream);
            this.reInitToBeDone = false;
        }
        this.resetStaticVariables();
    }

    public SwisSQLAPI(Reader stream) {
        if (!this.constructed) {
            this.vembuParser = new ALLSQL(stream);
            this.reInitToBeDone = false;
            this.constructed = true;
        } else {
            this.vembuParser.ReInit(stream);
            this.reInitToBeDone = false;
        }
        this.resetStaticVariables();
    }

    public HashMap getObjectNames() {
        return this.objectNames;
    }

    public synchronized void setSQLString(String sql) {
        if (!this.constructed) {
            this.vembuParser = new ALLSQL(new StringReader(sql));
            this.reInitToBeDone = false;
            this.constructed = true;
        } else {
            this.vembuParser.ReInit(new StringReader(sql));
            this.reInitToBeDone = false;
        }
        this.resetStaticVariables();
    }

    public synchronized void setSQLInputStream(InputStream stream) {
        if (!this.constructed) {
            this.vembuParser = new ALLSQL(stream);
            this.reInitToBeDone = false;
            this.constructed = true;
        } else {
            this.vembuParser.ReInit(stream);
            this.reInitToBeDone = false;
        }
        this.resetStaticVariables();
    }

    public synchronized void setSQLReader(Reader stream) {
        if (!this.constructed) {
            this.vembuParser = new ALLSQL(stream);
            this.reInitToBeDone = false;
            this.constructed = true;
        } else {
            this.vembuParser.ReInit(stream);
            this.reInitToBeDone = false;
        }
        this.resetStaticVariables();
    }

    public synchronized String convert(int dialect) throws ParseException, ConvertException {
        return this.convert(dialect, false);
    }

    public synchronized String convert(int dialect, boolean enable_indent) throws ParseException, ConvertException {
        String s_sql = null;
        if (!this.reInitToBeDone) {
            this.currentSwisSQLStatement = this.vembuParser.CompilationUnit();
            this.reInitToBeDone = true;
        }
        if (this.currentSwisSQLStatement == null) {
            return "";
        }
        boolean setDatatypeMapping = false;
        if (this.currentSwisSQLStatement instanceof CreateQueryStatement || this.currentSwisSQLStatement instanceof SelectQueryStatement) {
            setDatatypeMapping = true;
            if (this.currentSwisSQLStatement instanceof SelectQueryStatement) {
                ((SelectQueryStatement)this.currentSwisSQLStatement).setTopLevel(true);
            }
        }
        if (targetDBFunctionMappingFile != null) {
            this.loadFunctionNameMapping(targetDBFunctionMappingFile);
        }
        switch (dialect) {
            case 0: {
                s_sql = ((Object)this.currentSwisSQLStatement).toString();
                break;
            }
            case 1: {
                if (setDatatypeMapping) {
                    this.setDatatypeMappingForSQLDialect(this.currentSwisSQLStatement, 1);
                }
                s_sql = this.currentSwisSQLStatement.toOracleString();
                break;
            }
            case 2: {
                if (setDatatypeMapping) {
                    this.setDatatypeMappingForSQLDialect(this.currentSwisSQLStatement, 2);
                }
                s_sql = this.currentSwisSQLStatement.toMSSQLServerString();
                break;
            }
            case 3: {
                if (setDatatypeMapping) {
                    this.setDatatypeMappingForSQLDialect(this.currentSwisSQLStatement, 3);
                }
                s_sql = this.currentSwisSQLStatement.toDB2String();
                break;
            }
            case 4: {
                if (setDatatypeMapping) {
                    this.setDatatypeMappingForSQLDialect(this.currentSwisSQLStatement, 4);
                }
                s_sql = this.currentSwisSQLStatement.toPostgreSQLString();
                break;
            }
            case 5: {
                if (setDatatypeMapping) {
                    this.setDatatypeMappingForSQLDialect(this.currentSwisSQLStatement, 5);
                }
                s_sql = this.currentSwisSQLStatement.toMySQLString();
                break;
            }
            case 6: {
                if (setDatatypeMapping) {
                    this.setDatatypeMappingForSQLDialect(this.currentSwisSQLStatement, 6);
                }
                s_sql = this.currentSwisSQLStatement.toInformixString();
                break;
            }
            case 7: {
                if (setDatatypeMapping) {
                    this.setDatatypeMappingForSQLDialect(this.currentSwisSQLStatement, 7);
                }
                s_sql = this.currentSwisSQLStatement.toSybaseString();
                break;
            }
            case 8: {
                if (setDatatypeMapping) {
                    this.setDatatypeMappingForSQLDialect(this.currentSwisSQLStatement, 8);
                }
                s_sql = this.currentSwisSQLStatement.toANSIString();
                break;
            }
            case 10: {
                if (setDatatypeMapping) {
                    this.setDatatypeMappingForSQLDialect(this.currentSwisSQLStatement, 10);
                }
                s_sql = this.currentSwisSQLStatement.toTimesTenString();
                break;
            }
            case 11: {
                if (setDatatypeMapping) {
                    this.setDatatypeMappingForSQLDialect(this.currentSwisSQLStatement, 11);
                }
                s_sql = this.currentSwisSQLStatement.toNetezzaString();
                break;
            }
            case 12: {
                if (setDatatypeMapping) {
                    this.setDatatypeMappingForSQLDialect(this.currentSwisSQLStatement, 12);
                }
                s_sql = this.currentSwisSQLStatement.toTeradataString();
                break;
            }
            default: {
                s_sql = "Not Supported Dialect";
            }
        }
        if (enable_indent) {
            return s_sql;
        }
        return this.currentSwisSQLStatement.removeIndent(s_sql);
    }

    private void setDatatypeMappingForSQLDialect(SwisSQLStatement sqs, int dialect) {
        DatatypeMapping mapping = (DatatypeMapping)this.dbCumDatatypeMapping.get(new Integer(dialect));
        if (mapping == null) {
            mapping = (DatatypeMapping)this.dbCumDatatypeMapping.get(new Integer(9));
        }
        if (sqs instanceof CreateQueryStatement) {
            ((CreateQueryStatement)sqs).setDatatypeMapping(mapping);
        } else if (sqs instanceof SelectQueryStatement) {
            ((SelectQueryStatement)sqs).setDatatypeMapping(mapping);
        }
    }

    public synchronized SwisSQLStatement parse() throws ParseException, ConvertException {
        SwisSQLStatement sss = this.vembuParser.CompilationUnit();
        this.objectNames = this.vembuParser.getObjectNames();
        return sss;
    }

    private void resetStaticVariables() {
        SelectQueryStatement.singleQueryConvertedToMultipleQueryList = null;
        SelectQueryStatement.beautyTabCount = 0;
        SelectQueryStatement.getListOfWithStatements().clear();
        this.resetTruncateVariables();
    }

    private void resetTruncateVariables() {
        if (truncateTableCount > 99) {
            truncateTableCount = 0;
        }
        if (truncateIndexCount > 99) {
            truncateIndexCount = 0;
        }
        if (truncateConstraintCount > 99) {
            truncateConstraintCount = 0;
        }
    }

    public void getMetaData() {
        try {
            MetaDataUtility mUtil = new MetaDataUtility();
            Vector outputStrings = new Vector();
            mUtil.getMetaData(outputStrings);
            this.loadMetaData(mUtil.getDestinationFile());
        }
        catch (SQLException sqle) {
            System.out.println(" Error Code : " + sqle.getErrorCode() + ". Please verify the Connection URL. Proceeding without loading metdata...");
        }
        catch (Exception e) {
            System.out.println(" Problem in fetching/loading metadata. Proceeding without loading metdata...");
        }
    }

    public void getMetaData(MetaDataProperties property) {
        try {
            MetaDataUtility mUtil = new MetaDataUtility(property);
            Vector outputStrings = new Vector();
            mUtil.getMetaData(outputStrings);
            this.loadMetaData(mUtil.getDestinationFile());
        }
        catch (SQLException sqle) {
            System.out.println(" Error Code : " + sqle.getErrorCode() + ". Please verify the Connection URL. Proceeding without loading metdata...");
        }
        catch (Exception e) {
            System.out.println(" Problem in fetching/loading metadata. Proceeding without loading metdata...");
        }
    }

    public void getMetaData(Connection con, MetaDataProperties property) {
        try {
            MetaDataUtility mUtil = new MetaDataUtility(con, property);
            Vector outputStrings = new Vector();
            mUtil.getMetaData(outputStrings);
            this.loadMetaData(mUtil.getDestinationFile());
        }
        catch (SQLException sqle) {
            System.out.println(" Error Code : " + sqle.getErrorCode() + ". Please verify the Connection URL. Proceeding without loading metdata...");
            sqle.printStackTrace();
        }
        catch (Exception e) {
            System.out.println(" Problem in fetching/loading metadata. Proceeding without loading metdata...");
        }
    }

    public void loadMetaData(String fileName) {
        try {
            FileInputStream fis = new FileInputStream(fileName);
            InputStreamReader isr = new InputStreamReader(fis);
            this.loadMetaData(isr);
            isr.close();
            fis.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(" LoadMetaData : File not found " + fileName + ". Proceeding with default handling...");
        }
        catch (IOException ioe) {
            System.out.println(" LoadMetaData : GetMetaData yet to be done. Proceeding with default handling...");
        }
        catch (Exception e) {
            System.out.println(" LoadMetaData : GetMetaData yet to be done. Proceeding with default handling...");
        }
    }

    public void loadMetaData(InputStreamReader isr) throws IOException {
        dataTypesFromMetaDataHT = new Hashtable();
        tableColumnListMetadata = new Hashtable();
        primaryKeyMetaData = new Hashtable();
        BufferedReader br = new BufferedReader(isr);
        String metadataString = br.readLine();
        while (metadataString != null) {
            String tablename = StringFunctions.getLastStrToken(metadataString, "=:").trim();
            metadataString = br.readLine();
            String columnname = StringFunctions.getLastStrToken(metadataString, "=:").trim();
            metadataString = br.readLine();
            String orgTypename = StringFunctions.getLastStrToken(metadataString, "=:").toLowerCase().trim();
            metadataString = br.readLine();
            String primaryKey = null;
            if (metadataString != null) {
                primaryKey = StringFunctions.getLastStrToken(metadataString, "=:").trim();
            }
            Hashtable orgTemp = new Hashtable();
            ArrayList columnList = new ArrayList();
            if (dataTypesFromMetaDataHT.containsKey(tablename)) {
                orgTemp = (Hashtable)dataTypesFromMetaDataHT.get(tablename);
                orgTemp.put(columnname, orgTypename);
                columnList = (ArrayList)tableColumnListMetadata.get(tablename);
                columnList.add(columnname);
            } else {
                orgTemp.put(columnname, orgTypename);
                dataTypesFromMetaDataHT.put(tablename, orgTemp);
                columnList.add(columnname);
                tableColumnListMetadata.put(tablename, columnList);
            }
            if (primaryKey != null && primaryKey.equals("1")) {
                ArrayList tempCols;
                if (!primaryKeyMetaData.containsKey(tablename)) {
                    tempCols = new ArrayList();
                    tempCols.add(columnname);
                    primaryKeyMetaData.put(tablename, tempCols);
                } else {
                    tempCols = (ArrayList)primaryKeyMetaData.get(tablename);
                    if (!tempCols.contains(columnname)) {
                        tempCols.add(columnname);
                    }
                }
            }
            if (metadataString == null || metadataString.indexOf("PRIMARY_KEY=:") == -1) continue;
            metadataString = br.readLine();
        }
    }

    public void setDatatypeMapping(int toDB, DatatypeMapping mapping) {
        this.dbCumDatatypeMapping.put(new Integer(toDB), mapping);
    }

    public void setDatatypeMapping(int toDB, String datatypeMappingFileName) {
        this.dbCumDatatypeMappingFile.put(new Integer(toDB), datatypeMappingFileName);
        try {
            this.setDatatypeMappingWithMappingObject(new Integer(toDB));
        }
        catch (IOException ioe) {
            System.out.println(" Problem in loading datatype mapping from a file/Input stream. Proceeding with default handling ... ");
        }
        catch (Exception e) {
            System.out.println(" Problem in loading datatype mapping from a file/Input stream. Proceeding with default handling ...");
            e.printStackTrace();
        }
    }

    public void setDatatypeMapping(int toDB, InputStreamReader isr) {
        this.dbCumDatatypeMappingStream.put(new Integer(toDB), isr);
        try {
            this.setDatatypeMappingWithMappingObject(new Integer(toDB));
        }
        catch (IOException ioe) {
            System.out.println(" Problem in loading datatype mapping from a file/Input stream. Proceeding with default handling ... ");
        }
        catch (Exception e) {
            System.out.println(" Problem in loading datatype mapping from a file/Input stream. Proceeding with default handling ...");
            e.printStackTrace();
        }
    }

    public static void setObjectsOwnerName(int targetDatabase, String ownerName) {
        objectsOwnerName.put(new Integer(targetDatabase), ownerName);
    }

    public static void setIdentityMapping(String fileName) {
        try {
            File f = new File(fileName);
            FileInputStream fstream = new FileInputStream(f);
            DataInputStream in = new DataInputStream(fstream);
            InputStreamReader isr = new InputStreamReader(in);
            SwisSQLAPI.setIdentityMapping(isr);
            isr.close();
            fstream.close();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setIdentityMapping(InputStreamReader isr) {
        BufferedReader br = new BufferedReader(isr);
        try {
            String strLine;
            while ((strLine = br.readLine()) != null) {
                if (strLine.startsWith("#") || strLine.indexOf("=") == -1 || strLine.indexOf(".") == -1 || strLine.startsWith("/*") || strLine.startsWith("--")) continue;
                String[] datatype = strLine.trim().split("=");
                String temp = datatype[0].trim().toString();
                String identity = datatype[1].trim().toString();
                if (temp.indexOf(".") == -1) continue;
                identityMapping.put(temp, identity);
            }
            br.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void setDatatypeMappingWithMappingObject(Integer toDB) throws IOException, Exception {
        Enumeration enum1;
        if (this.dbCumDatatypeMappingStream.size() > 0 && (enum1 = this.dbCumDatatypeMappingStream.keys()) != null) {
            while (enum1.hasMoreElements()) {
                Object obj = enum1.nextElement();
                if (!obj.equals(toDB)) continue;
                BufferedReader br = new BufferedReader((InputStreamReader)this.dbCumDatatypeMappingStream.get(obj));
                DatatypeMapping mapping = null;
                if (br != null) {
                    String mappingString = br.readLine();
                    mapping = new DatatypeMapping();
                    while (mappingString != null) {
                        if (mappingString.indexOf("=") != -1 && !mappingString.trim().startsWith("#")) {
                            StringTokenizer stringTokenizer = new StringTokenizer(mappingString, "=");
                            String tabCol = stringTokenizer.nextToken().trim();
                            String mapped = stringTokenizer.nextToken().trim();
                            if (tabCol.indexOf(".") == -1) {
                                mapping.addGlobalDatatypeMapping(tabCol, mapped);
                            } else {
                                StringTokenizer tabCols = new StringTokenizer(tabCol, ".");
                                String tab = tabCols.nextToken().trim();
                                String col = tabCols.nextToken().trim();
                                mapping.addTableSpecificDatatypeMapping(tab, col, mapped);
                            }
                        }
                        mappingString = br.readLine();
                    }
                    br.close();
                }
                if (this.dbCumDatatypeMapping.containsKey(obj)) {
                    this.dbCumDatatypeMapping.remove(obj);
                }
                this.dbCumDatatypeMapping.put(obj, mapping);
            }
        }
        if (this.dbCumDatatypeMappingFile.size() > 0 && (enum1 = this.dbCumDatatypeMappingFile.keys()) != null) {
            while (enum1.hasMoreElements()) {
                DatatypeMapping mapping = new DatatypeMapping();
                Object obj = enum1.nextElement();
                if (!obj.equals(toDB)) continue;
                String mappingFileName = this.dbCumDatatypeMappingFile.get(obj).toString();
                File file = new File(mappingFileName);
                if (file.exists()) {
                    FileInputStream str2 = new FileInputStream(file);
                    Properties props = new Properties();
                    props.load(str2);
                    Enumeration<Object> enumProp = props.keys();
                    if (enumProp == null) continue;
                    while (enumProp.hasMoreElements()) {
                        String key = (String)enumProp.nextElement();
                        String val = (String)props.get(key);
                        if (key.indexOf(".") == -1) {
                            mapping.addGlobalDatatypeMapping(key, val);
                            continue;
                        }
                        StringTokenizer tabCol = new StringTokenizer(key, ".");
                        String tab = tabCol.nextToken().trim();
                        String col = tabCol.nextToken().trim();
                        mapping.addTableSpecificDatatypeMapping(tab, col, val);
                    }
                    if (this.dbCumDatatypeMapping.containsKey(obj)) {
                        this.dbCumDatatypeMapping.remove(obj);
                    }
                    this.dbCumDatatypeMapping.put(obj, mapping);
                    continue;
                }
                System.out.println(mappingFileName + " file is not found ...");
            }
        }
    }

    public void loadObjectNameMapping(String objectNameMappingFileName) {
        try {
            FileInputStream fis = new FileInputStream(objectNameMappingFileName);
            InputStreamReader isr = new InputStreamReader(fis);
            this.loadObjectNameMapping(isr);
            isr.close();
            fis.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(" objectName mapping file not found " + objectNameMappingFileName + ". Proceeding with default handling...");
        }
        catch (Exception e) {
            System.out.println(" Exception in loading the object name mapping . Proceeding with default handling...");
        }
    }

    public void loadObjectNameMapping(InputStreamReader objectNameMappingStreamReader) {
        try {
            BufferedReader br = new BufferedReader(objectNameMappingStreamReader);
            String mappingString = br.readLine();
            while (mappingString != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(mappingString, "=:");
                String sourceObjName = "";
                String targetObjName = "";
                if (stringTokenizer.hasMoreTokens()) {
                    sourceObjName = stringTokenizer.nextToken().trim();
                    if (stringTokenizer.hasMoreTokens()) {
                        targetObjName = stringTokenizer.nextToken().trim();
                    }
                    SwisSQLUtils.objectNameMapping.put(sourceObjName, targetObjName);
                }
                mappingString = br.readLine();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObjectNameMappingToFile(String objectNameMappingFileName) {
        if (SwisSQLUtils.objectNameMapping.size() == 0) {
            return;
        }
        File conf = new File(objectNameMappingFileName);
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(conf);
            bw = new BufferedWriter(fw);
            Enumeration keysEnum = SwisSQLUtils.objectNameMapping.keys();
            Enumeration valuesEnum = SwisSQLUtils.objectNameMapping.elements();
            while (keysEnum.hasMoreElements() && valuesEnum.hasMoreElements()) {
                String mapping = keysEnum.nextElement().toString() + ":=" + valuesEnum.nextElement().toString();
                bw.write(mapping);
                bw.newLine();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public SwisSQLStatement getCurrentSwisSQLStatement() {
        return this.currentSwisSQLStatement;
    }

    public void loadColumnDatatype(String fileName) throws IOException {
        try {
            FileInputStream fis = new FileInputStream(fileName);
            InputStreamReader isr = new InputStreamReader(fis);
            this.loadColumnDatatype(isr);
            isr.close();
            fis.close();
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(" loadColumnDatatype : File not found " + fileName + ". Proceeding with default handling...");
        }
        catch (IOException ioe) {
            System.out.println(" loadColumnDatatype : IOException. Proceeding with default handling...");
        }
        catch (Exception e) {
            System.out.println(" loadColumnDatatype : Exception in loading column datatypes. Proceeding with default handling...");
        }
    }

    public void loadColumnDatatype(InputStreamReader isr) throws IOException {
        columnDatatypes = new Hashtable();
        BufferedReader br = new BufferedReader(isr);
        String metadataString = br.readLine();
        while (metadataString != null) {
            String[] split = metadataString.split("=:");
            String columnname = split[0];
            String datatype = split[1];
            columnDatatypes.put(columnname, datatype);
            metadataString = br.readLine();
        }
    }

    public static void setTargetDBFunctionMappingFile(String filename) {
        targetDBFunctionMappingFile = filename;
    }

    public static void addFunctionNameMapping(String originalFunctionName, String mappedFunctionName) {
        targetDBMappedFunctionNames.put(originalFunctionName.trim().toUpperCase(), mappedFunctionName.trim());
    }

    public void loadFunctionNameMapping(String filename) {
        try {
            FileInputStream functionMap = new FileInputStream(filename);
            InputStreamReader isr = new InputStreamReader(functionMap);
            this.loadFunctionNameMapping(isr);
            isr.close();
            functionMap.close();
        }
        catch (FileNotFoundException fnf) {
            System.out.println("LoadFunctionMapping : File " + filename + " Not Found : Proceeding with Default configurations");
        }
        catch (IOException ioe) {
            System.out.println("LoadFunctionMapping : IO Exception Occured : Proceeding with default configurations");
        }
        catch (Exception e) {
            System.out.println("LoadFunctionMapping : Exception while loading function mappings" + e.getMessage());
        }
    }

    public void loadFunctionNameMapping(InputStreamReader isr) throws IOException {
        targetDBMappedFunctionNames = new HashMap();
        BufferedReader reader = new BufferedReader(isr);
        String functionMap = reader.readLine();
        while (functionMap != null) {
            String[] functionNames;
            if (!functionMap.trim().equals("") && !functionMap.startsWith("#") && (functionNames = functionMap.split(":=")).length == 2) {
                SwisSQLAPI.addFunctionNameMapping(functionNames[0], functionNames[1]);
            }
            functionMap = reader.readLine();
        }
    }

    public String getBuildID() {
        return "5.0_OCT_09_2009";
    }

    static {
        tozohodb = false;
        objectsOwnerName = new HashMap();
        targetDBMappedFunctionNames = new HashMap();
        targetDBFunctionMappingFile = null;
        truncateTableNameForDB2 = true;
        truncateTableNameForOracle = true;
        truncateTableCount = 0;
        truncateIndexCount = 0;
        truncateConstraintCount = 0;
    }
}

