/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.config.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class MetaDataProperties {
    private String connectionURL;
    private String driverName;
    private String userName;
    private String passwd;
    private String catalogName;
    private String schemaName;
    private String tableNamePattern;
    private String columnNamePattern;
    private String destinationFile;

    public MetaDataProperties() {
    }

    public MetaDataProperties(String fileName) throws IOException {
        if (fileName == null) {
            this.loadMetaDataConfiguration("conf/MetaDataConfiguration.conf");
        } else {
            this.loadMetaDataConfiguration(fileName);
        }
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setColumnNamePattern(String columnNamePattern) {
        this.columnNamePattern = columnNamePattern;
    }

    public void setMetadataStorageFile(String fileName) {
        this.destinationFile = fileName;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public String getColumnNamePattern() {
        return this.columnNamePattern;
    }

    public String getMetadataStorageFile() {
        return this.destinationFile;
    }

    public void loadMetaDataConfiguration(String fileName) throws IOException {
        File file = null;
        file = fileName == null ? new File("conf/MetaDataConfiguration.conf") : new File(fileName);
        if (file.exists()) {
            FileInputStream str2 = new FileInputStream(file);
            Properties props = new Properties();
            props.load(str2);
            Enumeration<Object> enum1 = props.keys();
            while (enum1.hasMoreElements()) {
                String key = (String)enum1.nextElement();
                String val = (String)props.get(key);
                if (key.equalsIgnoreCase("connectionurl")) {
                    this.setConnectionURL(val);
                    continue;
                }
                if (key.equalsIgnoreCase("drivername")) {
                    this.setDriverName(val);
                    continue;
                }
                if (key.equalsIgnoreCase("user")) {
                    this.setUserName(val);
                    continue;
                }
                if (key.equalsIgnoreCase("password")) {
                    this.setPasswd(val);
                    continue;
                }
                if (key.equalsIgnoreCase("catalogname")) {
                    this.setCatalogName(val);
                    continue;
                }
                if (key.equalsIgnoreCase("schemaname")) {
                    this.setSchemaName(val);
                    continue;
                }
                if (key.equalsIgnoreCase("tablenamepattern")) {
                    this.setTableNamePattern(val);
                    continue;
                }
                if (key.equalsIgnoreCase("columnnamepattern")) {
                    this.setColumnNamePattern(val);
                    continue;
                }
                if (!key.equalsIgnoreCase("metadatastoragefile")) continue;
                this.setMetadataStorageFile(val);
            }
        } else {
            System.out.println(fileName + " file is not found ...");
        }
    }
}

