/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.functions.analytic;

import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.statement.select.CaseStatement;
import com.adventnet.swissqlapi.sql.statement.select.FromTable;
import com.adventnet.swissqlapi.sql.statement.select.GroupByStatement;
import com.adventnet.swissqlapi.sql.statement.select.HavingStatement;
import com.adventnet.swissqlapi.sql.statement.select.OrderByStatement;
import com.adventnet.swissqlapi.sql.statement.select.OrderItem;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.SelectStatement;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhenStatement;
import com.adventnet.swissqlapi.sql.statement.select.WhereColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereExpression;
import com.adventnet.swissqlapi.sql.statement.select.WhereItem;
import java.util.ArrayList;
import java.util.Vector;

public class DenseRank
extends FunctionCalls {
    @Override
    public void toTeradata(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (this.getWithinGroup() != null) {
            if (this.functionArguments.size() > 1 || this.getOrderBy().getOrderItemList().size() > 1) {
                return;
            }
            String caseOper = "<";
            SelectColumn funcArg = (SelectColumn)this.functionArguments.firstElement();
            funcArg = funcArg.toTeradataSelect(to_sqs, from_sqs);
            OrderItem orderByArg = (OrderItem)this.getOrderBy().getOrderItemList().firstElement();
            orderByArg = orderByArg.toTeradataSelect(to_sqs, from_sqs);
            SelectColumn orderByCol = orderByArg.getOrderSpecifier();
            if (orderByArg.getOrder() != null && orderByArg.getOrder().equalsIgnoreCase("DESC")) {
                caseOper = ">";
            }
            CaseStatement caseStmt = new CaseStatement();
            caseStmt.setCaseClause("CASE");
            Vector<WhenStatement> whenStmtList = new Vector<WhenStatement>();
            WhenStatement whenStmt = new WhenStatement();
            whenStmt.setWhenClause("WHEN");
            WhereExpression whereExp = new WhereExpression();
            WhereItem wi = new WhereItem();
            WhereColumn lwe = new WhereColumn();
            Vector<SelectColumn> lweExp = new Vector<SelectColumn>();
            lweExp.add(orderByCol);
            lwe.setColumnExpression(lweExp);
            wi.setLeftWhereExp(lwe);
            wi.setOperator(caseOper);
            WhereColumn rwe = new WhereColumn();
            Vector<SelectColumn> rweExp = new Vector<SelectColumn>();
            rweExp.add(funcArg);
            rwe.setColumnExpression(rweExp);
            wi.setRightWhereExp(rwe);
            Vector<WhereItem> whereItemList = new Vector<WhereItem>();
            whereItemList.add(wi);
            whereExp.setWhereItem(whereItemList);
            whenStmt.setWhenCondition(whereExp);
            whenStmt.setThenClause("THEN");
            whenStmt.setThenStatement(orderByCol);
            whenStmtList.add(whenStmt);
            caseStmt.setWhenStatementList(whenStmtList);
            caseStmt.setElseClause("ELSE");
            SelectColumn elseCol = new SelectColumn();
            Vector<String> elseColExp = new Vector<String>();
            elseColExp.add("NULL");
            elseCol.setColumnExpression(elseColExp);
            caseStmt.setElseStatement(elseCol);
            caseStmt.setEndClause("END");
            FunctionCalls countFunc = new FunctionCalls();
            TableColumn countFuncName = new TableColumn();
            countFuncName.setColumnName("COUNT");
            countFunc.setFunctionName(countFuncName);
            countFunc.setArgumentQualifier("DISTINCT");
            SelectColumn countFuncCol = new SelectColumn();
            Vector<CaseStatement> countFuncArgExp = new Vector<CaseStatement>();
            countFuncArgExp.add(caseStmt);
            countFuncCol.setColumnExpression(countFuncArgExp);
            Vector<SelectColumn> countFuncArgs = new Vector<SelectColumn>();
            countFuncArgs.add(countFuncCol);
            countFunc.setFunctionArguments(countFuncArgs);
            SelectColumn newArg = new SelectColumn();
            Vector<Object> newArgExp = new Vector<Object>();
            newArgExp.add("(");
            newArgExp.add(countFunc);
            newArgExp.add("+");
            newArgExp.add("1");
            newArg.setColumnExpression(newArgExp);
            this.setFunctionName(null);
            Vector<SelectColumn> arguments = new Vector<SelectColumn>();
            arguments.add(newArg);
            this.setFunctionArguments(arguments);
            this.setOver(null);
            this.setOrderBy(null);
            this.setPartitionByClause(null);
            this.setWithinGroup(null);
        } else {
            from_sqs.setOlapFunctionPresent(true);
            String alias = from_sqs.getFromClause().getLastElement().getAliasName();
            String idx = "" + from_sqs.getOlapDerivedTables().size();
            if (this.getPartitionByClause() != null) {
                String partitionString = "denserank" + this.getPartitionByClause().toString();
                if (from_sqs.getOlapDerivedTables().containsKey(partitionString)) {
                    idx = "" + (from_sqs.getOlapDerivedTables().size() - 1);
                }
                from_sqs.addOlapDerivedTables(partitionString + this.obs, this.createTeradataDerivedTable(to_sqs, this, null, alias + idx));
            } else {
                if (from_sqs.getOlapDerivedTables().containsKey("denserank" + this.obs)) {
                    idx = "" + (from_sqs.getOlapDerivedTables().size() - 1);
                }
                from_sqs.addOlapDerivedTables("denserank" + this.obs, this.createTeradataDerivedTable(to_sqs, this, null, alias + idx));
            }
            TableColumn newTabCol = new TableColumn();
            newTabCol.setTableName(alias + idx);
            newTabCol.setColumnName("rnk");
            this.setFunctionName(newTabCol);
            this.getFunctionArguments().clear();
            this.setOpenBracesForFunctionNameRequired(false);
            this.setPartitionByClause(null);
            this.setOver(null);
            this.setOrderBy(null);
        }
    }

    @Override
    public FromTable createTeradataDerivedTable(SelectQueryStatement to_sqs, FunctionCalls fnCall, SelectColumn functionArgument, String alias) throws ConvertException {
        String fnName = fnCall.getFunctionName().getColumnName();
        SelectQueryStatement derivedTable = new SelectQueryStatement();
        SelectStatement selStmt = new SelectStatement();
        selStmt.setSelectClause("SELECT");
        Vector<SelectColumn> newSelColList = new Vector<SelectColumn>();
        Vector<WhereItem> newWhereItemList = new Vector<WhereItem>();
        HavingStatement qualifyStmt = new HavingStatement();
        qualifyStmt.setHavingClause("QUALIFY");
        WhereExpression qualifyExpression = new WhereExpression();
        Vector<WhereExpression> qualifyItems = new Vector<WhereExpression>();
        SelectColumn rownumCol = this.getNewSelectColumnForDerivedTable(fnCall, 0);
        newSelColList.add(rownumCol);
        WhereItem wi = new WhereItem();
        WhereColumn lwc = new WhereColumn();
        Vector<TableColumn> lwcColExp = new Vector<TableColumn>();
        TableColumn tc1 = new TableColumn();
        tc1.setColumnName(rownumCol.getAliasName());
        lwcColExp.add(tc1);
        WhereColumn rwc = new WhereColumn();
        Vector<String> rwcColExp = new Vector<String>();
        rwcColExp.add("1");
        lwc.setColumnExpression(lwcColExp);
        rwc.setColumnExpression(rwcColExp);
        wi.setLeftWhereExp(lwc);
        wi.setRightWhereExp(rwc);
        wi.setOperator("=");
        qualifyExpression.addWhereItem(wi);
        qualifyItems.add(qualifyExpression);
        if (functionArgument != null) {
            newSelColList.add(functionArgument);
        }
        if (fnCall.getPartitionByClause() != null) {
            ArrayList selColsList = fnCall.getPartitionByClause().getSelectColumnList();
            for (int k = 0; k < selColsList.size(); ++k) {
                if (!(selColsList.get(k) instanceof SelectColumn)) continue;
                SelectColumn partSelCol = (SelectColumn)selColsList.get(k);
                SelectColumn newPartSelCol = new SelectColumn();
                newPartSelCol.setColumnExpression(partSelCol.getColumnExpression());
                newPartSelCol.setAliasName("partition_" + k);
                newPartSelCol.setEndsWith(",");
                newWhereItemList.add(this.generateWhereItems(partSelCol, alias, "partition_" + k));
                newSelColList.add(newPartSelCol);
            }
        } else {
            newWhereItemList.add(wi);
        }
        if (fnName.equalsIgnoreCase("dense_rank") && fnCall.getOrderBy() != null) {
            OrderByStatement obs = fnCall.getOrderBy();
            Vector orderItemList = obs.getOrderItemList();
            for (int i_count = 0; i_count < orderItemList.size(); ++i_count) {
                OrderItem oi = (OrderItem)orderItemList.elementAt(i_count);
                if (oi == null) continue;
                SelectColumn orderSelCol = oi.getOrderSpecifier();
                SelectColumn newOrderSelCol = new SelectColumn();
                newOrderSelCol.setColumnExpression(orderSelCol.getColumnExpression());
                newOrderSelCol.setAliasName("order_" + i_count);
                newOrderSelCol.setEndsWith(",");
                newWhereItemList.add(this.generateWhereItems(orderSelCol, alias, "order_" + i_count));
                newSelColList.add(newOrderSelCol);
            }
        }
        ((SelectColumn)newSelColList.lastElement()).setEndsWith(null);
        selStmt.setSelectItemList(newSelColList);
        derivedTable.setSelectStatement(selStmt);
        qualifyStmt.setHavingItems(qualifyItems);
        if (fnName.equalsIgnoreCase("dense_rank") || fnName.equalsIgnoreCase("count")) {
            GroupByStatement gbs = new GroupByStatement();
            gbs.setGroupClause("GROUP BY");
            Vector<SelectColumn> groupByItems = new Vector<SelectColumn>();
            for (int k = 1; k < newSelColList.size(); ++k) {
                SelectColumn gbsSC = new SelectColumn();
                Vector<String> gbsSCExp = new Vector<String>();
                gbsSCExp.add("" + (k + 1));
                gbsSC.setColumnExpression(gbsSCExp);
                groupByItems.add(gbsSC);
            }
            gbs.setGroupByItemList(groupByItems);
            derivedTable.setGroupByStatement(gbs);
        } else {
            derivedTable.setHavingStatement(qualifyStmt);
        }
        FromTable derivedTableFromItem = new FromTable();
        derivedTableFromItem.setTableName(derivedTable);
        derivedTableFromItem.setAliasName(alias);
        derivedTableFromItem.setJoinClause("INNER JOIN ");
        derivedTableFromItem.setOnOrUsingJoin("ON");
        Vector<WhereExpression> joinCondition = new Vector<WhereExpression>();
        WhereExpression we = new WhereExpression();
        we.setWhereItem(newWhereItemList);
        Vector<String> operators = new Vector<String>();
        for (int s = 0; s < newWhereItemList.size() - 1; ++s) {
            operators.add("AND");
        }
        we.setOperator(operators);
        joinCondition.add(we);
        derivedTableFromItem.setJoinExpression(joinCondition);
        return derivedTableFromItem;
    }

    private SelectColumn getNewSelectColumnForDerivedTable(FunctionCalls fnCall, int argIndex) throws ConvertException {
        SelectColumn rownumSelCol = new SelectColumn();
        String origFnName = fnCall.getFunctionName().getColumnName();
        if (origFnName.equalsIgnoreCase("count")) {
            FunctionCalls countFunc = new FunctionCalls();
            countFunc.setFunctionName(fnCall.getFunctionName());
            countFunc.setFunctionArguments(fnCall.getFunctionArguments());
            countFunc.setArgumentQualifier(fnCall.getArgumentQualifier());
            Vector<FunctionCalls> rownumSelColExp = new Vector<FunctionCalls>();
            rownumSelColExp.add(countFunc);
            rownumSelCol.setColumnExpression(rownumSelColExp);
            rownumSelCol.setAliasName("cnt_" + argIndex);
        } else {
            FunctionCalls rownumFunc = new FunctionCalls();
            TableColumn rownumFuncName = new TableColumn();
            rownumFuncName.setColumnName("ROW_NUMBER");
            rownumFunc.setFunctionName(rownumFuncName);
            rownumFunc.setFunctionArguments(new Vector());
            if (fnCall.getPartitionByClause() != null) {
                rownumFunc.setPartitionByClause(fnCall.getPartitionByClause());
            }
            if (fnCall.getOrderBy() != null) {
                OrderByStatement obs = fnCall.getOrderBy();
                if (origFnName.equalsIgnoreCase("last_value")) {
                    Vector orderItemList = obs.getOrderItemList();
                    for (int i_count = 0; i_count < orderItemList.size(); ++i_count) {
                        OrderItem oi = (OrderItem)orderItemList.elementAt(i_count);
                        if (oi == null) continue;
                        String orderType = oi.getOrder();
                        if (orderType != null && orderType.equalsIgnoreCase("ASC")) {
                            oi.setOrder("DESC");
                        }
                        if (orderType != null && orderType.equalsIgnoreCase("DESC")) {
                            oi.setOrder("ASC");
                            continue;
                        }
                        if (orderType != null) continue;
                        oi.setOrder("DESC");
                    }
                }
                rownumFunc.setOrderBy(obs);
            }
            rownumFunc.setOver("OVER");
            Vector<FunctionCalls> rownumSelColExp = new Vector<FunctionCalls>();
            rownumSelColExp.add(rownumFunc);
            rownumSelCol.setColumnExpression(rownumSelColExp);
            if (origFnName.equalsIgnoreCase("dense_rank")) {
                rownumSelCol.setAliasName("rnk");
            } else {
                rownumSelCol.setAliasName("rownum_" + argIndex);
            }
        }
        rownumSelCol.setEndsWith(",");
        return rownumSelCol;
    }

    private WhereItem generateWhereItems(SelectColumn selCol, String derivedTableAlias, String derivedTableColumn) throws ConvertException {
        WhereItem wi = new WhereItem();
        WhereColumn lwc = new WhereColumn();
        Vector<SelectColumn> lwcColExp = new Vector<SelectColumn>();
        lwcColExp.add(selCol);
        WhereColumn rwc = new WhereColumn();
        Vector<TableColumn> rwcColExp = new Vector<TableColumn>();
        if (selCol != null) {
            TableColumn rsc = new TableColumn();
            rsc.setTableName(derivedTableAlias);
            rsc.setColumnName(derivedTableColumn);
            rwcColExp.add(rsc);
        }
        lwc.setColumnExpression(lwcColExp);
        rwc.setColumnExpression(rwcColExp);
        wi.setLeftWhereExp(lwc);
        wi.setRightWhereExp(rwc);
        wi.setOperator("=");
        return wi;
    }
}

