/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.create;

import com.adventnet.swissqlapi.SwisSQLAPI;
import com.adventnet.swissqlapi.config.SwisSQLOptions;
import com.adventnet.swissqlapi.config.datatypes.DatatypeMapping;
import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.statement.create.BinClass;
import com.adventnet.swissqlapi.sql.statement.create.CharacterClass;
import com.adventnet.swissqlapi.sql.statement.create.CheckConstraintClause;
import com.adventnet.swissqlapi.sql.statement.create.ConstraintClause;
import com.adventnet.swissqlapi.sql.statement.create.ConstraintType;
import com.adventnet.swissqlapi.sql.statement.create.CreateQueryStatement;
import com.adventnet.swissqlapi.sql.statement.create.CreateSequenceStatement;
import com.adventnet.swissqlapi.sql.statement.create.Datatype;
import com.adventnet.swissqlapi.sql.statement.create.DateClass;
import com.adventnet.swissqlapi.sql.statement.create.DefaultConstraintClause;
import com.adventnet.swissqlapi.sql.statement.create.ForeignConstraintClause;
import com.adventnet.swissqlapi.sql.statement.create.GeometryClass;
import com.adventnet.swissqlapi.sql.statement.create.NotNull;
import com.adventnet.swissqlapi.sql.statement.create.NumericClass;
import com.adventnet.swissqlapi.sql.statement.create.PrimaryOrUniqueConstraintClause;
import com.adventnet.swissqlapi.sql.statement.create.QuotedIdentifierDatatype;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereExpression;
import com.adventnet.swissqlapi.sql.statement.select.WhereItem;
import com.adventnet.swissqlapi.sql.statement.update.TableObject;
import com.adventnet.swissqlapi.util.SwisSQLUtils;
import com.adventnet.swissqlapi.util.misc.CastingUtil;
import com.adventnet.swissqlapi.util.misc.CustomizeUtil;
import com.adventnet.swissqlapi.util.misc.StringFunctions;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class CreateColumn {
    private String columnName;
    private String nullStatus;
    private String onDefault;
    private String defaultValue;
    private String defaultOpenBrace;
    private String defaultClosedBrace;
    private FunctionCalls functionCall;
    private String identity;
    Datatype datatype;
    private String userDefinedDatatype;
    private Vector constraintVector;
    private Vector constraintNullVector;
    private NotNull notNull;
    private String tableNameFromCQS;
    private String startString;
    private String withString;
    private String increment;
    private String byString;
    private String generated;
    private String always;
    private String byForAlways;
    private String defaultForIdentity;
    private String asForIdentity;
    private boolean notNullSetFromCreateQueryStatement = false;
    private String collate;
    private String collationName;
    private String autoIncrement;
    private boolean booleanOracle = false;
    private boolean booleanDb2 = false;
    private UserObjectContext context = null;
    private DatatypeMapping datatypeMapping;
    private boolean isAlterStatement = false;
    private String datapageStorageLevel;
    private String createSequenceStr;
    private ArrayList defaultExpList;
    private String onUpdateClause = null;
    Datatype castDatatype;
    private SelectColumn computedColumnExpression;
    private String computedColumnAS;
    private String sparseStr;
    private static Hashtable userdefinedDatatypes = new Hashtable();
    private static Hashtable userConfiguredDatatypes = new Hashtable();

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setObjectContext(UserObjectContext context) {
        this.context = context;
    }

    public void setDatatype(Datatype datatype) {
        this.datatype = datatype;
    }

    public void setUserDefinedDatatype(String userDefinedDatatype) {
        this.userDefinedDatatype = userDefinedDatatype;
    }

    public void setDefault(String onDefault) {
        this.onDefault = onDefault;
    }

    public void setDefaultOpenBrace(String defaultOpenBrace) {
        this.defaultOpenBrace = defaultOpenBrace;
    }

    public void setDefaultClosedBrace(String defaultClosedBrace) {
        this.defaultClosedBrace = defaultClosedBrace;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDefaultFunction(FunctionCalls functionCall) {
        this.functionCall = functionCall;
    }

    public void setDefaultExpression(ArrayList defaultExpList) {
        this.defaultExpList = defaultExpList;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public void setCastDatatype(Datatype castDatatype) {
        this.castDatatype = castDatatype;
    }

    public void setNotNull(NotNull notNull) {
        this.notNull = notNull;
        this.identity = notNull.getIdentity();
        this.nullStatus = notNull.getNullStatus();
        this.startString = notNull.getStart();
        this.withString = notNull.getWith();
        this.increment = notNull.getIncrement();
        this.byString = notNull.getBy();
    }

    public void setTableNameFromCreateQueryStmt(String tableNameFromCQS) {
        this.tableNameFromCQS = tableNameFromCQS;
    }

    public void setNullStatus(String nullStatus) {
        this.nullStatus = nullStatus;
    }

    public void setNotNullSetFromCreateQueryStatement(boolean setNotNullValue) {
        this.notNullSetFromCreateQueryStatement = setNotNullValue;
    }

    public void setConstraintClause(Vector constraintVector) {
        this.constraintVector = constraintVector;
    }

    public void setCollate(String collate) {
        this.collate = collate;
    }

    public void setCollationName(String collationName) {
        this.collationName = collationName;
    }

    public void setGenerated(String generated) {
        this.generated = generated;
    }

    public void setAlways(String always) {
        this.always = always;
    }

    public void setOnUpdateClause(String val) {
        this.onUpdateClause = val;
    }

    public void setSparseString(String sparse) {
        this.sparseStr = sparse;
    }

    public String getOnUpdateClause() {
        return this.onUpdateClause;
    }

    public String getGenerated() {
        return this.generated;
    }

    public void setByForAlways(String byForAlways) {
        this.byForAlways = byForAlways;
    }

    public void setDefaultForIdentity(String defaultForIdentity) {
        this.defaultForIdentity = defaultForIdentity;
    }

    public void setIdentityAs(String asForIdentity) {
        this.asForIdentity = asForIdentity;
    }

    public void setAutoIncrement(String autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public void setDatatypeMapping(DatatypeMapping mapping) {
        this.datatypeMapping = mapping;
    }

    public void setAlterStatement(boolean isAlterStatement) {
        this.isAlterStatement = isAlterStatement;
    }

    public void setDatapageStorageLevel(String datapageStorageLevel) {
        this.datapageStorageLevel = datapageStorageLevel;
    }

    public void setCreateSequenceString(String createSequenceStr) {
        this.createSequenceStr = createSequenceStr;
    }

    public void setComputedColumnExpression(SelectColumn computedColExpr) {
        this.computedColumnExpression = computedColExpr;
    }

    public void setComputedColumnAS(String as) {
        this.computedColumnAS = as;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public String getUserDefinedDatatype() {
        return this.userDefinedDatatype;
    }

    public String getDefault() {
        return this.onDefault;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getAutoIncrement() {
        return this.autoIncrement;
    }

    public FunctionCalls getDefaultFunction() {
        return this.functionCall;
    }

    public ArrayList getDefaultExpression() {
        return this.defaultExpList;
    }

    public String getIdentity() {
        return this.identity;
    }

    public Vector getConstraintClause() {
        return this.constraintVector;
    }

    public String getNullStatus() {
        return this.nullStatus;
    }

    public String getDatapageStorageLevel() {
        return this.datapageStorageLevel;
    }

    public String getCreateSequenceString() {
        return this.createSequenceStr;
    }

    public Datatype getCastDatatype() {
        return this.castDatatype;
    }

    public SelectColumn getComputedColumnExpression() {
        return this.computedColumnExpression;
    }

    public String getComputedColumnAS() {
        return this.computedColumnAS;
    }

    public String getSparseString() {
        return this.sparseStr;
    }

    public void toDB2String() throws ConvertException {
        Datatype toDB2Datatype;
        Vector changeConstraintVector;
        StringBuffer temp_SB;
        this.setDatapageStorageLevel(null);
        if (this.columnName != null && (this.columnName.startsWith("[") && this.columnName.endsWith("]") || this.columnName.startsWith("`") && this.columnName.endsWith("`"))) {
            this.columnName = this.columnName.substring(1, this.columnName.length() - 1);
            if (this.columnName.indexOf(32) != -1) {
                this.columnName = "\"" + this.columnName + "\"";
            }
        }
        this.constraintNullVector = new Vector();
        if (this.identity != null) {
            temp_SB = new StringBuffer();
            if (this.identity.trim().equalsIgnoreCase("IDENTITY")) {
                if (this.always == null) {
                    temp_SB.append("GENERATED");
                    temp_SB.append(" BY");
                    temp_SB.append(" DEFAULT");
                    temp_SB.append(" AS ");
                }
                temp_SB.append("IDENTITY(START");
                temp_SB.append(" WITH");
                temp_SB.append(" 1");
                temp_SB.append(" INCREMENT BY");
                temp_SB.append(" 1)");
                this.identity = temp_SB.toString();
            } else {
                if (this.always == null) {
                    temp_SB.append("GENERATED");
                    temp_SB.append(" BY");
                    temp_SB.append(" DEFAULT");
                    temp_SB.append(" AS ");
                }
                String tempIdentity = this.identity.trim().substring(8).trim();
                tempIdentity = tempIdentity.substring(1, tempIdentity.length() - 1);
                StringTokenizer st = new StringTokenizer(tempIdentity, ",");
                String token1 = st.nextToken();
                temp_SB.append("IDENTITY(START");
                temp_SB.append(" WITH");
                temp_SB.append(" " + token1);
                if (st.countTokens() > 0) {
                    String token2 = st.nextToken();
                    temp_SB.append(" INCREMENT BY");
                    temp_SB.append(" " + token2 + ")");
                } else {
                    temp_SB.append(" INCREMENT BY");
                    temp_SB.append(" 1)");
                }
                this.identity = temp_SB.toString();
            }
        }
        this.setCollate(null);
        this.setCollationName(null);
        if (this.getConstraintClause() != null && (changeConstraintVector = this.getConstraintClause()) != null) {
            for (int i = 0; i < changeConstraintVector.size(); ++i) {
                ConstraintType toDB2ConstraintType;
                ConstraintClause toDB2ConstraintClause = (ConstraintClause)changeConstraintVector.get(i);
                if (toDB2ConstraintClause == null) continue;
                if (toDB2ConstraintClause.getConstraintType() != null && (toDB2ConstraintType = toDB2ConstraintClause.getConstraintType()) instanceof PrimaryOrUniqueConstraintClause && (this.getColumnName() != null || toDB2ConstraintClause.getConstraintName() != null) && !this.notNullSetFromCreateQueryStatement) {
                    this.setNullStatus("NOT NULL");
                }
                toDB2ConstraintClause.setColumnName(this.getColumnName());
                toDB2ConstraintClause.toDB2String();
                this.constraintNullVector.add(toDB2ConstraintClause);
            }
        }
        if (this.getNullStatus() != null && !this.getNullStatus().trim().equalsIgnoreCase("NULL") && !this.isAlterStatement) {
            this.constraintNullVector.add(this.getNullStatus());
        }
        if (this.getDatatype() != null) {
            if (!this.mapDatatype(this, this.datatypeMapping)) {
                toDB2Datatype = this.getDatatype();
                if (toDB2Datatype instanceof DateClass) {
                    DateClass dateClass = (DateClass)toDB2Datatype;
                    if (dateClass.getDatatypeName().equalsIgnoreCase("DATE")) {
                        dateClass.setDatatypeName("TIMESTAMP");
                    }
                    dateClass.toDB2String();
                } else if (toDB2Datatype instanceof BinClass) {
                    BinClass binClass = (BinClass)toDB2Datatype;
                    if (binClass.getDatatypeName().trim().equalsIgnoreCase("BOOLEAN")) {
                        this.booleanDb2 = true;
                    } else {
                        binClass.toDB2String();
                    }
                } else {
                    toDB2Datatype.toDB2String();
                    if (toDB2Datatype instanceof CharacterClass) {
                        this.enumValuesConvertedToCheckConstraints(toDB2Datatype, this.constraintNullVector);
                    }
                }
            }
        } else if (this.userDefinedDatatype != null && userdefinedDatatypes.size() > 0) {
            if (!this.mapUserDatatype(this, this.datatypeMapping, this.userDefinedDatatype)) {
                if (userdefinedDatatypes.containsKey(this.userDefinedDatatype.toLowerCase().trim())) {
                    this.setUserDefinedDatatype((String)userdefinedDatatypes.get(this.userDefinedDatatype.toLowerCase().trim()));
                } else if (this.userDefinedDatatype.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
                    this.setUserDefinedDatatype("VARGRAPHIC(36)");
                } else if (this.userDefinedDatatype.equalsIgnoreCase("ROWID")) {
                    this.setUserDefinedDatatype("CHAR(16) FOR BIT DATA");
                } else if (this.userDefinedDatatype.equalsIgnoreCase("SQL_VARIANT")) {
                    this.setUserDefinedDatatype("VARCHAR(800)");
                }
            }
        } else if (this.userDefinedDatatype != null && userdefinedDatatypes.size() <= 0 && !this.mapUserDatatype(this, this.datatypeMapping, this.userDefinedDatatype)) {
            if (this.userDefinedDatatype.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
                this.setUserDefinedDatatype("VARGRAPHIC(36)");
            } else if (this.userDefinedDatatype.equalsIgnoreCase("ROWID")) {
                this.setUserDefinedDatatype("CHAR(16) FOR BIT DATA");
            } else if (this.userDefinedDatatype.equalsIgnoreCase("SQL_VARIANT")) {
                this.setUserDefinedDatatype("VARCHAR(800)");
            }
        }
        if (this.getComputedColumnExpression() != null) {
            this.setComputedColumnExpression(this.getComputedColumnExpression().toDB2Select(null, null));
        }
        if (this.getDefaultValue() != null) {
            this.setDefaultOpenBrace(null);
            this.setDefaultClosedBrace(null);
            if (this.getDatatype() != null) {
                BinClass binClass;
                toDB2Datatype = this.getDatatype();
                if (toDB2Datatype instanceof NumericClass && this.getDefaultValue().startsWith("'") && this.getDefaultValue().endsWith("'")) {
                    this.setDefaultValue(this.defaultValue.substring(1, this.defaultValue.length() - 1));
                } else if (toDB2Datatype instanceof CharacterClass && this.getDefaultValue().startsWith("\"") && this.getDefaultValue().endsWith("\"")) {
                    this.setDefaultValue("'" + this.defaultValue.substring(1, this.defaultValue.length() - 1) + "'");
                } else if (this.getDatatype() instanceof DateClass) {
                    if (this.defaultValue.equals("'0000-00-00 00:00:00'") || this.defaultValue.equals("0000-00-00 00:00:00")) {
                        this.setDefaultValue("'0001-01-01 00:00:00'");
                    } else if (this.defaultValue.equals("'0000-00-00'") || this.defaultValue.equals("0000-00-00")) {
                        this.setDefaultValue("'0001-01-01'");
                    } else if (this.defaultValue.trim().equalsIgnoreCase("SYSDATE")) {
                        this.setDefaultValue("CURRENT TIMESTAMP");
                    }
                } else if (toDB2Datatype instanceof BinClass && (binClass = (BinClass)toDB2Datatype).getDatatypeName().trim().equalsIgnoreCase("BLOB")) {
                    this.setDefaultValue("BLOB(" + this.defaultValue + ")");
                }
            } else if (this.defaultValue.trim().equalsIgnoreCase("SYSDATE")) {
                this.setDefaultValue("CURRENT DATE");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT_DATE")) {
                this.setDefaultValue("CURRENT DATE");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT_TIME")) {
                this.setDefaultValue("CURRENT TIME");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT_TIMESTAMP")) {
                this.setDefaultValue("CURRENT TIMESTAMP");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT")) {
                this.setDefaultValue("CURRENT DATE");
            } else if (this.defaultValue.equalsIgnoreCase("SYSTEM_USER") || this.defaultValue.equalsIgnoreCase("CURRENT_USER")) {
                this.setDefaultValue("USER");
            }
        } else if (this.getDefaultFunction() != null) {
            if (this.getDefaultFunction().getFunctionName() != null) {
                String functionColName = this.getDefaultFunction().getFunctionName().getColumnName();
                if (functionColName.equalsIgnoreCase("GETDATE")) {
                    this.setDefaultClosedBrace(null);
                    this.setDefaultOpenBrace(null);
                    this.functionCall.setOpenBracesForFunctionNameRequired(false);
                } else if (functionColName.equalsIgnoreCase("EMPTY_CLOB")) {
                    this.setDefaultFunction(null);
                }
            }
            if (this.functionCall != null) {
                this.setDefaultFunction(this.functionCall.toDB2Select(null, null));
            }
        } else if (this.getDefaultExpression() != null) {
            ArrayList<SelectColumn> newExpList = new ArrayList<SelectColumn>();
            for (int i = 0; i < this.defaultExpList.size(); ++i) {
                if (this.defaultExpList.get(i) instanceof SelectColumn) {
                    SelectColumn sc = (SelectColumn)this.defaultExpList.get(i);
                    SelectColumn db2SC = sc.toDB2Select(null, null);
                    Vector colExpr = db2SC.getColumnExpression();
                    if (colExpr != null) {
                        for (int n = 0; n < colExpr.size(); ++n) {
                            Object obj = colExpr.get(n);
                            if (obj instanceof FunctionCalls) {
                                ((FunctionCalls)obj).setOpenBracesForFunctionNameRequired(false);
                            }
                            if (!(obj instanceof SelectColumn)) continue;
                            SelectColumn scTemp = (SelectColumn)obj;
                            Vector vtemp = scTemp.getColumnExpression();
                            if (scTemp.getOpenBrace() == null || scTemp.getCloseBrace() == null || vtemp.size() != 1) continue;
                            scTemp.setOpenBrace(null);
                            scTemp.setCloseBrace(null);
                        }
                    }
                    newExpList.add(db2SC);
                    continue;
                }
                newExpList.add((SelectColumn)this.defaultExpList.get(i));
            }
            this.setDefaultExpression(newExpList);
            this.setDefaultOpenBrace(null);
            this.setDefaultClosedBrace(null);
        }
        if (this.autoIncrement != null) {
            temp_SB = new StringBuffer();
            temp_SB.append("GENERATED");
            temp_SB.append(" BY");
            temp_SB.append(" DEFAULT");
            temp_SB.append(" AS ");
            temp_SB.append("IDENTITY(START");
            temp_SB.append(" WITH");
            temp_SB.append(" 1");
            temp_SB.append(" INCREMENT BY");
            temp_SB.append(" 1)");
            this.identity = temp_SB.toString();
            this.autoIncrement = null;
        }
        if (this.getCastDatatype() != null) {
            // empty if block
        }
    }

    public void toMSSQLServerString() throws ConvertException {
        SelectColumn sc;
        ArrayList<SelectColumn> newExpList;
        int i;
        Vector changeConstraintVector;
        this.setDatapageStorageLevel(null);
        this.constraintNullVector = new Vector();
        if (this.columnName != null && this.columnName.equalsIgnoreCase("FUNCTION")) {
            this.setColumnName(this.columnName + "_COLUMN");
        }
        this.generated = null;
        this.always = null;
        this.asForIdentity = null;
        this.byForAlways = null;
        this.defaultForIdentity = null;
        this.asForIdentity = null;
        if (this.nullStatus == null && SwisSQLOptions.sybaseNotNullConstraint && SwisSQLOptions.fromSybase && (this.getDatatype() != null || this.getUserDefinedDatatype() != null)) {
            this.nullStatus = "NOT NULL";
        }
        if (this.columnName != null) {
            if (this.columnName.startsWith("`") && this.columnName.endsWith("`")) {
                this.columnName = this.columnName.substring(1, this.columnName.length() - 1);
                if (this.columnName.indexOf(32) != -1) {
                    this.columnName = "\"" + this.columnName + "\"";
                }
            }
            String[] keywords = null;
            if (SwisSQLUtils.getKeywords(2) != null) {
                keywords = SwisSQLUtils.getKeywords(2);
                if (this.columnName.trim().length() > 0) {
                    this.columnName = CustomizeUtil.objectNamesToBracedIdentifier(this.columnName, keywords, null);
                }
            }
        }
        if (this.getConstraintClause() != null && (changeConstraintVector = this.getConstraintClause()) != null) {
            for (i = 0; i < changeConstraintVector.size(); ++i) {
                ConstraintClause toSQLServerConstraintClause = (ConstraintClause)changeConstraintVector.get(i);
                if (toSQLServerConstraintClause == null) continue;
                if (toSQLServerConstraintClause.getConstraintType() instanceof PrimaryOrUniqueConstraintClause) {
                    toSQLServerConstraintClause.setColumnName(this.getColumnName());
                    PrimaryOrUniqueConstraintClause primaryConstraintClause = (PrimaryOrUniqueConstraintClause)toSQLServerConstraintClause.getConstraintType();
                    boolean ccToBeAdded = false;
                    if (primaryConstraintClause.getConstraintColumnNames() != null && this.columnName != null) {
                        this.constraintNullVector.add(",\n\t");
                        CreateColumn cc = new CreateColumn();
                        if (this.getConstraintClause() != null) {
                            Vector primaryConstraintVector = new Vector();
                            for (int index = 0; index < this.getConstraintClause().size(); ++index) {
                                if (!(this.getConstraintClause().get(index) instanceof PrimaryOrUniqueConstraintClause)) continue;
                                primaryConstraintVector.add(this.getConstraintClause().get(index));
                                cc.setNullStatus(null);
                                cc.setDefaultValue(null);
                                cc.setDefault(null);
                                cc.toOracleString();
                                NotNull notnullObj = new NotNull();
                                notnullObj.setNullStatus(null);
                                notnullObj.setIdentity(null);
                                cc.setNotNull(notnullObj);
                                ccToBeAdded = true;
                            }
                            cc.setConstraintClause(primaryConstraintVector);
                        }
                        if (ccToBeAdded) {
                            this.constraintNullVector.add(cc);
                        }
                    }
                    if (primaryConstraintClause.getConstraintColumnNames() != null && !this.notNullSetFromCreateQueryStatement) {
                        this.setNullStatus("");
                    }
                }
                if (toSQLServerConstraintClause.getAutoIncrement() != null) {
                    this.setIdentity("IDENTITY (1,1)");
                    toSQLServerConstraintClause.setAutoIncrement(null);
                }
                toSQLServerConstraintClause.setColumnName(this.getColumnName());
                toSQLServerConstraintClause.toMSSQLServerString();
                this.constraintNullVector.add(toSQLServerConstraintClause);
            }
        }
        if (this.getComputedColumnExpression() != null) {
            this.setComputedColumnAS("AS");
            this.setComputedColumnExpression(this.getComputedColumnExpression().toMSSQLServerSelect(null, null));
        }
        if (this.getNullStatus() != null) {
            this.constraintNullVector.add(this.getNullStatus());
        }
        if (this.getDatatype() != null && !this.mapDatatype(this, this.datatypeMapping)) {
            Datatype toMSSQLServerDatatype = this.getDatatype();
            toMSSQLServerDatatype.toMSSQLServerString();
            if (toMSSQLServerDatatype instanceof CharacterClass) {
                this.enumValuesConvertedToCheckConstraints(toMSSQLServerDatatype, this.constraintNullVector);
            }
        }
        if (this.getDefaultExpression() != null) {
            newExpList = new ArrayList<SelectColumn>();
            int size = this.defaultExpList.size();
            if (size == 1) {
                if (this.defaultExpList.get(0) instanceof SelectColumn) {
                    sc = (SelectColumn)this.defaultExpList.get(0);
                    Vector expList = sc.getColumnExpression();
                    if (expList.size() == 1) {
                        TableColumn tc;
                        String colName;
                        Object obj = expList.get(0);
                        if (obj instanceof String) {
                            this.setDefaultValue((String)obj);
                        } else if (obj instanceof TableColumn && (colName = (tc = (TableColumn)obj).getColumnName()) != null) {
                            this.setDefaultValue(colName);
                        }
                    }
                } else {
                    ArrayList expWithoutSc = this.getDefaultExpression();
                    if (expWithoutSc.size() == 1 && expWithoutSc.get(0) instanceof String) {
                        this.setDefaultValue((String)expWithoutSc.get(0));
                    }
                }
            }
        }
        if (this.getDefaultValue() != null) {
            String typeName;
            Datatype type;
            if (this.defaultValue.toUpperCase().startsWith("G'") && this.defaultValue.toUpperCase().endsWith("'")) {
                String temp = this.defaultValue.substring(1);
                this.setDefaultValue(temp);
            }
            if (this.defaultValue.equalsIgnoreCase("SYSDATE")) {
                this.setDefaultValue("GETDATE()");
            }
            if (this.defaultValue.equalsIgnoreCase("SYS_GUID")) {
                this.setDefaultValue("NEWID()");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT DATE") || this.defaultValue.equalsIgnoreCase("CURRENT_DATE")) {
                this.setDefaultValue("GETDATE()");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIME") || this.defaultValue.equalsIgnoreCase("CURRENT_TIME")) {
                this.setDefaultValue("GETDATE()");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIMESTAMP") || this.defaultValue.equalsIgnoreCase("CURRENT_TIMESTAMP")) {
                this.setDefaultValue("GETDATE()");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT")) {
                this.setDefaultValue("GETDATE()");
            } else if (this.defaultValue.equalsIgnoreCase("USER") || this.defaultValue.equalsIgnoreCase("CURRENT_USER")) {
                this.setDefaultValue("SYSTEM_USER");
            } else if (this.defaultValue.toUpperCase().startsWith("EMPTY_BLOB") || this.defaultValue.toUpperCase().startsWith("EMPTY_CLOB")) {
                this.setDefaultValue("''");
            } else if (this.defaultValue.equals("'0000-00-00 00:00:00'") || this.defaultValue.equals("0000-00-00 00:00:00")) {
                this.setDefaultValue("'1753-01-01 00:00:00'");
            } else if (this.defaultValue.equals("\"\"")) {
                this.setDefaultValue("' '");
            } else if (this.defaultValue.startsWith("\"") && this.defaultValue.endsWith("\"")) {
                this.setDefaultValue("'" + this.defaultValue.substring(1, this.defaultValue.length() - 1) + "'");
            } else if (this.defaultValue.equalsIgnoreCase("true")) {
                this.setDefaultValue("1");
            } else if (this.defaultValue.equalsIgnoreCase("false")) {
                this.setDefaultValue("0");
            } else if (this.getDefault() != null && this.getDefault().equalsIgnoreCase("WITH DEFAULT ")) {
                this.setDefault("DEFAULT ");
            }
            if (this.defaultValue.startsWith("'") && (type = this.getDatatype()) != null && type instanceof BinClass && (typeName = type.getDatatypeName()) != null && typeName.equalsIgnoreCase("varbinary")) {
                this.setDefaultValue("CONVERT(VARBINARY, " + this.defaultValue + ")");
            }
        } else if (this.getDefaultFunction() != null) {
            String fnName = this.functionCall.getFunctionName().getColumnName();
            if (fnName != null && (fnName.toUpperCase().startsWith("EMPTY_BLOB") || fnName.toUpperCase().startsWith("EMPTY_CLOB"))) {
                this.functionCall.setFunctionName(null);
                Vector<String> fnArgs = new Vector<String>();
                fnArgs.add("''");
                this.functionCall.setFunctionArguments(fnArgs);
                this.functionCall.setOpenBracesForFunctionNameRequired(false);
            } else {
                this.setDefaultFunction(this.functionCall.toMSSQLServerSelect(null, null));
            }
        } else if (this.getDefaultExpression() != null) {
            newExpList = new ArrayList();
            for (i = 0; i < this.defaultExpList.size(); ++i) {
                if (this.defaultExpList.get(i) instanceof SelectColumn) {
                    sc = (SelectColumn)this.defaultExpList.get(i);
                    newExpList.add(sc.toMSSQLServerSelect(null, null));
                    continue;
                }
                newExpList.add((SelectColumn)this.defaultExpList.get(i));
            }
            this.setDefaultExpression(newExpList);
        } else if (this.getDefault() != null) {
            if (this.getDatatype() != null) {
                if (this.getDatatype() instanceof NumericClass) {
                    this.setDefaultValue("0");
                } else if (this.getDatatype() instanceof BinClass) {
                    this.setDefaultValue("''");
                } else if (this.getDatatype() instanceof CharacterClass) {
                    this.setDefaultValue("' '");
                } else if (this.getDatatype() instanceof DateClass) {
                    this.setDefaultValue("'0001-01-01 00:00:00'");
                } else {
                    this.setDefaultValue("NULL");
                }
            } else {
                this.setDefaultValue("NULL");
            }
            if (this.getDefault().equalsIgnoreCase("WITH DEFAULT ")) {
                this.setDefault("DEFAULT ");
            }
        }
        if (this.userDefinedDatatype != null && userdefinedDatatypes.size() <= 0 && !this.mapUserDatatype(this, this.datatypeMapping, this.userDefinedDatatype) && this.userDefinedDatatype.equalsIgnoreCase("ROWID")) {
            this.setUserDefinedDatatype("UNIQUEIDENTIFIER");
        }
        if (this.autoIncrement != null) {
            this.identity = "IDENTITY(1,1)";
            this.autoIncrement = null;
        }
        if (this.getCastDatatype() != null) {
            this.getCastDatatype().toMSSQLServerString();
            this.createCastFunction();
        }
    }

    public void toSybaseString() throws ConvertException {
        int i;
        Vector changeConstraintVector;
        this.constraintNullVector = new Vector();
        this.generated = null;
        this.always = null;
        this.byForAlways = null;
        this.defaultForIdentity = null;
        if (this.columnName != null && this.columnName.startsWith("`") && this.columnName.endsWith("`")) {
            this.columnName = this.columnName.substring(1, this.columnName.length() - 1);
            if (this.columnName.indexOf(32) != -1) {
                this.columnName = "\"" + this.columnName + "\"";
            }
        }
        boolean nullStatusExists = false;
        if (this.getConstraintClause() != null && (changeConstraintVector = this.getConstraintClause()) != null) {
            for (i = 0; i < changeConstraintVector.size(); ++i) {
                PrimaryOrUniqueConstraintClause tempPrimaryOrUniqueConstraintClause;
                ConstraintClause toSybaseConstraintClause = (ConstraintClause)changeConstraintVector.get(i);
                if (toSybaseConstraintClause == null) continue;
                ConstraintType toSybaseConstraintType = toSybaseConstraintClause.getConstraintType();
                toSybaseConstraintClause.setColumnName(this.getColumnName());
                toSybaseConstraintClause.toSybaseString();
                if (toSybaseConstraintType instanceof DefaultConstraintClause) {
                    this.constraintNullVector.insertElementAt(toSybaseConstraintClause, 0);
                    continue;
                }
                if (toSybaseConstraintClause.getAutoIncrement() != null) {
                    this.setIdentity("IDENTITY");
                    toSybaseConstraintClause.setAutoIncrement(null);
                }
                toSybaseConstraintClause.setColumnName(this.getColumnName());
                if (this.getIdentity() != null) {
                    Datatype datatype;
                    NumericClass numericClass;
                    String dataTypeName;
                    this.setIdentity("IDENTITY");
                    if (this.getDatatype() != null && (dataTypeName = (numericClass = (NumericClass)(datatype = this.getDatatype())).getDatatypeName()).indexOf("NUMERIC") == -1) {
                        numericClass.setDatatypeName("NUMERIC (5,0)");
                    }
                }
                if (toSybaseConstraintType instanceof PrimaryOrUniqueConstraintClause && (tempPrimaryOrUniqueConstraintClause = (PrimaryOrUniqueConstraintClause)toSybaseConstraintType).getConstraintColumnNames() != null && this.columnName != null) {
                    this.constraintNullVector.add(",\n\t");
                    if (!this.notNullSetFromCreateQueryStatement) {
                        this.setNullStatus("");
                    }
                }
                if (toSybaseConstraintType instanceof ForeignConstraintClause) {
                    ForeignConstraintClause tempForeignConstraintClause = (ForeignConstraintClause)toSybaseConstraintType;
                    if (tempForeignConstraintClause.getConstraintColumnNames() != null && this.columnName != null) {
                        this.constraintNullVector.add(",\n\t");
                    } else if (tempForeignConstraintClause.getConstraintColumnNames() == null && this.columnName == null) {
                        tempForeignConstraintClause.setConstraintName(null);
                    }
                }
                toSybaseConstraintClause.toSybaseString();
                if (toSybaseConstraintClause.getNotNull() != null && toSybaseConstraintClause.getNotNull().getNullStatus() != null && !toSybaseConstraintClause.getNotNull().getNullStatus().trim().equals("")) {
                    nullStatusExists = true;
                }
                this.constraintNullVector.add(toSybaseConstraintClause);
            }
        }
        if (this.onDefault != null && this.onDefault.trim().equalsIgnoreCase("DEFAULT") && this.getDefaultValue() != null && this.getDefaultValue().trim().equalsIgnoreCase("null") && this.notNull == null) {
            NotNull newNotNull = new NotNull();
            newNotNull.setNullStatus("NULL");
            this.setNotNull(newNotNull);
        }
        if (this.getComputedColumnExpression() != null) {
            this.setComputedColumnAS("AS");
            this.setComputedColumnExpression(this.getComputedColumnExpression().toSybaseSelect(null, null));
        }
        if (this.getNullStatus() != null) {
            this.constraintNullVector.add(this.getNullStatus());
        } else if (!SwisSQLOptions.fromSybase && this.tableNameFromCQS != null && this.columnName != null && this.identity == null && !nullStatusExists) {
            String type;
            Hashtable colTypeHT;
            this.tableNameFromCQS = this.removeDelimiter(this.tableNameFromCQS);
            String colName = this.removeDelimiter(this.columnName);
            ArrayList tempCols = (ArrayList)CastingUtil.getValueIgnoreCase(SwisSQLAPI.primaryKeyMetaData, this.tableNameFromCQS);
            if (tempCols != null) {
                if (!(tempCols.contains(colName) || tempCols.contains(colName.toLowerCase()) || tempCols.contains(colName.toUpperCase()))) {
                    if (this.notNull == null) {
                        NotNull newNotNull = new NotNull();
                        newNotNull.setNullStatus("NULL");
                        this.setNotNull(newNotNull);
                    } else {
                        this.notNull.setNullStatus("NULL");
                    }
                    this.constraintNullVector.add(this.getNullStatus());
                }
            } else if (SwisSQLAPI.dataTypesFromMetaDataHT.size() > 0 && (colTypeHT = (Hashtable)CastingUtil.getValueIgnoreCase(SwisSQLAPI.dataTypesFromMetaDataHT, this.tableNameFromCQS)) != null && (type = (String)CastingUtil.getValueIgnoreCase(colTypeHT, colName)) != null) {
                if (this.notNull == null) {
                    NotNull newNotNull = new NotNull();
                    newNotNull.setNullStatus("NULL");
                    this.setNotNull(newNotNull);
                } else {
                    this.notNull.setNullStatus("NULL");
                }
                this.constraintNullVector.add(this.getNullStatus());
            }
        }
        if (this.getDatatype() != null) {
            if (this.identity != null || this.asForIdentity != null) {
                NumericClass ncl = new NumericClass();
                ncl.setDatatypeName("NUMERIC");
                this.setDatatype(ncl);
                if (this.identity != null && this.identity.indexOf("(") != -1) {
                    this.identity = this.identity.substring(0, this.identity.indexOf("("));
                }
            } else if (!this.mapDatatype(this, this.datatypeMapping)) {
                Datatype toSybaseDatatype = this.getDatatype();
                toSybaseDatatype.toSybaseString();
                if (toSybaseDatatype instanceof CharacterClass) {
                    this.enumValuesConvertedToCheckConstraints(toSybaseDatatype, this.constraintNullVector);
                }
            }
        } else if (this.userDefinedDatatype != null && userdefinedDatatypes.size() > 0) {
            if (!this.mapUserDatatype(this, this.datatypeMapping, this.userDefinedDatatype)) {
                if (userdefinedDatatypes.containsKey(this.userDefinedDatatype.toLowerCase().trim())) {
                    this.setUserDefinedDatatype((String)userdefinedDatatypes.get(this.userDefinedDatatype.toLowerCase().trim()));
                } else if (this.userDefinedDatatype.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
                    this.setUserDefinedDatatype("CHAR(36)");
                }
            }
        } else if (this.userDefinedDatatype != null && userdefinedDatatypes.size() <= 0 && !this.mapUserDatatype(this, this.datatypeMapping, this.userDefinedDatatype) && this.userDefinedDatatype.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
            this.setUserDefinedDatatype("CHAR(36)");
        }
        if (this.getDefaultValue() != null) {
            if (this.defaultValue.equalsIgnoreCase("SYSDATE")) {
                this.setDefaultValue("GETDATE()");
            }
            if (this.defaultValue.equalsIgnoreCase("SYS_GUID")) {
                this.setDefaultValue("NEWID()");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT DATE") || this.defaultValue.equalsIgnoreCase("CURRENT_DATE")) {
                this.setDefaultValue("GETDATE()");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIME") || this.defaultValue.equalsIgnoreCase("CURRENT_TIME")) {
                this.setDefaultValue("GETDATE()");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIMESTAMP") || this.defaultValue.equalsIgnoreCase("CURRENT_TIMESTAMP")) {
                this.setDefaultValue("GETDATE()");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT")) {
                this.setDefaultValue("GETDATE()");
            } else if (this.defaultValue.equalsIgnoreCase("SYSTEM_USER") || this.defaultValue.equalsIgnoreCase("CURRENT_USER")) {
                this.setDefaultValue("USER");
            } else if (this.defaultValue.indexOf("\"") != -1) {
                this.defaultValue = "'" + this.defaultValue.substring(1, this.defaultValue.length() - 1) + "'";
                this.setDefaultValue(this.defaultValue);
            } else if (this.defaultValue.equalsIgnoreCase("true")) {
                this.setDefaultValue("1");
            } else if (this.defaultValue.equalsIgnoreCase("false")) {
                this.setDefaultValue("0");
            } else if (this.getDefault() != null && this.getDefault().equalsIgnoreCase("WITH DEFAULT ")) {
                this.setDefault("DEFAULT ");
            }
        } else if (this.getDefaultFunction() != null) {
            this.setDefaultFunction(this.functionCall.toSybaseSelect(null, null));
        } else if (this.getDefaultExpression() != null) {
            ArrayList<SelectColumn> newExpList = new ArrayList<SelectColumn>();
            for (i = 0; i < this.defaultExpList.size(); ++i) {
                if (this.defaultExpList.get(i) instanceof SelectColumn) {
                    SelectColumn sc = (SelectColumn)this.defaultExpList.get(i);
                    newExpList.add(sc.toSybaseSelect(null, null));
                    continue;
                }
                newExpList.add((SelectColumn)this.defaultExpList.get(i));
            }
            this.setDefaultExpression(newExpList);
        } else if (this.getDefault() != null) {
            if (this.getDatatype() != null) {
                if (this.getDatatype() instanceof NumericClass) {
                    this.setDefaultValue("0");
                } else if (this.getDatatype() instanceof BinClass) {
                    this.setDefaultValue("''");
                } else if (this.getDatatype() instanceof CharacterClass) {
                    this.setDefaultValue("' '");
                } else if (this.getDatatype() instanceof DateClass) {
                    this.setDefaultValue("'0001-01-01 00:00:00'");
                } else if (this.getNullStatus() != null && !this.getNullStatus().trim().equalsIgnoreCase("NOT NULL")) {
                    this.setDefaultValue("NULL");
                }
            } else if (this.getNullStatus() != null && !this.getNullStatus().trim().equalsIgnoreCase("NOT NULL")) {
                this.setDefaultValue("NULL");
            }
            if (this.getDefault().equalsIgnoreCase("WITH DEFAULT ")) {
                this.setDefault("DEFAULT ");
            }
        }
        if (this.getCastDatatype() != null) {
            this.getCastDatatype().toSybaseString();
            this.createCastFunction();
        }
        if (this.autoIncrement != null) {
            this.identity = "IDENTITY";
            this.autoIncrement = null;
        }
        this.asForIdentity = null;
    }

    public void toOracleString() throws ConvertException {
        String str2;
        CreateSequenceStatement createSequenceObj;
        this.constraintNullVector = new Vector();
        int indexOfNotNull = 0;
        boolean notNullAddedForPrimaryorUniqueConstraint = true;
        this.setCollate(null);
        this.setDatapageStorageLevel(null);
        this.setCollationName(null);
        this.generated = null;
        this.always = null;
        this.asForIdentity = null;
        this.byForAlways = null;
        this.defaultForIdentity = null;
        this.asForIdentity = null;
        if (this.nullStatus == null && SwisSQLOptions.sybaseNotNullConstraint && SwisSQLOptions.fromSybase && (this.getDatatype() != null || this.getUserDefinedDatatype() != null)) {
            this.nullStatus = "NOT NULL";
        }
        if (this.columnName != null) {
            if (this.columnName.startsWith("[") && this.columnName.endsWith("]") || this.columnName.startsWith("`") && this.columnName.endsWith("`")) {
                this.columnName = this.columnName.substring(1, this.columnName.length() - 1);
                if (SwisSQLOptions.retainQuotedIdentifierForOracle || this.columnName.indexOf(32) != -1) {
                    this.columnName = "\"" + this.columnName + "\"";
                }
            }
            if (this.columnName.equalsIgnoreCase("SIZE")) {
                this.columnName = "SIZE_1";
            }
            this.columnName = CustomizeUtil.objectNamesToQuotedIdentifier(this.columnName, SwisSQLUtils.getKeywords(1), null, 1);
        }
        if (this.identity != null) {
            String table_name_str;
            String table_name_str2;
            String str1;
            String str3;
            createSequenceObj = new CreateSequenceStatement();
            TableObject tableObj = new TableObject();
            createSequenceObj.setSequence("SEQUENCE");
            String oracleColumnName = this.columnName;
            if (oracleColumnName.startsWith("[") || oracleColumnName.startsWith("\"")) {
                oracleColumnName = "\"" + oracleColumnName.substring(1);
                if (oracleColumnName.endsWith("]") || oracleColumnName.endsWith("\"")) {
                    oracleColumnName = oracleColumnName.substring(0, oracleColumnName.length() - 1) + "\"";
                }
                if (this.tableNameFromCQS != null) {
                    str3 = this.tableNameFromCQS + oracleColumnName.substring(1, oracleColumnName.length() - 1) + "_SEQ";
                    str1 = this.tableNameFromCQS + oracleColumnName.substring(1, oracleColumnName.length() - 1);
                    str2 = this.tableNameFromCQS;
                    if (str3.length() > 29) {
                        if (str1.length() > 25) {
                            str3 = str1.substring(0, 26) + "_SEQ";
                            if (str3.startsWith("\"")) {
                                str3 = StringFunctions.replaceAll("", "\"", str3);
                                str3 = "\"" + str3 + "\"";
                            }
                        } else if (str2.length() > 25) {
                            str3 = str2.substring(0, 26) + "_SEQ";
                            if (str2.startsWith("\"")) {
                                str3 = StringFunctions.replaceAll("", "\"", str2);
                                str3 = "\"" + str3 + "\"";
                            }
                        }
                        if (str3.length() > 27) {
                            tableObj.setTableName("\"" + str3.substring(0, 28) + "\"");
                            table_name_str2 = tableObj.getTableName();
                            if (table_name_str2.startsWith("\"")) {
                                table_name_str2 = StringFunctions.replaceAll("", "\"", table_name_str2);
                                table_name_str2 = "\"" + table_name_str2 + "\"";
                                tableObj.setTableName(table_name_str2);
                            }
                        } else {
                            tableObj.setTableName("\"" + str3 + "\"");
                            table_name_str2 = tableObj.getTableName();
                            if (table_name_str2.startsWith("\"")) {
                                table_name_str2 = StringFunctions.replaceAll("", "\"", table_name_str2);
                                table_name_str2 = "\"" + table_name_str2 + "\"";
                                tableObj.setTableName(table_name_str2);
                            }
                        }
                    } else if (str3.length() > 27) {
                        tableObj.setTableName("\"" + this.tableNameFromCQS + "_" + oracleColumnName + "_S" + "\"");
                        table_name_str2 = tableObj.getTableName();
                        if (table_name_str2.startsWith("\"")) {
                            table_name_str2 = StringFunctions.replaceAll("", "\"", table_name_str2);
                            table_name_str2 = "\"" + table_name_str2 + "\"";
                            tableObj.setTableName(table_name_str2);
                        }
                    } else {
                        tableObj.setTableName("\"" + this.tableNameFromCQS + "_" + oracleColumnName + "_SEQ" + "\"");
                        table_name_str2 = tableObj.getTableName();
                        if (table_name_str2.startsWith("\"")) {
                            table_name_str2 = StringFunctions.replaceAll("", "\"", table_name_str2);
                            table_name_str2 = "\"" + table_name_str2 + "\"";
                            tableObj.setTableName(table_name_str2);
                        }
                    }
                } else {
                    tableObj.setTableName(oracleColumnName + "_SEQ");
                    table_name_str = tableObj.getTableName();
                    if (table_name_str.startsWith("\"")) {
                        table_name_str = StringFunctions.replaceAll("", "\"", table_name_str);
                        table_name_str = "\"" + table_name_str + "\"";
                        tableObj.setTableName(table_name_str);
                    }
                }
            } else if (this.tableNameFromCQS != null) {
                str3 = this.tableNameFromCQS + "_" + oracleColumnName + "_SEQ";
                str1 = this.tableNameFromCQS + "_" + oracleColumnName;
                str2 = this.tableNameFromCQS;
                if (str3.length() > 29) {
                    if (str1.length() > 25) {
                        str3 = str1.substring(0, 26) + "_SEQ";
                    } else if (str2.length() > 25) {
                        str3 = str2.substring(0, 26) + "_SEQ";
                    }
                    tableObj.setTableName(str3);
                    table_name_str2 = tableObj.getTableName();
                    if (table_name_str2.startsWith("\"")) {
                        table_name_str2 = StringFunctions.replaceAll("", "\"", table_name_str2);
                        table_name_str2 = "\"" + table_name_str2 + "\"";
                        tableObj.setTableName(table_name_str2);
                    }
                } else {
                    tableObj.setTableName(this.tableNameFromCQS + "_" + oracleColumnName + "_SEQ");
                    table_name_str2 = tableObj.getTableName();
                    if (table_name_str2.startsWith("\"")) {
                        table_name_str2 = StringFunctions.replaceAll("", "\"", table_name_str2);
                        table_name_str2 = "\"" + table_name_str2 + "\"";
                        tableObj.setTableName(table_name_str2);
                    }
                }
            } else {
                tableObj.setTableName(this.columnName + "_SEQ");
                table_name_str = tableObj.getTableName();
                if (table_name_str.startsWith("\"")) {
                    table_name_str = StringFunctions.replaceAll("", "\"", table_name_str);
                    table_name_str = "\"" + table_name_str + "\"";
                    tableObj.setTableName(table_name_str);
                }
            }
            createSequenceObj.setSchemaName(tableObj);
            if (this.identity.trim().equalsIgnoreCase("IDENTITY")) {
                createSequenceObj.setStart("START");
                createSequenceObj.setWith("WITH");
                createSequenceObj.setStartValue("1");
                createSequenceObj.setIncrementString("INCREMENT BY");
                createSequenceObj.setIncrementValue("1");
            } else {
                String tempIdentity = this.identity.trim().substring(8).trim();
                tempIdentity = tempIdentity.substring(1, tempIdentity.length() - 1);
                StringTokenizer st = new StringTokenizer(tempIdentity, ",");
                String token1 = st.nextToken();
                createSequenceObj.setStart("START");
                createSequenceObj.setWith("WITH");
                createSequenceObj.setStartValue(token1);
                if (Integer.parseInt(token1) == 0) {
                    createSequenceObj.setMinValueOrNoMinValue("MINVALUE 0");
                }
                if (st.countTokens() > 0) {
                    String token2 = st.nextToken();
                    createSequenceObj.setIncrementString("INCREMENT BY");
                    createSequenceObj.setIncrementValue(token2);
                } else {
                    createSequenceObj.setIncrementString("INCREMENT BY");
                    createSequenceObj.setIncrementValue("1");
                }
            }
            SelectQueryStatement.singleQueryConvertedToMultipleQueryList = SelectQueryStatement.singleQueryConvertedToMultipleQueryList != null ? SelectQueryStatement.singleQueryConvertedToMultipleQueryList + "CREATE " + createSequenceObj.toString() + "\n/" + "\n/\n/* SwisSQL Message : Query split into multiple Queries. */\n\n" : "CREATE " + createSequenceObj.toString() + "\n/" + "\n\n/* SwisSQL Message : Query split into multiple Queries. */\n\n";
            this.setCreateSequenceString("CREATE " + createSequenceObj.toString());
            this.setIdentity(null);
        }
        if (this.getConstraintClause() != null) {
            boolean primaryOrUniqueClauseEncountered = false;
            Vector changeConstraintVector = this.getConstraintClause();
            if (changeConstraintVector != null) {
                ConstraintClause toOracleConstraintClause;
                int i;
                Vector<ConstraintClause> defaultConstraintVector = new Vector<ConstraintClause>();
                for (i = 0; i < changeConstraintVector.size(); ++i) {
                    toOracleConstraintClause = (ConstraintClause)changeConstraintVector.get(i);
                    if (toOracleConstraintClause == null || !(toOracleConstraintClause.getConstraintType() instanceof DefaultConstraintClause)) continue;
                    defaultConstraintVector.add(toOracleConstraintClause);
                    changeConstraintVector.remove(i);
                }
                if (defaultConstraintVector.size() > 0) {
                    for (int index = 0; index < defaultConstraintVector.size(); ++index) {
                        if (index < changeConstraintVector.size()) {
                            changeConstraintVector.add(index, defaultConstraintVector.get(index));
                            continue;
                        }
                        changeConstraintVector.add(defaultConstraintVector.get(index));
                    }
                }
                for (i = 0; i < changeConstraintVector.size(); ++i) {
                    toOracleConstraintClause = (ConstraintClause)changeConstraintVector.get(i);
                    toOracleConstraintClause.setTableNameFromCQS(this.tableNameFromCQS);
                    toOracleConstraintClause.setColumnNameForSequence(this.columnName);
                    if (toOracleConstraintClause == null) continue;
                    if (toOracleConstraintClause.getConstraintType() instanceof PrimaryOrUniqueConstraintClause) {
                        primaryOrUniqueClauseEncountered = true;
                        toOracleConstraintClause.setColumnName(this.getColumnName());
                        PrimaryOrUniqueConstraintClause primaryConstraintClause = (PrimaryOrUniqueConstraintClause)toOracleConstraintClause.getConstraintType();
                        boolean ccToBeAdded = false;
                        if (primaryConstraintClause.getConstraintColumnNames() != null && this.columnName != null) {
                            this.constraintNullVector.add(",\n\t");
                            CreateColumn cc = new CreateColumn();
                            if (this.getConstraintClause() != null) {
                                Vector primaryConstraintVector = new Vector();
                                for (int index = 0; index < this.getConstraintClause().size(); ++index) {
                                    if (!(this.getConstraintClause().get(index) instanceof PrimaryOrUniqueConstraintClause)) continue;
                                    primaryConstraintVector.add(this.getConstraintClause().get(index));
                                    cc.setNullStatus(null);
                                    cc.setDefaultValue(null);
                                    cc.setDefault(null);
                                    cc.toOracleString();
                                    NotNull notnullObj = new NotNull();
                                    notnullObj.setNullStatus(null);
                                    notnullObj.setIdentity(null);
                                    cc.setNotNull(notnullObj);
                                    ccToBeAdded = true;
                                }
                                cc.setConstraintClause(primaryConstraintVector);
                            }
                            if (ccToBeAdded) {
                                this.constraintNullVector.add(cc);
                            }
                            notNullAddedForPrimaryorUniqueConstraint = false;
                            indexOfNotNull = i;
                        }
                        toOracleConstraintClause.toOracleString();
                        this.constraintNullVector.add(toOracleConstraintClause);
                        continue;
                    }
                    if (toOracleConstraintClause.getConstraintType() instanceof DefaultConstraintClause) {
                        DefaultConstraintClause defaultConstraint = (DefaultConstraintClause)toOracleConstraintClause.getConstraintType();
                        if (defaultConstraint.getDefaultValue() != null && defaultConstraint.getDefaultValue().equalsIgnoreCase("NULL") && SwisSQLOptions.fromSybase && this.nullStatus != null && this.nullStatus.equalsIgnoreCase("NOT NULL")) {
                            this.nullStatus = "NULL";
                        }
                        if (this.columnName != null && defaultConstraint.getConstraintName() != null) {
                            toOracleConstraintClause.setConstraint(null);
                            toOracleConstraintClause.setConstraintName(null);
                            toOracleConstraintClause.toOracleString();
                            this.constraintNullVector.add(toOracleConstraintClause);
                            continue;
                        }
                        toOracleConstraintClause.toOracleString();
                        this.constraintNullVector.add(toOracleConstraintClause);
                        continue;
                    }
                    if (toOracleConstraintClause.getConstraintType() instanceof CheckConstraintClause) {
                        toOracleConstraintClause.toOracleString();
                        this.constraintNullVector.add(toOracleConstraintClause);
                        continue;
                    }
                    if (toOracleConstraintClause.getConstraintType() instanceof ForeignConstraintClause) {
                        toOracleConstraintClause.toOracleString();
                        this.constraintNullVector.add(toOracleConstraintClause);
                        continue;
                    }
                    if (toOracleConstraintClause.getNotNull() != null) {
                        notNullAddedForPrimaryorUniqueConstraint = false;
                        indexOfNotNull = i;
                        toOracleConstraintClause.toOracleString();
                        if (primaryOrUniqueClauseEncountered) continue;
                        this.constraintNullVector.add(toOracleConstraintClause);
                        continue;
                    }
                    toOracleConstraintClause.toOracleString();
                    this.constraintNullVector.add(toOracleConstraintClause);
                }
            }
        }
        if (this.getComputedColumnExpression() != null) {
            this.setComputedColumnExpression(this.getComputedColumnExpression().toOracleSelect(null, null));
        }
        if (this.getNullStatus() != null) {
            if (!notNullAddedForPrimaryorUniqueConstraint) {
                this.constraintNullVector.add(indexOfNotNull, this.getNullStatus());
            } else if (SwisSQLOptions.fromSybase) {
                if (this.getDefaultValue() != null && this.getDefaultValue().equalsIgnoreCase("NULL")) {
                    this.constraintNullVector.add("NULL");
                } else {
                    this.constraintNullVector.add(this.getNullStatus());
                }
            } else {
                this.constraintNullVector.add(this.getNullStatus());
            }
        }
        if (this.getDatatype() != null) {
            if (!this.mapDatatype(this, this.datatypeMapping)) {
                String precision;
                Datatype nt;
                String length2;
                String dataTypeWithoutLength;
                String typeName;
                String typeStringWithoutBraces;
                String typeString;
                CharacterClass ct;
                BinClass binClass;
                Datatype toOracleDatatype = this.getDatatype();
                if (toOracleDatatype instanceof BinClass && (binClass = (BinClass)toOracleDatatype).getDatatypeName().trim().equalsIgnoreCase("BOOLEAN")) {
                    this.booleanOracle = true;
                }
                if (userConfiguredDatatypes.isEmpty()) {
                    if (toOracleDatatype instanceof CharacterClass) {
                        ct = (CharacterClass)toOracleDatatype;
                        toOracleDatatype.toOracleString();
                        if ((toOracleDatatype.getDatatypeName().equalsIgnoreCase("varchar2") || toOracleDatatype.getDatatypeName().equalsIgnoreCase("nvarchar2")) && ct.getSize() == null) {
                            ct.setSize("1");
                            ct.setOpenBrace("(");
                            ct.setClosedBrace(")");
                        }
                        this.enumValuesConvertedToCheckConstraints(toOracleDatatype, this.constraintNullVector);
                    } else {
                        toOracleDatatype.toOracleString();
                    }
                } else if (toOracleDatatype instanceof DateClass) {
                    DateClass dt = (DateClass)toOracleDatatype;
                    typeString = new String();
                    boolean braceComes = false;
                    typeStringWithoutBraces = typeString = typeString + dt.getDatatypeName().trim();
                    if (dt.getSize() != null && !dt.getSize().trim().equals("")) {
                        typeString = typeString + "(" + dt.getSize().trim() + ")";
                        braceComes = true;
                    }
                    if (userConfiguredDatatypes.containsKey(typeString.toLowerCase())) {
                        typeName = userConfiguredDatatypes.get(typeString.toLowerCase()).toString();
                        if (typeName.indexOf("(") != -1 && typeName.indexOf(")") != -1 && typeName.indexOf("(") < typeName.indexOf(")")) {
                            dataTypeWithoutLength = typeName.substring(0, typeName.indexOf("("));
                            dt.setDatatypeName(dataTypeWithoutLength);
                            length2 = typeName.substring(typeName.indexOf("(") + 1, typeName.indexOf(")"));
                            dt.setSize(length2);
                            dt.setOpenBrace("(");
                            dt.setClosedBrace(")");
                        } else {
                            dt.setDatatypeName(typeName);
                            if (!braceComes) {
                                dt.setSize(null);
                                dt.setOpenBrace(null);
                                dt.setClosedBrace(null);
                            }
                        }
                    } else if (userConfiguredDatatypes.containsKey(typeStringWithoutBraces.toLowerCase())) {
                        typeName = userConfiguredDatatypes.get(typeStringWithoutBraces.toLowerCase()).toString();
                        if (typeName.indexOf("(") != -1 && typeName.indexOf(")") != -1 && typeName.indexOf("(") < typeName.indexOf(")")) {
                            if (!braceComes) {
                                dataTypeWithoutLength = typeName.substring(0, typeName.indexOf("("));
                                dt.setDatatypeName(dataTypeWithoutLength);
                                length2 = typeName.substring(typeName.indexOf("(") + 1, typeName.indexOf(")"));
                                dt.setSize(length2);
                                dt.setOpenBrace("(");
                                dt.setClosedBrace(")");
                            } else {
                                toOracleDatatype.toOracleString();
                            }
                        } else {
                            dt.setDatatypeName(typeName);
                            if (!braceComes) {
                                dt.setSize(null);
                                dt.setOpenBrace(null);
                                dt.setClosedBrace(null);
                            }
                        }
                    } else {
                        toOracleDatatype.toOracleString();
                    }
                } else if (toOracleDatatype instanceof NumericClass) {
                    nt = (NumericClass)toOracleDatatype;
                    typeString = new String();
                    String typeStringWithoutBraces2 = typeString = typeString + ((NumericClass)nt).getDatatypeName().trim();
                    boolean braceComes = false;
                    if (((NumericClass)nt).getPrecision() != null && !((NumericClass)nt).getPrecision().trim().equals("")) {
                        typeString = ((NumericClass)nt).getScale() != null && !((NumericClass)nt).getScale().trim().equals("") ? typeString + "(" + ((NumericClass)nt).getPrecision().trim() + "," + ((NumericClass)nt).getScale() + ")" : typeString + "(" + ((NumericClass)nt).getPrecision().trim() + ")";
                        braceComes = true;
                    }
                    if (userConfiguredDatatypes.containsKey(typeString.toLowerCase())) {
                        typeName = userConfiguredDatatypes.get(typeString.toLowerCase()).toString();
                        if (typeName.indexOf("(") != -1 && typeName.indexOf(")") != -1 && typeName.indexOf("(") < typeName.indexOf(")")) {
                            dataTypeWithoutLength = typeName.substring(0, typeName.indexOf("("));
                            ((NumericClass)nt).setDatatypeName(dataTypeWithoutLength);
                            length2 = typeName.substring(typeName.indexOf("(") + 1, typeName.indexOf(")"));
                            if (length2.indexOf(",") != -1) {
                                precision = length2.substring(0, length2.indexOf(","));
                                ((NumericClass)nt).setPrecision(precision);
                                String scale = length2.substring(length2.indexOf(",") + 1);
                                ((NumericClass)nt).setScale(scale);
                                ((NumericClass)nt).setOpenBrace("(");
                                ((NumericClass)nt).setClosedBrace(")");
                            } else {
                                ((NumericClass)nt).setPrecision(length2);
                                ((NumericClass)nt).setOpenBrace("(");
                                ((NumericClass)nt).setClosedBrace(")");
                            }
                        } else {
                            ((NumericClass)nt).setDatatypeName(typeName);
                            if (!braceComes) {
                                ((NumericClass)nt).setPrecision(null);
                                ((NumericClass)nt).setScale(null);
                                ((NumericClass)nt).setOpenBrace(null);
                                ((NumericClass)nt).setClosedBrace(null);
                            }
                        }
                    } else if (userConfiguredDatatypes.containsKey(typeStringWithoutBraces2.toLowerCase())) {
                        typeName = userConfiguredDatatypes.get(typeStringWithoutBraces2.toLowerCase()).toString();
                        if (typeName.indexOf("(") != -1 && typeName.indexOf(")") != -1 && typeName.indexOf("(") < typeName.indexOf(")")) {
                            if (!braceComes) {
                                dataTypeWithoutLength = typeName.substring(0, typeName.indexOf("("));
                                ((NumericClass)nt).setDatatypeName(dataTypeWithoutLength);
                                length2 = typeName.substring(typeName.indexOf("(") + 1, typeName.indexOf(")"));
                                if (length2.indexOf(",") != -1) {
                                    precision = length2.substring(0, length2.indexOf(","));
                                    ((NumericClass)nt).setPrecision(precision);
                                    String scale = length2.substring(length2.indexOf(",") + 1);
                                    ((NumericClass)nt).setScale(scale);
                                    ((NumericClass)nt).setOpenBrace("(");
                                    ((NumericClass)nt).setClosedBrace(")");
                                } else {
                                    ((NumericClass)nt).setPrecision(length2);
                                    ((NumericClass)nt).setOpenBrace("(");
                                    ((NumericClass)nt).setClosedBrace(")");
                                }
                            } else {
                                toOracleDatatype.toOracleString();
                            }
                        } else {
                            ((NumericClass)nt).setDatatypeName(typeName);
                            if (!braceComes) {
                                ((NumericClass)nt).setPrecision(null);
                                ((NumericClass)nt).setScale(null);
                                ((NumericClass)nt).setOpenBrace(null);
                                ((NumericClass)nt).setClosedBrace(null);
                            }
                        }
                    } else {
                        toOracleDatatype.toOracleString();
                    }
                } else if (toOracleDatatype instanceof CharacterClass) {
                    ct = (CharacterClass)toOracleDatatype;
                    typeString = new String();
                    typeString = typeString + ct.getDatatypeName().trim();
                    boolean braceComes = false;
                    typeStringWithoutBraces = typeString;
                    if (ct.getSize() != null && !ct.getSize().trim().equals("")) {
                        typeString = typeString + "(" + ct.getSize().trim() + ")";
                        braceComes = true;
                        if (ct.getSize().equalsIgnoreCase("max")) {
                            braceComes = false;
                        }
                    }
                    if (userConfiguredDatatypes.containsKey(typeString.toLowerCase())) {
                        typeName = userConfiguredDatatypes.get(typeString.toLowerCase()).toString();
                        if (typeName.indexOf("(") != -1 && typeName.indexOf(")") != -1 && typeName.indexOf("(") < typeName.indexOf(")")) {
                            dataTypeWithoutLength = typeName.substring(0, typeName.indexOf("("));
                            ct.setDatatypeName(dataTypeWithoutLength);
                            length2 = typeName.substring(typeName.indexOf("(") + 1, typeName.indexOf(")"));
                            ct.setSize(length2);
                            ct.setOpenBrace("(");
                            ct.setClosedBrace(")");
                        } else {
                            ct.setDatatypeName(typeName);
                            if (!braceComes) {
                                ct.setSize(null);
                                ct.setOpenBrace(null);
                                ct.setClosedBrace(null);
                            }
                        }
                    } else if (userConfiguredDatatypes.containsKey(typeStringWithoutBraces.toLowerCase())) {
                        typeName = userConfiguredDatatypes.get(typeStringWithoutBraces.toLowerCase()).toString();
                        boolean sizeIsMax = ct.getSize().equalsIgnoreCase("max");
                        if (typeName.indexOf("(") != -1 && typeName.indexOf(")") != -1 && typeName.indexOf("(") < typeName.indexOf(")")) {
                            if (!braceComes) {
                                String dataTypeWithoutLength2 = typeName.substring(0, typeName.indexOf("("));
                                ct.setDatatypeName(dataTypeWithoutLength2);
                                String length3 = typeName.substring(typeName.indexOf("(") + 1, typeName.indexOf(")"));
                                ct.setSize(length3);
                                ct.setOpenBrace("(");
                                ct.setClosedBrace(")");
                            } else {
                                toOracleDatatype.toOracleString();
                            }
                        } else {
                            ct.setDatatypeName(typeName);
                            if (!braceComes) {
                                ct.setSize(null);
                                ct.setOpenBrace(null);
                                ct.setClosedBrace(null);
                            }
                        }
                        if (sizeIsMax) {
                            if (typeStringWithoutBraces.equalsIgnoreCase("varchar")) {
                                ct.setSize("4000");
                            } else if (typeStringWithoutBraces.equalsIgnoreCase("nvarchar")) {
                                ct.setSize("2000");
                            }
                            ct.setOpenBrace("(");
                            ct.setClosedBrace(")");
                        }
                    } else {
                        toOracleDatatype.toOracleString();
                        if ((toOracleDatatype.getDatatypeName().equalsIgnoreCase("varchar2") || toOracleDatatype.getDatatypeName().equalsIgnoreCase("nvarchar2")) && ct.getSize() == null) {
                            ct.setSize("1");
                            ct.setOpenBrace("(");
                            ct.setClosedBrace(")");
                        }
                    }
                } else if (toOracleDatatype instanceof BinClass) {
                    BinClass bt = (BinClass)toOracleDatatype;
                    typeString = new String();
                    typeString = typeString + bt.getDatatypeName().trim();
                    boolean braceComes = false;
                    typeStringWithoutBraces = typeString;
                    if (bt.getSize() != null && !bt.getSize().trim().equals("")) {
                        typeString = typeString + "(" + bt.getSize().trim() + ")";
                        braceComes = true;
                    }
                    if (userConfiguredDatatypes.containsKey(typeString.toLowerCase())) {
                        typeName = userConfiguredDatatypes.get(typeString.toLowerCase()).toString();
                        if (typeName.indexOf("(") != -1 && typeName.indexOf(")") != -1 && typeName.indexOf("(") < typeName.indexOf(")")) {
                            dataTypeWithoutLength = typeName.substring(0, typeName.indexOf("("));
                            bt.setDatatypeName(dataTypeWithoutLength);
                            length2 = typeName.substring(typeName.indexOf("(") + 1, typeName.indexOf(")"));
                            bt.setSize(length2);
                            bt.setOpenBrace("(");
                            bt.setClosedBrace(")");
                        } else {
                            bt.setDatatypeName(typeName);
                            if (!braceComes) {
                                bt.setSize(null);
                                bt.setOpenBrace(null);
                                bt.setClosedBrace(null);
                            }
                        }
                    } else if (userConfiguredDatatypes.containsKey(typeStringWithoutBraces.toLowerCase())) {
                        typeName = userConfiguredDatatypes.get(typeStringWithoutBraces.toLowerCase()).toString();
                        if (typeName.indexOf("(") != -1 && typeName.indexOf(")") != -1 && typeName.indexOf("(") < typeName.indexOf(")")) {
                            if (!braceComes) {
                                dataTypeWithoutLength = typeName.substring(0, typeName.indexOf("("));
                                bt.setDatatypeName(dataTypeWithoutLength);
                                length2 = typeName.substring(typeName.indexOf("(") + 1, typeName.indexOf(")"));
                                bt.setSize(length2);
                                bt.setOpenBrace("(");
                                bt.setClosedBrace(")");
                            } else {
                                toOracleDatatype.toOracleString();
                            }
                        } else {
                            bt.setDatatypeName(typeName);
                            if (!braceComes) {
                                bt.setSize(null);
                                bt.setOpenBrace(null);
                                bt.setClosedBrace(null);
                            }
                        }
                    } else {
                        toOracleDatatype.toOracleString();
                    }
                } else if (toOracleDatatype instanceof QuotedIdentifierDatatype) {
                    nt = (QuotedIdentifierDatatype)toOracleDatatype;
                    typeString = new String();
                    String typeStringWithoutBraces3 = typeString = typeString + ((QuotedIdentifierDatatype)nt).getDatatypeName().trim();
                    boolean braceComes = false;
                    if (((QuotedIdentifierDatatype)nt).getPrecision() != null && !((QuotedIdentifierDatatype)nt).getPrecision().trim().equals("")) {
                        typeString = ((QuotedIdentifierDatatype)nt).getScale() != null && !((QuotedIdentifierDatatype)nt).getScale().trim().equals("") ? typeString + "(" + ((QuotedIdentifierDatatype)nt).getPrecision().trim() + "," + ((QuotedIdentifierDatatype)nt).getScale() + ")" : typeString + "(" + ((QuotedIdentifierDatatype)nt).getPrecision().trim() + ")";
                        braceComes = true;
                    }
                    if (userConfiguredDatatypes.containsKey(typeString.toLowerCase())) {
                        typeName = userConfiguredDatatypes.get(typeString.toLowerCase()).toString();
                        if (typeName.indexOf("(") != -1 && typeName.indexOf(")") != -1 && typeName.indexOf("(") < typeName.indexOf(")")) {
                            dataTypeWithoutLength = typeName.substring(0, typeName.indexOf("("));
                            ((QuotedIdentifierDatatype)nt).setDatatypeName(dataTypeWithoutLength);
                            length2 = typeName.substring(typeName.indexOf("(") + 1, typeName.indexOf(")"));
                            if (length2.indexOf(",") != -1) {
                                precision = length2.substring(0, length2.indexOf(","));
                                ((QuotedIdentifierDatatype)nt).setPrecision(precision);
                                String scale = length2.substring(length2.indexOf(",") + 1);
                                ((QuotedIdentifierDatatype)nt).setScale(scale);
                                ((QuotedIdentifierDatatype)nt).setOpenBrace("(");
                                ((QuotedIdentifierDatatype)nt).setClosedBrace(")");
                            } else {
                                ((QuotedIdentifierDatatype)nt).setPrecision(length2);
                                ((QuotedIdentifierDatatype)nt).setOpenBrace("(");
                                ((QuotedIdentifierDatatype)nt).setClosedBrace(")");
                            }
                        } else {
                            ((QuotedIdentifierDatatype)nt).setDatatypeName(typeName);
                            if (!braceComes) {
                                ((QuotedIdentifierDatatype)nt).setPrecision(null);
                                ((QuotedIdentifierDatatype)nt).setScale(null);
                                ((QuotedIdentifierDatatype)nt).setOpenBrace(null);
                                ((QuotedIdentifierDatatype)nt).setClosedBrace(null);
                            }
                        }
                    } else if (userConfiguredDatatypes.containsKey(typeStringWithoutBraces3.toLowerCase())) {
                        typeName = userConfiguredDatatypes.get(typeStringWithoutBraces3.toLowerCase()).toString();
                        if (typeName.indexOf("(") != -1 && typeName.indexOf(")") != -1 && typeName.indexOf("(") < typeName.indexOf(")")) {
                            if (!braceComes) {
                                dataTypeWithoutLength = typeName.substring(0, typeName.indexOf("("));
                                ((QuotedIdentifierDatatype)nt).setDatatypeName(dataTypeWithoutLength);
                                length2 = typeName.substring(typeName.indexOf("(") + 1, typeName.indexOf(")"));
                                if (length2.indexOf(",") != -1) {
                                    precision = length2.substring(0, length2.indexOf(","));
                                    ((QuotedIdentifierDatatype)nt).setPrecision(precision);
                                    String scale = length2.substring(length2.indexOf(",") + 1);
                                    ((QuotedIdentifierDatatype)nt).setScale(scale);
                                    ((QuotedIdentifierDatatype)nt).setOpenBrace("(");
                                    ((QuotedIdentifierDatatype)nt).setClosedBrace(")");
                                } else {
                                    ((QuotedIdentifierDatatype)nt).setPrecision(length2);
                                    ((QuotedIdentifierDatatype)nt).setOpenBrace("(");
                                    ((QuotedIdentifierDatatype)nt).setClosedBrace(")");
                                }
                            } else {
                                toOracleDatatype.toOracleString();
                            }
                        } else {
                            ((QuotedIdentifierDatatype)nt).setDatatypeName(typeName);
                            if (!braceComes) {
                                ((QuotedIdentifierDatatype)nt).setPrecision(null);
                                ((QuotedIdentifierDatatype)nt).setScale(null);
                                ((QuotedIdentifierDatatype)nt).setOpenBrace(null);
                                ((QuotedIdentifierDatatype)nt).setClosedBrace(null);
                            }
                        }
                    } else {
                        toOracleDatatype.toOracleString();
                    }
                }
            } else if (this.getDatatype() != null && this.getDatatype().getDatatypeName() != null && this.getDatatype().getSize() != null && this.getDatatype().getDatatypeName().startsWith("varchar") && this.getDatatype().getSize().equalsIgnoreCase("max")) {
                this.getDatatype().setSize(null);
                this.getDatatype().setOpenBrace(null);
                this.getDatatype().setClosedBrace(null);
            }
        } else if (this.userDefinedDatatype != null && userdefinedDatatypes.size() > 0) {
            if (!this.mapUserDatatype(this, this.datatypeMapping, this.userDefinedDatatype)) {
                if (userdefinedDatatypes.containsKey(this.userDefinedDatatype.toLowerCase().trim())) {
                    this.setUserDefinedDatatype((String)userdefinedDatatypes.get(this.userDefinedDatatype.toLowerCase().trim()));
                } else if (this.userDefinedDatatype.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
                    this.setUserDefinedDatatype("CHAR(36)");
                } else if (this.userDefinedDatatype.equalsIgnoreCase("SQL_VARIANT")) {
                    this.setUserDefinedDatatype("SYS.ANYDATA");
                }
            }
        } else if (this.userDefinedDatatype != null && userdefinedDatatypes.size() <= 0 && !this.mapUserDatatype(this, this.datatypeMapping, this.userDefinedDatatype)) {
            if (this.userDefinedDatatype.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
                this.setUserDefinedDatatype("CHAR(36)");
            } else if (this.userDefinedDatatype.equalsIgnoreCase("SQL_VARIANT")) {
                this.setUserDefinedDatatype("SYS.ANYDATA");
            }
        }
        if (this.getDefaultValue() != null) {
            if (this.defaultValue.equalsIgnoreCase("CURRENT_DATE") || this.defaultValue.equalsIgnoreCase("CURRENT_TIME") || this.defaultValue.equalsIgnoreCase("CURRENT_TIMESTAMP") || this.defaultValue.equalsIgnoreCase("CURRENT DATE") || this.defaultValue.equalsIgnoreCase("CURRENT TIME") || this.defaultValue.equalsIgnoreCase("CURRENT TIMESTAMP") || this.defaultValue.equalsIgnoreCase("CURRENT")) {
                this.setDefaultValue("SYSDATE");
            } else if (this.defaultValue.equalsIgnoreCase("SYSTEM_USER") || this.defaultValue.equalsIgnoreCase("CURRENT_USER")) {
                this.setDefaultValue("USER");
            } else if (this.defaultValue.startsWith("'") || this.defaultValue.startsWith("\"")) {
                CharacterClass cc;
                String dtype;
                if (this.getDatatype() instanceof DateClass) {
                    if (this.defaultValue.startsWith("\"")) {
                        this.defaultValue = "'" + this.defaultValue.substring(1);
                    }
                    if (this.defaultValue.endsWith("\"")) {
                        this.defaultValue = this.defaultValue.substring(0, this.defaultValue.length() - 1) + "'";
                    }
                    if (this.defaultValue.equals("'0000-00-00 00:00:00'") || this.defaultValue.equals("0000-00-00 00:00:00")) {
                        this.setDefaultValue("TO_DATE('0001-01-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS')");
                    } else if (this.defaultValue.equals("'0000-00-00'") || this.defaultValue.equals("0000-00-00")) {
                        this.setDefaultValue("TO_DATE('0001-01-01', 'YYYY-MM-DD')");
                    } else {
                        String format = SwisSQLUtils.getDateFormat(this.defaultValue, 1);
                        if (format != null) {
                            FunctionCalls fc = new FunctionCalls();
                            TableColumn tc = new TableColumn();
                            tc.setColumnName("TO_DATE");
                            Vector<String> fnArgs = new Vector<String>();
                            if (format.startsWith("'1900")) {
                                fnArgs.add(format);
                                fnArgs.add("'YYYY-MM-DD HH24:MI:SS'");
                            } else {
                                fnArgs.add(this.defaultValue);
                                fnArgs.add(format);
                            }
                            fc.setFunctionName(tc);
                            fc.setFunctionArguments(fnArgs);
                            this.setDefaultFunction(fc);
                            this.setDefaultValue(null);
                        }
                    }
                } else if (this.getDatatype() instanceof CharacterClass && (dtype = (cc = (CharacterClass)this.getDatatype()).getDatatypeName()) != null && (dtype.indexOf("char") != -1 || dtype.indexOf("CHAR") != -1) && cc.getSize() != null) {
                    int size = Integer.parseInt(cc.getSize());
                    int len = this.defaultValue.length() - 2;
                    if (len > size) {
                        this.setDefaultValue(null);
                        this.setDefault(null);
                        this.setDefaultOpenBrace(null);
                        this.setDefaultClosedBrace(null);
                    }
                }
            }
            if (this.getDefaultValue() != null) {
                StringTokenizer st = new StringTokenizer(this.getDefaultValue(), ".");
                Vector<String> defaultList = new Vector<String>();
                StringBuffer sb = new StringBuffer();
                while (st.hasMoreTokens()) {
                    defaultList.add(st.nextToken());
                }
                for (int i = 0; i < defaultList.size(); ++i) {
                    String str4 = (String)defaultList.get(i);
                    if (str4.startsWith("[") || str4.startsWith("\"")) {
                        str4 = "'" + str4.substring(1);
                    }
                    if (str4.endsWith("]") || str4.endsWith("\"")) {
                        str4 = str4.substring(0, str4.length() - 1) + "'";
                    }
                    if (i > 0) {
                        sb.append(".");
                    }
                    sb.append(str4);
                }
                if (this.datatype instanceof BinClass) {
                    BinClass binClass = (BinClass)this.datatype;
                    if (binClass.getDatatypeName() != null && binClass.getDatatypeName().trim().equalsIgnoreCase("BOOLEAN")) {
                        if (this.getDefaultValue().trim().equalsIgnoreCase("TRUE")) {
                            this.setDefaultValue("1");
                        } else {
                            this.setDefaultValue("0");
                        }
                    } else {
                        this.setDefaultValue(sb.toString());
                    }
                } else {
                    this.setDefaultValue(sb.toString());
                }
            }
            if (this.getDefault() != null && this.getDefault().equalsIgnoreCase("WITH DEFAULT ")) {
                this.setDefault("DEFAULT ");
            }
            if (SwisSQLOptions.fromSybase && this.getDefaultValue() != null && this.getDefaultValue().equalsIgnoreCase("NULL")) {
                this.nullStatus = "NULL";
            }
        } else if (this.getDefaultFunction() != null) {
            this.setDefaultFunction(this.functionCall.toOracleSelect(null, null));
        } else if (this.getDefaultExpression() != null) {
            ArrayList<SelectColumn> newExpList = new ArrayList<SelectColumn>();
            for (int i = 0; i < this.defaultExpList.size(); ++i) {
                if (this.defaultExpList.get(i) instanceof SelectColumn) {
                    Object sc_val;
                    SelectColumn sc = ((SelectColumn)this.defaultExpList.get(i)).toOracleSelect(null, null);
                    if (this.getDatatype() instanceof DateClass && sc.getColumnExpression().size() == 1) {
                        Object sc_val2 = sc.getColumnExpression().get(0);
                        if (sc_val2 instanceof String && sc_val2.toString().startsWith("'") && sc_val2.toString().length() == 10) {
                            sc.getColumnExpression().setElementAt("to_date(" + sc_val2.toString() + ",'YYYYMMDD')", 0);
                        } else if (sc_val2 instanceof String) {
                            String format;
                            String defVal = sc_val2.toString();
                            if (defVal.startsWith("N") && defVal.endsWith("'")) {
                                defVal = defVal.substring(defVal.indexOf("'"));
                            }
                            if ((format = SwisSQLUtils.getDateFormat(defVal, 1)) != null) {
                                FunctionCalls fc = new FunctionCalls();
                                TableColumn tc = new TableColumn();
                                if (format.toLowerCase().indexOf("ff") != -1) {
                                    tc.setColumnName("TO_TIMESTAMP");
                                } else {
                                    tc.setColumnName("TO_DATE");
                                }
                                Vector<String> fnArgs = new Vector<String>();
                                if (format.startsWith("'1900")) {
                                    fnArgs.add(format);
                                    fnArgs.add("'YYYY-MM-DD HH24:MI:SS'");
                                } else {
                                    fnArgs.add(defVal);
                                    fnArgs.add(format);
                                }
                                fc.setFunctionName(tc);
                                fc.setFunctionArguments(fnArgs);
                                this.setDefaultFunction(fc);
                                this.setDefaultValue(null);
                            }
                        }
                    } else if (this.getDatatype() instanceof BinClass && sc.getColumnExpression().size() == 1 && (sc_val = sc.getColumnExpression().get(0)) instanceof String) {
                        String defVal = sc_val.toString();
                        if (defVal.trim().equalsIgnoreCase("'false'") || defVal.trim().equalsIgnoreCase("'f'")) {
                            sc.getColumnExpression().setElementAt("0", 0);
                        } else if (defVal.trim().equalsIgnoreCase("'true'") || defVal.trim().equalsIgnoreCase("'t'")) {
                            sc.getColumnExpression().setElementAt("1", 0);
                        }
                    }
                    newExpList.add(sc);
                    continue;
                }
                newExpList.add((SelectColumn)this.defaultExpList.get(i));
            }
            this.setDefaultExpression(newExpList);
        } else if (this.getDefault() != null) {
            if (this.getDatatype() != null) {
                if (this.getDatatype() instanceof NumericClass) {
                    this.setDefaultValue("0");
                } else if (this.getDatatype() instanceof BinClass) {
                    this.setDefaultValue("''");
                } else if (this.getDatatype() instanceof CharacterClass) {
                    this.setDefaultValue("' '");
                } else if (this.getDatatype() instanceof DateClass) {
                    this.setDefaultValue("TO_DATE('0001-01-01 00:00:00', 'YYYY-MM-DD HH24:MI:SS')");
                } else {
                    this.setDefaultValue("NULL");
                }
            } else {
                this.setDefaultValue("NULL");
            }
            if (this.getDefault().equalsIgnoreCase("WITH DEFAULT ")) {
                this.setDefault("DEFAULT ");
            }
        }
        if (this.autoIncrement != null) {
            createSequenceObj = new CreateSequenceStatement();
            TableObject tableObj = new TableObject();
            createSequenceObj.setSequence("SEQUENCE");
            String oracleColumnName = this.columnName;
            if (oracleColumnName.startsWith("[") || oracleColumnName.startsWith("\"")) {
                oracleColumnName = "\"" + oracleColumnName.substring(1);
                if (oracleColumnName.endsWith("]") || oracleColumnName.endsWith("\"")) {
                    oracleColumnName = oracleColumnName.substring(0, oracleColumnName.length() - 1) + "\"";
                }
                if (this.tableNameFromCQS != null) {
                    String str5 = this.tableNameFromCQS + oracleColumnName.substring(1, oracleColumnName.length() - 1) + "_SEQ";
                    String str1 = this.tableNameFromCQS + oracleColumnName.substring(1, oracleColumnName.length() - 1);
                    str2 = this.tableNameFromCQS;
                    if (str5.length() > 29) {
                        if (str1.length() > 25) {
                            str5 = str1.substring(0, 26) + "_SEQ";
                        } else if (str2.length() > 25) {
                            str5 = str2.substring(0, 26) + "_SEQ";
                        }
                        if (str5.length() > 27) {
                            tableObj.setTableName("\"" + str5.substring(0, 28) + "\"");
                        } else {
                            tableObj.setTableName("\"" + str5 + "\"");
                        }
                    } else if (str5.length() > 27) {
                        tableObj.setTableName("\"" + this.tableNameFromCQS + "_" + oracleColumnName + "_S" + "\"");
                    } else {
                        tableObj.setTableName("\"" + this.tableNameFromCQS + "_" + oracleColumnName + "_SEQ" + "\"");
                    }
                } else {
                    tableObj.setTableName(oracleColumnName + "_SEQ");
                }
            } else if (this.tableNameFromCQS != null) {
                String str6 = this.tableNameFromCQS + oracleColumnName + "_SEQ";
                String str1 = this.tableNameFromCQS + oracleColumnName;
                str2 = this.tableNameFromCQS;
                if (str6.length() > 29) {
                    if (str1.length() > 25) {
                        str6 = str1.substring(0, 26) + "_SEQ";
                    } else if (str2.length() > 25) {
                        str6 = str2.substring(0, 26) + "_SEQ";
                    }
                    tableObj.setTableName(str6);
                } else {
                    tableObj.setTableName(this.tableNameFromCQS + "_" + oracleColumnName + "_SEQ");
                }
            } else {
                tableObj.setTableName(this.columnName + "_SEQ");
            }
            createSequenceObj.setSchemaName(tableObj);
            createSequenceObj.setStart("START");
            createSequenceObj.setWith("WITH");
            createSequenceObj.setStartValue("1");
            createSequenceObj.setIncrementString("INCREMENT BY");
            createSequenceObj.setIncrementValue("1");
            SelectQueryStatement.singleQueryConvertedToMultipleQueryList = SelectQueryStatement.singleQueryConvertedToMultipleQueryList != null ? SelectQueryStatement.singleQueryConvertedToMultipleQueryList + "CREATE " + createSequenceObj.toString() + "\n/" + "\n\n/* SwisSQL Message : Query split into multiple Queries. Manual Intervention required */\n" : "CREATE " + createSequenceObj.toString() + "\n/" + "\n\n/* SwisSQL Message : Query split into multiple Queries. Manual Intervention required */\n";
            this.setAutoIncrement(null);
        }
        if (this.getCastDatatype() != null) {
            this.getCastDatatype().toOracleString();
            this.createCastFunction();
        }
    }

    public void toPostgreSQLString() throws ConvertException {
        String def;
        String str2;
        String str1;
        String postgresqlColumnName;
        CreateSequenceStatement createSequenceObj;
        int indexOfNotNull = 0;
        boolean notNullAddedForPrimaryorUniqueConstraint = true;
        this.constraintNullVector = new Vector();
        this.setCollate(null);
        this.setCollationName(null);
        this.setDatapageStorageLevel(null);
        this.generated = null;
        this.always = null;
        this.asForIdentity = null;
        this.byForAlways = null;
        this.defaultForIdentity = null;
        this.asForIdentity = null;
        if (this.columnName != null) {
            if (this.columnName.startsWith("[") && this.columnName.endsWith("]") || this.columnName.startsWith("`") && this.columnName.endsWith("`")) {
                this.columnName = this.columnName.substring(1, this.columnName.length() - 1);
                if (this.columnName.indexOf(32) != -1) {
                    this.columnName = "\"" + this.columnName + "\"";
                }
            }
            this.columnName = CustomizeUtil.objectNamesToQuotedIdentifier(this.columnName, SwisSQLUtils.getKeywords(4), null, 4);
        }
        if (this.identity != null) {
            String table_name_str;
            String table_name_str2;
            String str3;
            createSequenceObj = new CreateSequenceStatement();
            TableObject tableObj = new TableObject();
            createSequenceObj.setSequence("SEQUENCE");
            postgresqlColumnName = this.columnName;
            if (postgresqlColumnName.startsWith("[") || postgresqlColumnName.startsWith("\"")) {
                postgresqlColumnName = "\"" + postgresqlColumnName.substring(1);
                if (postgresqlColumnName.endsWith("]") || postgresqlColumnName.endsWith("\"")) {
                    postgresqlColumnName = postgresqlColumnName.substring(0, postgresqlColumnName.length() - 1) + "\"";
                }
                if (this.tableNameFromCQS != null) {
                    str3 = this.tableNameFromCQS + postgresqlColumnName.substring(1, postgresqlColumnName.length() - 1) + "_SEQ";
                    str1 = this.tableNameFromCQS + postgresqlColumnName.substring(1, postgresqlColumnName.length() - 1);
                    str2 = this.tableNameFromCQS;
                    if (str3.length() > 63) {
                        if (str1.length() > 59) {
                            str3 = str1.substring(0, 60) + "_SEQ";
                            if (str3.startsWith("\"")) {
                                str3 = StringFunctions.replaceAll("", "\"", str3);
                                str3 = "\"" + str3 + "\"";
                            }
                        } else if (str2.length() > 59) {
                            str3 = str2.substring(0, 60) + "_SEQ";
                            if (str2.startsWith("\"")) {
                                str3 = StringFunctions.replaceAll("", "\"", str2);
                                str3 = "\"" + str3 + "\"";
                            }
                        }
                        if (str3.length() > 60) {
                            tableObj.setTableName("\"" + str3.substring(0, 61) + "\"");
                            table_name_str2 = tableObj.getTableName();
                            if (table_name_str2.startsWith("\"")) {
                                table_name_str2 = StringFunctions.replaceAll("", "\"", table_name_str2);
                                table_name_str2 = "\"" + table_name_str2 + "\"";
                                tableObj.setTableName(table_name_str2);
                            }
                        } else {
                            tableObj.setTableName("\"" + str3 + "\"");
                            table_name_str2 = tableObj.getTableName();
                            if (table_name_str2.startsWith("\"")) {
                                table_name_str2 = StringFunctions.replaceAll("", "\"", table_name_str2);
                                table_name_str2 = "\"" + table_name_str2 + "\"";
                                tableObj.setTableName(table_name_str2);
                            }
                        }
                    } else if (str3.length() > 60) {
                        tableObj.setTableName("\"" + this.tableNameFromCQS + "_" + postgresqlColumnName + "_S" + "\"");
                        table_name_str2 = tableObj.getTableName();
                        if (table_name_str2.startsWith("\"")) {
                            table_name_str2 = StringFunctions.replaceAll("", "\"", table_name_str2);
                            table_name_str2 = "\"" + table_name_str2 + "\"";
                            tableObj.setTableName(table_name_str2);
                        }
                    } else {
                        tableObj.setTableName("\"" + this.tableNameFromCQS + "_" + postgresqlColumnName + "_SEQ" + "\"");
                        table_name_str2 = tableObj.getTableName();
                        if (table_name_str2.startsWith("\"")) {
                            table_name_str2 = StringFunctions.replaceAll("", "\"", table_name_str2);
                            table_name_str2 = "\"" + table_name_str2 + "\"";
                            tableObj.setTableName(table_name_str2);
                        }
                    }
                } else {
                    tableObj.setTableName(postgresqlColumnName + "_SEQ");
                    table_name_str = tableObj.getTableName();
                    if (table_name_str.startsWith("\"")) {
                        table_name_str = StringFunctions.replaceAll("", "\"", table_name_str);
                        table_name_str = "\"" + table_name_str + "\"";
                        tableObj.setTableName(table_name_str);
                    }
                }
            } else if (this.tableNameFromCQS != null) {
                str3 = this.tableNameFromCQS + "_" + postgresqlColumnName + "_SEQ";
                str1 = this.tableNameFromCQS + "_" + postgresqlColumnName;
                str2 = this.tableNameFromCQS;
                if (str3.length() > 63) {
                    if (str1.length() > 59) {
                        str3 = str1.substring(0, 60) + "_SEQ";
                    } else if (str2.length() > 59) {
                        str3 = str2.substring(0, 60) + "_SEQ";
                    }
                    tableObj.setTableName(str3);
                    table_name_str2 = tableObj.getTableName();
                    if (table_name_str2.startsWith("\"")) {
                        table_name_str2 = StringFunctions.replaceAll("", "\"", table_name_str2);
                        table_name_str2 = "\"" + table_name_str2 + "\"";
                        tableObj.setTableName(table_name_str2);
                    }
                } else {
                    tableObj.setTableName(this.tableNameFromCQS + "_" + postgresqlColumnName + "_SEQ");
                    table_name_str2 = tableObj.getTableName();
                    if (table_name_str2.startsWith("\"")) {
                        table_name_str2 = StringFunctions.replaceAll("", "\"", table_name_str2);
                        table_name_str2 = "\"" + table_name_str2 + "\"";
                        tableObj.setTableName(table_name_str2);
                    }
                }
            } else {
                tableObj.setTableName(this.columnName + "_SEQ");
                table_name_str = tableObj.getTableName();
                if (table_name_str.startsWith("\"")) {
                    table_name_str = StringFunctions.replaceAll("", "\"", table_name_str);
                    table_name_str = "\"" + table_name_str + "\"";
                    tableObj.setTableName(table_name_str);
                }
            }
            createSequenceObj.setSchemaName(tableObj);
            if (this.identity.trim().equalsIgnoreCase("IDENTITY")) {
                createSequenceObj.setStart("START");
                createSequenceObj.setStartValue("1");
                createSequenceObj.setIncrementString("INCREMENT ");
                createSequenceObj.setIncrementValue("1");
            } else {
                String tempIdentity = this.identity.trim().substring(8).trim();
                tempIdentity = tempIdentity.substring(1, tempIdentity.length() - 1);
                StringTokenizer st = new StringTokenizer(tempIdentity, ",");
                String token1 = st.nextToken();
                createSequenceObj.setStart("START");
                createSequenceObj.setStartValue(token1);
                if (Integer.parseInt(token1) == 0) {
                    createSequenceObj.setMinValueOrNoMinValue("MINVALUE 0");
                }
                if (st.countTokens() > 0) {
                    String token2 = st.nextToken();
                    createSequenceObj.setIncrementString("INCREMENT ");
                    createSequenceObj.setIncrementValue(token2);
                } else {
                    createSequenceObj.setIncrementString("INCREMENT ");
                    createSequenceObj.setIncrementValue("1");
                }
            }
            SelectQueryStatement.singleQueryConvertedToMultipleQueryList = SelectQueryStatement.singleQueryConvertedToMultipleQueryList != null ? SelectQueryStatement.singleQueryConvertedToMultipleQueryList + "CREATE " + createSequenceObj.toString() + "\n;" + "\n/\n/* SwisSQL Message : Query split into multiple Queries. */\n\n" : "CREATE " + createSequenceObj.toString() + "\n;" + "\n\n/* SwisSQL Message : Query split into multiple Queries. */\n\n";
            this.setCreateSequenceString("CREATE " + createSequenceObj.toString());
            this.setIdentity(null);
        }
        if (this.getConstraintClause() != null) {
            boolean primaryOrUniqueClauseEncountered = false;
            Vector changeConstraintVector = this.getConstraintClause();
            if (changeConstraintVector != null) {
                ConstraintClause toPostgreSQLConstraintClause;
                int i;
                Vector<ConstraintClause> defaultConstraintVector = new Vector<ConstraintClause>();
                for (i = 0; i < changeConstraintVector.size(); ++i) {
                    toPostgreSQLConstraintClause = (ConstraintClause)changeConstraintVector.get(i);
                    if (toPostgreSQLConstraintClause == null || !(toPostgreSQLConstraintClause.getConstraintType() instanceof DefaultConstraintClause)) continue;
                    defaultConstraintVector.add(toPostgreSQLConstraintClause);
                    changeConstraintVector.remove(i);
                }
                if (defaultConstraintVector.size() > 0) {
                    for (int index = 0; index < defaultConstraintVector.size(); ++index) {
                        if (index < changeConstraintVector.size()) {
                            changeConstraintVector.add(index, defaultConstraintVector.get(index));
                            continue;
                        }
                        changeConstraintVector.add(defaultConstraintVector.get(index));
                    }
                }
                for (i = 0; i < changeConstraintVector.size(); ++i) {
                    toPostgreSQLConstraintClause = (ConstraintClause)changeConstraintVector.get(i);
                    toPostgreSQLConstraintClause.setTableNameFromCQS(this.tableNameFromCQS);
                    toPostgreSQLConstraintClause.setColumnNameForSequence(this.columnName);
                    if (toPostgreSQLConstraintClause == null) continue;
                    if (toPostgreSQLConstraintClause.getConstraintType() instanceof PrimaryOrUniqueConstraintClause) {
                        primaryOrUniqueClauseEncountered = true;
                        toPostgreSQLConstraintClause.setColumnName(this.getColumnName());
                        PrimaryOrUniqueConstraintClause primaryConstraintClause = (PrimaryOrUniqueConstraintClause)toPostgreSQLConstraintClause.getConstraintType();
                        boolean ccToBeAdded = false;
                        if (primaryConstraintClause.getConstraintColumnNames() != null && this.columnName != null) {
                            this.constraintNullVector.add(",\n\t");
                            CreateColumn cc = new CreateColumn();
                            if (this.getConstraintClause() != null) {
                                Vector primaryConstraintVector = new Vector();
                                for (int index = 0; index < this.getConstraintClause().size(); ++index) {
                                    if (!(this.getConstraintClause().get(index) instanceof PrimaryOrUniqueConstraintClause)) continue;
                                    primaryConstraintVector.add(this.getConstraintClause().get(index));
                                    cc.setNullStatus(null);
                                    cc.setDefaultValue(null);
                                    cc.setDefault(null);
                                    cc.toPostgreSQLString();
                                    NotNull notnullObj = new NotNull();
                                    notnullObj.setNullStatus(null);
                                    notnullObj.setIdentity(null);
                                    cc.setNotNull(notnullObj);
                                    ccToBeAdded = true;
                                }
                                cc.setConstraintClause(primaryConstraintVector);
                            }
                            if (ccToBeAdded) {
                                this.constraintNullVector.add(cc);
                            }
                            notNullAddedForPrimaryorUniqueConstraint = false;
                            indexOfNotNull = i;
                        }
                        toPostgreSQLConstraintClause.toPostgreSQLString();
                        this.constraintNullVector.add(toPostgreSQLConstraintClause);
                        continue;
                    }
                    if (toPostgreSQLConstraintClause.getConstraintType() instanceof DefaultConstraintClause) {
                        DefaultConstraintClause defaultConstraint = (DefaultConstraintClause)toPostgreSQLConstraintClause.getConstraintType();
                        if (defaultConstraint.getDefaultValue() != null && defaultConstraint.getDefaultValue().equalsIgnoreCase("NULL") && SwisSQLOptions.fromSybase && this.nullStatus != null && this.nullStatus.equalsIgnoreCase("NOT NULL")) {
                            this.nullStatus = "NULL";
                        }
                        if (this.columnName != null && defaultConstraint.getConstraintName() != null) {
                            toPostgreSQLConstraintClause.setConstraint(null);
                            toPostgreSQLConstraintClause.setConstraintName(null);
                            toPostgreSQLConstraintClause.toPostgreSQLString();
                            this.constraintNullVector.add(toPostgreSQLConstraintClause);
                            continue;
                        }
                        toPostgreSQLConstraintClause.toPostgreSQLString();
                        this.constraintNullVector.add(toPostgreSQLConstraintClause);
                        continue;
                    }
                    if (toPostgreSQLConstraintClause.getConstraintType() instanceof CheckConstraintClause) {
                        toPostgreSQLConstraintClause.toPostgreSQLString();
                        this.constraintNullVector.add(toPostgreSQLConstraintClause);
                        continue;
                    }
                    if (toPostgreSQLConstraintClause.getConstraintType() instanceof ForeignConstraintClause) {
                        toPostgreSQLConstraintClause.toPostgreSQLString();
                        this.constraintNullVector.add(toPostgreSQLConstraintClause);
                        continue;
                    }
                    if (toPostgreSQLConstraintClause.getNotNull() != null) {
                        notNullAddedForPrimaryorUniqueConstraint = false;
                        indexOfNotNull = i;
                        toPostgreSQLConstraintClause.toPostgreSQLString();
                        if (primaryOrUniqueClauseEncountered) continue;
                        this.constraintNullVector.add(toPostgreSQLConstraintClause);
                        continue;
                    }
                    toPostgreSQLConstraintClause.toPostgreSQLString();
                    this.constraintNullVector.add(toPostgreSQLConstraintClause);
                }
            }
        }
        if (this.getComputedColumnExpression() != null) {
            this.setComputedColumnExpression(this.getComputedColumnExpression().toPostgreSQLSelect(null, null));
        }
        if (this.getNullStatus() != null) {
            this.constraintNullVector.add(this.getNullStatus());
        }
        if (this.getDatatype() != null) {
            if (!this.mapDatatype(this, this.datatypeMapping)) {
                Datatype toPostgreSQLDatatype = this.getDatatype();
                toPostgreSQLDatatype.toPostgreSQLString();
                if (toPostgreSQLDatatype instanceof CharacterClass) {
                    this.enumValuesConvertedToCheckConstraints(toPostgreSQLDatatype, this.constraintNullVector);
                }
            }
        } else if (this.userDefinedDatatype != null && userdefinedDatatypes.size() > 0) {
            if (!this.mapUserDatatype(this, this.datatypeMapping, this.userDefinedDatatype)) {
                if (userdefinedDatatypes.containsKey(this.userDefinedDatatype.toLowerCase().trim())) {
                    this.setUserDefinedDatatype((String)userdefinedDatatypes.get(this.userDefinedDatatype.toLowerCase().trim()));
                } else if (this.userDefinedDatatype.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
                    this.setUserDefinedDatatype("CHAR(36)");
                }
            }
        } else if (this.userDefinedDatatype != null && userdefinedDatatypes.size() <= 0 && !this.mapUserDatatype(this, this.datatypeMapping, this.userDefinedDatatype) && this.userDefinedDatatype.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
            this.setUserDefinedDatatype("CHAR(36)");
        }
        if (this.getDefaultValue() != null) {
            if (this.defaultValue.equalsIgnoreCase("SYSDATE")) {
                this.setDefaultValue("CURRENT_DATE");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT DATE")) {
                this.setDefaultValue("CURRENT_DATE");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIME")) {
                this.setDefaultValue("CURRENT_TIME");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                this.setDefaultValue("CURRENT_TIMESTAMP");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT")) {
                this.setDefaultValue("CURRENT_DATE");
            } else if (this.defaultValue.equalsIgnoreCase("SYSTEM_USER") || this.defaultValue.equalsIgnoreCase("USER")) {
                this.setDefaultValue("CURRENT_USER");
            } else if (this.defaultValue.startsWith("0x") || this.defaultValue.startsWith("0X")) {
                this.setDefaultValue("'" + this.defaultValue.substring(1, this.defaultValue.length()) + "'");
            }
        } else if (this.getDefaultFunction() != null) {
            this.setDefaultFunction(this.functionCall.toPostgreSQLSelect(null, null));
        } else if (this.getDefaultExpression() != null) {
            ArrayList<SelectColumn> newExpList = new ArrayList<SelectColumn>();
            for (int i = 0; i < this.defaultExpList.size(); ++i) {
                if (this.defaultExpList.get(i) instanceof SelectColumn) {
                    SelectColumn sc = (SelectColumn)this.defaultExpList.get(i);
                    newExpList.add(sc.toPostgreSQLSelect(null, null));
                    continue;
                }
                newExpList.add((SelectColumn)this.defaultExpList.get(i));
            }
            this.setDefaultExpression(newExpList);
        } else if (this.getDefault() != null && (def = this.getDefault()).equalsIgnoreCase("WITH DEFAULT ")) {
            this.setDefault("DEFAULT ");
        }
        if (this.autoIncrement != null) {
            createSequenceObj = new CreateSequenceStatement();
            TableObject tableObj = new TableObject();
            createSequenceObj.setSequence("SEQUENCE");
            postgresqlColumnName = this.columnName;
            if (postgresqlColumnName.startsWith("[") || postgresqlColumnName.startsWith("\"")) {
                postgresqlColumnName = "\"" + postgresqlColumnName.substring(1);
                if (postgresqlColumnName.endsWith("]") || postgresqlColumnName.endsWith("\"")) {
                    postgresqlColumnName = postgresqlColumnName.substring(0, postgresqlColumnName.length() - 1) + "\"";
                }
                if (this.tableNameFromCQS != null) {
                    String str4 = this.tableNameFromCQS + postgresqlColumnName.substring(1, postgresqlColumnName.length() - 1) + "_SEQ";
                    str1 = this.tableNameFromCQS + postgresqlColumnName.substring(1, postgresqlColumnName.length() - 1);
                    str2 = this.tableNameFromCQS;
                    if (str4.length() > 63) {
                        if (str1.length() > 59) {
                            str4 = str1.substring(0, 60) + "_SEQ";
                        } else if (str2.length() > 59) {
                            str4 = str2.substring(0, 60) + "_SEQ";
                        }
                        if (str4.length() > 60) {
                            tableObj.setTableName("\"" + str4.substring(0, 61) + "\"");
                        } else {
                            tableObj.setTableName("\"" + str4 + "\"");
                        }
                    } else if (str4.length() > 60) {
                        tableObj.setTableName("\"" + this.tableNameFromCQS + "_" + postgresqlColumnName + "_S" + "\"");
                    } else {
                        tableObj.setTableName("\"" + this.tableNameFromCQS + "_" + postgresqlColumnName + "_SEQ" + "\"");
                    }
                } else {
                    tableObj.setTableName(postgresqlColumnName + "_SEQ");
                }
            } else if (this.tableNameFromCQS != null) {
                String str5 = this.tableNameFromCQS + postgresqlColumnName + "_SEQ";
                str1 = this.tableNameFromCQS + postgresqlColumnName;
                str2 = this.tableNameFromCQS;
                if (str5.length() > 63) {
                    if (str1.length() > 59) {
                        str5 = str1.substring(0, 60) + "_SEQ";
                    } else if (str2.length() > 59) {
                        str5 = str2.substring(0, 60) + "_SEQ";
                    }
                    tableObj.setTableName(str5);
                } else {
                    tableObj.setTableName(this.tableNameFromCQS + "_" + postgresqlColumnName + "_SEQ");
                }
            } else {
                tableObj.setTableName(this.columnName + "_SEQ");
            }
            createSequenceObj.setSchemaName(tableObj);
            createSequenceObj.setStart("START");
            createSequenceObj.setStartValue("1");
            createSequenceObj.setIncrementString("INCREMENT BY");
            createSequenceObj.setIncrementValue("1");
            SelectQueryStatement.singleQueryConvertedToMultipleQueryList = SelectQueryStatement.singleQueryConvertedToMultipleQueryList != null ? SelectQueryStatement.singleQueryConvertedToMultipleQueryList + "CREATE " + createSequenceObj.toString() + "\n;" + "\n\n/* SwisSQL Message : Query split into multiple Queries. Manual Intervention required */\n" : "CREATE " + createSequenceObj.toString() + "\n;" + "\n\n/* SwisSQL Message : Query split into multiple Queries. Manual Intervention required */\n";
            this.setCreateSequenceString("CREATE " + createSequenceObj.toString());
            this.setAutoIncrement(null);
        }
        if (this.getCastDatatype() != null) {
            this.getCastDatatype().toPostgreSQLString();
            this.setDefaultValue(this.getDefaultValue() + "::" + this.getCastDatatype());
        }
    }

    public void toMySQLString() throws ConvertException {
        this.constraintNullVector = new Vector();
        this.setCollate(null);
        this.setCollationName(null);
        this.generated = null;
        this.always = null;
        this.asForIdentity = null;
        this.byForAlways = null;
        this.setDatapageStorageLevel(null);
        this.defaultForIdentity = null;
        this.asForIdentity = null;
        if (this.columnName != null) {
            if (this.columnName.startsWith("[") && this.columnName.endsWith("]") || this.columnName.startsWith("\"") && this.columnName.endsWith("\"")) {
                this.columnName = this.columnName.substring(1, this.columnName.length() - 1);
                this.columnName = "`" + this.columnName + "`";
            } else if (!this.columnName.startsWith("`") && !this.columnName.endsWith("`")) {
                this.columnName = "`" + this.columnName + "`";
            }
        }
        if (this.getConstraintClause() != null) {
            Vector changeConstraintVector = this.getConstraintClause();
            if (changeConstraintVector != null) {
                for (int i = 0; i < changeConstraintVector.size(); ++i) {
                    NotNull notNullClause;
                    ConstraintClause toMySQLConstraintClause = (ConstraintClause)changeConstraintVector.get(i);
                    if (toMySQLConstraintClause == null) continue;
                    if (toMySQLConstraintClause.getNotNull() != null && (notNullClause = toMySQLConstraintClause.getNotNull()).getIdentity() != null) {
                        notNullClause.setIdentity(null);
                        this.setAutoIncrement("AUTO_INCREMENT");
                    }
                    if (this.getIdentity() != null) {
                        Datatype datatype;
                        NumericClass numericClass;
                        String dataTypeName;
                        toMySQLConstraintClause.setAutoIncrement("AUTO_INCREMENT");
                        this.setIdentity(null);
                        if (this.getDatatype() != null && (dataTypeName = (numericClass = (NumericClass)(datatype = this.getDatatype())).getDatatypeName()) != null) {
                            numericClass.setDatatypeName("INT");
                            numericClass.setSize(null);
                            numericClass.setPrecision(null);
                            numericClass.setScale(null);
                            numericClass.setOpenBrace(null);
                            numericClass.setClosedBrace(null);
                        }
                    }
                    toMySQLConstraintClause.setColumnName(this.getColumnName());
                    if (toMySQLConstraintClause.getConstraintType() instanceof PrimaryOrUniqueConstraintClause) {
                        PrimaryOrUniqueConstraintClause primaryConstraintClause = (PrimaryOrUniqueConstraintClause)toMySQLConstraintClause.getConstraintType();
                        boolean ccToBeAdded = false;
                        if (primaryConstraintClause.getConstraintColumnNames() != null && this.columnName != null) {
                            this.constraintNullVector.add(",\n\t");
                            CreateColumn cc = new CreateColumn();
                            if (this.getConstraintClause() != null) {
                                Vector primaryConstraintVector = new Vector();
                                for (int index = 0; index < this.getConstraintClause().size(); ++index) {
                                    if (!(this.getConstraintClause().get(index) instanceof PrimaryOrUniqueConstraintClause)) continue;
                                    primaryConstraintVector.add(this.getConstraintClause().get(index));
                                    cc.setNullStatus(null);
                                    cc.setDefaultValue(null);
                                    cc.setDefault(null);
                                    cc.toOracleString();
                                    NotNull notnullObj = new NotNull();
                                    notnullObj.setNullStatus(null);
                                    notnullObj.setIdentity(null);
                                    cc.setNotNull(notnullObj);
                                    ccToBeAdded = true;
                                }
                                cc.setConstraintClause(primaryConstraintVector);
                            }
                            if (ccToBeAdded) {
                                this.constraintNullVector.add(cc);
                            }
                        }
                    }
                    toMySQLConstraintClause.toMySQLString();
                    this.constraintNullVector.add(toMySQLConstraintClause);
                }
            }
        } else {
            if (this.identity != null) {
                NumericClass numericClass;
                String dataTypeName;
                Datatype datatype;
                this.setAutoIncrement("AUTO_INCREMENT");
                if (this.getDatatype() != null && (datatype = this.getDatatype()) instanceof NumericClass && (dataTypeName = (numericClass = (NumericClass)datatype).getDatatypeName()) != null) {
                    numericClass.setDatatypeName("INT");
                    numericClass.setSize(null);
                    numericClass.setPrecision(null);
                    numericClass.setScale(null);
                    numericClass.setOpenBrace(null);
                    numericClass.setClosedBrace(null);
                }
            }
            this.setIdentity(null);
        }
        if (this.getComputedColumnExpression() != null) {
            this.setComputedColumnExpression(this.getComputedColumnExpression().toMySQLSelect(null, null));
        }
        if (this.getNullStatus() != null) {
            this.constraintNullVector.add(this.getNullStatus());
        }
        if (this.getDefaultExpression() != null) {
            ArrayList newExpList = new ArrayList();
            int size = this.defaultExpList.size();
            if (size == 1) {
                if (this.defaultExpList.get(0) instanceof SelectColumn) {
                    SelectColumn sc = (SelectColumn)this.defaultExpList.get(0);
                    Vector expList = sc.getColumnExpression();
                    if (expList.size() == 1) {
                        TableColumn tc;
                        String colName;
                        Object obj = expList.get(0);
                        if (obj instanceof String) {
                            this.setDefaultValue((String)obj);
                        } else if (obj instanceof TableColumn && (colName = (tc = (TableColumn)obj).getColumnName()) != null) {
                            this.setDefaultValue(colName);
                        }
                    }
                } else {
                    ArrayList expWithoutSc = this.getDefaultExpression();
                    if (expWithoutSc.size() == 1 && expWithoutSc.get(0) instanceof String) {
                        this.setDefaultValue((String)expWithoutSc.get(0));
                    }
                }
            }
        }
        if (this.getDatatype() != null) {
            if (!this.mapDatatype(this, this.datatypeMapping)) {
                DateClass dc;
                CharacterClass cc;
                Datatype toMySQLDatatype = this.getDatatype();
                if (toMySQLDatatype instanceof CharacterClass && (cc = (CharacterClass)toMySQLDatatype).getDatatypeName() != null && cc.getDatatypeName().equalsIgnoreCase("LONG")) {
                    this.setDefault(null);
                    this.setDefaultValue(null);
                }
                if (toMySQLDatatype instanceof DateClass && (dc = (DateClass)toMySQLDatatype).getDatatypeName() != null && dc.getDatatypeName().equalsIgnoreCase("TIMESTAMP") && this.getDefault() != null && this.getDefaultValue() != null && this.getDefaultValue().trim().equalsIgnoreCase("NULL")) {
                    this.setDefaultValue("0");
                }
                toMySQLDatatype.toMySQLString();
            }
        } else if (this.userDefinedDatatype != null && userdefinedDatatypes.size() > 0) {
            if (!this.mapUserDatatype(this, this.datatypeMapping, this.userDefinedDatatype)) {
                if (userdefinedDatatypes.containsKey(this.userDefinedDatatype.toLowerCase().trim())) {
                    this.setUserDefinedDatatype((String)userdefinedDatatypes.get(this.userDefinedDatatype.toLowerCase().trim()));
                } else if (this.userDefinedDatatype.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
                    this.setUserDefinedDatatype("CHAR(36)");
                }
            }
        } else if (this.userDefinedDatatype != null && userdefinedDatatypes.size() <= 0 && !this.mapUserDatatype(this, this.datatypeMapping, this.userDefinedDatatype) && this.userDefinedDatatype.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
            this.setUserDefinedDatatype("CHAR(36)");
        }
        if (this.getDefaultValue() != null) {
            if (this.defaultValue.equalsIgnoreCase("SYSDATE")) {
                this.setDefaultValue("'CURRENT_DATE'");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT DATE")) {
                this.setDefaultValue("'CURRENT_DATE'");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIME")) {
                this.setDefaultValue("'CURRENT_TIME'");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                this.setDefaultValue("CURRENT_TIMESTAMP");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT")) {
                this.setDefaultValue("'CURRENT_DATE'");
            } else if (this.defaultValue.equalsIgnoreCase("SYSTEM_USER") || this.defaultValue.equalsIgnoreCase("CURRENT_USER")) {
                this.setDefaultValue("USER()");
            } else if (this.defaultValue.equalsIgnoreCase("true")) {
                this.setDefaultValue("1");
            } else if (this.defaultValue.equalsIgnoreCase("false")) {
                this.setDefaultValue("0");
            }
            this.setDefaultOpenBrace(null);
            this.setDefaultClosedBrace(null);
        } else if (this.getDefaultFunction() != null) {
            FunctionCalls fnCall = this.getDefaultFunction();
            TableColumn tabCol = fnCall.getFunctionName();
            if (tabCol != null && tabCol.getColumnName().equalsIgnoreCase("getdate")) {
                this.setDefaultValue("'CURRENT_DATE'");
                this.setDefaultFunction(null);
            } else {
                this.setDefaultFunction(this.functionCall.toMySQLSelect(null, null));
            }
        } else if (this.getDefault() != null) {
            this.setDefaultOpenBrace(null);
            this.setDefaultClosedBrace(null);
            this.setDefaultValue("NULL");
            if (this.getDefault().equalsIgnoreCase("WITH DEFAULT ")) {
                this.setDefault("DEFAULT ");
            }
        }
        if (this.getCastDatatype() != null) {
            // empty if block
        }
    }

    public void toANSIString() throws ConvertException {
        Vector changeConstraintVector;
        this.constraintNullVector = new Vector();
        this.setIdentity(null);
        this.setDatapageStorageLevel(null);
        this.setAutoIncrement(null);
        this.setCollate(null);
        this.setCollationName(null);
        this.generated = null;
        this.always = null;
        this.asForIdentity = null;
        this.byForAlways = null;
        this.defaultForIdentity = null;
        this.asForIdentity = null;
        if (this.columnName != null) {
            if (this.columnName.startsWith("[") && this.columnName.endsWith("]") || this.columnName.startsWith("`") && this.columnName.endsWith("`")) {
                this.columnName = this.columnName.substring(1, this.columnName.length() - 1);
                if (this.columnName.indexOf(32) != -1) {
                    this.columnName = "\"" + this.columnName + "\"";
                }
            } else {
                this.columnName = "\"" + this.columnName + "\"";
            }
        }
        if (this.getConstraintClause() != null && (changeConstraintVector = this.getConstraintClause()) != null) {
            for (int i = 0; i < changeConstraintVector.size(); ++i) {
                ConstraintClause toANSISQLConstraintClause = (ConstraintClause)changeConstraintVector.get(i);
                if (toANSISQLConstraintClause == null) continue;
                toANSISQLConstraintClause.setColumnName(this.getColumnName());
                toANSISQLConstraintClause.toANSIString();
                this.constraintNullVector.add(toANSISQLConstraintClause);
            }
        }
        if (this.getComputedColumnExpression() != null) {
            this.setComputedColumnAS("AS");
            this.setComputedColumnExpression(this.getComputedColumnExpression().toANSISelect(null, null));
        }
        if (this.getNullStatus() != null) {
            this.constraintNullVector.add(this.getNullStatus());
        }
        if (this.getDatatype() != null && !this.mapDatatype(this, this.datatypeMapping)) {
            Datatype toANSISQLDatatype = this.getDatatype();
            toANSISQLDatatype.toANSIString();
            if (toANSISQLDatatype instanceof CharacterClass) {
                this.enumValuesConvertedToCheckConstraints(toANSISQLDatatype, this.constraintNullVector);
            }
        }
        if (this.getDefaultExpression() != null) {
            ArrayList newExpList = new ArrayList();
            int size = this.defaultExpList.size();
            if (size == 1) {
                if (this.defaultExpList.get(0) instanceof SelectColumn) {
                    SelectColumn sc = (SelectColumn)this.defaultExpList.get(0);
                    Vector expList = sc.getColumnExpression();
                    if (expList.size() == 1) {
                        TableColumn tc;
                        String colName;
                        Object obj = expList.get(0);
                        if (obj instanceof String) {
                            this.setDefaultValue((String)obj);
                        } else if (obj instanceof TableColumn && (colName = (tc = (TableColumn)obj).getColumnName()) != null) {
                            this.setDefaultValue(colName);
                        }
                    }
                } else {
                    ArrayList expWithoutSc = this.getDefaultExpression();
                    if (expWithoutSc.size() == 1 && expWithoutSc.get(0) instanceof String) {
                        this.setDefaultValue((String)expWithoutSc.get(0));
                    }
                }
            }
        }
        if (this.getDefaultValue() != null) {
            if (this.defaultValue.equalsIgnoreCase("SYSDATE")) {
                this.setDefaultValue("CURRENT_DATE");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT DATE")) {
                this.setDefaultValue("CURRENT_DATE");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIME")) {
                this.setDefaultValue("CURRENT_TIME");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                this.setDefaultValue("CURRENT_TIMESTAMP");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT")) {
                this.setDefaultValue("CURRENT_DATE");
            } else if (this.defaultValue.equalsIgnoreCase("USER")) {
                this.setDefaultValue("CURRENT_USER");
            }
        } else if (this.getDefaultFunction() != null) {
            this.setDefaultFunction(this.functionCall.toANSISelect(null, null));
        } else if (this.getDefault() != null) {
            this.setDefaultValue("NULL");
            if (this.getDefault().equalsIgnoreCase("WITH DEFAULT ")) {
                this.setDefault("DEFAULT ");
            }
        }
        if (this.getCastDatatype() != null) {
            this.getCastDatatype().toANSIString();
            this.createCastFunction();
        }
    }

    public void toInformixString() throws ConvertException {
        int i;
        Vector constraintVector;
        this.constraintNullVector = new Vector();
        this.setIdentity(null);
        this.setAutoIncrement(null);
        this.setDatapageStorageLevel(null);
        this.setCollate(null);
        this.setCollationName(null);
        this.generated = null;
        this.always = null;
        this.asForIdentity = null;
        this.byForAlways = null;
        this.defaultForIdentity = null;
        this.asForIdentity = null;
        if (this.columnName != null && (this.columnName.startsWith("[") && this.columnName.endsWith("]") || this.columnName.startsWith("`") && this.columnName.endsWith("`"))) {
            this.columnName = this.columnName.substring(1, this.columnName.length() - 1);
            if (this.columnName.indexOf(32) != -1) {
                this.columnName = "\"" + this.columnName + "\"";
            }
        }
        if (this.getNullStatus() != null) {
            if (this.getNullStatus().trim().equalsIgnoreCase("NULL")) {
                this.setNullStatus(null);
            } else {
                this.constraintNullVector.add(this.getNullStatus());
            }
        }
        if (this.getConstraintClause() != null && (constraintVector = this.getConstraintClause()) != null) {
            for (i = 0; i < constraintVector.size(); ++i) {
                ConstraintClause toInformixConstraintClause = (ConstraintClause)constraintVector.get(i);
                if (toInformixConstraintClause == null) continue;
                ConstraintType toInformixConstraintType = toInformixConstraintClause.getConstraintType();
                toInformixConstraintClause.setColumnName(this.getColumnName());
                toInformixConstraintClause.toInformixString();
                if (toInformixConstraintType instanceof DefaultConstraintClause) {
                    this.constraintNullVector.insertElementAt(toInformixConstraintClause, 0);
                    continue;
                }
                this.constraintNullVector.add(toInformixConstraintClause);
            }
        }
        if (this.getDatatype() != null && !this.mapDatatype(this, this.datatypeMapping)) {
            Datatype toInformixDatatype = this.getDatatype();
            toInformixDatatype.toInformixString();
            if (toInformixDatatype instanceof CharacterClass) {
                this.enumValuesConvertedToCheckConstraints(toInformixDatatype, this.constraintNullVector);
            }
        }
        if (this.getComputedColumnExpression() != null) {
            this.setComputedColumnExpression(this.getComputedColumnExpression().toInformixSelect(null, null));
        }
        if (this.getDefaultValue() != null) {
            this.setDefaultOpenBrace(null);
            this.setDefaultClosedBrace(null);
            if (this.defaultValue.equalsIgnoreCase("SYSDATE")) {
                this.setDefaultValue("TODAY");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT DATE")) {
                this.setDefaultValue("TODAY");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIME")) {
                this.setDefaultValue("TODAY");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                this.setDefaultValue("TODAY");
            } else if (this.defaultValue.equalsIgnoreCase("SYSTEM_USER") || this.defaultValue.equalsIgnoreCase("CURRENT_USER")) {
                this.setDefaultValue("USER");
            } else if (this.defaultValue.indexOf("'") != -1) {
                this.setDefaultValue(this.defaultValue.replace('\'', '\"'));
            }
        } else if (this.getDefaultFunction() != null) {
            this.setDefaultFunction(this.functionCall.toInformixSelect(null, null));
        } else if (this.getDefaultExpression() != null) {
            ArrayList<SelectColumn> newExpList = new ArrayList<SelectColumn>();
            for (i = 0; i < this.defaultExpList.size(); ++i) {
                if (this.defaultExpList.get(i) instanceof SelectColumn) {
                    SelectColumn sc = (SelectColumn)this.defaultExpList.get(i);
                    newExpList.add(sc.toInformixSelect(null, null));
                    continue;
                }
                newExpList.add((SelectColumn)this.defaultExpList.get(i));
            }
            this.setDefaultExpression(newExpList);
        } else if (this.getDefault() != null) {
            this.setDefaultValue("NULL");
            if (this.getDefault().equalsIgnoreCase("WITH DEFAULT ")) {
                this.setDefault("DEFAULT ");
            }
        }
    }

    public void toTimesTenString() throws ConvertException {
        int i;
        Vector changeConstraintVector;
        this.constraintNullVector = new Vector();
        this.generated = null;
        this.always = null;
        this.byForAlways = null;
        this.defaultForIdentity = null;
        this.setDatapageStorageLevel(null);
        if (this.columnName != null && (this.columnName.startsWith("[") && this.columnName.endsWith("]") || this.columnName.startsWith("`") && this.columnName.endsWith("`"))) {
            this.columnName = this.columnName.substring(1, this.columnName.length() - 1);
            if (this.columnName.indexOf(32) != -1) {
                this.columnName = "\"" + this.columnName + "\"";
            }
        }
        boolean isPKColumn = false;
        if (this.getConstraintClause() != null && (changeConstraintVector = this.getConstraintClause()) != null) {
            for (i = 0; i < changeConstraintVector.size(); ++i) {
                ConstraintClause toTimesTenConstraintClause = (ConstraintClause)changeConstraintVector.get(i);
                if (toTimesTenConstraintClause == null) continue;
                ConstraintType toTimesTenConstraintType = toTimesTenConstraintClause.getConstraintType();
                toTimesTenConstraintClause.setColumnName(this.getColumnName());
                toTimesTenConstraintClause.toTimesTenString();
                if (toTimesTenConstraintType instanceof DefaultConstraintClause) {
                    if (CreateQueryStatement.commentWhenConstraintNameTruncated.trim().length() > 0 && CreateQueryStatement.commentWhenConstraintNameTruncated.indexOf("DEFAULT Constraint") == -1) {
                        CreateQueryStatement.commentWhenConstraintNameTruncated = CreateQueryStatement.commentWhenConstraintNameTruncated + "\n/* SwisSQL Message : DEFAULT Constraint is not supported in TimesTen 5.1.21 */";
                        continue;
                    }
                    if (CreateQueryStatement.commentWhenConstraintNameTruncated.indexOf("DEFAULT Constraint") != -1) continue;
                    CreateQueryStatement.commentWhenConstraintNameTruncated = "/* SwisSQL Message : DEFAULT Constraint is not supported in TimesTen 5.1.21 */";
                    continue;
                }
                if (toTimesTenConstraintClause.getAutoIncrement() != null) {
                    toTimesTenConstraintClause.setAutoIncrement(null);
                }
                toTimesTenConstraintClause.setColumnName(this.getColumnName());
                if (toTimesTenConstraintType instanceof PrimaryOrUniqueConstraintClause) {
                    PrimaryOrUniqueConstraintClause tempPrimaryOrUniqueConstraintClause = (PrimaryOrUniqueConstraintClause)toTimesTenConstraintType;
                    if (toTimesTenConstraintClause.getConstraint() != null) {
                        toTimesTenConstraintClause.setConstraint(null);
                        toTimesTenConstraintClause.setConstraintName(null);
                    }
                    if (tempPrimaryOrUniqueConstraintClause.getConstraintName().equalsIgnoreCase("PRIMARY KEY")) {
                        isPKColumn = true;
                    }
                    toTimesTenConstraintClause.toTimesTenString();
                    this.constraintNullVector.add(toTimesTenConstraintClause);
                    continue;
                }
                toTimesTenConstraintClause.toTimesTenString();
                this.constraintNullVector.add(toTimesTenConstraintClause);
            }
        }
        if (this.onDefault != null && this.onDefault.trim().equalsIgnoreCase("DEFAULT") && this.getDefaultValue() != null && this.getDefaultValue().trim().equalsIgnoreCase("null") && this.notNull == null) {
            NotNull newNotNull = new NotNull();
            newNotNull.setNullStatus("NULL");
            this.setNotNull(newNotNull);
        }
        if (this.getComputedColumnExpression() != null) {
            this.setComputedColumnExpression(this.getComputedColumnExpression().toTimesTenSelect(null, null));
        }
        if (!this.isAlterStatement) {
            if (this.getNullStatus() != null) {
                this.constraintNullVector.add(this.getNullStatus());
            } else if (!isPKColumn && this.getColumnName() != null && SwisSQLOptions.fromSybase && SwisSQLOptions.sybaseNotNullConstraint) {
                this.constraintNullVector.add("NOT NULL");
            }
        }
        if (this.getDatatype() != null) {
            if (!this.mapDatatype(this, this.datatypeMapping)) {
                Datatype toTimesTenDatatype = this.getDatatype();
                toTimesTenDatatype.toTimesTenString();
                toTimesTenDatatype.setDatatypeName(toTimesTenDatatype.getDatatypeName().toUpperCase());
                if (toTimesTenDatatype instanceof CharacterClass) {
                    this.enumValuesConvertedToCheckConstraints(toTimesTenDatatype, this.constraintNullVector);
                }
            }
        } else if (this.userDefinedDatatype != null && userdefinedDatatypes.size() > 0) {
            if (!this.mapUserDatatype(this, this.datatypeMapping, this.userDefinedDatatype)) {
                if (userdefinedDatatypes.containsKey(this.userDefinedDatatype.toLowerCase().trim())) {
                    String baseType = (String)userdefinedDatatypes.get(this.userDefinedDatatype.toLowerCase().trim());
                    Datatype ttType = SwisSQLUtils.constructDatatype(baseType);
                    if (ttType != null) {
                        ttType.toTimesTenString();
                        this.setUserDefinedDatatype(ttType.toString());
                    } else {
                        this.setUserDefinedDatatype(baseType);
                    }
                } else if (this.userDefinedDatatype.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
                    // empty if block
                }
            }
        } else if (this.userDefinedDatatype == null || userdefinedDatatypes.size() > 0 || this.mapUserDatatype(this, this.datatypeMapping, this.userDefinedDatatype) || this.userDefinedDatatype.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
            // empty if block
        }
        if (this.getDefaultFunction() != null || this.getDefaultValue() != null || this.getDefault() != null) {
            if (CreateQueryStatement.commentWhenConstraintNameTruncated.trim().length() > 0 && CreateQueryStatement.commentWhenConstraintNameTruncated.indexOf("DEFAULT Constraint") == -1) {
                CreateQueryStatement.commentWhenConstraintNameTruncated = CreateQueryStatement.commentWhenConstraintNameTruncated + "\n/* SwisSQL Message : DEFAULT Constraint is not supported in TimesTen 5.1.21 */";
            } else if (CreateQueryStatement.commentWhenConstraintNameTruncated.indexOf("DEFAULT Constraint") == -1) {
                CreateQueryStatement.commentWhenConstraintNameTruncated = "/* SwisSQL Message : DEFAULT Constraint is not supported in TimesTen 5.1.21 */";
            }
        }
        if (this.getDefaultValue() != null) {
            this.setDefault(null);
            this.setDefaultValue(null);
            this.setDefaultClosedBrace(null);
            this.setDefaultOpenBrace(null);
        } else if (this.getDefaultFunction() != null) {
            this.setDefaultFunction(null);
            this.setDefault(null);
        } else if (this.getDefaultExpression() != null) {
            ArrayList<SelectColumn> newExpList = new ArrayList<SelectColumn>();
            for (i = 0; i < this.defaultExpList.size(); ++i) {
                if (this.defaultExpList.get(i) instanceof SelectColumn) {
                    SelectColumn sc = (SelectColumn)this.defaultExpList.get(i);
                    newExpList.add(sc.toTimesTenSelect(null, null));
                    continue;
                }
                newExpList.add((SelectColumn)this.defaultExpList.get(i));
            }
            this.setDefaultExpression(newExpList);
        } else if (this.getDefault() != null) {
            this.setDefault(null);
        }
        if (this.identity != null) {
            Datatype type = this.getDatatype();
            if (type instanceof NumericClass) {
                NumericClass nc = (NumericClass)type;
                nc.setDatatypeName("INT");
                nc.setSize(null);
                nc.setPrecision(null);
                nc.setScale(null);
                nc.setOpenBrace(null);
                nc.setClosedBrace(null);
            }
            CreateSequenceStatement createSequenceObj = new CreateSequenceStatement();
            TableObject tableObj = new TableObject();
            createSequenceObj.setSequence("SEQUENCE");
            String timesTenColumnName = this.columnName;
            this.setTableNameAfterTruncation(timesTenColumnName, tableObj);
            createSequenceObj.setSchemaName(tableObj);
            if (!this.identity.trim().equalsIgnoreCase("IDENTITY")) {
                String tempIdentity = this.identity.trim().substring(8).trim();
                tempIdentity = tempIdentity.substring(1, tempIdentity.length() - 1);
                StringTokenizer st = new StringTokenizer(tempIdentity, ",");
                String token1 = st.nextToken();
                createSequenceObj.setMinValueOrNoMinValue("MINVALUE " + token1);
                if (st.countTokens() > 0) {
                    String token2 = st.nextToken();
                    createSequenceObj.setIncrementString("INCREMENT BY");
                    createSequenceObj.setIncrementValue(token2);
                } else {
                    createSequenceObj.setIncrementString("INCREMENT BY");
                    createSequenceObj.setIncrementValue("1");
                }
            }
            SelectQueryStatement.singleQueryConvertedToMultipleQueryList = SelectQueryStatement.singleQueryConvertedToMultipleQueryList != null ? SelectQueryStatement.singleQueryConvertedToMultipleQueryList + "CREATE " + createSequenceObj.toString() + ";\n\n/* SwisSQL Message : Query split into multiple Queries. */\n\n" : "CREATE " + createSequenceObj.toString() + ";\n\n/* SwisSQL Message : Query split into multiple Queries. */\n\n";
            this.setIdentity(null);
        }
        if (this.autoIncrement != null) {
            this.getDatatype().setDatatypeName("INT");
            this.getDatatype().setSize(null);
            this.getDatatype().setOpenBrace(null);
            this.getDatatype().setClosedBrace(null);
            CreateSequenceStatement createSequenceObj = new CreateSequenceStatement();
            TableObject tableObj = new TableObject();
            createSequenceObj.setSequence("SEQUENCE");
            String timesTenColumnName = this.columnName;
            this.setTableNameAfterTruncation(timesTenColumnName, tableObj);
            createSequenceObj.setSchemaName(tableObj);
            SelectQueryStatement.singleQueryConvertedToMultipleQueryList = SelectQueryStatement.singleQueryConvertedToMultipleQueryList != null ? SelectQueryStatement.singleQueryConvertedToMultipleQueryList + "CREATE " + createSequenceObj.toString() + ";\n\n/* SwisSQL Message : Query split into multiple Queries. */\n\n" : "CREATE " + createSequenceObj.toString() + ";\n\n/* SwisSQL Message : Query split into multiple Queries. */\n\n";
            this.autoIncrement = null;
        }
        this.asForIdentity = null;
    }

    public void toNetezzaString() throws ConvertException {
        int i;
        Vector changeConstraintVector;
        this.constraintNullVector = new Vector();
        this.setIdentity(null);
        this.setDatapageStorageLevel(null);
        this.setAutoIncrement(null);
        this.setCollate(null);
        this.setCollationName(null);
        this.generated = null;
        this.always = null;
        this.asForIdentity = null;
        this.byForAlways = null;
        this.defaultForIdentity = null;
        this.asForIdentity = null;
        if (this.columnName != null) {
            if (this.columnName.startsWith("[") && this.columnName.endsWith("]") || this.columnName.startsWith("`") && this.columnName.endsWith("`")) {
                this.columnName = this.columnName.substring(1, this.columnName.length() - 1);
                if (this.columnName.indexOf(32) != -1) {
                    this.columnName = "\"" + this.columnName + "\"";
                }
            }
            this.columnName = CustomizeUtil.objectNamesToQuotedIdentifier(this.columnName, SwisSQLUtils.getKeywords(11), null, 11);
        }
        if (this.getConstraintClause() != null && (changeConstraintVector = this.getConstraintClause()) != null) {
            for (i = 0; i < changeConstraintVector.size(); ++i) {
                ConstraintClause toNetezzaSQLConstraintClause = (ConstraintClause)changeConstraintVector.get(i);
                if (toNetezzaSQLConstraintClause == null) continue;
                toNetezzaSQLConstraintClause.setColumnName(this.getColumnName());
                toNetezzaSQLConstraintClause.toNetezzaString();
                this.constraintNullVector.add(toNetezzaSQLConstraintClause);
            }
        }
        if (this.getComputedColumnExpression() != null) {
            this.setComputedColumnAS("AS");
            this.setComputedColumnExpression(this.getComputedColumnExpression().toNetezzaSelect(null, null));
        }
        if (this.getNullStatus() != null) {
            this.constraintNullVector.add(this.getNullStatus());
        }
        if (this.getDatatype() != null && !this.mapDatatype(this, this.datatypeMapping)) {
            Datatype toNetezzaSQLDatatype = this.getDatatype();
            toNetezzaSQLDatatype.toNetezzaString();
            if (toNetezzaSQLDatatype instanceof CharacterClass) {
                this.enumValuesConvertedToCheckConstraints(toNetezzaSQLDatatype, this.constraintNullVector);
            }
        }
        if (this.getDefaultValue() != null) {
            if (this.defaultValue.equalsIgnoreCase("SYSDATE")) {
                this.setDefaultValue("CURRENT_DATE");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT DATE")) {
                this.setDefaultValue("CURRENT_DATE");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIME")) {
                this.setDefaultValue("CURRENT_TIME");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                this.setDefaultValue("CURRENT_TIMESTAMP");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT")) {
                this.setDefaultValue("CURRENT_DATE");
            } else if (this.defaultValue.equalsIgnoreCase("USER")) {
                this.setDefaultValue("CURRENT_USER");
            }
        } else if (this.getDefaultFunction() != null) {
            this.setDefaultFunction(this.functionCall.toNetezzaSelect(null, null));
        } else if (this.getDefaultExpression() != null) {
            ArrayList<SelectColumn> newExpList = new ArrayList<SelectColumn>();
            for (i = 0; i < this.defaultExpList.size(); ++i) {
                if (this.defaultExpList.get(i) instanceof SelectColumn) {
                    SelectColumn sc = (SelectColumn)this.defaultExpList.get(i);
                    newExpList.add(sc.toNetezzaSelect(null, null));
                    continue;
                }
                newExpList.add((SelectColumn)this.defaultExpList.get(i));
            }
            this.setDefaultExpression(newExpList);
        } else if (this.getDefault() != null) {
            this.setDefaultValue("NULL");
            if (this.getDefault().equalsIgnoreCase("WITH DEFAULT ")) {
                this.setDefault("DEFAULT ");
            }
        }
        if (this.getCastDatatype() != null) {
            this.getCastDatatype().toNetezzaString();
            this.createCastFunction();
        }
    }

    public void toTeradataString() throws ConvertException {
        Vector changeConstraintVector;
        this.constraintNullVector = new Vector();
        this.setIdentity(null);
        this.setDatapageStorageLevel(null);
        this.setAutoIncrement(null);
        this.setCollate(null);
        this.setCollationName(null);
        this.generated = null;
        this.always = null;
        this.asForIdentity = null;
        this.byForAlways = null;
        this.defaultForIdentity = null;
        this.asForIdentity = null;
        if (this.columnName != null) {
            if (this.columnName.startsWith("[") && this.columnName.endsWith("]") || this.columnName.startsWith("`") && this.columnName.endsWith("`")) {
                this.columnName = this.columnName.substring(1, this.columnName.length() - 1);
                if (this.columnName.indexOf(32) != -1) {
                    this.columnName = "\"" + this.columnName + "\"";
                }
            } else {
                this.columnName = CustomizeUtil.objectNamesToQuotedIdentifier(this.columnName, SwisSQLUtils.getKeywords("teradata"), null, -1);
            }
        }
        if (this.getConstraintClause() != null && (changeConstraintVector = this.getConstraintClause()) != null) {
            for (int i = 0; i < changeConstraintVector.size(); ++i) {
                ConstraintClause toTeradataSQLConstraintClause = (ConstraintClause)changeConstraintVector.get(i);
                if (toTeradataSQLConstraintClause == null) continue;
                toTeradataSQLConstraintClause.setColumnName(this.getColumnName());
                toTeradataSQLConstraintClause.toTeradataString();
                this.constraintNullVector.add(toTeradataSQLConstraintClause);
            }
        }
        if (this.getComputedColumnExpression() != null) {
            this.setComputedColumnAS("AS");
            this.setComputedColumnExpression(this.getComputedColumnExpression().toTeradataSelect(null, null));
        }
        if (this.getNullStatus() != null) {
            this.constraintNullVector.add(this.getNullStatus());
        }
        if (this.getDatatype() != null && !this.mapDatatype(this, this.datatypeMapping)) {
            Datatype toTeradataSQLDatatype = this.getDatatype();
            toTeradataSQLDatatype.toTeradataString();
            if (toTeradataSQLDatatype instanceof CharacterClass) {
                this.enumValuesConvertedToCheckConstraints(toTeradataSQLDatatype, this.constraintNullVector);
            }
        }
        if (this.getDefaultExpression() != null) {
            ArrayList newExpList = new ArrayList();
            int size = this.defaultExpList.size();
            if (size == 1) {
                if (this.defaultExpList.get(0) instanceof SelectColumn) {
                    SelectColumn sc = (SelectColumn)this.defaultExpList.get(0);
                    Vector expList = sc.getColumnExpression();
                    if (expList.size() == 1) {
                        TableColumn tc;
                        String colName;
                        Object obj = expList.get(0);
                        if (obj instanceof String) {
                            this.setDefaultValue((String)obj);
                        } else if (obj instanceof TableColumn && (colName = (tc = (TableColumn)obj).getColumnName()) != null) {
                            this.setDefaultValue(colName);
                        }
                    }
                } else {
                    ArrayList expWithoutSc = this.getDefaultExpression();
                    if (expWithoutSc.size() == 1 && expWithoutSc.get(0) instanceof String) {
                        this.setDefaultValue((String)expWithoutSc.get(0));
                    }
                }
            }
        }
        if (this.getDefaultValue() != null) {
            if (this.defaultValue.equalsIgnoreCase("SYSDATE")) {
                this.setDefaultValue("CURRENT_DATE");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT DATE")) {
                this.setDefaultValue("CURRENT_DATE");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIME")) {
                this.setDefaultValue("CURRENT_TIME");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT TIMESTAMP")) {
                this.setDefaultValue("CURRENT_TIMESTAMP");
            } else if (this.defaultValue.equalsIgnoreCase("CURRENT")) {
                this.setDefaultValue("CURRENT_DATE");
            } else if (this.defaultValue.equalsIgnoreCase("USER")) {
                this.setDefaultValue("CURRENT_USER");
            }
        } else if (this.getDefaultFunction() != null) {
            this.setDefaultFunction(this.functionCall.toTeradataSelect(null, null));
        } else if (this.getDefault() != null) {
            this.setDefaultValue("NULL");
            if (this.getDefault().equalsIgnoreCase("WITH DEFAULT ")) {
                this.setDefault("DEFAULT ");
            }
        }
        if (this.getCastDatatype() != null) {
            this.getCastDatatype().toTeradataString();
            this.createCastFunction();
        }
    }

    private void setTableNameAfterTruncation(String sourceColumnName, TableObject tableObj) {
        if (sourceColumnName.startsWith("[") || sourceColumnName.startsWith("\"")) {
            sourceColumnName = "\"" + sourceColumnName.substring(1);
            if (sourceColumnName.endsWith("]") || sourceColumnName.endsWith("\"")) {
                sourceColumnName = sourceColumnName.substring(0, sourceColumnName.length() - 1) + "\"";
            }
            if (this.tableNameFromCQS != null) {
                String str2 = this.tableNameFromCQS + sourceColumnName.substring(1, sourceColumnName.length() - 1) + "_SEQ";
                String str1 = this.tableNameFromCQS + sourceColumnName.substring(1, sourceColumnName.length() - 1);
                String str22 = this.tableNameFromCQS;
                if (str2.length() > 29) {
                    if (str1.length() > 25) {
                        str2 = str1.substring(0, 26) + "_SEQ";
                        if (str2.startsWith("\"")) {
                            str2 = StringFunctions.replaceAll("", "\"", str2);
                            str2 = "\"" + str2 + "\"";
                        }
                    } else if (str22.length() > 25) {
                        str2 = str22.substring(0, 26) + "_SEQ";
                        if (str22.startsWith("\"")) {
                            str2 = StringFunctions.replaceAll("", "\"", str22);
                            str2 = "\"" + str2 + "\"";
                        }
                    }
                    if (str2.length() > 27) {
                        tableObj.setTableName("\"" + str2.substring(0, 28) + "\"");
                        String table_name_str = tableObj.getTableName();
                        if (table_name_str.startsWith("\"")) {
                            table_name_str = StringFunctions.replaceAll("", "\"", table_name_str);
                            table_name_str = "\"" + table_name_str + "\"";
                            tableObj.setTableName(table_name_str);
                        }
                    } else {
                        tableObj.setTableName("\"" + str2 + "\"");
                        String table_name_str = tableObj.getTableName();
                        if (table_name_str.startsWith("\"")) {
                            table_name_str = StringFunctions.replaceAll("", "\"", table_name_str);
                            table_name_str = "\"" + table_name_str + "\"";
                            tableObj.setTableName(table_name_str);
                        }
                    }
                } else if (str2.length() > 27) {
                    tableObj.setTableName("\"" + this.tableNameFromCQS + "_" + sourceColumnName + "_S" + "\"");
                    String table_name_str = tableObj.getTableName();
                    if (table_name_str.startsWith("\"")) {
                        table_name_str = StringFunctions.replaceAll("", "\"", table_name_str);
                        table_name_str = "\"" + table_name_str + "\"";
                        tableObj.setTableName(table_name_str);
                    }
                } else {
                    tableObj.setTableName("\"" + this.tableNameFromCQS + "_" + sourceColumnName + "_SEQ" + "\"");
                    String table_name_str = tableObj.getTableName();
                    if (table_name_str.startsWith("\"")) {
                        table_name_str = StringFunctions.replaceAll("", "\"", table_name_str);
                        table_name_str = "\"" + table_name_str + "\"";
                        tableObj.setTableName(table_name_str);
                    }
                }
            } else {
                tableObj.setTableName(sourceColumnName + "_SEQ");
                String table_name_str = tableObj.getTableName();
                if (table_name_str.startsWith("\"")) {
                    table_name_str = StringFunctions.replaceAll("", "\"", table_name_str);
                    table_name_str = "\"" + table_name_str + "\"";
                    tableObj.setTableName(table_name_str);
                }
            }
        } else if (this.tableNameFromCQS != null) {
            String str3 = this.tableNameFromCQS + "_" + sourceColumnName + "_SEQ";
            String str1 = this.tableNameFromCQS + "_" + sourceColumnName;
            String str2 = this.tableNameFromCQS;
            if (str3.length() > 29) {
                if (str1.length() > 25) {
                    str3 = str1.substring(0, 26) + "_SEQ";
                } else if (str2.length() > 25) {
                    str3 = str2.substring(0, 26) + "_SEQ";
                }
                tableObj.setTableName(str3);
                String table_name_str = tableObj.getTableName();
                if (table_name_str.startsWith("\"")) {
                    table_name_str = StringFunctions.replaceAll("", "\"", table_name_str);
                    table_name_str = "\"" + table_name_str + "\"";
                    tableObj.setTableName(table_name_str);
                }
            } else {
                tableObj.setTableName(this.tableNameFromCQS + "_" + sourceColumnName + "_SEQ");
                String table_name_str = tableObj.getTableName();
                if (table_name_str.startsWith("\"")) {
                    table_name_str = StringFunctions.replaceAll("", "\"", table_name_str);
                    table_name_str = "\"" + table_name_str + "\"";
                    tableObj.setTableName(table_name_str);
                }
            }
        } else {
            tableObj.setTableName(this.columnName + "_SEQ");
            String table_name_str = tableObj.getTableName();
            if (table_name_str.startsWith("\"")) {
                table_name_str = StringFunctions.replaceAll("", "\"", table_name_str);
                table_name_str = "\"" + table_name_str + "\"";
                tableObj.setTableName(table_name_str);
            }
        }
    }

    public CreateColumn copyObjectValues() {
        CreateColumn dupCreateColumn = new CreateColumn();
        Vector orgConstraintVector = this.getConstraintClause();
        if (orgConstraintVector != null) {
            Vector<ConstraintClause> newConstraintVector = new Vector<ConstraintClause>();
            for (int i = 0; i < orgConstraintVector.size(); ++i) {
                ConstraintClause orgConstraintClause = (ConstraintClause)orgConstraintVector.get(i);
                if (orgConstraintClause == null) continue;
                ConstraintClause newConstraintClause = orgConstraintClause.copyObjectValues();
                newConstraintVector.add(newConstraintClause);
            }
            dupCreateColumn.setConstraintClause(newConstraintVector);
        }
        dupCreateColumn.setColumnName(this.getColumnName());
        dupCreateColumn.setObjectContext(this.context);
        Datatype orgDatatype = this.getDatatype();
        if (orgDatatype != null) {
            Datatype dupDatatype = null;
            if (orgDatatype instanceof NumericClass) {
                NumericClass numericDatatype = (NumericClass)orgDatatype;
                dupDatatype = numericDatatype.copyObjectValues();
            } else if (orgDatatype instanceof CharacterClass) {
                CharacterClass characterDatatype = (CharacterClass)orgDatatype;
                dupDatatype = characterDatatype.copyObjectValues();
            } else if (orgDatatype instanceof DateClass) {
                DateClass dateDatatype = (DateClass)orgDatatype;
                dupDatatype = dateDatatype.copyObjectValues();
            } else if (orgDatatype instanceof BinClass) {
                BinClass binDatatype = (BinClass)orgDatatype;
                dupDatatype = binDatatype.copyObjectValues();
            } else if (orgDatatype instanceof GeometryClass) {
                GeometryClass geometryDatatype = (GeometryClass)orgDatatype;
                dupDatatype = geometryDatatype.copyObjectValues();
            } else if (orgDatatype instanceof QuotedIdentifierDatatype) {
                QuotedIdentifierDatatype quotedDatatype = (QuotedIdentifierDatatype)orgDatatype;
                dupDatatype = quotedDatatype.copyObjectValues();
            }
            dupCreateColumn.setDatatype(dupDatatype);
        }
        dupCreateColumn.setUserDefinedDatatype(this.userDefinedDatatype);
        dupCreateColumn.setDefault(this.getDefault());
        dupCreateColumn.setDefaultOpenBrace(this.defaultOpenBrace);
        dupCreateColumn.setDefaultValue(this.getDefaultValue());
        dupCreateColumn.setDefaultClosedBrace(this.defaultClosedBrace);
        dupCreateColumn.setIdentity(this.getIdentity());
        dupCreateColumn.setNullStatus(this.getNullStatus());
        dupCreateColumn.setDefaultFunction(this.getDefaultFunction());
        dupCreateColumn.setCollate(this.collate);
        dupCreateColumn.setCollationName(this.collationName);
        dupCreateColumn.setGenerated(this.generated);
        dupCreateColumn.setAlways(this.always);
        dupCreateColumn.setByForAlways(this.byForAlways);
        dupCreateColumn.setDefaultForIdentity(this.defaultForIdentity);
        dupCreateColumn.setIdentityAs(this.asForIdentity);
        dupCreateColumn.setAutoIncrement(this.autoIncrement);
        dupCreateColumn.setDatapageStorageLevel(this.datapageStorageLevel);
        dupCreateColumn.setDefaultExpression(this.defaultExpList);
        dupCreateColumn.setCastDatatype(this.castDatatype);
        dupCreateColumn.setComputedColumnExpression(this.computedColumnExpression);
        return dupCreateColumn;
    }

    private boolean mapDatatype(CreateColumn changeCreateColumn, DatatypeMapping mapping) {
        String datatypeName;
        Datatype changeCreateColumnDatatype = changeCreateColumn.getDatatype();
        if (changeCreateColumnDatatype != null && (datatypeName = changeCreateColumnDatatype.getDatatypeName()) != null) {
            if (SwisSQLAPI.objectContext != null) {
                String tableName = this.tableNameFromCQS;
                String columnName = changeCreateColumn.getColumnName();
                Object val = null;
                if ((datatypeName.equalsIgnoreCase("varchar") || datatypeName.equalsIgnoreCase("nvarchar")) && changeCreateColumn.getDatatype().getSize() != null && changeCreateColumn.getDatatype().getSize().equalsIgnoreCase("max")) {
                    String dataTypeNameWithSize = datatypeName.trim() + "(" + changeCreateColumn.getDatatype().getSize() + ")";
                    val = SwisSQLAPI.objectContext.getMappedDatatype(tableName, columnName, dataTypeNameWithSize);
                } else {
                    val = SwisSQLAPI.objectContext.getMappedDatatype(tableName, columnName, datatypeName);
                }
                if (val != null) {
                    String newDatatypeName = (String)val;
                    if (!(changeCreateColumn.getDatatype().getSize() == null || !changeCreateColumn.getDatatype().getSize().equalsIgnoreCase("max") || newDatatypeName.startsWith("varchar") && newDatatypeName.startsWith("nvarchar"))) {
                        changeCreateColumnDatatype.setOpenBrace(null);
                        changeCreateColumnDatatype.setClosedBrace(null);
                        changeCreateColumnDatatype.setSize(null);
                    }
                    if (newDatatypeName.indexOf("(") != -1) {
                        changeCreateColumnDatatype.setDatatypeName(newDatatypeName.substring(0, newDatatypeName.indexOf("(")));
                        changeCreateColumnDatatype.setOpenBrace("(");
                        changeCreateColumnDatatype.setClosedBrace(")");
                        changeCreateColumnDatatype.setSize(newDatatypeName.substring(newDatatypeName.indexOf("(") + 1, newDatatypeName.indexOf(")")));
                        if (changeCreateColumnDatatype instanceof QuotedIdentifierDatatype) {
                            ((QuotedIdentifierDatatype)changeCreateColumnDatatype).setPrecision(newDatatypeName.substring(newDatatypeName.indexOf("(") + 1, newDatatypeName.indexOf(")")));
                        }
                    } else {
                        changeCreateColumnDatatype.setDatatypeName(newDatatypeName);
                    }
                    return true;
                }
            }
            if (mapping != null) {
                Hashtable globalMapping;
                String newDatatypeName;
                Hashtable tableSpecificMapping = mapping.getTableSpecificDatatypeMapping();
                if (tableSpecificMapping != null && this.tableNameFromCQS != null) {
                    boolean contain = tableSpecificMapping.containsKey(this.tableNameFromCQS.toLowerCase());
                    String tableNameWithoutDelimiter = null;
                    if (!contain) {
                        tableNameWithoutDelimiter = this.removeDelimiter(this.tableNameFromCQS.toLowerCase());
                        contain = tableSpecificMapping.containsKey(tableNameWithoutDelimiter);
                    }
                    if (contain) {
                        Hashtable column = (Hashtable)tableSpecificMapping.get(this.tableNameFromCQS.toLowerCase());
                        if (column == null) {
                            column = (Hashtable)tableSpecificMapping.get(tableNameWithoutDelimiter);
                        }
                        if (column != null) {
                            newDatatypeName = (String)column.get(changeCreateColumn.getColumnName().toLowerCase());
                            if (newDatatypeName == null) {
                                newDatatypeName = (String)column.get(this.removeDelimiter(changeCreateColumn.getColumnName().toLowerCase()));
                            }
                            if (newDatatypeName != null) {
                                if (newDatatypeName.indexOf("(") != -1) {
                                    changeCreateColumnDatatype.setDatatypeName(newDatatypeName.substring(0, newDatatypeName.indexOf("(")));
                                    changeCreateColumnDatatype.setOpenBrace("(");
                                    changeCreateColumnDatatype.setClosedBrace(")");
                                    changeCreateColumnDatatype.setSize(newDatatypeName.substring(newDatatypeName.indexOf("(") + 1, newDatatypeName.indexOf(")")));
                                    if (changeCreateColumnDatatype instanceof QuotedIdentifierDatatype) {
                                        ((QuotedIdentifierDatatype)changeCreateColumnDatatype).setPrecision(newDatatypeName.substring(newDatatypeName.indexOf("(") + 1, newDatatypeName.indexOf(")")));
                                    }
                                } else {
                                    changeCreateColumnDatatype.setDatatypeName(newDatatypeName);
                                    if (changeCreateColumnDatatype.getOpenBrace() != null) {
                                        NumericClass nC;
                                        if (changeCreateColumnDatatype instanceof NumericClass && (nC = (NumericClass)changeCreateColumnDatatype).getPrecision() != null) {
                                            nC.setPrecision(null);
                                            if (nC.getScale() != null) {
                                                nC.setScale(null);
                                            }
                                        }
                                        changeCreateColumnDatatype.setOpenBrace(null);
                                        changeCreateColumnDatatype.setSize(null);
                                        changeCreateColumnDatatype.setClosedBrace(null);
                                    }
                                }
                                return true;
                            }
                        }
                    }
                }
                if ((globalMapping = mapping.getGlobalDatatypeMapping()) != null) {
                    String origDatatypeName = datatypeName;
                    if (changeCreateColumnDatatype instanceof NumericClass) {
                        NumericClass nc = (NumericClass)changeCreateColumnDatatype;
                        if (nc.getPrecision() != null) {
                            datatypeName = datatypeName + "(" + nc.getPrecision();
                            if (nc.getScale() != null) {
                                datatypeName = datatypeName + "," + nc.getScale();
                            }
                            datatypeName = datatypeName + ")";
                        }
                    } else if (changeCreateColumnDatatype.getOpenBrace() != null) {
                        if (changeCreateColumnDatatype instanceof QuotedIdentifierDatatype) {
                            if (changeCreateColumnDatatype.getSize() != null) {
                                datatypeName = datatypeName + "(" + changeCreateColumnDatatype.getSize() + ")";
                            } else if (((QuotedIdentifierDatatype)changeCreateColumnDatatype).getPrecision() != null) {
                                datatypeName = datatypeName + "(" + ((QuotedIdentifierDatatype)changeCreateColumnDatatype).getPrecision() + ")";
                            }
                        } else {
                            datatypeName = datatypeName + "(" + changeCreateColumnDatatype.getSize() + ")";
                        }
                    }
                    CharacterClass cc = null;
                    if (changeCreateColumnDatatype instanceof CharacterClass && (cc = (CharacterClass)changeCreateColumnDatatype).getBinary() != null && cc.getBinary().toUpperCase().indexOf("FOR BIT DATA") != -1) {
                        datatypeName = datatypeName + " FOR BIT DATA";
                    }
                    if (globalMapping.containsKey(datatypeName.toLowerCase())) {
                        newDatatypeName = (String)globalMapping.get(datatypeName.toLowerCase());
                        if (newDatatypeName.indexOf("(") != -1) {
                            changeCreateColumnDatatype.setDatatypeName(newDatatypeName.substring(0, newDatatypeName.indexOf("(")));
                            changeCreateColumnDatatype.setOpenBrace("(");
                            changeCreateColumnDatatype.setClosedBrace(")");
                            changeCreateColumnDatatype.setSize(newDatatypeName.substring(newDatatypeName.indexOf("(") + 1, newDatatypeName.indexOf(")")));
                            if (changeCreateColumnDatatype instanceof QuotedIdentifierDatatype) {
                                ((QuotedIdentifierDatatype)changeCreateColumnDatatype).setPrecision(newDatatypeName.substring(newDatatypeName.indexOf("(") + 1, newDatatypeName.indexOf(")")));
                            }
                        } else if (datatypeName.indexOf("(") != -1) {
                            changeCreateColumnDatatype.setDatatypeName(newDatatypeName);
                            changeCreateColumnDatatype.setOpenBrace(null);
                            changeCreateColumnDatatype.setClosedBrace(null);
                            changeCreateColumnDatatype.setSize(null);
                            if (changeCreateColumnDatatype instanceof NumericClass) {
                                NumericClass nc = (NumericClass)changeCreateColumnDatatype;
                                nc.setPrecision(null);
                                nc.setScale(null);
                            }
                        } else {
                            changeCreateColumnDatatype.setDatatypeName(newDatatypeName);
                        }
                        if (cc != null && cc.getBinary() != null) {
                            cc.setBinary(null);
                        }
                        return true;
                    }
                    if (globalMapping.containsKey(origDatatypeName.toLowerCase())) {
                        newDatatypeName = (String)globalMapping.get(origDatatypeName.toLowerCase());
                        if (newDatatypeName.indexOf("(") != -1) {
                            String size = newDatatypeName.substring(newDatatypeName.indexOf("(") + 1, newDatatypeName.indexOf(")"));
                            changeCreateColumnDatatype.setOpenBrace("(");
                            changeCreateColumnDatatype.setClosedBrace(")");
                            changeCreateColumnDatatype.setSize(size);
                            newDatatypeName = newDatatypeName.substring(0, newDatatypeName.indexOf("("));
                        }
                        changeCreateColumnDatatype.setDatatypeName(newDatatypeName);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean mapUserDatatype(CreateColumn changeCreateColumn, DatatypeMapping mapping, String datatypeName) {
        String columnName;
        String tableName;
        Object val;
        if (SwisSQLAPI.objectContext != null && (val = SwisSQLAPI.objectContext.getMappedDatatype(tableName = this.tableNameFromCQS, columnName = changeCreateColumn.getColumnName(), datatypeName)) != null) {
            this.setUserDefinedDatatype((String)val);
            return true;
        }
        if (mapping != null) {
            Hashtable globalMapping;
            Hashtable tableSpecificMapping = mapping.getTableSpecificDatatypeMapping();
            if (tableSpecificMapping != null && this.tableNameFromCQS != null) {
                boolean contain = tableSpecificMapping.containsKey(this.tableNameFromCQS.toLowerCase());
                String tableNameWithoutDelimiter = null;
                if (!contain) {
                    tableNameWithoutDelimiter = this.removeDelimiter(this.tableNameFromCQS.toLowerCase());
                    contain = tableSpecificMapping.containsKey(tableNameWithoutDelimiter);
                }
                if (contain) {
                    Hashtable column = (Hashtable)tableSpecificMapping.get(this.tableNameFromCQS.toLowerCase());
                    if (column == null) {
                        column = (Hashtable)tableSpecificMapping.get(tableNameWithoutDelimiter);
                    }
                    if (column != null) {
                        String newDatatypeName = (String)column.get(changeCreateColumn.getColumnName().toLowerCase());
                        if (newDatatypeName == null) {
                            newDatatypeName = (String)column.get(this.removeDelimiter(changeCreateColumn.getColumnName().toLowerCase()));
                        }
                        if (newDatatypeName != null) {
                            this.setUserDefinedDatatype(newDatatypeName);
                            return true;
                        }
                    }
                }
            }
            if ((globalMapping = mapping.getGlobalDatatypeMapping()) != null && globalMapping.containsKey(datatypeName.toLowerCase())) {
                String newDatatypeName = (String)globalMapping.get(datatypeName.toLowerCase());
                this.setUserDefinedDatatype(newDatatypeName);
                return true;
            }
        }
        return false;
    }

    private String removeDelimiter(String name) {
        if (name.startsWith("[") && name.endsWith("]") || name.startsWith("\"") && name.endsWith("\"") || name.startsWith("`") && name.endsWith("`")) {
            return name.substring(1, name.length() - 1);
        }
        return name;
    }

    public String toString() {
        String str2;
        StringBuffer sb = new StringBuffer();
        if (this.columnName != null) {
            if (this.context != null) {
                String temp = this.context.getEquivalent(this.columnName).toString();
                sb.append(temp + " ");
            } else {
                sb.append(this.columnName + " ");
            }
        }
        if (this.datatype != null) {
            if (this.datatype.toString().trim().equalsIgnoreCase("BOOLEAN")) {
                if (this.booleanDb2) {
                    sb.append("SMALLINT CHECK(" + this.columnName + "=0 or " + this.columnName + "=1) ");
                } else if (this.booleanOracle) {
                    if (this.getDefaultValue() != null && this.onDefault != null) {
                        sb.append("NUMBER(1) " + this.onDefault + " " + this.getDefaultValue() + " CHECK(" + this.columnName + "=0 or " + this.columnName + "=1) ");
                    } else {
                        sb.append("NUMBER(1) CHECK(" + this.columnName + "=0 or " + this.columnName + "=1) ");
                    }
                } else {
                    sb.append(this.datatype.toString() + " ");
                }
            } else {
                sb.append(this.datatype.toString() + " ");
            }
        } else if (this.userDefinedDatatype != null) {
            sb.append(this.userDefinedDatatype + " ");
        }
        if (this.computedColumnExpression != null) {
            if (this.computedColumnAS != null) {
                sb.append(this.computedColumnAS + " ");
            }
            sb.append(this.computedColumnExpression.toString() + " ");
        }
        if (this.collate != null) {
            sb.append(this.collate + " ");
        }
        if (this.collationName != null) {
            sb.append(this.collationName + " ");
        }
        if (this.sparseStr != null) {
            sb.append(this.sparseStr + " ");
        }
        if (this.onDefault != null && !this.booleanOracle) {
            sb.append(this.onDefault.toUpperCase() + " ");
        }
        if (this.defaultOpenBrace != null) {
            sb.append(this.defaultOpenBrace + " ");
        }
        if (this.defaultValue != null && !this.booleanOracle) {
            sb.append(this.defaultValue + " ");
        } else if (this.getDefaultFunction() != null) {
            this.functionCall.setObjectContext(this.context);
            sb.append(this.functionCall + " ");
        } else if (this.getDefaultExpression() != null) {
            for (int i = 0; i < this.defaultExpList.size(); ++i) {
                sb.append(this.defaultExpList.get(i) + " ");
            }
        }
        if (this.defaultClosedBrace != null) {
            sb.append(this.defaultClosedBrace + " ");
        }
        if (this.generated != null) {
            sb.append(" " + this.generated.toUpperCase());
        }
        if (this.always != null) {
            sb.append(" " + this.always.toUpperCase());
        }
        if (this.byForAlways != null) {
            sb.append(" " + this.byForAlways.toUpperCase());
        }
        if (this.defaultForIdentity != null) {
            sb.append(" " + this.defaultForIdentity);
        }
        if (this.asForIdentity != null) {
            sb.append(" " + this.asForIdentity.toUpperCase() + " ");
        }
        if (this.identity != null) {
            sb.append(this.identity + " ");
        }
        if (this.constraintNullVector != null) {
            for (int i = 0; i < this.constraintNullVector.size(); ++i) {
                if (this.constraintNullVector.get(i) instanceof String) {
                    String str3 = sb.toString().trim();
                    if (((String)this.constraintNullVector.get(i)).trim().toUpperCase().equals("NOT NULL")) {
                        if (str3.toUpperCase().indexOf("NOT NULL") != -1) continue;
                        sb.append(((String)this.constraintNullVector.get(i)).toUpperCase() + " ");
                        continue;
                    }
                    if (((String)this.constraintNullVector.get(i)).equalsIgnoreCase("null") || ((String)this.constraintNullVector.get(i)).equalsIgnoreCase("not null")) {
                        sb.append(((String)this.constraintNullVector.get(i)).toUpperCase() + " ");
                        continue;
                    }
                    sb.append((String)this.constraintNullVector.get(i) + " ");
                    continue;
                }
                if (this.constraintNullVector.get(i) instanceof ConstraintClause) {
                    ConstraintClause constraintClause = (ConstraintClause)this.constraintNullVector.get(i);
                    constraintClause.setObjectContext(this.context);
                    sb.append(constraintClause.toString());
                    continue;
                }
                if (!(this.constraintNullVector.get(i) instanceof CreateColumn)) continue;
                CreateColumn createCol = (CreateColumn)this.constraintNullVector.get(i);
                createCol.setObjectContext(this.context);
                sb.append(createCol.toString());
            }
        } else if (this.constraintVector != null || this.getNullStatus() != null) {
            if (this.constraintVector != null) {
                for (int i = 0; i < this.constraintVector.size(); ++i) {
                    ConstraintClause constraintClause = (ConstraintClause)this.constraintVector.get(i);
                    constraintClause.setObjectContext(this.context);
                    sb.append(constraintClause.toString());
                }
            }
            if (this.getNullStatus() != null) {
                sb.append(this.nullStatus.toUpperCase() + " ");
            }
        }
        if (this.autoIncrement != null) {
            sb.append(" " + this.autoIncrement.toUpperCase() + " ");
        }
        if (this.getNullStatus() != null && !this.getNullStatus().trim().toUpperCase().equals("NULL") && (str2 = sb.toString().trim()).toUpperCase().indexOf("NOT NULL") == -1) {
            sb.append(this.nullStatus.toUpperCase() + " ");
        }
        if (this.datapageStorageLevel != null) {
            sb.append(this.datapageStorageLevel.toUpperCase() + " ROW");
        }
        return sb.toString();
    }

    public static void addToUserDefinedDataTypes(String type, String basetype) {
        if (type != null && basetype != null) {
            userdefinedDatatypes.put(type, basetype);
            userConfiguredDatatypes.put(type, basetype);
        }
    }

    public static Hashtable getUserDefinedDatatypes() {
        return userdefinedDatatypes;
    }

    public static boolean isTypePresent(String type) {
        return userConfiguredDatatypes.containsKey(type);
    }

    public static void readUserDefinedDatatypes() {
        try {
            FileInputStream fis = new FileInputStream("conf/SQLServerUDDBaseTypeEquivalents.conf");
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            String functionString = new String();
            functionString = br.readLine();
            while (functionString != null) {
                String oracleBaseDatatype;
                String udd;
                StringTokenizer st;
                if (functionString.trim().equals("")) {
                    functionString = br.readLine();
                    continue;
                }
                int index = functionString.trim().indexOf("/*");
                if (index != -1) {
                    if (index > 0 && (st = new StringTokenizer(functionString = functionString.substring(0, functionString.indexOf("/*")), "=")).countTokens() == 2) {
                        udd = st.nextToken().trim().toLowerCase();
                        oracleBaseDatatype = st.nextToken().trim();
                        userdefinedDatatypes.put(udd, oracleBaseDatatype);
                    }
                    while (functionString != null && functionString.indexOf("*/") == -1) {
                        functionString = br.readLine();
                    }
                    continue;
                }
                if (functionString.trim().indexOf("--") != -1) {
                    functionString = functionString.substring(0, functionString.indexOf("--"));
                }
                if ((st = new StringTokenizer(functionString, "=")).countTokens() == 2) {
                    udd = st.nextToken().trim().toLowerCase();
                    oracleBaseDatatype = st.nextToken().trim();
                    userdefinedDatatypes.put(udd, oracleBaseDatatype);
                }
                functionString = br.readLine();
            }
            br.close();
            isr.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void enumValuesConvertedToCheckConstraints(Datatype datatype, Vector constraintNullVector) {
        ArrayList enumValues = ((CharacterClass)datatype).getEnumValues();
        if (enumValues != null && !enumValues.isEmpty()) {
            WhereExpression checkWE = new WhereExpression();
            WhereColumn lwc = new WhereColumn();
            Vector<String> lwcV = new Vector<String>();
            lwcV.add(this.columnName);
            lwc.setColumnExpression(lwcV);
            for (int i = 0; i < enumValues.size(); ++i) {
                WhereItem wi = new WhereItem();
                wi.setLeftWhereExp(lwc);
                WhereColumn rwc = new WhereColumn();
                Vector rwcV = new Vector();
                rwcV.add(enumValues.get(i));
                rwc.setColumnExpression(rwcV);
                wi.setRightWhereExp(rwc);
                wi.setOperator("=");
                checkWE.addWhereItem(wi);
                if (i == enumValues.size() - 1) continue;
                checkWE.addOperator("OR");
            }
            Vector constrClaV = this.getConstraintClause();
            boolean isCheckConstrExists = false;
            if (constrClaV != null) {
                for (int i = 0; i < constrClaV.size(); ++i) {
                    ConstraintClause constrCla = (ConstraintClause)constrClaV.get(i);
                    ConstraintType constrType = constrCla.getConstraintType();
                    if (constrType == null || !(constrType instanceof CheckConstraintClause)) continue;
                    isCheckConstrExists = true;
                    CheckConstraintClause checkConstr = (CheckConstraintClause)constrType;
                    WhereExpression we = checkConstr.getWhereExpression();
                    if (we == null) continue;
                    we.addOperator("OR");
                    we.addWhereExpression(checkWE);
                }
            }
            if (!isCheckConstrExists) {
                ConstraintClause constrCla = new ConstraintClause();
                CheckConstraintClause chConstrClause = new CheckConstraintClause();
                chConstrClause.setOpenBrace("(");
                chConstrClause.setClosedBrace(")");
                chConstrClause.setWhereExpression(checkWE);
                chConstrClause.setConstraintName("CHECK");
                constrCla.setConstraintType(chConstrClause);
                constraintNullVector.addElement(constrCla);
            }
        }
        ((CharacterClass)datatype).setEnumValues(null);
    }

    public static void readUserConfiguredDatatypes() {
        try {
            FileInputStream fis = new FileInputStream("conf/MSSQLServerToOracleDatatype.conf");
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            String functionString = new String();
            functionString = br.readLine();
            while (functionString != null) {
                String oracleBaseDatatype;
                String udd;
                StringTokenizer st;
                if (functionString.trim().equals("")) {
                    functionString = br.readLine();
                    continue;
                }
                int index = functionString.trim().indexOf("/*");
                if (index != -1) {
                    if (index > 0 && (st = new StringTokenizer(functionString = functionString.substring(0, functionString.indexOf("/*")), "=")).countTokens() == 2) {
                        udd = st.nextToken().trim().toLowerCase();
                        oracleBaseDatatype = st.nextToken().trim();
                        userConfiguredDatatypes.put(udd.toLowerCase(), oracleBaseDatatype);
                    }
                    while (functionString != null && functionString.indexOf("*/") == -1) {
                        functionString = br.readLine();
                    }
                    continue;
                }
                if (functionString.trim().indexOf("--") != -1) {
                    functionString = functionString.substring(0, functionString.indexOf("--"));
                }
                if ((st = new StringTokenizer(functionString, "=")).countTokens() == 2) {
                    udd = st.nextToken().trim().toLowerCase();
                    oracleBaseDatatype = st.nextToken().trim();
                    userConfiguredDatatypes.put(udd.toLowerCase(), oracleBaseDatatype);
                }
                functionString = br.readLine();
            }
            br.close();
            isr.close();
            fis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createCastFunction() throws ConvertException {
        SelectColumn firstArgInCastFunction = new SelectColumn();
        SelectColumn secondArgInCastFunction = new SelectColumn();
        Vector<SelectColumn> functionArguments = new Vector<SelectColumn>();
        TableColumn tc = new TableColumn();
        FunctionCalls fc = new FunctionCalls();
        Vector<Object> vec_firstarg = new Vector<Object>();
        Vector vec_secondarg = new Vector();
        tc.setColumnName("CAST");
        fc.setFunctionName(tc);
        vec_firstarg.addElement(this.getDefaultValue());
        vec_firstarg.addElement(" AS ");
        vec_firstarg.addElement(this.getCastDatatype());
        firstArgInCastFunction.setColumnExpression(vec_firstarg);
        functionArguments.addElement(firstArgInCastFunction);
        fc.setFunctionArguments(functionArguments);
        this.setDefaultFunction(fc);
        this.setDefaultValue(null);
    }
}

