/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.create;

import com.adventnet.swissqlapi.config.SwisSQLOptions;
import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.statement.create.ConstraintType;
import com.adventnet.swissqlapi.sql.statement.update.TableObject;
import com.adventnet.swissqlapi.util.SwisSQLUtils;
import com.adventnet.swissqlapi.util.misc.CustomizeUtil;
import java.util.Vector;

public class ForeignConstraintClause
implements ConstraintType {
    private Vector constraintColumnNames;
    private String constraintName;
    private String openBrace;
    private String closedBrace;
    private String referenceOpenBrace;
    private String referenceClosedBrace;
    private String reference;
    private TableObject referenceTable;
    private Vector referenceTableColumnNames;
    private String matchLevel;
    private String onUpdate;
    private String onDelete;
    private String actionOnDelete;
    private String actionOnUpdate;
    private String columnName;
    private UserObjectContext context = null;
    private String tableNameFromCQS;

    public void setObjectContext(UserObjectContext context) {
        this.context = context;
    }

    public void setConstraintColumnNames(Vector constraintColumnNames) {
        this.constraintColumnNames = constraintColumnNames;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public void setTableName(TableObject referenceTable) {
        this.referenceTable = referenceTable;
    }

    public void setReferenceTableColumnNames(Vector referenceTableColumnNames) {
        this.referenceTableColumnNames = referenceTableColumnNames;
    }

    public void setMatch(String matchLevel) {
        this.matchLevel = matchLevel;
    }

    public void setOnUpdate(String onUpdate) {
        this.onUpdate = onUpdate;
    }

    public void setOnDelete(String onDelete) {
        this.onDelete = onDelete;
    }

    public void setActionOnUpdate(String actionOnUpdate) {
        this.actionOnUpdate = actionOnUpdate;
    }

    public void setActionOnDelete(String actionOnDelete) {
        this.actionOnDelete = actionOnDelete;
    }

    public void setOpenBrace(String openBrace) {
        this.openBrace = openBrace;
    }

    public void setClosedBrace(String closedBrace) {
        this.closedBrace = closedBrace;
    }

    public void setReferenceOpenBrace(String referenceOpenBrace) {
        this.referenceOpenBrace = referenceOpenBrace;
    }

    public void setReferenceClosedBrace(String referenceClosedBrace) {
        this.referenceClosedBrace = referenceClosedBrace;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setTableNameFromCQS(String tableNameFromCQS) {
        this.tableNameFromCQS = tableNameFromCQS;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Vector getConstraintColumnNames() {
        return this.constraintColumnNames;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getReference() {
        return this.reference;
    }

    public TableObject getTableName() {
        return this.referenceTable;
    }

    public Vector getReferenceTableColumnNames() {
        return this.referenceTableColumnNames;
    }

    public String getMatch() {
        return this.matchLevel;
    }

    public String getOnUpdate() {
        return this.onUpdate;
    }

    public String getOnDelete() {
        return this.onDelete;
    }

    public String getActionOnUpdate() {
        return this.actionOnUpdate;
    }

    public String getActionOnDelete() {
        return this.actionOnDelete;
    }

    @Override
    public void toDB2String() throws ConvertException {
        String constraintColumn;
        int i;
        Vector<String> oracleColumnVector;
        this.setMatch(null);
        if (this.constraintColumnNames != null) {
            oracleColumnVector = new Vector<String>();
            for (i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
        if (this.referenceTable != null) {
            String ownerName = this.referenceTable.getOwner();
            String tableName = this.referenceTable.getTableName();
            String userName = this.referenceTable.getUser();
            if (ownerName != null && (ownerName.startsWith("[") && ownerName.endsWith("]") || ownerName.startsWith("`") && ownerName.endsWith("`")) && (ownerName = ownerName.substring(1, ownerName.length() - 1)).indexOf(32) != -1) {
                ownerName = "\"" + ownerName + "\"";
            }
            if (tableName != null && (tableName.startsWith("[") && tableName.endsWith("]") || tableName.startsWith("`") && tableName.endsWith("`")) && (tableName = tableName.substring(1, tableName.length() - 1)).indexOf(32) != -1) {
                tableName = "\"" + tableName + "\"";
            }
            if (userName != null && (userName.startsWith("[") && userName.endsWith("]") || userName.startsWith("`") && userName.endsWith("`")) && (userName = userName.substring(1, userName.length() - 1)).indexOf(32) != -1) {
                userName = "\"" + userName + "\"";
            }
            this.referenceTable.setOwner(ownerName);
            this.referenceTable.setTableName(tableName);
            this.referenceTable.setUser(userName);
            this.referenceTable.toDB2();
        }
        if (this.referenceTableColumnNames != null) {
            oracleColumnVector = new Vector();
            for (i = 0; i < this.referenceTableColumnNames.size(); ++i) {
                if (this.referenceTableColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.referenceTableColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
            }
            this.setReferenceTableColumnNames(oracleColumnVector);
        }
        if (this.getActionOnUpdate() != null && (this.getActionOnUpdate().equalsIgnoreCase("SET DEFAULT") || this.getActionOnUpdate().equalsIgnoreCase("SET NULL") || this.getActionOnUpdate().equalsIgnoreCase("CASCADE"))) {
            this.setActionOnUpdate(null);
            this.setOnUpdate(null);
        }
        if (this.getActionOnDelete() != null && this.getActionOnDelete().equalsIgnoreCase("SET DEFAULT")) {
            this.setActionOnDelete("SET NULL");
        }
        if (this.getColumnName() != null && this.getConstraintName() != null) {
            this.setConstraintName(null);
            this.setConstraintColumnNames(null);
        }
    }

    @Override
    public void toMSSQLServerString() throws ConvertException {
        String constraintColumn;
        int i;
        Vector<String> oracleColumnVector;
        if (this.constraintColumnNames != null) {
            oracleColumnVector = new Vector<String>();
            for (i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
        if (this.referenceTableColumnNames != null) {
            oracleColumnVector = new Vector();
            for (i = 0; i < this.referenceTableColumnNames.size(); ++i) {
                if (this.referenceTableColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.referenceTableColumnNames.get(i);
                    if (constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
            }
            this.setReferenceTableColumnNames(oracleColumnVector);
        }
        if (this.referenceTable != null) {
            String ownerName = this.referenceTable.getOwner();
            String tableName = this.referenceTable.getTableName();
            String userName = this.referenceTable.getUser();
            if (ownerName != null && ownerName.startsWith("`") && ownerName.endsWith("`") && (ownerName = ownerName.substring(1, ownerName.length() - 1)).indexOf(32) != -1) {
                ownerName = "\"" + ownerName + "\"";
            }
            if (tableName != null && tableName.startsWith("`") && tableName.endsWith("`") && (tableName = tableName.substring(1, tableName.length() - 1)).indexOf(32) != -1) {
                tableName = "\"" + tableName + "\"";
            }
            if (userName != null && userName.startsWith("`") && userName.endsWith("`") && (userName = userName.substring(1, userName.length() - 1)).indexOf(32) != -1) {
                userName = "\"" + userName + "\"";
            }
            this.referenceTable.setOwner(ownerName);
            this.referenceTable.setTableName(tableName);
            this.referenceTable.setUser(userName);
        }
        if (this.getActionOnUpdate() != null) {
            if (this.getActionOnUpdate().equalsIgnoreCase("SET DEFAULT") || this.getActionOnUpdate().equalsIgnoreCase("SET NULL")) {
                this.setOnUpdate(null);
                this.setActionOnUpdate(null);
            } else if (this.getActionOnUpdate().equalsIgnoreCase("RESTRICT")) {
                this.setActionOnUpdate("NO ACTION");
            }
        }
        if (this.getActionOnDelete() != null) {
            if (SwisSQLOptions.sqlServerTriggers && (this.getActionOnDelete().equalsIgnoreCase("SET DEFAULT") || this.getActionOnDelete().equalsIgnoreCase("SET NULL"))) {
                this.setOnDelete(null);
                this.setActionOnDelete(null);
            } else if (this.getActionOnDelete().equalsIgnoreCase("RESTRICT")) {
                this.setActionOnDelete("NO ACTION");
            }
        }
    }

    @Override
    public void toSybaseString() throws ConvertException {
        String constraintColumn;
        int i;
        Vector<String> oracleColumnVector;
        if (this.constraintColumnNames != null) {
            oracleColumnVector = new Vector<String>();
            for (i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
        if (this.referenceTableColumnNames != null) {
            oracleColumnVector = new Vector();
            for (i = 0; i < this.referenceTableColumnNames.size(); ++i) {
                if (this.referenceTableColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.referenceTableColumnNames.get(i);
                    if (constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
            }
            this.setReferenceTableColumnNames(oracleColumnVector);
        }
        if (this.referenceTable != null) {
            String ownerName = this.referenceTable.getOwner();
            String tableName = this.referenceTable.getTableName();
            String userName = this.referenceTable.getUser();
            if (ownerName != null && (ownerName.startsWith("[") && ownerName.endsWith("]") || ownerName.startsWith("`") && ownerName.endsWith("`")) && (ownerName = ownerName.substring(1, ownerName.length() - 1)).indexOf(32) != -1) {
                ownerName = "\"" + ownerName + "\"";
            }
            if (tableName != null && (tableName.startsWith("[") && tableName.endsWith("]") || tableName.startsWith("`") && tableName.endsWith("`")) && (tableName = tableName.substring(1, tableName.length() - 1)).indexOf(32) != -1) {
                tableName = "\"" + tableName + "\"";
            }
            if (userName != null && (userName.startsWith("[") && userName.endsWith("]") || userName.startsWith("`") && userName.endsWith("`")) && (userName = userName.substring(1, userName.length() - 1)).indexOf(32) != -1) {
                userName = "\"" + userName + "\"";
            }
            this.referenceTable.setOwner(ownerName);
            this.referenceTable.setTableName(tableName);
            this.referenceTable.setUser(userName);
        }
        if (this.getActionOnUpdate() != null) {
            if (this.getActionOnUpdate().equalsIgnoreCase("SET DEFAULT") || this.getActionOnUpdate().equalsIgnoreCase("SET NULL")) {
                this.setOnUpdate(null);
                this.setActionOnUpdate(null);
            } else if (this.getActionOnUpdate().equalsIgnoreCase("RESTRICT")) {
                this.setActionOnUpdate("NO ACTION");
            }
            this.setOnUpdate(null);
            this.setActionOnUpdate(null);
        }
        if (this.getActionOnDelete() != null) {
            if (this.getActionOnDelete().equalsIgnoreCase("SET DEFAULT") || this.getActionOnDelete().equalsIgnoreCase("SET NULL")) {
                this.setOnDelete(null);
                this.setActionOnDelete(null);
            } else if (this.getActionOnDelete().equalsIgnoreCase("RESTRICT")) {
                this.setActionOnDelete("NO ACTION");
            }
            this.setOnDelete(null);
            this.setActionOnDelete(null);
        }
    }

    @Override
    public void toOracleString() throws ConvertException {
        boolean addQuotes;
        String constraintColumn;
        int i;
        Vector<String> oracleColumnVector;
        this.setMatch(null);
        if (this.getActionOnUpdate() != null) {
            this.setOnUpdate(null);
            this.setActionOnUpdate(null);
        }
        if (this.getActionOnDelete() != null) {
            if (this.getActionOnDelete().equalsIgnoreCase("SET DEFAULT")) {
                this.setActionOnDelete("SET NULL");
            } else if (this.getActionOnDelete().equalsIgnoreCase("RESTRICT") || this.getActionOnDelete().equalsIgnoreCase("NO ACTION")) {
                this.setOnDelete(null);
                this.setActionOnDelete(null);
            }
        }
        if (this.getColumnName() != null && this.getConstraintName() != null) {
            this.setConstraintName(null);
            this.setConstraintColumnNames(null);
            this.setOpenBrace(null);
            this.setClosedBrace(null);
        }
        if (this.constraintColumnNames != null) {
            oracleColumnVector = new Vector<String>();
            for (i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.constraintColumnNames.get(i);
                    if ((constraintColumn = CustomizeUtil.objectNamesToQuotedIdentifier(constraintColumn, SwisSQLUtils.getKeywords(1), null, 1)).startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1);
                        if (SwisSQLOptions.retainQuotedIdentifierForOracle || constraintColumn.indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                    } else {
                        oracleColumnVector.add(constraintColumn);
                    }
                    if (this.tableNameFromCQS != null) continue;
                    addQuotes = false;
                    if (constraintColumn.startsWith("\"") && constraintColumn.endsWith("\"")) {
                        constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1);
                        addQuotes = true;
                    }
                    if (constraintColumn.length() <= 30) continue;
                    constraintColumn = constraintColumn.substring(0, 30);
                    if (addQuotes) {
                        constraintColumn = "\"" + constraintColumn + "\"";
                    }
                    oracleColumnVector.setElementAt(constraintColumn, oracleColumnVector.size() - 1);
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
        if (this.referenceTableColumnNames != null) {
            oracleColumnVector = new Vector();
            for (i = 0; i < this.referenceTableColumnNames.size(); ++i) {
                if (this.referenceTableColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.referenceTableColumnNames.get(i);
                    if ((constraintColumn = CustomizeUtil.objectNamesToQuotedIdentifier(constraintColumn, SwisSQLUtils.getKeywords(1), null, 1)).startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1);
                        if (SwisSQLOptions.retainQuotedIdentifierForOracle || constraintColumn.indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                    } else {
                        oracleColumnVector.add(constraintColumn);
                    }
                    addQuotes = false;
                    if (constraintColumn.startsWith("\"") && constraintColumn.endsWith("\"")) {
                        constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1);
                        addQuotes = true;
                    }
                    if (constraintColumn.length() <= 30) continue;
                    constraintColumn = constraintColumn.substring(0, 30);
                    if (addQuotes) {
                        constraintColumn = "\"" + constraintColumn + "\"";
                    }
                    oracleColumnVector.setElementAt(constraintColumn, oracleColumnVector.size() - 1);
                    continue;
                }
                oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
            }
            this.setReferenceTableColumnNames(oracleColumnVector);
        }
        if (this.referenceTable != null) {
            String ownerName = this.referenceTable.getOwner();
            String tableName = this.referenceTable.getTableName();
            String userName = this.referenceTable.getUser();
            if (ownerName != null && (ownerName.startsWith("[") && ownerName.endsWith("]") || ownerName.startsWith("`") && ownerName.endsWith("`"))) {
                ownerName = ownerName.substring(1, ownerName.length() - 1);
                if (SwisSQLOptions.retainQuotedIdentifierForOracle || ownerName.indexOf(32) != -1) {
                    ownerName = "\"" + ownerName + "\"";
                }
            }
            if (tableName != null && (tableName.startsWith("[") && tableName.endsWith("]") || tableName.startsWith("`") && tableName.endsWith("`"))) {
                tableName = tableName.substring(1, tableName.length() - 1);
                if (SwisSQLOptions.retainQuotedIdentifierForOracle || tableName.indexOf(32) != -1) {
                    tableName = "\"" + tableName + "\"";
                }
            }
            tableName = CustomizeUtil.objectNamesToQuotedIdentifier(tableName, SwisSQLUtils.getKeywords(1), null, 1);
            if (userName != null && (userName.startsWith("[") && userName.endsWith("]") || userName.startsWith("`") && userName.endsWith("`"))) {
                userName = userName.substring(1, userName.length() - 1);
                if (SwisSQLOptions.retainQuotedIdentifierForOracle || userName.indexOf(32) != -1) {
                    userName = "\"" + userName + "\"";
                }
            }
            this.referenceTable.setOwner(ownerName);
            this.referenceTable.setTableName(tableName);
            this.referenceTable.setUser(userName);
        }
    }

    @Override
    public void toPostgreSQLString() throws ConvertException {
        String constraintColumn;
        int i;
        Vector<String> oracleColumnVector;
        this.setMatch(null);
        if (this.constraintColumnNames != null) {
            oracleColumnVector = new Vector<String>();
            for (i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
        if (this.referenceTableColumnNames != null) {
            oracleColumnVector = new Vector();
            for (i = 0; i < this.referenceTableColumnNames.size(); ++i) {
                if (this.referenceTableColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.referenceTableColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
            }
            this.setReferenceTableColumnNames(oracleColumnVector);
        }
        if (this.referenceTable != null) {
            String ownerName = this.referenceTable.getOwner();
            String tableName = this.referenceTable.getTableName();
            String userName = this.referenceTable.getUser();
            if (ownerName != null && (ownerName.startsWith("[") && ownerName.endsWith("]") || ownerName.startsWith("`") && ownerName.endsWith("`")) && (ownerName = ownerName.substring(1, ownerName.length() - 1)).indexOf(32) != -1) {
                ownerName = "\"" + ownerName + "\"";
            }
            if (tableName != null && (tableName.startsWith("[") && tableName.endsWith("]") || tableName.startsWith("`") && tableName.endsWith("`")) && (tableName = tableName.substring(1, tableName.length() - 1)).indexOf(32) != -1) {
                tableName = "\"" + tableName + "\"";
            }
            if (userName != null && (userName.startsWith("[") && userName.endsWith("]") || userName.startsWith("`") && userName.endsWith("`")) && (userName = userName.substring(1, userName.length() - 1)).indexOf(32) != -1) {
                userName = "\"" + userName + "\"";
            }
            this.referenceTable.setOwner(ownerName);
            this.referenceTable.setTableName(tableName);
            this.referenceTable.setUser(userName);
        }
        if (this.getColumnName() != null && this.getConstraintName() != null) {
            this.setConstraintName(null);
            this.setConstraintColumnNames(null);
            this.setOpenBrace(null);
            this.setClosedBrace(null);
        }
    }

    @Override
    public void toANSIString() throws ConvertException {
        String constraintColumn;
        int i;
        Vector<String> oracleColumnVector;
        this.setMatch(null);
        if (this.constraintColumnNames != null) {
            oracleColumnVector = new Vector<String>();
            for (i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
        if (this.referenceTableColumnNames != null) {
            oracleColumnVector = new Vector();
            for (i = 0; i < this.referenceTableColumnNames.size(); ++i) {
                if (this.referenceTableColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.referenceTableColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
            }
            this.setReferenceTableColumnNames(oracleColumnVector);
        }
        if (this.referenceTable != null) {
            String ownerName = this.referenceTable.getOwner();
            String tableName = this.referenceTable.getTableName();
            String userName = this.referenceTable.getUser();
            if (ownerName != null && (ownerName.startsWith("[") && ownerName.endsWith("]") || ownerName.startsWith("`") && ownerName.endsWith("`")) && (ownerName = ownerName.substring(1, ownerName.length() - 1)).indexOf(32) != -1) {
                ownerName = "\"" + ownerName + "\"";
            }
            if (tableName != null && (tableName.startsWith("[") && tableName.endsWith("]") || tableName.startsWith("`") && tableName.endsWith("`")) && (tableName = tableName.substring(1, tableName.length() - 1)).indexOf(32) != -1) {
                tableName = "\"" + tableName + "\"";
            }
            if (userName != null && (userName.startsWith("[") && userName.endsWith("]") || userName.startsWith("`") && userName.endsWith("`")) && (userName = userName.substring(1, userName.length() - 1)).indexOf(32) != -1) {
                userName = "\"" + userName + "\"";
            }
            this.referenceTable.setOwner(ownerName);
            this.referenceTable.setTableName(tableName);
            this.referenceTable.setUser(userName);
        }
        if (this.getColumnName() != null && this.getConstraintName() != null) {
            this.setConstraintName(null);
            this.setConstraintColumnNames(null);
            this.setOpenBrace(null);
            this.setClosedBrace(null);
        }
    }

    @Override
    public void toMySQLString() throws ConvertException {
        String constraintColumn;
        int i;
        Vector<String> oracleColumnVector;
        if (this.constraintColumnNames != null) {
            oracleColumnVector = new Vector<String>();
            for (i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "`" + constraintColumn + "`";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
        if (this.referenceTableColumnNames != null) {
            oracleColumnVector = new Vector();
            for (i = 0; i < this.referenceTableColumnNames.size(); ++i) {
                if (this.referenceTableColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.referenceTableColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "`" + constraintColumn + "`";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
            }
            this.setReferenceTableColumnNames(oracleColumnVector);
        }
        if (this.referenceTable != null) {
            String ownerName = this.referenceTable.getOwner();
            String tableName = this.referenceTable.getTableName();
            String userName = this.referenceTable.getUser();
            if (ownerName != null && ownerName.startsWith("[") && ownerName.endsWith("]") && (ownerName = ownerName.substring(1, ownerName.length() - 1)).indexOf(32) != -1) {
                ownerName = "`" + ownerName + "`";
            }
            if (tableName != null && tableName.startsWith("[") && tableName.endsWith("]") && (tableName = tableName.substring(1, tableName.length() - 1)).indexOf(32) != -1) {
                tableName = "`" + tableName + "`";
            }
            if (userName != null && userName.startsWith("[") && userName.endsWith("]") && (userName = userName.substring(1, userName.length() - 1)).indexOf(32) != -1) {
                userName = "`" + userName + "`";
            }
            this.referenceTable.setOwner(ownerName);
            this.referenceTable.setTableName(tableName);
            this.referenceTable.setUser(userName);
        }
        this.setMatch(null);
        if (this.getColumnName() != null && this.getConstraintName() != null) {
            this.setConstraintName(null);
            this.setConstraintColumnNames(null);
            this.setOpenBrace(null);
            this.setClosedBrace(null);
        }
    }

    @Override
    public void toInformixString() throws ConvertException {
        String constraintColumn;
        int i;
        Vector<String> oracleColumnVector;
        if (this.constraintColumnNames != null) {
            oracleColumnVector = new Vector<String>();
            for (i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
        if (this.referenceTableColumnNames != null) {
            oracleColumnVector = new Vector();
            for (i = 0; i < this.referenceTableColumnNames.size(); ++i) {
                if (this.referenceTableColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.referenceTableColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
            }
            this.setReferenceTableColumnNames(oracleColumnVector);
        }
        if (this.referenceTable != null) {
            String ownerName = this.referenceTable.getOwner();
            String tableName = this.referenceTable.getTableName();
            String userName = this.referenceTable.getUser();
            if (ownerName != null && (ownerName.startsWith("[") && ownerName.endsWith("]") || ownerName.startsWith("`") && ownerName.endsWith("`")) && (ownerName = ownerName.substring(1, ownerName.length() - 1)).indexOf(32) != -1) {
                ownerName = "\"" + ownerName + "\"";
            }
            if (tableName != null && (tableName.startsWith("[") && tableName.endsWith("]") || tableName.startsWith("`") && tableName.endsWith("`")) && (tableName = tableName.substring(1, tableName.length() - 1)).indexOf(32) != -1) {
                tableName = "\"" + tableName + "\"";
            }
            if (userName != null && (userName.startsWith("[") && userName.endsWith("]") || userName.startsWith("`") && userName.endsWith("`")) && (userName = userName.substring(1, userName.length() - 1)).indexOf(32) != -1) {
                userName = "\"" + userName + "\"";
            }
            this.referenceTable.setOwner(ownerName);
            this.referenceTable.setTableName(tableName);
            this.referenceTable.setUser(userName);
        }
        this.setMatch(null);
        if (this.getActionOnUpdate() != null) {
            this.setOnUpdate(null);
            this.setActionOnUpdate(null);
        }
        if (this.getActionOnDelete() != null && (this.getActionOnDelete().equalsIgnoreCase("SET DEFAULT") || this.getActionOnDelete().equalsIgnoreCase("RESTRICT") || this.getActionOnDelete().equalsIgnoreCase("NO ACTION") || this.getActionOnDelete().equalsIgnoreCase("SET NULL"))) {
            this.setOnDelete(null);
            this.setActionOnDelete(null);
        }
        if (this.getColumnName() != null && this.getConstraintName() != null) {
            this.setConstraintName(null);
            this.setConstraintColumnNames(null);
            this.setOpenBrace(null);
            this.setClosedBrace(null);
        }
    }

    @Override
    public void toTimesTenString() throws ConvertException {
        String constraintColumn;
        int i;
        Vector<String> columnVector;
        if (this.constraintColumnNames != null) {
            columnVector = new Vector<String>();
            for (i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.constraintColumnNames.get(i);
                    if ((constraintColumn = CustomizeUtil.objectNamesToQuotedIdentifier(constraintColumn, SwisSQLUtils.getKeywords(10), null, 10)).startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        columnVector.add(constraintColumn);
                        continue;
                    }
                    columnVector.add(constraintColumn);
                    continue;
                }
                columnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(columnVector);
        }
        if (this.referenceTableColumnNames != null) {
            columnVector = new Vector();
            for (i = 0; i < this.referenceTableColumnNames.size(); ++i) {
                if (this.referenceTableColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.referenceTableColumnNames.get(i);
                    if ((constraintColumn = CustomizeUtil.objectNamesToQuotedIdentifier(constraintColumn, SwisSQLUtils.getKeywords(10), null, 10)).startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        columnVector.add(constraintColumn);
                        continue;
                    }
                    columnVector.add(constraintColumn);
                    continue;
                }
                columnVector.add((String)this.referenceTableColumnNames.get(i));
            }
            this.setReferenceTableColumnNames(columnVector);
        }
        if (this.referenceTable != null) {
            String ownerName = this.referenceTable.getOwner();
            String tableName = this.referenceTable.getTableName();
            String userName = this.referenceTable.getUser();
            if (ownerName != null && (ownerName.startsWith("[") && ownerName.endsWith("]") || ownerName.startsWith("`") && ownerName.endsWith("`")) && (ownerName = ownerName.substring(1, ownerName.length() - 1)).indexOf(32) != -1) {
                ownerName = "\"" + ownerName + "\"";
            }
            if (tableName != null && (tableName.startsWith("[") && tableName.endsWith("]") || tableName.startsWith("`") && tableName.endsWith("`")) && (tableName = tableName.substring(1, tableName.length() - 1)).indexOf(32) != -1) {
                tableName = "\"" + tableName + "\"";
            }
            tableName = CustomizeUtil.objectNamesToQuotedIdentifier(tableName, SwisSQLUtils.getKeywords(10), null, 10);
            if (userName != null) {
                userName = null;
            }
            this.referenceTable.setOwner(ownerName);
            this.referenceTable.setTableName(tableName);
            this.referenceTable.setUser(userName);
        }
        if (this.getActionOnUpdate() != null) {
            this.setOnUpdate(null);
            this.setActionOnUpdate(null);
        }
        if (this.getActionOnDelete() != null) {
            this.setOnDelete(null);
            this.setActionOnDelete(null);
        }
        this.setMatch(null);
    }

    @Override
    public void toNetezzaString() throws ConvertException {
        String constraintColumn;
        int i;
        Vector<String> oracleColumnVector;
        this.setMatch(null);
        if (this.constraintColumnNames != null) {
            oracleColumnVector = new Vector<String>();
            for (i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
        if (this.referenceTableColumnNames != null) {
            oracleColumnVector = new Vector();
            for (i = 0; i < this.referenceTableColumnNames.size(); ++i) {
                if (this.referenceTableColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.referenceTableColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
            }
            this.setReferenceTableColumnNames(oracleColumnVector);
        }
        if (this.referenceTable != null) {
            String ownerName = this.referenceTable.getOwner();
            String tableName = this.referenceTable.getTableName();
            String userName = this.referenceTable.getUser();
            if (ownerName != null && (ownerName.startsWith("[") && ownerName.endsWith("]") || ownerName.startsWith("`") && ownerName.endsWith("`")) && (ownerName = ownerName.substring(1, ownerName.length() - 1)).indexOf(32) != -1) {
                ownerName = "\"" + ownerName + "\"";
            }
            if (tableName != null && (tableName.startsWith("[") && tableName.endsWith("]") || tableName.startsWith("`") && tableName.endsWith("`")) && (tableName = tableName.substring(1, tableName.length() - 1)).indexOf(32) != -1) {
                tableName = "\"" + tableName + "\"";
            }
            if (userName != null && (userName.startsWith("[") && userName.endsWith("]") || userName.startsWith("`") && userName.endsWith("`")) && (userName = userName.substring(1, userName.length() - 1)).indexOf(32) != -1) {
                userName = "\"" + userName + "\"";
            }
            this.referenceTable.setOwner(ownerName);
            this.referenceTable.setTableName(tableName);
            this.referenceTable.setUser(userName);
        }
        if (this.getColumnName() != null && this.getConstraintName() != null) {
            this.setConstraintName(null);
            this.setConstraintColumnNames(null);
            this.setOpenBrace(null);
            this.setClosedBrace(null);
        }
    }

    @Override
    public void toTeradataString() throws ConvertException {
        String constraintColumn;
        int i;
        Vector<String> oracleColumnVector;
        this.setMatch(null);
        if (this.constraintColumnNames != null) {
            oracleColumnVector = new Vector<String>();
            for (i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
        if (this.referenceTableColumnNames != null) {
            oracleColumnVector = new Vector();
            for (i = 0; i < this.referenceTableColumnNames.size(); ++i) {
                if (this.referenceTableColumnNames.elementAt(i) instanceof String) {
                    constraintColumn = (String)this.referenceTableColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.referenceTableColumnNames.get(i));
            }
            this.setReferenceTableColumnNames(oracleColumnVector);
        }
        if (this.referenceTable != null) {
            String ownerName = this.referenceTable.getOwner();
            String tableName = this.referenceTable.getTableName();
            String userName = this.referenceTable.getUser();
            if (ownerName != null && (ownerName.startsWith("[") && ownerName.endsWith("]") || ownerName.startsWith("`") && ownerName.endsWith("`")) && (ownerName = ownerName.substring(1, ownerName.length() - 1)).indexOf(32) != -1) {
                ownerName = "\"" + ownerName + "\"";
            }
            if (tableName != null && (tableName.startsWith("[") && tableName.endsWith("]") || tableName.startsWith("`") && tableName.endsWith("`")) && (tableName = tableName.substring(1, tableName.length() - 1)).indexOf(32) != -1) {
                tableName = "\"" + tableName + "\"";
            }
            if (userName != null && (userName.startsWith("[") && userName.endsWith("]") || userName.startsWith("`") && userName.endsWith("`")) && (userName = userName.substring(1, userName.length() - 1)).indexOf(32) != -1) {
                userName = "\"" + userName + "\"";
            }
            this.referenceTable.setOwner(ownerName);
            this.referenceTable.setTableName(tableName);
            this.referenceTable.setUser(userName);
        }
        if (this.getColumnName() != null && this.getConstraintName() != null) {
            this.setConstraintName(null);
            this.setConstraintColumnNames(null);
            this.setOpenBrace(null);
            this.setClosedBrace(null);
        }
    }

    public String toString() {
        String temp;
        String col;
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.constraintName != null) {
            sb.append(this.constraintName.toUpperCase() + " ");
        }
        if (this.openBrace != null) {
            sb.append(this.openBrace);
        }
        if (this.constraintColumnNames != null) {
            for (i = 0; i < this.constraintColumnNames.size(); ++i) {
                col = this.constraintColumnNames.get(i).toString();
                if (i == 0) {
                    if (this.context != null) {
                        temp = this.context.getEquivalent(col).toString();
                        sb.append(temp);
                        continue;
                    }
                    sb.append(col);
                    continue;
                }
                if (this.context != null) {
                    temp = this.context.getEquivalent(col).toString();
                    sb.append(", " + temp);
                    continue;
                }
                sb.append(", " + col);
            }
        }
        if (this.closedBrace != null) {
            sb.append(this.closedBrace + " ");
        }
        if (this.reference != null) {
            sb.append(this.reference.toUpperCase() + " ");
        }
        if (this.referenceTable != null) {
            if (this.context != null) {
                this.referenceTable.setObjectContext(this.context);
            }
            sb.append(this.referenceTable.toString() + " ");
        }
        if (this.referenceOpenBrace != null) {
            sb.append(this.referenceOpenBrace);
        }
        if (this.referenceTableColumnNames != null) {
            for (i = 0; i < this.referenceTableColumnNames.size(); ++i) {
                String sss;
                String s;
                if (!(this.referenceTableColumnNames.get(i) instanceof String)) continue;
                col = this.referenceTableColumnNames.get(i).toString();
                if (this.referenceTable != null && this.context != null && !(s = this.referenceTable.getTableName() + "." + col).equals(sss = this.context.getEquivalent(s).toString())) {
                    col = sss;
                }
                if (i == 0) {
                    if (this.context != null) {
                        temp = this.context.getEquivalent(col).toString();
                        sb.append(temp);
                        continue;
                    }
                    sb.append(col);
                    continue;
                }
                if (this.context != null) {
                    temp = this.context.getEquivalent(col).toString();
                    sb.append(", " + temp);
                    continue;
                }
                sb.append(", " + col);
            }
        }
        if (this.referenceClosedBrace != null) {
            sb.append(this.referenceClosedBrace + " ");
        }
        if (this.matchLevel != null) {
            sb.append(this.matchLevel + " ");
        }
        if (this.onUpdate != null) {
            sb.append(this.onUpdate + " ");
        }
        if (this.actionOnUpdate != null) {
            sb.append(this.actionOnUpdate + " ");
        }
        if (this.onDelete != null) {
            sb.append(this.onDelete + " ");
        }
        if (this.actionOnDelete != null) {
            sb.append(this.actionOnDelete + " ");
        }
        return sb.toString();
    }

    public ConstraintType copyObjectValues() {
        ForeignConstraintClause dupForeignConstraintClause = new ForeignConstraintClause();
        dupForeignConstraintClause.setClosedBrace(this.closedBrace);
        dupForeignConstraintClause.setConstraintColumnNames(this.getConstraintColumnNames());
        dupForeignConstraintClause.setConstraintName(this.getConstraintName());
        dupForeignConstraintClause.setOpenBrace(this.openBrace);
        dupForeignConstraintClause.setActionOnUpdate(this.getActionOnUpdate());
        dupForeignConstraintClause.setActionOnDelete(this.getActionOnDelete());
        dupForeignConstraintClause.setMatch(this.getMatch());
        dupForeignConstraintClause.setOnUpdate(this.getOnUpdate());
        dupForeignConstraintClause.setOnDelete(this.getOnDelete());
        dupForeignConstraintClause.setReference(this.getReference());
        dupForeignConstraintClause.setReferenceClosedBrace(this.referenceClosedBrace);
        dupForeignConstraintClause.setReferenceOpenBrace(this.referenceOpenBrace);
        dupForeignConstraintClause.setReferenceTableColumnNames(this.getReferenceTableColumnNames());
        dupForeignConstraintClause.setTableName(this.getTableName());
        dupForeignConstraintClause.setObjectContext(this.context);
        return dupForeignConstraintClause;
    }
}

