/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.create;

import com.adventnet.swissqlapi.config.SwisSQLOptions;
import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.statement.create.ConstraintType;
import com.adventnet.swissqlapi.util.SwisSQLUtils;
import com.adventnet.swissqlapi.util.misc.CustomizeUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class PrimaryOrUniqueConstraintClause
implements ConstraintType {
    private Vector constraintColumnNames;
    private String constraintName;
    private String clusteredStatus;
    private String with;
    private HashMap diskAttr;
    private String openBrace;
    private String closedBrace;
    private String columnName;
    private String usingIndex;
    private String onString;
    private String onIndexOrIdentifier;
    private UserObjectContext context = null;
    private HashMap constrColSortClause;
    private String sortClause;
    private String tableNameFromCQS;
    private Map columnNameVsSize = new HashMap();

    public void addToColumnNameVsSize(String columnName, String size) {
        if (columnName.startsWith("`")) {
            columnName = columnName.substring(1, columnName.length() - 1);
        }
        this.columnNameVsSize.put(columnName, size);
    }

    public void setObjectContext(UserObjectContext context) {
        this.context = context;
    }

    public void setConstraintColumnNames(Vector constraintColumnNames) {
        this.constraintColumnNames = constraintColumnNames;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public void setClustered(String clusteredStatus) {
        this.clusteredStatus = clusteredStatus;
    }

    public void setWith(String with) {
        this.with = with;
    }

    public void setDiskAttr(HashMap diskAttr) {
        this.diskAttr = diskAttr;
    }

    public void setUsingIndex(String usingIndex) {
        this.usingIndex = usingIndex;
    }

    public void setOpenBrace(String openBrace) {
        this.openBrace = openBrace;
    }

    public void setClosedBrace(String closedBrace) {
        this.closedBrace = closedBrace;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setOnString(String onString) {
        this.onString = onString;
    }

    public void setOnIndexOrIdentifier(String onIndexOrIdentifier) {
        this.onIndexOrIdentifier = onIndexOrIdentifier;
    }

    public void setConstrColumnSortClauseMap(HashMap constrColSortClause) {
        this.constrColSortClause = constrColSortClause;
    }

    public void setSortClause(String sortClause) {
        this.sortClause = sortClause;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getClustered() {
        return this.clusteredStatus;
    }

    public String getWith() {
        return this.with;
    }

    public HashMap getDiskAttr() {
        return this.diskAttr;
    }

    public String getUsingIndex() {
        return this.usingIndex;
    }

    public Vector getConstraintColumnNames() {
        return this.constraintColumnNames;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public HashMap getConstrColumnSortClauseMap() {
        return this.constrColSortClause;
    }

    public String getSortClause() {
        return this.sortClause;
    }

    public void setTableNameFromCQS(String tableNameFromCQS) {
        this.tableNameFromCQS = tableNameFromCQS;
    }

    @Override
    public void toDB2String() throws ConvertException {
        this.setClustered(null);
        this.setWith(null);
        this.setDiskAttr(null);
        this.setUsingIndex(null);
        this.setOnString(null);
        this.setOnIndexOrIdentifier(null);
        this.setConstrColumnSortClauseMap(null);
        this.setSortClause(null);
        if (this.getColumnName() != null) {
            this.setOpenBrace(null);
            this.setConstraintColumnNames(null);
            this.setClosedBrace(null);
        }
        if (this.constraintColumnNames != null) {
            Vector<String> oracleColumnVector = new Vector<String>();
            for (int i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    String constraintColumn = (String)this.constraintColumnNames.get(i);
                    String strConst = this.getConstraintName();
                    if (strConst.toUpperCase().indexOf("UNIQUE KEY") != -1) {
                        strConst = "UNIQUE ";
                        this.setConstraintName(strConst);
                    }
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
    }

    @Override
    public void toMSSQLServerString() throws ConvertException {
        if (this.onString != null) {
            this.setUsingIndex(this.onString + " " + this.onIndexOrIdentifier);
        }
        this.setConstrColumnSortClauseMap(null);
        this.setSortClause(null);
        if (this.constraintColumnNames != null) {
            String columnsString = "";
            Vector<String> oracleColumnVector = new Vector<String>();
            for (int i = 0; i < this.constraintColumnNames.size(); ++i) {
                String strConst = this.getConstraintName();
                if (strConst.toUpperCase().indexOf("UNIQUE KEY") != -1) {
                    strConst = "UNIQUE";
                    this.setConstraintName(strConst);
                }
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    String constraintColumn = (String)this.constraintColumnNames.get(i);
                    String[] keywords = null;
                    if (SwisSQLUtils.getKeywords(2) != null) {
                        keywords = SwisSQLUtils.getKeywords(2);
                        if (constraintColumn.trim().length() > 0) {
                            constraintColumn = CustomizeUtil.objectNamesToBracedIdentifier(constraintColumn, keywords, null);
                        }
                    }
                    if (constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    if (constraintColumn.trim().startsWith("[") && constraintColumn.trim().endsWith("]")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    if (this.usingIndex != null && strConst != null && strConst.toUpperCase().indexOf("UNIQUE") == -1) {
                        if (i == this.constraintColumnNames.size() - 1) {
                            columnsString = columnsString + constraintColumn;
                            this.setUsingIndex(null);
                            oracleColumnVector.add("CLUSTERED(" + columnsString + ")");
                        } else {
                            columnsString = columnsString + constraintColumn + ",";
                        }
                        this.setClosedBrace(null);
                        this.setOpenBrace(null);
                        continue;
                    }
                    oracleColumnVector.add(constraintColumn);
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            if (this.usingIndex != null) {
                this.setUsingIndex(null);
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
    }

    @Override
    public void toSybaseString() throws ConvertException {
        this.setUsingIndex(null);
        if (this.constraintColumnNames != null) {
            Vector<String> oracleColumnVector = new Vector<String>();
            if (this.columnNameVsSize != null && !this.columnNameVsSize.isEmpty()) {
                this.columnNameVsSize = new HashMap();
            }
            for (int i = 0; i < this.constraintColumnNames.size(); ++i) {
                String strConst = this.getConstraintName();
                if (strConst.toUpperCase().indexOf("UNIQUE KEY") != -1) {
                    strConst = "UNIQUE";
                    this.setConstraintName(strConst);
                }
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    String constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        String tempValue = (String)this.constrColSortClause.get(constraintColumn);
                        this.constrColSortClause.remove(constraintColumn);
                        constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1);
                        if (constraintColumn.indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        this.constrColSortClause.put(constraintColumn, tempValue);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
    }

    @Override
    public void toOracleString() throws ConvertException {
        if (this.getColumnName() != null) {
            this.setOpenBrace(null);
            this.setConstraintColumnNames(null);
            this.setClosedBrace(null);
        }
        this.setConstrColumnSortClauseMap(null);
        this.setSortClause(null);
        if (this.constraintColumnNames != null) {
            Vector<String> oracleColumnVector = new Vector<String>();
            for (int i = 0; i < this.constraintColumnNames.size(); ++i) {
                String strConst = this.getConstraintName();
                if (strConst.toUpperCase().indexOf("UNIQUE KEY") != -1) {
                    strConst = "UNIQUE";
                    this.setConstraintName(strConst);
                }
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    String constraintColumn = (String)this.constraintColumnNames.get(i);
                    if ((constraintColumn = CustomizeUtil.objectNamesToQuotedIdentifier(constraintColumn, SwisSQLUtils.getKeywords(1), null, 1)).startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1);
                        if (SwisSQLOptions.retainQuotedIdentifierForOracle || constraintColumn.indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                    } else {
                        oracleColumnVector.add(constraintColumn);
                    }
                    if (this.tableNameFromCQS != null) continue;
                    boolean addQuotes = false;
                    if (constraintColumn.startsWith("\"") && constraintColumn.endsWith("\"")) {
                        constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1);
                        addQuotes = true;
                    }
                    if (constraintColumn.length() <= 30) continue;
                    constraintColumn = constraintColumn.substring(0, 30);
                    if (addQuotes) {
                        constraintColumn = "\"" + constraintColumn + "\"";
                    }
                    oracleColumnVector.setElementAt(constraintColumn, oracleColumnVector.size() - 1);
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
        this.setUsingIndex(this.usingIndex);
        if (this.onString != null) {
            String indexString = this.onIndexOrIdentifier;
            if (indexString.startsWith("[") && indexString.endsWith("]") || indexString.startsWith("`") && indexString.endsWith("`")) {
                indexString = indexString.substring(1, indexString.length() - 1);
                if (SwisSQLOptions.retainQuotedIdentifierForOracle || indexString.indexOf(32) != -1) {
                    indexString = "\"" + indexString + "\"";
                }
            }
            if (!indexString.equalsIgnoreCase("primary")) {
                this.setUsingIndex("USING INDEX TABLESPACE " + indexString);
            }
            this.setOnString(null);
            this.setOnIndexOrIdentifier(null);
        }
    }

    @Override
    public void toPostgreSQLString() throws ConvertException {
        this.setClustered(null);
        this.setWith(null);
        this.setDiskAttr(null);
        this.setUsingIndex(null);
        this.setConstrColumnSortClauseMap(null);
        this.setSortClause(null);
        if (this.getColumnName() != null) {
            this.setOpenBrace(null);
            this.setConstraintColumnNames(null);
            this.setClosedBrace(null);
        }
        if (this.constraintColumnNames != null) {
            Vector<String> oracleColumnVector = new Vector<String>();
            for (int i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    String constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
    }

    @Override
    public void toANSIString() throws ConvertException {
        this.setClustered(null);
        this.setWith(null);
        this.setDiskAttr(null);
        this.setUsingIndex(null);
        this.setOnString(null);
        this.setOnIndexOrIdentifier(null);
        this.setConstrColumnSortClauseMap(null);
        this.setSortClause(null);
        if (this.getColumnName() != null) {
            this.setOpenBrace(null);
            this.setConstraintColumnNames(null);
            this.setClosedBrace(null);
        }
        if (this.constraintColumnNames != null) {
            Vector<String> oracleColumnVector = new Vector<String>();
            for (int i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    String constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
    }

    @Override
    public void toTeradataString() throws ConvertException {
        this.setClustered(null);
        this.setWith(null);
        this.setDiskAttr(null);
        this.setUsingIndex(null);
        this.setOnString(null);
        this.setOnIndexOrIdentifier(null);
        this.setConstrColumnSortClauseMap(null);
        this.setSortClause(null);
        if (this.getColumnName() != null) {
            this.setOpenBrace(null);
            this.setConstraintColumnNames(null);
            this.setClosedBrace(null);
        }
        if (this.constraintColumnNames != null) {
            Vector<String> oracleColumnVector = new Vector<String>();
            for (int i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    String constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
    }

    @Override
    public void toMySQLString() throws ConvertException {
        this.setClustered(null);
        this.setWith(null);
        this.setDiskAttr(null);
        this.setUsingIndex(null);
        this.setOnString(null);
        this.setOnIndexOrIdentifier(null);
        this.setConstrColumnSortClauseMap(null);
        this.setSortClause(null);
        if (this.getColumnName() != null && this.constraintColumnNames != null && this.constraintColumnNames.contains(this.getColumnName())) {
            this.setOpenBrace(null);
            this.setConstraintColumnNames(null);
            this.setClosedBrace(null);
        }
        if (this.constraintColumnNames != null) {
            Vector<String> oracleColumnVector = new Vector<String>();
            for (int i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    String constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("\"") && constraintColumn.endsWith("\"")) {
                        constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1);
                        constraintColumn = "`" + constraintColumn + "`";
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    if (constraintColumn.startsWith("`") || constraintColumn.endsWith("`")) {
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    constraintColumn = "`" + constraintColumn + "`";
                    oracleColumnVector.add(constraintColumn);
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
    }

    @Override
    public void toInformixString() throws ConvertException {
        this.setClustered(null);
        this.setWith(null);
        this.setDiskAttr(null);
        this.setUsingIndex(null);
        this.setOnString(null);
        this.setOnIndexOrIdentifier(null);
        this.setConstrColumnSortClauseMap(null);
        this.setSortClause(null);
        if (this.getColumnName() != null) {
            this.setOpenBrace(null);
            this.setConstraintColumnNames(null);
            this.setClosedBrace(null);
        }
        if (this.constraintColumnNames != null) {
            Vector<String> oracleColumnVector = new Vector<String>();
            for (int i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    String constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
    }

    @Override
    public void toTimesTenString() throws ConvertException {
        this.setUsingIndex(null);
        this.setConstrColumnSortClauseMap(null);
        this.setSortClause(null);
        this.setWith(null);
        this.setDiskAttr(null);
        this.setClustered(null);
        if (this.constraintColumnNames != null) {
            Vector<String> columnVector = new Vector<String>();
            for (int i = 0; i < this.constraintColumnNames.size(); ++i) {
                String strConst = this.getConstraintName();
                if (strConst.toUpperCase().indexOf("UNIQUE KEY") != -1) {
                    strConst = "UNIQUE";
                    this.setConstraintName(strConst);
                }
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    String constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        columnVector.add(constraintColumn);
                        continue;
                    }
                    columnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                columnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(columnVector);
        }
    }

    @Override
    public void toNetezzaString() throws ConvertException {
        this.setClustered(null);
        this.setWith(null);
        this.setDiskAttr(null);
        this.setUsingIndex(null);
        this.setOnString(null);
        this.setOnIndexOrIdentifier(null);
        this.setConstrColumnSortClauseMap(null);
        this.setSortClause(null);
        if (this.getColumnName() != null) {
            this.setOpenBrace(null);
            this.setConstraintColumnNames(null);
            this.setClosedBrace(null);
        }
        if (this.constraintColumnNames != null) {
            Vector<String> oracleColumnVector = new Vector<String>();
            for (int i = 0; i < this.constraintColumnNames.size(); ++i) {
                if (this.constraintColumnNames.elementAt(i) instanceof String) {
                    String constraintColumn = (String)this.constraintColumnNames.get(i);
                    if (constraintColumn.startsWith("[") && constraintColumn.endsWith("]") || constraintColumn.startsWith("`") && constraintColumn.endsWith("`")) {
                        if ((constraintColumn = constraintColumn.substring(1, constraintColumn.length() - 1)).indexOf(32) != -1) {
                            constraintColumn = "\"" + constraintColumn + "\"";
                        }
                        oracleColumnVector.add(constraintColumn);
                        continue;
                    }
                    oracleColumnVector.add((String)this.constraintColumnNames.get(i));
                    continue;
                }
                oracleColumnVector.add((String)this.constraintColumnNames.get(i));
            }
            this.setConstraintColumnNames(oracleColumnVector);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.constraintName != null) {
            sb.append(this.constraintName.toUpperCase() + " ");
        }
        if (this.clusteredStatus != null) {
            sb.append(this.clusteredStatus + " ");
        }
        if (this.sortClause != null) {
            sb.append(this.sortClause.toUpperCase() + " ");
        }
        if (this.openBrace != null) {
            sb.append(this.openBrace);
        }
        if (this.constraintColumnNames != null) {
            for (int i = 0; i < this.constraintColumnNames.size(); ++i) {
                String sizeStr;
                String temp;
                String sss;
                String s;
                String col = this.constraintColumnNames.get(i).toString();
                if (this.context != null && !(s = col).equals(sss = this.context.getEquivalent(s).toString())) {
                    col = sss;
                }
                String modifiedCol = col;
                if (i == 0) {
                    if (this.context != null) {
                        temp = this.context.getEquivalent(col).toString();
                        sb.append(temp);
                    } else {
                        sb.append(col);
                        if (col.startsWith("`")) {
                            modifiedCol = col.substring(1, col.length() - 1);
                        }
                        if ((sizeStr = (String)this.columnNameVsSize.get(modifiedCol)) != null) {
                            sb.append("(");
                            sb.append(sizeStr);
                            sb.append(")");
                        }
                    }
                } else if (this.context != null) {
                    temp = this.context.getEquivalent(col).toString();
                    sb.append(", " + temp);
                } else {
                    sb.append(", " + col);
                    if (modifiedCol.startsWith("`")) {
                        modifiedCol = modifiedCol.substring(1, modifiedCol.length() - 1);
                    }
                    if ((sizeStr = (String)this.columnNameVsSize.get(modifiedCol)) != null) {
                        sb.append("(");
                        sb.append(sizeStr);
                        sb.append(")");
                    }
                }
                if (this.constrColSortClause == null || this.constrColSortClause.get(col) == null) continue;
                sb.append(" " + ((String)this.constrColSortClause.get(col)).toUpperCase());
            }
        }
        if (this.closedBrace != null) {
            sb.append(this.closedBrace + " ");
        }
        if (this.with != null) {
            sb.append(this.with.toUpperCase() + " ");
        }
        if (this.diskAttr != null && this.diskAttr.size() > 0) {
            Set keys = this.diskAttr.keySet();
            Iterator it = keys.iterator();
            boolean start = true;
            while (it.hasNext()) {
                if (!start) {
                    sb.append(", ");
                }
                Object obj = it.next();
                sb.append(obj.toString().toUpperCase() + " = " + (String)this.diskAttr.get(obj));
                start = false;
            }
            sb.append(" ");
        }
        if (this.usingIndex != null) {
            sb.append(this.usingIndex + " ");
        }
        return sb.toString();
    }

    public ConstraintType copyObjectValues() {
        PrimaryOrUniqueConstraintClause dupPrimaryOrUniqueConstraintClause = new PrimaryOrUniqueConstraintClause();
        dupPrimaryOrUniqueConstraintClause.setClosedBrace(this.closedBrace);
        dupPrimaryOrUniqueConstraintClause.setConstraintColumnNames(this.getConstraintColumnNames());
        dupPrimaryOrUniqueConstraintClause.setConstraintName(this.getConstraintName());
        dupPrimaryOrUniqueConstraintClause.setOpenBrace(this.openBrace);
        dupPrimaryOrUniqueConstraintClause.setConstrColumnSortClauseMap(this.constrColSortClause);
        dupPrimaryOrUniqueConstraintClause.setSortClause(this.sortClause);
        dupPrimaryOrUniqueConstraintClause.setClustered(this.getClustered());
        dupPrimaryOrUniqueConstraintClause.setWith(this.getWith());
        dupPrimaryOrUniqueConstraintClause.setDiskAttr(this.getDiskAttr());
        dupPrimaryOrUniqueConstraintClause.setUsingIndex(this.getUsingIndex());
        dupPrimaryOrUniqueConstraintClause.setOnString(this.onString);
        dupPrimaryOrUniqueConstraintClause.setOnIndexOrIdentifier(this.onIndexOrIdentifier);
        dupPrimaryOrUniqueConstraintClause.setObjectContext(this.context);
        if (this.columnNameVsSize != null) {
            Iterator it = this.columnNameVsSize.keySet().iterator();
            while (it.hasNext()) {
                String colName = it.next().toString();
                String colSize = this.columnNameVsSize.get(colName).toString();
                dupPrimaryOrUniqueConstraintClause.addToColumnNameVsSize(colName, colSize);
            }
        }
        return dupPrimaryOrUniqueConstraintClause;
    }
}

