/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.drop;

import com.adventnet.swissqlapi.config.SwisSQLOptions;
import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.statement.CommentClass;
import com.adventnet.swissqlapi.sql.statement.SwisSQLStatement;
import com.adventnet.swissqlapi.sql.statement.update.TableObject;
import java.util.Vector;

public class DropStatement
implements SwisSQLStatement {
    private String drop;
    private String tableOrSequence;
    private String ifExists;
    private Vector tableObjectVector;
    private String restrictOrCascade;
    private String constraints;
    private UserObjectContext objectContext = null;
    private String multipleQuery;
    private String materializedObject;
    private CommentClass commentObject;

    public void setDrop(String drop) {
        this.drop = drop;
    }

    public void setTableOrSequence(String tableOrSequence) {
        this.tableOrSequence = tableOrSequence;
    }

    public void setIfExists(String ifExists) {
        this.ifExists = ifExists;
    }

    public void setTableNameVector(Vector tableObjectVector) {
        this.tableObjectVector = tableObjectVector;
    }

    public void setRestrictOrCascade(String restrictOrCascade) {
        this.restrictOrCascade = restrictOrCascade;
    }

    public void setConstraints(String constraints) {
        this.constraints = constraints;
    }

    @Override
    public void setCommentClass(CommentClass commentObject) {
        this.commentObject = commentObject;
    }

    public void setMultipleQuery(String multipleQuery) {
        this.multipleQuery = multipleQuery;
    }

    public void setMaterializedView(String materialized) {
        this.materializedObject = materialized;
    }

    public String getMaterializedView() {
        return this.materializedObject;
    }

    public String getTableOrSequence() {
        return this.tableOrSequence;
    }

    public String getConstraints() {
        return this.constraints;
    }

    public Vector getTableObjectVector() {
        return this.tableObjectVector;
    }

    @Override
    public CommentClass getCommentClass() {
        return this.commentObject;
    }

    @Override
    public String toANSIString() throws ConvertException {
        DropStatement dropStatement = this.copyObjectValues();
        if (dropStatement.getTableObjectVector() != null) {
            Vector tableObjVector = dropStatement.getTableObjectVector();
            for (int i = 0; i < tableObjVector.size(); ++i) {
                TableObject tableObj = (TableObject)tableObjVector.get(i);
                tableObj.toANSISQL();
            }
        }
        dropStatement.setIfExists(null);
        dropStatement.setConstraints(null);
        return dropStatement.toString();
    }

    @Override
    public String toTeradataString() throws ConvertException {
        DropStatement dropStatement = this.copyObjectValues();
        if (dropStatement.commentObject != null) {
            dropStatement.commentObject.setSQLDialect(12);
        }
        if (dropStatement.getTableObjectVector() != null) {
            Vector tableObjVector = dropStatement.getTableObjectVector();
            for (int i = 0; i < tableObjVector.size(); ++i) {
                TableObject tableObj = (TableObject)tableObjVector.get(i);
                tableObj.toTeradata();
            }
        }
        dropStatement.setIfExists(null);
        dropStatement.setConstraints(null);
        return dropStatement.toString();
    }

    @Override
    public String toDB2String() throws ConvertException {
        DropStatement dropStatement = this.copyObjectValues();
        if (dropStatement.getTableObjectVector() != null) {
            Vector tableObjVector = dropStatement.getTableObjectVector();
            for (int i = 0; i < tableObjVector.size(); ++i) {
                TableObject tableObj = (TableObject)tableObjVector.get(i);
                tableObj.toDB2();
            }
        }
        dropStatement.setIfExists(null);
        dropStatement.setRestrictOrCascade(null);
        dropStatement.setConstraints(null);
        return dropStatement.toString();
    }

    @Override
    public String toInformixString() throws ConvertException {
        DropStatement dropStatement = this.copyObjectValues();
        if (dropStatement.getTableObjectVector() != null) {
            Vector tableObjVector = dropStatement.getTableObjectVector();
            for (int i = 0; i < tableObjVector.size(); ++i) {
                TableObject tableObj = (TableObject)tableObjVector.get(i);
                tableObj.toInformix();
            }
        }
        dropStatement.setIfExists(null);
        dropStatement.setConstraints(null);
        return dropStatement.toString();
    }

    @Override
    public String toMSSQLServerString() throws ConvertException {
        DropStatement dropStatement = this.copyObjectValues();
        if (dropStatement.getTableObjectVector() != null) {
            Vector tableObjVector = dropStatement.getTableObjectVector();
            for (int i = 0; i < tableObjVector.size(); ++i) {
                TableObject tableObj = (TableObject)tableObjVector.get(i);
                if (this.tableOrSequence.equalsIgnoreCase("INDEX")) {
                    tableObj.setTableType("INDEX");
                    if (tableObj.getUser() != null && SwisSQLOptions.fromSybase) {
                        tableObj.setOwner(tableObj.getUser());
                        tableObj.setUser(null);
                    }
                }
                tableObj.toMSSQLServer();
            }
        }
        dropStatement.setRestrictOrCascade(null);
        dropStatement.setIfExists(null);
        dropStatement.setConstraints(null);
        return dropStatement.toString();
    }

    @Override
    public String toMySQLString() throws ConvertException {
        DropStatement dropStatement = this.copyObjectValues();
        if (dropStatement.getTableObjectVector() != null) {
            Vector tableObjVector = dropStatement.getTableObjectVector();
            for (int i = 0; i < tableObjVector.size(); ++i) {
                TableObject tableObj = (TableObject)tableObjVector.get(i);
                tableObj.toMySQL();
            }
        }
        dropStatement.setRestrictOrCascade(null);
        dropStatement.setConstraints(null);
        return dropStatement.toString();
    }

    @Override
    public String toOracleString() throws ConvertException {
        DropStatement dropStatement = this.copyObjectValues();
        if (dropStatement.getTableObjectVector() != null) {
            Vector tableObjVector = dropStatement.getTableObjectVector();
            for (int i = 0; i < tableObjVector.size(); ++i) {
                String tableName;
                TableObject tableObj = (TableObject)tableObjVector.get(i);
                tableObj.toOracle();
                String tableOrIndex = dropStatement.getTableOrSequence();
                if (tableOrIndex != null && tableOrIndex.equalsIgnoreCase("index")) {
                    tableObj.setUser(null);
                }
                if ((tableName = tableObj.getTableName()) == null || (!tableName.startsWith("[") || !tableName.endsWith("]")) && (!tableName.startsWith("`") || !tableName.endsWith("`"))) continue;
                tableName = tableName.substring(1, tableName.length() - 1);
                if (SwisSQLOptions.retainQuotedIdentifierForOracle || tableName.indexOf(" ") != -1) {
                    tableName = "\"" + tableName + "\"";
                }
                tableObj.setTableName(tableName);
            }
        }
        dropStatement.setIfExists(null);
        return dropStatement.toString();
    }

    @Override
    public String toPostgreSQLString() throws ConvertException {
        DropStatement dropStatement = this.copyObjectValues();
        if (dropStatement.getTableObjectVector() != null) {
            Vector tableObjVector = dropStatement.getTableObjectVector();
            for (int i = 0; i < tableObjVector.size(); ++i) {
                TableObject tableObj = (TableObject)tableObjVector.get(i);
                tableObj.toPostgreSQL();
            }
        }
        dropStatement.setRestrictOrCascade(null);
        dropStatement.setIfExists(null);
        dropStatement.setConstraints(null);
        return dropStatement.toString();
    }

    @Override
    public String toSybaseString() throws ConvertException {
        DropStatement dropStatement = this.copyObjectValues();
        if (dropStatement.getTableObjectVector() != null) {
            Vector tableObjVector = dropStatement.getTableObjectVector();
            for (int i = 0; i < tableObjVector.size(); ++i) {
                TableObject tableObj = (TableObject)tableObjVector.get(i);
                tableObj.toSybase();
            }
        }
        dropStatement.setRestrictOrCascade(null);
        dropStatement.setIfExists(null);
        dropStatement.setConstraints(null);
        return dropStatement.toString();
    }

    @Override
    public String toTimesTenString() throws ConvertException {
        DropStatement dropStatement = this.copyObjectValues();
        if (dropStatement.getTableObjectVector() != null) {
            Vector tableObjVector = dropStatement.getTableObjectVector();
            this.multipleQuery = "";
            for (int i = 0; i < tableObjVector.size(); ++i) {
                TableObject tableObj = (TableObject)tableObjVector.get(i);
                tableObj.toTimesTen();
                if (i <= 0) continue;
                tableObjVector.remove(i);
                --i;
                this.multipleQuery = this.multipleQuery + "DROP " + this.tableOrSequence + " " + tableObj.toString().trim() + ";\n\n";
            }
        }
        if (!this.multipleQuery.equalsIgnoreCase("")) {
            dropStatement.setMultipleQuery(this.multipleQuery);
        }
        dropStatement.setIfExists(null);
        dropStatement.setRestrictOrCascade(null);
        dropStatement.setConstraints(null);
        return dropStatement.toString();
    }

    @Override
    public String toNetezzaString() throws ConvertException {
        DropStatement dropStatement = this.copyObjectValues();
        if (dropStatement.getTableObjectVector() != null) {
            Vector tableObjVector = dropStatement.getTableObjectVector();
            for (int i = 0; i < tableObjVector.size(); ++i) {
                TableObject tableObj = (TableObject)tableObjVector.get(i);
                tableObj.toNetezza();
            }
        }
        dropStatement.setIfExists(null);
        dropStatement.setConstraints(null);
        dropStatement.setRestrictOrCascade(null);
        return dropStatement.toString();
    }

    public DropStatement copyObjectValues() {
        DropStatement dropStmt = new DropStatement();
        dropStmt.setConstraints(this.constraints);
        dropStmt.setCommentClass(this.commentObject);
        dropStmt.setDrop(this.drop);
        dropStmt.setIfExists(this.ifExists);
        dropStmt.setRestrictOrCascade(this.restrictOrCascade);
        dropStmt.setTableOrSequence(this.tableOrSequence);
        dropStmt.setTableNameVector(this.tableObjectVector);
        dropStmt.setObjectContext(this.objectContext);
        dropStmt.setMaterializedView(this.materializedObject);
        return dropStmt;
    }

    @Override
    public String removeIndent(String str2) {
        str2 = str2.replace('\n', ' ');
        str2 = str2.replace('\t', ' ');
        return str2;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.commentObject != null) {
            sb.append(this.commentObject.toString() + "\n");
        }
        if (this.drop != null) {
            sb.append(this.drop.toUpperCase());
        }
        if (this.materializedObject != null) {
            sb.append(" " + this.getMaterializedView() + " ");
        }
        if (this.tableOrSequence != null) {
            sb.append(" " + this.tableOrSequence.toUpperCase());
        }
        if (this.ifExists != null) {
            sb.append("  " + this.ifExists.toUpperCase());
        }
        if (this.tableObjectVector != null) {
            for (int i = 0; i < this.tableObjectVector.size(); ++i) {
                TableObject tableObject = (TableObject)this.tableObjectVector.get(i);
                tableObject.setObjectContext(this.objectContext);
                if (i == 0) {
                    sb.append(" " + tableObject);
                    continue;
                }
                sb.append(",\n\t" + tableObject);
            }
        }
        if (this.restrictOrCascade != null) {
            sb.append("\n\t" + this.restrictOrCascade.toUpperCase());
        }
        if (this.constraints != null) {
            sb.append(" " + this.constraints.toUpperCase());
        }
        if (this.multipleQuery != null) {
            StringBuffer sb1 = new StringBuffer();
            sb1.append(sb.toString().trim() + ";\n\n" + this.multipleQuery);
            return sb1.toString();
        }
        return sb.toString();
    }

    @Override
    public UserObjectContext getObjectContext() {
        return this.objectContext;
    }

    @Override
    public void setObjectContext(UserObjectContext obj) {
        this.objectContext = obj;
    }
}

