/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.insert;

import com.adventnet.swissqlapi.config.SwisSQLOptions;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.statement.SwisSQLStatement;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.update.TableObject;
import com.adventnet.swissqlapi.util.SwisSQLUtils;
import com.adventnet.swissqlapi.util.misc.CustomizeUtil;
import java.util.ArrayList;

public class CommonTableExpression {
    String with;
    TableObject viewName;
    ArrayList columnList = new ArrayList();
    String as;
    SelectQueryStatement sqs;

    public void setWith(String with) {
        this.with = with;
    }

    public void setViewName(TableObject viewName) {
        this.viewName = viewName;
    }

    public void setColumnList(ArrayList columnList) {
        this.columnList = columnList;
    }

    public void setAs(String as) {
        this.as = as;
    }

    public void setSelectQueryStatement(SelectQueryStatement sqs) {
        this.sqs = sqs;
    }

    public String getWith() {
        return this.with;
    }

    public TableObject getViewName() {
        return this.viewName;
    }

    public ArrayList getColumnList() {
        return this.columnList;
    }

    public String getAs() {
        return this.as;
    }

    public SelectQueryStatement getSelectQueryStatement() {
        return this.sqs;
    }

    public CommonTableExpression toOracle(SwisSQLStatement fromSQL, SwisSQLStatement toSQL) throws ConvertException {
        SelectQueryStatement srcSQS;
        CommonTableExpression commonTableExpr = this.copyObjectValues();
        TableObject srcViewName = commonTableExpr.getViewName();
        srcViewName.toOracle();
        ArrayList columnList = commonTableExpr.getColumnList();
        if (!columnList.isEmpty()) {
            for (int i = 0; i < columnList.size(); ++i) {
                String columnName = (String)columnList.get(i);
                if (!(columnName.trim().equals(",") || columnName.trim().equals("(") || columnName.trim().equals(")"))) {
                    columnName = CustomizeUtil.objectNamesToQuotedIdentifier(columnName, SwisSQLUtils.getKeywords(1), null, 1);
                }
                if (columnName.startsWith("[") && columnName.endsWith("]") || columnName.startsWith("`") && columnName.endsWith("`")) {
                    columnName = columnName.substring(1, columnName.length() - 1);
                }
                if (columnName.startsWith("\"") || !SwisSQLOptions.retainQuotedIdentifierForOracle && columnName.indexOf(32) == -1) continue;
                columnName = "\"" + columnName + "\"";
            }
        }
        if ((srcSQS = commonTableExpr.getSelectQueryStatement()) != null) {
            commonTableExpr.setSelectQueryStatement(srcSQS.toOracleSelect());
        }
        return commonTableExpr;
    }

    public CommonTableExpression toMSSQLServer(SwisSQLStatement fromSQL, SwisSQLStatement toSQL) throws ConvertException {
        return this;
    }

    public CommonTableExpression toSybase(SwisSQLStatement fromSQL, SwisSQLStatement toSQL) throws ConvertException {
        return this;
    }

    public CommonTableExpression toDB2(SwisSQLStatement fromSQL, SwisSQLStatement toSQL) throws ConvertException {
        return this;
    }

    public CommonTableExpression toMySQL(SwisSQLStatement fromSQL, SwisSQLStatement toSQL) throws ConvertException {
        return this;
    }

    public CommonTableExpression toInformix(SwisSQLStatement fromSQL, SwisSQLStatement toSQL) throws ConvertException {
        return this;
    }

    public CommonTableExpression toPostgreSQL(SwisSQLStatement fromSQL, SwisSQLStatement toSQL) throws ConvertException {
        return this;
    }

    public CommonTableExpression toANSISQL(SwisSQLStatement fromSQL, SwisSQLStatement toSQL) throws ConvertException {
        SelectQueryStatement srcSQS;
        CommonTableExpression commonTableExpr = this.copyObjectValues();
        TableObject srcViewName = commonTableExpr.getViewName();
        srcViewName.toANSISQL();
        ArrayList columnList = commonTableExpr.getColumnList();
        if (!columnList.isEmpty()) {
            for (int i = 0; i < columnList.size(); ++i) {
                String columnName = (String)columnList.get(i);
                if (!(columnName.trim().equals(",") || columnName.trim().equals("(") || columnName.trim().equals(")"))) {
                    columnName = CustomizeUtil.objectNamesToQuotedIdentifier(columnName, SwisSQLUtils.getKeywords(8), null, 8);
                }
                if (columnName.startsWith("[") && columnName.endsWith("]") || columnName.startsWith("`") && columnName.endsWith("`")) {
                    columnName = columnName.substring(1, columnName.length() - 1);
                }
                if (columnName.startsWith("\"") || columnName.indexOf(32) == -1) continue;
                columnName = "\"" + columnName + "\"";
            }
        }
        if ((srcSQS = commonTableExpr.getSelectQueryStatement()) != null) {
            commonTableExpr.setSelectQueryStatement(srcSQS.toANSISelect());
        }
        return commonTableExpr;
    }

    public CommonTableExpression toTeradata(SwisSQLStatement fromSQL, SwisSQLStatement toSQL) throws ConvertException {
        SelectQueryStatement srcSQS;
        CommonTableExpression commonTableExpr = this.copyObjectValues();
        TableObject srcViewName = commonTableExpr.getViewName();
        srcViewName.toTeradata();
        ArrayList columnList = commonTableExpr.getColumnList();
        if (!columnList.isEmpty()) {
            for (int i = 0; i < columnList.size(); ++i) {
                String columnName = (String)columnList.get(i);
                if (!(columnName.trim().equals(",") || columnName.trim().equals("(") || columnName.trim().equals(")"))) {
                    columnName = CustomizeUtil.objectNamesToQuotedIdentifier(columnName, SwisSQLUtils.getKeywords(12), null, 12);
                }
                if (columnName.startsWith("[") && columnName.endsWith("]") || columnName.startsWith("`") && columnName.endsWith("`")) {
                    columnName = columnName.substring(1, columnName.length() - 1);
                }
                if (columnName.startsWith("\"") || columnName.indexOf(32) == -1) continue;
                columnName = "\"" + columnName + "\"";
            }
        }
        if ((srcSQS = commonTableExpr.getSelectQueryStatement()) != null) {
            commonTableExpr.setSelectQueryStatement(srcSQS.toTeradataSelect());
        }
        return commonTableExpr;
    }

    public CommonTableExpression toTimesTen(SwisSQLStatement fromSQL, SwisSQLStatement toSQL) throws ConvertException {
        return this;
    }

    public CommonTableExpression toNetezza(SwisSQLStatement fromSQL, SwisSQLStatement toSQL) throws ConvertException {
        SelectQueryStatement srcSQS;
        CommonTableExpression commonTableExpr = this.copyObjectValues();
        TableObject srcViewName = commonTableExpr.getViewName();
        srcViewName.toNetezza();
        ArrayList columnList = commonTableExpr.getColumnList();
        if (!columnList.isEmpty()) {
            for (int i = 0; i < columnList.size(); ++i) {
                String columnName = (String)columnList.get(i);
                if (!(columnName.trim().equals(",") || columnName.trim().equals("(") || columnName.trim().equals(")"))) {
                    columnName = CustomizeUtil.objectNamesToQuotedIdentifier(columnName, SwisSQLUtils.getKeywords(11), null, 11);
                }
                if (columnName.startsWith("[") && columnName.endsWith("]") || columnName.startsWith("`") && columnName.endsWith("`")) {
                    columnName = columnName.substring(1, columnName.length() - 1);
                }
                if (columnName.startsWith("\"") || columnName.indexOf(32) == -1) continue;
                columnName = "\"" + columnName + "\"";
            }
        }
        if ((srcSQS = commonTableExpr.getSelectQueryStatement()) != null) {
            commonTableExpr.setSelectQueryStatement(srcSQS.toNetezzaSelect());
        }
        return commonTableExpr;
    }

    private CommonTableExpression copyObjectValues() {
        CommonTableExpression commonTableExpr = new CommonTableExpression();
        commonTableExpr.setWith(this.getWith());
        commonTableExpr.setViewName(this.getViewName());
        commonTableExpr.setColumnList(this.getColumnList());
        commonTableExpr.setAs(this.getAs());
        commonTableExpr.setSelectQueryStatement(this.getSelectQueryStatement());
        return commonTableExpr;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.with != null) {
            sb.append("WITH ");
        }
        if (this.viewName != null) {
            sb.append(this.viewName);
        }
        if (!this.columnList.isEmpty()) {
            for (int i = 0; i < this.columnList.size(); ++i) {
                sb.append(this.columnList.get(i));
            }
        }
        if (this.as != null) {
            sb.append(" AS ");
        }
        if (this.sqs != null) {
            sb.append("(" + this.sqs.toString().trim() + ")");
        }
        return sb.toString();
    }
}

