/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.select;

import com.adventnet.swissqlapi.SwisSQLAPI;
import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.statement.CommentClass;
import com.adventnet.swissqlapi.sql.statement.create.DateClass;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhenStatement;
import com.adventnet.swissqlapi.sql.statement.select.WhereColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereExpression;
import com.adventnet.swissqlapi.sql.statement.select.WhereItem;
import com.adventnet.swissqlapi.util.SwisSQLUtils;
import java.util.Vector;

public class CaseStatement {
    private String caseClause = null;
    private WhereExpression caseCondition = null;
    private SelectQueryStatement subquery;
    private Vector whenStatementList = null;
    private String elseClause = null;
    private SelectColumn elseStatement = null;
    private String endClause = null;
    private UserObjectContext context = null;
    private String decodeFunction = null;
    private CommentClass commentObj;
    private Vector curr_whereItem = new Vector();

    public void setCaseClause(String s_case_clause) {
        this.caseClause = s_case_clause;
    }

    public void setObjectContext(UserObjectContext obj) {
        this.context = obj;
    }

    public void setCaseCondition(WhereExpression we_case_condition) {
        this.caseCondition = we_case_condition;
    }

    public void setSubQuery(SelectQueryStatement subquery) {
        this.subquery = subquery;
    }

    public void setWhenStatementList(Vector v_when_clause_list) {
        this.whenStatementList = v_when_clause_list;
    }

    public void setElseClause(String s_else_clause) {
        this.elseClause = s_else_clause;
    }

    public void setElseStatement(SelectColumn sc_else_statement) {
        this.elseStatement = sc_else_statement;
    }

    public void setEndClause(String s_end_clause) {
        this.endClause = s_end_clause;
    }

    public void setDecodeFunction(String s_decode_function) {
        this.decodeFunction = s_decode_function;
    }

    public void setCommentClass(CommentClass commentObj) {
        this.commentObj = commentObj;
    }

    public CommentClass getCommentClass() {
        return this.commentObj;
    }

    public String getDecodeFunction() {
        return this.decodeFunction;
    }

    public String getCaseClause() {
        return this.caseClause;
    }

    public WhereExpression getCaseCondition() {
        return this.caseCondition;
    }

    public SelectQueryStatement getSubQuery() {
        return this.subquery;
    }

    public Vector getWhenClauseList() {
        return this.whenStatementList;
    }

    public String getElseClause() {
        return this.elseClause;
    }

    public SelectColumn getElseStatement() {
        return this.elseStatement;
    }

    public String getEndClause() {
        return this.endClause;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String convertToBooleanFunction(WhereItem wi) throws ConvertException {
        StringBuffer sb = new StringBuffer();
        if (wi.getRightWhereExp() == null && wi.getRightWhereSubQuery() == null) {
            String isnull2 = wi.toString().toUpperCase();
            if (isnull2.indexOf("NOT") == -1) {
                sb.append("DECODE( " + wi.getLeftWhereExp().toString() + ", NULL , 1 , 0 )");
                return sb.toString();
            } else {
                sb.append("DECODE( " + wi.getLeftWhereExp().toString() + ", NULL , 0 , 1 )");
            }
            return sb.toString();
        } else if (wi.getRightWhereExp() != null && wi.getRightWhereSubQuery() == null) {
            String s_operator = wi.getOperator();
            if (s_operator.equals("=")) {
                sb.append("DECODE( " + wi.getLeftWhereExp().toString() + "," + wi.getRightWhereExp().toString());
                sb.append(",1,0)");
                return sb.toString();
            } else if (s_operator.equals("!=") || s_operator.equals("<>") || s_operator.equals("^=")) {
                sb.append("DECODE(" + wi.getLeftWhereExp().toString() + "," + wi.getRightWhereExp().toString());
                sb.append(",0,1)");
                return sb.toString();
            } else if (s_operator.equals("<")) {
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),");
                sb.append("(" + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),0,0,0,1 )");
                return sb.toString();
            } else if (s_operator.equals(">")) {
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),0,0, ");
                sb.append("(" + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),1,0 )");
                return sb.toString();
            } else if (s_operator.equals("<=")) {
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),");
                sb.append(" 0,1,( " + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),0,1 )");
                return sb.toString();
            } else if (s_operator.equals(">=")) {
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),");
                sb.append(" 0,1,( " + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),1,0)");
                return sb.toString();
            } else if (s_operator.equalsIgnoreCase("IN")) {
                sb.append("DECODE( " + wi.getLeftWhereExp());
                sb.append(",");
                WhereColumn wc = wi.getRightWhereExp();
                if (wc.getColumnExpression() != null) {
                    if (wc.getColumnExpression().size() == 1) {
                        sb.append(wc.getColumnExpression().get(0).toString() + ",1");
                    } else {
                        for (int i = 0; i < wc.getColumnExpression().size(); ++i) {
                            if (")".equals(wc.getColumnExpression().get(i).toString().trim()) || "(".equals(wc.getColumnExpression().get(i).toString().trim()) || ",".equals(wc.getColumnExpression().get(i).toString().trim())) continue;
                            sb.append(wc.getColumnExpression().get(i).toString() + ",");
                            sb.append("1");
                            if (i == wc.getColumnExpression().size() - 2) continue;
                            sb.append(",");
                        }
                    }
                }
                sb.append(",0 )");
                return sb.toString();
            } else if (s_operator.equalsIgnoreCase("NOT IN")) {
                sb.append("DECODE( " + wi.getLeftWhereExp());
                sb.append(",");
                WhereColumn wc = wi.getRightWhereExp();
                if (wc.getColumnExpression() != null) {
                    if (wc.getColumnExpression().size() == 1) {
                        sb.append(wc.getColumnExpression().get(0).toString() + ",0");
                    } else {
                        for (int i = 0; i < wc.getColumnExpression().size(); ++i) {
                            if (i < wc.getColumnExpression().size() - 1) {
                                if (")".equals(wc.getColumnExpression().get(i).toString().trim()) || "(".equals(wc.getColumnExpression().get(i).toString().trim()) || ",".equals(wc.getColumnExpression().get(i).toString().trim())) continue;
                                sb.append(wc.getColumnExpression().get(i).toString() + ",");
                                sb.append("0");
                                if (i == wc.getColumnExpression().size() - 2) continue;
                                sb.append(",");
                                continue;
                            }
                            if (")".equals(wc.getColumnExpression().get(i).toString().trim()) || "(".equals(wc.getColumnExpression().get(i).toString().trim()) || ",".equals(wc.getColumnExpression().get(i).toString().trim())) continue;
                            sb.append(wc.getColumnExpression().get(i).toString() + ",");
                            sb.append("1");
                            if (i == wc.getColumnExpression().size() - 2) continue;
                            sb.append(",");
                        }
                    }
                }
                sb.append(",1 )");
                return sb.toString();
            } else {
                if (!s_operator.equalsIgnoreCase("BETWEEN")) throw new ConvertException("Current operator yet to be supported ");
                String var = wi.getLeftWhereExp().toString();
                sb.append("DECODE( GREATEST(" + var + ",");
                String v1 = "";
                String v2 = "";
                WhereColumn wc = wi.getRightWhereExp();
                if (wc.getColumnExpression() != null && wc.getColumnExpression().size() == 3 && wc.getColumnExpression().get(1).toString().trim().equalsIgnoreCase("AND")) {
                    v1 = wc.getColumnExpression().get(0).toString();
                    v2 = wc.getColumnExpression().get(2).toString();
                }
                sb.append(v1 + "), " + var + ", DECODE(LEAST(" + var + "," + v2 + ")," + var + ",1,0),0)");
            }
            return sb.toString();
        } else {
            if (wi.getRightWhereSubQuery() == null) return sb.toString();
            String s_operator = wi.getOperator();
            if (s_operator.equals("=")) {
                sb.append("DECODE( " + wi.getLeftWhereExp().toString() + "," + "(" + wi.getRightWhereSubQuery().toString() + ")");
                sb.append(",1,0)");
                return sb.toString();
            } else if (s_operator.equals("!=") || s_operator.equals("<>") || s_operator.equals("^=")) {
                sb.append("DECODE(" + wi.getLeftWhereExp().toString() + "," + "(" + wi.getRightWhereSubQuery().toString() + ")");
                sb.append(",0,1)");
                return sb.toString();
            } else if (s_operator.equals("<")) {
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + " ) ),");
                sb.append("(" + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + " ) ),0,0,0,1 )");
                return sb.toString();
            } else if (s_operator.equals(">")) {
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + ") ),0,0 ,");
                sb.append("(" + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + ") ),1,0 )");
                return sb.toString();
            } else if (s_operator.equals("<=")) {
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + " ) ),");
                sb.append(" 0,1,( " + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + ") ),0,1 )");
                return sb.toString();
            } else if (s_operator.equals(">=")) {
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + ") ),");
                sb.append(" 0,1,( " + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + ") ),1,0)");
                return sb.toString();
            } else {
                if (!"exists".equalsIgnoreCase(s_operator.trim())) throw new ConvertException("Current operator yet to be supported");
                sb.append("DECODE( 1 , (");
                SelectQueryStatement selectQueryStatement = wi.getRightWhereSubQuery();
                Vector<String> v = new Vector<String>();
                v.add("1");
                WhereItem whereItem = new WhereItem();
                WhereColumn whereColumnL = new WhereColumn();
                WhereColumn whereColumnR = new WhereColumn();
                Vector<String> colExpL = new Vector<String>();
                Vector<String> colExpR = new Vector<String>();
                colExpL.add("ROWNUM");
                colExpR.add("2");
                whereColumnL.setColumnExpression(colExpL);
                whereColumnR.setColumnExpression(colExpR);
                whereItem.setLeftWhereExp(whereColumnL);
                whereItem.setRightWhereExp(whereColumnR);
                whereItem.setOperator("<");
                WhereExpression whereExpression = selectQueryStatement.getWhereExpression();
                if (whereExpression != null) {
                    whereExpression.addOperator("AND");
                    whereExpression.addWhereItem(whereItem);
                } else {
                    whereExpression = new WhereExpression();
                    whereExpression.addWhereItem(whereItem);
                    selectQueryStatement.setWhereExpression(whereExpression);
                }
                selectQueryStatement.getSelectStatement().setSelectItemList(v);
                sb.append(selectQueryStatement.toString() + " ),1,0 )");
            }
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String convertToBooleanFunction(WhereExpression caseCondition) throws ConvertException {
        String s_operator;
        StringBuffer sb = new StringBuffer();
        if (caseCondition.getOpenBrace() == null && caseCondition.getWhereItems().size() > 1) {
            throw new ConvertException("Multiple Conditions yet to be supported  1");
        }
        if (caseCondition.getOpenBrace() != null && caseCondition.getWhereItems().size() == 1) {
            WhereExpression we;
            if (caseCondition.getWhereItems().elementAt(0) instanceof WhereExpression && (we = (WhereExpression)caseCondition.getWhereItems().elementAt(0)).getWhereItems().size() > 1) {
                throw new ConvertException("Conversion Failure..Multiple Conditions are not supported 2");
            }
        } else if (caseCondition.getWhereItems().get(1) instanceof WhereExpression) {
            String str2 = this.convertToBooleanFunction((WhereExpression)caseCondition.getWhereItems().get(1));
            sb.append("DECODE(2,");
            sb.append(str2);
            sb.append(" + ");
        }
        WhereItem wi = new WhereItem();
        if (caseCondition.getWhereItems().elementAt(0) instanceof WhereExpression) {
            WhereExpression we = (WhereExpression)caseCondition.getWhereItems().elementAt(0);
            wi = (WhereItem)we.getWhereItems().elementAt(0);
        } else {
            wi = (WhereItem)caseCondition.getWhereItems().elementAt(0);
        }
        if (wi.getRightWhereExp() == null && wi.getRightWhereSubQuery() == null) {
            String isnull2 = wi.toString().toUpperCase();
            if (isnull2.indexOf("NOT") == -1) {
                sb.append("DECODE( " + wi.getLeftWhereExp().toString() + ", NULL , 1 , 0 )");
                return sb.toString();
            } else {
                sb.append("DECODE( " + wi.getLeftWhereExp().toString() + ", NULL , 0 , 1 )");
            }
            return sb.toString();
        } else if (wi.getRightWhereExp() != null && wi.getRightWhereSubQuery() == null) {
            s_operator = wi.getOperator();
            if (s_operator.equals("=")) {
                sb.append("DECODE( " + wi.getLeftWhereExp().toString() + "," + wi.getRightWhereExp().toString());
                sb.append(",1,0)");
                return sb.toString();
            } else if (s_operator.equals("!=") || s_operator.equals("<>") || s_operator.equals("^=")) {
                sb.append("DECODE(" + wi.getLeftWhereExp().toString() + "," + wi.getRightWhereExp().toString());
                sb.append(",0,1)");
                return sb.toString();
            } else if (s_operator.equals("<")) {
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),");
                sb.append("(" + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),0,0,0,1 )");
                return sb.toString();
            } else if (s_operator.equals(">")) {
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),0,0, ");
                sb.append("(" + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),1,0 )");
                return sb.toString();
            } else if (s_operator.equals("<=")) {
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),");
                sb.append(" 0,1,( " + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),0,1 )");
                return sb.toString();
            } else {
                if (!s_operator.equals(">=")) throw new ConvertException("Conversion Failure..operator not supported");
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),");
                sb.append(" 0,1,( " + wi.getLeftWhereExp().toString() + " - " + wi.getRightWhereExp().toString() + "),1,0)");
            }
            return sb.toString();
        } else {
            if (wi.getRightWhereSubQuery() == null) return sb.toString();
            s_operator = wi.getOperator();
            if (s_operator.equals("=")) {
                sb.append("DECODE( " + wi.getLeftWhereExp().toString() + "," + "(" + wi.getRightWhereSubQuery().toString() + ")");
                sb.append(",1,0)");
                return sb.toString();
            } else if (s_operator.equals("!=") || s_operator.equals("<>") || s_operator.equals("^=")) {
                sb.append("DECODE(" + wi.getLeftWhereExp().toString() + "," + "(" + wi.getRightWhereSubQuery().toString() + ")");
                sb.append(",0,1)");
                return sb.toString();
            } else if (s_operator.equals("<")) {
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + " ) ),");
                sb.append("(" + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + " ) ),0,0,0,1 )");
                return sb.toString();
            } else if (s_operator.equals(">")) {
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + ") ),0,0 ,");
                sb.append("(" + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + ") ),1,0 )");
                return sb.toString();
            } else if (s_operator.equals("<=")) {
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + " ) ),");
                sb.append(" 0,1,( " + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + ") ),0,1 )");
                return sb.toString();
            } else {
                if (!s_operator.equals(">=")) throw new ConvertException("Conversion Failure..operator not supported");
                sb.append("DECODE(ABS(" + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + ") ),");
                sb.append(" 0,1,( " + wi.getLeftWhereExp().toString() + " - " + "(" + wi.getRightWhereSubQuery().toString() + ") ),1,0)");
            }
        }
        return sb.toString();
    }

    public CaseStatement toMySQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        CaseStatement cs = new CaseStatement();
        try {
            Vector<WhenStatement> v_when_statement_list = new Vector<WhenStatement>();
            cs.setCaseClause(this.caseClause);
            if (this.caseCondition != null) {
                cs.setCaseCondition(this.caseCondition.toMySQLSelect(to_sqs, from_sqs));
            }
            for (int i = 0; i < this.whenStatementList.size(); ++i) {
                v_when_statement_list.addElement(((WhenStatement)this.whenStatementList.elementAt(i)).toMySQLSelect(to_sqs, from_sqs));
            }
            cs.setWhenStatementList(v_when_statement_list);
            cs.setElseClause(this.elseClause);
            if (this.elseStatement != null) {
                cs.setElseStatement(this.elseStatement.toMySQLSelect(to_sqs, from_sqs));
            }
            cs.setEndClause(this.endClause);
            cs.setDecodeFunction(this.decodeFunction);
        }
        catch (Exception e) {
            System.err.println("Exception in Query : " + from_sqs);
            e.printStackTrace();
        }
        return cs;
    }

    public CaseStatement toPostgreSQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        CaseStatement cs = new CaseStatement();
        Vector<WhenStatement> v_when_statement_list = new Vector<WhenStatement>();
        cs.setCaseClause(this.caseClause);
        if (this.caseCondition != null) {
            cs.setCaseCondition(this.caseCondition.toPostgreSQLSelect(to_sqs, from_sqs));
        }
        for (int i = 0; i < this.whenStatementList.size(); ++i) {
            v_when_statement_list.addElement(((WhenStatement)this.whenStatementList.elementAt(i)).toPostgreSQLSelect(to_sqs, from_sqs));
        }
        if (this.subquery != null) {
            cs.setSubQuery(this.subquery.toPostgreSQLSelect());
        }
        cs.setWhenStatementList(v_when_statement_list);
        cs.setElseClause(this.elseClause);
        if (this.elseStatement != null) {
            cs.setElseStatement(this.elseStatement.toPostgreSQLSelect(to_sqs, from_sqs));
        }
        cs.setEndClause(this.endClause);
        cs.setDecodeFunction(this.decodeFunction);
        return cs;
    }

    public CaseStatement toANSISelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        CaseStatement cs = new CaseStatement();
        Vector<WhenStatement> v_when_statement_list = new Vector<WhenStatement>();
        cs.setCaseClause(this.caseClause);
        if (this.caseCondition != null) {
            cs.setCaseCondition(this.caseCondition.toANSISelect(to_sqs, from_sqs));
        }
        for (int i = 0; i < this.whenStatementList.size(); ++i) {
            v_when_statement_list.addElement(((WhenStatement)this.whenStatementList.elementAt(i)).toANSISelect(to_sqs, from_sqs));
        }
        if (this.subquery != null) {
            cs.setSubQuery(this.subquery.toANSISelect());
        }
        cs.setWhenStatementList(v_when_statement_list);
        cs.setElseClause(this.elseClause);
        if (this.elseStatement != null) {
            cs.setElseStatement(this.elseStatement.toANSISelect(to_sqs, from_sqs));
        }
        cs.setEndClause(this.endClause);
        cs.setDecodeFunction(this.decodeFunction);
        return cs;
    }

    public CaseStatement toTeradataSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        Object fnName;
        CaseStatement cs = new CaseStatement();
        Vector<WhenStatement> v_when_statement_list = new Vector<WhenStatement>();
        cs.setCaseClause(this.caseClause);
        if (this.caseCondition != null) {
            this.caseCondition.setCaseExpressionBool(true);
            WhereExpression caseExp = this.caseCondition.toTeradataSelect(to_sqs, from_sqs);
            if (this.caseCondition.getRownumClause() != null) {
                caseExp.setRownumClause(this.caseCondition.getRownumClause());
            }
            cs.setCaseCondition(caseExp);
        }
        boolean isDatePresent = false;
        int dateWhenStmtIdx = -1;
        for (int k = 0; k < this.whenStatementList.size(); ++k) {
            SelectColumn sc1 = ((WhenStatement)this.whenStatementList.elementAt(k)).getThenStatement();
            for (int n = 0; n < sc1.getColumnExpression().size(); ++n) {
                String fnName2;
                FunctionCalls fcObj;
                Object obj = sc1.getColumnExpression().get(n);
                if (!(obj instanceof FunctionCalls) || (fcObj = (FunctionCalls)obj).getFunctionName() == null || !SwisSQLUtils.getFunctionReturnType(fnName2 = fcObj.getFunctionName().getColumnName(), fcObj.getFunctionArguments()).equalsIgnoreCase("date")) continue;
                isDatePresent = true;
                dateWhenStmtIdx = k;
            }
        }
        if (this.elseStatement != null) {
            for (int n = 0; n < this.elseStatement.getColumnExpression().size(); ++n) {
                FunctionCalls fcObj;
                Object obj = this.elseStatement.getColumnExpression().get(n);
                if (!(obj instanceof FunctionCalls) || (fcObj = (FunctionCalls)obj).getFunctionName() == null || !SwisSQLUtils.getFunctionReturnType((String)(fnName = fcObj.getFunctionName().getColumnName()), fcObj.getFunctionArguments()).equalsIgnoreCase("date")) continue;
                isDatePresent = true;
            }
        }
        for (int i = 0; i < this.whenStatementList.size(); ++i) {
            WhenStatement convertedWhenStmt = ((WhenStatement)this.whenStatementList.elementAt(i)).toTeradataSelect(to_sqs, from_sqs);
            if (isDatePresent) {
                FunctionCalls caseFunc = new FunctionCalls();
                fnName = new TableColumn();
                ((TableColumn)fnName).setColumnName("CAST");
                caseFunc.setFunctionName((TableColumn)fnName);
                Vector<Object> fnArgs = new Vector<Object>();
                fnArgs.add(convertedWhenStmt.getThenStatement());
                caseFunc.setAsDatatype("AS");
                DateClass timestamp = new DateClass();
                timestamp.setDatatypeName("TIMESTAMP");
                timestamp.setSize("0");
                timestamp.setOpenBrace("(");
                timestamp.setClosedBrace(")");
                fnArgs.add(timestamp);
                caseFunc.setFunctionArguments(fnArgs);
                SelectColumn newSelCol = new SelectColumn();
                Vector<FunctionCalls> colExp = new Vector<FunctionCalls>();
                colExp.add(caseFunc);
                newSelCol.setColumnExpression(colExp);
                convertedWhenStmt.setThenStatement(newSelCol);
                v_when_statement_list.addElement(convertedWhenStmt);
                continue;
            }
            v_when_statement_list.addElement(convertedWhenStmt);
        }
        if (this.subquery != null) {
            cs.setSubQuery(this.subquery.toTeradataSelect());
        }
        cs.setWhenStatementList(v_when_statement_list);
        cs.setElseClause(this.elseClause);
        if (this.elseStatement != null) {
            SelectColumn convertedElseStatement = this.elseStatement.toTeradataSelect(to_sqs, from_sqs);
            if (isDatePresent) {
                FunctionCalls caseFunc = new FunctionCalls();
                TableColumn fnName3 = new TableColumn();
                fnName3.setColumnName("CAST");
                caseFunc.setFunctionName(fnName3);
                Vector<Object> fnArgs = new Vector<Object>();
                fnArgs.add(convertedElseStatement);
                caseFunc.setAsDatatype("AS");
                DateClass timestamp = new DateClass();
                timestamp.setDatatypeName("TIMESTAMP");
                timestamp.setSize("0");
                timestamp.setOpenBrace("(");
                timestamp.setClosedBrace(")");
                fnArgs.add(timestamp);
                caseFunc.setFunctionArguments(fnArgs);
                SelectColumn newSelCol = new SelectColumn();
                Vector<FunctionCalls> colExp = new Vector<FunctionCalls>();
                colExp.add(caseFunc);
                newSelCol.setColumnExpression(colExp);
                cs.setElseStatement(newSelCol);
            } else {
                cs.setElseStatement(convertedElseStatement);
            }
        }
        cs.setEndClause(this.endClause);
        cs.setDecodeFunction(this.decodeFunction);
        return cs;
    }

    public CaseStatement toDB2Select(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        CaseStatement cs = new CaseStatement();
        Vector<WhenStatement> v_when_statement_list = new Vector<WhenStatement>();
        cs.setCaseClause(this.caseClause);
        if (this.caseCondition != null) {
            cs.setCaseCondition(this.caseCondition.toDB2Select(to_sqs, from_sqs));
        }
        for (int i = 0; i < this.whenStatementList.size(); ++i) {
            v_when_statement_list.addElement(((WhenStatement)this.whenStatementList.elementAt(i)).toDB2Select(to_sqs, from_sqs));
        }
        if (this.subquery != null) {
            cs.setSubQuery(this.subquery.toDB2Select());
        }
        cs.setWhenStatementList(v_when_statement_list);
        cs.setElseClause(this.elseClause);
        if (this.elseStatement != null) {
            cs.setElseStatement(this.elseStatement.toDB2Select(to_sqs, from_sqs));
        }
        cs.setEndClause(this.endClause);
        cs.setDecodeFunction(this.decodeFunction);
        return cs;
    }

    public CaseStatement toMSSQLServerSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        CaseStatement cs = new CaseStatement();
        Vector<WhenStatement> v_when_statement_list = new Vector<WhenStatement>();
        cs.setCaseClause(this.caseClause);
        cs.setCaseCondition(this.caseCondition);
        if (this.caseCondition != null) {
            cs.setCaseCondition(this.caseCondition.toMSSQLServerSelect(to_sqs, from_sqs));
        }
        if (this.subquery != null) {
            cs.setSubQuery(this.subquery.toMSSQLServerSelect());
        }
        for (int i = 0; i < this.whenStatementList.size(); ++i) {
            v_when_statement_list.addElement(((WhenStatement)this.whenStatementList.elementAt(i)).toMSSQLServerSelect(to_sqs, from_sqs));
        }
        cs.setWhenStatementList(v_when_statement_list);
        cs.setElseClause(this.elseClause);
        if (this.elseStatement != null) {
            cs.setElseStatement(this.elseStatement.toMSSQLServerSelect(to_sqs, from_sqs));
        }
        cs.setEndClause(this.endClause);
        cs.setDecodeFunction(this.decodeFunction);
        return cs;
    }

    public CaseStatement toSybaseSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        CaseStatement cs = new CaseStatement();
        Vector<WhenStatement> v_when_statement_list = new Vector<WhenStatement>();
        cs.setCaseClause(this.caseClause);
        cs.setObjectContext(this.context);
        cs.setCaseCondition(this.caseCondition);
        if (this.caseCondition != null) {
            cs.setCaseCondition(this.caseCondition.toSybaseSelect(to_sqs, from_sqs));
        }
        for (int i = 0; i < this.whenStatementList.size(); ++i) {
            v_when_statement_list.addElement(((WhenStatement)this.whenStatementList.elementAt(i)).toSybaseSelect(to_sqs, from_sqs));
        }
        if (this.subquery != null) {
            cs.setSubQuery(this.subquery.toSybaseSelect());
        }
        cs.setWhenStatementList(v_when_statement_list);
        cs.setElseClause(this.elseClause);
        if (this.elseStatement != null) {
            cs.setElseStatement(this.elseStatement.toSybaseSelect(to_sqs, from_sqs));
        }
        cs.setEndClause(this.endClause);
        cs.setDecodeFunction(this.decodeFunction);
        return cs;
    }

    public CaseStatement toOracleSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (SwisSQLAPI.convertCaseToDecode) {
            StringBuffer sb = new StringBuffer();
            if (this.commentObj != null) {
                sb.append(this.commentObj.toString().trim() + " ");
            }
            sb.append("DECODE(");
            if (this.caseCondition == null) {
                if (this.subquery == null) {
                    sb.append("1 ,");
                    for (int i = 0; i < this.whenStatementList.size(); ++i) {
                        WhenStatement when_statement = ((WhenStatement)this.whenStatementList.elementAt(i)).toOracleSelect(to_sqs, from_sqs);
                        Vector whereItemList = new Vector();
                        Vector operator = new Vector();
                        this.curr_whereItem = when_statement.getWhenCondition().getWhereItems();
                        this.loadWhereItemsOperators(whereItemList, operator);
                        sb.append(" DECODE( " + whereItemList.size() + " ,");
                        for (int j = 0; j < whereItemList.size(); ++j) {
                            sb.append(this.convertToBooleanFunction((WhereItem)whereItemList.get(j)));
                            if (j == whereItemList.size() - 1) continue;
                            sb.append(" + ");
                        }
                        sb.append(" , 1 , 0 ) ");
                        sb.append(",");
                        sb.append(when_statement.getThenStatement().toString());
                        sb.append(",");
                    }
                } else {
                    SelectColumn caseSelectColumn = new SelectColumn();
                    Vector<SelectQueryStatement> items = new Vector<SelectQueryStatement>();
                    items.add(this.subquery);
                    caseSelectColumn.setColumnExpression(items);
                    SelectColumn decodeCondition = caseSelectColumn.toOracleSelect(null, null);
                    String singleQueryConvertedToMultipleQueryList = SelectQueryStatement.singleQueryConvertedToMultipleQueryList;
                    SelectQueryStatement.singleQueryConvertedToMultipleQueryList = null;
                    sb.append(decodeCondition.toString());
                    SelectQueryStatement.singleQueryConvertedToMultipleQueryList = singleQueryConvertedToMultipleQueryList;
                    sb.append(",");
                    for (int i = 0; i < this.whenStatementList.size(); ++i) {
                        WhenStatement when_statement = ((WhenStatement)this.whenStatementList.elementAt(i)).toOracleSelect(to_sqs, from_sqs);
                        Vector whereItemList = new Vector();
                        Vector operator = new Vector();
                        this.curr_whereItem = when_statement.getWhenCondition().getWhereItems();
                        if (this.curr_whereItem.get(0) != null) {
                            sb.append(this.curr_whereItem.get(0).toString());
                        }
                        sb.append(",");
                        sb.append(when_statement.getThenStatement().toString());
                        sb.append(",");
                    }
                }
            } else {
                WhereExpression decodeCondition = this.caseCondition.toOracleSelect(to_sqs, from_sqs);
                String singleQueryConvertedToMultipleQueryList = SelectQueryStatement.singleQueryConvertedToMultipleQueryList;
                SelectQueryStatement.singleQueryConvertedToMultipleQueryList = null;
                sb.append(decodeCondition.toString());
                SelectQueryStatement.singleQueryConvertedToMultipleQueryList = singleQueryConvertedToMultipleQueryList;
                sb.append(",");
                for (int i = 0; i < this.whenStatementList.size(); ++i) {
                    WhenStatement when_statement = ((WhenStatement)this.whenStatementList.elementAt(i)).toOracleSelect(to_sqs, from_sqs);
                    Vector whereItemList = new Vector();
                    Vector operator = new Vector();
                    this.curr_whereItem = when_statement.getWhenCondition().getWhereItems();
                    if (this.curr_whereItem.get(0) != null) {
                        sb.append(this.curr_whereItem.get(0).toString());
                    }
                    sb.append(",");
                    sb.append(when_statement.getThenStatement().toString());
                    sb.append(",");
                }
            }
            if (this.elseStatement != null) {
                sb.append(this.elseStatement.toOracleSelect(to_sqs, from_sqs));
            } else {
                sb.deleteCharAt(sb.toString().lastIndexOf(44));
            }
            sb.append(")");
            this.decodeFunction = sb.toString();
            return this;
        }
        CaseStatement cs = new CaseStatement();
        Vector<WhenStatement> v_when_statement_list = new Vector<WhenStatement>();
        cs.setCaseClause(this.caseClause);
        cs.setCommentClass(this.commentObj);
        if (this.caseCondition != null) {
            cs.setCaseCondition(this.caseCondition.toOracleSelect(to_sqs, from_sqs));
        }
        for (int i = 0; i < this.whenStatementList.size(); ++i) {
            v_when_statement_list.addElement(((WhenStatement)this.whenStatementList.elementAt(i)).toOracleSelect(to_sqs, from_sqs));
        }
        if (this.subquery != null) {
            cs.setSubQuery(this.subquery.toOracleSelect());
        }
        cs.setWhenStatementList(v_when_statement_list);
        cs.setElseClause(this.elseClause);
        if (this.elseStatement != null) {
            cs.setElseStatement(this.elseStatement.toOracleSelect(to_sqs, from_sqs));
        }
        cs.setEndClause(this.endClause);
        cs.setDecodeFunction(this.decodeFunction);
        return cs;
    }

    public CaseStatement toNetezzaSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        CaseStatement cs = new CaseStatement();
        Vector<WhenStatement> v_when_statement_list = new Vector<WhenStatement>();
        cs.setCaseClause(this.caseClause);
        if (this.caseCondition != null) {
            cs.setCaseCondition(this.caseCondition.toNetezzaSelect(to_sqs, from_sqs));
        }
        for (int i = 0; i < this.whenStatementList.size(); ++i) {
            v_when_statement_list.addElement(((WhenStatement)this.whenStatementList.elementAt(i)).toNetezzaSelect(to_sqs, from_sqs));
        }
        if (this.subquery != null) {
            cs.setSubQuery(this.subquery.toNetezzaSelect());
        }
        cs.setWhenStatementList(v_when_statement_list);
        cs.setElseClause(this.elseClause);
        if (this.elseStatement != null) {
            cs.setElseStatement(this.elseStatement.toNetezzaSelect(to_sqs, from_sqs));
        }
        cs.setEndClause(this.endClause);
        cs.setDecodeFunction(this.decodeFunction);
        return cs;
    }

    public void loadWhereItemsOperators(Vector whereItemList, Vector operatorList) {
        for (int i = 0; i < this.curr_whereItem.size(); ++i) {
            Object obj = this.curr_whereItem.get(i);
            if (obj instanceof WhereItem) {
                whereItemList.add(obj);
                continue;
            }
            if (!(obj instanceof WhereExpression)) continue;
            WhereExpression we = (WhereExpression)obj;
            we.loadWhereItemsOperators(whereItemList, operatorList);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.decodeFunction != null) {
            sb.append(this.decodeFunction);
        } else {
            int j;
            ++SelectQueryStatement.beautyTabCount;
            if (this.commentObj != null) {
                sb.append("\n");
                for (j = 0; j < SelectQueryStatement.beautyTabCount; ++j) {
                    sb.append("\t");
                }
                sb.append(this.commentObj.toString().trim());
            }
            sb.append("\n");
            for (j = 0; j < SelectQueryStatement.beautyTabCount; ++j) {
                sb.append("\t");
            }
            sb.append(this.caseClause);
            if (this.caseCondition != null) {
                this.caseCondition.setObjectContext(this.context);
                sb.append(" " + this.caseCondition.toString());
            }
            if (this.subquery != null) {
                this.subquery.setObjectContext(this.context);
                sb.append("\n");
                for (j = 0; j < SelectQueryStatement.beautyTabCount; ++j) {
                    sb.append("\t");
                }
                sb.append("(");
                sb.append(" " + this.subquery.toString());
                sb.append("\n");
                for (j = 0; j < SelectQueryStatement.beautyTabCount; ++j) {
                    sb.append("\t");
                }
                sb.append(")");
            }
            ++SelectQueryStatement.beautyTabCount;
            for (int i_count = 0; i_count < this.whenStatementList.size(); ++i_count) {
                ((WhenStatement)this.whenStatementList.elementAt(i_count)).setObjectContext(this.context);
                sb.append("\n");
                for (int j2 = 0; j2 < SelectQueryStatement.beautyTabCount; ++j2) {
                    sb.append("\t");
                }
                sb.append(" " + this.whenStatementList.elementAt(i_count).toString());
            }
            if (this.elseClause != null) {
                sb.append("\n");
                for (j = 0; j < SelectQueryStatement.beautyTabCount; ++j) {
                    sb.append("\t");
                }
                sb.append(" " + this.elseClause);
                this.elseStatement.setObjectContext(this.context);
                sb.append(" " + this.elseStatement.toString());
            }
            --SelectQueryStatement.beautyTabCount;
            sb.append("\n");
            for (j = 0; j < SelectQueryStatement.beautyTabCount; ++j) {
                sb.append("\t");
            }
            sb.append(" " + this.endClause.toString());
            --SelectQueryStatement.beautyTabCount;
        }
        return sb.toString();
    }

    public CaseStatement toInformixSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        StringBuffer sb = new StringBuffer();
        sb.append("DECODE(");
        if (this.caseCondition == null) {
            if (this.subquery == null) {
                sb.append("1 ,");
                for (int i = 0; i < this.whenStatementList.size(); ++i) {
                    WhenStatement when_statement = ((WhenStatement)this.whenStatementList.elementAt(i)).toInformixSelect(to_sqs, from_sqs);
                    Vector whereItemList = new Vector();
                    Vector operator = new Vector();
                    this.curr_whereItem = when_statement.getWhenCondition().getWhereItems();
                    this.loadWhereItemsOperators(whereItemList, operator);
                    sb.append(" DECODE( " + whereItemList.size() + " ,");
                    for (int j = 0; j < whereItemList.size(); ++j) {
                        sb.append(this.convertToBooleanFunction((WhereItem)whereItemList.get(j)));
                        if (j == whereItemList.size() - 1) continue;
                        sb.append(" + ");
                    }
                    sb.append(" , 1 , 0 ) ");
                    sb.append(",");
                    sb.append(when_statement.getThenStatement().toString());
                    sb.append(",");
                }
            } else {
                SelectColumn caseSelectColumn = new SelectColumn();
                Vector<SelectQueryStatement> items = new Vector<SelectQueryStatement>();
                items.add(this.subquery);
                caseSelectColumn.setColumnExpression(items);
                SelectColumn decodeCondition = caseSelectColumn.toInformixSelect(null, null);
                String singleQueryConvertedToMultipleQueryList = SelectQueryStatement.singleQueryConvertedToMultipleQueryList;
                SelectQueryStatement.singleQueryConvertedToMultipleQueryList = null;
                sb.append(decodeCondition.toString());
                SelectQueryStatement.singleQueryConvertedToMultipleQueryList = singleQueryConvertedToMultipleQueryList;
                sb.append(",");
                for (int i = 0; i < this.whenStatementList.size(); ++i) {
                    WhenStatement when_statement = ((WhenStatement)this.whenStatementList.elementAt(i)).toInformixSelect(to_sqs, from_sqs);
                    Vector whereItemList = new Vector();
                    Vector operator = new Vector();
                    this.curr_whereItem = when_statement.getWhenCondition().getWhereItems();
                    if (this.curr_whereItem.get(0) != null) {
                        sb.append(this.curr_whereItem.get(0).toString());
                    }
                    sb.append(",");
                    sb.append(when_statement.getThenStatement().toString());
                    sb.append(",");
                }
            }
        } else {
            sb.append(this.caseCondition.toInformixSelect(to_sqs, from_sqs));
            sb.append(",");
            for (int i = 0; i < this.whenStatementList.size(); ++i) {
                WhenStatement when_statement = ((WhenStatement)this.whenStatementList.elementAt(i)).toInformixSelect(to_sqs, from_sqs);
                Vector whereItemList = new Vector();
                Vector operator = new Vector();
                this.curr_whereItem = when_statement.getWhenCondition().getWhereItems();
                if (this.curr_whereItem.get(0) != null) {
                    sb.append(this.curr_whereItem.get(0).toString());
                }
                sb.append(",");
                sb.append(when_statement.getThenStatement().toString());
                sb.append(",");
            }
        }
        if (this.elseStatement != null) {
            sb.append(this.elseStatement.toInformixSelect(to_sqs, from_sqs));
        } else {
            sb.deleteCharAt(sb.toString().lastIndexOf(44));
        }
        sb.append(")");
        this.decodeFunction = sb.toString();
        return this;
    }

    public void replaceRownumTableColumn(Object newColumn) throws ConvertException {
        if (this.caseCondition != null) {
            this.caseCondition.replaceRownumTableColumn(newColumn);
        }
        for (int i = 0; i < this.whenStatementList.size(); ++i) {
            WhenStatement whenSt = (WhenStatement)this.whenStatementList.get(i);
            if (whenSt.getThenStatement() != null) {
                whenSt.getThenStatement().replaceRownumTableColumn(newColumn);
            }
            if (whenSt.getWhenCondition() == null) continue;
            whenSt.getWhenCondition().replaceRownumTableColumn(newColumn);
        }
        if (this.elseStatement != null) {
            this.elseStatement.replaceRownumTableColumn(newColumn);
        }
    }
}

