/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.select;

import com.adventnet.swissqlapi.SwisSQLAPI;
import com.adventnet.swissqlapi.config.SwisSQLOptions;
import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.statement.CommentClass;
import com.adventnet.swissqlapi.sql.statement.SwisSQLStatement;
import com.adventnet.swissqlapi.sql.statement.insert.ValuesClause;
import com.adventnet.swissqlapi.sql.statement.select.ForUpdateStatement;
import com.adventnet.swissqlapi.sql.statement.select.FromClause;
import com.adventnet.swissqlapi.sql.statement.select.QueryPartitionClause;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.SelectStatement;
import com.adventnet.swissqlapi.sql.statement.select.SetOperatorClause;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereExpression;
import com.adventnet.swissqlapi.sql.statement.select.WhereItem;
import com.adventnet.swissqlapi.sql.statement.select.WithStatement;
import com.adventnet.swissqlapi.util.SwisSQLUtils;
import com.adventnet.swissqlapi.util.database.MetadataInfoUtil;
import com.adventnet.swissqlapi.util.misc.CustomizeUtil;
import com.adventnet.swissqlapi.util.misc.StringFunctions;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class FromTable {
    private Object tableName;
    private String aliasName;
    private String joinClause;
    private String tableKeyword;
    private Vector joinExpression;
    private Vector UsingList;
    private String onOrUsingJoin;
    private String outer;
    private String outerOpenBrace;
    private String outerClosedBrace;
    private boolean isAS;
    private SetOperatorClause setOperatorClauseForFullJoin;
    private String updateLock;
    private String holdLock;
    private UserObjectContext context = null;
    private boolean isTenroxRequirement = false;
    private String fromClauseOpenBraces;
    private String fromClauseClosedBraces;
    private FromClause fc;
    private String lock;
    private String with;
    private String lockTableStatement;
    private String indexHint;
    private String origTableName;
    private ArrayList setOperatorClauseListForSubQuery = new ArrayList();
    private CommentClass commentObj;
    private QueryPartitionClause queryPartitionClause = null;
    private FromTable crossJoinForPartitionClause = null;
    private SelectQueryStatement crossJoinSelectQuery = null;
    private WhereExpression crossJoinExpression = null;
    private ArrayList columnAliasList;
    private ArrayList rowValuesList = new ArrayList();

    public void setObjectContext(UserObjectContext context) {
        this.context = context;
    }

    public void setIndexHint(String s) {
        this.indexHint = s;
    }

    public void setSetOperatorClause(SetOperatorClause setOperatorClauseForFullJoin) {
        this.setOperatorClauseForFullJoin = setOperatorClauseForFullJoin;
    }

    public void setTableName(Object tn) {
        this.tableName = tn;
    }

    public void setAliasName(String an) {
        this.aliasName = an;
    }

    public void setIsAS(boolean is) {
        this.isAS = is;
    }

    public void setJoinClause(String jc) {
        this.joinClause = jc;
    }

    public void setOnOrUsingJoin(String s_onou) {
        this.onOrUsingJoin = s_onou;
    }

    public void setJoinExpression(Vector v_je) {
        this.joinExpression = v_je;
    }

    public void setUsingList(Vector v_ul) {
        this.UsingList = v_ul;
    }

    public void setLockTableStatement(String lockTableStatement) {
        this.lockTableStatement = lockTableStatement;
    }

    public void setWith(String with) {
        this.with = with;
    }

    public void setLock(String lock) {
        this.lock = lock;
    }

    public void setTableKeyword(String s_tk) {
        this.tableKeyword = s_tk;
    }

    public void setOuter(String outer) {
        this.outer = outer;
    }

    public void setOuterOpenBrace(String outerOpenBrace) {
        this.outerOpenBrace = outerOpenBrace;
    }

    public void setOuterClosedBrace(String outerClosedBrace) {
        this.outerClosedBrace = outerClosedBrace;
    }

    public void setUpdateLock(String updateLock) {
        this.updateLock = updateLock;
    }

    public void setHoldLock(String lock) {
        this.holdLock = lock;
    }

    public void setFromClauseOpenBraces(String fromClauseOpenBraces) {
        this.fromClauseOpenBraces = fromClauseOpenBraces;
    }

    public void setFromClauseClosedBraces(String fromClauseClosedBraces) {
        this.fromClauseClosedBraces = fromClauseClosedBraces;
    }

    public void setFromClause(FromClause fc) {
        this.fc = fc;
    }

    public void setColumnAliasList(ArrayList columnAliasList) {
        this.columnAliasList = columnAliasList;
    }

    public void setOrigTableName(String origTableName) {
        this.origTableName = origTableName;
    }

    public void setSetOperatorClauseListForSubQuery(ArrayList socList) {
        this.setOperatorClauseListForSubQuery = socList;
    }

    public void setQueryPartitionClause(QueryPartitionClause qpc) {
        this.queryPartitionClause = qpc;
    }

    public void setCrossJoinForPartitionClause(FromTable crossJoinForPartitionClause) {
        this.crossJoinForPartitionClause = crossJoinForPartitionClause;
    }

    public void setCrossJoinSelectQuery(SelectQueryStatement crossJoinSelectQuery) {
        this.crossJoinSelectQuery = crossJoinSelectQuery;
    }

    public void setCrossJoinExpression(WhereExpression crossJoinExpression) {
        this.crossJoinExpression = crossJoinExpression;
    }

    public void setCommentClass(CommentClass commentObj) {
        this.commentObj = commentObj;
    }

    public Object getTableName() {
        return this.tableName;
    }

    public String getOrigTableName() {
        return this.origTableName;
    }

    public String getLockTableStatement() {
        return this.lockTableStatement;
    }

    public String getWith() {
        return this.with;
    }

    public String getLock() {
        return this.lock;
    }

    public String getTableKeyword() {
        return this.tableKeyword;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public boolean getIsAS() {
        return this.isAS;
    }

    public String getJoinClause() {
        return this.joinClause;
    }

    public Vector getJoinExpression() {
        return this.joinExpression;
    }

    public String getOuter() {
        return this.outer;
    }

    public String getOuterOpenBrace() {
        return this.outerOpenBrace;
    }

    public String getOuterClosedBrace() {
        return this.outerClosedBrace;
    }

    public String getFromClauseOpenBraces() {
        return this.fromClauseOpenBraces;
    }

    public String getUpdateLock() {
        return this.updateLock;
    }

    public String getFromClauseClosedBraces() {
        return this.fromClauseClosedBraces;
    }

    public FromClause getFromClause() {
        return this.fc;
    }

    public String getOnOrUsingJoin() {
        return this.onOrUsingJoin;
    }

    public Vector getUsingList() {
        return this.UsingList;
    }

    public ArrayList getSetOperatorClauseListForSubQuery() {
        return this.setOperatorClauseListForSubQuery;
    }

    public QueryPartitionClause getQueryPartitionClause() {
        return this.queryPartitionClause;
    }

    public FromTable getCrossJoinForPartitionClause() {
        return this.crossJoinForPartitionClause;
    }

    public SelectQueryStatement getCrossJoinSelectQuery() {
        return this.crossJoinSelectQuery;
    }

    public WhereExpression getCrossJoinExpression() {
        return this.crossJoinExpression;
    }

    public CommentClass getCommentClass() {
        return this.commentObj;
    }

    public ArrayList getColumnAliasList() {
        return this.columnAliasList;
    }

    public FromTable convert(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs, int database) throws ConvertException {
        if (database == 8) {
            return this.toANSISelect(to_sqs, from_sqs);
        }
        if (database == 3) {
            return this.toDB2Select(to_sqs, from_sqs);
        }
        if (database == 2) {
            return this.toMSSQLServerSelect(to_sqs, from_sqs);
        }
        if (database == 7) {
            return this.toSybaseSelect(to_sqs, from_sqs);
        }
        if (database == 5) {
            return this.toMySQLSelect(to_sqs, from_sqs);
        }
        if (database == 4) {
            return this.toPostgreSQLSelect(to_sqs, from_sqs);
        }
        if (database == 6) {
            return this.toInformixSelect(to_sqs, from_sqs);
        }
        if (database == 1) {
            return this.toOracleSelect(to_sqs, from_sqs);
        }
        if (database == 11) {
            return this.toNetezzaSelect(to_sqs, from_sqs);
        }
        if (database == 12) {
            return this.toTeradataSelect(to_sqs, from_sqs);
        }
        return null;
    }

    public FromTable toMySQLSelect(SelectQueryStatement vembuSQS, SelectQueryStatement vendorSQS) throws ConvertException {
        FromTable ft = new FromTable();
        boolean isFullJoin = false;
        if (this.joinClause != null) {
            WhereExpression we;
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL JOIN")) {
                throw new ConvertException("Conversion failure..Natural join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL LEFT JOIN")) {
                throw new ConvertException("Conversion failure..Natural left Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL RIGHT JOIN")) {
                throw new ConvertException("Conversion failure..Natural right Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL LEFT OUTER JOIN")) {
                throw new ConvertException("Conversion failure..Natural left Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL RIGHT OUTER JOIN")) {
                throw new ConvertException("Conversion failure..Natural right join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("KEY JOIN")) {
                throw new ConvertException("Conversion failure..Key join is not supported");
            }
            if (this.joinClause.trim().equalsIgnoreCase("OUTER")) {
                ft.setJoinClause("OUTER JOIN");
            } else if (this.joinClause.trim().equalsIgnoreCase("FULL JOIN") || this.joinClause.trim().equalsIgnoreCase("FULL OUTER JOIN")) {
                FromClause fc = new FromClause();
                FromTable newFromTable = new FromTable();
                newFromTable.setAliasName(this.aliasName);
                newFromTable.setIsAS(this.isAS);
                newFromTable.setJoinClause("RIGHT OUTER JOIN");
                newFromTable.setJoinExpression(this.joinExpression);
                newFromTable.setOnOrUsingJoin(this.onOrUsingJoin);
                newFromTable.setTableKeyword(this.tableKeyword);
                newFromTable.setTableName(this.tableName);
                newFromTable.setUsingList(this.UsingList);
                if (vendorSQS.getFromClause() != null) {
                    fc.setFromClause("FROM");
                    Vector fromList = vendorSQS.getFromClause().getFromItemList();
                    Vector<FromTable> newFromList = new Vector<FromTable>();
                    for (int i = 0; i < fromList.size(); ++i) {
                        if (fromList.get(i) instanceof FromTable) {
                            FromTable getFT = (FromTable)fromList.get(i);
                            if (getFT != null && getFT.equals(this)) {
                                newFromList.add(newFromTable);
                                continue;
                            }
                            if (!(fromList.get(i) instanceof FromTable)) continue;
                            newFromList.add(((FromTable)fromList.get(i)).toMySQLSelect(vembuSQS, vendorSQS));
                            continue;
                        }
                        if (!(fromList.get(i) instanceof FromClause)) continue;
                        ((FromClause)fromList.get(i)).toMySQLSelect(vembuSQS, vendorSQS);
                    }
                    fc.setFromItemList(newFromList);
                }
                SelectQueryStatement sqs = new SelectQueryStatement();
                sqs.setFromClause(fc);
                if (vendorSQS.getSelectStatement() != null) {
                    sqs.setSelectStatement(vendorSQS.getSelectStatement().toMySQLSelect(vembuSQS, vendorSQS));
                }
                if (vendorSQS.getFetchClause() != null) {
                    sqs.setFetchClause(vendorSQS.getFetchClause().toMySQLSelect(vembuSQS, vendorSQS));
                }
                if (vendorSQS.getForUpdateStatement() != null) {
                    sqs.setForUpdateStatement(null);
                }
                if (vendorSQS.getGroupByStatement() != null) {
                    sqs.setGroupByStatement(vendorSQS.getGroupByStatement().toMySQLSelect(vembuSQS, vendorSQS));
                }
                if (vendorSQS.getHavingStatement() != null) {
                    sqs.setHavingStatement(vendorSQS.getHavingStatement().toMySQLSelect(vembuSQS, vendorSQS));
                }
                if (vendorSQS.getHierarchicalQueryClause() != null) {
                    sqs.setHierarchicalQueryClause(null);
                }
                if (vendorSQS.getLimitClause() != null) {
                    sqs.setLimitClause(vendorSQS.getLimitClause().toMySQLSelect(vembuSQS, vendorSQS));
                }
                if (vendorSQS.getSetOperatorClause() != null) {
                    sqs.setSetOperatorClause(null);
                }
                if (vendorSQS.getWhereExpression() != null) {
                    sqs.setWhereExpression(vendorSQS.getWhereExpression().toMySQLSelect(vembuSQS, vendorSQS));
                }
                this.setOperatorClauseForFullJoin = new SetOperatorClause();
                this.setOperatorClauseForFullJoin.setSelectQueryStatement(sqs);
                this.setOperatorClauseForFullJoin.setSetClause("UNION");
                if (vendorSQS.getWhereExpression() != null) {
                    this.setOperatorClauseForFullJoin.setWhereExpression(vendorSQS.getWhereExpression().toMySQLSelect(vembuSQS, vendorSQS));
                    vendorSQS.setWhereExpression(null);
                }
                ft.setSetOperatorClause(this.setOperatorClauseForFullJoin);
                isFullJoin = true;
            }
            if (this.onOrUsingJoin == null && this.joinExpression != null) {
                ft.setOnOrUsingJoin("ON");
                we = ((WhereExpression)this.joinExpression.elementAt(0)).toMySQLSelect(vembuSQS, vendorSQS);
                Vector<WhereExpression> v = new Vector<WhereExpression>();
                v.addElement(we);
                ft.setJoinExpression(v);
            } else if (this.joinExpression != null) {
                ft.setOnOrUsingJoin(this.onOrUsingJoin);
                we = (WhereExpression)this.joinExpression.elementAt(0);
                Vector operatorList = we.getOperator();
                we.setOperator(operatorList);
                we.toMySQLSelect(vembuSQS, vendorSQS);
                Vector<WhereExpression> v = new Vector<WhereExpression>();
                v.addElement(we);
                ft.setJoinExpression(v);
            }
            ft.setOnOrUsingJoin(this.onOrUsingJoin);
            if (this.UsingList != null) {
                Vector<TableColumn> v = new Vector<TableColumn>();
                for (int i = 0; i < this.UsingList.size(); ++i) {
                    if (this.UsingList.elementAt(i) instanceof TableColumn) {
                        v.addElement(((TableColumn)this.UsingList.elementAt(i)).toMySQLSelect(vembuSQS, vendorSQS));
                        continue;
                    }
                    v.addElement((TableColumn)this.UsingList.elementAt(i));
                }
                ft.setUsingList(v);
            }
            if (!isFullJoin) {
                ft.setJoinClause(this.joinClause);
            } else {
                ft.setJoinClause("LEFT OUTER JOIN");
            }
            if (this.joinClause.trim().equalsIgnoreCase("JOIN")) {
                ft.setJoinClause("INNER JOIN");
            }
        }
        if (this.getOuter() != null) {
            ft.setOuter(this.outer);
            if (this.getOuterOpenBrace() != null) {
                ft.setOuterOpenBrace(this.outerOpenBrace);
            }
            if (this.outerClosedBrace != null) {
                ft.setOuterClosedBrace(this.outerClosedBrace);
            }
        }
        if (this.outerClosedBrace != null) {
            ft.setOuterClosedBrace(this.outerClosedBrace);
        }
        if (this.tableName != null) {
            if (this.tableName instanceof SelectQueryStatement) {
                ft.setTableName(((SelectQueryStatement)this.tableName).toMySQLSelect());
                if (this.aliasName == null) {
                    ft.setAliasName("SwisSQL_ALIAS" + (this.getFromTableIndexFromFromItemList(vendorSQS) + 1));
                }
            } else {
                if (this.tableName instanceof FunctionCalls) {
                    throw new ConvertException();
                }
                if (this.tableName instanceof WithStatement) {
                    ft.setTableName(((WithStatement)this.tableName).toMySQL());
                } else if (this.tableName instanceof FromClause) {
                    ft.setTableName(((FromClause)this.tableName).toMySQLSelect(vembuSQS, vendorSQS));
                } else {
                    int startIndex;
                    String dataBaseTableName;
                    String table_Name_String = (String)this.tableName;
                    int atIndex = table_Name_String.indexOf("@");
                    ft.setTableName(StringFunctions.replaceFirst(".", "..", (String)this.tableName));
                    Vector<String> tokenVector = new Vector<String>();
                    String table_Name = (String)this.tableName;
                    StringTokenizer st = new StringTokenizer(table_Name, ".");
                    int count2 = 0;
                    while (st.hasMoreTokens()) {
                        tokenVector.add(st.nextToken());
                        ++count2;
                    }
                    if (count2 == 1 && atIndex != -1) {
                        dataBaseTableName = (String)tokenVector.elementAt(0);
                        String sqlTableName = dataBaseTableName.substring(0, atIndex);
                        String sqlDataBaseName = dataBaseTableName.substring(atIndex + 1);
                        String sqlDataBaseAndTableName = sqlDataBaseName + "." + sqlTableName;
                        ft.setTableName(sqlDataBaseAndTableName);
                    } else if (count2 == 2 && atIndex != -1) {
                        dataBaseTableName = (String)tokenVector.elementAt(1);
                        int tableAtIndex = dataBaseTableName.indexOf("@");
                        String sqlTableName = dataBaseTableName.substring(0, tableAtIndex);
                        String sqlDataBaseName = dataBaseTableName.substring(tableAtIndex + 1);
                        String sqlDataBaseAndTableName = sqlDataBaseName + "." + (String)tokenVector.elementAt(0) + "." + sqlTableName;
                        ft.setTableName(sqlDataBaseAndTableName);
                    }
                    String tempTableName = (String)ft.getTableName();
                    String tableNameSubString = "";
                    String quotedIdenStartString = "[";
                    String quotedIdenEndString = "]";
                    if (tempTableName.startsWith("\"")) {
                        quotedIdenStartString = "\"";
                    }
                    if (tempTableName.endsWith("\"")) {
                        quotedIdenEndString = "\"";
                    }
                    if ((startIndex = tempTableName.indexOf(quotedIdenStartString)) != -1) {
                        while (startIndex != -1) {
                            if (startIndex == 0) {
                                tableNameSubString = tempTableName.substring(1);
                                tableNameSubString = "`" + tableNameSubString;
                                tempTableName = tableNameSubString = StringFunctions.replaceFirst("`", quotedIdenEndString, tableNameSubString);
                                startIndex = tableNameSubString.indexOf(quotedIdenStartString);
                                continue;
                            }
                            tableNameSubString = tempTableName.substring(0, startIndex);
                            tableNameSubString = tableNameSubString + "`";
                            tableNameSubString = tableNameSubString + tempTableName.substring(startIndex + 1);
                            tempTableName = tableNameSubString = StringFunctions.replaceFirst("`", quotedIdenEndString, tableNameSubString);
                            startIndex = tableNameSubString.indexOf(quotedIdenStartString);
                        }
                        ft.setTableName(tableNameSubString);
                    }
                }
            }
        }
        ft.setIsAS(this.isAS);
        if (this.aliasName != null) {
            if (this.aliasName.charAt(0) == '\'') {
                ft.setAliasName(this.aliasName.replace('\'', ' ').trim());
            } else if (this.aliasName.charAt(0) == '\"') {
                ft.setAliasName(this.aliasName.replace('\"', ' ').trim());
            } else {
                ft.setAliasName(this.aliasName);
            }
        }
        return ft;
    }

    public FromTable toPostgreSQLSelect(SelectQueryStatement vembuSQS, SelectQueryStatement vendorSQS) throws ConvertException {
        FromTable ft = new FromTable();
        if (this.joinClause != null) {
            WhereExpression we;
            if (this.joinClause.trim().equalsIgnoreCase("KEY JOIN")) {
                throw new ConvertException("Conversion failure..Key join is not supported");
            }
            if (this.onOrUsingJoin == null && this.joinExpression != null) {
                ft.setOnOrUsingJoin("ON");
                we = ((WhereExpression)this.joinExpression.elementAt(0)).toPostgreSQLSelect(vembuSQS, vendorSQS);
                Vector<WhereExpression> v = new Vector<WhereExpression>();
                v.addElement(we);
                ft.setJoinExpression(v);
            } else if (this.joinExpression != null) {
                ft.setOnOrUsingJoin(this.onOrUsingJoin);
                we = (WhereExpression)this.joinExpression.elementAt(0);
                Vector operatorList = we.getOperator();
                for (int i = 0; i < operatorList.size(); ++i) {
                    if (!(operatorList.elementAt(i) instanceof String) || !((String)operatorList.get(i)).equalsIgnoreCase("AND")) continue;
                    operatorList.setElementAt("ON", i);
                }
                we.setOperator(operatorList);
                we.toPostgreSQLSelect(vembuSQS, vendorSQS);
                Vector<WhereExpression> v = new Vector<WhereExpression>();
                v.addElement(we);
                ft.setJoinExpression(v);
            }
            ft.setOnOrUsingJoin(this.onOrUsingJoin);
            if (this.UsingList != null) {
                Vector<TableColumn> v = new Vector<TableColumn>();
                for (int i = 0; i < this.UsingList.size(); ++i) {
                    if (this.UsingList.elementAt(i) instanceof TableColumn) {
                        v.addElement(((TableColumn)this.UsingList.elementAt(i)).toPostgreSQLSelect(vembuSQS, vendorSQS));
                        continue;
                    }
                    v.addElement((TableColumn)this.UsingList.elementAt(i));
                }
                ft.setUsingList(v);
            }
        }
        if (this.getOuter() != null) {
            ft.setOuter(this.outer);
            if (this.getOuterOpenBrace() != null) {
                ft.setOuterOpenBrace(this.outerOpenBrace);
            }
            if (this.outerClosedBrace != null) {
                ft.setOuterClosedBrace(this.outerClosedBrace);
            }
        }
        if (this.outerClosedBrace != null) {
            ft.setOuterClosedBrace(this.outerClosedBrace);
        }
        if (this.tableName != null) {
            if (this.tableName instanceof SelectQueryStatement) {
                if (!this.setOperatorClauseListForSubQuery.isEmpty()) {
                    this.buildSetOperatorClauseForSubQuery((SelectQueryStatement)this.tableName);
                }
                ft.setTableName(((SelectQueryStatement)this.tableName).toPostgreSQLSelect());
            } else {
                if (this.tableName instanceof FunctionCalls) {
                    throw new ConvertException("Function calls in the place of Table name yet to be supported");
                }
                if (this.tableName instanceof WithStatement) {
                    ft.setTableName(((WithStatement)this.tableName).toPostgreSQL());
                } else if (this.tableName instanceof FromClause) {
                    ft.setTableName(((FromClause)this.tableName).toPostgreSQLSelect(vembuSQS, vendorSQS));
                } else if (((String)this.tableName).indexOf(".") > 0) {
                    String table_name = (String)this.tableName;
                    if (table_name.indexOf("..") > 0) {
                        ft.setTableName(table_name.substring(table_name.indexOf("..") + 2, table_name.length()));
                    } else {
                        String dataBaseTableName;
                        String table_Name_String = (String)this.tableName;
                        int atIndex = table_Name_String.indexOf("@");
                        ft.setTableName(table_name.substring(table_name.indexOf(".") + 1, table_name.length()));
                        Vector<String> tokenVector = new Vector<String>();
                        String table_Name = (String)this.tableName;
                        StringTokenizer st = new StringTokenizer(table_Name, ".");
                        int count2 = 0;
                        while (st.hasMoreTokens()) {
                            tokenVector.add(st.nextToken());
                            ++count2;
                        }
                        if (count2 == 1 && atIndex != -1) {
                            dataBaseTableName = (String)tokenVector.elementAt(0);
                            String sqlTableName = dataBaseTableName.substring(0, atIndex);
                            String sqlDataBaseName = dataBaseTableName.substring(atIndex + 1);
                            String sqlDataBaseAndTableName = sqlTableName;
                            ft.setTableName(sqlDataBaseAndTableName);
                        } else if (count2 == 2 && atIndex != -1) {
                            dataBaseTableName = (String)tokenVector.elementAt(1);
                            int tableAtIndex = dataBaseTableName.indexOf("@");
                            String sqlTableName = dataBaseTableName.substring(0, tableAtIndex);
                            String sqlDataBaseName = dataBaseTableName.substring(tableAtIndex + 1);
                            String sqlDataBaseAndTableName = sqlTableName;
                            ft.setTableName(sqlDataBaseAndTableName);
                        }
                        if (((String)this.tableName).indexOf("[") >= 0) {
                            String tempTableName = (String)ft.getTableName();
                            String tableNameSubString = "";
                            int startIndex = tempTableName.indexOf("[");
                            if (startIndex != -1) {
                                while (startIndex != -1) {
                                    if (startIndex == 0) {
                                        tableNameSubString = tempTableName.substring(1);
                                        tableNameSubString = "\"" + tableNameSubString;
                                        tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                                        startIndex = tableNameSubString.indexOf("[");
                                        continue;
                                    }
                                    tableNameSubString = tempTableName.substring(0, startIndex);
                                    tableNameSubString = tableNameSubString + "\"";
                                    tableNameSubString = tableNameSubString + tempTableName.substring(startIndex + 1);
                                    tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                                    startIndex = tableNameSubString.indexOf("[");
                                }
                                ft.setTableName(tableNameSubString);
                            }
                        }
                    }
                } else {
                    if (((String)this.tableName).indexOf("[") == 0) {
                        String tempTableName = (String)this.tableName;
                        String tableNameSubString = "";
                        int startIndex = tempTableName.indexOf("[");
                        if (startIndex != -1) {
                            while (startIndex != -1) {
                                if (startIndex == 0) {
                                    tableNameSubString = tempTableName.substring(1);
                                    tableNameSubString = "\"" + tableNameSubString;
                                    tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                                    startIndex = tableNameSubString.indexOf("[");
                                    continue;
                                }
                                tableNameSubString = tempTableName.substring(0, startIndex);
                                tableNameSubString = tableNameSubString + "\"";
                                tableNameSubString = tableNameSubString + tempTableName.substring(startIndex + 1);
                                tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                                startIndex = tableNameSubString.indexOf("[");
                            }
                            ft.setTableName(tableNameSubString);
                        }
                    } else {
                        ft.setTableName(this.tableName);
                    }
                    String table_Name_String = (String)this.tableName;
                    int atIndex = table_Name_String.indexOf("@");
                    Vector<String> tokenVector = new Vector<String>();
                    String table_Name = (String)this.tableName;
                    StringTokenizer st = new StringTokenizer(table_Name, ".");
                    int count3 = 0;
                    while (st.hasMoreTokens()) {
                        tokenVector.add(st.nextToken());
                        ++count3;
                    }
                    if (count3 == 1 && atIndex != -1) {
                        String dataBaseTableName = (String)tokenVector.elementAt(0);
                        String sqlTableName = dataBaseTableName.substring(0, atIndex);
                        String sqlDataBaseName = dataBaseTableName.substring(atIndex + 1);
                        String sqlDataBaseAndTableName = sqlTableName;
                        ft.setTableName(sqlTableName);
                    }
                    String tempTableName = (String)ft.getTableName();
                    String tableNameSubString = "";
                    int startIndex = tempTableName.indexOf("[");
                    if (startIndex != -1) {
                        if (startIndex == 0) {
                            tableNameSubString = tempTableName.substring(1);
                            tableNameSubString = "\"" + tableNameSubString;
                            tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                        }
                        ft.setTableName(tempTableName);
                    }
                }
            }
        }
        ft.setIsAS(this.isAS);
        if (this.aliasName != null) {
            if (this.aliasName.charAt(0) == '\'') {
                ft.setAliasName(this.aliasName.replace('\'', '\"'));
            } else {
                ft.setAliasName(this.aliasName);
            }
        } else if (this.tableName instanceof SelectQueryStatement) {
            SelectQueryStatement sqs = (SelectQueryStatement)this.tableName;
            if (sqs.getSetOperatorClause() != null) {
                SetOperatorClause soc = sqs.getSetOperatorClause();
                if (soc == null || soc.getSetClause() == null || !soc.getSetClause().toUpperCase().startsWith("UNION") && !soc.getSetClause().toUpperCase().startsWith("MINUS") && !soc.getSetClause().toUpperCase().startsWith("INTERSECT") && !soc.getSetClause().toUpperCase().startsWith("EXCEPT")) {
                    ft.setAliasName("SwisSQL_ALIAS" + (this.getFromTableIndexFromFromItemList(vendorSQS) + 1));
                }
            } else {
                ft.setAliasName("SwisSQL_ALIAS" + (this.getFromTableIndexFromFromItemList(vendorSQS) + 1));
            }
        }
        if (this.joinClause != null && this.joinClause.trim().equalsIgnoreCase("NATURAL JOIN")) {
            ft.setOnOrUsingJoin(null);
        }
        ft.setJoinClause(this.joinClause);
        return ft;
    }

    public FromTable toDB2Select(SelectQueryStatement vembuSQS, SelectQueryStatement vendorSQS) throws ConvertException {
        FromTable ft = new FromTable();
        if (this.joinClause != null) {
            WhereExpression we;
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL JOIN")) {
                throw new ConvertException("Conversion failure..Natural join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("CROSS JOIN")) {
                this.joinClause = "INNER JOIN";
                this.setOnOrUsingJoin("ON");
                Vector<WhereExpression> newWhereItems = new Vector<WhereExpression>();
                WhereItem newWhereItem = new WhereItem();
                WhereColumn newWhereColumn = new WhereColumn();
                Vector<String> whereColumnItems = new Vector<String>();
                whereColumnItems.add("1");
                newWhereColumn.setColumnExpression(whereColumnItems);
                newWhereItem.setLeftWhereExp(newWhereColumn);
                newWhereItem.setRightWhereExp(newWhereColumn);
                newWhereItem.setOperator("=");
                WhereExpression newWhereExpression = new WhereExpression();
                newWhereExpression.addWhereItem(newWhereItem);
                newWhereItems.add(newWhereExpression);
                this.setJoinExpression(newWhereItems);
            } else {
                if (this.joinClause.trim().equalsIgnoreCase("NATURAL LEFT JOIN")) {
                    throw new ConvertException("Conversion failure..Natural left Outer join can't be converted");
                }
                if (this.joinClause.trim().equalsIgnoreCase("NATURAL RIGHT JOIN")) {
                    throw new ConvertException("Conversion failure..Natural right Outer join can't be converted");
                }
                if (this.joinClause.trim().equalsIgnoreCase("NATURAL LEFT OUTER JOIN")) {
                    throw new ConvertException("Conversion failure..Natural left Outer join can't be converted");
                }
                if (this.joinClause.trim().equalsIgnoreCase("NATURAL RIGHT OUTER JOIN")) {
                    throw new ConvertException("Conversion failure..Natural right join can't be converted");
                }
                if (this.joinClause.trim().equalsIgnoreCase("KEY JOIN")) {
                    throw new ConvertException("Conversion failure..Key join is not supported");
                }
            }
            if (this.onOrUsingJoin == null && this.joinExpression != null) {
                ft.setOnOrUsingJoin("ON");
                we = ((WhereExpression)this.joinExpression.elementAt(0)).toDB2Select(vembuSQS, vendorSQS);
                Vector<WhereExpression> v = new Vector<WhereExpression>();
                v.addElement(we);
                ft.setJoinExpression(v);
            } else if (this.onOrUsingJoin != null && this.onOrUsingJoin.equalsIgnoreCase("USING")) {
                this.changeToOnJoin(ft, this.getPreviousFromTableFromTheFromItemList(vendorSQS));
            } else if (this.joinExpression != null) {
                ft.setOnOrUsingJoin(this.onOrUsingJoin);
                we = (WhereExpression)this.joinExpression.elementAt(0);
                Vector operatorList = we.getOperator();
                we.setOperator(operatorList);
                we.toDB2Select(vembuSQS, vendorSQS);
                Vector<WhereExpression> v = new Vector<WhereExpression>();
                v.addElement(we);
                ft.setJoinExpression(v);
            }
        }
        if (this.getOuter() != null) {
            ft.setOuter(this.outer);
            if (this.getOuterOpenBrace() != null) {
                ft.setOuterOpenBrace(this.outerOpenBrace);
            }
            if (this.outerClosedBrace != null) {
                ft.setOuterClosedBrace(this.outerClosedBrace);
            }
        }
        if (this.outerClosedBrace != null) {
            ft.setOuterClosedBrace(this.outerClosedBrace);
        }
        if (this.tableName != null) {
            if (this.tableName instanceof SelectQueryStatement) {
                ft.setTableKeyword(this.tableKeyword);
                ft.setTableName(((SelectQueryStatement)this.tableName).toDB2Select());
            } else if (this.tableName instanceof FunctionCalls) {
                ft.setTableKeyword(this.tableKeyword);
                ft.setTableName(((FunctionCalls)this.tableName).toDB2Select(vembuSQS, vendorSQS));
            } else if (this.tableName instanceof WithStatement) {
                ft.setTableName(((WithStatement)this.tableName).toDB2());
            } else if (this.tableName instanceof FromClause) {
                ft.setTableName(((FromClause)this.tableName).toDB2Select(vembuSQS, vendorSQS));
            } else {
                String dataBaseTableName;
                String table_Name_String = (String)this.tableName;
                int atIndex = table_Name_String.indexOf("@");
                ft.setTableName(StringFunctions.replaceFirst(".", "..", (String)this.tableName));
                Vector<String> tokenVector = new Vector<String>();
                String table_Name = (String)this.tableName;
                StringTokenizer st = new StringTokenizer(table_Name, ".");
                int count2 = 0;
                while (st.hasMoreTokens()) {
                    tokenVector.add(st.nextToken());
                    ++count2;
                }
                if (count2 == 1 && atIndex != -1) {
                    dataBaseTableName = (String)tokenVector.elementAt(0);
                    String sqlTableName = dataBaseTableName.substring(0, atIndex);
                    String sqlDataBaseName = dataBaseTableName.substring(atIndex + 1);
                    String sqlDataBaseAndTableName = sqlDataBaseName + "." + sqlTableName;
                    ft.setTableName(sqlDataBaseAndTableName);
                } else if (count2 == 2 && atIndex != -1) {
                    dataBaseTableName = (String)tokenVector.elementAt(1);
                    int tableAtIndex = dataBaseTableName.indexOf("@");
                    String sqlTableName = dataBaseTableName;
                    if (tableAtIndex != -1) {
                        sqlTableName = dataBaseTableName.substring(0, tableAtIndex);
                    }
                    String sqlDataBaseName = dataBaseTableName.substring(tableAtIndex + 1);
                    String sqlDataBaseAndTableName = sqlDataBaseName + "." + (String)tokenVector.elementAt(0) + "." + sqlTableName;
                    ft.setTableName(sqlDataBaseAndTableName);
                }
                String tempTableName = (String)ft.getTableName();
                String tableNameSubString = "";
                int startIndex = tempTableName.indexOf("[");
                if (startIndex != -1) {
                    while (startIndex != -1) {
                        if (startIndex == 0) {
                            tableNameSubString = tempTableName.substring(1);
                            tableNameSubString = "\"" + tableNameSubString;
                            tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                            startIndex = tableNameSubString.indexOf("[");
                            continue;
                        }
                        tableNameSubString = tempTableName.substring(0, startIndex);
                        tableNameSubString = tableNameSubString + "\"";
                        tableNameSubString = tableNameSubString + tempTableName.substring(startIndex + 1);
                        tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                        startIndex = tableNameSubString.indexOf("[");
                    }
                    ft.setTableName(tableNameSubString);
                }
            }
        }
        ft.setIsAS(this.isAS);
        if (this.aliasName != null) {
            if (this.aliasName.charAt(0) == '\'') {
                ft.setAliasName(this.aliasName.replace('\'', '\"'));
            } else {
                ft.setAliasName(this.aliasName);
            }
        } else if (this.tableName instanceof SelectQueryStatement) {
            ft.setAliasName("SwisSQL_ALIAS" + (this.getFromTableIndexFromFromItemList(vendorSQS) + 1));
        }
        ft.setJoinClause(this.joinClause);
        String ownerName = (String)SwisSQLAPI.objectsOwnerName.get(new Integer(3));
        if (ownerName != null && ft.getTableName() instanceof String && ft.getTableName().toString().toLowerCase().indexOf(ownerName + ".") == -1) {
            ft.setTableName(ownerName + "." + ft.getTableName());
        }
        return ft;
    }

    public FromTable toANSISelect(SelectQueryStatement vembuSQS, SelectQueryStatement vendorSQS) throws ConvertException {
        WhereExpression we;
        FromTable ft = new FromTable();
        ft.setTableKeyword(this.tableKeyword);
        if (this.tableName != null) {
            if (this.tableName instanceof SelectQueryStatement) {
                ft.setTableName(((SelectQueryStatement)this.tableName).toANSISelect());
            } else {
                if (this.tableName instanceof FunctionCalls) {
                    throw new ConvertException("Functions yet to be supported in table names");
                }
                if (this.tableName instanceof WithStatement) {
                    ft.setTableName(((WithStatement)this.tableName).toANSISQL());
                } else if (this.tableName instanceof FromClause) {
                    ft.setTableName(((FromClause)this.tableName).toANSISelect(vembuSQS, vendorSQS));
                } else {
                    String dataBaseTableName;
                    String table_Name_String = (String)this.tableName;
                    int atIndex = table_Name_String.indexOf("@");
                    int lastIndexOfDot = table_Name_String.lastIndexOf(".");
                    String remoteLinkName = "";
                    if (atIndex != -1) {
                        remoteLinkName = table_Name_String.substring(atIndex + 1);
                    }
                    if (remoteLinkName.indexOf(".") != -1) {
                        remoteLinkName = "\"" + remoteLinkName + "\"";
                    }
                    ft.setTableName(StringFunctions.replaceFirst(".", "..", (String)this.tableName));
                    Vector<String> tokenVector = new Vector<String>();
                    String table_Name = (String)this.tableName;
                    if (atIndex != -1 && lastIndexOfDot > atIndex) {
                        table_Name = table_Name.substring(0, atIndex);
                    }
                    StringTokenizer st = new StringTokenizer(table_Name, ".");
                    int count2 = 0;
                    while (st.hasMoreTokens()) {
                        tokenVector.add(st.nextToken());
                        ++count2;
                    }
                    if (count2 == 1 && atIndex != -1) {
                        dataBaseTableName = (String)tokenVector.elementAt(0);
                        String sqlTableName = dataBaseTableName.substring(0, atIndex);
                        String sqlDataBaseAndTableName = remoteLinkName + "." + sqlTableName;
                        ft.setTableName(sqlDataBaseAndTableName);
                    } else if (count2 == 2 && atIndex != -1) {
                        dataBaseTableName = (String)tokenVector.elementAt(1);
                        String sqlDataBaseAndTableName = remoteLinkName + "." + (String)tokenVector.elementAt(0) + "." + dataBaseTableName;
                        ft.setTableName(sqlDataBaseAndTableName);
                    }
                    String tempTableName = (String)ft.getTableName();
                    String tableNameSubString = "";
                    int startIndex = tempTableName.indexOf("[");
                    if (startIndex != -1) {
                        while (startIndex != -1) {
                            if (startIndex == 0) {
                                tableNameSubString = tempTableName.substring(1);
                                tableNameSubString = "\"" + tableNameSubString;
                                tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                                startIndex = tableNameSubString.indexOf("[");
                                continue;
                            }
                            tableNameSubString = tempTableName.substring(0, startIndex);
                            tableNameSubString = tableNameSubString + "\"";
                            tableNameSubString = tableNameSubString + tempTableName.substring(startIndex + 1);
                            tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                            startIndex = tableNameSubString.indexOf("[");
                        }
                        ft.setTableName(tableNameSubString);
                    } else if (count2 == 1 && atIndex == -1) {
                        String tableName = tokenVector.get(0).toString().trim();
                        if (tableName.startsWith("\"") || tableName.startsWith("'")) {
                            ft.setTableName(tableName);
                        } else if (SwisSQLOptions.setDoubleQuotesToAnsiSqlTableObjects) {
                            ft.setTableName("\"" + ft.getTableName() + "\"");
                        } else {
                            ft.setTableName(ft.getTableName());
                        }
                    } else if (count2 == 2 && atIndex == -1) {
                        String databaseSchemaName = tokenVector.get(0).toString();
                        String databaseTableName = tokenVector.get(1).toString();
                        if (!(databaseSchemaName.startsWith("\"") || databaseTableName.startsWith("\"") || databaseSchemaName.startsWith("'") || databaseTableName.startsWith("'") || !SwisSQLOptions.setDoubleQuotesToAnsiSqlTableObjects)) {
                            ft.setTableName("\"" + databaseSchemaName + "\"" + "." + "\"" + databaseTableName + "\"");
                        } else {
                            ft.setTableName(ft.getTableName());
                        }
                    } else if (count2 == 3 && atIndex == -1) {
                        String databaseName = tokenVector.get(0).toString();
                        String databaseSchemaName = tokenVector.get(1).toString();
                        String databaseTableName = tokenVector.get(2).toString();
                        if (!(databaseSchemaName.startsWith("\"") || databaseTableName.startsWith("\"") || databaseSchemaName.startsWith("'") || databaseTableName.startsWith("'") || databaseName.startsWith("\"") || databaseName.startsWith("'") || !SwisSQLOptions.setDoubleQuotesToAnsiSqlTableObjects)) {
                            ft.setTableName("\"" + databaseName + "\"" + "." + "\"" + databaseSchemaName + "\"" + "." + "\"" + databaseTableName + "\"");
                        } else {
                            ft.setTableName(ft.getTableName());
                        }
                    } else if (SwisSQLOptions.setDoubleQuotesToAnsiSqlTableObjects) {
                        ft.setTableName("\"" + ft.getTableName() + "\"");
                    } else {
                        ft.setTableName(ft.getTableName());
                    }
                }
            }
        }
        if (this.onOrUsingJoin == null && this.joinExpression != null) {
            ft.setOnOrUsingJoin("ON");
            we = ((WhereExpression)this.joinExpression.elementAt(0)).toDB2Select(vembuSQS, vendorSQS);
            Vector<WhereExpression> v = new Vector<WhereExpression>();
            v.addElement(we);
            ft.setJoinExpression(v);
        } else if (this.onOrUsingJoin != null && this.onOrUsingJoin.equalsIgnoreCase("USING")) {
            this.changeToOnJoin(ft, this.getPreviousFromTableFromTheFromItemList(vendorSQS));
        } else if (this.joinExpression != null) {
            ft.setOnOrUsingJoin(this.onOrUsingJoin);
            we = (WhereExpression)this.joinExpression.elementAt(0);
            Vector operatorList = we.getOperator();
            we.setOperator(operatorList);
            Vector<WhereExpression> v = new Vector<WhereExpression>();
            v.addElement(we.toANSISelect(vembuSQS, vendorSQS));
            ft.setJoinExpression(v);
        }
        if (this.getOuter() != null) {
            ft.setOuter(this.outer);
            if (this.getOuterOpenBrace() != null) {
                ft.setOuterOpenBrace(this.outerOpenBrace);
            }
            if (this.outerClosedBrace != null) {
                ft.setOuterClosedBrace(this.outerClosedBrace);
            }
        }
        if (this.outerClosedBrace != null) {
            ft.setOuterClosedBrace(this.outerClosedBrace);
        }
        ft.setIsAS(this.isAS);
        if (this.aliasName != null) {
            if (this.aliasName.charAt(0) == '\'' && SwisSQLOptions.setDoubleQuotesToAnsiSqlTableObjects) {
                ft.setAliasName(this.aliasName.replace('\'', '\"'));
            } else if (this.aliasName.charAt(0) == '\"') {
                ft.setAliasName(this.aliasName);
            } else if (SwisSQLOptions.setDoubleQuotesToAnsiSqlTableObjects) {
                ft.setAliasName("\"" + this.aliasName + "\"");
            } else {
                ft.setAliasName(this.aliasName);
            }
        } else if (this.tableName instanceof SelectQueryStatement) {
            ft.setAliasName("SwisSQL_ALIAS" + (this.getFromTableIndexFromFromItemList(vendorSQS) + 1));
        }
        ft.setJoinClause(this.joinClause);
        return ft;
    }

    public FromTable toTeradataSelect(SelectQueryStatement vembuSQS, SelectQueryStatement vendorSQS) throws ConvertException {
        WhereExpression we;
        FromTable ft = new FromTable();
        ft.setTableKeyword(this.tableKeyword);
        if (this.tableName != null) {
            if (this.tableName instanceof SelectQueryStatement) {
                SelectQueryStatement subQueryStmt = (SelectQueryStatement)this.tableName;
                if (!this.setOperatorClauseListForSubQuery.isEmpty()) {
                    this.buildSetOperatorClauseForSubQuery(subQueryStmt);
                }
                Vector selectItemList = subQueryStmt.getSelectStatement().getSelectItemList();
                for (int i_count = 0; i_count < selectItemList.size(); ++i_count) {
                    if (!(selectItemList.elementAt(i_count) instanceof SelectColumn)) continue;
                    SelectColumn sc1 = (SelectColumn)selectItemList.elementAt(i_count);
                    if (vendorSQS == null || vendorSQS.getTopLevel()) continue;
                    if (sc1.getColumnExpression().size() == 1 && !(sc1.getColumnExpression().get(0) instanceof TableColumn) && sc1.getAliasName() == null) {
                        String aliasForExpr = sc1.getTheCoreSelectItem().trim();
                        if (sc1.getColumnExpression().get(0) instanceof SelectColumn && ((SelectColumn)sc1.getColumnExpression().get(0)).getColumnExpression().size() == 1) {
                            aliasForExpr = !(((SelectColumn)sc1.getColumnExpression().get(0)).getColumnExpression().get(0) instanceof TableColumn) ? ((SelectColumn)sc1.getColumnExpression().get(0)).toString() : "";
                        }
                        if (aliasForExpr.lastIndexOf(",") != -1) {
                            aliasForExpr = aliasForExpr.substring(0, aliasForExpr.lastIndexOf(",")).trim();
                        }
                        if (aliasForExpr.indexOf("*/") != -1) {
                            aliasForExpr = aliasForExpr.substring(aliasForExpr.indexOf("*/") + 2).trim();
                        }
                        boolean isNum = false;
                        try {
                            Double.parseDouble(aliasForExpr);
                            isNum = true;
                        }
                        catch (NumberFormatException nfe) {
                            isNum = false;
                        }
                        if (!isNum && !aliasForExpr.toLowerCase().startsWith("case") && aliasForExpr.indexOf(".") != -1 && aliasForExpr.indexOf(".") == aliasForExpr.lastIndexOf(".") && aliasForExpr.indexOf("(") == -1) {
                            aliasForExpr = aliasForExpr.substring(aliasForExpr.lastIndexOf(".") + 1);
                        }
                        if (aliasForExpr.indexOf("/*") != -1) {
                            aliasForExpr = aliasForExpr.substring(0, aliasForExpr.indexOf("/*")).trim();
                        }
                        if (!(aliasForExpr.equalsIgnoreCase("*") || aliasForExpr.startsWith("*") || aliasForExpr.endsWith("*"))) {
                            if (aliasForExpr.length() > 30) {
                                aliasForExpr = aliasForExpr.substring(0, 29);
                            }
                            if (aliasForExpr.length() > 0) {
                                sc1.setAliasForExpression("\"" + aliasForExpr.replaceAll("\n", " ").replaceAll("\t", " ") + "\"");
                            }
                        }
                    }
                    if (sc1.getAliasName() != null || sc1.getAliasForExpression() == null) continue;
                    sc1.setAliasName(sc1.getAliasForExpression());
                }
                SelectQueryStatement subQuery = subQueryStmt;
                if (!subQuery.isConverted()) {
                    subQuery = subQueryStmt.toTeradataSelect();
                }
                if (subQuery.getWithStatement() != null) {
                    SelectQueryStatement.getListOfWithStatements().add(subQuery.getWithStatement());
                    SelectQueryStatement tempSubQuery = subQuery.getWithStatement().getWithSQS();
                    subQuery.getWithStatement().setWithSQS(null);
                    subQuery = tempSubQuery;
                }
                ft.setTableName(subQuery);
            } else {
                if (this.tableName instanceof FunctionCalls) {
                    throw new ConvertException("Functions yet to be supported in table names");
                }
                if (this.tableName instanceof WithStatement) {
                    ft.setTableName(((WithStatement)this.tableName).toTeradata());
                } else if (this.tableName instanceof FromClause) {
                    FromClause teradataFromClause = ((FromClause)this.tableName).toTeradataSelect(vembuSQS, vendorSQS);
                    ft.setTableName(teradataFromClause);
                    if (this.aliasName == null && ft.getAliasName() == null && teradataFromClause.getAliasName() != null) {
                        ft.setAliasName(teradataFromClause.getAliasName());
                    }
                } else {
                    String dataBaseTableName;
                    Vector<String> tokenVector;
                    String table_Name_String = (String)this.tableName;
                    int atIndex = table_Name_String.indexOf("@");
                    if (table_Name_String.indexOf("..") != -1) {
                        ft.setTableName(StringFunctions.replaceFirst(".", "..", (String)this.tableName));
                    }
                    int dotDotIndex = table_Name_String.indexOf("..");
                    ft.setTableName(table_Name_String);
                    if (dotDotIndex != -1) {
                        String localTableName = table_Name_String.substring(table_Name_String.lastIndexOf(".") + 1, table_Name_String.length());
                        ft.setTableName(CustomizeUtil.objectNamesToQuotedIdentifier(localTableName, SwisSQLUtils.getKeywords("teradata"), null, -1));
                    } else {
                        tokenVector = new Vector<String>();
                        StringTokenizer st = new StringTokenizer(table_Name_String, ".");
                        int count2 = 0;
                        while (st.hasMoreTokens()) {
                            tokenVector.add(st.nextToken());
                            ++count2;
                        }
                        if (count2 == 1) {
                            ft.setTableName(CustomizeUtil.objectNamesToQuotedIdentifier(table_Name_String, SwisSQLUtils.getKeywords("teradata"), null, -1));
                        } else if (count2 == 2) {
                            String ownerName = (String)tokenVector.elementAt(0);
                            String tableName = (String)tokenVector.elementAt(1);
                            if (!tableName.startsWith("\"")) {
                                tableName = CustomizeUtil.objectNamesToQuotedIdentifier(tableName, SwisSQLUtils.getKeywords("teradata"), null, -1);
                            }
                            if (ownerName.equalsIgnoreCase("DBO")) {
                                ft.setTableName(tableName);
                            } else {
                                ft.setTableName(ownerName + "." + tableName);
                            }
                        } else if (count2 == 3) {
                            String dataBaseName = (String)tokenVector.elementAt(0);
                            String ownerName = (String)tokenVector.elementAt(1);
                            String tableName = (String)tokenVector.elementAt(2);
                            if (!tableName.startsWith("\"")) {
                                tableName = CustomizeUtil.objectNamesToQuotedIdentifier(tableName, SwisSQLUtils.getKeywords("teradata"), null, -1);
                            }
                            if (ownerName.equalsIgnoreCase("DBO")) {
                                ft.setTableName(tableName);
                            } else {
                                ft.setTableName(ownerName + "." + tableName);
                            }
                        }
                    }
                    tokenVector = new Vector();
                    String table_Name = (String)this.tableName;
                    StringTokenizer st = new StringTokenizer(table_Name, ".");
                    int count3 = 0;
                    while (st.hasMoreTokens()) {
                        tokenVector.add(st.nextToken());
                        ++count3;
                    }
                    if (count3 == 1 && atIndex != -1) {
                        dataBaseTableName = (String)tokenVector.elementAt(0);
                        String sqlTableName = dataBaseTableName.substring(0, atIndex);
                        String sqlDataBaseName = dataBaseTableName.substring(atIndex + 1);
                        sqlTableName = CustomizeUtil.objectNamesToQuotedIdentifier(sqlTableName, SwisSQLUtils.getKeywords("teradata"), null, -1);
                        String sqlDataBaseAndTableName = sqlDataBaseName + "." + sqlTableName;
                        ft.setTableName(sqlDataBaseAndTableName);
                    } else if (count3 == 2 && atIndex != -1) {
                        dataBaseTableName = (String)tokenVector.elementAt(1);
                        int tableAtIndex = dataBaseTableName.indexOf("@");
                        String sqlTableName = dataBaseTableName.substring(0, tableAtIndex);
                        String sqlDataBaseName = dataBaseTableName.substring(tableAtIndex + 1);
                        sqlTableName = CustomizeUtil.objectNamesToQuotedIdentifier(sqlTableName, SwisSQLUtils.getKeywords("teradata"), null, -1);
                        String sqlDataBaseAndTableName = sqlDataBaseName + "." + (String)tokenVector.elementAt(0) + "." + sqlTableName;
                        ft.setTableName(sqlDataBaseAndTableName);
                    }
                    String tempTableName = (String)ft.getTableName();
                    String tableNameSubString = "";
                    int startIndex = tempTableName.indexOf("[");
                    if (startIndex != -1) {
                        while (startIndex != -1) {
                            if (startIndex == 0) {
                                tableNameSubString = tempTableName.substring(1);
                                tableNameSubString = "\"" + tableNameSubString;
                                tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                                startIndex = tableNameSubString.indexOf("[");
                                continue;
                            }
                            tableNameSubString = tempTableName.substring(0, startIndex);
                            tableNameSubString = tableNameSubString + "\"";
                            tableNameSubString = tableNameSubString + tempTableName.substring(startIndex + 1);
                            tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                            startIndex = tableNameSubString.indexOf("[");
                        }
                        ft.setTableName(tableNameSubString);
                    } else if (count3 == 2 && atIndex == -1) {
                        String databaseSchemaName = tokenVector.get(0).toString();
                        String databaseTableName = tokenVector.get(1).toString();
                        if (!(databaseSchemaName.startsWith("\"") || databaseTableName.startsWith("\"") || databaseSchemaName.startsWith("'") || databaseTableName.startsWith("'"))) {
                            databaseSchemaName = CustomizeUtil.objectNamesToQuotedIdentifier(databaseSchemaName, SwisSQLUtils.getKeywords("teradata"), null, -1);
                            databaseTableName = CustomizeUtil.objectNamesToQuotedIdentifier(databaseTableName, SwisSQLUtils.getKeywords("teradata"), null, -1);
                            ft.setTableName(databaseSchemaName + "." + databaseTableName);
                        } else {
                            ft.setTableName(ft.getTableName());
                        }
                    } else if (count3 == 3 && atIndex == -1) {
                        String databaseName = tokenVector.get(0).toString();
                        String databaseSchemaName = tokenVector.get(1).toString();
                        String databaseTableName = tokenVector.get(2).toString();
                        if (!(databaseSchemaName.startsWith("\"") || databaseTableName.startsWith("\"") || databaseSchemaName.startsWith("'") || databaseTableName.startsWith("'") || databaseName.startsWith("\"") || databaseName.startsWith("'"))) {
                            databaseName = CustomizeUtil.objectNamesToQuotedIdentifier(databaseName, SwisSQLUtils.getKeywords("teradata"), null, -1);
                            databaseSchemaName = CustomizeUtil.objectNamesToQuotedIdentifier(databaseSchemaName, SwisSQLUtils.getKeywords("teradata"), null, -1);
                            databaseTableName = CustomizeUtil.objectNamesToQuotedIdentifier(databaseTableName, SwisSQLUtils.getKeywords("teradata"), null, -1);
                            ft.setTableName(databaseName + "." + databaseSchemaName + "." + databaseTableName);
                        } else {
                            ft.setTableName(ft.getTableName());
                        }
                    }
                }
            }
        }
        if (this.onOrUsingJoin == null && this.joinExpression != null) {
            ft.setOnOrUsingJoin("ON");
            we = ((WhereExpression)this.joinExpression.elementAt(0)).toDB2Select(vembuSQS, vendorSQS);
            Vector<WhereExpression> v = new Vector<WhereExpression>();
            v.addElement(we);
            ft.setJoinExpression(v);
        } else if (this.onOrUsingJoin != null && this.onOrUsingJoin.equalsIgnoreCase("USING")) {
            this.changeToOnJoin(ft, this.getPreviousFromTableFromTheFromItemList(vendorSQS));
        } else if (this.joinExpression != null) {
            ft.setOnOrUsingJoin(this.onOrUsingJoin);
            we = (WhereExpression)this.joinExpression.elementAt(0);
            Vector operatorList = we.getOperator();
            we.setOperator(operatorList);
            Vector<WhereExpression> v = new Vector<WhereExpression>();
            WhereExpression teradataWhereExp = we.toTeradataSelect(vembuSQS, vendorSQS);
            if (this.crossJoinExpression != null) {
                teradataWhereExp.addWhereExpression(this.crossJoinExpression);
                teradataWhereExp.addOperator("AND");
            }
            v.addElement(teradataWhereExp);
            ft.setJoinExpression(v);
        }
        if (this.getOuter() != null) {
            ft.setOuter(this.outer);
            if (this.getOuterOpenBrace() != null) {
                ft.setOuterOpenBrace(this.outerOpenBrace);
            }
            if (this.outerClosedBrace != null) {
                ft.setOuterClosedBrace(this.outerClosedBrace);
            }
        }
        if (this.outerClosedBrace != null) {
            ft.setOuterClosedBrace(this.outerClosedBrace);
        }
        if (this.fromClauseOpenBraces != null) {
            ft.setFromClauseOpenBraces(this.fromClauseOpenBraces);
            ft.setFromClauseClosedBraces(")");
        }
        ft.setIsAS(this.isAS);
        if (this.aliasName != null) {
            this.aliasName = CustomizeUtil.objectNamesToQuotedIdentifier(this.aliasName, SwisSQLUtils.getKeywords("teradata"), null, -1);
            ft.setAliasName(this.aliasName);
        } else if (this.tableName instanceof SelectQueryStatement && vendorSQS != null) {
            ft.setAliasName("SwisSQL_ALIAS" + (this.getFromTableIndexFromFromItemList(vendorSQS) + 1));
        }
        ft.setJoinClause(this.joinClause);
        if (this.queryPartitionClause != null) {
            FromTable crossJoinFt = new FromTable();
            SelectQueryStatement crossJoinQuery = new SelectQueryStatement();
            SelectStatement crossJoinSelect = new SelectStatement();
            crossJoinSelect.setSelectClause("SELECT");
            crossJoinSelect.setSelectQualifier("DISTINCT");
            Vector<SelectColumn> crossJoinItems = new Vector<SelectColumn>();
            for (int ki = 0; ki < this.queryPartitionClause.getSelectColumnList().size(); ++ki) {
                if (!(this.queryPartitionClause.getSelectColumnList().get(ki) instanceof SelectColumn)) continue;
                SelectColumn sc1 = (SelectColumn)this.queryPartitionClause.getSelectColumnList().get(ki);
                if (sc1.getEndsWith() == null && ki < this.queryPartitionClause.getSelectColumnList().size() - 1) {
                    sc1.setEndsWith(",");
                }
                crossJoinItems.add(sc1.toTeradataSelect(null, null));
            }
            crossJoinSelect.setSelectItemList(crossJoinItems);
            crossJoinQuery.setSelectStatement(crossJoinSelect);
            FromClause fc = new FromClause();
            fc.setFromClause("FROM");
            Vector<FromTable> fcFromItems = new Vector<FromTable>();
            FromTable crossJoinTable = new FromTable();
            crossJoinTable.setTableName(ft.getTableName());
            crossJoinTable.setAliasName(ft.getAliasName());
            fcFromItems.add(crossJoinTable);
            fc.setFromItemList(fcFromItems);
            crossJoinQuery.setFromClause(fc);
            if (ft.getAliasName() != null) {
                crossJoinFt.setAliasName(ft.getAliasName() + 1);
            } else if (ft.getTableName() instanceof String) {
                crossJoinFt.setAliasName(ft.getTableName().toString() + 1);
            } else {
                crossJoinFt.setAliasName("cj1");
            }
            crossJoinFt.setTableName(crossJoinQuery);
            crossJoinFt.setJoinClause("CROSS JOIN");
            ft.setQueryPartitionClause(this.queryPartitionClause);
            ft.setCrossJoinForPartitionClause(crossJoinFt);
            WhereExpression crossJoinWhereExp = new WhereExpression();
            Vector toSQSSelectItems = new Vector();
            if (vembuSQS != null) {
                toSQSSelectItems = vembuSQS.getSelectStatement().getSelectItemList();
            }
            for (int j = 0; j < crossJoinItems.size(); ++j) {
                String origStr;
                SelectColumn orig = (SelectColumn)crossJoinItems.get(j);
                String origStrBase = origStr = orig.getTheCoreSelectItem().trim();
                if (!origStr.toLowerCase().startsWith("case") && origStr.indexOf(".") != -1 && origStr.indexOf(".") == origStr.lastIndexOf(".") && origStr.indexOf("(") == -1) {
                    origStr = origStr.substring(origStr.lastIndexOf(".") + 1);
                }
                if (origStr.length() > 30) {
                    origStr = origStr.substring(0, 29);
                }
                if (!origStr.startsWith("\"") && !origStr.endsWith("\"")) {
                    origStr = "\"" + origStr + "\"";
                }
                orig.setAliasName(origStr);
                WhereItem crossJoinWhereItem = new WhereItem();
                WhereColumn crossJoinWhereCol = new WhereColumn();
                Vector<TableColumn> crossJoinColExp = new Vector<TableColumn>();
                TableColumn crossJoinCol = new TableColumn();
                crossJoinCol.setTableName(crossJoinFt.getAliasName());
                crossJoinCol.setColumnName(orig.getAliasName());
                crossJoinColExp.add(crossJoinCol);
                crossJoinWhereCol.setColumnExpression(crossJoinColExp);
                crossJoinWhereItem.setLeftWhereExp(crossJoinWhereCol);
                for (int ji = 0; ji < toSQSSelectItems.size(); ++ji) {
                    SelectColumn toSQSCol = (SelectColumn)toSQSSelectItems.get(ji);
                    if (!origStrBase.equalsIgnoreCase(toSQSCol.getTheCoreSelectItem().trim())) continue;
                    toSQSCol.setColumnExpression(crossJoinColExp);
                    if (toSQSCol.getAliasName() != null) continue;
                    toSQSCol.setAliasName(orig.getAliasName());
                }
                WhereColumn origWhereCol = new WhereColumn();
                SelectColumn origTableSelCol = new SelectColumn();
                origTableSelCol.setColumnExpression(orig.getColumnExpression());
                Vector<SelectColumn> origWhereColExp = new Vector<SelectColumn>();
                origWhereColExp.add(origTableSelCol);
                origWhereCol.setColumnExpression(origWhereColExp);
                crossJoinWhereItem.setRightWhereExp(origWhereCol);
                crossJoinWhereExp.addWhereItem(crossJoinWhereItem);
                crossJoinWhereItem.setOperator("=");
                if (j == 0) continue;
                crossJoinWhereExp.addOperator("AND");
            }
            if (ft.getJoinExpression() != null) {
                ((WhereExpression)ft.getJoinExpression().elementAt(0)).addWhereExpression(crossJoinWhereExp);
                ((WhereExpression)ft.getJoinExpression().elementAt(0)).addOperator("AND");
            } else {
                ft.setCrossJoinExpression(crossJoinWhereExp);
            }
        }
        if (this.crossJoinForPartitionClause != null) {
            ft.setCrossJoinForPartitionClause(this.crossJoinForPartitionClause);
        }
        return ft;
    }

    public FromTable toMSSQLServerSelect(SelectQueryStatement vembuSQS, SelectQueryStatement vendorSQS) throws ConvertException {
        FromTable ft = new FromTable();
        if (this.joinClause != null) {
            WhereExpression we;
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL JOIN")) {
                throw new ConvertException("Conversion failure..Natural join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL LEFT JOIN")) {
                throw new ConvertException("Conversion failure..Natural left Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL RIGHT JOIN")) {
                throw new ConvertException("Conversion failure..Natural right Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL LEFT OUTER JOIN")) {
                throw new ConvertException("Conversion failure..Natural left Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL RIGHT OUTER JOIN")) {
                throw new ConvertException("Conversion failure..Natural right join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("KEY JOIN")) {
                throw new ConvertException("Conversion failure..Key join is not supported");
            }
            if (this.onOrUsingJoin == null && this.joinExpression != null) {
                ft.setOnOrUsingJoin("ON");
                we = ((WhereExpression)this.joinExpression.elementAt(0)).toMSSQLServerSelect(vembuSQS, vendorSQS);
                Vector<WhereExpression> v = new Vector<WhereExpression>();
                v.addElement(we);
                ft.setJoinExpression(v);
            } else if (this.onOrUsingJoin != null && this.onOrUsingJoin.equalsIgnoreCase("USING")) {
                this.changeToOnJoin(ft, this.getPreviousFromTableFromTheFromItemList(vendorSQS));
            } else if (this.joinExpression != null) {
                ft.setOnOrUsingJoin(this.onOrUsingJoin);
                we = (WhereExpression)this.joinExpression.elementAt(0);
                Vector operatorList = we.getOperator();
                we.setOperator(operatorList);
                Vector<WhereExpression> v = new Vector<WhereExpression>();
                v.addElement(we.toMSSQLServerSelect(vembuSQS, vendorSQS));
                ft.setJoinExpression(v);
            }
        }
        if (vendorSQS != null && vendorSQS.getForUpdateStatement() != null) {
            ft.setUpdateLock("(UPDLOCK)");
        }
        if (this.getOuter() != null) {
            ft.setOuter(this.outer);
            if (this.getOuterOpenBrace() != null) {
                ft.setOuterOpenBrace(this.outerOpenBrace);
            }
            if (this.outerClosedBrace != null) {
                ft.setOuterClosedBrace(this.outerClosedBrace);
            }
        }
        if (this.outerClosedBrace != null) {
            ft.setOuterClosedBrace(this.outerClosedBrace);
        }
        if (this.getOuter() != null) {
            ft.setOuter(this.outer);
            if (this.getOuterOpenBrace() != null) {
                ft.setOuterOpenBrace(this.outerOpenBrace);
            }
            if (this.outerClosedBrace != null) {
                ft.setOuterClosedBrace(this.outerClosedBrace);
            }
        }
        if (this.outerClosedBrace != null) {
            ft.setOuterClosedBrace(this.outerClosedBrace);
        }
        if (this.tableName != null) {
            if (this.tableName instanceof SelectQueryStatement) {
                ft.setTableName(((SelectQueryStatement)this.tableName).toMSSQLServerSelect());
            } else if (this.tableName instanceof FunctionCalls) {
                if (this.tableKeyword != null) {
                    FunctionCalls fn = ((FunctionCalls)this.tableName).toMSSQLServerSelect(vembuSQS, vendorSQS);
                    if (fn != null && fn.toString().indexOf("CAST") != -1) {
                        ft.setTableKeyword("TABLE(");
                    }
                    ft.setTableName(fn);
                } else {
                    ft.setTableName(((FunctionCalls)this.tableName).toMSSQLServerSelect(vembuSQS, vendorSQS));
                }
            } else if (this.tableName instanceof WithStatement) {
                ft.setTableName(((WithStatement)this.tableName).toMSSQLServer());
            } else if (this.tableName instanceof FromClause) {
                ft.setTableName(((FromClause)this.tableName).toMSSQLServerSelect(vembuSQS, vendorSQS));
            } else {
                String table_Name_String = (String)this.tableName;
                int atIndex = table_Name_String.indexOf("@");
                if (((String)this.tableName).indexOf("..") < 0) {
                    if (SwisSQLOptions.removeDBSchemaQualifier) {
                        ft.setTableName(table_Name_String.substring(table_Name_String.lastIndexOf(".") + 1));
                    } else {
                        ft.setTableName((String)this.tableName);
                    }
                } else {
                    ft.setTableName((String)this.tableName);
                }
                Vector<String> tokenVector = new Vector<String>();
                String table_Name = (String)this.tableName;
                StringTokenizer st = new StringTokenizer(table_Name, ".");
                int count2 = 0;
                while (st.hasMoreTokens()) {
                    tokenVector.add(st.nextToken());
                    ++count2;
                }
                if (count2 == 1 && atIndex != -1 && atIndex != 0) {
                    String dataBaseTableName = (String)tokenVector.elementAt(0);
                    String sqlTableName = dataBaseTableName.substring(0, atIndex);
                    String sqlDataBaseName = dataBaseTableName.substring(atIndex + 1);
                    String sqlDataBaseAndTableName = sqlDataBaseName + ".." + sqlTableName;
                    ft.setTableName(sqlDataBaseAndTableName);
                } else if (count2 == 2 && atIndex != -1) {
                    String dataBaseTableName = (String)tokenVector.elementAt(1);
                    int tableAtIndex = dataBaseTableName.indexOf("@");
                    String sqlTableName = dataBaseTableName.substring(0, tableAtIndex);
                    String sqlDataBaseName = dataBaseTableName.substring(tableAtIndex + 1);
                    String sqlDataBaseAndTableName = sqlDataBaseName + "." + (String)tokenVector.elementAt(0) + "." + sqlTableName;
                    ft.setTableName(sqlDataBaseAndTableName);
                }
            }
        }
        ft.setIsAS(this.isAS);
        if (this.aliasName != null) {
            if (this.aliasName.charAt(0) == '\'') {
                ft.setAliasName(this.aliasName.replace('\'', '\"'));
            } else if (this.aliasName.equalsIgnoreCase("noholdlock")) {
                if (ft.getUpdateLock() == null) {
                    ft.setAliasName("WITH(NOLOCK)");
                } else {
                    ft.setAliasName("WITH(NOLOCK, UPDLOCK)");
                    ft.setUpdateLock(null);
                }
            } else if (this.aliasName.equalsIgnoreCase("holdlock")) {
                if (ft.getUpdateLock() == null) {
                    ft.setAliasName("WITH(HOLDLOCK)");
                } else {
                    ft.setAliasName("WITH(HOLDLOCK, UPDLOCK)");
                    ft.setUpdateLock(null);
                }
            } else {
                ft.setAliasName(this.aliasName);
            }
        } else if (this.tableName instanceof SelectQueryStatement) {
            ft.setAliasName("SwisSQL_ALIAS" + (this.getFromTableIndexFromFromItemList(vendorSQS) + 1));
        }
        if (this.holdLock != null) {
            if (this.holdLock.equalsIgnoreCase("noholdlock")) {
                if (ft.getUpdateLock() == null) {
                    ft.setHoldLock("WITH(NOLOCK)");
                } else {
                    ft.setHoldLock("WITH(NOLOCK, UPDLOCK)");
                    ft.setUpdateLock(null);
                }
            } else if (this.holdLock.equalsIgnoreCase("holdlock")) {
                if (ft.getUpdateLock() == null) {
                    ft.setHoldLock("WITH(HOLDLOCK)");
                } else {
                    ft.setHoldLock("WITH(HOLDLOCK, UPDLOCK)");
                    ft.setUpdateLock(null);
                }
            }
        }
        if (this.joinClause != null && this.joinClause.equalsIgnoreCase("JOIN")) {
            ft.setJoinClause(" INNER " + this.joinClause);
        } else {
            ft.setJoinClause(this.joinClause);
        }
        if (this.indexHint != null) {
            if (this.indexHint.trim().startsWith("WITH")) {
                ft.setIndexHint(this.indexHint);
            } else if (ft.getUpdateLock() == null) {
                ft.setIndexHint(" WITH(index(" + this.indexHint + "))");
            } else {
                ft.setIndexHint(" WITH(index(" + this.indexHint + "), UPDLOCK)");
                ft.setUpdateLock(null);
            }
        }
        return ft;
    }

    public FromTable toSybaseSelect(SelectQueryStatement vembuSQS, SelectQueryStatement vendorSQS) throws ConvertException {
        FromTable ft = new FromTable();
        ft.setObjectContext(this.context);
        boolean isFullJoin = false;
        if (this.joinClause != null) {
            WhereExpression we;
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL JOIN")) {
                throw new ConvertException("Conversion failure..Natural join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL LEFT JOIN")) {
                throw new ConvertException("Conversion failure..Natural left Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL RIGHT JOIN")) {
                throw new ConvertException("Conversion failure..Natural right Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL LEFT OUTER JOIN")) {
                throw new ConvertException("Conversion failure..Natural left Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL RIGHT OUTER JOIN")) {
                throw new ConvertException("Conversion failure..Natural right join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("KEY JOIN")) {
                throw new ConvertException("Conversion failure..Key join is not supported");
            }
            if (this.joinClause.trim().equalsIgnoreCase("CROSS JOIN")) {
                this.joinClause = null;
            } else if (this.joinClause.trim().equalsIgnoreCase("NATURAL INNER JOIN")) {
                this.joinClause = "INNER JOIN";
            } else if (this.joinClause.trim().equalsIgnoreCase("FULL JOIN") || this.joinClause.trim().equalsIgnoreCase("FULL OUTER JOIN")) {
                FromClause fc = new FromClause();
                fc.setObjectContext(this.context);
                FromTable newFromTable = new FromTable();
                newFromTable.setAliasName(this.aliasName);
                newFromTable.setObjectContext(this.context);
                newFromTable.setIsAS(this.isAS);
                newFromTable.setJoinClause("RIGHT OUTER JOIN");
                newFromTable.setJoinExpression(this.joinExpression);
                newFromTable.setOnOrUsingJoin(this.onOrUsingJoin);
                newFromTable.setTableKeyword(this.tableKeyword);
                newFromTable.setTableName(this.tableName);
                newFromTable.setUsingList(this.UsingList);
                if (vendorSQS.getFromClause() != null) {
                    fc.setFromClause("FROM");
                    Vector fromList = vendorSQS.getFromClause().getFromItemList();
                    Vector<FromTable> newFromList = new Vector<FromTable>();
                    for (int i = 0; i < fromList.size(); ++i) {
                        if (fromList.get(i) instanceof FromTable) {
                            FromTable getFT = (FromTable)fromList.get(i);
                            if (getFT != null && getFT.equals(this)) {
                                newFromList.add(newFromTable);
                                continue;
                            }
                            if (!(fromList.get(i) instanceof FromTable)) continue;
                            newFromList.add(((FromTable)fromList.get(i)).toSybaseSelect(vembuSQS, vendorSQS));
                            continue;
                        }
                        if (!(fromList.get(i) instanceof FromClause)) continue;
                        ((FromClause)fromList.get(i)).toSybaseSelect(vembuSQS, vendorSQS);
                    }
                    fc.setFromItemList(newFromList);
                }
                SelectQueryStatement sqs = new SelectQueryStatement();
                sqs.setObjectContext(this.context);
                sqs.setFromClause(fc);
                if (vendorSQS.getSelectStatement() != null) {
                    sqs.setSelectStatement(vendorSQS.getSelectStatement().toSybaseSelect(vembuSQS, vendorSQS));
                }
                if (vendorSQS.getFetchClause() != null) {
                    sqs.setFetchClause(vendorSQS.getFetchClause().toSybaseSelect(vembuSQS, vendorSQS));
                }
                if (vendorSQS.getForUpdateStatement() != null) {
                    sqs.setForUpdateStatement(vendorSQS.getForUpdateStatement().toSybaseSelect(vembuSQS, vendorSQS));
                }
                if (vendorSQS.getGroupByStatement() != null) {
                    sqs.setGroupByStatement(vendorSQS.getGroupByStatement().toSybaseSelect(vembuSQS, vendorSQS));
                }
                if (vendorSQS.getHavingStatement() != null) {
                    sqs.setHavingStatement(vendorSQS.getHavingStatement().toSybaseSelect(vembuSQS, vendorSQS));
                }
                if (vendorSQS.getHierarchicalQueryClause() != null) {
                    sqs.setHierarchicalQueryClause(vendorSQS.getHierarchicalQueryClause().toSybaseSelect(vembuSQS, vendorSQS));
                }
                if (vendorSQS.getLimitClause() != null) {
                    sqs.setLimitClause(vendorSQS.getLimitClause().toSybaseSelect(vembuSQS, vendorSQS));
                }
                if (vendorSQS.getSetOperatorClause() != null) {
                    sqs.setSetOperatorClause(vendorSQS.getSetOperatorClause().toSybaseSelect(vembuSQS, vendorSQS));
                }
                if (vendorSQS.getWhereExpression() != null) {
                    sqs.setWhereExpression(vendorSQS.getWhereExpression().toSybaseSelect(vembuSQS, vendorSQS));
                }
                this.setOperatorClauseForFullJoin = new SetOperatorClause();
                this.setOperatorClauseForFullJoin.setSelectQueryStatement(sqs);
                this.setOperatorClauseForFullJoin.setSetClause("UNION");
                this.setOperatorClauseForFullJoin.setObjectContext(this.context);
                if (vendorSQS.getWhereExpression() != null) {
                    this.setOperatorClauseForFullJoin.setWhereExpression(vendorSQS.getWhereExpression().toSybaseSelect(vembuSQS, vendorSQS));
                    vendorSQS.setWhereExpression(null);
                }
                ft.setSetOperatorClause(this.setOperatorClauseForFullJoin);
                isFullJoin = true;
            }
            if (this.onOrUsingJoin == null && this.joinExpression != null) {
                ft.setOnOrUsingJoin("ON");
                we = ((WhereExpression)this.joinExpression.elementAt(0)).toSybaseSelect(vembuSQS, vendorSQS);
                Vector<WhereExpression> v = new Vector<WhereExpression>();
                v.addElement(we);
                ft.setJoinExpression(v);
            } else if (this.onOrUsingJoin != null && this.onOrUsingJoin.equalsIgnoreCase("USING")) {
                this.changeToOnJoin(ft, this.getPreviousFromTableFromTheFromItemList(vendorSQS));
            } else if (this.joinExpression != null) {
                ft.setOnOrUsingJoin(this.onOrUsingJoin);
                we = (WhereExpression)this.joinExpression.elementAt(0);
                Vector operatorList = we.getOperator();
                for (int i = 0; i < operatorList.size(); ++i) {
                    if (!(operatorList.elementAt(i) instanceof String) || !((String)operatorList.get(i)).equalsIgnoreCase("AND") || isFullJoin) continue;
                    operatorList.setElementAt("ON", i);
                }
                we.setOperator(operatorList);
                we.toSybaseSelect(vembuSQS, vendorSQS);
                Vector<WhereExpression> v = new Vector<WhereExpression>();
                v.addElement(we);
                ft.setJoinExpression(v);
            }
        }
        if (this.getOuter() != null) {
            ft.setOuter(this.outer);
            if (this.getOuterOpenBrace() != null) {
                ft.setOuterOpenBrace(this.outerOpenBrace);
            }
            if (this.outerClosedBrace != null) {
                ft.setOuterClosedBrace(this.outerClosedBrace);
            }
        }
        if (this.outerClosedBrace != null) {
            ft.setOuterClosedBrace(this.outerClosedBrace);
        }
        if (this.getOuter() != null) {
            ft.setOuter(this.outer);
            if (this.getOuterOpenBrace() != null) {
                ft.setOuterOpenBrace(this.outerOpenBrace);
            }
            if (this.outerClosedBrace != null) {
                ft.setOuterClosedBrace(this.outerClosedBrace);
            }
        }
        if (this.outerClosedBrace != null) {
            ft.setOuterClosedBrace(this.outerClosedBrace);
        }
        if (this.tableName != null) {
            if (this.tableName instanceof SelectQueryStatement) {
                ft.setTableName(((SelectQueryStatement)this.tableName).toSybaseSelect());
            } else if (this.tableName instanceof FunctionCalls) {
                ft.setTableName(((FunctionCalls)this.tableName).toSybaseSelect(vembuSQS, vendorSQS));
            } else if (this.tableName instanceof WithStatement) {
                ft.setTableName(((WithStatement)this.tableName).toSybase());
            } else if (this.tableName instanceof FromClause) {
                ft.setTableName(((FromClause)this.tableName).toSybaseSelect(vembuSQS, vendorSQS));
            } else {
                String dataBaseTableName;
                String table_Name_String = (String)this.tableName;
                int atIndex = table_Name_String.indexOf("@");
                if (((String)this.tableName).indexOf("..") < 0) {
                    StringTokenizer toks = new StringTokenizer((String)this.tableName, ".");
                    ft.setTableName((String)this.tableName);
                } else {
                    ft.setTableName((String)this.tableName);
                }
                Vector<String> tokenVector = new Vector<String>();
                String table_Name = (String)this.tableName;
                StringTokenizer st = new StringTokenizer(table_Name, ".");
                int count2 = 0;
                while (st.hasMoreTokens()) {
                    tokenVector.add(st.nextToken());
                    ++count2;
                }
                if (count2 == 1 && atIndex != -1 && atIndex != 0) {
                    dataBaseTableName = (String)tokenVector.elementAt(0);
                    String sqlTableName = dataBaseTableName.substring(0, atIndex);
                    String sqlDataBaseName = dataBaseTableName.substring(atIndex + 1);
                    String sqlDataBaseAndTableName = sqlDataBaseName + ".." + sqlTableName;
                    ft.setTableName(sqlDataBaseAndTableName);
                } else if (count2 == 2 && atIndex != -1) {
                    dataBaseTableName = (String)tokenVector.elementAt(1);
                    int tableAtIndex = dataBaseTableName.indexOf("@");
                    String sqlTableName = dataBaseTableName;
                    if (tableAtIndex != -1) {
                        sqlTableName = dataBaseTableName.substring(0, tableAtIndex);
                    }
                    String sqlDataBaseName = dataBaseTableName.substring(tableAtIndex + 1);
                    String sqlDataBaseAndTableName = sqlDataBaseName + "." + (String)tokenVector.elementAt(0) + "." + sqlTableName;
                    ft.setTableName(sqlDataBaseAndTableName);
                }
                String tempTableName = (String)ft.getTableName();
                String tableNameSubString = "";
                int startIndex = tempTableName.indexOf("[");
                if (startIndex != -1) {
                    while (startIndex != -1) {
                        if (startIndex == 0) {
                            tableNameSubString = tempTableName.substring(1);
                            tableNameSubString = "\"" + tableNameSubString;
                            tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                            startIndex = tableNameSubString.indexOf("[");
                            continue;
                        }
                        tableNameSubString = tempTableName.substring(0, startIndex);
                        tableNameSubString = tableNameSubString + "\"";
                        tableNameSubString = tableNameSubString + tempTableName.substring(startIndex + 1);
                        tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                        startIndex = tableNameSubString.indexOf("[");
                    }
                    ft.setTableName(tableNameSubString);
                }
            }
        }
        ft.setIsAS(this.isAS);
        if (this.aliasName != null) {
            if (this.aliasName.charAt(0) == '\'') {
                ft.setAliasName(this.aliasName.replace('\'', '\"'));
            } else {
                ft.setAliasName(this.aliasName);
            }
        } else if (this.tableName instanceof SelectQueryStatement) {
            ft.setAliasName("SwisSQL_ALIAS" + (this.getFromTableIndexFromFromItemList(vendorSQS) + 1));
        }
        if (!isFullJoin) {
            ft.setJoinClause(this.joinClause);
        } else {
            ft.setJoinClause("LEFT OUTER JOIN");
        }
        if (this.indexHint != null) {
            ft.setIndexHint(" ( index " + this.indexHint + ")");
        }
        return ft;
    }

    public void changeToOnJoin(FromTable to_ft, FromTable from_ft) throws ConvertException {
        int i = 0;
        String s_cn = null;
        if (from_ft != null) {
            s_cn = from_ft.getAliasName() != null ? from_ft.getAliasName() : from_ft.getTableName().toString();
        }
        Vector<Object> v_ul = new Vector<Object>();
        v_ul.addElement("(");
        for (i = 0; i < this.UsingList.size(); ++i) {
            if (this.UsingList.elementAt(i) instanceof TableColumn) {
                Vector v_wi = new Vector();
                TableColumn tc = (TableColumn)this.UsingList.elementAt(i);
                tc.setTableName(s_cn);
                v_ul.addElement(tc);
                v_ul.addElement("=");
                TableColumn tcr = new TableColumn();
                tcr.setColumnName(((TableColumn)this.UsingList.elementAt(i)).getColumnName());
                if (this.aliasName != null) {
                    tcr.setTableName(this.aliasName);
                } else {
                    tcr.setTableName(this.tableName.toString());
                }
                v_ul.addElement(tcr);
                continue;
            }
            String s_cd = (String)this.UsingList.elementAt(i);
            if (s_cd.equals(",")) {
                v_ul.addElement("AND");
                continue;
            }
            v_ul.addElement(s_cd);
        }
        v_ul.addElement(")");
        to_ft.setJoinExpression(v_ul);
        to_ft.setOnOrUsingJoin("ON");
    }

    public Object clone() {
        FromTable ft = new FromTable();
        ft.setObjectContext(this.context);
        ft.setIndexHint(this.indexHint);
        ft.setSetOperatorClause(this.setOperatorClauseForFullJoin);
        ft.setTableName(this.tableName);
        ft.setAliasName(this.aliasName);
        ft.setIsAS(this.isAS);
        ft.setJoinClause(this.joinClause);
        ft.setOnOrUsingJoin(this.onOrUsingJoin);
        ft.setJoinExpression(this.joinExpression);
        ft.setUsingList(this.UsingList);
        ft.setLockTableStatement(this.lockTableStatement);
        ft.setWith(this.with);
        ft.setLock(this.lock);
        ft.setTableKeyword(this.tableKeyword);
        ft.setOuter(this.outer);
        ft.setOuterOpenBrace(this.outerOpenBrace);
        ft.setOuterClosedBrace(this.outerClosedBrace);
        ft.setUpdateLock(this.updateLock);
        ft.setHoldLock(this.holdLock);
        ft.setFromClauseOpenBraces(this.fromClauseOpenBraces);
        ft.setFromClauseClosedBraces(this.fromClauseClosedBraces);
        ft.setFromClause(this.fc);
        ft.setOrigTableName(this.origTableName);
        ft.setCommentClass(this.commentObj);
        return ft;
    }

    private WhereExpression getClonedWhereExpression(WhereExpression whereExpression) {
        WhereExpression clonedWhereExpression = new WhereExpression();
        clonedWhereExpression.setOpenBrace(whereExpression.getOpenBrace());
        clonedWhereExpression.setCloseBrace(whereExpression.getCloseBrace());
        clonedWhereExpression.setOperator(whereExpression.getOperator());
        Vector<Object> whereItemList = new Vector<Object>();
        Vector whereItems = whereExpression.getWhereItems();
        Vector clonedWhereItems = new Vector();
        clonedWhereExpression.setOperator((Vector)whereExpression.getOperator().clone());
        for (int i = 0; i < whereItems.size(); ++i) {
            if (whereItems.elementAt(i) instanceof WhereItem) {
                WhereItem whereItem = (WhereItem)((WhereItem)whereItems.elementAt(i)).clone();
                whereItemList.addElement(whereItem);
                continue;
            }
            if (!(whereItems.elementAt(i) instanceof WhereExpression)) continue;
            whereItemList.addElement(this.getClonedWhereExpression((WhereExpression)whereItems.elementAt(i)));
        }
        clonedWhereExpression.setWhereItem(whereItemList);
        return clonedWhereExpression;
    }

    private Vector getTablesOnlyList(Vector vendorList) {
        Vector<FromTable> vembuList = new Vector<FromTable>();
        for (int i = 0; i < vendorList.size(); ++i) {
            if (vendorList.elementAt(i) instanceof FromTable) {
                FromTable ft = (FromTable)vendorList.get(i);
                FromTable fromTable = new FromTable();
                fromTable.setTableName(ft.getTableName());
                fromTable.setAliasName(ft.getAliasName());
                fromTable.setJoinClause(null);
                fromTable.setJoinExpression(null);
                fromTable.setOnOrUsingJoin(null);
                fromTable.setUsingList(null);
                vembuList.addElement(fromTable);
                continue;
            }
            if (!(vendorList.elementAt(i) instanceof FromClause)) continue;
            FromClause newFC = (FromClause)vendorList.get(i);
            Vector newFromItemsList = newFC.getFromItemList();
            this.getTablesOnlyList(newFromItemsList);
        }
        return vembuList;
    }

    public FromTable toOracleSelect(SelectQueryStatement vembuSQS, SelectQueryStatement vendorSQS) throws ConvertException {
        FromTable ft = new FromTable();
        ft.setCommentClass(this.commentObj);
        if (this.tableName != null) {
            if (this.tableName instanceof SelectQueryStatement) {
                ft.setTableName(((SelectQueryStatement)this.tableName).toOracleSelect());
            } else if (this.tableName instanceof FunctionCalls) {
                if (this.tableKeyword != null) {
                    FunctionCalls fn = ((FunctionCalls)this.tableName).toOracleSelect(vembuSQS, vendorSQS);
                    if (fn != null && fn.toString().indexOf("CAST") != -1) {
                        ft.setTableKeyword("TABLE(");
                    }
                    ft.setTableName(fn);
                } else if (this.tableName.toString().toUpperCase().indexOf("(NOLOCK)") == -1) {
                    ft.setTableKeyword("TABLE(");
                    ft.setTableName(((FunctionCalls)this.tableName).toOracleSelect(vembuSQS, vendorSQS));
                } else {
                    ft.setTableName(((FunctionCalls)this.tableName).getFunctionNameAsAString());
                }
            } else if (this.tableName instanceof WithStatement) {
                ft.setTableName(((WithStatement)this.tableName).toOracle());
            } else if (this.tableName instanceof FromClause) {
                FromClause fromCl = (FromClause)this.tableName;
                ft.setTableName(fromCl.toOracleSelect(vembuSQS, vendorSQS));
            } else if (this.tableName instanceof ValuesClause && this.columnAliasList != null) {
                ValuesClause vc = (ValuesClause)this.tableName;
                this.convertTableValueConstructorToSelectUnion(vc, this.columnAliasList, vembuSQS, vendorSQS);
                ft.setTableName("DUAL");
            } else {
                String tt;
                String table_Name_String = (String)this.tableName;
                int dotDotIndex = table_Name_String.indexOf("..");
                String table_name = StringFunctions.replaceFirst(".", "..", (String)this.tableName);
                if (!(ft.getTableName() instanceof SelectQueryStatement)) {
                    ft.setTableName(table_name);
                }
                Vector<String> tokenVector = new Vector<String>();
                StringTokenizer st = new StringTokenizer(table_name, ".");
                int count2 = 0;
                while (st.hasMoreTokens()) {
                    tokenVector.add(st.nextToken());
                    ++count2;
                }
                boolean ownerExistsInSrc = false;
                if (count2 == 3) {
                    tokenVector.remove(1);
                    count2 = 2;
                    ownerExistsInSrc = true;
                }
                if (count2 == 1) {
                    ft.setTableName(CustomizeUtil.objectNamesToQuotedIdentifier((String)ft.getTableName(), SwisSQLUtils.getKeywords(1), null, 1));
                } else if (count2 == 2) {
                    String dataBaseName = (String)tokenVector.elementAt(0);
                    String tableName = (String)tokenVector.elementAt(1);
                    String oracleDataBaseAndTableName = "";
                    tableName = CustomizeUtil.objectNamesToQuotedIdentifier(tableName, SwisSQLUtils.getKeywords(1), null, 1);
                    oracleDataBaseAndTableName = dataBaseName.equalsIgnoreCase("DBO") && this.isTenroxRequirement ? "PUSER." + tableName : (dataBaseName.equalsIgnoreCase("DBO") || dataBaseName.equalsIgnoreCase("tempdb") && (ownerExistsInSrc || dotDotIndex != -1) ? tableName : (SwisSQLOptions.removeOracleSchemaQualifier ? tableName : dataBaseName + "." + tableName));
                    ft.setTableName(oracleDataBaseAndTableName);
                } else if (count2 == 4) {
                    String serverName = (String)tokenVector.elementAt(0);
                    String databaseName = (String)tokenVector.elementAt(1);
                    String tableName = (String)tokenVector.elementAt(3);
                    tableName = CustomizeUtil.objectNamesToQuotedIdentifier(tableName, SwisSQLUtils.getKeywords(1), null, 1);
                    ft.setTableName(databaseName + "." + tableName + "@" + serverName);
                }
                String tempTableName = (String)ft.getTableName();
                String tableNameSubString = "";
                int startIndex = tempTableName.indexOf("[");
                if (startIndex != -1) {
                    while (startIndex != -1) {
                        if (startIndex == 0) {
                            tableNameSubString = tempTableName.substring(1);
                            int endIndex = tableNameSubString.indexOf("]");
                            String temp = tableNameSubString.substring(0, endIndex);
                            if (SwisSQLOptions.retainQuotedIdentifierForOracle || temp.indexOf(" ") != -1) {
                                temp = "\"" + temp + "\"";
                            }
                            tableNameSubString = temp + tableNameSubString.substring(endIndex + 1);
                        } else {
                            tableNameSubString = tempTableName.substring(0, startIndex);
                            String temp = tempTableName.substring(startIndex + 1);
                            int endIndex = temp.indexOf("]");
                            String token = temp.substring(0, endIndex);
                            tableNameSubString = SwisSQLOptions.retainQuotedIdentifierForOracle || token.indexOf(" ") != -1 ? tableNameSubString + "\"" + token + "\"" + temp.substring(endIndex + 1) : tableNameSubString + token + temp.substring(endIndex + 1);
                        }
                        tempTableName = tableNameSubString;
                        startIndex = tableNameSubString.indexOf("[");
                    }
                    ft.setTableName(tableNameSubString);
                }
                if ((tt = (String)ft.getTableName()).startsWith("#")) {
                    tt = tt.substring(1);
                }
                if (tt.startsWith("#")) {
                    tt = tt.substring(1);
                }
                if (tt.startsWith("@")) {
                    tt = "\"" + tt + "\"";
                }
                ft.setTableName(tt);
                if (this.with != null && this.lock != null) {
                    ft.setLock(this.lock);
                    if (this.lock.equalsIgnoreCase("TABLOCK") || this.lock.equalsIgnoreCase("UPDLOCK")) {
                        this.lock = "SHARE";
                    }
                    if (this.lock.equalsIgnoreCase("TABLOCKX")) {
                        this.lock = "EXCLUSIVE";
                    }
                    if (!(this.lock.equalsIgnoreCase("NOLOCK") || this.lock.equalsIgnoreCase("ROWLOCK") || this.lock.equalsIgnoreCase("XLOCK"))) {
                        this.lockTableStatement = "LOCK TABLE " + tt + " IN " + this.lock + " MODE;";
                        if (SwisSQLOptions.handleLOCK_HINTSforOracle) {
                            ft.setLockTableStatement(this.lockTableStatement);
                        }
                    }
                    if (this.lock.equalsIgnoreCase("HOLDLOCK")) {
                        ft.setLockTableStatement(null);
                        ForUpdateStatement forUpdateStmt = new ForUpdateStatement();
                        forUpdateStmt.setForUpdateClause("FOR UPDATE");
                        forUpdateStmt.setForUpdateQualifier("OF");
                        forUpdateStmt.setNoWaitQualifier("NOWAIT");
                        if (SwisSQLOptions.handleLOCK_HINTSforOracle) {
                            vembuSQS.setForUpdateStatement(forUpdateStmt);
                        }
                    }
                }
            }
            if (this.tableName.toString().startsWith("@")) {
                this.tableName = "\"" + this.tableName + "\"";
            }
        }
        if (this.origTableName != null) {
            ft.setOrigTableName(this.origTableName);
        }
        if (this.joinClause != null) {
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL JOIN")) {
                throw new ConvertException(" Natural join are not allowed in Oracle");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL LEFT JOIN")) {
                throw new ConvertException("Conversion failure..Natural left Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL RIGHT JOIN")) {
                throw new ConvertException("Conversion failure..Natural right Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL LEFT OUTER JOIN")) {
                throw new ConvertException("Conversion failure..Natural left Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL RIGHT OUTER JOIN")) {
                throw new ConvertException("Conversion failure..Natural right join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("KEY JOIN")) {
                throw new ConvertException("Conversion failure..Key join is not supported");
            }
            if (SwisSQLAPI.ANSIJOIN_ForOracle) {
                ft.setJoinClause(this.joinClause);
                ft.setOnOrUsingJoin(this.onOrUsingJoin);
                Vector newJoinExpression = new Vector();
                if (this.joinExpression != null) {
                    for (int jCount = 0; jCount < this.joinExpression.size(); ++jCount) {
                        Object o = this.joinExpression.get(jCount);
                        if (o instanceof String) {
                            newJoinExpression.add(o);
                            continue;
                        }
                        if (o instanceof FunctionCalls) {
                            FunctionCalls fc = (FunctionCalls)o;
                            newJoinExpression.add(fc.toOracleSelect(vembuSQS, vendorSQS));
                            continue;
                        }
                        if (o instanceof SelectQueryStatement) {
                            SelectQueryStatement sqsNew = (SelectQueryStatement)o;
                            newJoinExpression.add(sqsNew.toOracleSelect());
                            continue;
                        }
                        if (o instanceof FromClause) {
                            FromClause fcl = (FromClause)o;
                            newJoinExpression.add(fcl.toOracleSelect(vembuSQS, vendorSQS));
                            continue;
                        }
                        if (o instanceof WhereExpression) {
                            WhereExpression wexp = (WhereExpression)o;
                            newJoinExpression.add(wexp.toOracleSelect(vembuSQS, vendorSQS));
                            continue;
                        }
                        if (o instanceof FromTable) {
                            FromTable ftNew = (FromTable)o;
                            newJoinExpression.add(ftNew.toOracleSelect(vembuSQS, vendorSQS));
                            continue;
                        }
                        if (o instanceof TableColumn) {
                            TableColumn tcl = (TableColumn)o;
                            newJoinExpression.add(tcl.toOracleSelect(vembuSQS, vendorSQS));
                            continue;
                        }
                        if (o instanceof WhereItem) {
                            WhereItem wit = (WhereItem)o;
                            newJoinExpression.add(wit.toOracleSelect(vembuSQS, vendorSQS));
                            continue;
                        }
                        if (o instanceof SelectColumn) {
                            SelectColumn scl = (SelectColumn)o;
                            newJoinExpression.add(scl.toOracleSelect(vembuSQS, vendorSQS));
                            continue;
                        }
                        if (o instanceof WhereColumn) {
                            WhereColumn wcl = (WhereColumn)o;
                            newJoinExpression.add(wcl.toOracleSelect(vembuSQS, vendorSQS));
                            continue;
                        }
                        if (o instanceof SelectStatement) {
                            SelectStatement sst = (SelectStatement)o;
                            newJoinExpression.add(sst.toOracleSelect(vembuSQS, vendorSQS));
                            continue;
                        }
                        newJoinExpression.add(o.toString());
                    }
                }
                ft.setJoinExpression(newJoinExpression);
            } else if (this.joinClause.trim().equalsIgnoreCase("FULL JOIN") || this.joinClause.trim().equalsIgnoreCase("FULL OUTER JOIN")) {
                this.insertItem(vembuSQS, vendorSQS, 2, true);
            } else if (this.onOrUsingJoin != null && this.onOrUsingJoin.equalsIgnoreCase("ON") || this.onOrUsingJoin == null && this.joinExpression != null) {
                if (this.joinClause.equalsIgnoreCase("JOIN") || this.joinClause.equalsIgnoreCase("INNER JOIN")) {
                    this.insertItem(vembuSQS, vendorSQS, 1, true);
                } else {
                    this.moveJoinExpressionToWhereExpression(ft, vembuSQS, vendorSQS, true);
                }
            } else if (this.onOrUsingJoin != null && this.onOrUsingJoin.equalsIgnoreCase("USING")) {
                this.insertItem(vembuSQS, vendorSQS, 3, true);
            } else if (this.joinClause.trim().equalsIgnoreCase("cross apply")) {
                SelectQueryStatement sqs;
                ft.setJoinClause(" CROSS JOIN ");
                if (ft.getTableName() instanceof SelectQueryStatement && (sqs = (SelectQueryStatement)ft.getTableName()).getWhereExpression() != null) {
                    WhereExpression we = sqs.getWhereExpression();
                    if (vendorSQS.getWhereExpression() == null) {
                        vendorSQS.setWhereExpression(we);
                        sqs.setWhereExpression(null);
                    } else {
                        WhereExpression weSrc = vendorSQS.getWhereExpression();
                        Vector weOperators = we.getOperator();
                        Vector colExp = we.getWhereItems();
                        for (int i = 0; i < colExp.size(); ++i) {
                            if (colExp.get(i) instanceof WhereItem) {
                                weSrc.addWhereItem((WhereItem)colExp.get(i));
                                if (i == 0) {
                                    weSrc.addOperator("AND");
                                } else {
                                    weSrc.addOperator((String)weOperators.get(i - 1));
                                }
                            }
                            sqs.setWhereExpression(null);
                        }
                    }
                }
            } else if (this.joinClause.trim().equalsIgnoreCase("outer apply")) {
                ft.setJoinClause(" LEFT OUTER JOIN ");
                ft.setOnOrUsingJoin("ON");
                Vector<WhereExpression> newJoinExp = new Vector<WhereExpression>();
                WhereExpression weNew = new WhereExpression();
                Vector<WhereItem> wiVector = new Vector<WhereItem>();
                WhereItem wiNew = new WhereItem();
                WhereColumn leftWhereCol = new WhereColumn();
                WhereColumn rightWhereCol = new WhereColumn();
                Vector<String> whereCols = new Vector<String>();
                String value = "1";
                whereCols.add(value);
                leftWhereCol.setColumnExpression(whereCols);
                rightWhereCol.setColumnExpression(whereCols);
                wiNew.setLeftWhereExp(leftWhereCol);
                wiNew.setRightWhereExp(rightWhereCol);
                wiNew.setOperator("=");
                wiVector.add(wiNew);
                weNew.setWhereItem(wiVector);
                newJoinExp.add(weNew);
                ft.setJoinExpression(newJoinExp);
            }
        }
        ft.setIsAS(false);
        if (this.aliasName != null) {
            this.aliasName = CustomizeUtil.objectNamesToQuotedIdentifier(this.aliasName, SwisSQLUtils.getKeywords(1), null, 1);
            if (this.aliasName.charAt(0) == '\'') {
                ft.setAliasName(this.aliasName.replace('\'', '\"'));
            } else {
                ft.setAliasName(this.aliasName);
            }
            if (this.aliasName.startsWith("[") && this.aliasName.endsWith("]") || this.aliasName.startsWith("`") && this.aliasName.endsWith("`")) {
                this.aliasName = this.aliasName.substring(1, this.aliasName.length() - 1);
                if (SwisSQLOptions.retainQuotedIdentifierForOracle || this.aliasName.indexOf(32) != -1) {
                    this.aliasName = "\"" + this.aliasName + "\"";
                }
                ft.setAliasName(this.aliasName);
            }
        }
        return ft;
    }

    public FromTable toInformixSelect(SelectQueryStatement vembuSQS, SelectQueryStatement vendorSQS) throws ConvertException {
        FromTable ft = new FromTable();
        if (this.joinClause != null) {
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL JOIN")) {
                throw new ConvertException("Conversion failure..Natural join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL LEFT JOIN")) {
                throw new ConvertException("Conversion failure..Natural left Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL RIGHT JOIN")) {
                throw new ConvertException("Conversion failure..Natural right Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL LEFT OUTER JOIN")) {
                throw new ConvertException("Conversion failure..Natural left Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL RIGHT OUTER JOIN")) {
                throw new ConvertException("Conversion failure..Natural right join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("KEY JOIN")) {
                throw new ConvertException("Conversion failure..Key join is not supported");
            }
            if (this.joinClause.trim().equalsIgnoreCase("FULL JOIN")) {
                ft.setJoinClause(null);
                this.insertItem(vembuSQS, vendorSQS, 2, true);
            } else if (this.onOrUsingJoin != null && this.onOrUsingJoin.equalsIgnoreCase("ON") || this.onOrUsingJoin == null && this.joinExpression != null) {
                if (this.joinClause.equalsIgnoreCase("JOIN") || this.joinClause.equalsIgnoreCase("INNER JOIN")) {
                    ft.setJoinClause(null);
                    this.insertItem(vembuSQS, vendorSQS, 1, true);
                } else {
                    ft.setJoinClause("OUTER");
                    this.insertItem(vembuSQS, vendorSQS, 4, true);
                }
            } else if (this.onOrUsingJoin != null && this.onOrUsingJoin.equalsIgnoreCase("USING")) {
                this.insertItem(vembuSQS, vendorSQS, 3, true);
            }
        }
        if (this.getOuter() != null) {
            ft.setOuter(this.outer);
            if (this.getOuterOpenBrace() != null) {
                ft.setOuterOpenBrace(this.outerOpenBrace);
            }
            if (this.outerClosedBrace != null) {
                ft.setOuterClosedBrace(this.outerClosedBrace);
            }
        }
        if (this.outerClosedBrace != null) {
            ft.setOuterClosedBrace(this.outerClosedBrace);
        }
        if (this.tableName != null) {
            if (this.tableName instanceof SelectQueryStatement) {
                ft.setTableName(((SelectQueryStatement)this.tableName).toInformixSelect());
            } else if (this.tableName instanceof FunctionCalls) {
                ft.setTableName(((FunctionCalls)this.tableName).toInformixSelect(vembuSQS, vendorSQS));
            } else if (this.tableName instanceof WithStatement) {
                ft.setTableName(((WithStatement)this.tableName).toInformix());
            } else if (this.tableName instanceof FromClause) {
                ft.setTableName(((FromClause)this.tableName).toInformixSelect(vembuSQS, vendorSQS));
            } else {
                String dataBaseTableName;
                String table_Name_String = (String)this.tableName;
                int atIndex = table_Name_String.indexOf("@");
                String table_name = StringFunctions.replaceFirst(".", "..", (String)this.tableName);
                if (!(ft.getTableName() instanceof SelectQueryStatement)) {
                    ft.setTableName(table_name);
                }
                Vector<String> tokenVector = new Vector<String>();
                String table_Name = (String)this.tableName;
                StringTokenizer st = new StringTokenizer(table_Name, ".");
                int count2 = 0;
                while (st.hasMoreTokens()) {
                    tokenVector.add(st.nextToken());
                    ++count2;
                }
                if (count2 == 1 && atIndex != -1) {
                    dataBaseTableName = (String)tokenVector.elementAt(0);
                    String sqlTableName = dataBaseTableName.substring(0, atIndex);
                    String sqlDataBaseName = dataBaseTableName.substring(atIndex + 1);
                    String sqlDataBaseAndTableName = sqlDataBaseName + "." + sqlTableName;
                    ft.setTableName(sqlDataBaseAndTableName);
                } else if (count2 == 2 && atIndex != -1) {
                    dataBaseTableName = (String)tokenVector.elementAt(1);
                    int tableAtIndex = dataBaseTableName.indexOf("@");
                    String sqlTableName = dataBaseTableName.substring(0, tableAtIndex);
                    String sqlDataBaseName = dataBaseTableName.substring(tableAtIndex + 1);
                    String sqlDataBaseAndTableName = sqlDataBaseName + "." + (String)tokenVector.elementAt(0) + "." + sqlTableName;
                    ft.setTableName(sqlDataBaseAndTableName);
                }
                String tempTableName = (String)ft.getTableName();
                String tableNameSubString = "";
                int startIndex = tempTableName.indexOf("[");
                if (startIndex != -1) {
                    while (startIndex != -1) {
                        if (startIndex == 0) {
                            tableNameSubString = tempTableName.substring(1);
                            tableNameSubString = "\"" + tableNameSubString;
                            tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                            startIndex = tableNameSubString.indexOf("[");
                            continue;
                        }
                        tableNameSubString = tempTableName.substring(0, startIndex);
                        tableNameSubString = tableNameSubString + "\"";
                        tableNameSubString = tableNameSubString + tempTableName.substring(startIndex + 1);
                        tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                        startIndex = tableNameSubString.indexOf("[");
                    }
                    ft.setTableName(tableNameSubString);
                }
            }
        }
        ft.setIsAS(this.isAS);
        if (this.aliasName != null) {
            ft.setAliasName(this.aliasName);
        } else if (this.tableName instanceof SelectQueryStatement) {
            ft.setAliasName("SwisSQL_ALIAS" + (this.getFromTableIndexFromFromItemList(vendorSQS) + 1));
        }
        return ft;
    }

    public FromTable toTimesTenSelect(SelectQueryStatement vembuSQS, SelectQueryStatement vendorSQS) throws ConvertException {
        FromTable ft = new FromTable();
        if (this.tableName != null) {
            if (this.tableName instanceof SelectQueryStatement) {
                ft.setTableName(((SelectQueryStatement)this.tableName).toTimesTenSelect());
            } else if (!(this.tableName instanceof FunctionCalls)) {
                if (this.tableName instanceof FromClause) {
                    FromClause fromCl = (FromClause)this.tableName;
                    ft.setTableName(fromCl.toTimesTenSelect(vembuSQS, vendorSQS));
                } else {
                    String tt;
                    String table_Name_String = (String)this.tableName;
                    int dotDotIndex = table_Name_String.indexOf("..");
                    ft.setTableName(table_Name_String);
                    if (dotDotIndex != -1) {
                        ft.setTableName(table_Name_String.substring(table_Name_String.lastIndexOf(".") + 1, table_Name_String.length()));
                        ft.setTableName(CustomizeUtil.objectNamesToQuotedIdentifier((String)ft.getTableName(), SwisSQLUtils.getKeywords(10), null, 10));
                    } else {
                        Vector<String> tokenVector = new Vector<String>();
                        StringTokenizer st = new StringTokenizer(table_Name_String, ".");
                        int count2 = 0;
                        while (st.hasMoreTokens()) {
                            tokenVector.add(st.nextToken());
                            ++count2;
                        }
                        if (count2 == 1) {
                            ft.setTableName(CustomizeUtil.objectNamesToQuotedIdentifier((String)ft.getTableName(), SwisSQLUtils.getKeywords(10), null, 10));
                        } else if (count2 == 2) {
                            String ownerName = (String)tokenVector.elementAt(0);
                            String tableName = (String)tokenVector.elementAt(1);
                            tableName = CustomizeUtil.objectNamesToQuotedIdentifier(tableName, SwisSQLUtils.getKeywords(10), null, 10);
                            if (ownerName.equalsIgnoreCase("DBO")) {
                                ft.setTableName(tableName);
                            } else {
                                ft.setTableName(ownerName + "." + tableName);
                            }
                        } else if (count2 == 3) {
                            String dataBaseName = (String)tokenVector.elementAt(0);
                            String ownerName = (String)tokenVector.elementAt(1);
                            String tableName = (String)tokenVector.elementAt(2);
                            tableName = CustomizeUtil.objectNamesToQuotedIdentifier(tableName, SwisSQLUtils.getKeywords(10), null, 10);
                            if (ownerName.equalsIgnoreCase("DBO")) {
                                ft.setTableName(tableName);
                            } else {
                                ft.setTableName(ownerName + "." + tableName);
                            }
                        }
                    }
                    String tempTableName = (String)ft.getTableName();
                    String tableNameSubString = "";
                    int startIndex = tempTableName.indexOf("[");
                    if (startIndex != -1) {
                        while (startIndex != -1) {
                            if (startIndex == 0) {
                                int endIndex;
                                tableNameSubString = tempTableName.substring(1);
                                String temp = tableNameSubString.substring(0, endIndex = tableNameSubString.indexOf("]"));
                                if (temp.indexOf(" ") != -1) {
                                    temp = "\"" + temp + "\"";
                                }
                                tableNameSubString = temp + tableNameSubString.substring(endIndex + 1);
                            } else {
                                int endIndex;
                                tableNameSubString = tempTableName.substring(0, startIndex);
                                String temp = tempTableName.substring(startIndex + 1);
                                String token = temp.substring(0, endIndex = temp.indexOf("]"));
                                tableNameSubString = token.indexOf(" ") != -1 ? tableNameSubString + "\"" + token + "\"" + temp.substring(endIndex + 1) : tableNameSubString + token + temp.substring(endIndex + 1);
                            }
                            tempTableName = tableNameSubString;
                            startIndex = tableNameSubString.indexOf("[");
                        }
                        ft.setTableName(tableNameSubString);
                    }
                    if ((tt = (String)ft.getTableName()).equalsIgnoreCase("dual") || tt.equalsIgnoreCase("sys.dual")) {
                        tt = "MONITOR";
                    }
                    ft.setTableName(tt);
                }
            }
        }
        if (this.joinClause != null) {
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL JOIN")) {
                throw new ConvertException("Natural joins are not allowed in TimesTen");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL LEFT JOIN")) {
                throw new ConvertException("Conversion failure..Natural left Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL RIGHT JOIN")) {
                throw new ConvertException("Conversion failure..Natural right Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL LEFT OUTER JOIN")) {
                throw new ConvertException("Conversion failure..Natural left Outer join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("NATURAL RIGHT OUTER JOIN")) {
                throw new ConvertException("Conversion failure..Natural right join can't be converted");
            }
            if (this.joinClause.trim().equalsIgnoreCase("KEY JOIN")) {
                throw new ConvertException("Conversion failure..Key join is not supported");
            }
            if (this.joinClause.trim().equalsIgnoreCase("FULL JOIN") || this.joinClause.trim().equalsIgnoreCase("FULL OUTER JOIN")) {
                this.insertItem(vembuSQS, vendorSQS, 2, false);
            } else if (this.onOrUsingJoin != null && this.onOrUsingJoin.equalsIgnoreCase("ON") || this.onOrUsingJoin == null && this.joinExpression != null) {
                if (this.joinClause.equalsIgnoreCase("JOIN") || this.joinClause.equalsIgnoreCase("INNER JOIN")) {
                    this.insertItem(vembuSQS, vendorSQS, 1, false);
                } else {
                    this.moveJoinExpressionToWhereExpression(ft, vembuSQS, vendorSQS, false);
                }
            } else if (this.onOrUsingJoin != null && this.onOrUsingJoin.equalsIgnoreCase("USING")) {
                this.insertItem(vembuSQS, vendorSQS, 3, false);
            }
        }
        ft.setIsAS(false);
        if (this.aliasName != null) {
            if (this.aliasName.charAt(0) == '\'') {
                ft.setAliasName(this.aliasName.replace('\'', '\"'));
            } else {
                this.aliasName = CustomizeUtil.objectNamesToQuotedIdentifier(this.aliasName, SwisSQLUtils.getKeywords(10), null, 10);
                ft.setAliasName(this.aliasName);
            }
        }
        return ft;
    }

    public FromTable toNetezzaSelect(SelectQueryStatement vembuSQS, SelectQueryStatement vendorSQS) throws ConvertException {
        WhereExpression we;
        FromTable ft = new FromTable();
        ft.setTableKeyword(this.tableKeyword);
        if (this.tableName != null) {
            if (this.tableName instanceof SelectQueryStatement) {
                ft.setTableName(((SelectQueryStatement)this.tableName).toNetezzaSelect());
            } else {
                if (this.tableName instanceof FunctionCalls) {
                    throw new ConvertException("Functions yet to be supported in table names");
                }
                if (this.tableName instanceof WithStatement) {
                    ft.setTableName(((WithStatement)this.tableName).toNetezza());
                } else if (this.tableName instanceof FromClause) {
                    ft.setTableName(((FromClause)this.tableName).toNetezzaSelect(vembuSQS, vendorSQS));
                } else {
                    String dataBaseTableName;
                    String table_Name_String = (String)this.tableName;
                    int atIndex = table_Name_String.indexOf("@");
                    String replaceDotDot = StringFunctions.replaceFirst(".", "..", (String)this.tableName);
                    ft.setTableName(CustomizeUtil.objectNamesToQuotedIdentifier(replaceDotDot, SwisSQLUtils.getKeywords(11), null, 11));
                    Vector<String> tokenVector = new Vector<String>();
                    String table_Name = (String)this.tableName;
                    StringTokenizer st = new StringTokenizer(table_Name, ".");
                    int count2 = 0;
                    while (st.hasMoreTokens()) {
                        tokenVector.add(st.nextToken());
                        ++count2;
                    }
                    if (count2 == 1 && atIndex != -1) {
                        dataBaseTableName = (String)tokenVector.elementAt(0);
                        String sqlTableName = dataBaseTableName.substring(0, atIndex);
                        String sqlDataBaseName = dataBaseTableName.substring(atIndex + 1);
                        String sqlDataBaseAndTableName = sqlDataBaseName + "." + sqlTableName;
                        ft.setTableName(sqlDataBaseAndTableName);
                    } else if (count2 == 2 && atIndex != -1) {
                        dataBaseTableName = (String)tokenVector.elementAt(1);
                        int tableAtIndex = dataBaseTableName.indexOf("@");
                        if (tableAtIndex != -1) {
                            String sqlTableName = dataBaseTableName.substring(0, tableAtIndex);
                            String sqlDataBaseName = dataBaseTableName.substring(tableAtIndex + 1);
                            String sqlDataBaseAndTableName = sqlDataBaseName + "." + (String)tokenVector.elementAt(0) + "." + sqlTableName;
                            ft.setTableName(sqlDataBaseAndTableName);
                        } else {
                            ft.setTableName(this.tableName);
                        }
                    }
                    String tempTableName = (String)ft.getTableName();
                    String tableNameSubString = "";
                    int startIndex = tempTableName.indexOf("[");
                    if (startIndex != -1) {
                        while (startIndex != -1) {
                            if (startIndex == 0) {
                                tableNameSubString = tempTableName.substring(1);
                                tableNameSubString = "\"" + tableNameSubString;
                                tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                                startIndex = tableNameSubString.indexOf("[");
                                continue;
                            }
                            tableNameSubString = tempTableName.substring(0, startIndex);
                            tableNameSubString = tableNameSubString + "\"";
                            tableNameSubString = tableNameSubString + tempTableName.substring(startIndex + 1);
                            tempTableName = tableNameSubString = StringFunctions.replaceFirst("\"", "]", tableNameSubString);
                            startIndex = tableNameSubString.indexOf("[");
                        }
                        ft.setTableName(tableNameSubString);
                    }
                    if (count2 == 1 && atIndex == -1) {
                        ft.setTableName(CustomizeUtil.objectNamesToQuotedIdentifier((String)ft.getTableName(), SwisSQLUtils.getKeywords(11), null, 11));
                    } else if (count2 == 2 && atIndex == -1) {
                        String ownerName = (String)tokenVector.elementAt(0);
                        String tableName = (String)tokenVector.elementAt(1);
                        ownerName = CustomizeUtil.objectNamesToQuotedIdentifier(ownerName, SwisSQLUtils.getKeywords(11), null, 11);
                        tableName = CustomizeUtil.objectNamesToQuotedIdentifier(tableName, SwisSQLUtils.getKeywords(11), null, 11);
                        if (ownerName.equalsIgnoreCase("DBO")) {
                            ft.setTableName(tableName);
                        } else if (SwisSQLOptions.renameTableNameAsSchemName_TableName && !ownerName.startsWith("\"") && !tableName.startsWith("\"")) {
                            ft.setTableName(ownerName + "." + ownerName + "_" + tableName);
                        } else {
                            ft.setTableName(ownerName + "." + tableName);
                        }
                    } else if (count2 == 3 && atIndex == -1) {
                        String dataBaseName = (String)tokenVector.elementAt(0);
                        String ownerName = (String)tokenVector.elementAt(1);
                        String tableName = (String)tokenVector.elementAt(2);
                        dataBaseName = CustomizeUtil.objectNamesToQuotedIdentifier(dataBaseName, SwisSQLUtils.getKeywords(11), null, 11);
                        ownerName = CustomizeUtil.objectNamesToQuotedIdentifier(ownerName, SwisSQLUtils.getKeywords(11), null, 11);
                        tableName = CustomizeUtil.objectNamesToQuotedIdentifier(tableName, SwisSQLUtils.getKeywords(11), null, 11);
                        if (ownerName.equalsIgnoreCase("DBO")) {
                            ft.setTableName(tableName);
                        } else if (SwisSQLOptions.renameTableNameAsSchemName_TableName && !ownerName.startsWith("\"") && !tableName.startsWith("\"") && !dataBaseName.startsWith("\"")) {
                            ft.setTableName(dataBaseName + "." + ownerName + "." + ownerName + "_" + tableName);
                        } else {
                            ft.setTableName(dataBaseName + "." + ownerName + "." + tableName);
                        }
                    }
                }
            }
        }
        if (this.onOrUsingJoin == null && this.joinExpression != null) {
            ft.setOnOrUsingJoin("ON");
            we = ((WhereExpression)this.joinExpression.elementAt(0)).toNetezzaSelect(vembuSQS, vendorSQS);
            Vector<WhereExpression> v = new Vector<WhereExpression>();
            v.addElement(we);
            ft.setJoinExpression(v);
        } else if (this.onOrUsingJoin != null && this.onOrUsingJoin.equalsIgnoreCase("USING")) {
            this.changeToOnJoin(ft, this.getPreviousFromTableFromTheFromItemList(vendorSQS));
        } else if (this.joinExpression != null) {
            ft.setOnOrUsingJoin(this.onOrUsingJoin);
            we = (WhereExpression)this.joinExpression.elementAt(0);
            Vector operatorList = we.getOperator();
            we.setOperator(operatorList);
            we.toNetezzaSelect(vembuSQS, vendorSQS);
            Vector<WhereExpression> v = new Vector<WhereExpression>();
            v.addElement(we);
            ft.setJoinExpression(v);
        }
        if (this.getOuter() != null) {
            ft.setOuter(this.outer);
            if (this.getOuterOpenBrace() != null) {
                ft.setOuterOpenBrace(this.outerOpenBrace);
            }
            if (this.outerClosedBrace != null) {
                ft.setOuterClosedBrace(this.outerClosedBrace);
            }
        }
        if (this.outerClosedBrace != null) {
            ft.setOuterClosedBrace(this.outerClosedBrace);
        }
        ft.setIsAS(this.isAS);
        if (!(this.aliasName == null || this.aliasName.equalsIgnoreCase("partition") && this.columnAliasList != null)) {
            if (this.aliasName.charAt(0) == '\'') {
                ft.setAliasName(this.aliasName.replace('\'', '\"'));
            } else {
                ft.setAliasName(this.aliasName);
            }
        } else if (this.tableName instanceof SelectQueryStatement) {
            ft.setAliasName("SwisSQL_ALIAS" + (this.getFromTableIndexFromFromItemList(vendorSQS) + 1));
        }
        ft.setJoinClause(this.joinClause);
        return ft;
    }

    private void moveJoinExpressionToWhereExpression(FromTable ft, SelectQueryStatement vembuSQS, SelectQueryStatement vendorSQS, boolean toOracle) throws ConvertException {
        WhereExpression joinWE = null;
        Vector whereItemList = new Vector();
        Vector operatorList = new Vector();
        Vector whereItemListWithoutJoin = new Vector();
        Vector operatorListWithoutJoin = new Vector();
        Object obj = this.joinExpression.elementAt(0);
        if (obj instanceof WhereExpression) {
            joinWE = (WhereExpression)obj;
            joinWE.loadWhereItemsOperators(whereItemList, operatorList);
        }
        SelectQueryStatement selectQueryStatement = null;
        SelectStatement selectStatement = null;
        Vector<String> selectItemList = null;
        FromClause fromClause = null;
        Vector<FromTable> fromItemList = null;
        FromTable fromTable = null;
        WhereExpression whereExpression = null;
        boolean isRightOuterJoin = false;
        for (int i = 0; i < whereItemList.size(); ++i) {
            TableColumn rightTableColumn;
            WhereItem whereItem = (WhereItem)whereItemList.elementAt(i);
            Vector operators = (Vector)operatorList.elementAt(i);
            WhereColumn leftItem = null;
            Vector leftColumnExpression = null;
            WhereColumn rightItem = null;
            Vector rightColumnExpression = null;
            if (whereItem != null) {
                leftItem = whereItem.getLeftWhereExp();
                if (leftItem != null) {
                    leftColumnExpression = leftItem.getColumnExpression();
                }
                if ((rightItem = whereItem.getRightWhereExp()) != null) {
                    rightColumnExpression = rightItem.getColumnExpression();
                }
            }
            if (rightColumnExpression != null) {
                // empty if block
            }
            if ((leftColumnExpression != null && !(leftColumnExpression.elementAt(0) instanceof TableColumn) || rightColumnExpression != null && !(rightColumnExpression.elementAt(0) instanceof TableColumn) || leftColumnExpression == null || rightColumnExpression == null) && toOracle) {
                String oneOfTheTableNames = null;
                if (leftColumnExpression != null && leftColumnExpression.elementAt(0) instanceof TableColumn) {
                    TableColumn leftTableColumn = (TableColumn)leftColumnExpression.elementAt(0);
                    oneOfTheTableNames = leftTableColumn.getTableName();
                } else if (rightColumnExpression != null && rightColumnExpression.elementAt(0) instanceof TableColumn) {
                    rightTableColumn = (TableColumn)rightColumnExpression.elementAt(0);
                    oneOfTheTableNames = rightTableColumn.getTableName();
                }
                if (this.aliasName == null && this.tableName instanceof String) {
                    this.aliasName = this.tableName.toString();
                } else if (this.aliasName != null || !(this.tableName instanceof String)) {
                    // empty if block
                }
                if (this.joinClause.equalsIgnoreCase("LEFT OUTER JOIN") || this.joinClause.equalsIgnoreCase("LEFT JOIN")) {
                    if (this.tableName instanceof String && this.tableName.toString().equalsIgnoreCase(oneOfTheTableNames) || this.aliasName != null && this.aliasName.equalsIgnoreCase(oneOfTheTableNames) || oneOfTheTableNames == null) {
                        WhereExpression weClone;
                        if (selectQueryStatement == null) {
                            if (this.tableName != null && this.tableName instanceof SelectQueryStatement) {
                                if (((SelectQueryStatement)this.tableName).getWhereExpression() != null) {
                                    WhereExpression orgWhereExpression = ((SelectQueryStatement)this.tableName).getWhereExpression();
                                    WhereExpression weClone2 = this.getClonedWhereExpression(joinWE.toOracleSelect(vembuSQS, vendorSQS));
                                    whereExpression = this.createNewWhereExpressionByRemovingTheJOINConditions(weClone2);
                                    this.collectAllWhereColumnsInWhereExpression(whereExpression);
                                    orgWhereExpression.addWhereExpression(whereExpression);
                                    orgWhereExpression.addOperator("AND");
                                    ft.setAliasName(this.aliasName);
                                    ft.setTableName(this.tableName);
                                    selectQueryStatement = ((SelectQueryStatement)this.tableName).toOracleSelect();
                                } else {
                                    weClone = this.getClonedWhereExpression(joinWE.toOracleSelect(vembuSQS, vendorSQS));
                                    whereExpression = this.createNewWhereExpressionByRemovingTheJOINConditions(weClone);
                                    ((SelectQueryStatement)this.tableName).setWhereExpression(whereExpression);
                                    this.collectAllWhereColumnsInWhereExpression(whereExpression);
                                    ft.setAliasName(this.aliasName);
                                    ft.setTableName(this.tableName);
                                    selectQueryStatement = ((SelectQueryStatement)this.tableName).toOracleSelect();
                                }
                            } else {
                                selectQueryStatement = new SelectQueryStatement();
                                selectStatement = new SelectStatement();
                                selectStatement.setSelectClause("SELECT");
                                selectItemList = new Vector();
                                selectItemList.addElement("*");
                                selectStatement.setSelectItemList(selectItemList);
                                fromClause = new FromClause();
                                fromClause.setFromClause("FROM");
                                fromItemList = new Vector<FromTable>();
                                fromTable = new FromTable();
                                fromTable.setTableName(this.tableName);
                                fromTable.setAliasName(this.aliasName);
                                fromItemList.add(fromTable);
                                fromClause.setFromItemList(fromItemList);
                                selectQueryStatement.setSelectStatement(selectStatement);
                                selectQueryStatement.setFromClause(fromClause);
                                weClone = this.getClonedWhereExpression(joinWE.toOracleSelect(vembuSQS, vendorSQS));
                                whereExpression = this.createNewWhereExpressionByRemovingTheJOINConditions(weClone);
                                selectQueryStatement.setWhereExpression(whereExpression);
                            }
                        } else {
                            weClone = this.getClonedWhereExpression(joinWE.toOracleSelect(vembuSQS, vendorSQS));
                            whereExpression = this.createNewWhereExpressionByRemovingTheJOINConditions(weClone);
                            selectQueryStatement.setWhereExpression(whereExpression);
                        }
                        ft.setAliasName(this.aliasName);
                        ft.setTableName(selectQueryStatement);
                        continue;
                    }
                    if (selectQueryStatement == null) {
                        selectQueryStatement = new SelectQueryStatement();
                        selectStatement = new SelectStatement();
                        selectStatement.setSelectClause("SELECT");
                        selectItemList = new Vector<String>();
                        selectItemList.addElement(this.aliasName + ".*");
                        selectStatement.setSelectItemList(selectItemList);
                        fromClause = new FromClause();
                        FromClause vendorFromClause = vendorSQS.getFromClause();
                        Vector vendorFromItemList = vendorFromClause.getFromItemList();
                        Vector vembuFromItemList = new Vector();
                        vembuFromItemList = this.getTablesOnlyList(vendorFromItemList);
                        fromClause.setFromClause("FROM");
                        fromClause.setFromItemList(vembuFromItemList);
                        whereExpression = new WhereExpression();
                        whereExpression = this.getClonedWhereExpression(joinWE.toOracleSelect(vembuSQS, vendorSQS));
                        selectQueryStatement.setSelectStatement(selectStatement);
                        selectQueryStatement.setFromClause(fromClause);
                        selectQueryStatement.setWhereExpression(whereExpression);
                    }
                    ft.setAliasName(this.aliasName);
                    ft.setTableName(selectQueryStatement);
                    continue;
                }
                if (!this.joinClause.equalsIgnoreCase("RIGHT OUTER JOIN") && !this.joinClause.equalsIgnoreCase("RIGHT JOIN")) continue;
                FromTable previousFromTable = this.getPreviousFromTableFromTheFromItemList(vendorSQS);
                Object previousTableName = null;
                String previousAliasName = null;
                if (previousFromTable != null) {
                    if (previousFromTable.getTableName() instanceof String) {
                        previousTableName = previousFromTable.getTableName();
                    }
                    if ((previousAliasName = previousFromTable.getAliasName()) == null && previousTableName instanceof String) {
                        previousAliasName = (String)previousTableName;
                    } else if (previousAliasName != null || !(previousTableName instanceof String)) {
                        // empty if block
                    }
                }
                FromTable toBeChangedConvertedPreviousFromTable = null;
                if (vembuSQS.getFromClause() != null && vembuSQS.getFromClause().getFromItemList() != null && vembuSQS.getFromClause().getFromItemList().size() > 0 && vembuSQS.getFromClause().getFromItemList().lastElement() != null && vembuSQS.getFromClause().getFromItemList().lastElement() instanceof FromTable) {
                    toBeChangedConvertedPreviousFromTable = (FromTable)vembuSQS.getFromClause().getFromItemList().lastElement();
                } else if (vembuSQS.getFromClause() != null && vembuSQS.getFromClause().getFromItemList() != null && vembuSQS.getFromClause().getFromItemList().size() > 0 && vembuSQS.getFromClause().getFromItemList().lastElement() != null && vembuSQS.getFromClause().getFromItemList().lastElement() instanceof FromClause) {
                    FromClause fc = (FromClause)vembuSQS.getFromClause().getFromItemList().lastElement();
                    Vector fromItemsList = fc.getFromItemList();
                    toBeChangedConvertedPreviousFromTable = fc.getLastElement();
                }
                if (previousTableName != null && (previousTableName.toString().equalsIgnoreCase(oneOfTheTableNames) || previousAliasName.equalsIgnoreCase(oneOfTheTableNames) || oneOfTheTableNames == null)) {
                    WhereExpression weClone;
                    if (selectQueryStatement == null) {
                        selectQueryStatement = new SelectQueryStatement();
                        selectStatement = new SelectStatement();
                        selectStatement.setSelectClause("SELECT");
                        selectItemList = new Vector();
                        selectItemList.addElement("*");
                        selectStatement.setSelectItemList(selectItemList);
                        fromClause = new FromClause();
                        fromClause.setFromClause("FROM");
                        fromItemList = new Vector();
                        fromTable = new FromTable();
                        fromTable.setTableName(previousTableName);
                        fromTable.setAliasName(previousAliasName);
                        fromItemList.add(fromTable);
                        fromClause.setFromItemList(fromItemList);
                        selectQueryStatement.setSelectStatement(selectStatement);
                        selectQueryStatement.setFromClause(fromClause);
                        weClone = this.getClonedWhereExpression(joinWE.toOracleSelect(vembuSQS, vendorSQS));
                        whereExpression = this.createNewWhereExpressionByRemovingTheJOINConditions(weClone);
                        selectQueryStatement.setWhereExpression(whereExpression);
                    } else {
                        weClone = this.getClonedWhereExpression(joinWE.toOracleSelect(vembuSQS, vendorSQS));
                        whereExpression = this.createNewWhereExpressionByRemovingTheJOINConditions(weClone);
                        selectQueryStatement.setWhereExpression(whereExpression);
                    }
                    toBeChangedConvertedPreviousFromTable.setAliasName(previousAliasName);
                    toBeChangedConvertedPreviousFromTable.setTableName(selectQueryStatement);
                    continue;
                }
                if (selectQueryStatement == null) {
                    selectQueryStatement = new SelectQueryStatement();
                    selectStatement = new SelectStatement();
                    selectStatement.setSelectClause("SELECT");
                    selectItemList = new Vector();
                    selectItemList.addElement(this.aliasName + ".*");
                    selectStatement.setSelectItemList(selectItemList);
                    fromClause = new FromClause();
                    FromClause vendorFromClause = vendorSQS.getFromClause();
                    Vector vendorFromItemList = vendorFromClause.getFromItemList();
                    Vector vembuFromItemList = new Vector();
                    vembuFromItemList = this.getTablesOnlyList(vendorFromItemList);
                    fromClause.setFromClause("FROM");
                    fromClause.setFromItemList(vembuFromItemList);
                    whereExpression = new WhereExpression();
                    whereExpression = this.getClonedWhereExpression(joinWE.toOracleSelect(vembuSQS, vendorSQS));
                    selectQueryStatement.setSelectStatement(selectStatement);
                    selectQueryStatement.setFromClause(fromClause);
                    selectQueryStatement.setWhereExpression(whereExpression);
                }
                if (toBeChangedConvertedPreviousFromTable == null) continue;
                toBeChangedConvertedPreviousFromTable.setAliasName(this.aliasName);
                toBeChangedConvertedPreviousFromTable.setTableName(selectQueryStatement);
                continue;
            }
            if (leftColumnExpression == null || !(leftColumnExpression.elementAt(0) instanceof TableColumn)) continue;
            TableColumn leftTableColumn = (TableColumn)leftColumnExpression.elementAt(0);
            if (leftTableColumn != null && leftTableColumn.getTableName() != null) {
                if (rightColumnExpression != null && rightColumnExpression.elementAt(0) instanceof TableColumn) {
                    rightTableColumn = (TableColumn)rightColumnExpression.elementAt(0);
                    if (rightTableColumn != null && rightTableColumn.getTableName() != null) {
                        Vector fromItemListVector;
                        FromClause fromClauseInsideFT;
                        SelectColumn sc;
                        String temp;
                        Vector v;
                        String tabName;
                        String tableNameExtracted;
                        FunctionCalls fc;
                        String tableNameExtracted2;
                        String rightTableName = rightTableColumn.getTableName();
                        if (this.joinClause.equalsIgnoreCase("LEFT OUTER JOIN") || this.joinClause.equalsIgnoreCase("LEFT JOIN")) {
                            if (this.tableName instanceof String) {
                                tableNameExtracted2 = null;
                                if (this.tableName.toString().lastIndexOf(".") != -1) {
                                    tableNameExtracted2 = this.tableName.toString().substring(this.tableName.toString().lastIndexOf(".") + 1);
                                }
                                if (tableNameExtracted2 != null && tableNameExtracted2.equalsIgnoreCase(rightTableName) || ((String)this.tableName).equalsIgnoreCase(rightTableName) || this.aliasName != null && this.aliasName.equalsIgnoreCase(rightTableName)) {
                                    whereItem.setLeftJoin("+");
                                    continue;
                                }
                                whereItem.setRightJoin("+");
                                continue;
                            }
                            if (this.tableName instanceof FunctionCalls) {
                                fc = (FunctionCalls)this.tableName;
                                tableNameExtracted = null;
                                tabName = fc.getFunctionName().getColumnName();
                                if (tabName.toString().lastIndexOf(".") != -1) {
                                    tableNameExtracted = tabName.toString().substring(tabName.toString().lastIndexOf(".") + 1);
                                }
                                if ((v = fc.getFunctionArguments()).size() != 1 || !(v.get(0) instanceof SelectColumn) || !(temp = (sc = (SelectColumn)v.get(0)).toString()).trim().equalsIgnoreCase("NOLOCK")) continue;
                                if (tableNameExtracted != null && tableNameExtracted.equalsIgnoreCase(rightTableName) || tabName.equalsIgnoreCase(rightTableName) || this.aliasName != null && this.aliasName.equalsIgnoreCase(rightTableName)) {
                                    whereItem.setLeftJoin("+");
                                    continue;
                                }
                                whereItem.setRightJoin("+");
                                continue;
                            }
                            if (this.tableName instanceof SelectQueryStatement) {
                                if (this.aliasName != null && this.aliasName.equalsIgnoreCase(rightTableName)) {
                                    whereItem.setLeftJoin("+");
                                    continue;
                                }
                                whereItem.setRightJoin("+");
                                continue;
                            }
                            if (!(this.tableName instanceof FromClause)) continue;
                            fromClauseInsideFT = (FromClause)this.tableName;
                            fromItemListVector = fromClauseInsideFT.getFromItemList();
                            this.getLeftJoinInWhereItemForTableNameAsFromClause(fromItemListVector, rightTableName, this.aliasName, whereItem);
                            continue;
                        }
                        if (!this.joinClause.equalsIgnoreCase("RIGHT OUTER JOIN") && !this.joinClause.equalsIgnoreCase("RIGHT JOIN")) continue;
                        isRightOuterJoin = true;
                        if (this.tableName instanceof String) {
                            tableNameExtracted2 = null;
                            if (this.tableName.toString().lastIndexOf(".") != -1) {
                                tableNameExtracted2 = this.tableName.toString().substring(this.tableName.toString().lastIndexOf(".") + 1);
                            }
                            if (tableNameExtracted2 != null && tableNameExtracted2.equalsIgnoreCase(rightTableName) || ((String)this.tableName).equalsIgnoreCase(rightTableName) || this.aliasName != null && this.aliasName.equalsIgnoreCase(rightTableName)) {
                                whereItem.setRightJoin("+");
                                continue;
                            }
                            whereItem.setLeftJoin("+");
                            continue;
                        }
                        if (this.tableName instanceof FunctionCalls) {
                            fc = (FunctionCalls)this.tableName;
                            tableNameExtracted = null;
                            tabName = fc.getFunctionName().getColumnName();
                            if (tabName.toString().lastIndexOf(".") != -1) {
                                tableNameExtracted = tabName.toString().substring(tabName.toString().lastIndexOf(".") + 1);
                            }
                            if ((v = fc.getFunctionArguments()).size() != 1 || !(v.get(0) instanceof SelectColumn) || !(temp = (sc = (SelectColumn)v.get(0)).toString()).trim().equalsIgnoreCase("NOLOCK")) continue;
                            if (tableNameExtracted != null && tableNameExtracted.equalsIgnoreCase(rightTableName) || tabName.equalsIgnoreCase(rightTableName) || this.aliasName != null && this.aliasName.equalsIgnoreCase(rightTableName)) {
                                whereItem.setRightJoin("+");
                                continue;
                            }
                            whereItem.setLeftJoin("+");
                            continue;
                        }
                        if (this.tableName instanceof SelectQueryStatement) {
                            if (this.aliasName != null && this.aliasName.equalsIgnoreCase(rightTableName)) {
                                whereItem.setRightJoin("+");
                                continue;
                            }
                            whereItem.setLeftJoin("+");
                            continue;
                        }
                        if (!(this.tableName instanceof FromClause)) continue;
                        fromClauseInsideFT = (FromClause)this.tableName;
                        fromItemListVector = fromClauseInsideFT.getFromItemList();
                        this.getRightJoinInWhereItemForTableNameAsFromClause(fromItemListVector, rightTableName, this.aliasName, whereItem);
                        continue;
                    }
                    if (rightTableColumn == null) continue;
                    this.setJoinType(whereItem, leftTableColumn.getTableName(), true);
                    continue;
                }
                if (rightColumnExpression == null || !(rightColumnExpression.elementAt(0) instanceof String) || toOracle || !isRightOuterJoin || !(this.tableName instanceof String)) continue;
                whereItem.setRightJoin("+");
                continue;
            }
            if (leftTableColumn == null || rightColumnExpression == null || !(rightColumnExpression.elementAt(0) instanceof TableColumn)) continue;
            rightTableColumn = (TableColumn)rightColumnExpression.elementAt(0);
            if (rightTableColumn != null && rightTableColumn.getTableName() != null) {
                this.setJoinType(whereItem, rightTableColumn.getTableName(), false);
                continue;
            }
            if (rightTableColumn == null) continue;
            FromTable ftLeftExpr = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)vendorSQS, leftTableColumn);
            if (ftLeftExpr != null) {
                Object tblObj = ftLeftExpr.getTableName();
                if (!(tblObj instanceof String) || !(this.tableName instanceof String)) continue;
                if (((String)tblObj).equalsIgnoreCase((String)this.tableName)) {
                    if (this.joinClause.equalsIgnoreCase("LEFT OUTER JOIN") || this.joinClause.equalsIgnoreCase("LEFT JOIN")) {
                        whereItem.setRightJoin("+");
                        continue;
                    }
                    if (!this.joinClause.equalsIgnoreCase("RIGHT OUTER JOIN") && !this.joinClause.equalsIgnoreCase("RIGHT JOIN")) continue;
                    whereItem.setLeftJoin("+");
                    continue;
                }
                if (this.joinClause.equalsIgnoreCase("LEFT OUTER JOIN") || this.joinClause.equalsIgnoreCase("LEFT JOIN")) {
                    whereItem.setLeftJoin("+");
                    continue;
                }
                if (!this.joinClause.equalsIgnoreCase("RIGHT OUTER JOIN") && !this.joinClause.equalsIgnoreCase("RIGHT JOIN")) continue;
                whereItem.setRightJoin("+");
                continue;
            }
            vembuSQS.setGeneralComments("/* SwisSQL Message : Metadata required for accurate conversions. */");
            if (this.joinClause.equalsIgnoreCase("LEFT OUTER JOIN") || this.joinClause.equalsIgnoreCase("LEFT JOIN")) {
                whereItem.setLeftJoin("+");
                continue;
            }
            if (!this.joinClause.equalsIgnoreCase("RIGHT OUTER JOIN") && !this.joinClause.equalsIgnoreCase("RIGHT JOIN")) continue;
            whereItem.setRightJoin("+");
        }
        if (toOracle) {
            this.insertItem(vembuSQS, vendorSQS, 1, true);
        } else {
            this.insertItem(vembuSQS, vendorSQS, 1, false);
        }
    }

    private void setJoinType(WhereItem whereItem, String wcTableName, boolean leftColumn) {
        if (this.joinClause.equalsIgnoreCase("LEFT OUTER JOIN") || this.joinClause.equalsIgnoreCase("LEFT JOIN")) {
            if (this.tableName instanceof String) {
                String tableNameExtracted = null;
                if (this.tableName.toString().lastIndexOf(".") != -1) {
                    tableNameExtracted = this.tableName.toString().substring(this.tableName.toString().lastIndexOf(".") + 1);
                }
                if (tableNameExtracted != null && tableNameExtracted.equalsIgnoreCase(wcTableName) || ((String)this.tableName).equalsIgnoreCase(wcTableName) || this.aliasName != null && this.aliasName.equalsIgnoreCase(wcTableName)) {
                    if (leftColumn) {
                        whereItem.setRightJoin("+");
                    } else {
                        whereItem.setLeftJoin("+");
                    }
                } else if (leftColumn) {
                    whereItem.setLeftJoin("+");
                } else {
                    whereItem.setRightJoin("+");
                }
            }
        } else if ((this.joinClause.equalsIgnoreCase("RIGHT OUTER JOIN") || this.joinClause.equalsIgnoreCase("RIGHT JOIN")) && this.tableName instanceof String) {
            String tableNameExtracted = null;
            if (this.tableName.toString().lastIndexOf(".") != -1) {
                tableNameExtracted = this.tableName.toString().substring(this.tableName.toString().lastIndexOf(".") + 1);
            }
            if (tableNameExtracted != null && tableNameExtracted.equalsIgnoreCase(wcTableName) || ((String)this.tableName).equalsIgnoreCase(wcTableName) || this.aliasName != null && this.aliasName.equalsIgnoreCase(wcTableName)) {
                if (leftColumn) {
                    whereItem.setLeftJoin("+");
                } else {
                    whereItem.setRightJoin("+");
                }
            } else if (leftColumn) {
                whereItem.setRightJoin("+");
            } else {
                whereItem.setLeftJoin("+");
            }
        }
    }

    private void getLeftJoinInWhereItemForTableNameAsFromClause(Vector fromItemListVector, String rightTableName, String aliasName, WhereItem whereItem) {
        for (int count2 = 0; count2 < fromItemListVector.size(); ++count2) {
            if (fromItemListVector.elementAt(count2) instanceof FromTable) {
                FromTable fromTableFromFC = (FromTable)fromItemListVector.get(count2);
                Object fromTableName = fromTableFromFC.getTableName();
                if (fromTableName instanceof String) {
                    if (((String)fromTableName).equalsIgnoreCase(rightTableName) || aliasName != null && aliasName.equalsIgnoreCase(rightTableName)) {
                        whereItem.setLeftJoin("+");
                        continue;
                    }
                    whereItem.setRightJoin("+");
                    continue;
                }
                if (!(fromTableName instanceof SelectQueryStatement)) continue;
                if (aliasName != null && aliasName.equalsIgnoreCase(rightTableName)) {
                    whereItem.setLeftJoin("+");
                    continue;
                }
                whereItem.setRightJoin("+");
                continue;
            }
            if (!(fromItemListVector.elementAt(count2) instanceof FromClause)) continue;
            FromClause newFC = (FromClause)fromItemListVector.get(count2);
            Vector newFromItemList = newFC.getFromItemList();
            this.getLeftJoinInWhereItemForTableNameAsFromClause(newFromItemList, rightTableName, aliasName, whereItem);
        }
    }

    private void getRightJoinInWhereItemForTableNameAsFromClause(Vector fromItemListVector, String rightTableName, String aliasName, WhereItem whereItem) {
        for (int count2 = 0; count2 < fromItemListVector.size(); ++count2) {
            if (fromItemListVector.elementAt(count2) instanceof FromTable) {
                FromTable fromTableFromFC = (FromTable)fromItemListVector.get(count2);
                Object fromTableName = fromTableFromFC.getTableName();
                if (fromTableName instanceof String) {
                    if (((String)fromTableName).equalsIgnoreCase(rightTableName) || aliasName != null && aliasName.equalsIgnoreCase(rightTableName)) {
                        whereItem.setRightJoin("+");
                        continue;
                    }
                    whereItem.setLeftJoin("+");
                    continue;
                }
                if (!(fromTableName instanceof SelectQueryStatement)) continue;
                if (aliasName != null && aliasName.equalsIgnoreCase(rightTableName)) {
                    whereItem.setRightJoin("+");
                    continue;
                }
                whereItem.setLeftJoin("+");
                continue;
            }
            if (!(fromItemListVector.elementAt(count2) instanceof FromClause)) continue;
            FromClause newFC = (FromClause)fromItemListVector.get(count2);
            Vector newFromItemList = newFC.getFromItemList();
            this.getRightJoinInWhereItemForTableNameAsFromClause(newFromItemList, rightTableName, aliasName, whereItem);
        }
    }

    private WhereExpression createNewWhereExpressionByRemovingTheJOINConditions(WhereExpression weClone) {
        WhereExpression newWhereExp = new WhereExpression();
        Vector whereItemsANDExpressions = weClone.getWhereItems();
        for (int i = 0; i < whereItemsANDExpressions.size(); ++i) {
            Object obj = whereItemsANDExpressions.elementAt(i);
            if (obj instanceof WhereExpression) {
                WhereExpression we = (WhereExpression)obj;
                we = this.createNewWhereExpressionByRemovingTheJOINConditions(we);
                continue;
            }
            if (!(obj instanceof WhereItem)) continue;
            WhereItem whereItem = (WhereItem)obj;
            WhereColumn leftItem = null;
            Vector leftColumnExpression = null;
            WhereColumn rightItem = null;
            Vector rightColumnExpression = null;
            if (whereItem != null) {
                leftItem = whereItem.getLeftWhereExp();
                if (leftItem != null) {
                    leftColumnExpression = leftItem.getColumnExpression();
                }
                if ((rightItem = whereItem.getRightWhereExp()) != null) {
                    rightColumnExpression = rightItem.getColumnExpression();
                }
            }
            if (leftColumnExpression == null || !(leftColumnExpression.elementAt(0) instanceof TableColumn) || rightColumnExpression == null || !(rightColumnExpression.elementAt(0) instanceof TableColumn)) continue;
            whereItemsANDExpressions.removeElementAt(i);
            if (i != 0 && weClone.getOperator().size() > 0) {
                weClone.getOperator().removeElementAt(i - 1);
            } else if (weClone.getOperator().size() > i) {
                weClone.getOperator().removeElementAt(i);
            }
            --i;
        }
        weClone.setToOracle(true);
        return weClone;
    }

    public FromTable getPreviousFromTableFromTheFromItemList(SelectQueryStatement vendorSQS) throws ConvertException {
        FromClause fc = vendorSQS.getFromClause();
        Vector v_fl = fc.getFromItemList();
        int i_cnt = 0;
        for (i_cnt = 0; i_cnt < v_fl.size(); ++i_cnt) {
            if (v_fl.elementAt(i_cnt) instanceof FromTable) {
                if (v_fl.elementAt(i_cnt).hashCode() != this.hashCode()) continue;
                break;
            }
            if (!(v_fl.elementAt(i_cnt) instanceof FromClause)) continue;
            return null;
        }
        if (--i_cnt == -1) {
            return null;
        }
        FromTable t_ft = null;
        if (v_fl.elementAt(i_cnt) instanceof FromTable) {
            t_ft = (FromTable)v_fl.elementAt(i_cnt);
        }
        return t_ft;
    }

    private int getFromTableIndexFromFromItemList(SelectQueryStatement vendorSQS) throws ConvertException {
        FromClause fc = vendorSQS.getFromClause();
        Vector v_fl = fc.getFromItemList();
        int i_cnt = 0;
        for (i_cnt = 0; i_cnt < v_fl.size(); ++i_cnt) {
            if (v_fl.elementAt(i_cnt) instanceof FromTable) {
                if (v_fl.elementAt(i_cnt).hashCode() != this.hashCode()) continue;
                break;
            }
            if (!(v_fl.elementAt(i_cnt) instanceof FromClause)) continue;
            return 0;
        }
        return i_cnt;
    }

    private void markToBeRemovedOperators(WhereExpression whereExpression) {
        Vector whereItems = whereExpression.getWhereItems();
        Vector operators = whereExpression.getOperator();
        Object obj = null;
        for (int i = 0; i < whereItems.size(); ++i) {
            obj = whereItems.elementAt(i);
            if (obj instanceof WhereItem) {
                WhereItem wi = obj;
                if (!wi.getMovedToFromClause()) continue;
                if (i != 0) {
                    operators.setElementAt("&AND", i - 1);
                    continue;
                }
                if (operators.size() <= i) continue;
                operators.setElementAt("&AND", i);
                continue;
            }
            if (!(obj instanceof WhereExpression)) continue;
            this.markToBeRemovedOperators(obj);
        }
    }

    private void markNonJoinWhereItems(WhereExpression whereExpression, boolean toOracle) {
        Vector whereItems = whereExpression.getWhereItems();
        Vector operators = whereExpression.getOperator();
        Object obj = null;
        for (int i = 0; i < whereItems.size(); ++i) {
            obj = whereItems.elementAt(i);
            if (obj instanceof WhereItem) {
                WhereItem whereItem = obj;
                WhereColumn leftItem = null;
                Vector leftColumnExpression = null;
                WhereColumn rightItem = null;
                Vector rightColumnExpression = null;
                if (whereItem != null) {
                    leftItem = whereItem.getLeftWhereExp();
                    if (leftItem != null) {
                        leftColumnExpression = leftItem.getColumnExpression();
                    }
                    if ((rightItem = whereItem.getRightWhereExp()) != null) {
                        rightColumnExpression = rightItem.getColumnExpression();
                    }
                }
                if (!(leftColumnExpression != null && !(leftColumnExpression.elementAt(0) instanceof TableColumn) || rightColumnExpression != null && !(rightColumnExpression.elementAt(0) instanceof TableColumn) || leftColumnExpression == null) && rightColumnExpression != null || !toOracle) continue;
                whereItem.setMovedToFromClause(true);
                if (i != 0) {
                    operators.setElementAt("&AND", i - 1);
                    continue;
                }
                if (operators.size() <= i) continue;
                operators.setElementAt("&AND", i);
                continue;
            }
            if (!(obj instanceof WhereExpression)) continue;
            this.markNonJoinWhereItems(obj, toOracle);
        }
    }

    private Object convertTableNameToOracle(Object tableName, SelectQueryStatement vembuSQS, SelectQueryStatement vendorSQS) throws ConvertException {
        if (tableName instanceof SelectQueryStatement) {
            return ((SelectQueryStatement)tableName).toOracleSelect();
        }
        if (tableName instanceof FunctionCalls) {
            return ((FunctionCalls)tableName).toOracleSelect(vembuSQS, vendorSQS);
        }
        String table_name = StringFunctions.replaceFirst(".", "..", (String)tableName);
        return table_name;
    }

    private void addLeftJoin(WhereExpression whereExpression) {
        Vector whereItems = whereExpression.getWhereItems();
        Object obj = null;
        for (int i = 0; i < whereItems.size(); ++i) {
            obj = whereItems.elementAt(i);
            if (obj instanceof WhereItem) {
                WhereItem wi = obj;
                if (!wi.isItAJoinItem()) continue;
                wi.setLeftJoin("+");
                continue;
            }
            if (!(obj instanceof WhereExpression)) continue;
            this.addLeftJoin(obj);
        }
    }

    private void addRightJoin(WhereExpression whereExpression) {
        Vector whereItems = whereExpression.getWhereItems();
        Object obj = null;
        for (int i = 0; i < whereItems.size(); ++i) {
            obj = whereItems.elementAt(i);
            if (obj instanceof WhereItem) {
                WhereItem wi = obj;
                if (!wi.isItAJoinItem()) continue;
                wi.setRightJoin("+");
                continue;
            }
            if (!(obj instanceof WhereExpression)) continue;
            this.addRightJoin(obj);
        }
    }

    public void insertItem(SelectQueryStatement vembuSQS, SelectQueryStatement vendorSQS, int type, boolean toOracle) throws ConvertException {
        WhereExpression f_we = vendorSQS.getWhereExpression();
        WhereExpression t_we = new WhereExpression();
        if (type == 1) {
            t_we = (WhereExpression)this.joinExpression.elementAt(0);
            if (!this.joinClause.equalsIgnoreCase("JOIN") && !this.joinClause.equalsIgnoreCase("INNER JOIN")) {
                this.markNonJoinWhereItems(t_we, toOracle);
            }
            if (vembuSQS.getWhereExpression() != null) {
                vembuSQS.getWhereExpression().addOperator("AND");
                t_we.setCloseBrace(")");
                t_we.setOpenBrace("(");
                if (toOracle) {
                    vembuSQS.getWhereExpression().addWhereExpression(t_we.toOracleSelect(vembuSQS, vendorSQS));
                } else {
                    vembuSQS.getWhereExpression().addWhereExpression(t_we.toTimesTenSelect(vembuSQS, vendorSQS));
                }
            } else if (toOracle) {
                vembuSQS.setWhereExpression(t_we.toOracleSelect(vembuSQS, vendorSQS));
            } else {
                vembuSQS.setWhereExpression(t_we.toTimesTenSelect(vembuSQS, vendorSQS));
            }
        } else if (type == 2) {
            if (this.joinExpression != null) {
                t_we = (WhereExpression)this.joinExpression.elementAt(0);
                t_we = this.getClonedWhereExpression(t_we);
                this.addRightJoin(t_we);
                if (vembuSQS.getWhereExpression() != null) {
                    vembuSQS.getWhereExpression().addOperator("AND");
                    t_we.setCloseBrace(")");
                    t_we.setOpenBrace("(");
                    if (toOracle) {
                        vembuSQS.getWhereExpression().addWhereExpression(t_we.toOracleSelect(vembuSQS, vendorSQS));
                    } else {
                        vembuSQS.getWhereExpression().addWhereExpression(t_we.toTimesTenSelect(vembuSQS, vendorSQS));
                    }
                } else if (toOracle) {
                    vembuSQS.setWhereExpression(t_we.toOracleSelect(vembuSQS, vendorSQS));
                } else {
                    vembuSQS.setWhereExpression(t_we.toTimesTenSelect(vembuSQS, vendorSQS));
                }
            } else if (toOracle) {
                vembuSQS.setWhereExpression(t_we.toOracleSelect(vembuSQS, vendorSQS));
            } else {
                vembuSQS.setWhereExpression(t_we.toTimesTenSelect(vembuSQS, vendorSQS));
            }
            SetOperatorClause soc = new SetOperatorClause();
            soc.setSetClause(" UNION ");
            SelectQueryStatement sqs = new SelectQueryStatement();
            sqs.setSelectStatement(vendorSQS.getSelectStatement());
            FromClause fromClause = new FromClause();
            FromClause vendorFromClause = vendorSQS.getFromClause();
            Vector vendorFromItemList = vendorFromClause.getFromItemList();
            Vector vembuFromItemList = new Vector();
            vembuFromItemList = this.getTablesOnlyList(vendorFromItemList);
            fromClause.setFromClause("FROM");
            fromClause.setFromItemList(vembuFromItemList);
            sqs.setFromClause(fromClause);
            if (this.joinExpression != null) {
                t_we = (WhereExpression)this.joinExpression.elementAt(0);
                t_we = this.getClonedWhereExpression(t_we);
                this.addLeftJoin(t_we);
                if (vendorSQS.getWhereExpression() != null) {
                    if (toOracle) {
                        sqs.setWhereExpression(t_we.toOracleSelect(vembuSQS, vendorSQS));
                    } else {
                        sqs.setWhereExpression(t_we.toTimesTenSelect(vembuSQS, vendorSQS));
                    }
                    sqs.getWhereExpression().addOperator("AND");
                    vendorSQS.getWhereExpression().setCloseBrace(")");
                    vendorSQS.getWhereExpression().setOpenBrace("(");
                    sqs.getWhereExpression().addWhereExpression(vendorSQS.getWhereExpression().toOracleSelect(vembuSQS, vendorSQS));
                } else if (toOracle) {
                    sqs.setWhereExpression(t_we.toOracleSelect(vembuSQS, vendorSQS));
                } else {
                    sqs.setWhereExpression(t_we.toTimesTenSelect(vembuSQS, vendorSQS));
                }
            } else if (toOracle) {
                sqs.setWhereExpression(t_we.toOracleSelect(vembuSQS, vendorSQS));
            } else {
                sqs.setWhereExpression(t_we.toTimesTenSelect(vembuSQS, vendorSQS));
            }
            sqs.setGroupByStatement(vendorSQS.getGroupByStatement());
            sqs.setForUpdateStatement(vendorSQS.getForUpdateStatement());
            sqs.setHavingStatement(vendorSQS.getHavingStatement());
            soc.setSelectQueryStatement(sqs);
            vembuSQS.setSetOperatorClause(soc);
        } else if (type == 3) {
            this.convertUsingListToWhereExp(this.UsingList, t_we, this.getPreviousFromTableFromTheFromItemList(vendorSQS));
            if (vembuSQS.getWhereExpression() != null) {
                vembuSQS.getWhereExpression().addOperator("AND");
                t_we.setCloseBrace(")");
                t_we.setOpenBrace("(");
                if (toOracle) {
                    vembuSQS.getWhereExpression().addWhereExpression(t_we.toOracleSelect(vembuSQS, vendorSQS));
                } else {
                    vembuSQS.getWhereExpression().addWhereExpression(t_we.toTimesTenSelect(vembuSQS, vendorSQS));
                }
            } else if (toOracle) {
                vembuSQS.setWhereExpression(t_we.toOracleSelect(vembuSQS, vendorSQS));
            } else {
                vembuSQS.setWhereExpression(t_we.toTimesTenSelect(vembuSQS, vendorSQS));
            }
        } else if (type == 4) {
            t_we = (WhereExpression)this.joinExpression.elementAt(0);
            if (vembuSQS.getWhereExpression() != null) {
                vembuSQS.getWhereExpression().addOperator("AND");
                t_we.setCloseBrace(")");
                t_we.setOpenBrace("(");
                vembuSQS.getWhereExpression().addWhereExpression(t_we.toInformixSelect(vembuSQS, vendorSQS));
            } else {
                vembuSQS.setWhereExpression(t_we.toInformixSelect(vembuSQS, vendorSQS));
            }
        }
    }

    public void convertUsingListToWhereExp(Vector v_ul, WhereExpression t_we, FromTable fc) throws ConvertException {
        WhereItem wi = new WhereItem();
        int i = 0;
        String s_cn = null;
        if (fc != null) {
            s_cn = fc.getAliasName() != null ? fc.getAliasName() : fc.getTableName().toString();
        }
        for (i = 0; i < v_ul.size(); ++i) {
            if (v_ul.elementAt(i) instanceof TableColumn) {
                Vector<TableColumn> v_wi = new Vector<TableColumn>();
                WhereColumn wc_wi = new WhereColumn();
                TableColumn tc = (TableColumn)v_ul.elementAt(i);
                tc.setTableName(s_cn);
                v_wi.addElement(tc);
                wc_wi.setColumnExpression(v_wi);
                wi.setLeftWhereExp(wc_wi);
                TableColumn tcr = new TableColumn();
                tcr.setColumnName(((TableColumn)v_ul.elementAt(i)).getColumnName());
                Vector<TableColumn> v_wir = new Vector<TableColumn>();
                WhereColumn wc_wir = new WhereColumn();
                if (this.aliasName != null) {
                    tcr.setTableName(this.aliasName);
                } else {
                    tcr.setTableName(this.tableName.toString());
                }
                v_wir.addElement(tcr);
                wc_wir.setColumnExpression(v_wir);
                wi.setRightWhereExp(wc_wir);
                wi.setOperator("=");
                if (this.joinClause.equalsIgnoreCase("LEFT OUTER JOIN") || this.joinClause.equalsIgnoreCase("LEFT JOIN")) {
                    wi.setLeftJoin("+");
                } else if (this.joinClause.equalsIgnoreCase("RIGHT OUTER JOIN") || this.joinClause.equalsIgnoreCase("RIGHT JOIN")) {
                    wi.setRightJoin("+");
                }
                t_we.addWhereItem(wi);
                wi = new WhereItem();
                continue;
            }
            String s_cd = (String)this.UsingList.elementAt(i);
            if (s_cd.equals(",")) {
                t_we.addOperator("AND");
                continue;
            }
            t_we.addOperator(s_cd);
        }
    }

    public void convertJoinExpToWhereExp(Vector v_jex, WhereExpression t_we, FromTable fc) throws ConvertException {
        WhereItem wi = new WhereItem();
        boolean LRflag = true;
        int i = 0;
        String s_cn = null;
        if (fc != null) {
            s_cn = fc.getAliasName() != null ? fc.getAliasName() : fc.getTableName().toString();
        }
        for (i = 0; i < v_jex.size(); ++i) {
            if (v_jex.elementAt(i) instanceof Vector) {
                this.convertJoinExpToWhereExp((Vector)v_jex.elementAt(i), t_we, fc);
                continue;
            }
            if (v_jex.elementAt(i) instanceof TableColumn) {
                Vector<TableColumn> v_wi = new Vector<TableColumn>();
                WhereColumn wc_wi = new WhereColumn();
                TableColumn tc = (TableColumn)v_jex.elementAt(i);
                if (fc != null && tc.getTableName() == null) {
                    tc.setTableName(s_cn);
                }
                if (LRflag) {
                    if (fc != null && tc.getTableName() == null) {
                        tc.setTableName(s_cn);
                    }
                    v_wi.addElement(tc);
                    wc_wi.setColumnExpression(v_wi);
                    wi.setLeftWhereExp(wc_wi);
                    LRflag = false;
                    continue;
                }
                if (this.aliasName != null) {
                    if (tc.getTableName() == null) {
                        tc.setTableName(this.aliasName);
                    }
                } else if (tc.getTableName() == null) {
                    tc.setTableName(this.tableName.toString());
                }
                v_wi.addElement(tc);
                wc_wi.setColumnExpression(v_wi);
                wi.setRightWhereExp(wc_wi);
                LRflag = true;
                continue;
            }
            if (!(v_jex.elementAt(i) instanceof String)) continue;
            if (((String)v_jex.elementAt(i)).equalsIgnoreCase("=")) {
                TableColumn tc = new TableColumn();
                if (v_jex.elementAt(i + 1) instanceof TableColumn) {
                    tc = (TableColumn)v_jex.elementAt(i + 1);
                }
                if (tc.getTableName().equalsIgnoreCase(this.aliasName) || tc.getTableName().equalsIgnoreCase((String)this.tableName)) {
                    if (this.joinClause.equalsIgnoreCase("LEFT OUTER JOIN") | this.joinClause.equalsIgnoreCase("LEFT JOIN")) {
                        wi.setRightJoin("+");
                    } else if (this.joinClause.equalsIgnoreCase("RIGHT OUTER JOIN") | this.joinClause.equalsIgnoreCase("RIGHT JOIN")) {
                        wi.setLeftJoin("+");
                    }
                } else if (this.joinClause.equalsIgnoreCase("LEFT OUTER JOIN") | this.joinClause.equalsIgnoreCase("LEFT JOIN")) {
                    wi.setLeftJoin("+");
                } else if (this.joinClause.equalsIgnoreCase("RIGHT OUTER JOIN") | this.joinClause.equalsIgnoreCase("RIGHT JOIN")) {
                    wi.setRightJoin("+");
                }
                wi.setOperator("=");
                continue;
            }
            if (!(((String)v_jex.elementAt(i)).equalsIgnoreCase("AND") | ((String)v_jex.elementAt(i)).equalsIgnoreCase("OR"))) continue;
            t_we.addOperator((String)v_jex.elementAt(i));
            t_we.addWhereItem(wi);
            wi = new WhereItem();
        }
        if (!(v_jex.elementAt(--i) instanceof Vector)) {
            t_we.addWhereItem(wi);
        }
    }

    public String toString() {
        String temp;
        StringBuffer sb = new StringBuffer();
        SelectStatement ss = new SelectStatement();
        if (this.commentObj != null) {
            sb.append(this.commentObj.toString().trim() + " ");
        }
        if (this.joinClause != null) {
            sb.append(" " + this.joinClause.toUpperCase());
        }
        if (this.outer != null) {
            sb.append(" " + this.outer.toUpperCase());
        }
        if (this.outerOpenBrace != null) {
            sb.append(" " + this.outerOpenBrace.toUpperCase());
        }
        if (this.tableName != null) {
            if (this.tableName instanceof SelectQueryStatement) {
                ((SelectQueryStatement)this.tableName).setObjectContext(this.context);
                if (this.tableKeyword != null) {
                    sb.append(" " + this.tableKeyword.toUpperCase());
                }
                sb.append("(" + this.tableName.toString() + ")");
            } else if (this.tableName instanceof FunctionCalls) {
                ((FunctionCalls)this.tableName).setObjectContext(this.context);
                if (this.tableKeyword != null) {
                    sb.append(" " + this.tableKeyword + this.tableName.toString() + ")");
                } else {
                    sb.append(this.tableName.toString());
                }
            } else if (this.tableName instanceof FromClause) {
                ((FromClause)this.tableName).setObjectContext(this.context);
                if (this.fromClauseOpenBraces != null) {
                    sb.append("(");
                }
                sb.append(this.tableName.toString());
                if (this.fromClauseClosedBraces != null) {
                    sb.append(")");
                }
            } else if (this.context != null) {
                Object obj;
                temp = null;
                temp = this.origTableName != null ? ((obj = this.context.getEquivalent(this.origTableName)) != null && obj.toString().equals(this.origTableName) || obj == null ? this.context.getEquivalent(this.tableName.toString()).toString() : obj.toString()) : this.context.getEquivalent(this.tableName.toString()).toString();
                sb.append(" " + temp);
            } else {
                sb.append(" " + this.tableName.toString());
            }
        }
        if (this.isAS) {
            sb.append(" AS ");
        }
        if (this.aliasName != null) {
            if (this.context != null) {
                temp = this.context.getEquivalent(this.aliasName).toString();
                sb.append(" " + temp);
            } else {
                sb.append(" " + this.aliasName);
            }
        }
        if (this.holdLock != null) {
            sb.append("  " + this.holdLock);
        }
        if (this.queryPartitionClause == null && this.crossJoinForPartitionClause != null) {
            sb.append(" " + this.crossJoinForPartitionClause + " ");
        }
        if (this.outerClosedBrace != null) {
            sb.append(" " + this.outerClosedBrace.toUpperCase());
        }
        if (this.indexHint != null) {
            sb.append(this.indexHint);
        }
        if (this.onOrUsingJoin != null) {
            if (this.onOrUsingJoin.equalsIgnoreCase("using")) {
                if (this.joinExpression != null) {
                    sb.append(" " + this.convertJoinExpToString(this.joinExpression));
                }
                sb.append(" " + this.onOrUsingJoin.toUpperCase() + " ");
                sb.append("(");
                for (int i = 0; i < this.UsingList.size(); ++i) {
                    sb.append(this.UsingList.elementAt(i).toString() + " ");
                }
                sb.append(")");
            } else {
                sb.append(" " + this.onOrUsingJoin.toUpperCase());
                if (this.joinExpression != null) {
                    sb.append(" " + this.convertJoinExpToString(this.joinExpression));
                }
            }
        } else if (this.joinExpression != null) {
            sb.append(" " + this.convertJoinExpToString(this.joinExpression));
        }
        if (this.updateLock != null) {
            sb.append(" " + this.updateLock + " ");
        }
        if (this.setOperatorClauseForFullJoin != null) {
            sb.append(this.setOperatorClauseForFullJoin);
        }
        return sb.toString();
    }

    public String convertJoinExpToString(Vector v_jex) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < v_jex.size(); ++i) {
            if (v_jex.elementAt(i) instanceof Vector) {
                sb.append(this.convertJoinExpToString((Vector)v_jex.elementAt(i)));
                continue;
            }
            sb.append(v_jex.elementAt(i).toString() + " ");
        }
        return sb.toString();
    }

    private void collectAllWhereColumnsInWhereExpression(WhereExpression sqlWhereExpression) {
        Vector sqlWhereItemsList;
        if (sqlWhereExpression != null && (sqlWhereItemsList = sqlWhereExpression.getWhereItems()) != null) {
            for (int i = 0; i < sqlWhereItemsList.size(); ++i) {
                if (!(sqlWhereItemsList.get(0) instanceof WhereItem)) continue;
                WhereColumn leftColumnExpression = ((WhereItem)sqlWhereItemsList.get(i)).getLeftWhereExp();
                WhereColumn rightColumnExpression = ((WhereItem)sqlWhereItemsList.get(i)).getRightWhereExp();
                this.collectWhereColumnItems(leftColumnExpression);
                this.collectWhereColumnItems(rightColumnExpression);
            }
        }
    }

    private void collectWhereColumnItems(WhereColumn sqlWhereColumn) {
        if (sqlWhereColumn != null) {
            Vector sqlWhereColumnList = sqlWhereColumn.getColumnExpression();
            this.removeAllTableReferenceFromColumnsInWhereExpression(sqlWhereColumnList);
        }
    }

    private void removeAllTableReferenceFromColumnsInWhereExpression(Vector sqlWhereColumnList) {
        if (sqlWhereColumnList != null) {
            for (int i = 0; i < sqlWhereColumnList.size(); ++i) {
                if (sqlWhereColumnList.get(i) instanceof TableColumn) {
                    TableColumn sqlTableColumn = (TableColumn)sqlWhereColumnList.get(i);
                    sqlTableColumn.setTableName(null);
                    sqlTableColumn.setOwnerName(null);
                    continue;
                }
                if (sqlWhereColumnList.get(i) instanceof FunctionCalls) {
                    Vector functionArguments = ((FunctionCalls)sqlWhereColumnList.get(i)).getFunctionArguments();
                    this.removeAllTableReferenceFromColumnsInWhereExpression(functionArguments);
                    continue;
                }
                if (!(sqlWhereColumnList.get(i) instanceof SelectColumn)) continue;
                Vector colExp = ((SelectColumn)sqlWhereColumnList.get(i)).getColumnExpression();
                this.removeAllTableReferenceFromColumnsInWhereExpression(colExp);
            }
        }
    }

    private void buildSetOperatorClauseForSubQuery(SelectQueryStatement tabName) {
        SetOperatorClause newSOC = new SetOperatorClause();
        for (int i = this.setOperatorClauseListForSubQuery.size() - 1; i >= 0; --i) {
            SetOperatorClause tempSOC = new SetOperatorClause();
            Object obj = this.setOperatorClauseListForSubQuery.get(i);
            SetOperatorClause socTemp = new SetOperatorClause();
            if (obj == null || !(obj instanceof SetOperatorClause)) continue;
            SelectQueryStatement sqs = new SelectQueryStatement();
            socTemp = (SetOperatorClause)obj;
            String setClause = socTemp.getSetClause();
            sqs = socTemp.getSelectQueryStatement();
            if (i == this.setOperatorClauseListForSubQuery.size() - 1) {
                newSOC = socTemp;
                continue;
            }
            sqs.setSetOperatorClause(newSOC);
            tempSOC.setSetClause(setClause);
            tempSOC.setSelectQueryStatement(sqs);
            newSOC = tempSOC;
        }
        tabName.setSetOperatorClause(newSOC);
    }

    private void convertTableValueConstructorToSelectUnion(ValuesClause vc, ArrayList columnAliasList, SelectQueryStatement vembuSQS, SelectQueryStatement vendorSQS) throws ConvertException {
        int size;
        ArrayList selectQueries = new ArrayList();
        for (int j = 0; j < columnAliasList.size(); ++j) {
            String str2;
            Object obj = columnAliasList.get(j);
            if (!(obj instanceof String) || !(str2 = ((String)obj).trim()).equals("(") && !str2.equals(",") && !str2.equals(")")) continue;
            columnAliasList.remove(j);
        }
        this.groupRowValues(vc.getValuesList());
        selectQueries = this.convertValuesToSelectQueryStatements(this.rowValuesList, columnAliasList);
        SelectQueryStatement lastSQS = null;
        SetOperatorClause currentSOC = null;
        for (int j = size = selectQueries.size() - 1; j != -1; --j) {
            currentSOC = new SetOperatorClause();
            if (j == size) {
                lastSQS = (SelectQueryStatement)selectQueries.get(size);
                continue;
            }
            currentSOC.setSetClause("UNION ALL");
            currentSOC.setSelectQueryStatement(lastSQS);
            SelectQueryStatement tempSQS = (SelectQueryStatement)selectQueries.get(j);
            tempSQS.setSetOperatorClause(currentSOC);
            lastSQS = tempSQS;
        }
        vendorSQS.setSetOperatorClause(lastSQS.getSetOperatorClause());
        vembuSQS.setSelectStatement(lastSQS.getSelectStatement().toOracleSelect(vembuSQS, vendorSQS));
        vembuSQS.setFromClause(lastSQS.getFromClause());
    }

    private void groupRowValues(List valuesList) throws ConvertException {
        Vector<SelectColumn> newValuesList = new Vector<SelectColumn>();
        int multiValListSize = valuesList.size();
        int firstOpenBraceIndex = valuesList.indexOf("(");
        int firstCloseBraceIndex = valuesList.indexOf(")");
        int lastCloseBraceIndex = valuesList.lastIndexOf(")");
        List firstValuesSet = valuesList.subList(firstOpenBraceIndex, firstCloseBraceIndex + 1);
        int firstValuesSetSize = firstValuesSet.size();
        for (int i = 0; i < firstValuesSetSize; ++i) {
            if (!(firstValuesSet.get(i) instanceof SelectColumn)) continue;
            SelectColumn sc = (SelectColumn)firstValuesSet.get(i);
            if (i != firstValuesSetSize - 2) {
                sc.setEndsWith(",");
            }
            newValuesList.add(sc);
        }
        this.rowValuesList.add(newValuesList);
        if (firstCloseBraceIndex == lastCloseBraceIndex) {
            return;
        }
        this.groupRowValues(valuesList.subList(firstCloseBraceIndex + 1, multiValListSize));
    }

    private ArrayList convertValuesToSelectQueryStatements(ArrayList rowValuesList, ArrayList columnAliasList) throws ConvertException {
        ArrayList<SelectQueryStatement> selectQueriesList = new ArrayList<SelectQueryStatement>();
        FromClause fcTemp = new FromClause();
        FromTable ft1 = new FromTable();
        Vector<FromTable> fromItems = new Vector<FromTable>();
        fcTemp.setFromClause("FROM");
        ft1.setTableName("DUAL");
        fromItems.add(ft1);
        fcTemp.setFromItemList(fromItems);
        for (int j = 0; j < rowValuesList.size(); ++j) {
            if (j == 0) {
                Vector v = (Vector)rowValuesList.get(0);
                for (int k = 0; k < v.size(); ++k) {
                    Object obj;
                    if (v.size() != columnAliasList.size() || !((obj = v.get(k)) instanceof SelectColumn)) continue;
                    SelectColumn scTemp = (SelectColumn)obj;
                    scTemp.setAliasName(columnAliasList.get(k).toString());
                }
            }
            SelectQueryStatement sqs = new SelectQueryStatement();
            SelectStatement selectStmt = new SelectStatement();
            selectStmt.setSelectClause("SELECT");
            selectStmt.setSelectItemList((Vector)rowValuesList.get(j));
            sqs.setSelectStatement(selectStmt);
            sqs.setFromClause(fcTemp);
            selectQueriesList.add(sqs);
        }
        return selectQueriesList;
    }
}

