/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.select;

import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.statement.select.CaseStatement;
import com.adventnet.swissqlapi.sql.statement.select.GroupByStatement;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.SelectStatement;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhenStatement;
import com.adventnet.swissqlapi.sql.statement.select.WhereColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereExpression;
import com.adventnet.swissqlapi.sql.statement.select.WhereItem;
import java.util.ArrayList;
import java.util.Vector;

public class PivotClause {
    private String pivotStr;
    private TableColumn pivotColumn;
    private String forStr;
    private WhereItem inClause;
    private String openBrace;
    private String closedBrace;
    private FunctionCalls aggregateFunction;
    private String asStr;
    private String aliasName;
    private boolean isAS;
    private SelectQueryStatement subQuery;
    private FunctionCalls newFc;

    public void setAliasName(String an) {
        this.aliasName = an;
    }

    public void setIsAs(boolean is) {
        this.isAS = is;
    }

    public void setOpenBrace(String openBrace) {
        this.openBrace = openBrace;
    }

    public void setClosedBrace(String closedBrace) {
        this.closedBrace = closedBrace;
    }

    public void setAggregateFunction(FunctionCalls fc) {
        this.aggregateFunction = fc;
    }

    public void setPivot(String pivotStr) {
        this.pivotStr = pivotStr;
    }

    public void setPivotColumn(TableColumn tc) {
        this.pivotColumn = tc;
    }

    public void setForStr(String forStr) {
        this.forStr = forStr;
    }

    public void setInClause(WhereItem wi) {
        this.inClause = wi;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public boolean getIsAs() {
        return this.isAS;
    }

    public String getOpenBrace() {
        return this.openBrace;
    }

    public String getClosedBrace() {
        return this.closedBrace;
    }

    public FunctionCalls getAggregateFunction() {
        return this.aggregateFunction;
    }

    public String getPivot() {
        return this.pivotStr;
    }

    public TableColumn getPivotColumn() {
        return this.pivotColumn;
    }

    public String getForStr() {
        return this.forStr;
    }

    public WhereItem getInClause() {
        return this.inClause;
    }

    public void setSubQuery(SelectQueryStatement selectQueryStatement) {
        this.subQuery = selectQueryStatement;
    }

    public void toOracleSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.newFc = this.getAggregateFunction().toOracleSelect(to_sqs, from_sqs);
        ArrayList inClauseColumns = new ArrayList();
        ArrayList selectItems = new ArrayList();
        ArrayList subQuerySelectItems = new ArrayList();
        Vector newSelectItemList = new Vector();
        SelectStatement newST = new SelectStatement();
        newST.setSelectClause("SELECT");
        inClauseColumns = this.getInClauseColumns();
        selectItems = this.getSelectColumns(from_sqs);
        subQuerySelectItems = this.getSelectColumns(this.subQuery);
        newSelectItemList = this.getNewSelectItems(inClauseColumns, selectItems, subQuerySelectItems);
        newST.setSelectItemList(newSelectItemList);
        GroupByStatement gbs = this.generateGroupByStatement(subQuerySelectItems);
        if (gbs != null) {
            to_sqs.setGroupByStatement(gbs.toOracleSelect(to_sqs, from_sqs));
        }
        to_sqs.setSelectStatement(newST.toOracleSelect(to_sqs, from_sqs));
    }

    public void toMSSQLServerSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
    }

    public void toDB2Select(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.newFc = this.getAggregateFunction().toDB2Select(to_sqs, from_sqs);
        ArrayList inClauseColumns = new ArrayList();
        ArrayList selectItems = new ArrayList();
        ArrayList subQuerySelectItems = new ArrayList();
        Vector newSelectItemList = new Vector();
        SelectStatement newST = new SelectStatement();
        newST.setSelectClause("SELECT");
        inClauseColumns = this.getInClauseColumns();
        selectItems = this.getSelectColumns(from_sqs);
        subQuerySelectItems = this.getSelectColumns(this.subQuery);
        newSelectItemList = this.getNewSelectItems(inClauseColumns, selectItems, subQuerySelectItems);
        newST.setSelectItemList(newSelectItemList);
        GroupByStatement gbs = this.generateGroupByStatement(subQuerySelectItems);
        if (gbs != null) {
            to_sqs.setGroupByStatement(gbs.toDB2Select(to_sqs, from_sqs));
        }
        to_sqs.setSelectStatement(newST.toDB2Select(to_sqs, from_sqs));
    }

    public void toInformixSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.newFc = this.getAggregateFunction().toInformixSelect(to_sqs, from_sqs);
        ArrayList inClauseColumns = new ArrayList();
        ArrayList selectItems = new ArrayList();
        ArrayList subQuerySelectItems = new ArrayList();
        Vector newSelectItemList = new Vector();
        SelectStatement newST = new SelectStatement();
        newST.setSelectClause("SELECT");
        inClauseColumns = this.getInClauseColumns();
        selectItems = this.getSelectColumns(from_sqs);
        subQuerySelectItems = this.getSelectColumns(this.subQuery);
        newSelectItemList = this.getNewSelectItems(inClauseColumns, selectItems, subQuerySelectItems);
        newST.setSelectItemList(newSelectItemList);
        GroupByStatement gbs = this.generateGroupByStatement(subQuerySelectItems);
        if (gbs != null) {
            to_sqs.setGroupByStatement(gbs.toInformixSelect(to_sqs, from_sqs));
        }
        to_sqs.setSelectStatement(newST.toInformixSelect(to_sqs, from_sqs));
    }

    public void toPostgreSQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.newFc = this.getAggregateFunction().toPostgreSQLSelect(to_sqs, from_sqs);
        ArrayList inClauseColumns = new ArrayList();
        ArrayList selectItems = new ArrayList();
        ArrayList subQuerySelectItems = new ArrayList();
        Vector newSelectItemList = new Vector();
        SelectStatement newST = new SelectStatement();
        newST.setSelectClause("SELECT");
        inClauseColumns = this.getInClauseColumns();
        selectItems = this.getSelectColumns(from_sqs);
        subQuerySelectItems = this.getSelectColumns(this.subQuery);
        newSelectItemList = this.getNewSelectItems(inClauseColumns, selectItems, subQuerySelectItems);
        newST.setSelectItemList(newSelectItemList);
        GroupByStatement gbs = this.generateGroupByStatement(subQuerySelectItems);
        if (gbs != null) {
            to_sqs.setGroupByStatement(gbs.toPostgreSQLSelect(to_sqs, from_sqs));
        }
        to_sqs.setSelectStatement(newST.toPostgreSQLSelect(to_sqs, from_sqs));
    }

    public void toMySQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.newFc = this.getAggregateFunction().toMySQLSelect(to_sqs, from_sqs);
        ArrayList inClauseColumns = new ArrayList();
        ArrayList selectItems = new ArrayList();
        ArrayList subQuerySelectItems = new ArrayList();
        Vector newSelectItemList = new Vector();
        SelectStatement newST = new SelectStatement();
        newST.setSelectClause("SELECT");
        inClauseColumns = this.getInClauseColumns();
        selectItems = this.getSelectColumns(from_sqs);
        subQuerySelectItems = this.getSelectColumns(this.subQuery);
        newSelectItemList = this.getNewSelectItems(inClauseColumns, selectItems, subQuerySelectItems);
        newST.setSelectItemList(newSelectItemList);
        GroupByStatement gbs = this.generateGroupByStatement(subQuerySelectItems);
        if (gbs != null) {
            to_sqs.setGroupByStatement(gbs.toMySQLSelect(to_sqs, from_sqs));
        }
        to_sqs.setSelectStatement(newST.toMySQLSelect(to_sqs, from_sqs));
    }

    public void toANSISelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.newFc = this.getAggregateFunction().toANSISelect(to_sqs, from_sqs);
        ArrayList inClauseColumns = new ArrayList();
        ArrayList selectItems = new ArrayList();
        ArrayList subQuerySelectItems = new ArrayList();
        Vector newSelectItemList = new Vector();
        SelectStatement newST = new SelectStatement();
        newST.setSelectClause("SELECT");
        inClauseColumns = this.getInClauseColumns();
        selectItems = this.getSelectColumns(from_sqs);
        subQuerySelectItems = this.getSelectColumns(this.subQuery);
        newSelectItemList = this.getNewSelectItems(inClauseColumns, selectItems, subQuerySelectItems);
        newST.setSelectItemList(newSelectItemList);
        GroupByStatement gbs = this.generateGroupByStatement(subQuerySelectItems);
        if (gbs != null) {
            to_sqs.setGroupByStatement(gbs.toANSISelect(to_sqs, from_sqs));
        }
        to_sqs.setSelectStatement(newST.toANSISelect(to_sqs, from_sqs));
    }

    public void toSybaseSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.newFc = this.getAggregateFunction().toSybaseSelect(to_sqs, from_sqs);
        ArrayList inClauseColumns = new ArrayList();
        ArrayList selectItems = new ArrayList();
        ArrayList subQuerySelectItems = new ArrayList();
        Vector newSelectItemList = new Vector();
        SelectStatement newST = new SelectStatement();
        newST.setSelectClause("SELECT");
        inClauseColumns = this.getInClauseColumns();
        selectItems = this.getSelectColumns(from_sqs);
        subQuerySelectItems = this.getSelectColumns(this.subQuery);
        newSelectItemList = this.getNewSelectItems(inClauseColumns, selectItems, subQuerySelectItems);
        newST.setSelectItemList(newSelectItemList);
        GroupByStatement gbs = this.generateGroupByStatement(subQuerySelectItems);
        if (gbs != null) {
            to_sqs.setGroupByStatement(gbs.toSybaseSelect(to_sqs, from_sqs));
        }
        to_sqs.setSelectStatement(newST.toSybaseSelect(to_sqs, from_sqs));
    }

    public void toNetezzaSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.newFc = this.getAggregateFunction().toNetezzaSelect(to_sqs, from_sqs);
        ArrayList inClauseColumns = new ArrayList();
        ArrayList selectItems = new ArrayList();
        ArrayList subQuerySelectItems = new ArrayList();
        Vector newSelectItemList = new Vector();
        SelectStatement newST = new SelectStatement();
        newST.setSelectClause("SELECT");
        inClauseColumns = this.getInClauseColumns();
        selectItems = this.getSelectColumns(from_sqs);
        subQuerySelectItems = this.getSelectColumns(this.subQuery);
        newSelectItemList = this.getNewSelectItems(inClauseColumns, selectItems, subQuerySelectItems);
        newST.setSelectItemList(newSelectItemList);
        GroupByStatement gbs = this.generateGroupByStatement(subQuerySelectItems);
        if (gbs != null) {
            to_sqs.setGroupByStatement(gbs.toNetezzaSelect(to_sqs, from_sqs));
        }
        to_sqs.setSelectStatement(newST.toNetezzaSelect(to_sqs, from_sqs));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.pivotStr != null) {
            sb.append("\n" + this.pivotStr + "\n");
        }
        if (this.openBrace != null) {
            sb.append(this.openBrace);
        }
        if (this.aggregateFunction != null) {
            sb.append(this.aggregateFunction.toString() + " ");
        }
        if (this.forStr != null) {
            sb.append(this.forStr + " ");
        }
        if (this.pivotColumn != null) {
            sb.append(this.pivotColumn.toString() + " ");
        }
        if (this.inClause != null) {
            sb.append(this.inClause.toString() + "\n");
        }
        if (this.closedBrace != null) {
            sb.append(this.closedBrace);
        }
        if (this.isAS) {
            sb.append(" AS ");
        }
        if (this.aliasName != null) {
            sb.append(this.aliasName);
        }
        return sb.toString();
    }

    private ArrayList getInClauseColumns() {
        ArrayList<TableColumn> inClauseColumns = new ArrayList<TableColumn>();
        Vector whereColumns = this.inClause.getRightWhereExp().getColumnExpression();
        for (int i = 0; i < whereColumns.size(); ++i) {
            if (!(whereColumns.get(i) instanceof WhereColumn)) continue;
            WhereColumn wc = (WhereColumn)whereColumns.get(i);
            Vector pivotColumns = wc.getColumnExpression();
            TableColumn tc = (TableColumn)pivotColumns.get(0);
            inClauseColumns.add(tc);
        }
        return inClauseColumns;
    }

    private ArrayList getSelectColumns(SelectQueryStatement from_sqs) {
        ArrayList<SelectColumn> colList = new ArrayList<SelectColumn>();
        SelectStatement st = from_sqs.getSelectStatement();
        Vector selectItemsList = st.getSelectItemList();
        for (int i = 0; i < selectItemsList.size(); ++i) {
            if (!(selectItemsList.get(i) instanceof SelectColumn)) continue;
            SelectColumn sc = (SelectColumn)selectItemsList.get(i);
            colList.add(sc);
        }
        return colList;
    }

    private Vector getNewSelectItems(ArrayList inClauseColumns, ArrayList selectItems, ArrayList subQuerySelectItems) {
        Vector<SelectColumn> newSelectItems = new Vector<SelectColumn>();
        String alias = null;
        Object cilumnName = null;
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectColumn sc = (SelectColumn)selectItems.get(i);
            alias = sc.getAliasName();
            Vector colExp = sc.getColumnExpression();
            if (colExp.get(0) instanceof String) {
                newSelectItems.add(sc);
                continue;
            }
            if (!(colExp.get(0) instanceof TableColumn)) continue;
            SelectColumn scTemp = this.generateNewSelectColumn(sc, subQuerySelectItems, inClauseColumns);
            this.setaliasForSelectColumn(scTemp, sc);
            newSelectItems.add(scTemp);
        }
        return newSelectItems;
    }

    private SelectColumn generateNewSelectColumn(SelectColumn sc, ArrayList subQuerySelectItems, ArrayList inClauseColumns) {
        SelectColumn newSc = new SelectColumn();
        newSc.setAliasName(sc.getAliasName());
        newSc.setIsAS(sc.getIsAS());
        newSc.setEndsWith(sc.getEndsWith());
        Vector colExp = sc.getColumnExpression();
        Vector newColExp = new Vector();
        for (int i = 0; i < colExp.size(); ++i) {
            Object obj = colExp.get(i);
            if (obj instanceof TableColumn) {
                TableColumn tc = (TableColumn)obj;
                boolean presentInSubQuery = this.changeColumnIfPresentInSubQueryItemsList(newColExp, subQuerySelectItems, tc);
                if (presentInSubQuery) continue;
                this.changeColumnIfPresentInInClause(newColExp, inClauseColumns, tc);
                continue;
            }
            newColExp.add(obj);
        }
        newSc.setColumnExpression(newColExp);
        return newSc;
    }

    private boolean changeColumnIfPresentInSubQueryItemsList(Vector cols, ArrayList subQuerySelectItems, TableColumn tc) {
        String colName = tc.getColumnName().trim();
        for (int i = 0; i < subQuerySelectItems.size(); ++i) {
            SelectColumn scTemp = (SelectColumn)subQuerySelectItems.get(i);
            String aliasName = scTemp.getAliasName();
            if (aliasName != null && (aliasName.startsWith("\"") || aliasName.startsWith("[") || aliasName.startsWith("`"))) {
                aliasName = aliasName.substring(1, aliasName.length() - 1);
            }
            if (colName.startsWith("\"") || colName.startsWith("[") || colName.startsWith("`")) {
                colName = colName.substring(1, colName.length() - 1);
            }
            if (!colName.equalsIgnoreCase(aliasName)) continue;
            cols.add(scTemp.getColumnExpression().get(0));
            return true;
        }
        return false;
    }

    private void changeColumnIfPresentInInClause(Vector newColExp, ArrayList inClauseColumns, TableColumn tc) {
        String colName = tc.getColumnName();
        if (colName.startsWith("\"") || colName.startsWith("[") || colName.startsWith("`")) {
            colName = colName.substring(1, colName.length() - 1).trim();
        }
        for (int j = 0; j < inClauseColumns.size(); ++j) {
            TableColumn tcNew = (TableColumn)inClauseColumns.get(j);
            String inColName = tcNew.getColumnName();
            if (inColName.startsWith("\"") || inColName.startsWith("[") || inColName.startsWith("`")) {
                inColName = inColName.substring(1, inColName.length() - 1).trim();
            }
            if (!colName.equalsIgnoreCase(inColName)) continue;
            this.generateCaseStatementWithPivotedColumn(newColExp, inColName);
        }
    }

    private void generateCaseStatementWithPivotedColumn(Vector newColExp, String inColName) {
        FunctionCalls fc = new FunctionCalls();
        Vector functionargs = new Vector();
        CaseStatement caseStmt = new CaseStatement();
        SelectColumn sc = (SelectColumn)this.newFc.getFunctionArguments().get(0);
        Vector<WhenStatement> whenStmtList = new Vector<WhenStatement>();
        WhenStatement whenStmt = new WhenStatement();
        WhereExpression whenConditionWE = new WhereExpression();
        Vector<WhereItem> whenConditionVector = new Vector<WhereItem>();
        WhereItem whenWhereItem = new WhereItem();
        WhereColumn whenLeftWC = new WhereColumn();
        Vector<TableColumn> whenColExp = new Vector<TableColumn>();
        WhereColumn rightWhereExp = new WhereColumn();
        Vector<String> rightWhereColExp = new Vector<String>();
        SelectColumn thenStmt = new SelectColumn();
        Vector<SelectColumn> thenColExp = new Vector<SelectColumn>();
        SelectColumn elseStmt = new SelectColumn();
        Vector<String> elseColExp = new Vector<String>();
        String elseExpValue = "0";
        caseStmt.setCaseClause("CASE");
        whenStmt.setWhenClause("WHEN");
        whenStmt.setThenClause("THEN");
        caseStmt.setEndClause("END");
        whenColExp.add(this.pivotColumn);
        whenLeftWC.setColumnExpression(whenColExp);
        whenWhereItem.setLeftWhereExp(whenLeftWC);
        whenConditionVector.add(whenWhereItem);
        whenConditionWE.setWhereItem(whenConditionVector);
        whenStmt.setWhenCondition(whenConditionWE);
        rightWhereColExp.add("'" + inColName + "'");
        rightWhereExp.setColumnExpression(rightWhereColExp);
        whenWhereItem.setRightWhereExp(rightWhereExp);
        whenWhereItem.setOperator("=");
        thenColExp.add(sc);
        thenStmt.setColumnExpression(thenColExp);
        whenStmt.setThenStatement(thenStmt);
        whenStmtList.add(whenStmt);
        elseColExp.add(elseExpValue);
        elseStmt.setColumnExpression(elseColExp);
        caseStmt.setWhenStatementList(whenStmtList);
        SelectColumn argument = new SelectColumn();
        Vector<CaseStatement> colExp = new Vector<CaseStatement>();
        colExp.add(caseStmt);
        argument.setColumnExpression(colExp);
        Vector<SelectColumn> arguments = new Vector<SelectColumn>();
        arguments.add(argument);
        fc.setFunctionArguments(arguments);
        fc.setFunctionName(this.getAggregateFunction().getFunctionName());
        newColExp.add(fc);
    }

    private void setaliasForSelectColumn(SelectColumn scTemp, SelectColumn originalSC) {
        String alias = scTemp.getAliasName();
        if (alias == null || alias.equals("")) {
            Vector colExp = originalSC.getColumnExpression();
            TableColumn tc = (TableColumn)colExp.get(0);
            scTemp.setAliasName(tc.getColumnName().trim());
        }
    }

    private GroupByStatement generateGroupByStatement(ArrayList subQuerySelectItems) {
        GroupByStatement gbs = new GroupByStatement();
        Vector functionArgs = this.getAggregateFunction().getFunctionArguments();
        String pivotedColumn = this.getPivotColumn().getColumnName().trim();
        String fArg = this.extractColumnNameFromSelectColumn((SelectColumn)functionArgs.get(0));
        Vector<SelectColumn> groupByList = new Vector<SelectColumn>();
        for (int i = 0; i < subQuerySelectItems.size(); ++i) {
            SelectColumn scTemp;
            String colName;
            if (!(subQuerySelectItems.get(i) instanceof SelectColumn) || (colName = this.extractColumnNameFromSelectColumn(scTemp = (SelectColumn)subQuerySelectItems.get(i)).trim()).equalsIgnoreCase(fArg) || colName.equalsIgnoreCase(pivotedColumn)) continue;
            SelectColumn newSC = new SelectColumn();
            newSC.setColumnExpression(scTemp.getColumnExpression());
            groupByList.add(newSC);
        }
        gbs.setGroupClause("GROUP BY ");
        if (groupByList.size() > 0) {
            gbs.setGroupByItemList(groupByList);
            return gbs;
        }
        return null;
    }

    private String extractColumnNameFromSelectColumn(SelectColumn sc) {
        TableColumn tc;
        String colName = "";
        Vector colExp = sc.getColumnExpression();
        if (colExp.get(0) instanceof TableColumn && ((colName = (tc = (TableColumn)colExp.get(0)).getColumnName().trim()).startsWith("\"") || colName.startsWith("[") || colName.startsWith("`"))) {
            colName = colName.substring(1, colName.length() - 1);
        }
        return colName;
    }
}

