/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.select;

import com.adventnet.swissqlapi.SwisSQLAPI;
import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.parser.ParseException;
import com.adventnet.swissqlapi.sql.statement.CommentClass;
import com.adventnet.swissqlapi.sql.statement.select.FetchClause;
import com.adventnet.swissqlapi.sql.statement.select.FromClause;
import com.adventnet.swissqlapi.sql.statement.select.FromTable;
import com.adventnet.swissqlapi.sql.statement.select.GroupByStatement;
import com.adventnet.swissqlapi.sql.statement.select.HavingStatement;
import com.adventnet.swissqlapi.sql.statement.select.LimitClause;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereExpression;
import com.adventnet.swissqlapi.sql.statement.select.WhereItem;
import com.adventnet.swissqlapi.sql.statement.update.HintClause;
import java.util.ArrayList;
import java.util.Vector;

public class SelectStatement {
    private String selectClause;
    private String selectQualifier;
    private Vector distinctList;
    private String selectRowSpecifier;
    private String ifxSelectRowSpecifier;
    private String percentSpecifier;
    private int selectRowCount;
    private String selectSpecialQualifier;
    private Vector selectItemList;
    private String rowcountVariable;
    private String openBraceForSelectInInsert;
    private String xmlString;
    private String endBracesForXMLString;
    private UserObjectContext context = null;
    private ArrayList insertValList = null;
    private HintClause hintClause;
    private String openBraceForRowCount;
    private String closedBraceForRowCount;
    private CommentClass commentObj;

    public void setObjectContext(UserObjectContext context) {
        this.context = context;
    }

    public void setSelectClause(String s) {
        this.selectClause = s;
    }

    public void setSelectItemList(Vector v) {
        this.selectItemList = v;
    }

    public void setSelectQualifier(String s_sq) {
        this.selectQualifier = s_sq;
    }

    public void setSelectRowSpecifier(String s_srs) {
        this.selectRowSpecifier = s_srs;
    }

    public void setInformixRowSpecifier(String s_srs) {
        this.ifxSelectRowSpecifier = s_srs;
    }

    public void setSelectRowCount(int i_rc) {
        this.selectRowCount = i_rc;
    }

    public void setSelectRowCountVariable(String rowcountVariable) {
        this.rowcountVariable = rowcountVariable;
    }

    public void setSelectSpecialQualifier(String s_ssq) {
        this.selectSpecialQualifier = s_ssq;
    }

    public void setDistinctList(Vector v_dl) {
        this.distinctList = v_dl;
    }

    public void setOpenBraceForSelectInInsertQuery(String openBraceForSelectInInsert) {
        this.openBraceForSelectInInsert = openBraceForSelectInInsert;
    }

    public void setPercentSpecifier(String s_ps) {
        this.percentSpecifier = s_ps;
    }

    public void setXMLString(String xmlString) {
        this.xmlString = xmlString;
    }

    public void setXMLEndTag(String endBracesForXMLString) {
        this.endBracesForXMLString = endBracesForXMLString;
    }

    public void setInsertValList(ArrayList insertValList) {
        this.insertValList = insertValList;
    }

    public void setHintClause(HintClause hintClause) {
        this.hintClause = hintClause;
    }

    public void setCommentClass(CommentClass commentObj) {
        this.commentObj = commentObj;
    }

    public void setOpenBraceForRowCount(String openBraceForRowCount) {
        this.openBraceForRowCount = openBraceForRowCount;
    }

    public void setClosedBraceForRowCount(String closedBraceForRowCount) {
        this.closedBraceForRowCount = closedBraceForRowCount;
    }

    public CommentClass getCommentClass() {
        return this.commentObj;
    }

    public String getSelectClause() {
        return this.selectClause;
    }

    public Vector getSelectItemList() {
        return this.selectItemList;
    }

    public String getSelectQualifier() {
        return this.selectQualifier;
    }

    public String getSelectRowSpecifier() {
        return this.selectRowSpecifier;
    }

    public String getInformixRowSpecifier() {
        return this.ifxSelectRowSpecifier;
    }

    public int getSelectRowCount() {
        return this.selectRowCount;
    }

    public String getSelectRowCountVariable() {
        return this.rowcountVariable;
    }

    public String getSelectSpecialQualifier() {
        return this.selectSpecialQualifier;
    }

    public Vector getDistinctList() {
        return this.distinctList;
    }

    public String getPercentSpecifier() {
        return this.percentSpecifier;
    }

    public HintClause getHintClause() {
        return this.hintClause;
    }

    public String getOpenBraceForRowCount() {
        return this.openBraceForRowCount;
    }

    public String getClosedBraceForRowCount() {
        return this.closedBraceForRowCount;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.openBraceForSelectInInsert != null) {
            sb.append(this.openBraceForSelectInInsert);
        }
        sb.append(this.selectClause.toUpperCase());
        if (this.hintClause != null) {
            sb.append(" " + this.hintClause);
        }
        if (this.commentObj != null) {
            sb.append(this.commentObj.toString().trim() + " ");
        }
        if (this.ifxSelectRowSpecifier != null) {
            sb.append(" " + this.ifxSelectRowSpecifier.toUpperCase() + " " + this.selectRowCount);
        }
        if (this.selectQualifier != null) {
            sb.append(" " + this.selectQualifier.toUpperCase());
            if (this.selectQualifier.equalsIgnoreCase("DISTINCT ON")) {
                sb.append("(");
                for (int i_count = 0; i_count < this.distinctList.size(); ++i_count) {
                    if (i_count == this.distinctList.size() - 1) {
                        sb.append(this.distinctList.elementAt(i_count).toString());
                        continue;
                    }
                    sb.append(this.distinctList.elementAt(i_count).toString() + ",");
                }
                sb.append(")");
            }
        }
        if (this.selectRowSpecifier != null) {
            if (this.rowcountVariable != null) {
                sb.append(" " + this.selectRowSpecifier.toUpperCase() + " (" + this.rowcountVariable + ")");
            } else {
                sb.append(" " + this.selectRowSpecifier.toUpperCase());
                if (this.openBraceForRowCount != null) {
                    sb.append(this.openBraceForRowCount + this.selectRowCount + this.closedBraceForRowCount);
                } else {
                    sb.append(" " + this.selectRowCount);
                }
            }
            if (this.percentSpecifier != null) {
                sb.append(" " + this.percentSpecifier.toUpperCase());
            }
        }
        if (this.selectSpecialQualifier != null) {
            sb.append(" " + this.selectSpecialQualifier.toUpperCase());
        }
        if (this.xmlString != null) {
            sb.append(" " + this.xmlString);
        }
        int size = this.selectItemList.size();
        SelectQueryStatement.beautyTabCount += 2;
        for (int i = 0; i < size; ++i) {
            if (size > 1) {
                sb.append("\n");
                for (int j = 0; j < SelectQueryStatement.beautyTabCount; ++j) {
                    sb.append("\t");
                }
            }
            if (this.selectItemList.elementAt(i) instanceof SelectColumn) {
                ((SelectColumn)this.selectItemList.elementAt(i)).setObjectContext(this.context);
            }
            sb.append(" " + this.selectItemList.elementAt(i).toString());
        }
        if (this.endBracesForXMLString != null) {
            sb.append(this.endBracesForXMLString);
        }
        SelectQueryStatement.beautyTabCount -= 2;
        return sb.toString();
    }

    public SelectStatement toANSISelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectStatement t_ss = new SelectStatement();
        t_ss.setSelectClause(this.selectClause);
        if (this.selectQualifier != null) {
            GroupByStatement gbs_gb = from_sqs.getGroupByStatement();
            HavingStatement hs = from_sqs.getHavingStatement();
            if (this.selectQualifier.equalsIgnoreCase("DISTINCT ON")) {
                if (gbs_gb != null) {
                    to_sqs.setGroupByStatement(gbs_gb.toANSISelect(to_sqs, from_sqs));
                    this.addGroupByItems(to_sqs, from_sqs);
                } else {
                    to_sqs.setGroupByStatement(this.createGroupByStatement(to_sqs, from_sqs));
                }
                if (hs != null) {
                    to_sqs.setHavingStatement(hs.toANSISelect(to_sqs, from_sqs));
                    this.addHavingItem(to_sqs);
                } else {
                    to_sqs.setHavingStatement(this.createHavingStatement());
                }
                this.setSelectItemList(t_ss, from_sqs, to_sqs);
            } else if (this.selectQualifier.equalsIgnoreCase("UNIQUE")) {
                t_ss.setSelectQualifier("DISTINCT");
            } else {
                t_ss.setSelectQualifier(this.selectQualifier);
            }
        }
        if (this.selectRowSpecifier != null) {
            throw new ConvertException();
        }
        if (this.selectSpecialQualifier != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("/* " + this.selectSpecialQualifier + "*/");
            t_ss.setSelectSpecialQualifier(sb.toString());
        }
        if (this.selectQualifier != null && !this.selectQualifier.equalsIgnoreCase("DISTINCT ON") || this.selectQualifier == null) {
            Vector<Object> v_sil = new Vector<Object>();
            for (int i_count = 0; i_count < this.selectItemList.size(); ++i_count) {
                if (this.selectItemList.elementAt(i_count) instanceof SelectColumn) {
                    v_sil.addElement(((SelectColumn)this.selectItemList.elementAt(i_count)).toANSISelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.selectItemList.elementAt(i_count) instanceof WhereColumn) {
                    v_sil.addElement((WhereColumn)this.selectItemList.elementAt(i_count));
                    continue;
                }
                v_sil.addElement((String)this.selectItemList.elementAt(i_count));
            }
            t_ss.setSelectItemList(v_sil);
        }
        return t_ss;
    }

    public SelectStatement toTeradataSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectStatement t_ss = new SelectStatement();
        t_ss.setSelectClause(this.selectClause);
        t_ss.setHintClause(this.hintClause);
        if (this.commentObj != null) {
            String commId;
            String commentStr = this.commentObj.toString();
            if (commentStr.indexOf(commId = "%SSTD%") != -1) {
                commentStr = commentStr.replaceAll("/\\*", "").replaceAll(commId, "").replaceAll("\\*/", "");
            }
            to_sqs.setTeradataComment(commentStr);
        }
        if (this.selectQualifier != null) {
            GroupByStatement gbs_gb = from_sqs.getGroupByStatement();
            HavingStatement hs = from_sqs.getHavingStatement();
            if (this.selectQualifier.equalsIgnoreCase("DISTINCT ON")) {
                if (gbs_gb != null) {
                    to_sqs.setGroupByStatement(gbs_gb.toTeradataSelect(to_sqs, from_sqs));
                    this.addGroupByItems(to_sqs, from_sqs);
                } else {
                    to_sqs.setGroupByStatement(this.createGroupByStatement(to_sqs, from_sqs));
                }
                if (hs != null) {
                    to_sqs.setHavingStatement(hs.toTeradataSelect(to_sqs, from_sqs));
                    this.addHavingItem(to_sqs);
                } else {
                    to_sqs.setHavingStatement(this.createHavingStatement());
                }
                this.setSelectItemList(t_ss, from_sqs, to_sqs);
            } else if (this.selectQualifier.equalsIgnoreCase("UNIQUE")) {
                t_ss.setSelectQualifier("DISTINCT");
            } else {
                t_ss.setSelectQualifier(this.selectQualifier);
            }
        }
        if (this.selectRowSpecifier != null) {
            throw new ConvertException();
        }
        if (this.selectSpecialQualifier != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("/* " + this.selectSpecialQualifier + "*/");
            t_ss.setSelectSpecialQualifier(sb.toString());
        }
        if (this.selectQualifier != null && !this.selectQualifier.equalsIgnoreCase("DISTINCT ON") || this.selectQualifier == null) {
            Vector<Object> v_sil = new Vector<Object>();
            for (int i_count = 0; i_count < this.selectItemList.size(); ++i_count) {
                if (this.selectItemList.elementAt(i_count) instanceof SelectColumn) {
                    SelectColumn sc1 = (SelectColumn)this.selectItemList.elementAt(i_count);
                    if (from_sqs != null && !from_sqs.getTopLevel()) {
                        if (sc1.getColumnExpression().size() == 1 && !(sc1.getColumnExpression().get(0) instanceof TableColumn) && sc1.getAliasName() == null) {
                            String aliasForExpr = sc1.getTheCoreSelectItem().trim();
                            if (sc1.getColumnExpression().get(0) instanceof SelectColumn && ((SelectColumn)sc1.getColumnExpression().get(0)).getColumnExpression().size() == 1) {
                                aliasForExpr = !(((SelectColumn)sc1.getColumnExpression().get(0)).getColumnExpression().get(0) instanceof TableColumn) ? ((SelectColumn)sc1.getColumnExpression().get(0)).toString() : "";
                            }
                            if (aliasForExpr.lastIndexOf(",") != -1) {
                                aliasForExpr = aliasForExpr.substring(0, aliasForExpr.lastIndexOf(",")).trim();
                            }
                            if (aliasForExpr.indexOf("*/") != -1) {
                                aliasForExpr = aliasForExpr.substring(aliasForExpr.indexOf("*/") + 2).trim();
                            }
                            boolean isNum = false;
                            try {
                                Double.parseDouble(aliasForExpr);
                                isNum = true;
                            }
                            catch (NumberFormatException nfe) {
                                isNum = false;
                            }
                            if (!isNum && !aliasForExpr.toLowerCase().startsWith("case") && aliasForExpr.indexOf(".") != -1 && aliasForExpr.indexOf(".") == aliasForExpr.lastIndexOf(".") && aliasForExpr.indexOf("(") == -1) {
                                aliasForExpr = aliasForExpr.substring(aliasForExpr.lastIndexOf(".") + 1);
                            }
                            if (aliasForExpr.indexOf("/*") != -1) {
                                aliasForExpr = aliasForExpr.indexOf("/*") == 0 && aliasForExpr.indexOf("*/") < aliasForExpr.length() - 1 ? aliasForExpr.substring(aliasForExpr.indexOf("*/") + 1).trim() : aliasForExpr.substring(0, aliasForExpr.indexOf("/*")).trim();
                            }
                            if (!(aliasForExpr.equalsIgnoreCase("*") || aliasForExpr.startsWith("*") || aliasForExpr.endsWith("*"))) {
                                if (aliasForExpr.length() > 30) {
                                    aliasForExpr = aliasForExpr.substring(0, 29);
                                }
                                if (aliasForExpr.length() > 0) {
                                    sc1.setAliasForExpression("\"" + aliasForExpr.replaceAll("\n", " ").replaceAll("\t", " ") + "\"");
                                }
                            }
                        }
                        if (sc1.getAliasName() == null && sc1.getAliasForExpression() != null) {
                            sc1.setAliasName(sc1.getAliasForExpression());
                        }
                    }
                    v_sil.addElement(sc1.toTeradataSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.selectItemList.elementAt(i_count) instanceof WhereColumn) {
                    v_sil.addElement((WhereColumn)this.selectItemList.elementAt(i_count));
                    continue;
                }
                v_sil.addElement((String)this.selectItemList.elementAt(i_count));
            }
            t_ss.setSelectItemList(v_sil);
        }
        return t_ss;
    }

    public SelectStatement toDB2Select(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectStatement t_ss = new SelectStatement();
        t_ss.setOpenBraceForSelectInInsertQuery(this.openBraceForSelectInInsert);
        t_ss.setSelectClause(this.selectClause);
        if (this.selectQualifier != null) {
            GroupByStatement gbs_gb = from_sqs.getGroupByStatement();
            HavingStatement hs = from_sqs.getHavingStatement();
            if (this.selectQualifier.equalsIgnoreCase("DISTINCT ON")) {
                if (gbs_gb != null) {
                    to_sqs.setGroupByStatement(gbs_gb.toDB2Select(to_sqs, from_sqs));
                    this.addGroupByItems(to_sqs, from_sqs);
                } else {
                    to_sqs.setGroupByStatement(this.createGroupByStatement(to_sqs, from_sqs));
                }
                if (hs != null) {
                    to_sqs.setHavingStatement(hs.toDB2Select(to_sqs, from_sqs));
                    this.addHavingItem(to_sqs);
                } else {
                    to_sqs.setHavingStatement(this.createHavingStatement());
                }
                this.setSelectItemList(t_ss, from_sqs, to_sqs);
            } else if (this.selectQualifier.equalsIgnoreCase("UNIQUE")) {
                t_ss.setSelectQualifier("DISTINCT");
            } else {
                t_ss.setSelectQualifier(this.selectQualifier);
            }
        }
        if (this.selectRowSpecifier != null || this.ifxSelectRowSpecifier != null) {
            if (this.percentSpecifier != null) {
                throw new ConvertException();
            }
            FetchClause fc = new FetchClause();
            if (from_sqs.getFetchClause() != null) {
                throw new ConvertException();
            }
            fc.setFetchFirstClause("FETCH FIRST");
            fc.setFetchCount("" + this.selectRowCount);
            fc.setRowOnlyClause("ROWS ONLY");
            to_sqs.setFetchClause(fc);
        }
        if (this.selectQualifier != null && !this.selectQualifier.equalsIgnoreCase("DISTINCT ON") || this.selectQualifier == null) {
            Vector<Object> v_sil = new Vector<Object>();
            int count2 = 0;
            for (int i_count = 0; i_count < this.selectItemList.size(); ++i_count) {
                if (this.selectItemList.elementAt(i_count) instanceof SelectColumn) {
                    SelectColumn sc = (SelectColumn)this.selectItemList.elementAt(i_count);
                    if (this.insertValList != null) {
                        sc.setCorrespondingTableColumn((TableColumn)this.insertValList.get(count2));
                    }
                    Vector v_ce = sc.getColumnExpression();
                    for (int ii_count = 0; ii_count < v_ce.size(); ++ii_count) {
                        String s_ce;
                        if (!(v_ce.elementAt(ii_count) instanceof String) || !(s_ce = (String)v_ce.elementAt(ii_count)).equalsIgnoreCase("*") || v_ce.size() != 1 || this.selectItemList.size() <= 1) continue;
                        FromClause fc = from_sqs.getFromClause();
                        Vector v_fil = fc.getFromItemList();
                        if (v_fil.size() > 1) {
                            for (int countNum = 0; countNum < v_fil.size(); ++countNum) {
                                if (v_fil.elementAt(countNum) instanceof FromTable) {
                                    FromTable ft = (FromTable)v_fil.elementAt(countNum);
                                    if (ft.getAliasName() == null) {
                                        Object o_tn = ft.getTableName();
                                        if (!(o_tn instanceof String)) {
                                            throw new ConvertException();
                                        }
                                        s_ce = (String)o_tn + ".*";
                                    } else {
                                        s_ce = ft.getAliasName() + ".*";
                                    }
                                } else if (v_fil.elementAt(countNum) instanceof FromClause) {
                                    Vector newFromItemList = ((FromClause)v_fil.get(countNum)).getFromItemList();
                                    this.changeTheSelectColumnWithStarToTableNameStar(v_ce, newFromItemList, ii_count);
                                }
                                if (countNum == 0) {
                                    v_ce.setElementAt(s_ce, ii_count);
                                    continue;
                                }
                                v_ce.add(",");
                                v_ce.add(s_ce);
                            }
                            continue;
                        }
                        if (v_fil.elementAt(0) instanceof FromTable) {
                            FromTable ft = (FromTable)v_fil.elementAt(0);
                            if (ft.getAliasName() == null) {
                                Object o_tn = ft.getTableName();
                                if (!(o_tn instanceof String)) {
                                    throw new ConvertException();
                                }
                                s_ce = (String)o_tn + ".*";
                            } else {
                                s_ce = ft.getAliasName() + ".*";
                            }
                            v_ce.setElementAt(s_ce, ii_count);
                            continue;
                        }
                        if (!(v_fil.elementAt(0) instanceof FromClause)) continue;
                        Vector newFCVector = ((FromClause)v_fil.get(0)).getFromItemList();
                        this.changeTheSelectColumnWithStarToTableNameStar(v_ce, newFCVector, ii_count);
                    }
                    sc.setColumnExpression(v_ce);
                    v_sil.addElement(((SelectColumn)this.selectItemList.elementAt(i_count)).toDB2Select(to_sqs, from_sqs));
                } else if (this.selectItemList.elementAt(i_count) instanceof WhereColumn) {
                    v_sil.addElement((WhereColumn)this.selectItemList.elementAt(i_count));
                } else {
                    v_sil.addElement((String)this.selectItemList.elementAt(i_count));
                }
                ++count2;
            }
            t_ss.setSelectItemList(v_sil);
        }
        return t_ss;
    }

    public SelectStatement toMySQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectStatement t_ss = new SelectStatement();
        t_ss.setSelectClause(this.selectClause);
        if (this.selectQualifier != null) {
            GroupByStatement gbs_gb = from_sqs.getGroupByStatement();
            HavingStatement hs = from_sqs.getHavingStatement();
            if (this.selectQualifier.equalsIgnoreCase("DISTINCT ON")) {
                if (gbs_gb != null) {
                    to_sqs.setGroupByStatement(gbs_gb.toMySQLSelect(to_sqs, from_sqs));
                    this.addGroupByItems(to_sqs, from_sqs);
                } else {
                    to_sqs.setGroupByStatement(this.createGroupByStatement(to_sqs, from_sqs));
                }
                if (hs != null) {
                    to_sqs.setHavingStatement(hs.toMySQLSelect(to_sqs, from_sqs));
                    this.addHavingItem(to_sqs);
                } else {
                    to_sqs.setHavingStatement(this.createHavingStatement());
                }
                this.setSelectItemList(t_ss, from_sqs, to_sqs);
            } else if (this.selectQualifier.equalsIgnoreCase("UNIQUE")) {
                t_ss.setSelectQualifier("DISTINCT");
            } else {
                t_ss.setSelectQualifier(this.selectQualifier);
            }
        }
        if (this.selectRowSpecifier != null) {
            if (this.percentSpecifier != null) {
                throw new ConvertException();
            }
            LimitClause lc = new LimitClause();
            if (from_sqs.getLimitClause() != null) {
                throw new ConvertException();
            }
            lc.setLimitClause("LIMIT");
            lc.setLimitValue("" + this.selectRowCount);
            to_sqs.setLimitClause(lc);
        }
        if (this.selectSpecialQualifier != null) {
            t_ss.setSelectSpecialQualifier(this.selectSpecialQualifier);
        }
        if (this.selectQualifier != null && !this.selectQualifier.equalsIgnoreCase("DISTINCT ON") || this.selectQualifier == null) {
            Vector<Object> v_sil = new Vector<Object>();
            for (int i_count = 0; i_count < this.selectItemList.size(); ++i_count) {
                if (this.selectItemList.elementAt(i_count) instanceof SelectColumn) {
                    SelectColumn sc = (SelectColumn)this.selectItemList.elementAt(i_count);
                    Vector v_ce = sc.getColumnExpression();
                    for (int ii_count = 0; ii_count < v_ce.size(); ++ii_count) {
                        FromClause fc;
                        Vector v_fil;
                        String s_ce;
                        if (!(v_ce.elementAt(ii_count) instanceof String) || !(s_ce = (String)v_ce.elementAt(ii_count)).equalsIgnoreCase("*") || v_ce.size() != 1 || this.selectItemList.size() <= 1 || (v_fil = (fc = from_sqs.getFromClause()).getFromItemList()).size() > 1) continue;
                        FromTable ft = (FromTable)v_fil.elementAt(0);
                        if (ft.getAliasName() == null) {
                            Object o_tn = ft.getTableName();
                            if (!(o_tn instanceof String)) {
                                throw new ConvertException();
                            }
                        } else {
                            s_ce = ft.getAliasName() + ".*";
                        }
                        v_ce.setElementAt(s_ce, ii_count);
                    }
                    sc.setColumnExpression(v_ce);
                    v_sil.addElement(((SelectColumn)this.selectItemList.elementAt(i_count)).toMySQLSelect(to_sqs, from_sqs));
                    continue;
                }
                v_sil.addElement((String)this.selectItemList.elementAt(i_count));
            }
            t_ss.setSelectItemList(v_sil);
        }
        return t_ss;
    }

    public HavingStatement createHavingStatement() {
        HavingStatement hs = new HavingStatement();
        Vector<Object> v_hi = new Vector<Object>();
        Vector<SelectColumn> v_fa = new Vector<SelectColumn>();
        SelectColumn sc = new SelectColumn();
        SelectColumn sc_new = new SelectColumn();
        SelectColumn sc_temp = new SelectColumn();
        Vector<String> v_new = new Vector<String>();
        Vector<FunctionCalls> v_fi = new Vector<FunctionCalls>();
        TableColumn tc = new TableColumn();
        FunctionCalls fc = new FunctionCalls();
        Vector<String> vec_fa = new Vector<String>();
        v_hi.addElement("(");
        tc.setColumnName("COUNT");
        fc.setFunctionName(tc);
        vec_fa.addElement("*");
        sc_new.setColumnExpression(vec_fa);
        v_fa.addElement(sc_new);
        fc.setFunctionArguments(v_fa);
        v_fi.addElement(fc);
        sc.setColumnExpression(v_fi);
        v_hi.addElement(sc);
        v_hi.addElement("<");
        v_new.addElement("2");
        sc_temp.setColumnExpression(v_new);
        v_hi.addElement(sc_temp);
        v_hi.addElement(")");
        hs.setHavingClause("HAVING");
        hs.setHavingItems(v_hi);
        return hs;
    }

    public void addHavingItem(SelectQueryStatement to_sqs) {
        HavingStatement hs = to_sqs.getHavingStatement();
        Vector v_to_hi = hs.getHavingItems();
        Vector v_hi = new Vector();
        for (int i_count = 0; i_count < v_to_hi.size(); ++i_count) {
            v_hi.addElement(v_to_hi.elementAt(i_count));
        }
        v_hi.addElement("AND");
        SelectColumn sc = new SelectColumn();
        SelectColumn sc_new = new SelectColumn();
        SelectColumn sc_temp = new SelectColumn();
        Vector<String> v_new = new Vector<String>();
        Vector<FunctionCalls> v_fi = new Vector<FunctionCalls>();
        Vector<SelectColumn> v_fa = new Vector<SelectColumn>();
        TableColumn tc = new TableColumn();
        FunctionCalls fc = new FunctionCalls();
        Vector<String> vec_fa = new Vector<String>();
        v_hi.addElement("(");
        tc.setColumnName("COUNT");
        fc.setFunctionName(tc);
        vec_fa.addElement("*");
        sc_new.setColumnExpression(vec_fa);
        v_fa.addElement(sc);
        fc.setFunctionArguments(v_fa);
        v_fi.addElement(fc);
        sc.setColumnExpression(v_fi);
        v_hi.addElement(sc);
        v_hi.addElement("<");
        v_new.addElement("2");
        sc_temp.setColumnExpression(v_new);
        v_hi.addElement(sc_temp);
        v_hi.addElement(")");
        hs.setHavingItems(v_hi);
    }

    public SelectStatement toPostgreSQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        int i_count;
        SelectStatement t_ss = new SelectStatement();
        t_ss.setSelectClause(this.selectClause);
        if (this.selectQualifier != null) {
            if (this.selectQualifier.equalsIgnoreCase("UNIQUE")) {
                t_ss.setSelectQualifier("DISTINCT");
            } else {
                t_ss.setSelectQualifier(this.selectQualifier);
            }
            Vector<SelectColumn> v_dl = new Vector<SelectColumn>();
            if (this.distinctList != null) {
                for (i_count = 0; i_count < this.distinctList.size(); ++i_count) {
                    v_dl.addElement(((SelectColumn)this.distinctList.elementAt(i_count)).toPostgreSQLSelect(to_sqs, from_sqs));
                }
            }
            t_ss.setDistinctList(v_dl);
        }
        if (this.selectRowSpecifier != null) {
            if (this.percentSpecifier != null) {
                throw new ConvertException();
            }
            LimitClause lc = new LimitClause();
            if (from_sqs.getLimitClause() != null) {
                throw new ConvertException();
            }
            lc.setLimitClause("LIMIT");
            lc.setLimitValue("" + this.selectRowCount);
            to_sqs.setLimitClause(lc);
        }
        if (this.selectSpecialQualifier != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("/* " + this.selectSpecialQualifier + "*/");
            t_ss.setSelectSpecialQualifier(sb.toString());
        }
        if (this.selectItemList != null) {
            Vector<Object> v_sil = new Vector<Object>();
            for (i_count = 0; i_count < this.selectItemList.size(); ++i_count) {
                if (this.selectItemList.elementAt(i_count) instanceof SelectColumn) {
                    v_sil.addElement(((SelectColumn)this.selectItemList.elementAt(i_count)).toPostgreSQLSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.selectItemList.elementAt(i_count) instanceof WhereColumn) {
                    v_sil.addElement((WhereColumn)this.selectItemList.elementAt(i_count));
                    continue;
                }
                v_sil.addElement((String)this.selectItemList.elementAt(i_count));
            }
            t_ss.setSelectItemList(v_sil);
        }
        return t_ss;
    }

    public SelectStatement toMSSQLServerSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectStatement t_ss = new SelectStatement();
        t_ss.setSelectClause(this.selectClause);
        t_ss.setCommentClass(this.commentObj);
        if (this.selectQualifier != null) {
            GroupByStatement gbs_gb = from_sqs.getGroupByStatement();
            HavingStatement hs = from_sqs.getHavingStatement();
            if (this.selectQualifier.equalsIgnoreCase("DISTINCT ON")) {
                if (gbs_gb != null) {
                    to_sqs.setGroupByStatement(gbs_gb.toMSSQLServerSelect(to_sqs, from_sqs));
                    this.addGroupByItems(to_sqs, from_sqs);
                } else {
                    to_sqs.setGroupByStatement(this.createGroupByStatement(to_sqs, from_sqs));
                }
                if (hs != null) {
                    to_sqs.setHavingStatement(hs.toMSSQLServerSelect(to_sqs, from_sqs));
                    this.addHavingItem(to_sqs);
                } else {
                    to_sqs.setHavingStatement(this.createHavingStatement());
                }
                this.setSelectItemList(t_ss, from_sqs, to_sqs);
            } else if (this.selectQualifier.equalsIgnoreCase("UNIQUE")) {
                t_ss.setSelectQualifier("DISTINCT");
            } else {
                t_ss.setSelectQualifier(this.selectQualifier);
            }
        }
        if (this.selectRowSpecifier != null || this.ifxSelectRowSpecifier != null) {
            if (this.selectRowSpecifier != null && this.selectRowSpecifier.equalsIgnoreCase("FIRST")) {
                t_ss.setSelectRowSpecifier("TOP");
            } else if (this.ifxSelectRowSpecifier != null && this.ifxSelectRowSpecifier.equalsIgnoreCase("FIRST")) {
                t_ss.setSelectRowSpecifier("TOP");
                this.ifxSelectRowSpecifier = null;
            } else {
                t_ss.setSelectRowSpecifier(this.selectRowSpecifier);
                t_ss.setOpenBraceForRowCount(this.openBraceForRowCount);
                t_ss.setClosedBraceForRowCount(this.closedBraceForRowCount);
                t_ss.setSelectRowCountVariable(this.rowcountVariable);
            }
            t_ss.setSelectRowCount(this.selectRowCount);
        }
        if (this.selectSpecialQualifier != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("/* " + this.selectSpecialQualifier + "*/");
            t_ss.setSelectSpecialQualifier(sb.toString());
        }
        if (this.selectQualifier != null && !this.selectQualifier.equalsIgnoreCase("DISTINCT ON") || this.selectQualifier == null) {
            Vector<Object> v_sil = new Vector<Object>();
            for (int i_count = 0; i_count < this.selectItemList.size(); ++i_count) {
                if (this.selectItemList.elementAt(i_count) instanceof SelectColumn) {
                    v_sil.addElement(((SelectColumn)this.selectItemList.elementAt(i_count)).toMSSQLServerSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.selectItemList.elementAt(i_count) instanceof WhereColumn) {
                    v_sil.addElement((WhereColumn)this.selectItemList.elementAt(i_count));
                    continue;
                }
                v_sil.addElement((String)this.selectItemList.elementAt(i_count));
            }
            t_ss.setSelectItemList(v_sil);
        }
        t_ss.setPercentSpecifier(this.percentSpecifier);
        return t_ss;
    }

    public SelectStatement toSybaseSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectStatement t_ss = new SelectStatement();
        t_ss.setSelectClause(this.selectClause);
        if (this.selectQualifier != null) {
            GroupByStatement gbs_gb = from_sqs.getGroupByStatement();
            HavingStatement hs = from_sqs.getHavingStatement();
            if (this.selectQualifier.equalsIgnoreCase("DISTINCT ON")) {
                if (gbs_gb != null) {
                    to_sqs.setGroupByStatement(gbs_gb.toSybaseSelect(to_sqs, from_sqs));
                    this.addGroupByItems(to_sqs, from_sqs);
                } else {
                    to_sqs.setGroupByStatement(this.createGroupByStatement(to_sqs, from_sqs));
                }
                if (hs != null) {
                    to_sqs.setHavingStatement(hs.toSybaseSelect(to_sqs, from_sqs));
                    this.addHavingItem(to_sqs);
                } else {
                    to_sqs.setHavingStatement(this.createHavingStatement());
                }
                this.setSelectItemList(t_ss, from_sqs, to_sqs);
            } else if (this.selectQualifier.equalsIgnoreCase("UNIQUE")) {
                t_ss.setSelectQualifier("DISTINCT");
            } else {
                t_ss.setSelectQualifier(this.selectQualifier);
            }
        }
        if (this.selectRowSpecifier != null || this.ifxSelectRowSpecifier != null) {
            if (this.selectRowSpecifier != null && this.selectRowSpecifier.equalsIgnoreCase("FIRST")) {
                t_ss.setSelectRowSpecifier("TOP");
            } else if (this.ifxSelectRowSpecifier != null && this.ifxSelectRowSpecifier.equalsIgnoreCase("FIRST")) {
                t_ss.setSelectRowSpecifier("TOP");
                this.ifxSelectRowSpecifier = null;
            } else if (this.selectRowSpecifier != null && this.selectRowSpecifier.equalsIgnoreCase("TOP")) {
                t_ss.setSelectRowSpecifier(null);
                to_sqs.setSybaseTopRowCount(this.selectRowCount);
            } else {
                t_ss.setSelectRowSpecifier(this.selectRowSpecifier);
            }
            t_ss.setSelectRowCount(this.selectRowCount);
        }
        if (this.selectSpecialQualifier != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("/* " + this.selectSpecialQualifier + "*/");
            t_ss.setSelectSpecialQualifier(sb.toString());
        }
        for (int i_count = 0; i_count < this.selectItemList.size(); ++i_count) {
            if (!(this.selectItemList.elementAt(i_count) instanceof SelectColumn)) continue;
            ((SelectColumn)this.selectItemList.elementAt(i_count)).setObjectContext(this.context);
        }
        if (this.selectQualifier != null && !this.selectQualifier.equalsIgnoreCase("DISTINCT ON") || this.selectQualifier == null) {
            Vector<Object> v_sil = new Vector<Object>();
            Vector<String> aliasNames = new Vector<String>();
            int aliasCount = 1;
            for (int i_count = 0; i_count < this.selectItemList.size(); ++i_count) {
                if (this.selectItemList.elementAt(i_count) instanceof SelectColumn) {
                    SelectColumn sc = (SelectColumn)this.selectItemList.elementAt(i_count);
                    sc.setObjectContext(this.context);
                    if (sc.getAliasName() != null) {
                        if (aliasNames != null && aliasNames.contains(sc.getAliasName())) {
                            sc.setAliasName(sc.getAliasName() + aliasCount);
                            ++aliasCount;
                        } else {
                            aliasNames.add(sc.getAliasName());
                        }
                    }
                    v_sil.addElement(((SelectColumn)this.selectItemList.elementAt(i_count)).toSybaseSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.selectItemList.elementAt(i_count) instanceof WhereColumn) {
                    ((WhereColumn)this.selectItemList.elementAt(i_count)).setObjectContext(this.context);
                    v_sil.addElement((WhereColumn)this.selectItemList.elementAt(i_count));
                    continue;
                }
                v_sil.addElement((String)this.selectItemList.elementAt(i_count));
            }
            t_ss.setSelectItemList(v_sil);
        }
        t_ss.setPercentSpecifier(this.percentSpecifier);
        t_ss.setObjectContext(this.context);
        return t_ss;
    }

    public void setSelectItemList(SelectStatement ss, SelectQueryStatement from_sqs, SelectQueryStatement to_sqs) throws ConvertException {
        SelectStatement from_ss = from_sqs.getSelectStatement();
        Vector v_sil = from_ss.getSelectItemList();
        Vector<SelectColumn> v_new_sil = new Vector<SelectColumn>();
        for (int i_count = 0; i_count < v_sil.size(); ++i_count) {
            SelectColumn sc = new SelectColumn();
            Vector<Object> v_fi = new Vector<Object>();
            TableColumn tc = new TableColumn();
            FunctionCalls fc = new FunctionCalls();
            Vector<FunctionCalls> vec_af = new Vector<FunctionCalls>();
            tc.setColumnName("MAX");
            fc.setFunctionName(tc);
            if (v_sil.elementAt(i_count) instanceof SelectColumn) {
                SelectColumn sc_vi = ((SelectColumn)v_sil.elementAt(i_count)).toMSSQLServerSelect(to_sqs, from_sqs);
                sc_vi.setEndsWith(null);
                sc_vi.setAliasName(null);
                sc_vi.setIsAS(null);
                v_fi.addElement(sc_vi);
                if (sc_vi.getColumnExpression().elementAt(0) instanceof TableColumn) {
                    sc.setAliasName(((TableColumn)sc_vi.getColumnExpression().elementAt(0)).getColumnName());
                }
            } else {
                v_fi.addElement((String)v_sil.elementAt(i_count));
            }
            fc.setFunctionArguments(v_fi);
            vec_af.addElement(fc);
            sc.setColumnExpression(vec_af);
            if (i_count != v_sil.size() - 1) {
                sc.setEndsWith(",");
            }
            v_new_sil.addElement(sc);
        }
        ss.setSelectItemList(v_new_sil);
    }

    public GroupByStatement createGroupByStatement(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        GroupByStatement gbs = new GroupByStatement();
        Vector<SelectColumn> v_gbil = new Vector<SelectColumn>();
        gbs.setGroupClause("GROUP BY");
        for (int i_count = 0; i_count < this.distinctList.size(); ++i_count) {
            v_gbil.addElement(((SelectColumn)this.distinctList.elementAt(i_count)).toMSSQLServerSelect(to_sqs, from_sqs));
        }
        gbs.setGroupByItemList(v_gbil);
        return gbs;
    }

    public void addGroupByItems(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        int i_count;
        GroupByStatement gbs = to_sqs.getGroupByStatement();
        Vector v_gbil = gbs.getGroupByItemList();
        Vector v_new_gbil = new Vector();
        for (i_count = 0; i_count < v_gbil.size(); ++i_count) {
            v_new_gbil.addElement(v_gbil.elementAt(i_count));
        }
        for (i_count = 0; i_count < this.distinctList.size(); ++i_count) {
            v_new_gbil.addElement(((SelectColumn)this.distinctList.elementAt(i_count)).toMSSQLServerSelect(to_sqs, from_sqs));
        }
        gbs.setGroupByItemList(v_new_gbil);
    }

    public SelectStatement toOracleSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereExpression f_we;
        SelectStatement t_ss = new SelectStatement();
        t_ss.setSelectClause(this.selectClause);
        t_ss.setHintClause(this.hintClause);
        t_ss.setCommentClass(this.commentObj);
        if (this.selectQualifier != null) {
            f_we = from_sqs.getWhereExpression();
            WhereExpression t_we = new WhereExpression();
            if (this.selectQualifier.equalsIgnoreCase("DISTINCT ON")) {
                if (f_we != null) {
                    to_sqs.setWhereExpression(f_we.toOracleSelect(to_sqs, from_sqs));
                    to_sqs.getWhereExpression().addOperator("AND");
                    to_sqs.getWhereExpression().addWhereExpression(this.createQuery(from_sqs.getFromClause(), to_sqs, from_sqs));
                } else {
                    to_sqs.setWhereExpression(this.createQuery(from_sqs.getFromClause(), to_sqs, from_sqs));
                }
            } else {
                t_ss.setSelectQualifier(this.selectQualifier);
            }
        }
        if ((this.selectRowSpecifier != null || this.ifxSelectRowSpecifier != null) && (this.selectRowSpecifier != null && this.selectRowSpecifier.equalsIgnoreCase("TOP") || this.selectRowSpecifier != null && this.selectRowSpecifier.equalsIgnoreCase("FIRST") || this.ifxSelectRowSpecifier != null && this.ifxSelectRowSpecifier.equalsIgnoreCase("FIRST"))) {
            f_we = from_sqs.getWhereExpression();
            WhereItem wi = new WhereItem();
            Vector<String> v_temp = new Vector<String>();
            WhereColumn wc_temp = new WhereColumn();
            v_temp.addElement("ROWNUM");
            wc_temp.setColumnExpression(v_temp);
            wi.setLeftWhereExp(wc_temp);
            wi.setOperator("<");
            v_temp = new Vector();
            wc_temp = new WhereColumn();
            if (this.percentSpecifier != null) {
                String s_sqs = this.rowcountVariable != null && this.selectRowCount == 0 ? "select count(*)*(" + this.rowcountVariable + "/100) + 1 " + from_sqs.getFromClause().toString() : "select count(*)*(" + this.selectRowCount + "/100) + 1 " + from_sqs.getFromClause().toString();
                SwisSQLAPI swissqlapi = new SwisSQLAPI(s_sqs);
                try {
                    s_sqs = swissqlapi.convert(1);
                    s_sqs = "(" + s_sqs + ")";
                }
                catch (ParseException pe) {
                    throw new ConvertException(" Could not parse the converted from clause " + s_sqs);
                }
                catch (ConvertException ce) {
                    throw ce;
                }
                v_temp.addElement(s_sqs);
            } else if (this.rowcountVariable != null) {
                v_temp.addElement(this.rowcountVariable + " + 1");
            } else {
                v_temp.addElement(Integer.toString(this.selectRowCount + 1));
            }
            wc_temp.setColumnExpression(v_temp);
            wi.setRightWhereExp(wc_temp);
            if (f_we != null && f_we.getCheckWhere()) {
                to_sqs.getWhereExpression().addOperator("AND");
                to_sqs.getWhereExpression().addWhereItem(wi);
            } else if (f_we != null) {
                to_sqs.setWhereExpression(f_we.toOracleSelect(to_sqs, from_sqs));
                to_sqs.getWhereExpression().addOperator("AND");
                to_sqs.getWhereExpression().addWhereItem(wi);
            } else {
                WhereExpression we = new WhereExpression();
                we.addWhereItem(wi);
                if (to_sqs != null && to_sqs.getWhereExpression() != null) {
                    to_sqs.getWhereExpression().addOperator("AND");
                    to_sqs.getWhereExpression().addWhereExpression(we);
                } else {
                    to_sqs.setWhereExpression(we);
                }
            }
        }
        if (this.selectSpecialQualifier != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("/* +" + this.selectSpecialQualifier + "*/");
            t_ss.setSelectSpecialQualifier(sb.toString());
        }
        Vector<Object> v_sil = new Vector<Object>();
        for (int i_count = 0; i_count < this.selectItemList.size(); ++i_count) {
            if (this.selectItemList.elementAt(i_count) instanceof SelectColumn) {
                SelectColumn oracleSelectColumn;
                SelectColumn originalsc = (SelectColumn)this.selectItemList.elementAt(i_count);
                SelectColumn sc = oracleSelectColumn = ((SelectColumn)this.selectItemList.elementAt(i_count)).toOracleSelect(to_sqs, from_sqs);
                Vector v_ce = sc.getColumnExpression();
                for (int ii_count = 0; ii_count < v_ce.size(); ++ii_count) {
                    String s_ce;
                    if (!(v_ce.elementAt(ii_count) instanceof String) || !(s_ce = (String)v_ce.elementAt(ii_count)).equalsIgnoreCase("*") || v_ce.size() != 1 || this.selectItemList.size() <= 1) continue;
                    FromClause fc = from_sqs.getFromClause();
                    Vector v_fil = fc.getFromItemList();
                    if (v_fil.size() > 1) {
                        for (int countNum = 0; countNum < v_fil.size(); ++countNum) {
                            if (v_fil.elementAt(countNum) instanceof FromTable) {
                                FromTable ft = (FromTable)v_fil.elementAt(countNum);
                                if (ft.getAliasName() == null) {
                                    Object o_tn = ft.getTableName();
                                    if (!(o_tn instanceof String)) {
                                        throw new ConvertException();
                                    }
                                    String tableName = (String)o_tn;
                                    if (tableName.toLowerCase().startsWith("dbo.")) {
                                        tableName = tableName.substring(4);
                                    } else if (tableName.toLowerCase().startsWith("[dbo].")) {
                                        tableName = tableName.substring(6);
                                    }
                                    s_ce = tableName + ".*";
                                } else {
                                    s_ce = ft.getAliasName() + ".*";
                                }
                            } else if (v_fil.elementAt(countNum) instanceof FromClause) {
                                Vector newFromItemList = ((FromClause)v_fil.get(countNum)).getFromItemList();
                                this.changeTheSelectColumnWithStarToTableNameStar(v_ce, newFromItemList, ii_count);
                            }
                            if (countNum == 0) {
                                v_ce.setElementAt(s_ce, ii_count);
                                continue;
                            }
                            v_ce.add(",");
                            v_ce.add(s_ce);
                        }
                        continue;
                    }
                    if (v_fil.elementAt(0) instanceof FromTable) {
                        FromTable ft = (FromTable)v_fil.elementAt(0);
                        if (ft.getAliasName() == null) {
                            Object o_tn = ft.getTableName();
                            if (!(o_tn instanceof String)) {
                                throw new ConvertException();
                            }
                            String tableName = (String)o_tn;
                            if (tableName.toLowerCase().startsWith("dbo.")) {
                                tableName = tableName.substring(4);
                            } else if (tableName.toLowerCase().startsWith("[dbo].")) {
                                tableName = tableName.substring(6);
                            }
                            s_ce = tableName + ".*";
                        } else {
                            s_ce = ft.getAliasName() + ".*";
                        }
                        v_ce.setElementAt(s_ce, ii_count);
                        continue;
                    }
                    if (!(v_fil.elementAt(0) instanceof FromClause)) continue;
                    Vector newFCVector = ((FromClause)v_fil.get(0)).getFromItemList();
                    this.changeTheSelectColumnWithStarToTableNameStar(v_ce, newFCVector, ii_count);
                }
                sc.setColumnExpression(v_ce);
                v_sil.addElement(sc);
                continue;
            }
            if (this.selectItemList.elementAt(i_count) instanceof WhereColumn) {
                v_sil.addElement((WhereColumn)this.selectItemList.elementAt(i_count));
                continue;
            }
            if (this.selectItemList.elementAt(i_count) instanceof SelectQueryStatement) {
                SelectQueryStatement ss = (SelectQueryStatement)this.selectItemList.elementAt(i_count);
                if (ss.getWhereExpression() == null) {
                    WhereExpression we = new WhereExpression();
                    ss.setWhereExpression(we);
                } else {
                    ss.getWhereExpression().addOperator("AND");
                }
                WhereColumn col1 = new WhereColumn();
                Vector<String> col1List = new Vector<String>();
                col1List.add("ROWNUM");
                col1.setColumnExpression(col1List);
                WhereColumn col2 = new WhereColumn();
                Vector<String> col2List = new Vector<String>();
                col2List.add("1");
                col2.setColumnExpression(col2List);
                WhereItem it = new WhereItem();
                it.setLeftWhereExp(col1);
                it.setRightWhereExp(col2);
                it.setOperator("=");
                ss.getWhereExpression().addWhereItem(it);
                v_sil.addElement(ss);
                continue;
            }
            v_sil.addElement((String)this.selectItemList.elementAt(i_count));
        }
        t_ss.setSelectItemList(v_sil);
        t_ss.setObjectContext(this.context);
        return t_ss;
    }

    private void changeTheSelectColumnWithStarToTableNameStar(Vector v_ce, Vector v_fil, int num) throws ConvertException {
        for (int ii_count = 0; ii_count < v_ce.size(); ++ii_count) {
            String s_ce;
            if (!(v_ce.elementAt(ii_count) instanceof String) || !(s_ce = (String)v_ce.elementAt(ii_count)).equalsIgnoreCase("*") || v_ce.size() != 1 || this.selectItemList.size() <= 1) continue;
            if (v_fil.size() > 1) {
                for (int countNum = 0; countNum < v_fil.size(); ++countNum) {
                    if (v_fil.elementAt(countNum) instanceof FromTable) {
                        FromTable ft = (FromTable)v_fil.elementAt(countNum);
                        if (ft.getAliasName() == null) {
                            Object o_tn = ft.getTableName();
                            if (!(o_tn instanceof String)) {
                                throw new ConvertException();
                            }
                            s_ce = (String)o_tn + ".*";
                        } else {
                            s_ce = ft.getAliasName() + ".*";
                        }
                    } else if (v_fil.elementAt(countNum) instanceof FromClause) {
                        Vector newFCVector = ((FromClause)v_fil.get(countNum)).getFromItemList();
                        this.changeTheSelectColumnWithStarToTableNameStar(v_ce, newFCVector, num);
                    }
                    if (countNum == 0) {
                        v_ce.setElementAt(s_ce, num);
                        continue;
                    }
                    if (countNum > 0) {
                        v_ce.add(",");
                    }
                    v_ce.add(s_ce);
                }
                continue;
            }
            if (v_fil.elementAt(0) instanceof FromTable) {
                FromTable ft = (FromTable)v_fil.elementAt(0);
                if (ft.getAliasName() == null) {
                    Object o_tn = ft.getTableName();
                    if (!(o_tn instanceof String)) {
                        throw new ConvertException();
                    }
                    s_ce = (String)o_tn + ".*";
                } else {
                    s_ce = ft.getAliasName() + ".*";
                }
                v_ce.setElementAt(s_ce, ii_count);
                continue;
            }
            if (!(v_fil.elementAt(0) instanceof FromClause)) continue;
            Vector newFCVector = ((FromClause)v_fil.get(0)).getFromItemList();
            this.changeTheSelectColumnWithStarToTableNameStar(v_ce, newFCVector, ii_count);
        }
    }

    public SelectStatement toInformixSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectStatement t_ss = new SelectStatement();
        t_ss.setSelectClause(this.selectClause);
        if (this.selectQualifier != null) {
            GroupByStatement gbs_gb = from_sqs.getGroupByStatement();
            HavingStatement hs = from_sqs.getHavingStatement();
            if (this.selectQualifier.equalsIgnoreCase("DISTINCT ON")) {
                if (gbs_gb != null) {
                    to_sqs.setGroupByStatement(gbs_gb.toInformixSelect(to_sqs, from_sqs));
                    this.addGroupByItems(to_sqs, from_sqs);
                } else {
                    to_sqs.setGroupByStatement(this.createGroupByStatement(to_sqs, from_sqs));
                }
                if (hs != null) {
                    to_sqs.setHavingStatement(hs.toMySQLSelect(to_sqs, from_sqs));
                    this.addHavingItem(to_sqs);
                } else {
                    to_sqs.setHavingStatement(this.createHavingStatement());
                }
                this.setSelectItemList(t_ss, from_sqs, to_sqs);
            } else {
                t_ss.setSelectQualifier(this.selectQualifier);
            }
        }
        if (this.selectRowSpecifier != null) {
            if (this.selectRowSpecifier.equalsIgnoreCase("TOP")) {
                t_ss.setInformixRowSpecifier("FIRST");
                t_ss.setSelectRowSpecifier(null);
            } else {
                t_ss.setSelectRowSpecifier(this.selectRowSpecifier);
            }
            t_ss.setSelectRowCount(this.selectRowCount);
        }
        if (this.selectSpecialQualifier != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("/* " + this.selectSpecialQualifier + "*/");
            t_ss.setSelectSpecialQualifier(sb.toString());
        }
        if (this.selectQualifier != null && !this.selectQualifier.equalsIgnoreCase("DISTINCT ON") || this.selectQualifier == null) {
            Vector<Object> v_sil = new Vector<Object>();
            for (int i_count = 0; i_count < this.selectItemList.size(); ++i_count) {
                if (this.selectItemList.elementAt(i_count) instanceof SelectColumn) {
                    v_sil.addElement(((SelectColumn)this.selectItemList.elementAt(i_count)).toInformixSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.selectItemList.elementAt(i_count) instanceof WhereColumn) {
                    v_sil.addElement((WhereColumn)this.selectItemList.elementAt(i_count));
                    continue;
                }
                v_sil.addElement((String)this.selectItemList.elementAt(i_count));
            }
            t_ss.setSelectItemList(v_sil);
        }
        if (this.selectRowSpecifier != null && this.selectRowSpecifier.equalsIgnoreCase("FIRST")) {
            t_ss.setSelectRowSpecifier(null);
            t_ss.setInformixRowSpecifier("FIRST");
        }
        return t_ss;
    }

    public SelectStatement toTimesTenSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectStatement t_ss = new SelectStatement();
        t_ss.setSelectClause(this.selectClause);
        t_ss.setOpenBraceForSelectInInsertQuery(this.openBraceForSelectInInsert);
        if (this.selectQualifier != null) {
            WhereExpression f_we = from_sqs.getWhereExpression();
            WhereExpression t_we = new WhereExpression();
            if (this.selectQualifier.equalsIgnoreCase("DISTINCT ON")) {
                if (f_we != null) {
                    to_sqs.setWhereExpression(f_we.toTimesTenSelect(to_sqs, from_sqs));
                    to_sqs.getWhereExpression().addOperator("AND");
                    to_sqs.getWhereExpression().addWhereExpression(this.createQuery(from_sqs.getFromClause(), to_sqs, from_sqs));
                } else {
                    to_sqs.setWhereExpression(this.createQuery(from_sqs.getFromClause(), to_sqs, from_sqs));
                }
            } else {
                t_ss.setSelectQualifier(this.selectQualifier);
            }
        }
        if (this.selectRowSpecifier != null || this.ifxSelectRowSpecifier != null) {
            if (this.selectRowSpecifier != null && this.selectRowSpecifier.equalsIgnoreCase("TOP")) {
                t_ss.setSelectRowSpecifier("FIRST");
            } else {
                t_ss.setSelectRowSpecifier(this.selectRowSpecifier);
            }
            t_ss.setSelectRowCount(this.selectRowCount);
        }
        if (this.selectSpecialQualifier != null) {
            // empty if block
        }
        Vector<Object> v_sil = new Vector<Object>();
        for (int i_count = 0; i_count < this.selectItemList.size(); ++i_count) {
            if (this.selectItemList.elementAt(i_count) instanceof SelectColumn) {
                SelectColumn timesTenSelectColumn;
                SelectColumn originalsc = (SelectColumn)this.selectItemList.elementAt(i_count);
                SelectColumn sc = timesTenSelectColumn = ((SelectColumn)this.selectItemList.elementAt(i_count)).toTimesTenSelect(to_sqs, from_sqs);
                Vector v_ce = sc.getColumnExpression();
                for (int ii_count = 0; ii_count < v_ce.size(); ++ii_count) {
                    String s_ce;
                    if (!(v_ce.elementAt(ii_count) instanceof String) || !(s_ce = (String)v_ce.elementAt(ii_count)).equalsIgnoreCase("*") || v_ce.size() != 1 || this.selectItemList.size() <= 1) continue;
                    FromClause fc = from_sqs.getFromClause();
                    Vector v_fil = fc.getFromItemList();
                    if (v_fil.size() > 1) {
                        for (int countNum = 0; countNum < v_fil.size(); ++countNum) {
                            if (v_fil.elementAt(countNum) instanceof FromTable) {
                                FromTable ft = (FromTable)v_fil.elementAt(countNum);
                                if (ft.getAliasName() == null) {
                                    Object o_tn = ft.getTableName();
                                    if (!(o_tn instanceof String)) {
                                        throw new ConvertException();
                                    }
                                    String tableName = (String)o_tn;
                                    if (tableName.toLowerCase().startsWith("dbo.")) {
                                        tableName = tableName.substring(4);
                                    } else if (tableName.toLowerCase().startsWith("[dbo].")) {
                                        tableName = tableName.substring(6);
                                    }
                                    s_ce = tableName + ".*";
                                } else {
                                    s_ce = ft.getAliasName() + ".*";
                                }
                            } else if (v_fil.elementAt(countNum) instanceof FromClause) {
                                Vector newFromItemList = ((FromClause)v_fil.get(countNum)).getFromItemList();
                                this.changeTheSelectColumnWithStarToTableNameStar(v_ce, newFromItemList, ii_count);
                            }
                            if (countNum == 0) {
                                v_ce.setElementAt(s_ce, ii_count);
                                continue;
                            }
                            v_ce.add(",");
                            v_ce.add(s_ce);
                        }
                        continue;
                    }
                    if (v_fil.elementAt(0) instanceof FromTable) {
                        FromTable ft = (FromTable)v_fil.elementAt(0);
                        if (ft.getAliasName() == null) {
                            Object o_tn = ft.getTableName();
                            if (!(o_tn instanceof String)) {
                                throw new ConvertException();
                            }
                            String tableName = (String)o_tn;
                            if (tableName.toLowerCase().startsWith("dbo.")) {
                                tableName = tableName.substring(4);
                            } else if (tableName.toLowerCase().startsWith("[dbo].")) {
                                tableName = tableName.substring(6);
                            }
                            s_ce = tableName + ".*";
                        } else {
                            s_ce = ft.getAliasName() + ".*";
                        }
                        v_ce.setElementAt(s_ce, ii_count);
                        continue;
                    }
                    if (!(v_fil.elementAt(0) instanceof FromClause)) continue;
                    Vector newFCVector = ((FromClause)v_fil.get(0)).getFromItemList();
                    this.changeTheSelectColumnWithStarToTableNameStar(v_ce, newFCVector, ii_count);
                }
                sc.setColumnExpression(v_ce);
                v_sil.addElement(sc);
                continue;
            }
            if (this.selectItemList.elementAt(i_count) instanceof WhereColumn) {
                v_sil.addElement((WhereColumn)this.selectItemList.elementAt(i_count));
                continue;
            }
            if (this.selectItemList.elementAt(i_count) instanceof SelectQueryStatement) {
                SelectQueryStatement ss = (SelectQueryStatement)this.selectItemList.elementAt(i_count);
                continue;
            }
            v_sil.addElement((String)this.selectItemList.elementAt(i_count));
        }
        t_ss.setSelectItemList(v_sil);
        t_ss.setObjectContext(this.context);
        return t_ss;
    }

    public SelectStatement toNetezzaSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        SelectStatement t_ss = new SelectStatement();
        t_ss.setSelectClause(this.selectClause);
        t_ss.setHintClause(this.hintClause);
        if (this.selectQualifier != null) {
            GroupByStatement gbs_gb = from_sqs.getGroupByStatement();
            HavingStatement hs = from_sqs.getHavingStatement();
            if (this.selectQualifier.equalsIgnoreCase("DISTINCT ON")) {
                if (gbs_gb != null) {
                    to_sqs.setGroupByStatement(gbs_gb.toNetezzaSelect(to_sqs, from_sqs));
                    this.addGroupByItems(to_sqs, from_sqs);
                } else {
                    to_sqs.setGroupByStatement(this.createGroupByStatement(to_sqs, from_sqs));
                }
                if (hs != null) {
                    to_sqs.setHavingStatement(hs.toNetezzaSelect(to_sqs, from_sqs));
                    this.addHavingItem(to_sqs);
                } else {
                    to_sqs.setHavingStatement(this.createHavingStatement());
                }
                this.setSelectItemList(t_ss, from_sqs, to_sqs);
            } else if (this.selectQualifier.equalsIgnoreCase("UNIQUE")) {
                t_ss.setSelectQualifier("DISTINCT");
            } else {
                t_ss.setSelectQualifier(this.selectQualifier);
            }
        }
        if (this.selectRowSpecifier != null) {
            if (this.percentSpecifier != null) {
                throw new ConvertException();
            }
            LimitClause lc = new LimitClause();
            if (from_sqs.getLimitClause() != null) {
                throw new ConvertException();
            }
            lc.setLimitClause("LIMIT");
            lc.setLimitValue("" + this.selectRowCount);
            to_sqs.setLimitClause(lc);
        }
        if (this.selectSpecialQualifier != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("/* " + this.selectSpecialQualifier + "*/");
            t_ss.setSelectSpecialQualifier(sb.toString());
        }
        if (this.selectQualifier != null && !this.selectQualifier.equalsIgnoreCase("DISTINCT ON") || this.selectQualifier == null) {
            Vector<Object> v_sil = new Vector<Object>();
            for (int i_count = 0; i_count < this.selectItemList.size(); ++i_count) {
                if (this.selectItemList.elementAt(i_count) instanceof SelectColumn) {
                    v_sil.addElement(((SelectColumn)this.selectItemList.elementAt(i_count)).toNetezzaSelect(to_sqs, from_sqs));
                    continue;
                }
                if (this.selectItemList.elementAt(i_count) instanceof WhereColumn) {
                    v_sil.addElement((WhereColumn)this.selectItemList.elementAt(i_count));
                    continue;
                }
                v_sil.addElement((String)this.selectItemList.elementAt(i_count));
            }
            t_ss.setSelectItemList(v_sil);
        }
        return t_ss;
    }

    WhereExpression createQuery(FromClause t_fc, SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereItem wi = new WhereItem();
        WhereColumn wc = new WhereColumn();
        Vector<Object> v_sc = new Vector<Object>();
        SelectQueryStatement sqs_i = new SelectQueryStatement();
        SelectStatement ss_i = new SelectStatement();
        FunctionCalls fc = new FunctionCalls();
        FromClause fcl = new FromClause();
        GroupByStatement gbs = new GroupByStatement();
        TableColumn tc = new TableColumn();
        WhereExpression we = new WhereExpression();
        v_sc.addElement("ROWID");
        wc.setColumnExpression(v_sc);
        wi.setLeftWhereExp(wc);
        wi.setOperator("IN");
        tc.setColumnName("MIN");
        fc.setFunctionName(tc);
        SelectColumn sc = new SelectColumn();
        v_sc = new Vector();
        v_sc.addElement("ROWID");
        sc.setColumnExpression(v_sc);
        v_sc = new Vector();
        v_sc.addElement(sc);
        fc.setFunctionArguments(v_sc);
        sc = new SelectColumn();
        v_sc = new Vector();
        v_sc.addElement(fc);
        sc.setColumnExpression(v_sc);
        v_sc = new Vector();
        v_sc.addElement(sc);
        ss_i.setSelectClause("select");
        ss_i.setSelectItemList(v_sc);
        fcl.setFromClause(t_fc.getFromClause());
        Vector v_fil = t_fc.getFromItemList();
        Vector<FromTable> v_nfil = new Vector<FromTable>();
        for (int i_count = 0; i_count < v_fil.size(); ++i_count) {
            FromTable fc_n = (FromTable)v_fil.elementAt(i_count);
            fc_n.setIsAS(false);
            v_nfil.addElement(fc_n);
        }
        fcl.setFromItemList(v_nfil);
        gbs.setGroupClause("group by");
        gbs.setGroupByItemList(this.distinctList);
        sqs_i.setSelectStatement(ss_i);
        sqs_i.setFromClause(fcl);
        sqs_i.setGroupByStatement(gbs);
        wi.setRightWhereSubQuery(sqs_i.toOracleSelect());
        we.addWhereItem(wi);
        return we;
    }
}

