/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.select;

import com.adventnet.swissqlapi.SwisSQLAPI;
import com.adventnet.swissqlapi.config.SwisSQLOptions;
import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.functions.misc.decode;
import com.adventnet.swissqlapi.sql.statement.CommentClass;
import com.adventnet.swissqlapi.sql.statement.SwisSQLStatement;
import com.adventnet.swissqlapi.sql.statement.create.NumericClass;
import com.adventnet.swissqlapi.sql.statement.select.CaseStatement;
import com.adventnet.swissqlapi.sql.statement.select.FetchClause;
import com.adventnet.swissqlapi.sql.statement.select.FromClause;
import com.adventnet.swissqlapi.sql.statement.select.FromTable;
import com.adventnet.swissqlapi.sql.statement.select.LimitClause;
import com.adventnet.swissqlapi.sql.statement.select.RownumClause;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.SelectStatement;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhenStatement;
import com.adventnet.swissqlapi.sql.statement.select.WhereColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereItem;
import com.adventnet.swissqlapi.util.SwisSQLUtils;
import com.adventnet.swissqlapi.util.database.MetadataInfoUtil;
import com.adventnet.swissqlapi.util.misc.CustomizeUtil;
import com.adventnet.swissqlapi.util.misc.StringFunctions;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;

public class WhereExpression {
    private String openBraces;
    private String closeBraces;
    private Vector whereItems;
    private RownumClause rownumClause;
    private Vector operators;
    private boolean topLevel = false;
    private String beginOperator;
    private boolean checkWhere;
    private String concatenation;
    private UserObjectContext context = null;
    private boolean isToOracle = false;
    private ArrayList fromTableList = null;
    private CommentClass commentObj;
    private String stmtTableName;
    private Vector functionColumnVector = new Vector();
    private Vector removedFromItemsList = null;
    private boolean selectStmtInJoin = false;
    private boolean fromDeleteQueryStatement = false;
    private boolean thetaJoinPresent = false;
    private boolean is_Case_Expression = false;
    private int targetDatabase;

    public WhereExpression() {
        this.openBraces = new String("");
        this.closeBraces = new String("");
        this.whereItems = new Vector();
        this.operators = new Vector();
    }

    public Vector getFunctionColumnVector() {
        return this.functionColumnVector;
    }

    public void setObjectContext(UserObjectContext context) {
        this.context = context;
    }

    public void addWhereItem(WhereItem wi) {
        wi.setObjectContext(this.context);
        this.whereItems.addElement(wi);
    }

    public void setFromTableList(ArrayList fromTableList) {
        this.fromTableList = fromTableList;
    }

    public void setStmtTableName(String stmtTableName) {
        this.stmtTableName = stmtTableName;
    }

    public void addWhereExpression(WhereExpression we) {
        this.whereItems.addElement(we);
    }

    public void addOperator(String opr) {
        this.operators.addElement(opr);
    }

    public void addOpenBrace(String s) {
        this.openBraces = this.openBraces + s;
    }

    public void addCloseBrace(String s) {
        this.closeBraces = this.closeBraces + s;
    }

    public void removeBrace() {
        if (this.openBraces != null && this.openBraces.length() > 0) {
            this.openBraces = this.openBraces.substring(1);
            if (this.closeBraces != null && this.closeBraces.length() > 0) {
                this.closeBraces = this.closeBraces.substring(1);
            }
        }
    }

    public boolean removeOperator() {
        if (this.operators.size() != 0) {
            this.operators.removeElementAt(this.operators.size() - 1);
            return true;
        }
        return false;
    }

    public void setTopLevel(boolean b) {
        this.topLevel = b;
    }

    public void setBeginOperator(String begin) {
        this.beginOperator = begin;
    }

    public void setWhereItem(Vector wi) {
        if (wi != null) {
            for (int i = 0; i < wi.size(); ++i) {
                if (!(wi.get(i) instanceof WhereItem)) continue;
                ((WhereItem)wi.get(i)).setObjectContext(this.context);
            }
        }
        this.whereItems = wi;
    }

    public void setOperator(Vector opr) {
        this.operators = opr;
    }

    public void setOpenBrace(String s_ob) {
        this.openBraces = s_ob;
    }

    public void setCloseBrace(String s_cb) {
        this.closeBraces = s_cb;
    }

    public void setCheckWhere(boolean b_cw) {
        this.checkWhere = b_cw;
    }

    public void setConcatenation(String concatenation) {
        this.concatenation = concatenation;
    }

    public void setRownumClause(RownumClause rc) {
        this.rownumClause = rc;
    }

    public void setToOracle(boolean isToOracle) {
        this.isToOracle = isToOracle;
    }

    public void setCommentClass(CommentClass commentObj) {
        this.commentObj = commentObj;
    }

    public void setCaseExpressionBool(boolean boolVal) {
        this.is_Case_Expression = boolVal;
    }

    public void setTargetDatabase(int targetDatabase) {
        this.targetDatabase = targetDatabase;
    }

    public CommentClass getCommentClass() {
        return this.commentObj;
    }

    public String getConcatenation() {
        return this.concatenation;
    }

    public RownumClause getRownumClause() {
        return this.rownumClause;
    }

    public String getBeginOperator() {
        return this.beginOperator;
    }

    public Vector getWhereItems() {
        return this.whereItems;
    }

    public Vector getWhereItem() {
        return this.whereItems;
    }

    public Vector getOperator() {
        return this.operators;
    }

    public String getOpenBrace() {
        return this.openBraces;
    }

    public String getCloseBrace() {
        return this.closeBraces;
    }

    public boolean getCheckWhere() {
        return this.checkWhere;
    }

    public boolean getTopLevel() {
        return this.topLevel;
    }

    public void setFromDeleteQueryStatement(boolean b) {
        this.fromDeleteQueryStatement = b;
    }

    public boolean isThetaJoinPresent() {
        return this.thetaJoinPresent;
    }

    public void setThetaJoinPresent(boolean val) {
        this.thetaJoinPresent = true;
    }

    public boolean isCaseExpression() {
        return this.is_Case_Expression;
    }

    public int getTargetDatabase() {
        return this.targetDatabase;
    }

    public String toString() {
        String returnString;
        StringBuffer sb = new StringBuffer();
        if (this.beginOperator != null) {
            sb.append(this.beginOperator + " ");
        }
        if (this.openBraces != null && !this.openBraces.equals("")) {
            sb.append(this.openBraces);
        }
        for (int i = 0; i < this.whereItems.size(); ++i) {
            String whereItemString = null;
            if (this.whereItems.elementAt(i) != null) {
                if (this.whereItems.elementAt(i) instanceof WhereItem) {
                    ((WhereItem)this.whereItems.elementAt(i)).setObjectContext(this.context);
                } else if (this.whereItems.elementAt(i) instanceof WhereExpression) {
                    ((WhereExpression)this.whereItems.elementAt(i)).setObjectContext(this.context);
                }
                whereItemString = this.whereItems.elementAt(i).toString();
                if (whereItemString != null) {
                    sb.append(whereItemString);
                }
            }
            if (i == this.operators.size() && this.whereItems.elementAt(i) instanceof WhereExpression && whereItemString == null) {
                String s = sb.toString().trim();
                if (s.endsWith("OR")) {
                    s = s.substring(0, s.length() - 2);
                } else if (s.endsWith("AND")) {
                    s = s.substring(0, s.length() - 3);
                }
                sb = new StringBuffer(s);
            }
            if (i < this.operators.size() && this.operators.elementAt(i).toString().equalsIgnoreCase("&AND") || i >= this.operators.size() || this.operators.elementAt(i).toString().equalsIgnoreCase("ANSIAND") || this.operators.elementAt(i).toString().equalsIgnoreCase("ANSIOR")) continue;
            if (!(this.whereItems.elementAt(i) instanceof WhereExpression) || whereItemString != null) {
                sb.append("\n");
                for (int j = 0; j < SelectQueryStatement.beautyTabCount; ++j) {
                    sb.append("\t");
                }
                sb.append(" " + this.operators.elementAt(i).toString().toUpperCase() + "\t");
                continue;
            }
            if (whereItemString != null || this.isToOracle) continue;
            sb.append("\n");
            for (int j = 0; j < SelectQueryStatement.beautyTabCount; ++j) {
                sb.append("\t");
            }
            sb.append(" " + this.operators.elementAt(i).toString().toUpperCase() + "\t");
        }
        if (this.closeBraces != null && !this.closeBraces.equals("")) {
            sb.append(this.closeBraces);
        }
        if ((returnString = sb.toString()).equals("()")) {
            return null;
        }
        return returnString;
    }

    public void removeJoinConditionsFromWhereExpression(WhereExpression whereExp, SelectQueryStatement from_sqs) {
        if (!this.fromDeleteQueryStatement) {
            Vector whereItemsList = whereExp.getWhereItems();
            Vector tempOperators = whereExp.getOperator();
            for (int i = 0; i < whereItemsList.size(); ++i) {
                WhereItem wi;
                Object obj = whereItemsList.get(i);
                if (obj == null || !(obj instanceof WhereItem) || (wi = (WhereItem)obj).getOperator() == null || !wi.getOperator().trim().equals("=")) continue;
                FromTable ft1 = new FromTable();
                FromTable ft2 = new FromTable();
                WhereColumn wcl = wi.getLeftWhereExp();
                WhereColumn wcr = wi.getRightWhereExp();
                Vector leftColumnExp = wcl.getColumnExpression();
                Vector rightColumnExp = wcr.getColumnExpression();
                if (leftColumnExp == null || rightColumnExp == null || leftColumnExp.size() != 1 || rightColumnExp.size() != 1 || !(leftColumnExp.get(0) instanceof TableColumn) || !(rightColumnExp.get(0) instanceof TableColumn)) continue;
                TableColumn tc1 = (TableColumn)leftColumnExp.get(0);
                TableColumn tc2 = (TableColumn)rightColumnExp.get(0);
                ft1 = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)from_sqs, tc1);
                ft2 = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)from_sqs, tc2);
                String s1 = tc1.getColumnName().trim();
                String s2 = tc2.getColumnName().trim();
                if (s1.startsWith("'") || s2.startsWith("'") || s1.startsWith("\"") || s2.startsWith("\"") || ft1 == null || ft2 == null) continue;
                whereItemsList.set(i, null);
                if (i != 0) {
                    String op = (String)whereExp.getOperator().get(i - 1);
                    if (!op.equals("&AND")) {
                        whereExp.getOperator().setElementAt("&AND", i - 1);
                        continue;
                    }
                    if (whereExp.getOperator().size() <= i) continue;
                    whereExp.getOperator().setElementAt("&AND", i);
                    continue;
                }
                if (whereExp.getOperator().size() <= i) continue;
                whereExp.getOperator().setElementAt("&AND", i);
            }
            for (int k = 0; k < whereItemsList.size(); ++k) {
                if (whereItemsList.indexOf(null) == -1) continue;
                whereItemsList.remove(null);
                if (k < whereItemsList.size() - 1) continue;
                --k;
            }
            for (int l = 0; l < tempOperators.size(); ++l) {
                String s = (String)tempOperators.get(l);
                if (!s.trim().equalsIgnoreCase("&AND")) continue;
                tempOperators.remove(l);
                --l;
            }
            if (whereItemsList.size() == 1) {
                tempOperators.removeAllElements();
            }
        }
    }

    public Vector getJoinConditionsFromWhereExpression(WhereExpression whereExp, SelectQueryStatement from_sqs) {
        Vector joinConditions = new Vector();
        if (!this.fromDeleteQueryStatement) {
            Vector nonNullwhereItemsList = new Vector();
            for (int wi = 0; wi < whereExp.getWhereItems().size(); ++wi) {
                Object obj = whereExp.getWhereItems().get(wi);
                if (obj instanceof WhereItem) {
                    if (obj == null) continue;
                    nonNullwhereItemsList.add(obj);
                    continue;
                }
                if (!(obj instanceof WhereExpression) || obj.toString() == null || ((WhereExpression)obj).getWhereItem() == null || ((WhereExpression)obj).getWhereItem().size() <= 0) continue;
                boolean nonNullWhereItemPresent = false;
                WhereExpression wexpObj = (WhereExpression)obj;
                for (int wwi = 0; wwi < wexpObj.getWhereItem().size(); ++wwi) {
                    if (wexpObj.getWhereItem().get(wwi) == null) continue;
                    nonNullWhereItemPresent = true;
                }
                if (!nonNullWhereItemPresent) continue;
                nonNullwhereItemsList.add(obj);
            }
            Vector<String> nonNullOperators = new Vector<String>();
            for (int oi = 0; oi < whereExp.getOperator().size(); ++oi) {
                String obj = whereExp.getOperator().get(oi).toString();
                if (obj.equalsIgnoreCase("&AND")) continue;
                nonNullOperators.add(obj);
            }
            for (int i = 0; i < nonNullwhereItemsList.size(); ++i) {
                Object obj = nonNullwhereItemsList.get(i);
                if (obj != null && obj instanceof WhereItem) {
                    WhereItem wi = (WhereItem)obj;
                    if (wi.getOperator() == null || !wi.getOperator().trim().equals("=")) continue;
                    String sa = this.getTableAliasWhereL(wi);
                    String sb = this.getTableAliasWhereR(wi);
                    if (sa == null || sb == null) {
                        WhereColumn wcl = wi.getLeftWhereExp();
                        WhereColumn wcr = wi.getRightWhereExp();
                        FromTable ft1 = new FromTable();
                        FromTable ft2 = new FromTable();
                        Vector leftColumnExp = wcl.getColumnExpression();
                        Vector rightColumnExp = wcr.getColumnExpression();
                        if (leftColumnExp != null && rightColumnExp != null && leftColumnExp.size() == 1 && rightColumnExp.size() == 1 && leftColumnExp.get(0) instanceof TableColumn && rightColumnExp.get(0) instanceof TableColumn) {
                            TableColumn tc1 = (TableColumn)leftColumnExp.get(0);
                            TableColumn tc2 = (TableColumn)rightColumnExp.get(0);
                            ft1 = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)from_sqs, tc1);
                            ft2 = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)from_sqs, tc2);
                            String s1 = tc1.getColumnName().trim();
                            String s2 = tc2.getColumnName().trim();
                            if (!s1.startsWith("'") && !s2.startsWith("'") && (ft1 != null && ft2 != null || tc1.getTableName() != null && tc2.getTableName() != null)) {
                                sa = tc1.getTableName();
                                sb = tc2.getTableName();
                            }
                        }
                    }
                    if (sa == null || sb == null || sb.equalsIgnoreCase("") || sa.equalsIgnoreCase(sb)) continue;
                    String opOuter = "";
                    if (i != 0) {
                        opOuter = (String)whereExp.getOperator().get(i - 1);
                    }
                    if (opOuter.equalsIgnoreCase("OR")) continue;
                    joinConditions.add(obj);
                    nonNullwhereItemsList.set(i, null);
                    if (i != 0) {
                        String op = (String)nonNullOperators.get(i - 1);
                        if (op.equalsIgnoreCase("OR")) continue;
                        if (!op.equals("&AND")) {
                            nonNullOperators.setElementAt("&AND", i - 1);
                            continue;
                        }
                        if (nonNullOperators.size() <= i) continue;
                        nonNullOperators.setElementAt("&AND", i - 1);
                        continue;
                    }
                    if (nonNullOperators.size() <= i) continue;
                    nonNullOperators.setElementAt("&AND", i);
                    continue;
                }
                if (obj == null || !(obj instanceof WhereExpression)) continue;
                WhereExpression we = (WhereExpression)obj;
                if (we.getOperator().size() == 0) {
                    Vector localWI = this.getJoinConditionsFromWhereExpression(we, from_sqs);
                    if (localWI.size() > 0) {
                        if (i != 0) {
                            String op = (String)nonNullOperators.get(i - 1);
                            if (!op.equalsIgnoreCase("OR")) {
                                if (!op.equals("&AND")) {
                                    nonNullOperators.setElementAt("&AND", i - 1);
                                } else if (nonNullOperators.size() > i) {
                                    nonNullOperators.setElementAt("&AND", i - 1);
                                }
                            }
                        } else if (nonNullOperators.size() > i) {
                            nonNullOperators.setElementAt("&AND", i);
                        }
                    }
                    joinConditions.addAll(localWI);
                    continue;
                }
                if (we.getOperator().contains("OR") || we.getOperator().contains("or")) continue;
                joinConditions.addAll(this.getJoinConditionsFromGroupedWhereExpression(we, from_sqs));
            }
            Vector newWhereItemsList = new Vector();
            for (int k = 0; k < nonNullwhereItemsList.size(); ++k) {
                Object obj = nonNullwhereItemsList.get(k);
                if (obj instanceof WhereItem) {
                    if (obj == null) continue;
                    newWhereItemsList.add(nonNullwhereItemsList.get(k));
                    continue;
                }
                if (!(obj instanceof WhereExpression) || ((WhereExpression)obj).getWhereItem() == null || ((WhereExpression)obj).getWhereItem().size() <= 0) continue;
                boolean nonNullWhereItemPresent = false;
                WhereExpression wexpObj = (WhereExpression)obj;
                for (int wi = 0; wi < wexpObj.getWhereItem().size(); ++wi) {
                    if (wexpObj.getWhereItem().get(wi) == null) continue;
                    nonNullWhereItemPresent = true;
                }
                if (!nonNullWhereItemPresent) continue;
                newWhereItemsList.add(nonNullwhereItemsList.get(k));
            }
            Vector<String> newOperatorsList = new Vector<String>();
            for (int l = 0; l < nonNullOperators.size(); ++l) {
                String s = (String)nonNullOperators.get(l);
                if (s.trim().equalsIgnoreCase("&AND")) continue;
                newOperatorsList.add(s);
            }
            Vector finalOperatorsList = new Vector();
            if (newOperatorsList.size() > 0) {
                for (int fi = 0; fi < newWhereItemsList.size() - 1; ++fi) {
                    finalOperatorsList.add(newOperatorsList.get(fi));
                }
            }
            if (newWhereItemsList.size() == 1) {
                finalOperatorsList.removeAllElements();
            }
            whereExp.setWhereItem(newWhereItemsList);
            whereExp.setOperator(finalOperatorsList);
        }
        return joinConditions;
    }

    public Vector getJoinConditionsFromGroupedWhereExpression(WhereExpression whereExp, SelectQueryStatement from_sqs) {
        Vector joinConditions = new Vector();
        if (!this.fromDeleteQueryStatement) {
            Vector nonNullwhereItemsList = new Vector();
            for (int wi = 0; wi < whereExp.getWhereItems().size(); ++wi) {
                Object obj = whereExp.getWhereItems().get(wi);
                if (obj instanceof WhereItem) {
                    if (obj == null) continue;
                    nonNullwhereItemsList.add(obj);
                    continue;
                }
                if (!(obj instanceof WhereExpression) || obj.toString() == null || ((WhereExpression)obj).getWhereItem() == null || ((WhereExpression)obj).getWhereItem().size() <= 0) continue;
                boolean nonNullWhereItemPresent = false;
                WhereExpression wexpObj = (WhereExpression)obj;
                for (int wwi = 0; wwi < wexpObj.getWhereItem().size(); ++wwi) {
                    if (wexpObj.getWhereItem().get(wwi) == null) continue;
                    nonNullWhereItemPresent = true;
                }
                if (!nonNullWhereItemPresent) continue;
                nonNullwhereItemsList.add(obj);
            }
            Vector<String> nonNullOperators = new Vector<String>();
            for (int oi = 0; oi < whereExp.getOperator().size(); ++oi) {
                String obj = whereExp.getOperator().get(oi).toString();
                if (obj.equalsIgnoreCase("&AND")) continue;
                nonNullOperators.add(obj);
            }
            for (int i = 0; i < nonNullwhereItemsList.size(); ++i) {
                Object obj = nonNullwhereItemsList.get(i);
                if (obj != null && obj instanceof WhereItem) {
                    WhereItem wi = (WhereItem)obj;
                    if (wi.getOperator() == null || !wi.getOperator().trim().equals("=")) continue;
                    String sa = this.getTableAliasWhereL(wi);
                    String sb = this.getTableAliasWhereR(wi);
                    if (sa == null || sb == null) {
                        WhereColumn wcl = wi.getLeftWhereExp();
                        WhereColumn wcr = wi.getRightWhereExp();
                        FromTable ft1 = new FromTable();
                        FromTable ft2 = new FromTable();
                        Vector leftColumnExp = wcl.getColumnExpression();
                        Vector rightColumnExp = wcr.getColumnExpression();
                        if (leftColumnExp != null && rightColumnExp != null && leftColumnExp.size() == 1 && rightColumnExp.size() == 1 && leftColumnExp.get(0) instanceof TableColumn && rightColumnExp.get(0) instanceof TableColumn) {
                            TableColumn tc1 = (TableColumn)leftColumnExp.get(0);
                            TableColumn tc2 = (TableColumn)rightColumnExp.get(0);
                            ft1 = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)from_sqs, tc1);
                            ft2 = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)from_sqs, tc2);
                            String s1 = tc1.getColumnName().trim();
                            String s2 = tc2.getColumnName().trim();
                            if (!s1.startsWith("'") && !s2.startsWith("'") && (ft1 != null && ft2 != null || tc1.getTableName() != null && tc2.getTableName() != null)) {
                                sa = tc1.getTableName();
                                sb = tc2.getTableName();
                            }
                        }
                    }
                    if (sa == null || sb == null || sb.equalsIgnoreCase("") || sa.equalsIgnoreCase(sb)) continue;
                    String opOuter = "";
                    if (i != 0) {
                        opOuter = (String)nonNullOperators.get(i - 1);
                    }
                    if (opOuter.equalsIgnoreCase("OR")) continue;
                    joinConditions.add(obj);
                    nonNullwhereItemsList.set(i, null);
                    if (i != 0) {
                        String op = (String)nonNullOperators.get(i - 1);
                        if (op.equalsIgnoreCase("OR")) continue;
                        if (!op.equals("&AND")) {
                            nonNullOperators.setElementAt("&AND", i - 1);
                            continue;
                        }
                        if (nonNullOperators.size() <= i) continue;
                        nonNullOperators.setElementAt("&AND", i - 1);
                        continue;
                    }
                    if (nonNullOperators.size() <= i) continue;
                    nonNullOperators.setElementAt("&AND", i);
                    continue;
                }
                if (obj == null || !(obj instanceof WhereExpression)) continue;
                WhereExpression we = (WhereExpression)obj;
                Vector localWI = this.getJoinConditionsFromWhereExpression(we, from_sqs);
                if (localWI.size() > 0 && !we.hasNonNullWhereItem()) {
                    if (i != 0) {
                        String op = (String)nonNullOperators.get(i - 1);
                        if (!op.equalsIgnoreCase("OR")) {
                            if (!op.equals("&AND")) {
                                nonNullOperators.setElementAt("&AND", i - 1);
                            } else if (nonNullOperators.size() > i) {
                                nonNullOperators.setElementAt("&AND", i - 1);
                            }
                        }
                    } else if (nonNullOperators.size() > i) {
                        nonNullOperators.setElementAt("&AND", i);
                    }
                }
                joinConditions.addAll(localWI);
            }
            Vector newWhereItemsList = new Vector();
            for (int k = 0; k < nonNullwhereItemsList.size(); ++k) {
                Object obj = nonNullwhereItemsList.get(k);
                if (obj instanceof WhereItem) {
                    if (obj == null) continue;
                    newWhereItemsList.add(nonNullwhereItemsList.get(k));
                    continue;
                }
                if (!(obj instanceof WhereExpression) || ((WhereExpression)obj).getWhereItem() == null || ((WhereExpression)obj).getWhereItem().size() <= 0) continue;
                boolean nonNullWhereItemPresent = false;
                WhereExpression wexpObj = (WhereExpression)obj;
                for (int wi = 0; wi < wexpObj.getWhereItem().size(); ++wi) {
                    if (wexpObj.getWhereItem().get(wi) == null) continue;
                    nonNullWhereItemPresent = true;
                }
                if (!nonNullWhereItemPresent) continue;
                newWhereItemsList.add(nonNullwhereItemsList.get(k));
            }
            Vector<String> newOperatorsList = new Vector<String>();
            for (int l = 0; l < nonNullOperators.size(); ++l) {
                String s = (String)nonNullOperators.get(l);
                if (s.trim().equalsIgnoreCase("&AND")) continue;
                newOperatorsList.add(s);
            }
            Vector finalOperatorsList = new Vector();
            if (newOperatorsList.size() > 0) {
                for (int fi = 0; fi < newWhereItemsList.size() - 1; ++fi) {
                    finalOperatorsList.add(newOperatorsList.get(fi));
                }
            }
            if (newWhereItemsList.size() == 1) {
                finalOperatorsList.removeAllElements();
            }
            whereExp.setWhereItem(newWhereItemsList);
            whereExp.setOperator(finalOperatorsList);
        }
        return joinConditions;
    }

    public boolean hasNonNullWhereItem() {
        boolean nonNullWhereItem = false;
        Vector nonNullwhereItemsList = this.getWhereItems();
        block0: for (int k = 0; k < nonNullwhereItemsList.size(); ++k) {
            Object obj = nonNullwhereItemsList.get(k);
            if (obj instanceof WhereItem) {
                if (obj == null) continue;
                nonNullWhereItem = true;
                break;
            }
            if (!(obj instanceof WhereExpression) || ((WhereExpression)obj).getWhereItem() == null || ((WhereExpression)obj).getWhereItem().size() <= 0) continue;
            WhereExpression wexpObj = (WhereExpression)obj;
            for (int wi = 0; wi < wexpObj.getWhereItem().size(); ++wi) {
                if (wexpObj.getWhereItem().get(wi) == null) continue;
                nonNullWhereItem = true;
                continue block0;
            }
        }
        return nonNullWhereItem;
    }

    public WhereExpression toMySQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        int i;
        if (this.rownumClause != null && to_sqs != null) {
            this.addLimitClause(to_sqs, from_sqs);
        }
        WhereExpression we = new WhereExpression();
        we.setOpenBrace(this.openBraces);
        we.setCloseBrace(this.closeBraces);
        this.setTargetDatabase(5);
        if (this.beginOperator != null) {
            we.setBeginOperator(this.beginOperator);
        }
        if (this.operators != null) {
            Vector<String> newOperators = new Vector<String>();
            for (i = 0; i < this.operators.size(); ++i) {
                String op = (String)this.operators.elementAt(i);
                newOperators.addElement(op);
            }
            we.setOperator(newOperators);
        }
        Vector<Object> whereItemList = new Vector<Object>();
        for (i = 0; i < this.whereItems.size(); ++i) {
            String op;
            if (this.whereItems.elementAt(i) instanceof WhereItem) {
                WhereItem wi;
                if (this.whereItems.elementAt(i) == null) {
                    whereItemList.addElement(null);
                }
                if ((wi = (WhereItem)this.whereItems.elementAt(i)).getLeftJoin() == null && wi.getRightJoin() == null) {
                    if (this.isWhereItemEqualsClauseIsMultipleAndNotSubquery(wi)) {
                        Vector whereItemsListReplacingEqualsClause = wi.getWhereItemsReplacingEqualsClause();
                        for (int j = 0; j < whereItemsListReplacingEqualsClause.size(); ++j) {
                            whereItemList.addElement(((WhereItem)whereItemsListReplacingEqualsClause.get(j)).toMySQLSelect(to_sqs, from_sqs));
                            if (j == whereItemsListReplacingEqualsClause.size() - 1) continue;
                            if (wi.getOperator2().equalsIgnoreCase("ALL")) {
                                we.getOperator().add("AND");
                                continue;
                            }
                            we.getOperator().add("OR");
                        }
                    } else {
                        whereItemList.addElement(wi.toMySQLSelect(to_sqs, from_sqs));
                    }
                    if (wi.getRownumClause() == null) continue;
                    if (i != 0) {
                        op = (String)we.getOperator().get(i - 1);
                        if (!op.equals("&AND")) {
                            we.getOperator().setElementAt("&AND", i - 1);
                            continue;
                        }
                        if (we.getOperator().size() <= i) continue;
                        we.getOperator().setElementAt("&AND", i);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                whereItemList.addElement(null);
                if (i != 0) {
                    op = (String)we.getOperator().get(i - 1);
                    if (!op.equals("&AND")) {
                        we.getOperator().setElementAt("&AND", i - 1);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
                continue;
            }
            if (!(this.whereItems.elementAt(i) instanceof WhereExpression)) continue;
            WhereExpression internalWE = ((WhereExpression)this.whereItems.elementAt(i)).toMySQLSelect(to_sqs, from_sqs);
            whereItemList.addElement(internalWE);
            if (internalWE.toString() != null) continue;
            if (i != 0) {
                op = (String)we.getOperator().get(i - 1);
                if (!op.equals("&AND")) {
                    we.getOperator().setElementAt("&AND", i - 1);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
                continue;
            }
            if (we.getOperator().size() <= i) continue;
            we.getOperator().setElementAt("&AND", i);
        }
        we.setWhereItem(whereItemList);
        we.setCheckWhere(this.checkWhere);
        we.setRownumClause(this.rownumClause);
        if (this.topLevel) {
            this.setNewFromClauseWithANSIJoin(to_sqs, from_sqs, 5, we);
        }
        return we;
    }

    public WhereExpression toDB2Select(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        int i;
        if (this.rownumClause != null) {
            this.addFetchClause(to_sqs, from_sqs);
        }
        WhereExpression we = new WhereExpression();
        we.setOpenBrace(this.openBraces);
        we.setCloseBrace(this.closeBraces);
        this.setTargetDatabase(3);
        if (this.beginOperator != null) {
            we.setBeginOperator(this.beginOperator);
        }
        if (this.operators != null) {
            Vector<String> newOperators = new Vector<String>();
            for (i = 0; i < this.operators.size(); ++i) {
                String op = (String)this.operators.elementAt(i);
                newOperators.addElement(op);
            }
            we.setOperator(newOperators);
        }
        Vector<Object> whereItemList = new Vector<Object>();
        for (i = 0; i < this.whereItems.size(); ++i) {
            String op;
            if (this.whereItems.elementAt(i) == null) {
                whereItemList.addElement(null);
            }
            if (this.whereItems.elementAt(i) instanceof WhereItem) {
                WhereItem wi = (WhereItem)this.whereItems.elementAt(i);
                wi.setFromTableList(this.fromTableList);
                wi.setStmtTableName(this.stmtTableName);
                if (wi.getLeftJoin() == null && wi.getRightJoin() == null) {
                    if (this.isWhereItemEqualsClauseIsMultipleAndNotSubquery(wi)) {
                        Vector whereItemsListReplacingEqualsClause = wi.getWhereItemsReplacingEqualsClause();
                        for (int j = 0; j < whereItemsListReplacingEqualsClause.size(); ++j) {
                            whereItemList.addElement(((WhereItem)whereItemsListReplacingEqualsClause.get(j)).toDB2Select(to_sqs, from_sqs));
                            if (j == whereItemsListReplacingEqualsClause.size() - 1) continue;
                            if (wi.getOperator2().equalsIgnoreCase("ALL")) {
                                we.getOperator().add("AND");
                                continue;
                            }
                            we.getOperator().add("OR");
                        }
                    } else {
                        whereItemList.addElement(wi.toDB2Select(to_sqs, from_sqs));
                    }
                    if (wi.getRownumClause() == null) continue;
                    if (i != 0) {
                        op = (String)we.getOperator().get(i - 1);
                        if (!op.equals("&AND")) {
                            we.getOperator().setElementAt("&AND", i - 1);
                            continue;
                        }
                        if (we.getOperator().size() <= i) continue;
                        we.getOperator().setElementAt("&AND", i);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                whereItemList.addElement(null);
                if (i != 0) {
                    op = (String)we.getOperator().get(i - 1);
                    if (!op.equals("&AND")) {
                        we.getOperator().setElementAt("&AND", i - 1);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
                continue;
            }
            if (!(this.whereItems.elementAt(i) instanceof WhereExpression)) continue;
            WhereExpression internalWE = ((WhereExpression)this.whereItems.elementAt(i)).toDB2Select(to_sqs, from_sqs);
            whereItemList.addElement(internalWE);
            if (internalWE.toString() != null) continue;
            if (i != 0) {
                op = (String)we.getOperator().get(i - 1);
                if (!op.equals("&AND")) {
                    we.getOperator().setElementAt("&AND", i - 1);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
                continue;
            }
            if (we.getOperator().size() <= i) continue;
            we.getOperator().setElementAt("&AND", i);
        }
        we.setWhereItem(whereItemList);
        we.setCheckWhere(this.checkWhere);
        we.setRownumClause(this.rownumClause);
        if (this.topLevel) {
            this.setNewFromClauseWithANSIJoin(to_sqs, from_sqs, 3, we);
        }
        return we;
    }

    public WhereExpression toPostgreSQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        int i;
        if (this.rownumClause != null && to_sqs != null) {
            this.addLimitClause(to_sqs, from_sqs);
        }
        WhereExpression we = new WhereExpression();
        we.setOpenBrace(this.openBraces);
        we.setCloseBrace(this.closeBraces);
        this.setTargetDatabase(4);
        if (this.beginOperator != null) {
            we.setBeginOperator(this.beginOperator);
        }
        if (this.operators != null) {
            Vector<String> newOperators = new Vector<String>();
            for (i = 0; i < this.operators.size(); ++i) {
                String op = (String)this.operators.elementAt(i);
                newOperators.addElement(op);
            }
            we.setOperator(newOperators);
        }
        Vector<Object> whereItemList = new Vector<Object>();
        for (i = 0; i < this.whereItems.size(); ++i) {
            String op;
            if (this.whereItems.elementAt(i) == null) {
                whereItemList.addElement(null);
            }
            if (this.whereItems.elementAt(i) instanceof WhereItem) {
                WhereItem wi = (WhereItem)this.whereItems.elementAt(i);
                if (wi.getLeftJoin() == null && wi.getRightJoin() == null) {
                    int j;
                    if (this.isWhereItemInClauseIsMultipleAndNotSubquery(wi)) {
                        Vector whereItemsListReplacingInClause = wi.getWhereItemsReplacingInClause();
                        for (j = 0; j < whereItemsListReplacingInClause.size(); ++j) {
                            whereItemList.addElement(((WhereItem)whereItemsListReplacingInClause.get(j)).toPostgreSQLSelect(to_sqs, from_sqs));
                            if (j == whereItemsListReplacingInClause.size() - 1) continue;
                            we.getOperator().add("AND");
                        }
                    } else if (this.isWhereItemEqualsClauseIsMultipleAndNotSubquery(wi)) {
                        Vector whereItemsListReplacingEqualsClause = wi.getWhereItemsReplacingEqualsClause();
                        for (j = 0; j < whereItemsListReplacingEqualsClause.size(); ++j) {
                            whereItemList.addElement(((WhereItem)whereItemsListReplacingEqualsClause.get(j)).toPostgreSQLSelect(to_sqs, from_sqs));
                            if (j == whereItemsListReplacingEqualsClause.size() - 1) continue;
                            if (wi.getOperator2().equalsIgnoreCase("ALL")) {
                                we.getOperator().add("AND");
                                continue;
                            }
                            we.getOperator().add("OR");
                        }
                    } else {
                        whereItemList.addElement(wi.toPostgreSQLSelect(to_sqs, from_sqs));
                    }
                    if (wi.getRownumClause() == null) continue;
                    if (i != 0) {
                        op = (String)we.getOperator().get(i - 1);
                        if (!op.equals("&AND")) {
                            we.getOperator().setElementAt("&AND", i - 1);
                            continue;
                        }
                        if (we.getOperator().size() <= i) continue;
                        we.getOperator().setElementAt("&AND", i);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                whereItemList.addElement(null);
                if (i != 0) {
                    op = (String)we.getOperator().get(i - 1);
                    if (!op.equals("&AND")) {
                        we.getOperator().setElementAt("&AND", i - 1);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
                continue;
            }
            if (!(this.whereItems.elementAt(i) instanceof WhereExpression)) continue;
            WhereExpression internalWE = ((WhereExpression)this.whereItems.elementAt(i)).toPostgreSQLSelect(to_sqs, from_sqs);
            whereItemList.addElement(internalWE);
            if (internalWE.toString() != null) continue;
            if (i != 0) {
                op = (String)we.getOperator().get(i - 1);
                if (!op.equals("&AND")) {
                    we.getOperator().setElementAt("&AND", i - 1);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
                continue;
            }
            if (we.getOperator().size() <= i) continue;
            we.getOperator().setElementAt("&AND", i);
        }
        we.setWhereItem(whereItemList);
        we.setCheckWhere(this.checkWhere);
        we.setRownumClause(this.rownumClause);
        if (this.topLevel) {
            this.setNewFromClauseWithANSIJoin(to_sqs, from_sqs, 4, we);
        }
        return we;
    }

    public WhereExpression toMSSQLServerSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.setTargetDatabase(2);
        if (this.rownumClause != null && to_sqs != null) {
            String rownumValue = "0";
            if (to_sqs.getSelectStatement().getSelectRowSpecifier() != null) {
                throw new ConvertException();
            }
            if (this.rownumClause.getRownumValue() instanceof SelectQueryStatement) {
                throw new ConvertException("Conversion failure.. Subquery can't be converted");
            }
            if (this.rownumClause.getRownumValue() instanceof SelectColumn) {
                SelectColumn sc = (SelectColumn)this.rownumClause.getRownumValue();
                Vector colExp = sc.getColumnExpression();
                for (int i = 0; i < colExp.size(); ++i) {
                    if (colExp.elementAt(i) instanceof FunctionCalls) {
                        throw new ConvertException("Conversion failure.. Function calls can't be converted");
                    }
                    if (colExp.elementAt(i) instanceof TableColumn) {
                        if (this.rownumClause.getOperator().equals("<=") || this.rownumClause.getOperator().equals("=")) {
                            to_sqs.getSelectStatement().setSelectRowCountVariable(((TableColumn)colExp.elementAt(i)).toString());
                            continue;
                        }
                        to_sqs.getSelectStatement().setSelectRowCountVariable(((TableColumn)colExp.elementAt(i)).toString() + " - 1");
                        continue;
                    }
                    if (colExp.elementAt(i) instanceof String && colExp.size() == 1) {
                        rownumValue = (String)colExp.elementAt(i);
                        continue;
                    }
                    throw new ConvertException("Conversion failure.. Expression can't be converted");
                }
            }
            to_sqs.getSelectStatement().setSelectRowSpecifier("TOP");
            if (this.rownumClause.getOperator().equals("<=") || this.rownumClause.getOperator().equals("=")) {
                to_sqs.getSelectStatement().setSelectRowCount(Integer.parseInt(rownumValue));
            } else {
                to_sqs.getSelectStatement().setSelectRowCount(Integer.parseInt(rownumValue) - 1);
            }
        }
        WhereExpression we = new WhereExpression();
        we.setOpenBrace(this.openBraces);
        we.setCloseBrace(this.closeBraces);
        we.setConcatenation(this.concatenation);
        we.setCommentClass(this.commentObj);
        if (this.beginOperator != null) {
            we.setBeginOperator(this.beginOperator);
        }
        if (this.operators != null) {
            Vector<String> newOperators = new Vector<String>();
            for (int i = 0; i < this.operators.size(); ++i) {
                String op = (String)this.operators.elementAt(i);
                newOperators.addElement(op);
            }
            we.setOperator(newOperators);
        }
        Vector<Object> whereItemList = new Vector<Object>();
        for (int i = 0; i < this.whereItems.size(); ++i) {
            String op;
            if (this.whereItems.elementAt(i) == null) {
                whereItemList.addElement(null);
            }
            if (this.whereItems.elementAt(i) instanceof WhereItem) {
                WhereItem wi = (WhereItem)this.whereItems.elementAt(i);
                if (wi.getLeftJoin() == null && wi.getRightJoin() == null) {
                    if (this.isWhereItemInClauseIsMultipleAndNotSubquery(wi)) {
                        Vector whereItemsListReplacingInClause = wi.getWhereItemsReplacingInClause();
                        for (int j = 0; j < whereItemsListReplacingInClause.size(); ++j) {
                            whereItemList.addElement(((WhereItem)whereItemsListReplacingInClause.get(j)).toMSSQLServerSelect(to_sqs, from_sqs));
                            if (j == whereItemsListReplacingInClause.size() - 1) continue;
                            we.getOperator().add("AND");
                        }
                    } else if (this.isWhereItemEqualsClauseIsMultipleAndNotSubquery(wi)) {
                        Vector whereItemsListReplacingEqualsClause = wi.getWhereItemsReplacingEqualsClause();
                        for (int j = 0; j < whereItemsListReplacingEqualsClause.size(); ++j) {
                            whereItemList.addElement(((WhereItem)whereItemsListReplacingEqualsClause.get(j)).toMSSQLServerSelect(to_sqs, from_sqs));
                            if (j == whereItemsListReplacingEqualsClause.size() - 1) continue;
                            if (wi.getOperator2().equalsIgnoreCase("ALL")) {
                                we.getOperator().add("AND");
                                continue;
                            }
                            we.getOperator().add("OR");
                        }
                    } else {
                        WhereColumn l_wc_check = wi.getLeftWhereExp();
                        if (wi.getOperator() != null && wi.getOperator().equalsIgnoreCase("IN") && wi.getRightWhereSubQuery() != null && l_wc_check != null && l_wc_check.getColumnExpression() != null && l_wc_check.getColumnExpression().size() > 1 && l_wc_check.getColumnExpression().contains(",")) {
                            if (SwisSQLOptions.splitMulitpleColumnsOfINClause) {
                                Vector left_col_list_v = new Vector();
                                WhereColumn l_wc = wi.getLeftWhereExp();
                                if (l_wc.getColumnExpression() != null && l_wc.getColumnExpression().size() != 1 && l_wc.getColumnExpression().contains(",")) {
                                    Vector col_exp_v = l_wc.getColumnExpression();
                                    for (int k = 0; k < col_exp_v.size(); ++k) {
                                        if (col_exp_v.elementAt(k).toString().equalsIgnoreCase(",")) continue;
                                        left_col_list_v.addElement(col_exp_v.elementAt(k));
                                    }
                                }
                                SelectQueryStatement current_rw_subquery = wi.getRightWhereSubQuery();
                                Vector rw_subquery_selectlist = current_rw_subquery.getSelectStatement().getSelectItemList();
                                for (int k = 0; k < left_col_list_v.size(); ++k) {
                                    WhereItem wi1 = new WhereItem();
                                    wi1.setLeftWhereExp((WhereColumn)left_col_list_v.elementAt(k));
                                    wi1.setOperator("IN");
                                    SelectQueryStatement sqs1 = new SelectQueryStatement();
                                    SelectStatement ss1 = new SelectStatement();
                                    Object only_select_item_list = rw_subquery_selectlist.elementAt(k);
                                    if (only_select_item_list instanceof SelectColumn) {
                                        ((SelectColumn)only_select_item_list).setEndsWith(null);
                                    }
                                    Vector v = new Vector();
                                    v.addElement(only_select_item_list);
                                    ss1.setSelectClause(current_rw_subquery.getSelectStatement().getSelectClause());
                                    ss1.setSelectItemList(v);
                                    sqs1.setSelectStatement(ss1);
                                    sqs1.setFromClause(current_rw_subquery.getFromClause());
                                    WhereExpression we1 = null;
                                    if (current_rw_subquery.getWhereExpression() != null) {
                                        we1 = current_rw_subquery.getWhereExpression().toMSSQLServerSelect(current_rw_subquery, sqs1);
                                    }
                                    sqs1.setWhereExpression(we1);
                                    if (only_select_item_list instanceof SelectColumn && SwisSQLUtils.isAggregateFunction((SelectColumn)only_select_item_list)) {
                                        sqs1.setGroupByStatement(current_rw_subquery.getGroupByStatement());
                                    }
                                    wi1.setRightWhereSubQuery(sqs1);
                                    whereItemList.addElement(wi1.toMSSQLServerSelect(to_sqs, from_sqs));
                                    if (k >= left_col_list_v.size() - 1) continue;
                                    we.addOperator("AND");
                                }
                            } else {
                                whereItemList.addElement(wi.toMSSQLServerSelect(to_sqs, from_sqs));
                            }
                        } else if (wi.getOperator() != null && (wi.getOperator().equalsIgnoreCase("IN") || wi.getOperator().equalsIgnoreCase("NOT IN")) && wi.getRightWhereSubQuery() == null && wi.getRightWhereExp() != null) {
                            WhereItem mssqlWi = wi.toMSSQLServerSelect(to_sqs, from_sqs);
                            Vector v = mssqlWi.getRightWhereExp().getColumnExpression();
                            if (v != null) {
                                int newCount;
                                int count2 = v.size();
                                WhereExpression inWhereExp = null;
                                for (int j = 0; j < count2; ++j) {
                                    Object kk;
                                    String ss;
                                    Object val = v.get(j);
                                    if (!(val instanceof WhereColumn) || !(ss = ((WhereColumn)val).toString().trim()).equalsIgnoreCase("null")) continue;
                                    String op2 = mssqlWi.getOperator();
                                    inWhereExp = new WhereExpression();
                                    inWhereExp.addWhereItem(mssqlWi);
                                    inWhereExp.setOpenBrace("(");
                                    inWhereExp.setCloseBrace(")");
                                    WhereItem wet = new WhereItem();
                                    String newOp = op2.equalsIgnoreCase("IN") ? "IS" : "IS NOT";
                                    wet.setOperator(newOp);
                                    wet.setLeftWhereExp(mssqlWi.getLeftWhereExp());
                                    Vector<String> vv = new Vector<String>();
                                    vv.add("NULL");
                                    WhereColumn wcc = new WhereColumn();
                                    wcc.setColumnExpression(vv);
                                    wet.setRightWhereExp(wcc);
                                    String andOrOp = op2.equalsIgnoreCase("IN") ? "OR" : "AND";
                                    inWhereExp.addOperator(andOrOp);
                                    inWhereExp.addWhereItem(wet);
                                    if (j + 1 < count2 && (kk = v.get(j + 1)) != null && kk.toString().trim().equals(",")) {
                                        v.remove(j + 1);
                                        v.remove(j);
                                        break;
                                    }
                                    v.remove(j);
                                    if (j != v.size() - 1 || v.size() - 2 < 0 || !v.get(v.size() - 2).toString().trim().equals(",")) break;
                                    v.remove(v.size() - 2);
                                    break;
                                }
                                if (count2 == (newCount = v.size())) {
                                    whereItemList.addElement(mssqlWi);
                                } else {
                                    whereItemList.addElement(inWhereExp);
                                }
                            } else {
                                whereItemList.addElement(wi.toMSSQLServerSelect(to_sqs, from_sqs));
                            }
                        } else {
                            whereItemList.addElement(wi.toMSSQLServerSelect(to_sqs, from_sqs));
                        }
                    }
                    if (wi.getRownumClause() == null) continue;
                    if (i != 0) {
                        op = (String)we.getOperator().get(i - 1);
                        if (!op.equals("&AND")) {
                            we.getOperator().setElementAt("&AND", i - 1);
                            continue;
                        }
                        if (we.getOperator().size() <= i) continue;
                        we.getOperator().setElementAt("&AND", i);
                        continue;
                    }
                    if (we.getOperator().size() <= 0) continue;
                    we.getOperator().setElementAt("&AND", 0);
                    continue;
                }
                if (!SwisSQLAPI.MSSQLSERVER_THETA) {
                    whereItemList.addElement(null);
                    if (i != 0) {
                        op = (String)we.getOperator().get(i - 1);
                        if (!op.equals("&AND")) {
                            we.getOperator().setElementAt("&AND", i - 1);
                            continue;
                        }
                        if (we.getOperator().size() <= i) continue;
                        we.getOperator().setElementAt("&AND", i);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                whereItemList.addElement(((WhereItem)this.whereItems.elementAt(i)).toMSSQLServerSelect(to_sqs, from_sqs));
                continue;
            }
            if (!(this.whereItems.elementAt(i) instanceof WhereExpression)) continue;
            WhereExpression internalWE = ((WhereExpression)this.whereItems.elementAt(i)).toMSSQLServerSelect(to_sqs, from_sqs);
            whereItemList.addElement(internalWE);
            if (internalWE.toString() != null) continue;
            if (i != 0) {
                op = (String)we.getOperator().get(i - 1);
                if (!op.equals("&AND")) {
                    we.getOperator().setElementAt("&AND", i - 1);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
                continue;
            }
            if (we.getOperator().size() <= i) continue;
            we.getOperator().setElementAt("&AND", i);
        }
        we.setWhereItem(whereItemList);
        we.setCheckWhere(this.checkWhere);
        we.setRownumClause(this.rownumClause);
        if (!SwisSQLAPI.MSSQLSERVER_THETA && this.topLevel) {
            this.setNewFromClauseWithANSIJoin(to_sqs, from_sqs, 2, we);
        }
        return we;
    }

    public WhereExpression toSybaseSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.setTargetDatabase(7);
        if (this.rownumClause != null && to_sqs != null) {
            String rownumValue = "0";
            if (to_sqs.getSelectStatement().getSelectRowSpecifier() != null) {
                throw new ConvertException();
            }
            if (this.rownumClause.getRownumValue() instanceof SelectQueryStatement) {
                throw new ConvertException("Conversion failure.. Subquery can't be converted");
            }
            if (this.rownumClause.getRownumValue() instanceof SelectColumn) {
                SelectColumn sc = (SelectColumn)this.rownumClause.getRownumValue();
                Vector colExp = sc.getColumnExpression();
                for (int i = 0; i < colExp.size(); ++i) {
                    if (colExp.elementAt(i) instanceof FunctionCalls) {
                        throw new ConvertException("Conversion failure.. Function calls can't be converted");
                    }
                    if (colExp.elementAt(i) instanceof TableColumn) {
                        throw new ConvertException("Conversion failure.. Identifier can't be converted");
                    }
                    if (!(colExp.elementAt(i) instanceof String) || colExp.size() != 1) {
                        throw new ConvertException("Conversion failure.. Expression can't be converted");
                    }
                    rownumValue = (String)colExp.elementAt(i);
                }
            }
            if (this.rownumClause.getOperator().equals("<=") || this.rownumClause.getOperator().equals("=")) {
                to_sqs.getSelectStatement().setSelectRowCount(Integer.parseInt(rownumValue));
            } else {
                to_sqs.getSelectStatement().setSelectRowCount(Integer.parseInt(rownumValue) - 1);
            }
        }
        WhereExpression we = new WhereExpression();
        we.setOpenBrace(this.openBraces);
        we.setCloseBrace(this.closeBraces);
        we.setObjectContext(this.context);
        if (this.beginOperator != null) {
            we.setBeginOperator(this.beginOperator);
        }
        if (this.operators != null) {
            Vector<String> newOperators = new Vector<String>();
            for (int i = 0; i < this.operators.size(); ++i) {
                String op = (String)this.operators.elementAt(i);
                newOperators.addElement(op);
            }
            we.setOperator(newOperators);
        }
        Vector<Object> whereItemList = new Vector<Object>();
        for (int i = 0; i < this.whereItems.size(); ++i) {
            String op;
            if (this.whereItems.elementAt(i) == null) {
                whereItemList.addElement(null);
            }
            if (this.whereItems.elementAt(i) instanceof WhereItem) {
                WhereItem wi = (WhereItem)this.whereItems.elementAt(i);
                wi.setObjectContext(this.context);
                if (wi.getLeftJoin() == null && wi.getRightJoin() == null) {
                    int j;
                    if (this.isWhereItemInClauseIsMultipleAndNotSubquery(wi)) {
                        Vector whereItemsListReplacingInClause = wi.getWhereItemsReplacingInClause();
                        for (j = 0; j < whereItemsListReplacingInClause.size(); ++j) {
                            ((WhereItem)whereItemsListReplacingInClause.get(j)).setObjectContext(this.context);
                            whereItemList.addElement(((WhereItem)whereItemsListReplacingInClause.get(j)).toSybaseSelect(to_sqs, from_sqs));
                            if (j == whereItemsListReplacingInClause.size() - 1) continue;
                            we.getOperator().add("AND");
                        }
                    } else if (this.isWhereItemEqualsClauseIsMultipleAndNotSubquery(wi)) {
                        Vector whereItemsListReplacingEqualsClause = wi.getWhereItemsReplacingEqualsClause();
                        for (j = 0; j < whereItemsListReplacingEqualsClause.size(); ++j) {
                            ((WhereItem)whereItemsListReplacingEqualsClause.get(j)).setObjectContext(this.context);
                            whereItemList.addElement(((WhereItem)whereItemsListReplacingEqualsClause.get(j)).toSybaseSelect(to_sqs, from_sqs));
                            if (j == whereItemsListReplacingEqualsClause.size() - 1) continue;
                            if (wi.getOperator2().equalsIgnoreCase("ALL")) {
                                we.getOperator().add("AND");
                                continue;
                            }
                            we.getOperator().add("OR");
                        }
                    } else {
                        whereItemList.addElement(wi.toSybaseSelect(to_sqs, from_sqs));
                    }
                    if (wi.getRownumClause() == null) continue;
                    if (i != 0) {
                        op = (String)we.getOperator().get(i - 1);
                        if (!op.equals("&AND")) {
                            we.getOperator().setElementAt("&AND", i - 1);
                            continue;
                        }
                        if (we.getOperator().size() <= i) continue;
                        we.getOperator().setElementAt("&AND", i);
                        continue;
                    }
                    if (we.getOperator().size() <= 0) continue;
                    we.getOperator().setElementAt("&AND", 0);
                    continue;
                }
                if (!SwisSQLAPI.MSSQLSERVER_THETA) {
                    whereItemList.addElement(null);
                    if (i != 0) {
                        op = (String)we.getOperator().get(i - 1);
                        if (!op.equals("&AND")) {
                            we.getOperator().setElementAt("&AND", i - 1);
                            continue;
                        }
                        if (we.getOperator().size() <= i) continue;
                        we.getOperator().setElementAt("&AND", i);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                whereItemList.addElement(((WhereItem)this.whereItems.elementAt(i)).toSybaseSelect(to_sqs, from_sqs));
                continue;
            }
            if (!(this.whereItems.elementAt(i) instanceof WhereExpression)) continue;
            ((WhereExpression)this.whereItems.elementAt(i)).setObjectContext(this.context);
            WhereExpression internalWE = ((WhereExpression)this.whereItems.elementAt(i)).toSybaseSelect(to_sqs, from_sqs);
            whereItemList.addElement(internalWE);
            if (internalWE.toString() != null) continue;
            if (i != 0) {
                op = (String)we.getOperator().get(i - 1);
                if (!op.equals("&AND")) {
                    we.getOperator().setElementAt("&AND", i - 1);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
                continue;
            }
            if (we.getOperator().size() <= i) continue;
            we.getOperator().setElementAt("&AND", i);
        }
        we.setWhereItem(whereItemList);
        we.setCheckWhere(this.checkWhere);
        we.setRownumClause(this.rownumClause);
        if (!SwisSQLAPI.MSSQLSERVER_THETA && this.topLevel) {
            this.setNewFromClauseWithANSIJoin(to_sqs, from_sqs, 7, we);
        }
        return we;
    }

    public WhereExpression toOracleSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereExpression we = new WhereExpression();
        this.setTargetDatabase(1);
        if (SwisSQLAPI.convert_OracleThetaJOIN_To_ANSIJOIN) {
            int i;
            we.setOpenBrace(this.openBraces);
            we.setCloseBrace(this.closeBraces);
            if (this.beginOperator != null) {
                we.setBeginOperator(this.beginOperator);
            }
            if (this.operators != null) {
                Vector<String> newOperators = new Vector<String>();
                for (i = 0; i < this.operators.size(); ++i) {
                    String op = (String)this.operators.elementAt(i);
                    newOperators.addElement(op);
                }
                we.setOperator(newOperators);
            }
            Vector<Object> whereItemList = new Vector<Object>();
            for (i = 0; i < this.whereItems.size(); ++i) {
                String op;
                if (this.whereItems.elementAt(i) == null) {
                    whereItemList.addElement(null);
                }
                if (this.whereItems.elementAt(i) instanceof WhereItem) {
                    WhereItem wi = (WhereItem)this.whereItems.elementAt(i);
                    if (wi.getLeftJoin() == null && wi.getRightJoin() == null) {
                        whereItemList.addElement(wi.toOracleSelect(to_sqs, from_sqs));
                        if (wi.getRownumClause() == null) continue;
                        if (i != 0) {
                            op = (String)we.getOperator().get(i - 1);
                            if (!op.equals("&AND")) {
                                we.getOperator().setElementAt("&AND", i - 1);
                                continue;
                            }
                            if (we.getOperator().size() <= i) continue;
                            we.getOperator().setElementAt("&AND", i);
                            continue;
                        }
                        if (we.getOperator().size() <= i) continue;
                        we.getOperator().setElementAt("&AND", i);
                        continue;
                    }
                    whereItemList.addElement(null);
                    if (i != 0) {
                        op = (String)we.getOperator().get(i - 1);
                        if (!op.equals("&AND")) {
                            we.getOperator().setElementAt("&AND", i - 1);
                            continue;
                        }
                        if (we.getOperator().size() <= i) continue;
                        we.getOperator().setElementAt("&AND", i);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                if (!(this.whereItems.elementAt(i) instanceof WhereExpression)) continue;
                WhereExpression internalWE = ((WhereExpression)this.whereItems.elementAt(i)).toOracleSelect(to_sqs, from_sqs);
                whereItemList.addElement(internalWE);
                if (internalWE.toString() != null) continue;
                if (i != 0) {
                    op = (String)we.getOperator().get(i - 1);
                    if (!op.equals("&AND")) {
                        we.getOperator().setElementAt("&AND", i - 1);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
            }
            we.setWhereItem(whereItemList);
            we.setCheckWhere(this.checkWhere);
            we.setRownumClause(this.rownumClause);
            if (this.topLevel) {
                this.setNewFromClauseWithANSIJoin(to_sqs, from_sqs, 1, we);
            }
        } else {
            int i;
            we.setOpenBrace(this.openBraces);
            we.setCloseBrace(this.closeBraces);
            we.setCommentClass(this.commentObj);
            if (this.beginOperator != null) {
                we.setBeginOperator(this.beginOperator);
            }
            if (this.operators != null) {
                Vector<String> newOperators = new Vector<String>();
                for (i = 0; i < this.operators.size(); ++i) {
                    String op = (String)this.operators.elementAt(i);
                    if (op != null && op.equalsIgnoreCase("ANSIAND")) {
                        newOperators.addElement("AND");
                        continue;
                    }
                    if (op != null && op.equalsIgnoreCase("ANSIOR")) {
                        newOperators.addElement("OR");
                        continue;
                    }
                    newOperators.addElement(op);
                }
                we.setOperator(newOperators);
            }
            Vector<Object> whereItemList = new Vector<Object>();
            for (i = 0; i < this.whereItems.size(); ++i) {
                String singleQueryConvertedToMultipleQueryList = SelectQueryStatement.singleQueryConvertedToMultipleQueryList;
                SelectQueryStatement.singleQueryConvertedToMultipleQueryList = null;
                if (this.whereItems.elementAt(i) == null) {
                    whereItemList.addElement(null);
                } else if (this.whereItems.elementAt(i) instanceof WhereItem) {
                    String operator;
                    WhereItem wi = ((WhereItem)this.whereItems.elementAt(i)).toOracleSelect(to_sqs, from_sqs);
                    whereItemList.addElement(wi);
                    if (wi != null && (operator = wi.getOperator()) != null && (operator.equalsIgnoreCase("like") || operator.equalsIgnoreCase("not like"))) {
                        this.handleRegularExpression(whereItemList, i);
                    }
                } else if (this.whereItems.elementAt(i) instanceof WhereExpression) {
                    whereItemList.addElement(((WhereExpression)this.whereItems.elementAt(i)).toOracleSelect(to_sqs, from_sqs));
                }
                SelectQueryStatement.singleQueryConvertedToMultipleQueryList = singleQueryConvertedToMultipleQueryList;
            }
            we.setWhereItem(whereItemList);
            we.setCheckWhere(this.checkWhere);
            we.setRownumClause(this.rownumClause);
        }
        return we;
    }

    public WhereExpression toInformixSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.setTargetDatabase(6);
        if (this.rownumClause != null && to_sqs != null) {
            String rownumValue = "0";
            if (to_sqs.getSelectStatement().getSelectRowSpecifier() != null) {
                throw new ConvertException();
            }
            if (this.rownumClause.getRownumValue() instanceof SelectQueryStatement) {
                throw new ConvertException("Conversion failure.. Subquery can't be converted");
            }
            if (this.rownumClause.getRownumValue() instanceof SelectColumn) {
                SelectColumn sc = (SelectColumn)this.rownumClause.getRownumValue();
                Vector colExp = sc.getColumnExpression();
                for (int i = 0; i < colExp.size(); ++i) {
                    if (colExp.elementAt(i) instanceof FunctionCalls) {
                        throw new ConvertException("Conversion failure.. Function calls can't be converted");
                    }
                    if (colExp.elementAt(i) instanceof TableColumn) {
                        throw new ConvertException("Conversion failure.. Identifier can't be converted");
                    }
                    if (!(colExp.elementAt(i) instanceof String) || colExp.size() != 1) {
                        throw new ConvertException("Conversion failure.. Expression can't be converted");
                    }
                    rownumValue = (String)colExp.elementAt(i);
                }
            }
            to_sqs.getSelectStatement().setInformixRowSpecifier("FIRST");
            if (this.rownumClause.getOperator().equals("<=")) {
                to_sqs.getSelectStatement().setSelectRowCount(Integer.parseInt(rownumValue));
            } else {
                to_sqs.getSelectStatement().setSelectRowCount(Integer.parseInt(rownumValue) - 1);
            }
        }
        WhereExpression we = new WhereExpression();
        we.setOpenBrace(this.openBraces);
        we.setCloseBrace(this.closeBraces);
        if (this.beginOperator != null) {
            we.setBeginOperator(this.beginOperator);
        }
        if (this.operators != null) {
            Vector<String> newOperators = new Vector<String>();
            for (int i = 0; i < this.operators.size(); ++i) {
                String op = (String)this.operators.elementAt(i);
                if (op != null && op.equalsIgnoreCase("ANSIAND")) {
                    newOperators.addElement("AND");
                    continue;
                }
                if (op != null && op.equalsIgnoreCase("ANSIOR")) {
                    newOperators.addElement("OR");
                    continue;
                }
                newOperators.addElement(op);
            }
            we.setOperator(newOperators);
        }
        Vector<Object> whereItemList = new Vector<Object>();
        for (int i = 0; i < this.whereItems.size(); ++i) {
            String op;
            if (this.whereItems.elementAt(i) == null) {
                whereItemList.addElement(null);
            }
            if (this.whereItems.elementAt(i) instanceof WhereItem) {
                int j;
                WhereItem wi = (WhereItem)this.whereItems.elementAt(i);
                if (this.isWhereItemInClauseIsMultipleAndNotSubquery(wi)) {
                    Vector whereItemsListReplacingInClause = wi.getWhereItemsReplacingInClause();
                    for (j = 0; j < whereItemsListReplacingInClause.size(); ++j) {
                        whereItemList.addElement(((WhereItem)whereItemsListReplacingInClause.get(j)).toInformixSelect(to_sqs, from_sqs));
                        if (j == whereItemsListReplacingInClause.size() - 1) continue;
                        we.getOperator().add("AND");
                    }
                } else if (this.isWhereItemEqualsClauseIsMultipleAndNotSubquery(wi)) {
                    Vector whereItemsListReplacingEqualsClause = wi.getWhereItemsReplacingEqualsClause();
                    for (j = 0; j < whereItemsListReplacingEqualsClause.size(); ++j) {
                        whereItemList.addElement(((WhereItem)whereItemsListReplacingEqualsClause.get(j)).toInformixSelect(to_sqs, from_sqs));
                        if (j == whereItemsListReplacingEqualsClause.size() - 1) continue;
                        if (wi.getOperator2().equalsIgnoreCase("ALL")) {
                            we.getOperator().add("AND");
                            continue;
                        }
                        we.getOperator().add("OR");
                    }
                } else {
                    whereItemList.addElement(wi.toInformixSelect(to_sqs, from_sqs));
                }
                if (wi.getRownumClause() == null) continue;
                if (i != 0) {
                    op = (String)we.getOperator().get(i - 1);
                    if (!op.equals("&AND")) {
                        we.getOperator().setElementAt("&AND", i - 1);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                if (we.getOperator().size() <= 0) continue;
                we.getOperator().setElementAt("&AND", 0);
                continue;
            }
            if (!(this.whereItems.elementAt(i) instanceof WhereExpression)) continue;
            WhereExpression internalWE = ((WhereExpression)this.whereItems.elementAt(i)).toInformixSelect(to_sqs, from_sqs);
            whereItemList.addElement(internalWE);
            if (internalWE.toString() != null) continue;
            if (i != 0) {
                op = (String)we.getOperator().get(i - 1);
                if (!op.equals("&AND")) {
                    we.getOperator().setElementAt("&AND", i - 1);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
                continue;
            }
            if (we.getOperator().size() <= i) continue;
            we.getOperator().setElementAt("&AND", i);
        }
        we.setWhereItem(whereItemList);
        we.setCheckWhere(this.checkWhere);
        we.setRownumClause(this.rownumClause);
        if (this.topLevel) {
            this.setNewFromClauseWithInformixJoin(to_sqs, from_sqs, 6);
        }
        return we;
    }

    public WhereExpression toANSISelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        int i;
        WhereExpression we = new WhereExpression();
        we.setOpenBrace(this.openBraces);
        we.setCloseBrace(this.closeBraces);
        if (this.beginOperator != null) {
            we.setBeginOperator(this.beginOperator);
        }
        if (this.operators != null) {
            Vector<String> newOperators = new Vector<String>();
            for (i = 0; i < this.operators.size(); ++i) {
                String op = (String)this.operators.elementAt(i);
                newOperators.addElement(op);
            }
            we.setOperator(newOperators);
        }
        Vector<Object> whereItemList = new Vector<Object>();
        for (i = 0; i < this.whereItems.size(); ++i) {
            String op;
            if (this.whereItems.elementAt(i) == null) {
                whereItemList.addElement(null);
            }
            if (this.whereItems.elementAt(i) instanceof WhereItem) {
                WhereItem wi = (WhereItem)this.whereItems.elementAt(i);
                if (wi.getLeftJoin() == null && wi.getRightJoin() == null) {
                    whereItemList.addElement(wi.toANSISelect(to_sqs, from_sqs));
                    if (wi.getRownumClause() == null) continue;
                    if (i != 0) {
                        op = (String)we.getOperator().get(i - 1);
                        if (!op.equals("&AND")) {
                            we.getOperator().setElementAt("&AND", i - 1);
                            continue;
                        }
                        if (we.getOperator().size() <= i) continue;
                        we.getOperator().setElementAt("&AND", i);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                whereItemList.addElement(null);
                if (i != 0) {
                    op = (String)we.getOperator().get(i - 1);
                    if (!op.equals("&AND")) {
                        we.getOperator().setElementAt("&AND", i - 1);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
                continue;
            }
            if (!(this.whereItems.elementAt(i) instanceof WhereExpression)) continue;
            WhereExpression internalWE = ((WhereExpression)this.whereItems.elementAt(i)).toANSISelect(to_sqs, from_sqs);
            whereItemList.addElement(internalWE);
            if (internalWE.toString() != null) continue;
            if (i != 0) {
                op = (String)we.getOperator().get(i - 1);
                if (!op.equals("&AND")) {
                    we.getOperator().setElementAt("&AND", i - 1);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
                continue;
            }
            if (we.getOperator().size() <= i) continue;
            we.getOperator().setElementAt("&AND", i);
        }
        we.setWhereItem(whereItemList);
        we.setCheckWhere(this.checkWhere);
        we.setRownumClause(this.rownumClause);
        if (this.topLevel) {
            this.setNewFromClauseWithANSIJoin(to_sqs, from_sqs, 8, we);
        }
        return we;
    }

    public WhereExpression toTeradataSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        int i;
        WhereExpression we = new WhereExpression();
        we.setOpenBrace(this.openBraces);
        we.setCloseBrace(this.closeBraces);
        this.setTargetDatabase(12);
        this.thetaJoinPresent = false;
        if (this.beginOperator != null) {
            we.setBeginOperator(this.beginOperator);
        }
        if (this.operators != null) {
            Vector<String> newOperators = new Vector<String>();
            for (i = 0; i < this.operators.size(); ++i) {
                String op = (String)this.operators.elementAt(i);
                newOperators.addElement(op);
            }
            we.setOperator(newOperators);
        }
        Vector<Object> whereItemList = new Vector<Object>();
        for (i = 0; i < this.whereItems.size(); ++i) {
            String op;
            if (this.whereItems.elementAt(i) == null) {
                whereItemList.addElement(null);
            }
            if (this.whereItems.elementAt(i) instanceof WhereItem) {
                WhereItem wi = (WhereItem)this.whereItems.elementAt(i);
                wi.setCaseExpressionBool(this.isCaseExpression());
                if (wi.getLeftJoin() == null && wi.getRightJoin() == null) {
                    WhereItem teradataWi = wi.toTeradataSelect(to_sqs, from_sqs);
                    whereItemList.addElement(teradataWi);
                    if (teradataWi != null && teradataWi.getTeradataSysCalendarWhereItem() != null) {
                        whereItemList.addElement(teradataWi.getTeradataSysCalendarWhereItem());
                        we.getOperator().addElement("AND");
                    }
                    if (wi.getRownumClause() == null || this.isCaseExpression()) continue;
                    if (i != 0) {
                        String op2 = (String)we.getOperator().get(i - 1);
                        if (!op2.equals("&AND")) {
                            we.getOperator().setElementAt("&AND", i - 1);
                            continue;
                        }
                        if (we.getOperator().size() <= i) continue;
                        we.getOperator().setElementAt("&AND", i);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                if (!this.thetaJoinPresent) {
                    this.thetaJoinPresent = true;
                }
                whereItemList.addElement(null);
                if (i != 0) {
                    op = (String)we.getOperator().get(i - 1);
                    if (!op.equals("&AND")) {
                        we.getOperator().setElementAt("&AND", i - 1);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
                continue;
            }
            if (!(this.whereItems.elementAt(i) instanceof WhereExpression)) continue;
            ((WhereExpression)this.whereItems.elementAt(i)).setCaseExpressionBool(this.isCaseExpression());
            WhereExpression internalWE = ((WhereExpression)this.whereItems.elementAt(i)).toTeradataSelect(to_sqs, from_sqs);
            if (!this.thetaJoinPresent) {
                this.thetaJoinPresent = internalWE.isThetaJoinPresent();
            }
            whereItemList.addElement(internalWE);
            if (internalWE.toString() != null) continue;
            if (i != 0) {
                op = (String)we.getOperator().get(i - 1);
                if (!op.equals("&AND")) {
                    we.getOperator().setElementAt("&AND", i - 1);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
                continue;
            }
            if (we.getOperator().size() <= i) continue;
            we.getOperator().setElementAt("&AND", i);
        }
        we.setWhereItem(whereItemList);
        we.setCheckWhere(this.checkWhere);
        we.setRownumClause(this.rownumClause);
        if (this.thetaJoinPresent) {
            we.setThetaJoinPresent(true);
        }
        if (this.topLevel && this.thetaJoinPresent) {
            this.setNewFromClauseWithANSIJoin(to_sqs, from_sqs, 12, we);
        }
        return we;
    }

    public WhereExpression toTimesTenSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        this.setTargetDatabase(10);
        if (this.rownumClause != null && to_sqs != null) {
            String rownumValue = "0";
            if (to_sqs.getSelectStatement().getSelectRowSpecifier() != null) {
                throw new ConvertException();
            }
            if (this.rownumClause.getRownumValue() instanceof SelectQueryStatement) {
                throw new ConvertException("Conversion failure.. Subquery can't be converted");
            }
            if (this.rownumClause.getRownumValue() instanceof SelectColumn) {
                SelectColumn sc = (SelectColumn)this.rownumClause.getRownumValue();
                Vector colExp = sc.getColumnExpression();
                for (int i = 0; i < colExp.size(); ++i) {
                    if (colExp.elementAt(i) instanceof FunctionCalls) {
                        throw new ConvertException("Conversion failure.. Function calls can't be converted");
                    }
                    if (colExp.elementAt(i) instanceof TableColumn) {
                        if (this.rownumClause.getOperator().equals("<=") || this.rownumClause.getOperator().equals("=")) {
                            to_sqs.getSelectStatement().setSelectRowCountVariable(((TableColumn)colExp.elementAt(i)).toString());
                            continue;
                        }
                        to_sqs.getSelectStatement().setSelectRowCountVariable(((TableColumn)colExp.elementAt(i)).toString() + " - 1");
                        continue;
                    }
                    if (colExp.elementAt(i) instanceof String && colExp.size() == 1) {
                        rownumValue = (String)colExp.elementAt(i);
                        continue;
                    }
                    throw new ConvertException("Conversion failure.. Expression can't be converted");
                }
            }
            to_sqs.getSelectStatement().setSelectRowSpecifier("FIRST");
            if (this.rownumClause.getOperator().equals("<=") || this.rownumClause.getOperator().equals("=")) {
                to_sqs.getSelectStatement().setSelectRowCount(Integer.parseInt(rownumValue));
            } else {
                to_sqs.getSelectStatement().setSelectRowCount(Integer.parseInt(rownumValue) - 1);
            }
        }
        WhereExpression we = new WhereExpression();
        we.setOpenBrace(this.openBraces);
        we.setCloseBrace(this.closeBraces);
        if (this.beginOperator != null) {
            we.setBeginOperator(this.beginOperator);
        }
        if (this.operators != null) {
            Vector<String> newOperators = new Vector<String>();
            for (int i = 0; i < this.operators.size(); ++i) {
                String op = (String)this.operators.elementAt(i);
                if (op != null && op.equalsIgnoreCase("ANSIAND")) {
                    newOperators.addElement("AND");
                    continue;
                }
                if (op != null && op.equalsIgnoreCase("ANSIOR")) {
                    newOperators.addElement("OR");
                    continue;
                }
                newOperators.addElement(op);
            }
            we.setOperator(newOperators);
        }
        Vector<Object> whereItemList = new Vector<Object>();
        for (int i = 0; i < this.whereItems.size(); ++i) {
            String singleQueryConvertedToMultipleQueryList = SelectQueryStatement.singleQueryConvertedToMultipleQueryList;
            SelectQueryStatement.singleQueryConvertedToMultipleQueryList = null;
            if (this.whereItems.elementAt(i) == null) {
                whereItemList.addElement(null);
            } else if (this.whereItems.elementAt(i) instanceof WhereItem) {
                whereItemList.addElement(((WhereItem)this.whereItems.elementAt(i)).toTimesTenSelect(to_sqs, from_sqs));
            } else if (this.whereItems.elementAt(i) instanceof WhereExpression) {
                whereItemList.addElement(((WhereExpression)this.whereItems.elementAt(i)).toTimesTenSelect(to_sqs, from_sqs));
            }
            SelectQueryStatement.singleQueryConvertedToMultipleQueryList = singleQueryConvertedToMultipleQueryList;
        }
        we.setWhereItem(whereItemList);
        we.setCheckWhere(this.checkWhere);
        we.setRownumClause(this.rownumClause);
        return we;
    }

    public WhereExpression toNetezzaSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        int i;
        WhereExpression we = new WhereExpression();
        we.setOpenBrace(this.openBraces);
        we.setCloseBrace(this.closeBraces);
        this.setTargetDatabase(11);
        if (this.beginOperator != null) {
            we.setBeginOperator(this.beginOperator);
        }
        if (this.operators != null) {
            Vector<String> newOperators = new Vector<String>();
            for (i = 0; i < this.operators.size(); ++i) {
                String op = (String)this.operators.elementAt(i);
                newOperators.addElement(op);
            }
            we.setOperator(newOperators);
        }
        Vector<Object> whereItemList = new Vector<Object>();
        for (i = 0; i < this.whereItems.size(); ++i) {
            String op;
            if (this.whereItems.elementAt(i) == null) {
                whereItemList.addElement(null);
            }
            if (this.whereItems.elementAt(i) instanceof WhereItem) {
                WhereItem wi = (WhereItem)this.whereItems.elementAt(i);
                if (wi.getLeftJoin() == null && wi.getRightJoin() == null) {
                    whereItemList.addElement(wi.toNetezzaSelect(to_sqs, from_sqs));
                    if (wi.getRownumClause() == null) continue;
                    if (i != 0) {
                        op = (String)we.getOperator().get(i - 1);
                        if (!op.equals("&AND")) {
                            we.getOperator().setElementAt("&AND", i - 1);
                            continue;
                        }
                        if (we.getOperator().size() <= i) continue;
                        we.getOperator().setElementAt("&AND", i);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                whereItemList.addElement(null);
                if (i != 0) {
                    op = (String)we.getOperator().get(i - 1);
                    if (!op.equals("&AND")) {
                        we.getOperator().setElementAt("&AND", i - 1);
                        continue;
                    }
                    if (we.getOperator().size() <= i) continue;
                    we.getOperator().setElementAt("&AND", i);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
                continue;
            }
            if (!(this.whereItems.elementAt(i) instanceof WhereExpression)) continue;
            WhereExpression internalWE = ((WhereExpression)this.whereItems.elementAt(i)).toNetezzaSelect(to_sqs, from_sqs);
            whereItemList.addElement(internalWE);
            if (internalWE.toString() != null) continue;
            if (i != 0) {
                op = (String)we.getOperator().get(i - 1);
                if (!op.equals("&AND")) {
                    we.getOperator().setElementAt("&AND", i - 1);
                    continue;
                }
                if (we.getOperator().size() <= i) continue;
                we.getOperator().setElementAt("&AND", i);
                continue;
            }
            if (we.getOperator().size() <= i) continue;
            we.getOperator().setElementAt("&AND", i);
        }
        we.setWhereItem(whereItemList);
        we.setCheckWhere(this.checkWhere);
        we.setRownumClause(this.rownumClause);
        if (this.topLevel) {
            this.setNewFromClauseWithANSIJoin(to_sqs, from_sqs, 11, we);
        }
        return we;
    }

    private void handleRegularExpression(Vector whereItemsList, int i) {
        WhereItem wi = (WhereItem)whereItemsList.get(i);
        WhereColumn rwc = wi.getRightWhereExp();
        WhereColumn lwc = wi.getLeftWhereExp();
        String operator = wi.getOperator();
        boolean isNotLike = false;
        if (operator.equalsIgnoreCase("not like")) {
            isNotLike = true;
        }
        if (rwc != null) {
            Vector colExp = rwc.getColumnExpression();
            for (int j = 0; j < colExp.size(); ++j) {
                Object obj = colExp.get(j);
                if (!(obj instanceof String) || !((String)obj).startsWith("'")) continue;
                String literal = (String)obj;
                int index1 = literal.indexOf("[");
                int index2 = literal.indexOf("]");
                if (index1 == -1 || index2 == -1 || index2 == index1 + 1) continue;
                String subRegExp = literal.substring(index1 + 1, index2);
                String replaceStr = "[" + subRegExp + "]";
                if (subRegExp.startsWith("(") && subRegExp.endsWith(")") && subRegExp.length() > 2) {
                    subRegExp = subRegExp.substring(1, subRegExp.length() - 1);
                }
                WhereExpression we = new WhereExpression();
                we.setOpenBrace("(");
                we.setCloseBrace(")");
                if (subRegExp.startsWith("^")) {
                    if ((subRegExp = subRegExp.substring(1)).startsWith("(") && subRegExp.endsWith(")") && subRegExp.length() > 2) {
                        subRegExp = subRegExp.substring(1, subRegExp.length() - 1);
                    }
                    ArrayList<String> rightSideItems = new ArrayList<String>();
                    if (subRegExp.length() == 3 && subRegExp.indexOf("-") == 1) {
                        int startInt = subRegExp.charAt(0);
                        char endInt = subRegExp.charAt(2);
                        for (int s = startInt; s <= endInt; ++s) {
                            rightSideItems.add("'" + (char)s + "'");
                        }
                    } else {
                        for (int k = 0; k < subRegExp.length(); ++k) {
                            rightSideItems.add("'" + subRegExp.charAt(k) + "'");
                        }
                    }
                    if (literal.startsWith("'%")) {
                        String newLiteral = StringFunctions.replaceFirst("_", replaceStr, literal);
                        colExp.setElementAt(newLiteral, j);
                        String replaceFnLiteral = literal;
                        replaceFnLiteral = "'" + replaceFnLiteral.substring(2);
                        if (replaceFnLiteral.endsWith("%'")) {
                            replaceFnLiteral = replaceFnLiteral.substring(0, replaceFnLiteral.length() - 2) + "'";
                        }
                        WhereExpression we1 = new WhereExpression();
                        we1.setOpenBrace("(");
                        we1.setCloseBrace(")");
                        for (int k = 0; k < rightSideItems.size(); ++k) {
                            String character = rightSideItems.get(k).toString();
                            character = character.substring(1, 2);
                            WhereItem newWI = new WhereItem();
                            WhereColumn newLWC = new WhereColumn();
                            Vector<FunctionCalls> newLWCExp = new Vector<FunctionCalls>();
                            newLWC.setColumnExpression(newLWCExp);
                            FunctionCalls fc = new FunctionCalls();
                            TableColumn tcfn = new TableColumn();
                            tcfn.setColumnName("REPLACE");
                            fc.setFunctionName(tcfn);
                            Vector<Object> fnArgs = new Vector<Object>();
                            fc.setFunctionArguments(fnArgs);
                            SelectColumn sc = new SelectColumn();
                            sc.setColumnExpression(lwc.getColumnExpression());
                            fnArgs.add(sc);
                            String secondArg = StringFunctions.replaceFirst(character, replaceStr, replaceFnLiteral);
                            fnArgs.add(secondArg);
                            fnArgs.add("'x'");
                            newLWCExp.add(fc);
                            newWI.setLeftWhereExp(newLWC);
                            newWI.setOperator("LIKE");
                            newWI.setRightWhereExp(rwc);
                            if (isNotLike) {
                                we1.addWhereItem(newWI);
                            } else {
                                we.addWhereItem(newWI);
                            }
                            if (k + 1 >= rightSideItems.size()) continue;
                            if (isNotLike) {
                                we1.addOperator("AND");
                                continue;
                            }
                            we.addOperator("AND");
                        }
                        if (isNotLike) {
                            we.setOpenBrace(null);
                            we.setCloseBrace(null);
                            WhereItem newWI = new WhereItem();
                            newWI.setLeftWhereExp(null);
                            newWI.setOperator("NOT");
                            WhereColumn newRWC = new WhereColumn();
                            Vector<WhereExpression> newRWCExp = new Vector<WhereExpression>();
                            newRWCExp.add(we1);
                            newRWC.setColumnExpression(newRWCExp);
                            newWI.setRightWhereExp(newRWC);
                            we.addWhereItem(newWI);
                        }
                    } else {
                        WhereItem wi1 = new WhereItem();
                        wi1.setLeftWhereExp(lwc);
                        wi1.setOperator("LIKE");
                        String newLiteral = StringFunctions.replaceFirst("_", replaceStr, literal);
                        colExp.setElementAt(newLiteral, j);
                        wi1.setRightWhereExp(rwc);
                        WhereItem wi2 = new WhereItem();
                        WhereColumn lwc2 = new WhereColumn();
                        Vector<FunctionCalls> lwcExp = new Vector<FunctionCalls>();
                        FunctionCalls fc = new FunctionCalls();
                        Vector<Object> fnArgs = new Vector<Object>();
                        fnArgs.add(lwc);
                        fnArgs.add(index1 + "");
                        fnArgs.add("1");
                        TableColumn tcfn = new TableColumn();
                        tcfn.setColumnName("SUBSTR");
                        fc.setFunctionName(tcfn);
                        fc.setFunctionArguments(fnArgs);
                        lwcExp.add(fc);
                        lwc2.setColumnExpression(lwcExp);
                        wi2.setLeftWhereExp(lwc2);
                        if (isNotLike) {
                            wi2.setOperator("IN");
                        } else {
                            wi2.setOperator("NOT IN");
                        }
                        WhereColumn rwc2 = new WhereColumn();
                        Vector<String> rwcExp = new Vector<String>();
                        rwcExp.add("(");
                        for (int l = 0; l < rightSideItems.size(); ++l) {
                            rwcExp.add((String)rightSideItems.get(l));
                            if (l + 1 >= rightSideItems.size()) continue;
                            rwcExp.add(",");
                        }
                        rwcExp.add(")");
                        rwc2.setColumnExpression(rwcExp);
                        wi2.setRightWhereExp(rwc2);
                        if (isNotLike) {
                            WhereExpression we1 = new WhereExpression();
                            we1.setOpenBrace("(");
                            we1.setCloseBrace(")");
                            we1.addWhereItem(wi1);
                            we1.addOperator("AND");
                            we1.addWhereItem(wi2);
                            we.addWhereExpression(we1);
                            we.addOperator("OR");
                            WhereItem wi3 = new WhereItem();
                            wi3.setLeftWhereExp(lwc);
                            wi3.setOperator("NOT LIKE");
                            wi3.setRightWhereExp(rwc);
                            we.addWhereItem(wi3);
                        } else {
                            we.addWhereItem(wi1);
                            we.addOperator("AND");
                            we.addWhereItem(wi2);
                        }
                    }
                    whereItemsList.setElementAt(we, i);
                    break;
                }
                if (subRegExp.length() == 3 && subRegExp.indexOf("-") == 1) {
                    if (literal.startsWith("'%")) {
                        int startInt = subRegExp.charAt(0);
                        char endInt = subRegExp.charAt(2);
                        for (int s = startInt; s <= endInt; ++s) {
                            WhereItem newWI = new WhereItem();
                            newWI.setLeftWhereExp(lwc);
                            newWI.setOperator(wi.getOperator());
                            String newLiteral = StringFunctions.replaceFirst((char)s + "", replaceStr, literal);
                            colExp.setElementAt(newLiteral, j);
                            Vector newColExp = new Vector();
                            for (int n = 0; n < colExp.size(); ++n) {
                                newColExp.add(colExp.get(n));
                            }
                            WhereColumn newRWC = new WhereColumn();
                            newRWC.setColumnExpression(newColExp);
                            newRWC.setOpenBrace(rwc.getOpenBrace());
                            newRWC.setCloseBrace(rwc.getCloseBrace());
                            newWI.setRightWhereExp(newRWC);
                            we.addWhereItem(newWI);
                            if (s + '\u0001' > endInt) continue;
                            if (isNotLike) {
                                we.addOperator("AND");
                                continue;
                            }
                            we.addOperator("OR");
                        }
                        whereItemsList.setElementAt(we, i);
                        break;
                    }
                    String startChar = "'" + subRegExp.charAt(0) + "'";
                    String endChar = "'" + subRegExp.charAt(2) + "'";
                    WhereItem wi1 = new WhereItem();
                    wi1.setLeftWhereExp(lwc);
                    wi1.setOperator("LIKE");
                    String newLiteral = StringFunctions.replaceFirst("_", replaceStr, literal);
                    colExp.setElementAt(newLiteral, j);
                    wi1.setRightWhereExp(rwc);
                    WhereItem wi2 = new WhereItem();
                    WhereColumn lwc2 = new WhereColumn();
                    Vector<FunctionCalls> lwcExp = new Vector<FunctionCalls>();
                    FunctionCalls fc = new FunctionCalls();
                    Vector<Object> fnArgs = new Vector<Object>();
                    fnArgs.add(lwc);
                    fnArgs.add(index1 + "");
                    fnArgs.add("1");
                    TableColumn tcfn = new TableColumn();
                    tcfn.setColumnName("SUBSTR");
                    fc.setFunctionName(tcfn);
                    fc.setFunctionArguments(fnArgs);
                    lwcExp.add(fc);
                    lwc2.setColumnExpression(lwcExp);
                    wi2.setLeftWhereExp(lwc2);
                    if (isNotLike) {
                        wi2.setOperator("NOT BETWEEN");
                    } else {
                        wi2.setOperator("BETWEEN");
                    }
                    WhereColumn rwc2 = new WhereColumn();
                    Vector<String> rwcExp = new Vector<String>();
                    rwcExp.add(startChar);
                    rwcExp.add("AND");
                    rwcExp.add(endChar);
                    rwc2.setColumnExpression(rwcExp);
                    wi2.setRightWhereExp(rwc2);
                    if (isNotLike) {
                        WhereExpression we1 = new WhereExpression();
                        we1.setOpenBrace("(");
                        we1.setCloseBrace(")");
                        we1.addWhereItem(wi1);
                        we1.addOperator("AND");
                        we1.addWhereItem(wi2);
                        we.addWhereExpression(we1);
                        we.addOperator("OR");
                        WhereItem wi3 = new WhereItem();
                        wi3.setLeftWhereExp(lwc);
                        wi3.setOperator("NOT LIKE");
                        wi3.setRightWhereExp(rwc);
                        we.addWhereItem(wi3);
                    } else {
                        we.addWhereItem(wi1);
                        we.addOperator("AND");
                        we.addWhereItem(wi2);
                    }
                    whereItemsList.setElementAt(we, i);
                    break;
                }
                String first = literal.substring(0, index1);
                String last = literal.substring(index2 + 1);
                for (int k = 0; k < subRegExp.length(); ++k) {
                    String newLiteral = null;
                    boolean oracleWildCards = false;
                    if (subRegExp.length() == 1 && (subRegExp.charAt(0) == '%' || subRegExp.charAt(0) == '_')) {
                        newLiteral = first + "\\" + subRegExp.charAt(0) + last;
                        oracleWildCards = true;
                    } else {
                        newLiteral = first + subRegExp.charAt(k) + last;
                    }
                    colExp.setElementAt(newLiteral, j);
                    Vector newColExp = new Vector();
                    for (int n = 0; n < colExp.size(); ++n) {
                        newColExp.add(colExp.get(n));
                    }
                    if (oracleWildCards) {
                        newColExp.add("ESCAPE");
                        newColExp.add("'\\'");
                    }
                    WhereItem newWI = new WhereItem();
                    newWI.setLeftWhereExp(lwc);
                    newWI.setOperator(operator);
                    WhereColumn newRWC = new WhereColumn();
                    newRWC.setColumnExpression(newColExp);
                    newRWC.setOpenBrace(rwc.getOpenBrace());
                    newRWC.setCloseBrace(rwc.getCloseBrace());
                    newWI.setRightWhereExp(newRWC);
                    we.addWhereItem(newWI);
                    if (k + 1 >= subRegExp.length()) continue;
                    if (isNotLike) {
                        we.addOperator("AND");
                        continue;
                    }
                    we.addOperator("OR");
                }
                whereItemsList.setElementAt(we, i);
                break;
            }
        }
    }

    private String getPartialMatchKey(Iterator it, String key) {
        while (it.hasNext()) {
            String existingKey = it.next().toString();
            if (key.indexOf(existingKey) != -1) {
                return existingKey;
            }
            if (existingKey.indexOf(key) != -1) {
                return existingKey;
            }
            if (key.indexOf("-&&") == -1 || existingKey.indexOf(key.substring(0, key.indexOf("-&&"))) == -1) continue;
            return existingKey;
        }
        return null;
    }

    private FromClause handleInnerJoin(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs, int database, WhereExpression whereExpression, Vector remainingFromItemList, FromClause convertedFromClause) throws ConvertException {
        block72: {
            try {
                FromTable ft;
                Vector fromItemList = convertedFromClause.getFromItemList();
                int fromItemSize = fromItemList.size();
                int baseTableIndex = -1;
                LinkedHashMap<String, FromClause> joinedTables = new LinkedHashMap<String, FromClause>();
                LinkedHashMap newInnerJoinedTables = new LinkedHashMap();
                StringBuffer joinTable = new StringBuffer();
                boolean joinPresent = false;
                for (int fis = 0; fis < fromItemSize; ++fis) {
                    FromTable ft2 = (FromTable)fromItemList.get(fis);
                    if (ft2 != null && ft2.getJoinClause() == null) {
                        Vector newFromItems;
                        FromClause newFromClause;
                        if (joinTable.length() > 0) {
                            newFromClause = new FromClause();
                            newFromItems = new Vector();
                            newFromItems.addAll(fromItemList.subList(baseTableIndex, fis));
                            newFromClause.setFromItemList(newFromItems);
                            newFromClause.setOpenBraces("(");
                            newFromClause.setClosedBraces(")");
                            joinedTables.put(joinTable.toString(), newFromClause);
                            joinTable = new StringBuffer();
                        }
                        baseTableIndex = fis;
                        if (remainingFromItemList.contains(ft2)) continue;
                        if (ft2.getAliasName() != null) {
                            joinTable.append("&" + ft2.getAliasName().trim() + "&");
                        } else {
                            joinTable.append("&" + ft2.getTableName().toString().trim() + "&");
                        }
                        if (fis != fromItemSize - 1) continue;
                        newFromClause = new FromClause();
                        newFromItems = new Vector();
                        newFromItems.add(fromItemList.get(fis));
                        newFromClause.setFromItemList(newFromItems);
                        newFromClause.setOpenBraces("(");
                        newFromClause.setClosedBraces(")");
                        joinedTables.put(joinTable.toString(), newFromClause);
                        continue;
                    }
                    if (ft2 != null && ft2.getJoinClause() != null) {
                        joinPresent = true;
                        if (ft2.getAliasName() != null) {
                            joinTable.append("-&" + ft2.getAliasName().trim() + "&");
                            continue;
                        }
                        joinTable.append("-&" + ft2.getTableName().toString().trim() + "&");
                        continue;
                    }
                    if (ft2 != null) continue;
                    baseTableIndex = fis;
                }
                if (!joinPresent) break block72;
                Vector randomInnerJoinCondition = this.getJoinConditionsFromWhereExpression(whereExpression, from_sqs);
                Vector innerJoinCondition = null;
                innerJoinCondition = fromItemList.indexOf(null) == -1 ? this.arrangeTheWhereItemListAccordingToTheOrderInFromItemList(randomInnerJoinCondition, fromItemList) : randomInnerJoinCondition;
                int innerJoinConditionSize = innerJoinCondition.size();
                LinkedHashMap<String, WhereExpression> innerJoinTables = new LinkedHashMap<String, WhereExpression>();
                for (int ijc = 0; ijc < innerJoinConditionSize; ++ijc) {
                    WhereItem wi = null;
                    if (innerJoinCondition.get(ijc) instanceof WhereItem) {
                        wi = (WhereItem)innerJoinCondition.get(ijc);
                    }
                    ArrayList leftExpAliases = this.getTableAliasesWhereL(wi);
                    ArrayList rightExpAliases = this.getTableAliasesWhereR(wi);
                    StringBuffer hashBuf = new StringBuffer();
                    for (int k = 0; k < leftExpAliases.size(); ++k) {
                        if (k == leftExpAliases.size() - 1) {
                            hashBuf.append("&" + leftExpAliases.get(k).toString().trim() + "&-");
                            continue;
                        }
                        hashBuf.append("&" + leftExpAliases.get(k).toString().trim() + "&-");
                    }
                    for (int j = 0; j < rightExpAliases.size(); ++j) {
                        if (j == rightExpAliases.size() - 1) {
                            hashBuf.append("&" + rightExpAliases.get(j).toString().trim() + "&-");
                            continue;
                        }
                        hashBuf.append("&" + rightExpAliases.get(j).toString().trim() + "&-");
                    }
                    String hashKey = hashBuf.substring(0, hashBuf.lastIndexOf("-")).toString();
                    String existingKey = null;
                    if (innerJoinTables.containsKey(hashKey)) {
                        existingKey = hashKey;
                    } else if (hashKey.indexOf("-") == hashKey.lastIndexOf("-")) {
                        existingKey = this.getPartialMatchKey(innerJoinTables.keySet().iterator(), hashKey);
                    }
                    if (existingKey != null) {
                        Object oldObj = innerJoinTables.get(existingKey);
                        if (oldObj instanceof WhereExpression) {
                            ((WhereExpression)oldObj).addWhereItem(wi);
                            ((WhereExpression)oldObj).addOperator("AND");
                            continue;
                        }
                        if (!(oldObj instanceof WhereItem)) continue;
                        WhereExpression newWhereExp = new WhereExpression();
                        WhereItem oldItem = (WhereItem)oldObj;
                        newWhereExp.addWhereItem(oldItem);
                        newWhereExp.addOperator("AND");
                        newWhereExp.addWhereItem(wi);
                        innerJoinTables.put(hashKey, newWhereExp);
                        continue;
                    }
                    WhereExpression newWhereExp = new WhereExpression();
                    newWhereExp.addWhereItem(wi);
                    innerJoinTables.put(hashKey, newWhereExp);
                }
                ArrayList enOut = new ArrayList(innerJoinTables.keySet());
                Object keyOut = null;
                Vector<FromTable> reorderedRemainingFromItems = new Vector<FromTable>();
                Vector<FromTable> reorderedFromItems = new Vector<FromTable>(fromItemList.size());
                for (int ni = 0; ni < fromItemList.size(); ++ni) {
                    reorderedFromItems.add(null);
                }
                int remaininingFromItemsSize = remainingFromItemList.size();
                Vector fromItemListCopy = new Vector(fromItemList.size());
                fromItemListCopy.addAll(fromItemList);
                Vector<String> prevTables = new Vector<String>();
                for (int rf = 0; rf < fromItemListCopy.size(); ++rf) {
                    ft = (FromTable)fromItemListCopy.get(rf);
                    if (ft == null) continue;
                    String alias = ft.getAliasName();
                    if (alias == null) {
                        alias = ft.getTableName().toString().trim();
                    }
                    alias = "&" + alias + "&";
                    String key = this.getPartialMatchKey(innerJoinTables.keySet().iterator(), alias);
                    if (key != null) {
                        int insertIndex;
                        String leftExpAlias = key.substring(1, key.indexOf("-") - 1);
                        String rightExpAlias = key.substring(key.indexOf("-") + 2, key.length() - 1);
                        String joinKey = this.getPartialMatchKey(joinedTables.keySet().iterator(), "&" + leftExpAlias + "&");
                        if (key.startsWith(alias)) {
                            insertIndex = rf;
                            FromTable ft1 = null;
                            for (int j = rf; j < fromItemListCopy.size(); ++j) {
                                ft1 = (FromTable)fromItemListCopy.get(j);
                                if (ft1 == null) continue;
                                String ft1Alias = ft1.getAliasName();
                                if (ft1Alias == null) {
                                    ft1Alias = ft1.getTableName().toString();
                                }
                                if (!ft1Alias.equalsIgnoreCase(rightExpAlias)) continue;
                                insertIndex = j;
                                break;
                            }
                            if (insertIndex != rf) {
                                if (ft.getJoinClause() != null) {
                                    if (reorderedFromItems.indexOf(null) < insertIndex) {
                                        reorderedFromItems.add(reorderedFromItems.indexOf(null), ft);
                                        reorderedFromItems.add(reorderedFromItems.indexOf(null), ft1);
                                    } else {
                                        reorderedFromItems.add(insertIndex, ft1);
                                        reorderedFromItems.add(insertIndex, ft);
                                    }
                                } else if (ft1.getJoinClause() != null) {
                                    reorderedFromItems.add(reorderedFromItems.indexOf(null), ft);
                                    reorderedFromItems.add(reorderedFromItems.indexOf(null), ft1);
                                } else {
                                    reorderedFromItems.add(reorderedFromItems.indexOf(null), ft1);
                                    reorderedFromItems.add(reorderedFromItems.indexOf(null), ft);
                                }
                                fromItemListCopy.setElementAt(null, rf);
                                fromItemListCopy.setElementAt(null, insertIndex);
                                continue;
                            }
                            reorderedFromItems.add(reorderedFromItems.indexOf(null), ft);
                            fromItemListCopy.setElementAt(null, rf);
                            continue;
                        }
                        if (key.endsWith(alias)) {
                            insertIndex = rf;
                            int loopSize = fromItemListCopy.size();
                            FromTable ft1 = null;
                            for (int j = 0; j < loopSize; ++j) {
                                ft1 = (FromTable)fromItemListCopy.get(j);
                                if (ft1 == null) continue;
                                String ft1Alias = ft1.getAliasName();
                                if (ft1Alias == null) {
                                    ft1Alias = ft1.getTableName().toString();
                                }
                                if (!ft1Alias.equalsIgnoreCase(leftExpAlias)) continue;
                                insertIndex = j;
                                break;
                            }
                            if (insertIndex != rf) {
                                if (ft.getJoinClause() != null) {
                                    reorderedFromItems.add(rf, ft1);
                                    reorderedFromItems.add(rf, ft);
                                } else {
                                    reorderedFromItems.add(rf, ft);
                                    reorderedFromItems.insertElementAt(ft1, rf);
                                }
                                fromItemListCopy.setElementAt(null, rf);
                                fromItemListCopy.setElementAt(null, insertIndex);
                                continue;
                            }
                            reorderedFromItems.add(reorderedFromItems.indexOf(null), ft);
                            fromItemListCopy.setElementAt(null, rf);
                            continue;
                        }
                        reorderedFromItems.add(reorderedFromItems.indexOf(null), ft);
                        fromItemListCopy.setElementAt(null, rf);
                        continue;
                    }
                    if (reorderedFromItems.elementAt(rf) == null) {
                        if (ft.getJoinClause() != null) {
                            reorderedFromItems.add(reorderedFromItems.indexOf(null), ft);
                        } else if (rf == 0) {
                            reorderedFromItems.insertElementAt(ft, rf);
                        } else {
                            reorderedFromItems.add(ft);
                        }
                    } else if (ft.getJoinClause() != null) {
                        reorderedFromItems.add(reorderedFromItems.indexOf(null), ft);
                    } else {
                        reorderedFromItems.insertElementAt(ft, rf);
                    }
                    fromItemListCopy.setElementAt(null, rf);
                }
                for (int rei = 0; rei < fromItemList.size(); ++rei) {
                    ft = (FromTable)reorderedFromItems.get(rei);
                    if (ft == null) continue;
                    String ftName = ft.getAliasName();
                    if (ftName == null) {
                        ftName = ft.getTableName().toString();
                    }
                    for (int rrei = 0; rrei < remainingFromItemList.size(); ++rrei) {
                        FromTable ft1 = (FromTable)remainingFromItemList.get(rrei);
                        String ft1Name = ft1.getAliasName();
                        if (ft1Name == null) {
                            ft1Name = ft1.getTableName().toString();
                        }
                        if (!ftName.equalsIgnoreCase(ft1Name)) continue;
                        reorderedRemainingFromItems.add(ft);
                    }
                }
                remainingFromItemList.removeAll(reorderedRemainingFromItems);
                reorderedRemainingFromItems.addAll(remainingFromItemList);
                Vector tablesWithoutJoins = new Vector();
                FromClause fromClauseWithInnerJoin = new FromClause();
                fromClauseWithInnerJoin.setFromClause("FROM");
                Vector<Object> fromClauseWithInnerJoinItems = new Vector<Object>();
                if (innerJoinTables.isEmpty()) {
                    fromClauseWithInnerJoinItems.addAll(joinedTables.values());
                    fromClauseWithInnerJoinItems.addAll(reorderedRemainingFromItems);
                } else {
                    int swapPosition = 1;
                    for (int rfy = 0; rfy < reorderedFromItems.size(); ++rfy) {
                        FromTable ft3 = (FromTable)reorderedFromItems.get(rfy);
                        if (ft3 == null) continue;
                        String alias = ft3.getAliasName();
                        if (alias == null) {
                            alias = ft3.getTableName().toString().trim();
                        }
                        alias = "&" + alias + "&";
                        boolean keyAdded = false;
                        String key = null;
                        if (fromClauseWithInnerJoinItems.size() == 0) {
                            fromClauseWithInnerJoinItems.add(ft3);
                            prevTables.add(alias);
                        } else {
                            if (ft3.getJoinClause() != null) continue;
                            if (!innerJoinTables.isEmpty()) {
                                Iterator len = innerJoinTables.keySet().iterator();
                                while (len.hasNext()) {
                                    key = len.next().toString();
                                    int ind = key.toLowerCase().indexOf(alias.toLowerCase());
                                    if (ind == -1) continue;
                                    FromTable newFt = new FromTable();
                                    newFt.setJoinClause("INNER JOIN");
                                    newFt.setOnOrUsingJoin("ON");
                                    Vector we = new Vector();
                                    key = this.getValidKeyforInnerJoinCondition(innerJoinTables, prevTables, alias);
                                    if (key.equalsIgnoreCase("")) {
                                        if (fromItemListCopy.size() <= rfy + swapPosition) break;
                                        reorderedFromItems.add(rfy + swapPosition, (FromTable)reorderedFromItems.remove(rfy));
                                        reorderedFromItems.add(rfy, (FromTable)reorderedFromItems.remove(rfy + swapPosition - 1));
                                        --rfy;
                                        ++swapPosition;
                                        keyAdded = true;
                                        break;
                                    }
                                    swapPosition = 1;
                                    we.add(innerJoinTables.get(key));
                                    innerJoinTables.remove(key);
                                    FromClause newFtFC = new FromClause();
                                    Vector<FromTable> newFtFCItems = new Vector<FromTable>();
                                    newFtFCItems.add(ft3);
                                    newFtFC.setFromItemList(newFtFCItems);
                                    newFt.setTableName(newFtFC);
                                    newFt.setJoinExpression(we);
                                    fromClauseWithInnerJoinItems.add(newFt);
                                    keyAdded = true;
                                    prevTables.add(alias);
                                    break;
                                }
                                if (!keyAdded) {
                                    swapPosition = 1;
                                    fromClauseWithInnerJoinItems.add(ft3);
                                    prevTables.add(alias);
                                }
                            } else {
                                swapPosition = 1;
                                fromClauseWithInnerJoinItems.add(ft3);
                            }
                        }
                        FromTable joinFromTable = this.getJoinTableForTheFromItem(ft3, joinedTables, reorderedFromItems);
                        while (joinFromTable != null) {
                            fromClauseWithInnerJoinItems.add(joinFromTable);
                            String jAlias = joinFromTable.getAliasName();
                            if (jAlias == null) {
                                jAlias = joinFromTable.getTableName().toString();
                            }
                            jAlias = "&" + jAlias + "&";
                            prevTables.add(jAlias);
                            joinFromTable = this.getJoinTableForTheFromItem(ft3, joinedTables, reorderedFromItems);
                        }
                    }
                }
                if (!innerJoinTables.isEmpty() && !newInnerJoinedTables.isEmpty()) {
                    boolean fromClauseAdded = false;
                    Iterator en = innerJoinTables.keySet().iterator();
                    String key = null;
                    while (en.hasNext()) {
                        key = en.next().toString();
                        String joinedTableName1 = key.substring(0, key.indexOf("-")).toLowerCase();
                        String joinedTableName2 = key.substring(key.indexOf("-") + 1).toLowerCase();
                        Iterator en2 = newInnerJoinedTables.keySet().iterator();
                        String en2Key = null;
                        while (en2.hasNext()) {
                            en2Key = en2.next().toString();
                            if (en2Key.toLowerCase().indexOf(joinedTableName1) == -1 && en2Key.toLowerCase().indexOf(joinedTableName2) == -1) continue;
                            FromClause newInnerJoinTable = (FromClause)newInnerJoinedTables.get(en2Key);
                            ((WhereExpression)newInnerJoinTable.getFirstElement().getJoinExpression().lastElement()).getOperator().add("AND");
                            ((WhereExpression)newInnerJoinTable.getFirstElement().getJoinExpression().lastElement()).getWhereItems().add(innerJoinTables.get(key));
                            fromClauseAdded = true;
                            break;
                        }
                        if (!fromClauseAdded) continue;
                        newInnerJoinedTables.remove(en2Key);
                    }
                } else if (!innerJoinTables.isEmpty()) {
                    Iterator inIt = innerJoinTables.values().iterator();
                    while (inIt.hasNext()) {
                        if (!whereExpression.getWhereItems().isEmpty()) {
                            whereExpression.getOperator().add("AND");
                        }
                        whereExpression.getWhereItems().add(inIt.next());
                    }
                }
                fromClauseWithInnerJoinItems.addAll(tablesWithoutJoins);
                fromClauseWithInnerJoin.setFromItemList(fromClauseWithInnerJoinItems);
                return fromClauseWithInnerJoin;
            }
            catch (ArrayIndexOutOfBoundsException ae) {
                ae.printStackTrace();
                throw new ConvertException("Conversion failed.");
            }
        }
        return null;
    }

    private FromTable getJoinTableForTheFromItem(FromTable ft, LinkedHashMap joinMap, Vector fromItems) {
        FromTable joinFt = null;
        String alias = ft.getAliasName();
        if (ft.getAliasName() == null) {
            alias = ft.getTableName().toString();
        }
        alias = "&" + alias + "&";
        String jKey = this.getPartialMatchKey(joinMap.keySet().iterator(), alias);
        if (jKey != null) {
            int size = fromItems.size();
            for (int i = 0; i < size; ++i) {
                if (fromItems.get(i) instanceof FromTable) {
                    joinFt = (FromTable)fromItems.get(i);
                    String joinAlias = joinFt.getAliasName();
                    if (joinAlias == null) {
                        joinAlias = joinFt.getTableName().toString();
                    }
                    if (jKey.indexOf(joinAlias = "&" + joinAlias + "&") != -1 && !alias.equalsIgnoreCase(joinAlias)) {
                        String[] jKeyTables = jKey.split("-");
                        if (jKeyTables.length > 2) {
                            String newJoinKey = "";
                            int len = jKeyTables.length;
                            for (int s = 0; s < len; ++s) {
                                if (jKeyTables[s].equalsIgnoreCase(joinAlias)) continue;
                                if (s != 0) {
                                    newJoinKey = newJoinKey + "-";
                                }
                                newJoinKey = newJoinKey + jKeyTables[s];
                            }
                            joinMap.put(newJoinKey, joinMap.get(jKey));
                        }
                        joinMap.remove(jKey);
                        break;
                    }
                }
                joinFt = null;
            }
        }
        return joinFt;
    }

    private String getValidKeyforInnerJoinCondition(LinkedHashMap joinMap, Vector prevTables, String currentTableAlias) {
        String key = "";
        Iterator it = joinMap.keySet().iterator();
        block0: while (it.hasNext() && key.equalsIgnoreCase("")) {
            String key1 = it.next().toString().toLowerCase();
            String[] keyTables = null;
            keyTables = key1.split("-");
            for (int i = prevTables.size(); i > 0; --i) {
                String prevTableAlias = prevTables.get(i - 1).toString();
                if (key1.indexOf("-") == key1.lastIndexOf("-")) {
                    if (key1.indexOf(prevTableAlias) == -1 || key1.indexOf(currentTableAlias) == -1) continue;
                    key = key1;
                    continue block0;
                }
                boolean canJoin = true;
                int size = keyTables.length;
                for (int kt = 0; kt < size; ++kt) {
                    if (keyTables[kt].equalsIgnoreCase(currentTableAlias) || prevTables.contains(keyTables[kt])) continue;
                    canJoin = false;
                    break;
                }
                if (!canJoin) continue;
                key = key1;
                continue block0;
            }
        }
        return key;
    }

    private void setNewFromClauseWithANSIJoin(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs, int database, WhereExpression whereExpression) throws ConvertException {
        block109: {
            boolean fromAndWhereChanged;
            FromClause newFromClause;
            block111: {
                Vector whereItemList;
                Vector CheckOuterFromList;
                Vector fromItemList;
                FromClause fromClause;
                block110: {
                    FromClause tempFromClause;
                    FromTable ft;
                    boolean isInformixOuterJoin = false;
                    if (from_sqs == null) {
                        return;
                    }
                    fromClause = to_sqs.getFromClause();
                    this.removedFromItemsList = new Vector();
                    if (fromClause == null) break block109;
                    newFromClause = new FromClause();
                    Vector<FromTable> newFromItemList = new Vector<FromTable>();
                    newFromClause.setFromClause("FROM");
                    newFromClause.setFromItemList(newFromItemList);
                    newFromClause.setObjectContext(this.context);
                    fromItemList = fromClause.getFromItemList();
                    CheckOuterFromList = fromClause.changeOrderForOuter(fromItemList);
                    for (int i = 0; i < fromItemList.size(); ++i) {
                        FromTable newFromTable;
                        if (!(fromItemList.get(i) instanceof FromTable) || (newFromTable = (FromTable)fromItemList.get(i)).getOuter() == null) continue;
                        isInformixOuterJoin = true;
                    }
                    whereItemList = new Vector();
                    Vector operatorList = new Vector();
                    this.loadWhereItemsOperators(whereItemList, operatorList);
                    int size = fromItemList.size();
                    if (size < whereItemList.size()) {
                        size = whereItemList.size();
                    }
                    Vector[] joinExpression = new Vector[size];
                    fromAndWhereChanged = false;
                    if (isInformixOuterJoin) break block110;
                    if (database == 1) {
                        whereItemList = this.arrangeTheWhereItemListAccordingToTheOrderInFromItemList(whereItemList, fromItemList);
                    }
                    this.groupWhereItems(whereItemList, joinExpression, to_sqs, from_sqs, database);
                    this.orderWhereItems(whereItemList, joinExpression);
                    int index = 0;
                    boolean isRemainingFromListItemsAdded = false;
                    WhereExpression we = new WhereExpression();
                    we.setObjectContext(this.context);
                    for (int i = 0; i < whereItemList.size(); ++i) {
                        String str2;
                        String tableAliasR;
                        WhereItem wit = (WhereItem)whereItemList.get(i);
                        fromAndWhereChanged = true;
                        String tableAliasL = this.getTableAliasWhereL(wit);
                        if (i == 0) {
                            String str3;
                            if (tableAliasL != null) {
                                newFromItemList.add(index, this.getFromItemAfterConversion(fromItemList, tableAliasL, database));
                            } else {
                                FromTable ft1 = null;
                                ft1 = this.getFromTableForNoAlias(wit, false, from_sqs, fromItemList, database);
                                newFromItemList.add(index, ft1);
                            }
                            FromTable removedFromTbl = (FromTable)newFromItemList.get(index);
                            if (removedFromTbl != null && removedFromTbl.getAliasName() == null) {
                                this.removedFromItemsList.add(removedFromTbl);
                            }
                            ++index;
                            tableAliasR = this.getTableAliasWhereR(wit);
                            ft = null;
                            ft = tableAliasR != null ? this.getFromItemAfterConversion(fromItemList, tableAliasR, database) : this.getFromTableForNoAlias(wit, true, from_sqs, fromItemList, database);
                            if (ft != null && ft.getAliasName() == null) {
                                this.removedFromItemsList.add(ft);
                            }
                            if ((str3 = this.getJoinType(wit, ft)) == null) {
                                if (we.getWhereItems() != null && !we.getWhereItems().isEmpty()) {
                                    we.addOperator("AND");
                                }
                                if (joinExpression != null && joinExpression[i] != null && !joinExpression[i].isEmpty() && joinExpression[i].get(0) instanceof WhereExpression) {
                                    we.addWhereExpression((WhereExpression)joinExpression[i].get(0));
                                    continue;
                                }
                                we.addWhereItem(wit);
                                wit.setLeftJoin(null);
                                wit.setRightJoin(null);
                                continue;
                            }
                            ft.setJoinClause(str3);
                            ft.setOnOrUsingJoin(" ON ");
                            if (this.selectStmtInJoin) {
                                WhereExpression we1 = (WhereExpression)joinExpression[i].get(0);
                                WhereItem wi1 = (WhereItem)we1.getWhereItems().get(0);
                                wi1.setRightWhereExp(wit.getRightWhereExp());
                                joinExpression[i].remove(0);
                                joinExpression[i].add(0, we1);
                                this.selectStmtInJoin = false;
                            }
                            ft.setJoinExpression(joinExpression[i]);
                            newFromItemList.add(index, ft);
                            ++index;
                            continue;
                        }
                        FromTable ft2 = this.getFromItemAfterConversion(fromItemList, tableAliasL, database);
                        if (ft2 == null) {
                            tableAliasR = this.getTableAliasWhereR(wit);
                            ft2 = tableAliasR != null ? this.getFromItemAfterConversion(fromItemList, tableAliasR, database) : this.getFromTableForNoAlias(wit, true, from_sqs, fromItemList, database);
                        }
                        if (ft2 != null && ft2.getAliasName() == null) {
                            this.removedFromItemsList.add(ft2);
                        }
                        if ((str2 = this.getJoinType(ft2, whereItemList, i)) == null) {
                            if (we.getWhereItems() != null && !we.getWhereItems().isEmpty()) {
                                we.addOperator("AND");
                            }
                            wit.setLeftJoin(null);
                            wit.setRightJoin(null);
                            if (joinExpression != null && joinExpression[i] != null && !joinExpression[i].isEmpty() && joinExpression[i].get(0) instanceof WhereExpression) {
                                we.addWhereExpression((WhereExpression)joinExpression[i].get(0));
                                continue;
                            }
                            we.addWhereItem(wit);
                            continue;
                        }
                        ft2.setJoinClause(str2);
                        ft2.setOnOrUsingJoin(" ON ");
                        ft2.setJoinExpression(joinExpression[i]);
                        String tableAliasRight = this.getTableAliasWhereR(wit);
                        String tableAliasLeft = this.getTableAliasWhereL(wit);
                        if (!(ft2.getAliasName() != null && ft2.getAliasName().equalsIgnoreCase(tableAliasRight) || ft2.getAliasName() == null && ft2.getTableName().toString().equalsIgnoreCase(tableAliasRight))) {
                            FromTable tempFT;
                            FromTable remainingFromItems;
                            if (ft2.getAliasName() != null && ft2.getAliasName().equalsIgnoreCase(tableAliasLeft) || ft2.getAliasName() == null && ft2.getTableName().toString().equalsIgnoreCase(tableAliasLeft)) {
                                if (fromItemList.size() > 1) {
                                    int fromItemListSize = fromItemList.size();
                                    String tableAliasR2 = this.getTableAliasWhereR(wit);
                                    FromTable remainingFromItems2 = this.getFromItemAfterConversion(fromItemList, tableAliasR2, database);
                                    if (remainingFromItems2 != null && remainingFromItems2.getAliasName() == null) {
                                        this.removedFromItemsList.add(remainingFromItems2);
                                    }
                                    str2 = this.getJoinType(wit, remainingFromItems2);
                                    if (remainingFromItems2 != null) {
                                        remainingFromItems2.setJoinClause(str2);
                                        remainingFromItems2.setOnOrUsingJoin(" ON ");
                                        remainingFromItems2.setJoinExpression(ft2.getJoinExpression());
                                        ft2.setJoinClause(null);
                                        ft2.setJoinExpression(null);
                                        ft2.setOnOrUsingJoin(null);
                                        FromTable tempFT2 = ft2;
                                        ft2 = remainingFromItems2;
                                        remainingFromItems2 = tempFT2;
                                    }
                                    if (remainingFromItems2 != null) {
                                        if (i > fromItemList.size()) {
                                            newFromItemList.add(index, remainingFromItems2);
                                            ++index;
                                        } else {
                                            newFromItemList.add(index, remainingFromItems2);
                                            ++index;
                                        }
                                    }
                                    isRemainingFromListItemsAdded = true;
                                } else if (fromItemList.size() == 1) {
                                    String tableAliasR3 = this.getTableAliasWhereR(wit);
                                    remainingFromItems = this.getFromItemAfterConversion(fromItemList, tableAliasR3, database);
                                    if (remainingFromItems != null && remainingFromItems.getAliasName() == null) {
                                        this.removedFromItemsList.add(remainingFromItems);
                                    }
                                    str2 = this.getJoinType(wit, remainingFromItems);
                                    if (remainingFromItems != null) {
                                        remainingFromItems.setJoinClause(str2);
                                        remainingFromItems.setOnOrUsingJoin(" ON ");
                                        remainingFromItems.setJoinExpression(ft2.getJoinExpression());
                                        ft2.setJoinClause(null);
                                        ft2.setJoinExpression(null);
                                        ft2.setOnOrUsingJoin(null);
                                        tempFT = ft2;
                                        ft2 = remainingFromItems;
                                        remainingFromItems = tempFT;
                                    }
                                    if (remainingFromItems != null) {
                                        newFromItemList.add(index, remainingFromItems);
                                        ++index;
                                        isRemainingFromListItemsAdded = true;
                                    }
                                }
                            } else {
                                System.out.println("WhereExpression: It should never come here");
                                if (fromItemList.size() > 1) {
                                    int fromItemListSize = fromItemList.size();
                                    if (i > fromItemList.size()) {
                                        remainingFromItems = null;
                                        if (fromItemList.get(0) instanceof FromTable) {
                                            remainingFromItems = (FromTable)fromItemList.get(0);
                                        }
                                        if (remainingFromItems != null) {
                                            remainingFromItems.setJoinClause(str2);
                                            remainingFromItems.setOnOrUsingJoin(" ON ");
                                            remainingFromItems.setJoinExpression(ft2.getJoinExpression());
                                            ft2.setJoinClause(null);
                                            ft2.setJoinExpression(null);
                                            ft2.setOnOrUsingJoin(null);
                                            tempFT = ft2;
                                            ft2 = remainingFromItems;
                                            remainingFromItems = tempFT;
                                        }
                                        newFromItemList.add(index, remainingFromItems);
                                        ++index;
                                    } else {
                                        remainingFromItems = null;
                                        if (fromItemList.get(i - 1) instanceof FromTable) {
                                            remainingFromItems = (FromTable)fromItemList.get(i - 1);
                                        }
                                        if (remainingFromItems != null) {
                                            remainingFromItems.setJoinClause(str2);
                                            remainingFromItems.setOnOrUsingJoin(" ON ");
                                            remainingFromItems.setJoinExpression(ft2.getJoinExpression());
                                            ft2.setJoinClause(null);
                                            ft2.setJoinExpression(null);
                                            ft2.setOnOrUsingJoin(null);
                                            tempFT = ft2;
                                            ft2 = remainingFromItems;
                                            remainingFromItems = tempFT;
                                        }
                                        newFromItemList.add(index, remainingFromItems);
                                        ++index;
                                    }
                                    isRemainingFromListItemsAdded = true;
                                } else if (fromItemList.size() == 1 && ft2.getAliasName() != null) {
                                    FromTable remainingFromItems3 = null;
                                    if (fromItemList.get(0) instanceof FromTable) {
                                        remainingFromItems3 = (FromTable)fromItemList.get(0);
                                    }
                                    if (remainingFromItems3 != null) {
                                        remainingFromItems3.setJoinClause(str2);
                                        remainingFromItems3.setOnOrUsingJoin(" ON ");
                                        remainingFromItems3.setJoinExpression(ft2.getJoinExpression());
                                        ft2.setJoinClause(null);
                                        ft2.setJoinExpression(null);
                                        ft2.setOnOrUsingJoin(null);
                                        FromTable tempFT3 = ft2;
                                        ft2 = remainingFromItems3;
                                        remainingFromItems3 = tempFT3;
                                    }
                                    newFromItemList.add(index, remainingFromItems3);
                                    ++index;
                                    isRemainingFromListItemsAdded = true;
                                }
                            }
                        }
                        newFromItemList.add(index, ft2);
                        ++index;
                    }
                    if (we.getWhereItems() != null && !we.getWhereItems().isEmpty()) {
                        for (int wei = 0; wei < we.getWhereItems().size(); ++wei) {
                            WhereItem weWhereItem = null;
                            String weWhereItemLeftAlias = null;
                            Object weWhereItemRightAlias = null;
                            if (we.getWhereItems().get(wei) instanceof WhereItem) {
                                weWhereItem = (WhereItem)we.getWhereItems().get(wei);
                            } else if (we.getWhereItems().get(wei) instanceof WhereExpression && ((WhereExpression)we.getWhereItems().get(wei)).getWhereItems().lastElement() instanceof WhereItem) {
                                weWhereItem = (WhereItem)((WhereExpression)we.getWhereItems().get(wei)).getWhereItems().lastElement();
                            }
                            if (weWhereItem != null) {
                                weWhereItemLeftAlias = weWhereItem.getLeftWhereExp().getTableAlias();
                            }
                            boolean added = false;
                            for (int j = newFromItemList.size() - 1; j >= 0; --j) {
                                if (!(newFromItemList.get(j) instanceof FromTable) || (ft = (FromTable)newFromItemList.get(j)).getJoinExpression() == null || ft.getJoinExpression().isEmpty()) continue;
                                Vector joinExp = ft.getJoinExpression();
                                for (int k = joinExp.size() - 1; k >= 0; --k) {
                                    WhereExpression joinWhereExp;
                                    if (!(joinExp.get(k) instanceof WhereExpression) || !((joinWhereExp = (WhereExpression)joinExp.get(k)).getWhereItems().lastElement() instanceof WhereItem)) continue;
                                    WhereItem joinWhereItem = (WhereItem)joinWhereExp.getWhereItems().lastElement();
                                    String joinWhereItemLeftAlias = joinWhereItem.getLeftWhereExp().getTableAlias();
                                    String joinWhereItemRightAlias = joinWhereItem.getRightWhereExp().getTableAlias();
                                    if (weWhereItemLeftAlias != null && (joinWhereItemLeftAlias != null && weWhereItemLeftAlias.equalsIgnoreCase(joinWhereItemLeftAlias) || joinWhereItemRightAlias != null && weWhereItemLeftAlias.equalsIgnoreCase(joinWhereItemRightAlias))) {
                                        joinWhereExp.addWhereExpression(we);
                                        joinWhereExp.addOperator("AND");
                                        added = true;
                                        break;
                                    }
                                    if (weWhereItemLeftAlias != null) continue;
                                    joinWhereExp.addWhereExpression(we);
                                    joinWhereExp.addOperator("AND");
                                    added = true;
                                    break;
                                }
                                if (added) break;
                            }
                            if (added) continue;
                            if (whereExpression.getOperator().contains("AND") || whereExpression.getOperator().contains("and")) {
                                whereExpression.getOperator().add("AND");
                            } else if (whereExpression.getWhereItems().size() > 0 && whereExpression.getWhereItems().lastElement() != null) {
                                whereExpression.getOperator().add("AND");
                            }
                            whereExpression.getWhereItems().add(we.getWhereItems().get(wei));
                        }
                    }
                    if (fromItemList.size() <= 0) break block111;
                    for (int j = 0; j < fromItemList.size(); ++j) {
                        FromTable remainingFromItems = null;
                        if (fromItemList.get(j) instanceof FromTable) {
                            remainingFromItems = (FromTable)fromItemList.get(j);
                        }
                        newFromItemList.add(remainingFromItems);
                    }
                    if (database != 12 && database != 8 || (tempFromClause = this.handleInnerJoin(to_sqs, from_sqs, database, whereExpression, fromItemList, newFromClause)) == null) break block111;
                    newFromClause = tempFromClause;
                    break block111;
                }
                Vector outerTableNames = fromClause.getOuterFromTableNames(fromItemList);
                Hashtable whereItemsKeptInWhereClause = new Hashtable();
                Vector newWhereClause = new Vector();
                boolean isOuter = false;
                this.moveOuterWhereItemsAsANSIJoins(whereItemsKeptInWhereClause, whereItemList, outerTableNames);
                if (whereItemList.size() > 0) {
                    Vector Operators = whereExpression.getOperator();
                    boolean removeOpFollowingFirstExpression = false;
                    int getsize = Operators.size();
                    int count2 = 0;
                    for (int i = 0; i <= getsize; ++i) {
                        String key = "" + i;
                        if (whereItemsKeptInWhereClause.containsKey(key)) continue;
                        if (i - count2 != 0) {
                            if (Operators.size() <= 0) continue;
                            Operators.removeElementAt(i - 1 - count2);
                            ++count2;
                            continue;
                        }
                        if (Operators.size() <= 0) continue;
                        Operators.removeElementAt(i - count2);
                        ++count2;
                    }
                    whereExpression.setOperator(Operators);
                }
                for (int i = 0; i < whereItemsKeptInWhereClause.size() + whereItemList.size(); ++i) {
                    String key = "" + i;
                    if (whereItemsKeptInWhereClause.get(key) == null) continue;
                    Object obj = whereItemsKeptInWhereClause.get(key);
                    if (obj instanceof WhereItem) {
                        if (database == 1) {
                            obj = ((WhereItem)obj).toOracleSelect(to_sqs, from_sqs);
                        } else if (database == 2) {
                            obj = ((WhereItem)obj).toMSSQLServerSelect(to_sqs, from_sqs);
                        } else if (database == 7) {
                            obj = ((WhereItem)obj).toSybaseSelect(to_sqs, from_sqs);
                        } else if (database == 3) {
                            obj = ((WhereItem)obj).toDB2Select(to_sqs, from_sqs);
                        } else if (database == 5) {
                            obj = ((WhereItem)obj).toMySQLSelect(to_sqs, from_sqs);
                        } else if (database == 8) {
                            obj = ((WhereItem)obj).toANSISelect(to_sqs, from_sqs);
                        } else if (database == 4) {
                            obj = ((WhereItem)obj).toPostgreSQLSelect(to_sqs, from_sqs);
                        } else if (database == 6) {
                            obj = ((WhereItem)obj).toInformixSelect(to_sqs, from_sqs);
                        } else if (database == 10) {
                            obj = ((WhereItem)obj).toTimesTenSelect(to_sqs, from_sqs);
                        } else if (database == 11) {
                            obj = ((WhereItem)obj).toNetezzaSelect(to_sqs, from_sqs);
                        }
                    }
                    newWhereClause.add(obj);
                }
                whereExpression.setWhereItem(newWhereClause);
                Vector<String> tableOrAliasNameBeforeOuter = new Vector<String>();
                Vector<WhereItem> WhereItemsInOuter = new Vector<WhereItem>();
                boolean setAllTablesBeforeOuterasCrossJoin = false;
                for (int i = 0; i < CheckOuterFromList.size(); ++i) {
                    int k;
                    String innerJoinOnCondition = new String();
                    FromTable existingFromTable = (FromTable)CheckOuterFromList.get(i);
                    String tableOrAliasName = new String();
                    if (existingFromTable.getAliasName() != null) {
                        tableOrAliasName = existingFromTable.getAliasName();
                        tableOrAliasNameBeforeOuter.add(tableOrAliasName);
                    } else {
                        tableOrAliasName = existingFromTable.getTableName().toString();
                        tableOrAliasNameBeforeOuter.add(tableOrAliasName);
                    }
                    Vector<WhereItem> addJoinExpression = new Vector<WhereItem>();
                    if (existingFromTable.getOuter() != null || isOuter) {
                        FromTable previousFromTablesBeforeOuterTable;
                        int j;
                        fromAndWhereChanged = true;
                        if (!(setAllTablesBeforeOuterasCrossJoin || database != 2 && database != 4)) {
                            for (j = 1; j < i; ++j) {
                                previousFromTablesBeforeOuterTable = (FromTable)CheckOuterFromList.get(j);
                                previousFromTablesBeforeOuterTable.setJoinClause("CROSS JOIN");
                            }
                            setAllTablesBeforeOuterasCrossJoin = true;
                        } else if (!setAllTablesBeforeOuterasCrossJoin) {
                            for (j = 1; j < i; ++j) {
                                previousFromTablesBeforeOuterTable = (FromTable)CheckOuterFromList.get(j);
                                previousFromTablesBeforeOuterTable.setJoinClause("INNER JOIN");
                                previousFromTablesBeforeOuterTable.setOnOrUsingJoin("ON");
                                Vector<WhereItem> newWhereItems = new Vector<WhereItem>();
                                WhereItem newWhereItem = new WhereItem();
                                WhereColumn newWhereColumn = new WhereColumn();
                                Vector<String> whereColumnItems = new Vector<String>();
                                whereColumnItems.add("1");
                                newWhereColumn.setColumnExpression(whereColumnItems);
                                newWhereItem.setLeftWhereExp(newWhereColumn);
                                newWhereItem.setRightWhereExp(newWhereColumn);
                                newWhereItem.setOperator("=");
                                newWhereItems.add(newWhereItem);
                                previousFromTablesBeforeOuterTable.setJoinExpression(newWhereItems);
                            }
                            setAllTablesBeforeOuterasCrossJoin = true;
                        }
                        if (!isOuter) {
                            existingFromTable.setJoinClause("LEFT OUTER JOIN");
                        } else if (database == 2 || database == 4) {
                            existingFromTable.setJoinClause("CROSS JOIN");
                        } else {
                            existingFromTable.setJoinClause("INNER JOIN");
                            innerJoinOnCondition = "ON 1 = 1 ";
                        }
                        existingFromTable.setOuter(null);
                        if (existingFromTable.getOuterOpenBrace() != null) {
                            existingFromTable.setOuterOpenBrace(null);
                            isOuter = true;
                        }
                        if (whereItemList != null) {
                            for (j = 0; j < whereItemList.size(); ++j) {
                                String tableAliaswhere;
                                TableColumn tableColumn;
                                WhereItem whereItem = (WhereItem)whereItemList.get(j);
                                WhereColumn leftWhereExp = whereItem.getLeftWhereExp();
                                WhereColumn rightWhereExp = whereItem.getRightWhereExp();
                                String tableOrAliasNameForLeftExp = new String();
                                String tableOrAliasNameForRightExp = new String();
                                if (leftWhereExp != null && leftWhereExp.getColumnExpression().get(0) instanceof TableColumn) {
                                    tableColumn = new TableColumn();
                                    tableColumn = (TableColumn)leftWhereExp.getColumnExpression().get(0);
                                    tableOrAliasNameForLeftExp = tableColumn.getOwnerName() != null ? tableColumn.getOwnerName() + "." + tableColumn.getTableName() : tableColumn.getTableName();
                                }
                                if (leftWhereExp != null && leftWhereExp.getColumnExpression().get(0) instanceof String && (tableAliaswhere = (String)leftWhereExp.getColumnExpression().get(0)).indexOf(".") != -1) {
                                    tableOrAliasNameForLeftExp = tableAliaswhere.substring(0, tableAliaswhere.lastIndexOf("."));
                                }
                                if (rightWhereExp != null && rightWhereExp.getColumnExpression().get(0) instanceof TableColumn) {
                                    tableColumn = new TableColumn();
                                    tableColumn = (TableColumn)rightWhereExp.getColumnExpression().get(0);
                                    tableOrAliasNameForRightExp = tableColumn.getOwnerName() != null ? tableColumn.getOwnerName() + "." + tableColumn.getTableName() : tableColumn.getTableName();
                                }
                                if (rightWhereExp != null && rightWhereExp.getColumnExpression().get(0) instanceof String && (tableAliaswhere = (String)rightWhereExp.getColumnExpression().get(0)).indexOf(".") != -1) {
                                    tableOrAliasNameForRightExp = tableAliaswhere.substring(0, tableAliaswhere.lastIndexOf("."));
                                }
                                if (!(tableOrAliasName.equalsIgnoreCase(tableOrAliasNameForRightExp) && tableOrAliasNameBeforeOuter.contains(tableOrAliasNameForLeftExp) || tableOrAliasName.equalsIgnoreCase(tableOrAliasNameForLeftExp) && tableOrAliasNameBeforeOuter.contains(tableOrAliasNameForRightExp)) && (!tableOrAliasName.equalsIgnoreCase(tableOrAliasNameForLeftExp) || rightWhereExp == null || !(rightWhereExp.getColumnExpression().get(0) instanceof String))) continue;
                                if (!isOuter) {
                                    if (WhereItemsInOuter.size() == 0) {
                                        addJoinExpression.add(whereItem);
                                        existingFromTable.setOnOrUsingJoin("ON");
                                    }
                                    if (j <= 0) continue;
                                    whereItem.setOperator1("AND");
                                    continue;
                                }
                                WhereItemsInOuter.add(whereItem);
                                if (WhereItemsInOuter.size() <= 1) continue;
                                whereItem.setOperator1("AND");
                            }
                            existingFromTable.setJoinExpression(addJoinExpression);
                        }
                        if (existingFromTable.getOuterClosedBrace() != null) {
                            existingFromTable.setOuterClosedBrace(null);
                            existingFromTable.setOnOrUsingJoin(innerJoinOnCondition + "ON");
                            isOuter = false;
                            for (k = 0; k < WhereItemsInOuter.size(); ++k) {
                                addJoinExpression.add((WhereItem)WhereItemsInOuter.get(k));
                            }
                        }
                    }
                    if (existingFromTable.getOuterClosedBrace() != null) {
                        existingFromTable.setOuterClosedBrace(null);
                        existingFromTable.setOnOrUsingJoin(innerJoinOnCondition + "ON");
                        for (k = 0; k < WhereItemsInOuter.size(); ++k) {
                            addJoinExpression.add((WhereItem)WhereItemsInOuter.get(k));
                        }
                    }
                    newFromClause.setFromItemList(CheckOuterFromList);
                }
            }
            if (fromAndWhereChanged) {
                to_sqs.setFromClause(newFromClause);
            }
        }
    }

    private FromTable getFromItem(Vector fromItemList, String tableAliasWhere) {
        for (int i = 0; i < fromItemList.size(); ++i) {
            FromTable ft = (FromTable)fromItemList.get(i);
            if (ft.getAliasName() != null && CustomizeUtil.compareQuotedIdentifiers(ft.getAliasName(), tableAliasWhere, false)) {
                fromItemList.remove(i);
                return ft;
            }
            if (!CustomizeUtil.compareQuotedIdentifiers(ft.getTableName().toString(), tableAliasWhere, false)) continue;
            fromItemList.remove(i);
            return ft;
        }
        return null;
    }

    private FromTable getFromItemAfterConversion(Vector fromItemList, String tableAliasWhere, int database) throws ConvertException {
        if (this.removedFromItemsList != null) {
            for (int j = 0; j < this.removedFromItemsList.size(); ++j) {
                FromTable removedFromTable = (FromTable)this.removedFromItemsList.get(j);
                if (removedFromTable.getAliasName() != null && CustomizeUtil.compareQuotedIdentifiers(removedFromTable.getAliasName(), tableAliasWhere, true)) {
                    return null;
                }
                if (tableAliasWhere == null || !CustomizeUtil.compareQuotedIdentifiers(tableAliasWhere, removedFromTable.getTableName().toString(), true)) continue;
                return null;
            }
        }
        for (int i = 0; i < fromItemList.size(); ++i) {
            FromTable ft = (FromTable)fromItemList.get(i);
            if (ft.getAliasName() != null && CustomizeUtil.compareQuotedIdentifiers(ft.getAliasName(), tableAliasWhere, true)) {
                fromItemList.remove(i);
                return ft.convert(null, null, database);
            }
            if (tableAliasWhere == null || !CustomizeUtil.compareQuotedIdentifiers(tableAliasWhere, ft.getTableName().toString(), true)) continue;
            fromItemList.remove(i);
            return ft.convert(null, null, database);
        }
        return null;
    }

    private String getTableAliasWhereL(WhereItem wit) {
        WhereColumn wcl = wit.getLeftWhereExp();
        if (wcl != null && wcl.getColumnExpression() != null && wcl.getColumnExpression().size() > 0) {
            for (int i = 0; i < wcl.getColumnExpression().size(); ++i) {
                String tableAliaswhere;
                String tableName;
                if (wcl.getColumnExpression().get(i) instanceof TableColumn) {
                    TableColumn tc = (TableColumn)wcl.getColumnExpression().get(i);
                    if (tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier && SwisSQLOptions.fullyQualifiedWithDatabaseName && !tc.getOwnerName().equalsIgnoreCase("dbo") && this.targetDatabase == 7) {
                        return tc.getOwnerName() + "." + "dbo." + tc.getTableName();
                    }
                    if (tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier) {
                        return tc.getOwnerName() + "." + tc.getTableName();
                    }
                    return tc.getTableName();
                }
                if (wcl.getColumnExpression().get(i) instanceof FunctionCalls) {
                    tableName = this.getTableAliasName((FunctionCalls)wcl.getColumnExpression().get(i));
                    if (tableName == null || tableName.equals("")) continue;
                    return tableName;
                }
                if (wcl.getColumnExpression().get(i) instanceof CaseStatement) {
                    CaseStatement cs = (CaseStatement)wcl.getColumnExpression().get(i);
                    String tableName2 = this.getTableAliasName(cs);
                    if (tableName2 == null || tableName2.equals("")) continue;
                    return tableName2;
                }
                if (wcl.getColumnExpression().get(i) instanceof SelectColumn) {
                    tableName = this.getTableAliasWhereR((SelectColumn)wcl.getColumnExpression().get(i));
                    if (tableName == null || tableName.equals("")) continue;
                    return tableName;
                }
                if (!(wcl.getColumnExpression().get(i) instanceof String) || (tableAliaswhere = (String)wcl.getColumnExpression().get(i)).indexOf(".") == -1 || tableAliaswhere.startsWith("/*") && tableAliaswhere.endsWith("*/")) continue;
                return tableAliaswhere.substring(i, tableAliaswhere.indexOf("."));
            }
        }
        return null;
    }

    private String getTableAliasWhereR(WhereItem wit) {
        WhereColumn wcr = wit.getRightWhereExp();
        if (wcr != null && wcr.getColumnExpression() != null && wcr.getColumnExpression().size() > 0) {
            for (int i = 0; i < wcr.getColumnExpression().size(); ++i) {
                String tableName;
                if (wcr.getColumnExpression().get(i) instanceof TableColumn) {
                    TableColumn tc = (TableColumn)wcr.getColumnExpression().get(i);
                    if (tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier && SwisSQLOptions.fullyQualifiedWithDatabaseName && !tc.getOwnerName().equalsIgnoreCase("dbo") && this.targetDatabase == 7) {
                        return tc.getOwnerName() + "." + "dbo." + tc.getTableName();
                    }
                    if (tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier) {
                        return tc.getOwnerName() + "." + tc.getTableName();
                    }
                    return tc.getTableName();
                }
                if (wcr.getColumnExpression().get(i) instanceof FunctionCalls) {
                    tableName = this.getTableAliasName((FunctionCalls)wcr.getColumnExpression().get(i));
                    if (tableName == null || tableName.equals("")) continue;
                    return tableName;
                }
                if (wcr.getColumnExpression().get(i) instanceof CaseStatement) {
                    CaseStatement cs = (CaseStatement)wcr.getColumnExpression().get(i);
                    String tableName2 = this.getTableAliasName(cs);
                    if (tableName2 == null || tableName2.equals("")) continue;
                    return tableName2;
                }
                if (wcr.getColumnExpression().get(i) instanceof SelectColumn) {
                    tableName = this.getTableAliasWhereR((SelectColumn)wcr.getColumnExpression().get(i));
                    if (tableName == null || tableName.equals("")) continue;
                    return tableName;
                }
                if (!(wcr.getColumnExpression().get(i) instanceof String)) continue;
                String tableAliaswhere = (String)wcr.getColumnExpression().get(i);
                if (tableAliaswhere.startsWith("'")) {
                    return "";
                }
                if (tableAliaswhere.indexOf(".") == -1 || tableAliaswhere.startsWith("/*") && tableAliaswhere.endsWith("*/")) continue;
                if (tableAliaswhere.indexOf(".") != tableAliaswhere.lastIndexOf(".")) {
                    if (SwisSQLOptions.removeDBSchemaQualifier) {
                        return tableAliaswhere.substring(tableAliaswhere.indexOf(".") + 1, tableAliaswhere.lastIndexOf("."));
                    }
                    return tableAliaswhere.substring(0, tableAliaswhere.lastIndexOf("."));
                }
                return tableAliaswhere.substring(0, tableAliaswhere.indexOf("."));
            }
        }
        return null;
    }

    private ArrayList getTableAliasesWhereL(WhereItem wit) {
        ArrayList<String> list = new ArrayList<String>();
        WhereColumn wcl = wit.getLeftWhereExp();
        if (wcl != null && wcl.getColumnExpression() != null && wcl.getColumnExpression().size() > 0) {
            for (int i = 0; i < wcl.getColumnExpression().size(); ++i) {
                String tableAliaswhere;
                String tableName;
                if (wcl.getColumnExpression().get(i) instanceof TableColumn) {
                    TableColumn tc = (TableColumn)wcl.getColumnExpression().get(i);
                    if (tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier) {
                        list.add(tc.getOwnerName() + "." + tc.getTableName());
                        continue;
                    }
                    list.add(tc.getTableName());
                    continue;
                }
                if (wcl.getColumnExpression().get(i) instanceof FunctionCalls) {
                    String tableName1;
                    FunctionCalls fcl = (FunctionCalls)wcl.getColumnExpression().get(i);
                    tableName = this.getTableAliasName(fcl);
                    if (tableName != null && !tableName.equals("")) {
                        list.add(tableName);
                    }
                    if (fcl.getFunctionName() == null || !fcl.getFunctionName().getColumnName().equalsIgnoreCase("COALESCE") || (tableName1 = this.getTableAliasWhereR((SelectColumn)fcl.getFunctionArguments().get(1))) == null || tableName1.equals("")) continue;
                    list.add(tableName1);
                    continue;
                }
                if (wcl.getColumnExpression().get(i) instanceof CaseStatement) {
                    CaseStatement cs = (CaseStatement)wcl.getColumnExpression().get(i);
                    tableName = this.getTableAliasName(cs);
                    if (tableName == null || tableName.equals("")) continue;
                    list.add(tableName);
                    continue;
                }
                if (wcl.getColumnExpression().get(i) instanceof SelectColumn) {
                    String tableName2 = this.getTableAliasWhereR((SelectColumn)wcl.getColumnExpression().get(i));
                    if (tableName2 == null || tableName2.equals("")) continue;
                    list.add(tableName2);
                    continue;
                }
                if (!(wcl.getColumnExpression().get(i) instanceof String) || (tableAliaswhere = (String)wcl.getColumnExpression().get(i)).indexOf(".") == -1 || tableAliaswhere.startsWith("/*") && tableAliaswhere.endsWith("*/")) continue;
                if (tableAliaswhere.indexOf(".") != tableAliaswhere.lastIndexOf(".")) {
                    if (SwisSQLOptions.removeDBSchemaQualifier) {
                        tableAliaswhere = tableAliaswhere.substring(tableAliaswhere.indexOf(".") + 1);
                    }
                    list.add(tableAliaswhere.substring(0, tableAliaswhere.lastIndexOf(".")));
                }
                list.add(tableAliaswhere.substring(0, tableAliaswhere.indexOf(".")));
            }
        }
        return list;
    }

    private ArrayList getTableAliasesWhereR(WhereItem wit) {
        ArrayList<String> list = new ArrayList<String>();
        WhereColumn wcr = wit.getRightWhereExp();
        if (wcr != null && wcr.getColumnExpression() != null && wcr.getColumnExpression().size() > 0) {
            for (int i = 0; i < wcr.getColumnExpression().size(); ++i) {
                String tableName;
                if (wcr.getColumnExpression().get(i) instanceof TableColumn) {
                    TableColumn tc = (TableColumn)wcr.getColumnExpression().get(i);
                    if (tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier) {
                        list.add(tc.getOwnerName() + "." + tc.getTableName());
                        continue;
                    }
                    list.add(tc.getTableName());
                    continue;
                }
                if (wcr.getColumnExpression().get(i) instanceof FunctionCalls) {
                    tableName = this.getTableAliasName((FunctionCalls)wcr.getColumnExpression().get(i));
                    if (tableName == null || tableName.equals("")) continue;
                    list.add(tableName);
                    continue;
                }
                if (wcr.getColumnExpression().get(i) instanceof CaseStatement) {
                    CaseStatement cs = (CaseStatement)wcr.getColumnExpression().get(i);
                    String tableName2 = this.getTableAliasName(cs);
                    if (tableName2 == null || tableName2.equals("")) continue;
                    list.add(tableName2);
                    continue;
                }
                if (wcr.getColumnExpression().get(i) instanceof SelectColumn) {
                    tableName = this.getTableAliasWhereR((SelectColumn)wcr.getColumnExpression().get(i));
                    if (tableName == null || tableName.equals("")) continue;
                    list.add(tableName);
                    continue;
                }
                if (!(wcr.getColumnExpression().get(i) instanceof String)) continue;
                String tableAliaswhere = (String)wcr.getColumnExpression().get(i);
                if (tableAliaswhere.startsWith("'")) {
                    list.add("");
                }
                if (tableAliaswhere.indexOf(".") == -1 || tableAliaswhere.startsWith("/*") && tableAliaswhere.endsWith("*/")) continue;
                if (tableAliaswhere.indexOf(".") != tableAliaswhere.lastIndexOf(".")) {
                    if (SwisSQLOptions.removeDBSchemaQualifier) {
                        tableAliaswhere = tableAliaswhere.substring(tableAliaswhere.indexOf(".") + 1);
                    }
                    list.add(tableAliaswhere.substring(0, tableAliaswhere.lastIndexOf(".")));
                }
                list.add(tableAliaswhere.substring(0, tableAliaswhere.indexOf(".")));
            }
        }
        return list;
    }

    private String getTableAliasWhereR(SelectColumn sc) {
        if (sc != null && sc.getColumnExpression() != null && sc.getColumnExpression().size() > 0) {
            for (int i = 0; i < sc.getColumnExpression().size(); ++i) {
                String tableName;
                if (sc.getColumnExpression().get(i) instanceof TableColumn) {
                    TableColumn tc = (TableColumn)sc.getColumnExpression().get(i);
                    if (tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier) {
                        return tc.getOwnerName() + "." + tc.getTableName();
                    }
                    return tc.getTableName();
                }
                if (sc.getColumnExpression().get(i) instanceof FunctionCalls) {
                    FunctionCalls fc = (FunctionCalls)sc.getColumnExpression().get(i);
                    tableName = this.getTableAliasName(fc);
                    if (tableName == null || tableName.equals("")) continue;
                    return tableName;
                }
                if (sc.getColumnExpression().get(i) instanceof CaseStatement) {
                    CaseStatement cs = (CaseStatement)sc.getColumnExpression().get(i);
                    tableName = this.getTableAliasName(cs);
                    if (tableName == null || tableName.equals("")) continue;
                    return tableName;
                }
                if (sc.getColumnExpression().get(i) instanceof SelectColumn) {
                    String tableName2 = this.getTableAliasWhereR((SelectColumn)sc.getColumnExpression().get(i));
                    if (tableName2 == null || tableName2.equals("")) continue;
                    return tableName2;
                }
                if (!(sc.getColumnExpression().get(i) instanceof String)) continue;
                String tableAliaswhere = (String)sc.getColumnExpression().get(i);
                if (tableAliaswhere.startsWith("'")) {
                    return "";
                }
                if (tableAliaswhere.indexOf(".") == -1 || tableAliaswhere.startsWith("/*") && tableAliaswhere.endsWith("*/")) continue;
                if (tableAliaswhere.indexOf(".") != tableAliaswhere.lastIndexOf(".")) {
                    if (SwisSQLOptions.removeDBSchemaQualifier) {
                        return tableAliaswhere.substring(tableAliaswhere.indexOf(".") + 1, tableAliaswhere.lastIndexOf("."));
                    }
                    return tableAliaswhere.substring(0, tableAliaswhere.lastIndexOf("."));
                }
                return tableAliaswhere.substring(0, tableAliaswhere.indexOf("."));
            }
        }
        return null;
    }

    private FromTable getFromTableForNoAlias(WhereItem wit, boolean right2, SelectQueryStatement from_sqs, Vector fromItemList, int database) throws ConvertException {
        Vector colExpr;
        WhereColumn whc = null;
        FromTable ft = null;
        whc = right2 ? wit.getRightWhereExp() : wit.getLeftWhereExp();
        if (whc != null && (colExpr = whc.getColumnExpression()) != null && colExpr.size() > 0) {
            for (int k = 0; k < colExpr.size(); ++k) {
                if (colExpr.get(k) instanceof TableColumn) {
                    ft = this.getFromTableForTableColumnOrString(colExpr.get(k), ft, from_sqs, fromItemList, database, whc);
                    continue;
                }
                if (colExpr.get(k) instanceof FunctionCalls) {
                    FunctionCalls fc = (FunctionCalls)colExpr.get(k);
                    Vector fnArgs = fc.getFunctionArguments();
                    if (fnArgs == null) continue;
                    for (int l = 0; l < fnArgs.size(); ++l) {
                        SelectColumn sc;
                        Vector scColExpr;
                        if (fnArgs.get(l) instanceof TableColumn) {
                            ft = this.getFromTableForTableColumnOrString(fnArgs.get(l), ft, from_sqs, fromItemList, database, whc);
                        }
                        if (!(fnArgs.get(l) instanceof SelectColumn) || (scColExpr = (sc = (SelectColumn)fnArgs.get(l)).getColumnExpression()) == null) continue;
                        for (int m = 0; m < scColExpr.size(); ++m) {
                            if (!(scColExpr.get(m) instanceof TableColumn)) continue;
                            ft = this.getFromTableForTableColumnOrString(scColExpr.get(m), ft, from_sqs, fromItemList, database, whc);
                        }
                    }
                    continue;
                }
                if (colExpr.get(k) instanceof SelectQueryStatement) {
                    SelectQueryStatement sqs = (SelectQueryStatement)colExpr.get(k);
                    Vector selectItemList = sqs.getSelectStatement().getSelectItemList();
                    SelectColumn sc = (SelectColumn)selectItemList.get(0);
                    FromTable newFromTable = new FromTable();
                    sqs.setOpenBrace("(");
                    sqs.setCloseBrace(")");
                    if (selectItemList.size() == 1) {
                        sc.setAliasName("ALIAS_1");
                    }
                    newFromTable.setTableName(sqs);
                    newFromTable.setAliasName("TABLE_ALIAS1");
                    ft = newFromTable;
                    WhereColumn wc = new WhereColumn();
                    Vector<TableColumn> newRightExpression = new Vector<TableColumn>();
                    TableColumn tc1 = new TableColumn();
                    tc1.setTableName(newFromTable.getAliasName());
                    tc1.setColumnName(sc.getAliasName());
                    tc1.setDot(".");
                    newRightExpression.add(tc1);
                    wc.setColumnExpression(newRightExpression);
                    wit.setRightWhereExp(wc);
                    this.selectStmtInJoin = true;
                    return ft;
                }
                if (colExpr.get(k) instanceof CaseStatement) {
                    CaseStatement cs = (CaseStatement)colExpr.get(k);
                    WhereItem cswi = null;
                    if (cs.getCaseCondition() != null) {
                        cswi = (WhereItem)cs.getCaseCondition().getWhereItem().get(0);
                    } else if (((WhenStatement)cs.getWhenClauseList().get(0)).getWhenCondition() != null) {
                        Object wiObj = ((WhenStatement)cs.getWhenClauseList().get(0)).getWhenCondition().getWhereItem().get(0);
                        if (wiObj instanceof WhereItem) {
                            cswi = (WhereItem)wiObj;
                        } else if (wiObj instanceof WhereExpression) {
                            cswi = (WhereItem)((WhereExpression)wiObj).getWhereItems().get(0);
                        }
                    }
                    Object cssc = cswi.getLeftWhereExp().getColumnExpression().get(0);
                    if (cssc instanceof SelectColumn) {
                        Vector scColExpr = ((SelectColumn)cssc).getColumnExpression();
                        if (scColExpr == null) continue;
                        for (int m = 0; m < scColExpr.size(); ++m) {
                            if (!(scColExpr.get(m) instanceof TableColumn)) continue;
                            ft = this.getFromTableForTableColumnOrString(scColExpr.get(m), ft, from_sqs, fromItemList, database, whc);
                        }
                        continue;
                    }
                    if (cssc instanceof TableColumn) {
                        ft = this.getFromTableForTableColumnOrString(cssc, ft, from_sqs, fromItemList, database, whc);
                        continue;
                    }
                    if (!(cssc instanceof String)) continue;
                    ft = this.getFromTableForTableColumnOrString(cssc, ft, from_sqs, fromItemList, database, whc);
                    continue;
                }
                if (!(colExpr.get(k) instanceof String)) continue;
                ft = this.getFromTableForTableColumnOrString(colExpr.get(k), ft, from_sqs, fromItemList, database, whc);
            }
        }
        return ft;
    }

    private FromTable getFromTableForTableColumnOrString(Object object, FromTable ft, SelectQueryStatement from_sqs, Vector fromItemList, int database, WhereColumn whc) throws ConvertException {
        if (object instanceof TableColumn) {
            TableColumn tc1 = (TableColumn)object;
            ft = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)from_sqs, tc1);
        } else if (object instanceof String) {
            ft = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)from_sqs, object.toString());
        }
        if (ft != null && ft.getTableName() != null) {
            String tableAlias = ft.getTableName().toString();
            String alias = ft.getAliasName();
            if (alias != null) {
                tableAlias = ft.getAliasName();
            }
            ft = this.getFromItemAfterConversion(fromItemList, tableAlias, database);
            for (int n = 0; n < whc.getColumnExpression().size(); ++n) {
                Object obj = whc.getColumnExpression().get(n);
                if (obj == null) continue;
                if (obj instanceof TableColumn) {
                    TableColumn tc2 = (TableColumn)obj;
                    tc2.setTableName(tableAlias);
                    continue;
                }
                if (obj instanceof FunctionCalls) {
                    FunctionCalls fc = (FunctionCalls)obj;
                    Vector fnArgs = fc.getFunctionArguments();
                    if (fnArgs == null) continue;
                    for (int k = 0; k < fnArgs.size(); ++k) {
                        SelectColumn sc;
                        Vector colExpression;
                        if (!(fnArgs.get(k) instanceof SelectColumn) || (colExpression = (sc = (SelectColumn)fnArgs.get(k)).getColumnExpression()) == null) continue;
                        for (int m = 0; m < colExpression.size(); ++m) {
                            if (!(colExpression.get(m) instanceof TableColumn)) continue;
                            TableColumn tc2 = (TableColumn)colExpression.get(m);
                            tc2.setTableName(tableAlias);
                        }
                    }
                    continue;
                }
                if (!(obj instanceof String)) continue;
                Object oldObj = obj;
                obj = tableAlias + "." + obj.toString();
                Vector colWCExpr = whc.getColumnExpression();
                if (colWCExpr == null) continue;
                for (int s = 0; s < colWCExpr.size(); ++s) {
                    if (!(colWCExpr.get(s) instanceof String) || !colWCExpr.get(s).toString().equalsIgnoreCase(oldObj.toString())) continue;
                    colWCExpr.setElementAt(obj, s);
                }
            }
            return ft;
        }
        return ft;
    }

    private String getJoinType(WhereItem wit) {
        if (wit.getLeftJoin() != null) {
            return new String(" LEFT OUTER JOIN ");
        }
        if (wit.getRightJoin() != null) {
            return new String(" RIGHT OUTER JOIN ");
        }
        return new String(" INNER JOIN ");
    }

    private String getJoinType(FromTable ft, Vector whereItemList, int position_of_curr_wit) {
        boolean flg = false;
        WhereItem curr_wit = (WhereItem)whereItemList.get(position_of_curr_wit);
        WhereColumn curr_rwc = curr_wit.getRightWhereExp();
        for (int k = 0; k < position_of_curr_wit; ++k) {
            WhereItem wit_in_check = (WhereItem)whereItemList.get(k);
            if (wit_in_check == null || curr_wit == null) continue;
            WhereColumn prev_rwc = wit_in_check.getRightWhereExp();
            if (curr_rwc == null || prev_rwc == null) continue;
            String curr_alias = curr_rwc.getTableAlias();
            String prev_alias = prev_rwc.getTableAlias();
            if (curr_alias == null || prev_alias == null || !curr_rwc.getTableAlias().equals(prev_rwc.getTableAlias())) continue;
            flg = true;
            break;
        }
        if (flg) {
            WhereColumn curr_lwc = curr_wit.getLeftWhereExp();
            curr_wit.setRightWhereExp(curr_lwc);
            curr_wit.setLeftWhereExp(curr_rwc);
            String ljoin = curr_wit.getLeftJoin();
            String rjoin = curr_wit.getRightJoin();
            if (ljoin != null) {
                curr_wit.setRightJoin(ljoin);
                curr_wit.setLeftJoin(null);
            }
            if (rjoin != null) {
                curr_wit.setLeftJoin(rjoin);
                curr_wit.setRightJoin(null);
            }
        }
        return this.getJoinType(curr_wit, ft);
    }

    private String getJoinType(WhereItem wit, FromTable ft) {
        String currentTableName = null;
        if (ft != null) {
            currentTableName = ft.getAliasName() != null ? ft.getAliasName() : ft.getTableName().toString();
            String leftTable = this.getTableAliasWhereL(wit);
            String rightTable = this.getTableAliasWhereR(wit);
            if (wit.getLeftJoin() != null) {
                if (ft != null && ft.getTableName() instanceof SelectQueryStatement) {
                    leftTable = ft.getAliasName();
                }
                if (rightTable != null && CustomizeUtil.compareQuotedIdentifiers(rightTable, currentTableName, true)) {
                    return new String(" LEFT OUTER JOIN ");
                }
                if (leftTable != null && CustomizeUtil.compareQuotedIdentifiers(leftTable, currentTableName, true)) {
                    return new String(" RIGHT OUTER JOIN ");
                }
            } else if (wit.getRightJoin() != null) {
                if (ft != null && ft.getTableName() instanceof SelectQueryStatement) {
                    rightTable = ft.getAliasName();
                }
                if (leftTable != null && CustomizeUtil.compareQuotedIdentifiers(leftTable, currentTableName, true)) {
                    return new String(" LEFT OUTER JOIN ");
                }
                if (rightTable != null && CustomizeUtil.compareQuotedIdentifiers(rightTable, currentTableName, true)) {
                    return new String(" RIGHT OUTER JOIN ");
                }
            } else {
                return new String(" INNER JOIN ");
            }
        }
        return null;
    }

    public void loadWhereItemsOperators(Vector whereItemList, Vector operatorList) {
        for (int i = 0; i < this.whereItems.size(); ++i) {
            Object obj = this.whereItems.get(i);
            if (obj instanceof WhereItem) {
                whereItemList.add(obj);
                operatorList.add(this.operators);
                continue;
            }
            if (!(obj instanceof WhereExpression)) continue;
            WhereExpression we = (WhereExpression)obj;
            we.loadWhereItemsOperators(whereItemList, operatorList);
        }
    }

    private void groupWhereItems(Vector whereItemList, Vector[] joinExpression, WhereExpression newWhereExpression) throws ConvertException {
        int i;
        String[] tableAliasNameL = new String[whereItemList.size()];
        String[] tableAliasNameR = new String[whereItemList.size()];
        Vector<String> wiTables = new Vector<String>();
        Vector<WhereItem> whereExpressions = new Vector<WhereItem>();
        Vector<String> operators = new Vector<String>();
        int operator = -1;
        for (i = 0; i < whereItemList.size(); ++i) {
            String tableAliaswhere;
            TableColumn tc = new TableColumn();
            WhereItem wit = (WhereItem)whereItemList.get(i);
            WhereColumn wcl = wit.getLeftWhereExp();
            WhereColumn wcr = wit.getRightWhereExp();
            if (wit.getLeftJoin() == null && wit.getRightJoin() == null) {
                whereExpressions.add(wit);
                whereItemList.remove(i);
                --i;
                ++operator;
                continue;
            }
            if (wcl.getColumnExpression() != null) {
                if (wcl.getColumnExpression().get(0) instanceof TableColumn) {
                    tc = (TableColumn)wcl.getColumnExpression().get(0);
                    tableAliasNameL[i] = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                }
                if (wcl.getColumnExpression().get(0) instanceof String && (tableAliaswhere = (String)wcl.getColumnExpression().get(0)).indexOf(46) != -1) {
                    if (tableAliaswhere.indexOf(".") != tableAliaswhere.lastIndexOf(".")) {
                        if (SwisSQLOptions.removeDBSchemaQualifier) {
                            tableAliaswhere = tableAliaswhere.substring(tableAliaswhere.indexOf(".") + 1);
                        }
                        tableAliasNameL[i] = tableAliaswhere.substring(0, tableAliaswhere.lastIndexOf("."));
                    } else {
                        tableAliasNameL[i] = tableAliaswhere.substring(0, tableAliaswhere.indexOf("."));
                    }
                }
            }
            if (wcr.getColumnExpression() != null) {
                if (wcr.getColumnExpression().get(0) instanceof TableColumn) {
                    tc = (TableColumn)wcr.getColumnExpression().get(0);
                    tableAliasNameR[i] = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                }
                if (wcr.getColumnExpression().get(0) instanceof String && (tableAliaswhere = (String)wcr.getColumnExpression().get(0)).indexOf(46) != -1) {
                    if (tableAliaswhere.indexOf(".") != tableAliaswhere.lastIndexOf(".")) {
                        if (SwisSQLOptions.removeDBSchemaQualifier) {
                            tableAliaswhere = tableAliaswhere.substring(tableAliaswhere.indexOf(".") + 1);
                        }
                        tableAliasNameR[i] = tableAliaswhere.substring(0, tableAliaswhere.lastIndexOf("."));
                    } else {
                        tableAliasNameR[i] = tableAliaswhere.substring(0, tableAliaswhere.indexOf("."));
                    }
                }
            }
            boolean added = false;
            for (int ii = 0; ii < wiTables.size(); ++ii) {
                String LR = (String)wiTables.get(ii);
                if (LR.equals(tableAliasNameL[i] + tableAliasNameR[i])) {
                    wiTables.add(tableAliasNameL[i] + tableAliasNameR[i]);
                    added = true;
                    break;
                }
                if (!LR.equals(tableAliasNameR[i] + tableAliasNameL[i])) continue;
                wiTables.add(tableAliasNameR[i] + tableAliasNameL[i]);
                added = true;
                break;
            }
            if (added) continue;
            wiTables.add(tableAliasNameL[i] + tableAliasNameR[i]);
        }
        for (i = 0; i < operator; ++i) {
            operators.add(" AND ");
        }
        newWhereExpression.setOperator(operators);
        newWhereExpression.setWhereItem(whereExpressions);
        boolean isSame = false;
        int loopCount = wiTables.size();
        for (int i2 = 0; i2 < loopCount; ++i2) {
            int j;
            joinExpression[i2] = new Vector();
            WhereItem joinWhereItem = (WhereItem)whereItemList.get(i2);
            joinExpression[i2].add(joinWhereItem);
            int[] indexArray = new int[whereItemList.size()];
            int index = 0;
            for (j = i2 + 1; j < loopCount; ++j) {
                if (!wiTables.get(i2).equals(wiTables.get(j))) continue;
                indexArray[index++] = j;
                isSame = true;
            }
            if (!isSame) continue;
            for (int in = 0; in < indexArray.length && indexArray[in] != 0; ++in) {
                joinExpression[i2].add(new String("AND"));
                WhereItem wi = (WhereItem)whereItemList.remove(indexArray[in]);
                wi.setMovedToFromClause(true);
                wiTables.remove(indexArray[in]);
                this.decrement(indexArray);
                wi.setLeftJoin(null);
                wi.setRightJoin(null);
                joinExpression[i2].add(wi);
                --loopCount;
                --j;
            }
            isSame = false;
        }
    }

    private void groupWhereItems(Vector whereItemList, Vector[] joinExpression, SelectQueryStatement to_sqs, SelectQueryStatement from_sqs, int database) throws ConvertException {
        int i;
        String[] tableAliasNameL = new String[whereItemList.size()];
        String[] tableAliasNameR = new String[whereItemList.size()];
        Vector<String> wiTables = new Vector<String>();
        WhereExpression whereExpressions = null;
        Vector<String> operators = new Vector<String>();
        int operator = -1;
        block4: for (int h = 0; h < whereItemList.size(); ++h) {
            WhereItem witem = (WhereItem)whereItemList.get(h);
            if (witem == null || witem.getRightJoin() == null) continue;
            WhereColumn lwhcol = witem.getLeftWhereExp();
            WhereColumn rwhcol = witem.getRightWhereExp();
            if (lwhcol == null || rwhcol == null) continue;
            String lalias = this.getTableAliasName(lwhcol);
            int rightnum = -1;
            boolean isRightNum = false;
            try {
                String rightStr = rwhcol.toString().trim();
                Vector rwhcolExp = rwhcol.getColumnExpression();
                for (int rwhi = 0; rwhi < rwhcolExp.size(); ++rwhi) {
                    try {
                        String objStr = rwhcolExp.get(rwhi).toString();
                        if (objStr.startsWith("(") && objStr.endsWith(")")) {
                            objStr = StringFunctions.replaceAll("", "(", objStr);
                            objStr = StringFunctions.replaceAll("", ")", objStr);
                        }
                        if (objStr.equalsIgnoreCase("-") || objStr.equalsIgnoreCase("+") || objStr.equalsIgnoreCase("*") || objStr.equalsIgnoreCase("/") || objStr.equalsIgnoreCase("(") || objStr.equalsIgnoreCase(")")) continue;
                        Double.parseDouble(objStr.trim());
                        isRightNum = true;
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        break;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (lalias == null || lalias.equals("") || !rwhcol.toString().trim().startsWith("'") && !rwhcol.toString().trim().startsWith("-") && !isRightNum) continue;
            for (int k = h + 1; k < whereItemList.size(); ++k) {
                WhereItem witem1 = (WhereItem)whereItemList.get(k);
                if (witem1.getRightJoin() == null) continue;
                WhereColumn lwhcol1 = witem1.getLeftWhereExp();
                WhereColumn rwhcol1 = witem1.getRightWhereExp();
                String lalias1 = this.getTableAliasName(lwhcol1);
                String ralias1 = this.getTableAliasName(rwhcol1);
                if (lalias1 == null || lalias1.equals("") || ralias1 == null || ralias1.equals("") || !lalias1.equals(lalias)) continue;
                WhereItem wi = (WhereItem)whereItemList.remove(h);
                if (k + 1 > whereItemList.size()) {
                    whereItemList.add(wi);
                } else {
                    whereItemList.add(k + 1, wi);
                }
                --h;
                continue block4;
            }
        }
        for (i = 0; i < whereItemList.size(); ++i) {
            CaseStatement casestmt;
            String tableAliaswhere;
            int index;
            SelectColumn sc;
            String tableAliaswhere2;
            FromTable fromTableOfWhereColumn;
            WhereItem wit = (WhereItem)whereItemList.get(i);
            WhereColumn wcl = wit.getLeftWhereExp();
            WhereColumn wcr = wit.getRightWhereExp();
            TableColumn tcLeft = new TableColumn();
            TableColumn tcRight = new TableColumn();
            FromTable ft1 = new FromTable();
            FromTable ft2 = new FromTable();
            if (wcl != null && wcl.getColumnExpression() != null && wcl.getColumnExpression().get(0) instanceof TableColumn) {
                tcLeft = (TableColumn)wcl.getColumnExpression().get(0);
                ft1 = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)from_sqs, tcLeft);
            }
            if (wcr != null && wcr.getColumnExpression() != null && wcr.getColumnExpression().get(0) instanceof TableColumn) {
                tcRight = (TableColumn)wcr.getColumnExpression().get(0);
                ft2 = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)from_sqs, tcRight);
            }
            if (wit.getLeftJoin() == null && wit.getRightJoin() == null) {
                whereItemList.remove(i);
                --i;
                ++operator;
                continue;
            }
            TableColumn tc = new TableColumn();
            if (wcl != null && wcl.getColumnExpression() != null) {
                if (wcl.getColumnExpression().get(0) instanceof TableColumn) {
                    tc = (TableColumn)wcl.getColumnExpression().get(0);
                    if (tc.getTableName() == null || tc.getColumnName().trim().equals("?")) {
                        String tableAliaswhere3 = tc.getColumnName();
                        String fromTableAlias = null;
                        fromTableOfWhereColumn = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)from_sqs, tc);
                        tableAliasNameL[i] = fromTableOfWhereColumn != null ? ((fromTableAlias = fromTableOfWhereColumn.getAliasName()) != null ? fromTableAlias : fromTableOfWhereColumn.getTableName().toString()) : "";
                    } else {
                        tableAliasNameL[i] = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                    }
                }
                if (wcl.getColumnExpression().get(0) instanceof FunctionCalls) {
                    FunctionCalls fc = (FunctionCalls)wcl.getColumnExpression().get(0);
                    Vector functionObjects = this.putObjectsInOneList(fc.getFunctionArguments());
                    if (functionObjects.size() > 0) {
                        if (functionObjects.get(0) instanceof TableColumn) {
                            tc = (TableColumn)functionObjects.get(0);
                            if (tc.getTableName() == null || tc.getColumnName().trim().equals("?")) {
                                tableAliaswhere2 = tc.getColumnName();
                                tableAliasNameL[i] = "";
                            } else {
                                tableAliasNameL[i] = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                            }
                        } else if (functionObjects.get(0) instanceof SelectColumn) {
                            sc = (SelectColumn)functionObjects.get(0);
                            if (sc.getColumnExpression() != null) {
                                for (index = 0; index < sc.getColumnExpression().size(); ++index) {
                                    if (!(sc.getColumnExpression().get(index) instanceof TableColumn)) continue;
                                    tc = (TableColumn)sc.getColumnExpression().get(index);
                                    if (tc.getTableName() == null || tc.getColumnName().trim().equals("?")) {
                                        tableAliaswhere = tc.getColumnName();
                                        tableAliasNameL[i] = "";
                                        continue;
                                    }
                                    tableAliasNameL[i] = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                                }
                            }
                        } else if (functionObjects.get(0) instanceof String) {
                            tableAliaswhere2 = (String)functionObjects.get(0);
                            if (tableAliaswhere2.indexOf(46) != -1) {
                                if (tableAliaswhere2.indexOf(46) != tableAliaswhere2.lastIndexOf(46)) {
                                    if (SwisSQLOptions.removeDBSchemaQualifier) {
                                        tableAliaswhere2 = tableAliaswhere2.substring(tableAliaswhere2.indexOf(".") + 1);
                                    }
                                    tableAliasNameL[i] = tableAliaswhere2.substring(0, tableAliaswhere2.lastIndexOf("."));
                                } else {
                                    tableAliasNameL[i] = tableAliaswhere2.substring(0, tableAliaswhere2.indexOf("."));
                                }
                            } else {
                                tableAliasNameL[i] = "";
                            }
                        } else if (functionObjects.get(0) instanceof NumericClass) {
                            if (functionObjects.size() == 2) {
                                if (functionObjects.get(1) instanceof TableColumn) {
                                    TableColumn tc1 = (TableColumn)functionObjects.get(1);
                                    tableAliasNameL[i] = tc1.getTableName();
                                } else if (functionObjects.get(1) instanceof String) {
                                    tableAliaswhere2 = (String)functionObjects.get(1);
                                    if (tableAliaswhere2.indexOf(46) != -1) {
                                        if (tableAliaswhere2.indexOf(46) != tableAliaswhere2.lastIndexOf(46)) {
                                            if (SwisSQLOptions.removeDBSchemaQualifier) {
                                                tableAliaswhere2 = tableAliaswhere2.substring(tableAliaswhere2.indexOf(".") + 1);
                                            }
                                            tableAliasNameL[i] = tableAliaswhere2.substring(0, tableAliaswhere2.lastIndexOf("."));
                                        } else {
                                            tableAliasNameL[i] = tableAliaswhere2.substring(0, tableAliaswhere2.indexOf("."));
                                        }
                                    } else {
                                        tableAliasNameL[i] = "";
                                    }
                                } else {
                                    tableAliasNameL[i] = "";
                                }
                            } else {
                                tableAliasNameL[i] = "";
                            }
                        }
                    } else {
                        tableAliasNameL[i] = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                    }
                }
                if (wcl.getColumnExpression().get(0) instanceof SelectColumn) {
                    Vector colExpr = ((SelectColumn)wcl.getColumnExpression().get(0)).getColumnExpression();
                    for (int k = 0; k < colExpr.size(); ++k) {
                        if (colExpr.get(k) instanceof TableColumn) {
                            tc = (TableColumn)colExpr.get(k);
                            if (tc.getTableName() == null || tc.getColumnName().trim().equals("?")) {
                                tableAliaswhere2 = tc.getColumnName();
                                tableAliasNameL[i] = "";
                                break;
                            }
                            if (tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier) {
                                tableAliasNameL[i] = tc.getOwnerName() + "." + tc.getTableName();
                                break;
                            }
                            tableAliasNameL[i] = tc.getTableName();
                            break;
                        }
                        if (colExpr.get(k) instanceof String) {
                            tableAliaswhere2 = (String)colExpr.get(k);
                            if (tableAliaswhere2.indexOf(46) != -1) {
                                if (tableAliaswhere2.indexOf(46) != tableAliaswhere2.lastIndexOf(46)) {
                                    if (SwisSQLOptions.removeDBSchemaQualifier) {
                                        tableAliaswhere2 = tableAliaswhere2.substring(tableAliaswhere2.indexOf(".") + 1);
                                    }
                                    tableAliasNameL[i] = tableAliaswhere2.substring(0, tableAliaswhere2.lastIndexOf("."));
                                } else {
                                    tableAliasNameL[i] = tableAliaswhere2.substring(0, tableAliaswhere2.indexOf("."));
                                }
                            } else {
                                tableAliasNameL[i] = "";
                            }
                        }
                        if (!(colExpr.get(k) instanceof CaseStatement)) continue;
                        casestmt = (CaseStatement)colExpr.get(k);
                        tableAliasNameL[i] = this.getTableAliasName(casestmt);
                    }
                }
                if (wcl.getColumnExpression().get(0) instanceof CaseStatement) {
                    CaseStatement casestmt2 = (CaseStatement)wcl.getColumnExpression().get(0);
                    tableAliasNameL[i] = this.getTableAliasName(casestmt2);
                }
                if (wcl.getColumnExpression().get(0) instanceof String) {
                    String tableAliaswhere4 = (String)wcl.getColumnExpression().get(0);
                    if (tableAliaswhere4.indexOf(46) != -1) {
                        if (tableAliaswhere4.indexOf(46) != tableAliaswhere4.lastIndexOf(46)) {
                            if (SwisSQLOptions.removeDBSchemaQualifier) {
                                tableAliaswhere4 = tableAliaswhere4.substring(tableAliaswhere4.indexOf(".") + 1);
                            }
                            tableAliasNameL[i] = tableAliaswhere4.substring(0, tableAliaswhere4.lastIndexOf("."));
                        } else {
                            tableAliasNameL[i] = tableAliaswhere4.substring(0, tableAliaswhere4.indexOf("."));
                        }
                    } else {
                        tableAliasNameL[i] = "";
                    }
                }
            } else {
                tableAliasNameL[i] = "";
            }
            if (wcr != null && wcr.getColumnExpression() != null) {
                if (wcr.getColumnExpression().get(0) instanceof SelectColumn) {
                    Vector colExpr = ((SelectColumn)wcr.getColumnExpression().get(0)).getColumnExpression();
                    for (int k = 0; k < colExpr.size(); ++k) {
                        if (colExpr.get(k) instanceof TableColumn) {
                            tc = (TableColumn)colExpr.get(k);
                            if (tc.getTableName() == null || tc.getColumnName().trim().equals("?")) {
                                tableAliaswhere2 = tc.getColumnName();
                                tableAliasNameR[i] = "";
                                break;
                            }
                            if (tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier) {
                                tableAliasNameR[i] = tc.getOwnerName() + "." + tc.getTableName();
                                break;
                            }
                            tableAliasNameR[i] = tc.getTableName();
                            break;
                        }
                        if (colExpr.get(k) instanceof String) {
                            tableAliaswhere2 = (String)colExpr.get(k);
                            if (tableAliaswhere2.indexOf(46) != -1) {
                                if (tableAliaswhere2.indexOf(46) != tableAliaswhere2.lastIndexOf(46)) {
                                    if (SwisSQLOptions.removeDBSchemaQualifier) {
                                        tableAliaswhere2 = tableAliaswhere2.substring(tableAliaswhere2.indexOf(".") + 1);
                                    }
                                    tableAliasNameR[i] = tableAliaswhere2.substring(0, tableAliaswhere2.lastIndexOf("."));
                                } else {
                                    tableAliasNameR[i] = tableAliaswhere2.substring(0, tableAliaswhere2.indexOf("."));
                                }
                            } else {
                                tableAliasNameR[i] = "";
                            }
                        }
                        if (!(colExpr.get(k) instanceof CaseStatement)) continue;
                        casestmt = (CaseStatement)colExpr.get(k);
                        tableAliasNameR[i] = this.getTableAliasName(casestmt);
                    }
                }
                if (wcr.getColumnExpression().get(0) instanceof TableColumn) {
                    tc = (TableColumn)wcr.getColumnExpression().get(0);
                    if (tc.getTableName() == null || tc.getColumnName().trim().equals("?")) {
                        String tableAliaswhere5 = tc.getColumnName();
                        String fromTableAlias = null;
                        fromTableOfWhereColumn = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)from_sqs, tc);
                        tableAliasNameR[i] = fromTableOfWhereColumn != null ? ((fromTableAlias = fromTableOfWhereColumn.getAliasName()) != null ? fromTableAlias : fromTableOfWhereColumn.getTableName().toString()) : "";
                    } else {
                        tableAliasNameR[i] = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                    }
                }
                if (wcr.getColumnExpression().get(0) instanceof FunctionCalls) {
                    FunctionCalls fc = (FunctionCalls)wcr.getColumnExpression().get(0);
                    Vector functionObjects = this.putObjectsInOneList(fc.getFunctionArguments());
                    if (functionObjects.size() > 0) {
                        if (functionObjects.get(0) instanceof TableColumn) {
                            tc = (TableColumn)functionObjects.get(0);
                            if (tc.getTableName() == null || tc.getColumnName().trim().equals("?")) {
                                tableAliaswhere2 = tc.getColumnName();
                                tableAliasNameR[i] = "";
                            } else {
                                tableAliasNameR[i] = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                            }
                        } else if (functionObjects.get(0) instanceof SelectColumn) {
                            sc = (SelectColumn)functionObjects.get(0);
                            if (sc.getColumnExpression() != null) {
                                for (index = 0; index < sc.getColumnExpression().size(); ++index) {
                                    if (!(sc.getColumnExpression().get(index) instanceof TableColumn)) continue;
                                    tc = (TableColumn)sc.getColumnExpression().get(index);
                                    if (tc.getTableName() == null && tc.getColumnName().trim().equals("?")) {
                                        tableAliaswhere = tc.getColumnName();
                                        tableAliasNameR[i] = "";
                                        continue;
                                    }
                                    tableAliasNameR[i] = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                                }
                            }
                        } else if (functionObjects.get(0) instanceof String) {
                            tableAliaswhere2 = (String)functionObjects.get(0);
                            if (tableAliaswhere2.indexOf(46) != -1) {
                                if (tableAliaswhere2.indexOf(46) != tableAliaswhere2.lastIndexOf(46)) {
                                    if (SwisSQLOptions.removeDBSchemaQualifier) {
                                        tableAliaswhere2 = tableAliaswhere2.substring(tableAliaswhere2.indexOf(".") + 1);
                                    }
                                    tableAliasNameR[i] = tableAliaswhere2.substring(0, tableAliaswhere2.lastIndexOf("."));
                                } else {
                                    tableAliasNameR[i] = tableAliaswhere2.substring(0, tableAliaswhere2.indexOf("."));
                                }
                            } else {
                                tableAliasNameR[i] = "";
                            }
                        }
                    } else {
                        tableAliasNameR[i] = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                    }
                }
                if (wcr.getColumnExpression().get(0) instanceof CaseStatement) {
                    CaseStatement casestmt3 = (CaseStatement)wcr.getColumnExpression().get(0);
                    tableAliasNameR[i] = this.getTableAliasName(casestmt3);
                }
                if (wcr.getColumnExpression().get(0) instanceof String) {
                    String tableAliaswhere6 = (String)wcr.getColumnExpression().get(0);
                    if (tableAliaswhere6.indexOf(46) != -1) {
                        if (tableAliaswhere6.indexOf(46) != tableAliaswhere6.lastIndexOf(46)) {
                            if (SwisSQLOptions.removeDBSchemaQualifier) {
                                tableAliaswhere6 = tableAliaswhere6.substring(tableAliaswhere6.indexOf(".") + 1);
                            }
                            tableAliasNameR[i] = tableAliaswhere6.substring(0, tableAliaswhere6.lastIndexOf("."));
                        } else {
                            tableAliasNameR[i] = tableAliaswhere6.substring(0, tableAliaswhere6.indexOf("."));
                        }
                    } else {
                        tableAliasNameR[i] = "";
                    }
                }
            } else {
                tableAliasNameR[i] = "";
            }
            if ((database == 12 || database == 8) && (tableAliasNameL[i] != null && tableAliasNameL[i].equalsIgnoreCase("") || tableAliasNameR[i] != null && tableAliasNameR[i].equalsIgnoreCase("")) && (wit.getLeftJoin() != null || wit.getRightJoin() != null) && this.isColumnNameExistsInWhereColumn(wit.getRightWhereExp().getColumnExpression().get(0))) {
                String errMsg = "SwisSQL Message : Tablename is not provided for one of the Columns in the Where Condition";
                errMsg = errMsg + " : " + wit.toString() + " \n";
                errMsg = errMsg + " Please provide the Tablename in the original query and then convert.";
                throw new ConvertException(errMsg);
            }
            boolean added = false;
            for (int ii = 0; ii < wiTables.size(); ++ii) {
                if (tableAliasNameL[i] == null || tableAliasNameR[i] == null) continue;
                String LR = (String)wiTables.get(ii);
                if (LR.equals(tableAliasNameL[i] + "-" + tableAliasNameR[i])) {
                    wiTables.add(tableAliasNameL[i] + "-" + tableAliasNameR[i]);
                    added = true;
                    break;
                }
                if (!LR.equals(tableAliasNameR[i] + "-" + tableAliasNameL[i])) continue;
                wiTables.add(tableAliasNameR[i] + "-" + tableAliasNameL[i]);
                added = true;
                break;
            }
            if (added || tableAliasNameL[i] == null || tableAliasNameR[i] == null) continue;
            wiTables.add(tableAliasNameL[i] + "-" + tableAliasNameR[i]);
        }
        for (i = 0; i < operator; ++i) {
            operators.add(" AND ");
        }
        boolean isSame = false;
        int loopCount = wiTables.size();
        for (int i2 = 0; i2 < loopCount; ++i2) {
            whereExpressions = new WhereExpression();
            joinExpression[i2] = new Vector();
            WhereItem joinWhereItem = (WhereItem)whereItemList.get(i2);
            whereExpressions.addWhereItem(joinWhereItem.convert(to_sqs, from_sqs, database));
            int[] indexArray = new int[whereItemList.size()];
            int index = 0;
            for (int j = i2 + 1; j < loopCount; ++j) {
                if (wiTables.get(i2).equals(wiTables.get(j))) {
                    indexArray[index++] = j;
                    isSame = true;
                    continue;
                }
                String ithElement = (String)wiTables.get(i2);
                String jthElement = (String)wiTables.get(j);
                if (jthElement.endsWith("-")) {
                    jthElement = jthElement.substring(0, jthElement.length() - 1);
                } else if (jthElement.startsWith("-")) {
                    jthElement = jthElement.substring(1);
                }
                ithElement = "&" + ithElement.replaceAll("-", "&-&") + "&";
                jthElement = "&" + jthElement.replaceAll("-", "&-&") + "&";
                if (ithElement.indexOf("-" + jthElement) == -1 && ithElement.indexOf(jthElement + "-") == -1) continue;
                indexArray[index++] = j;
                isSame = true;
            }
            if (isSame) {
                for (int in = 0; in < indexArray.length && indexArray[in] != 0; ++in) {
                    whereExpressions.addOperator("AND");
                    WhereItem wi = (WhereItem)whereItemList.remove(indexArray[in] - in);
                    wiTables.remove(indexArray[in] - in);
                    whereExpressions.addWhereItem(wi.convert(to_sqs, from_sqs, database));
                    --loopCount;
                }
                isSame = false;
            }
            joinExpression[i2].add(whereExpressions);
        }
    }

    public void orderWhereItems(Vector whereItemList, Vector[] joinExpression) {
        int size = whereItemList.size();
        for (int i = 0; i < size; ++i) {
            WhereItem wi = (WhereItem)whereItemList.elementAt(i);
            String leftTable = this.getTableAliasWhereL(wi);
            String rightTable = this.getTableAliasWhereR(wi);
            int position = i + 1;
            for (int j = i + 1; j < size; ++j) {
                WhereItem nextWI = (WhereItem)whereItemList.elementAt(j);
                String nextLeftTable = this.getTableAliasWhereL(nextWI);
                String nextRightTable = this.getTableAliasWhereR(nextWI);
                if (!(leftTable != null && nextLeftTable != null && CustomizeUtil.compareQuotedIdentifiers(leftTable, nextLeftTable, true) || leftTable != null && nextRightTable != null && CustomizeUtil.compareQuotedIdentifiers(leftTable, nextRightTable, true) || rightTable != null && nextLeftTable != null && CustomizeUtil.compareQuotedIdentifiers(rightTable, nextLeftTable, true)) && (rightTable == null || nextRightTable == null || !CustomizeUtil.compareQuotedIdentifiers(rightTable, nextRightTable, true))) continue;
                whereItemList.insertElementAt(whereItemList.remove(j), position);
                Vector v = joinExpression[position];
                for (int k = position; k < j; ++k) {
                    Vector vNext = joinExpression[k + 1];
                    joinExpression[k + 1] = v;
                    v = vNext;
                }
                joinExpression[position] = v;
                ++position;
            }
        }
    }

    private void decrement(int[] indexArray) {
        int i = 0;
        while (i < indexArray.length && indexArray[i] != 0) {
            int n = i++;
            indexArray[n] = indexArray[n] - 1;
        }
    }

    private boolean isColumnNameExistsInWhereColumn(Object obj) {
        if (obj instanceof SelectColumn) {
            SelectColumn sc = (SelectColumn)obj;
            Vector vc = sc.getColumnExpression();
            int size = vc.size();
            for (int i = 0; i < size; ++i) {
                if (!this.isColumnNameExistsInWhereColumn(vc.get(i))) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof FunctionCalls) {
            FunctionCalls fc = (FunctionCalls)obj;
            Vector vc = fc.getFunctionArguments();
            int size = vc.size();
            for (int i = 0; i < size; ++i) {
                if (!this.isColumnNameExistsInWhereColumn(vc.get(i))) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof TableColumn) {
            return this.isColumnNameExistsInWhereColumn(((TableColumn)obj).getColumnName());
        }
        if (obj instanceof String) {
            String str2 = obj.toString().trim();
            return !str2.startsWith("'") && !this.isNumber(str2) && !this.isOperator(str2) && !this.isKeyword(str2, 12) && !this.isKeyword(str2, 8);
        }
        return true;
    }

    private boolean isKeyword(String str2, int database) {
        String[] keyList = SwisSQLUtils.getKeywords(database);
        if (keyList == null) {
            return false;
        }
        int size = keyList.length;
        for (int i = 0; i < size; ++i) {
            if (!str2.equalsIgnoreCase(keyList[i])) continue;
            return true;
        }
        return str2.equalsIgnoreCase("DUAL") || str2.equalsIgnoreCase("SYS.DUAL") || str2.equalsIgnoreCase("DATE") || str2.equalsIgnoreCase("CURRENT DATE") || str2.equalsIgnoreCase("\"rownum\"") || str2.equalsIgnoreCase("rownum") || str2.equalsIgnoreCase("SYSDATE") || str2.equalsIgnoreCase("SYS_GUID") || str2.equalsIgnoreCase("TIME") || str2.equalsIgnoreCase("CURRENT TIME") || str2.equalsIgnoreCase("USER") || str2.equalsIgnoreCase("SYSDATE") || str2.equalsIgnoreCase("TIMESTAMP") || str2.equalsIgnoreCase("SYSTIMESTAMP") || str2.equalsIgnoreCase("CURRENT TIMESTAMP") || str2.equalsIgnoreCase("CURRENT") || str2.equalsIgnoreCase("SYSTEM_USER");
    }

    private boolean isOperator(String str2) {
        return str2.equalsIgnoreCase("+") || str2.equalsIgnoreCase("-") || str2.equalsIgnoreCase("*") || str2.equalsIgnoreCase("/");
    }

    private boolean isNumber(String str2) {
        try {
            Integer.parseInt(str2.substring(0, 1));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public Vector arrangeTheWhereItemListAccordingToTheOrderInFromItemList(Vector whereItemList, Vector fromItemList) {
        int i;
        Vector arrangeWhereItemList = new Vector();
        Vector originalWhereItemList = whereItemList;
        Vector originalFromItemList = fromItemList;
        for (i = 0; i < originalFromItemList.size(); ++i) {
            FromTable ft1 = null;
            if (originalFromItemList.elementAt(i) instanceof FromTable) {
                ft1 = (FromTable)originalFromItemList.get(i);
            } else if (originalFromItemList.elementAt(i) instanceof FromClause) {
                Vector newFromItemVector = ((FromClause)originalFromItemList.get(i)).getFromItemList();
                for (int index = 0; index < newFromItemVector.size(); ++index) {
                    if (newFromItemVector.elementAt(index) instanceof FromTable) {
                        ft1 = (FromTable)newFromItemVector.get(index);
                        continue;
                    }
                    this.arrangeTheWhereItemListAccordingToTheOrderInFromItemList(whereItemList, newFromItemVector);
                }
            }
            for (int count2 = i + 1; count2 < originalFromItemList.size(); ++count2) {
                FromTable ft2 = null;
                if (originalFromItemList.elementAt(count2) instanceof FromTable) {
                    ft2 = (FromTable)originalFromItemList.get(count2);
                } else if (originalFromItemList.elementAt(count2) instanceof FromClause) {
                    Vector newFromItemVector = ((FromClause)originalFromItemList.get(count2)).getFromItemList();
                    for (int index = 0; index < newFromItemVector.size(); ++index) {
                        if (newFromItemVector.elementAt(index) instanceof FromTable) {
                            ft2 = (FromTable)newFromItemVector.get(index);
                            continue;
                        }
                        this.arrangeTheWhereItemListAccordingToTheOrderInFromItemList(whereItemList, newFromItemVector);
                    }
                }
                this.orderTheWhereItemAccordingToTheFromItem(ft1, ft2, arrangeWhereItemList, originalWhereItemList);
            }
        }
        for (i = 0; i < originalWhereItemList.size(); ++i) {
            arrangeWhereItemList.add(originalWhereItemList.get(i));
        }
        return arrangeWhereItemList;
    }

    public void orderTheWhereItemAccordingToTheFromItem(FromTable ft1, FromTable ft2, Vector arrangeWhereItemList, Vector originalWhereItemList) {
        int currentArrangedSize = arrangeWhereItemList.size();
        for (int i = 0; i < originalWhereItemList.size(); ++i) {
            WhereItem wi = (WhereItem)originalWhereItemList.elementAt(i);
            String leftTable = this.getTableAliasWhereL(wi);
            String rightTable = this.getTableAliasWhereR(wi);
            String fromTableAliasName1 = ft1.getAliasName();
            String fromTableAliasName2 = ft2.getAliasName();
            if (fromTableAliasName1 == null) {
                fromTableAliasName1 = ft1.getTableName().toString();
            }
            if (fromTableAliasName2 == null) {
                fromTableAliasName2 = ft2.getTableName().toString();
            }
            if (fromTableAliasName1.equalsIgnoreCase(leftTable) && fromTableAliasName2.equalsIgnoreCase(rightTable)) {
                if (arrangeWhereItemList.size() > currentArrangedSize) {
                    arrangeWhereItemList.insertElementAt(wi, currentArrangedSize);
                } else {
                    arrangeWhereItemList.add(wi);
                }
                originalWhereItemList.remove(i);
                --i;
                continue;
            }
            if (fromTableAliasName1.equalsIgnoreCase(rightTable) && fromTableAliasName2.equalsIgnoreCase(leftTable)) {
                WhereColumn newLeftWhereExp = wi.getLeftWhereExp();
                WhereColumn newRightWhereExp = wi.getRightWhereExp();
                String leftJoin = wi.getLeftJoin();
                String rightJoin = wi.getRightJoin();
                wi.setLeftJoin(rightJoin);
                wi.setRightJoin(leftJoin);
                wi.setLeftWhereExp(newRightWhereExp);
                wi.setRightWhereExp(newLeftWhereExp);
                if (arrangeWhereItemList.size() > currentArrangedSize) {
                    arrangeWhereItemList.insertElementAt(wi, currentArrangedSize);
                } else {
                    arrangeWhereItemList.add(wi);
                }
                originalWhereItemList.remove(i);
                --i;
                continue;
            }
            if (leftTable == null && fromTableAliasName1.equalsIgnoreCase(rightTable)) {
                arrangeWhereItemList.add(wi);
                originalWhereItemList.remove(i);
                --i;
                continue;
            }
            if (leftTable != null && leftTable.trim().equals("") && fromTableAliasName1.equalsIgnoreCase(rightTable)) {
                arrangeWhereItemList.add(wi);
                originalWhereItemList.remove(i);
                --i;
                continue;
            }
            if (rightTable == null && fromTableAliasName1.equalsIgnoreCase(leftTable)) {
                arrangeWhereItemList.add(wi);
                originalWhereItemList.remove(i);
                --i;
                continue;
            }
            if (rightTable == null || !rightTable.trim().equals("") || !fromTableAliasName1.equalsIgnoreCase(leftTable)) continue;
            arrangeWhereItemList.add(wi);
            originalWhereItemList.remove(i);
            --i;
        }
    }

    private void addFetchClause(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        Vector scItem;
        int i;
        if (to_sqs == null) {
            return;
        }
        FetchClause fetch_clause = new FetchClause();
        String rownumValue = "0";
        if (this.rownumClause.getRownumValue() instanceof SelectQueryStatement) {
            throw new ConvertException("Conversion failure.. Subquery can't be converted");
        }
        if (this.rownumClause.getRownumValue() instanceof SelectColumn) {
            SelectColumn sc = (SelectColumn)this.rownumClause.getRownumValue();
            Vector colExp = sc.getColumnExpression();
            for (i = 0; i < colExp.size(); ++i) {
                if (colExp.elementAt(i) instanceof FunctionCalls) {
                    throw new ConvertException("Conversion failure.. Function calls can't be converted");
                }
                if (colExp.elementAt(i) instanceof TableColumn) {
                    if (this.rownumClause.getOperator().equals("<=") || this.rownumClause.getOperator().equals("=")) {
                        fetch_clause.setFetchCountVariable(((TableColumn)colExp.elementAt(i)).toString());
                        continue;
                    }
                    fetch_clause.setFetchCountVariable(((TableColumn)colExp.elementAt(i)).toString() + " - 1");
                    continue;
                }
                if (colExp.elementAt(i) instanceof String && colExp.size() == 1) {
                    rownumValue = (String)colExp.elementAt(i);
                    continue;
                }
                throw new ConvertException("Conversion failure.. Expression can't be converted");
            }
        }
        fetch_clause.setFetchFirstClause("FETCH FIRST");
        fetch_clause.setRowOnlyClause("ROWS ONLY");
        if (this.rownumClause.getOperator().equals("<=") || this.rownumClause.getOperator().equals("=")) {
            fetch_clause.setFetchCount(rownumValue);
        } else {
            fetch_clause.setFetchCount(Integer.parseInt(rownumValue) - 1 + "");
        }
        if (to_sqs.getFetchClause() != null) {
            throw new ConvertException();
        }
        to_sqs.setFetchClause(fetch_clause);
        SelectStatement ss = to_sqs.getSelectStatement();
        if (ss != null && (scItem = ss.getSelectItemList()) != null) {
            for (i = 0; i < scItem.size(); ++i) {
                Vector cols;
                SelectColumn sc;
                if (!(scItem.get(i) instanceof SelectColumn) || (sc = (SelectColumn)scItem.get(i)) == null || (cols = sc.getColumnExpression()) == null) continue;
                for (int j = 0; j < cols.size(); ++j) {
                    String colName;
                    TableColumn tc;
                    if (!(cols.get(j) instanceof TableColumn) || (tc = (TableColumn)cols.get(j)) == null || (colName = tc.getColumnName()) == null || !colName.toLowerCase().equals("rownum")) continue;
                    tc.setColumnName("ROW_NUMBER() OVER()");
                }
            }
        }
        to_sqs.setLimitClause(null);
    }

    private void addLimitClause(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        LimitClause limitClause = new LimitClause();
        String rownumValue = new String("0");
        if (this.rownumClause.getRownumValue() instanceof SelectQueryStatement) {
            throw new ConvertException(" SubQuery are not allowed in Limit clause");
        }
        if (this.rownumClause.getRownumValue() instanceof SelectColumn) {
            SelectColumn sc = (SelectColumn)this.rownumClause.getRownumValue();
            Vector colExp = sc.getColumnExpression();
            for (int i = 0; i < colExp.size(); ++i) {
                if (colExp.elementAt(i) instanceof FunctionCalls) {
                    throw new ConvertException(" Function calls are not allowed in Limit clause");
                }
                if (colExp.elementAt(i) instanceof TableColumn) {
                    throw new ConvertException(" Identifier is not allowed in Limit clause");
                }
                if (!(colExp.elementAt(i) instanceof String) || colExp.size() != 1) {
                    throw new ConvertException(" Expression are not allowed in Limit clause");
                }
                rownumValue = (String)colExp.elementAt(i);
            }
        }
        limitClause.setLimitClause("LIMIT");
        if (this.rownumClause.getOperator().equals("<=")) {
            limitClause.setLimitValue(rownumValue);
        } else {
            limitClause.setLimitValue(Integer.parseInt(rownumValue) - 1 + "");
        }
        if (to_sqs.getLimitClause() != null) {
            throw new ConvertException();
        }
        to_sqs.setLimitClause(limitClause);
        to_sqs.setFetchClause(null);
    }

    private boolean isMetaDataRequired(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) {
        WhereExpression newWhereExpression = new WhereExpression();
        FromClause fromClause = to_sqs.getFromClause();
        if (fromClause != null) {
            FromClause newFromClause = new FromClause();
            Vector newFromItemList = new Vector();
            newFromClause.setFromClause("FROM");
            newFromClause.setFromItemList(newFromItemList);
            Vector fromItemList = fromClause.getFromItemList();
            Vector whereItemList = new Vector();
            Vector operatorList = new Vector();
            Vector[] joinExpression = new Vector[fromItemList.size()];
            this.loadWhereItemsOperators(whereItemList, operatorList);
            String[] tableAliasNameL = new String[whereItemList.size()];
            String[] tableAliasNameR = new String[whereItemList.size()];
            Vector<String> wiTables = new Vector<String>();
            Vector<WhereItem> whereExpressions = new Vector<WhereItem>();
            Vector operators = new Vector();
            int operator = -1;
            for (int i = 0; i < whereItemList.size(); ++i) {
                TableColumn tc = new TableColumn();
                WhereItem wit = (WhereItem)whereItemList.get(i);
                WhereColumn wcl = wit.getLeftWhereExp();
                WhereColumn wcr = wit.getRightWhereExp();
                try {
                    String tableAliaswhere;
                    if (wit.getLeftJoin() == null && wit.getRightJoin() == null) {
                        whereExpressions.add(wit);
                        whereItemList.remove(i);
                        --i;
                        ++operator;
                        continue;
                    }
                    if (wcl.getColumnExpression() != null) {
                        if (wcl.getColumnExpression().get(0) instanceof TableColumn) {
                            tc = (TableColumn)wcl.getColumnExpression().get(0);
                            tableAliasNameL[i] = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                        }
                        if (wcl.getColumnExpression().get(0) instanceof String && !(tableAliaswhere = (String)wcl.getColumnExpression().get(0)).startsWith("'")) {
                            try {
                                Integer.parseInt(tableAliaswhere);
                            }
                            catch (NumberFormatException nfe) {
                                tableAliasNameL[i] = tableAliaswhere.substring(0, tableAliaswhere.lastIndexOf("."));
                            }
                        }
                    }
                    if (wcr.getColumnExpression() != null) {
                        if (wcr.getColumnExpression().get(0) instanceof TableColumn) {
                            tc = (TableColumn)wcr.getColumnExpression().get(0);
                            tableAliasNameR[i] = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                        }
                        if (wcr.getColumnExpression().get(0) instanceof String && !(tableAliaswhere = (String)wcr.getColumnExpression().get(0)).startsWith("'")) {
                            try {
                                Integer.parseInt(tableAliaswhere);
                            }
                            catch (NumberFormatException nfe) {
                                tableAliasNameR[i] = tableAliaswhere.substring(0, tableAliaswhere.lastIndexOf("."));
                            }
                        }
                    }
                    wiTables.add(tableAliasNameL[i] + tableAliasNameR[i]);
                }
                catch (Exception e) {
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean isWhereItemInClauseIsMultipleAndNotSubquery(WhereItem whereItem) {
        WhereColumn leftWhereColumn;
        boolean isWhereItemNormal = false;
        String whereItemOperator = whereItem.getOperator();
        SelectQueryStatement rightWhereSubquery = whereItem.getRightWhereSubQuery();
        WhereColumn rightWhereExpression = whereItem.getRightWhereExp();
        if (whereItemOperator != null && (whereItemOperator.equalsIgnoreCase("IN") || whereItemOperator.equalsIgnoreCase("NOT IN")) && rightWhereExpression != null && rightWhereSubquery == null && (leftWhereColumn = whereItem.getLeftWhereExp()).getColumnExpression() != null && leftWhereColumn.getColumnExpression().size() != 1) {
            Vector colExpr = leftWhereColumn.getColumnExpression();
            for (int i = 0; i < colExpr.size(); ++i) {
                if (!colExpr.get(i).toString().trim().equals(",")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isWhereItemEqualsClauseIsMultipleAndNotSubquery(WhereItem whereItem) {
        boolean isWhereItemNormal = false;
        String whereItemOperator = whereItem.getOperator2();
        SelectQueryStatement rightWhereSubquery = whereItem.getRightWhereSubQuery();
        WhereColumn rightWhereExpression = whereItem.getRightWhereExp();
        return whereItemOperator != null && (whereItemOperator.equalsIgnoreCase("ALL") || whereItemOperator.equalsIgnoreCase("ANY") || whereItemOperator.equalsIgnoreCase("SOME")) && rightWhereExpression != null && rightWhereSubquery == null;
    }

    private void setNewFromClauseWithInformixJoin(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs, int database) throws ConvertException {
        if (from_sqs == null) {
            return;
        }
        FromClause fromClause = to_sqs.getFromClause();
        if (fromClause != null) {
            FromClause newFromClause = new FromClause();
            Vector newFromItemList = new Vector();
            newFromClause.setFromClause("FROM");
            newFromClause.setFromItemList(newFromItemList);
            Vector fromItemList = fromClause.getFromItemList();
            Vector whereItemList = new Vector();
            Vector operatorList = new Vector();
            Vector[] joinExpression = new Vector[fromItemList.size()];
            this.loadWhereItemsOperators(whereItemList, operatorList);
            if (this.isMetaDataRequired(to_sqs, from_sqs)) {
                String exceptionString = new String();
                exceptionString = "The given query involves theta join to INFORMIX join.\nIt needs metadata for conversion";
                throw new ConvertException(exceptionString);
            }
            this.groupWhereItems(whereItemList, joinExpression, to_sqs, from_sqs, database);
            boolean index = false;
            boolean fromChanged = false;
            Vector<String> outerJoinTableItems = new Vector<String>();
            for (int i = 0; i < whereItemList.size(); ++i) {
                WhereItem wit = (WhereItem)whereItemList.get(i);
                if (wit.getLeftJoin() != null) {
                    if (!outerJoinTableItems.contains(this.getTableAliasWhereR(wit))) {
                        outerJoinTableItems.add(this.getTableAliasWhereR(wit));
                    }
                } else if (wit.getRightJoin() != null && !outerJoinTableItems.contains(this.getTableAliasWhereL(wit))) {
                    outerJoinTableItems.add(this.getTableAliasWhereL(wit));
                }
                String tableAliasL = this.getTableAliasWhereL(wit);
            }
            Vector<FromTable> newFromItemListWithOuter = new Vector<FromTable>();
            StringBuffer outerTableNames = new StringBuffer();
            boolean isOuterSet = false;
            for (int i = 0; i < fromItemList.size(); ++i) {
                FromTable fromTable = null;
                if (fromItemList.get(i) instanceof FromTable) {
                    fromTable = (FromTable)fromItemList.get(i);
                }
                if (outerJoinTableItems != null && fromTable != null && (outerJoinTableItems.contains(fromTable.getAliasName()) || outerJoinTableItems.contains(fromTable.getTableName().toString()))) {
                    if (!isOuterSet) {
                        outerTableNames.append("OUTER (");
                    }
                    fromChanged = true;
                    for (int j = 0; j < outerJoinTableItems.size(); ++j) {
                        if (fromTable.getAliasName() != null && fromTable.getAliasName().equalsIgnoreCase((String)outerJoinTableItems.get(j))) {
                            if (isOuterSet) {
                                outerTableNames.append(", ");
                            } else {
                                isOuterSet = true;
                            }
                            outerTableNames.append(fromTable.getTableName().toString() + " ");
                            outerTableNames.append(fromTable.getAliasName());
                            continue;
                        }
                        if (!((String)outerJoinTableItems.get(j)).equalsIgnoreCase(fromTable.getTableName().toString())) continue;
                        if (isOuterSet) {
                            outerTableNames.append(", ");
                        } else {
                            isOuterSet = true;
                        }
                        outerTableNames.append(fromTable.getTableName().toString() + " ");
                    }
                    continue;
                }
                newFromItemListWithOuter.add(fromTable);
            }
            if (isOuterSet) {
                outerTableNames.append(") ");
                FromTable outerFromTable = new FromTable();
                outerFromTable.setTableName(outerTableNames.toString());
                newFromItemListWithOuter.insertElementAt(outerFromTable, 0);
            }
            newFromClause.setFromItemList(newFromItemListWithOuter);
            if (fromChanged) {
                to_sqs.setFromClause(newFromClause);
            }
        }
    }

    private void moveOuterWhereItemsAsANSIJoins(Hashtable whereItemList, Vector whereItemsToBeMovedToFromClause, Vector outerTableNames) {
        int getsize = whereItemsToBeMovedToFromClause.size();
        int count2 = 0;
        if (outerTableNames != null) {
            for (int j = 0; j < getsize; ++j) {
                String obj;
                WhereItem whereItem = (WhereItem)whereItemsToBeMovedToFromClause.get(j - count2);
                WhereColumn leftWhereExp = whereItem.getLeftWhereExp();
                WhereColumn rightWhereExp = whereItem.getRightWhereExp();
                String tableOrAliasNameForLeftExp = new String("");
                String tableOrAliasNameForRightExp = new String("");
                if (leftWhereExp != null && leftWhereExp.getColumnExpression() != null && rightWhereExp != null && rightWhereExp.getColumnExpression() != null) {
                    String tableAliaswhere;
                    TableColumn tableColumn;
                    if (leftWhereExp.getColumnExpression().get(0) instanceof TableColumn) {
                        tableColumn = new TableColumn();
                        tableColumn = (TableColumn)leftWhereExp.getColumnExpression().get(0);
                        tableOrAliasNameForLeftExp = tableColumn.getOwnerName() != null ? tableColumn.getOwnerName() + "." + tableColumn.getTableName() : tableColumn.getTableName();
                    }
                    if (leftWhereExp.getColumnExpression().get(0) instanceof String && (tableAliaswhere = (String)leftWhereExp.getColumnExpression().get(0)).indexOf(".") != -1) {
                        tableOrAliasNameForLeftExp = tableAliaswhere.substring(0, tableAliaswhere.lastIndexOf("."));
                    }
                    if (rightWhereExp.getColumnExpression().get(0) instanceof TableColumn) {
                        tableColumn = new TableColumn();
                        tableColumn = (TableColumn)rightWhereExp.getColumnExpression().get(0);
                        tableOrAliasNameForRightExp = tableColumn.getOwnerName() != null ? tableColumn.getOwnerName() + "." + tableColumn.getTableName() : tableColumn.getTableName();
                    }
                    if (rightWhereExp.getColumnExpression().get(0) instanceof String && (tableAliaswhere = (String)rightWhereExp.getColumnExpression().get(0)).indexOf(".") != -1) {
                        tableOrAliasNameForRightExp = tableAliaswhere.substring(0, tableAliaswhere.lastIndexOf("."));
                    }
                    if (outerTableNames.contains(tableOrAliasNameForRightExp) || outerTableNames.contains(tableOrAliasNameForLeftExp)) continue;
                    obj = "" + j;
                    whereItemList.put(obj, whereItemsToBeMovedToFromClause.get(j - count2));
                    whereItemsToBeMovedToFromClause.removeElementAt(j - count2);
                    ++count2;
                    continue;
                }
                obj = "" + j;
                whereItemList.put(obj, whereItemsToBeMovedToFromClause.get(j - count2));
                whereItemsToBeMovedToFromClause.removeElementAt(j - count2);
                ++count2;
            }
        } else {
            for (int i = 0; i < getsize; ++i) {
                String obj = "" + i;
                whereItemList.put(obj, whereItemsToBeMovedToFromClause.get(i - count2));
                whereItemsToBeMovedToFromClause.removeElementAt(i - count2);
                ++count2;
            }
        }
    }

    private Vector putObjectsInOneList(Vector columnList) {
        Vector returnObjects = new Vector();
        if (columnList != null) {
            for (int i = 0; i < columnList.size(); ++i) {
                if (columnList.get(i) instanceof SelectColumn) {
                    SelectColumn sc = (SelectColumn)columnList.get(i);
                    Vector selectList = this.putObjectsInOneList(sc.getColumnExpression());
                    returnObjects.addAll(selectList);
                    continue;
                }
                if (columnList.get(i) instanceof FunctionCalls) {
                    FunctionCalls fc = (FunctionCalls)columnList.get(i);
                    Vector functionsList = this.putObjectsInOneList(fc.getFunctionArguments());
                    returnObjects.addAll(functionsList);
                    continue;
                }
                returnObjects.add(columnList.get(i));
            }
        }
        return returnObjects;
    }

    private String getTableAliasName(WhereColumn wc) {
        TableColumn tc = new TableColumn();
        String aliasname = "";
        if (wc != null && wc.getColumnExpression() != null) {
            CaseStatement cs;
            String tableName;
            String tableAliaswhere;
            if (wc.getColumnExpression().get(0) instanceof TableColumn) {
                tc = (TableColumn)wc.getColumnExpression().get(0);
                if (tc.getTableName() == null && tc.getColumnName().trim().equals("?")) {
                    tableAliaswhere = tc.getColumnName();
                    aliasname = "";
                } else {
                    aliasname = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                }
            }
            if (wc.getColumnExpression().get(0) instanceof FunctionCalls) {
                FunctionCalls fc = (FunctionCalls)wc.getColumnExpression().get(0);
                Vector functionObjects = this.putObjectsInOneList(fc.getFunctionArguments());
                if (functionObjects.size() > 0) {
                    if (functionObjects.get(0) instanceof TableColumn) {
                        tc = (TableColumn)functionObjects.get(0);
                        if (tc.getTableName() == null || tc.getColumnName().trim().equals("?")) {
                            String tableAliaswhere2 = tc.getColumnName();
                            aliasname = "";
                        } else {
                            aliasname = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                        }
                    } else if (functionObjects.get(0) instanceof SelectColumn) {
                        SelectColumn sc = (SelectColumn)functionObjects.get(0);
                        if (sc.getColumnExpression() != null) {
                            for (int index = 0; index < sc.getColumnExpression().size(); ++index) {
                                if (!(sc.getColumnExpression().get(index) instanceof TableColumn)) continue;
                                tc = (TableColumn)sc.getColumnExpression().get(index);
                                if (tc.getTableName() == null || tc.getColumnName().trim().equals("?")) {
                                    String tableAliaswhere3 = tc.getColumnName();
                                    aliasname = "";
                                    continue;
                                }
                                aliasname = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                            }
                        }
                    } else if (functionObjects.get(0) instanceof String) {
                        String tableAliaswhere4 = (String)functionObjects.get(0);
                        if (tableAliaswhere4.indexOf(46) != -1) {
                            if (tableAliaswhere4.indexOf(46) != tableAliaswhere4.lastIndexOf(46)) {
                                if (SwisSQLOptions.removeDBSchemaQualifier) {
                                    tableAliaswhere4 = tableAliaswhere4.substring(tableAliaswhere4.indexOf(".") + 1);
                                }
                                aliasname = tableAliaswhere4.substring(0, tableAliaswhere4.lastIndexOf("."));
                            } else {
                                aliasname = tableAliaswhere4.substring(0, tableAliaswhere4.indexOf("."));
                            }
                        } else {
                            aliasname = "";
                        }
                    } else if (functionObjects.get(0) instanceof NumericClass && functionObjects.size() == 2) {
                        if (functionObjects.get(1) instanceof TableColumn) {
                            TableColumn tc1 = (TableColumn)functionObjects.get(1);
                            aliasname = tc1.getTableName();
                        } else if (functionObjects.get(1) instanceof String) {
                            String tableAliaswhere5 = (String)functionObjects.get(1);
                            if (tableAliaswhere5.indexOf(46) != -1) {
                                if (tableAliaswhere5.indexOf(46) != tableAliaswhere5.lastIndexOf(46)) {
                                    if (SwisSQLOptions.removeDBSchemaQualifier) {
                                        tableAliaswhere5 = tableAliaswhere5.substring(tableAliaswhere5.indexOf(".") + 1);
                                    }
                                    aliasname = tableAliaswhere5.substring(0, tableAliaswhere5.lastIndexOf("."));
                                } else {
                                    aliasname = tableAliaswhere5.substring(0, tableAliaswhere5.indexOf("."));
                                }
                            } else {
                                aliasname = "";
                            }
                        } else {
                            aliasname = "";
                        }
                    }
                } else {
                    aliasname = tc.getOwnerName() != null && !SwisSQLOptions.removeDBSchemaQualifier ? tc.getOwnerName() + "." + tc.getTableName() : tc.getTableName();
                }
            }
            if (wc.getColumnExpression().get(0) instanceof CaseStatement && (tableName = this.getTableAliasName(cs = (CaseStatement)wc.getColumnExpression().get(0))) != null && !tableName.equals("")) {
                aliasname = tableName;
            }
            if (wc.getColumnExpression().get(0) instanceof String) {
                tableAliaswhere = (String)wc.getColumnExpression().get(0);
                if (tableAliaswhere.indexOf(46) != -1) {
                    if (tableAliaswhere.indexOf(46) != tableAliaswhere.lastIndexOf(46)) {
                        if (SwisSQLOptions.removeDBSchemaQualifier) {
                            tableAliaswhere = tableAliaswhere.substring(tableAliaswhere.indexOf(".") + 1);
                        }
                        aliasname = tableAliaswhere.substring(0, tableAliaswhere.lastIndexOf("."));
                    } else {
                        aliasname = tableAliaswhere.substring(0, tableAliaswhere.indexOf("."));
                    }
                } else {
                    aliasname = "";
                }
            }
        } else {
            aliasname = "";
        }
        return aliasname;
    }

    private void addWhereExpToANSIJOIN(SelectQueryStatement to_sqs, WhereExpression we) {
        if (to_sqs != null && to_sqs.getFromClause() != null && to_sqs.getFromClause().getFromItemList() != null) {
            Vector fromItems = to_sqs.getFromClause().getFromItemList();
            for (int i = 0; i < fromItems.size(); ++i) {
                FromTable fromTable;
                if (!(fromItems.get(i) instanceof FromTable) || (fromTable = (FromTable)fromItems.get(i)) == null || fromTable.getJoinExpression() == null) continue;
                for (int j = 0; j < fromTable.getJoinExpression().size(); ++j) {
                    WhereExpression whereExp;
                    if (!(fromTable.getJoinExpression().get(j) instanceof WhereExpression) || (whereExp = (WhereExpression)fromTable.getJoinExpression().get(j)) == null) continue;
                    Vector whereItems = whereExp.getWhereItems();
                    for (int k = 0; k < whereItems.size(); ++k) {
                        WhereItem whereItem;
                        if (!(whereItems.get(k) instanceof WhereItem) || (whereItem = (WhereItem)whereItems.get(k)).getLeftWhereExp() == null || whereItem.getRightWhereExp() == null) continue;
                        WhereColumn leftColumn = whereItem.getLeftWhereExp();
                        WhereColumn rightColumn = whereItem.getRightWhereExp();
                        Vector to_sqsWhereItems = we.getWhereItems();
                        Vector we_Operators = we.getOperator();
                        for (int l = 0; l < to_sqsWhereItems.size(); ++l) {
                            WhereItem to_sqsWhereItem;
                            if (!(to_sqsWhereItems.get(l) instanceof WhereItem) || (to_sqsWhereItem = (WhereItem)to_sqsWhereItems.get(l)) == null || to_sqsWhereItem.getLeftWhereExp() == null || to_sqsWhereItem.getRightWhereExp() != null) continue;
                            WhereColumn to_sqlWhereColumn = to_sqsWhereItem.getLeftWhereExp();
                            if (!leftColumn.toString().contentEquals(new StringBuffer(to_sqlWhereColumn.toString())) && !rightColumn.toString().contentEquals(new StringBuffer(to_sqlWhereColumn.toString()))) continue;
                            if (l > 0) {
                                if (we_Operators.get(l - 1).toString().equalsIgnoreCase("&AND")) {
                                    if (we_Operators.size() > 0) {
                                        ((WhereExpression)((FromTable)fromItems.get(i)).getJoinExpression().get(j)).addOperator("AND");
                                    }
                                } else if (we_Operators.size() > 0) {
                                    ((WhereExpression)((FromTable)fromItems.get(i)).getJoinExpression().get(j)).addOperator((String)we_Operators.get(l - 1));
                                }
                            } else if (l == 0 && we_Operators.size() > 0) {
                                ((WhereExpression)((FromTable)fromItems.get(i)).getJoinExpression().get(j)).addOperator((String)we_Operators.get(l));
                            }
                            ((WhereExpression)((FromTable)fromItems.get(i)).getJoinExpression().get(j)).addWhereItem(to_sqsWhereItem);
                            we.getWhereItems().removeElement(to_sqsWhereItems.get(l));
                            if (l == 0) {
                                if (we.getOperator().size() <= 0) continue;
                                we.getOperator().removeElementAt(l);
                                continue;
                            }
                            if (l <= 0 || we.getOperator().size() <= 0) continue;
                            we.getOperator().removeElementAt(l - 1);
                        }
                    }
                }
            }
        }
    }

    public void replaceRownumTableColumn(Object newColumn) throws ConvertException {
        for (int j = 0; j < this.whereItems.size(); ++j) {
            Object wiObj = this.whereItems.get(j);
            if (wiObj == null) continue;
            if (wiObj instanceof WhereItem) {
                ((WhereItem)wiObj).replaceRownumTableColumn(newColumn);
                continue;
            }
            if (!(wiObj instanceof WhereExpression)) continue;
            ((WhereExpression)wiObj).replaceRownumTableColumn(newColumn);
        }
    }

    private String getTableAliasName(FunctionCalls fc) {
        CaseStatement cs;
        WhereItem cswi;
        SelectColumn cssc;
        String tableName;
        FunctionCalls fnc;
        String aliasname = "";
        FunctionCalls lclFnCl = fc;
        Vector functionArguments = lclFnCl.getFunctionArguments();
        if (functionArguments != null) {
            for (int j = 0; j < functionArguments.size(); ++j) {
                String tableName2;
                if (!(functionArguments.get(j) instanceof SelectColumn) || (tableName2 = this.getTableAliasWhereR((SelectColumn)functionArguments.get(j))) == null || tableName2.equals("")) continue;
                return tableName2;
            }
        } else if (functionArguments == null && lclFnCl instanceof decode && (fnc = fc).toString().trim().toLowerCase().startsWith("case") && fnc instanceof decode && (tableName = this.getTableAliasWhereR(cssc = (SelectColumn)(cswi = (WhereItem)(cs = ((decode)fnc).getCaseStatement()).getCaseCondition().getWhereItem().get(0)).getLeftWhereExp().getColumnExpression().get(0))) != null && !tableName.equals("")) {
            return tableName;
        }
        return aliasname;
    }

    private String getTableAliasName(CaseStatement cs) {
        Object wiObj;
        String aliasname = "";
        WhereItem cswi = null;
        if (cs.getCaseCondition() != null) {
            wiObj = cs.getCaseCondition().getWhereItem().get(0);
            if (wiObj instanceof WhereItem) {
                cswi = (WhereItem)wiObj;
            } else if (wiObj instanceof WhereExpression) {
                cswi = (WhereItem)((WhereExpression)wiObj).getWhereItems().get(0);
            }
        } else {
            wiObj = ((WhenStatement)cs.getWhenClauseList().get(0)).getWhenCondition().getWhereItem().get(0);
            if (wiObj instanceof WhereItem) {
                cswi = (WhereItem)wiObj;
            } else if (wiObj instanceof WhereExpression) {
                if (((WhereExpression)wiObj).getWhereItems().get(0) instanceof WhereItem) {
                    cswi = (WhereItem)((WhereExpression)wiObj).getWhereItems().get(0);
                } else if (((WhereExpression)wiObj).getWhereItems().get(0) instanceof WhereExpression) {
                    cswi = (WhereItem)((WhereExpression)((WhereExpression)wiObj).getWhereItems().get(0)).getWhereItems().get(0);
                }
            }
        }
        if (cswi != null) {
            Object cssc = cswi.getLeftWhereExp().getColumnExpression().get(0);
            if (cssc instanceof SelectColumn) {
                String tableName = this.getTableAliasWhereR((SelectColumn)cssc);
                if (tableName != null && !tableName.equals("")) {
                    return tableName;
                }
            } else {
                FunctionCalls fc;
                String tableName;
                if (cssc instanceof TableColumn) {
                    TableColumn cscol = (TableColumn)cssc;
                    if (cscol.getOwnerName() != null) {
                        return cscol.getOwnerName() + "." + cscol.getTableName();
                    }
                    return cscol.getTableName();
                }
                if (cssc instanceof FunctionCalls && (tableName = this.getTableAliasName(fc = (FunctionCalls)cssc)) != null && !tableName.equals("")) {
                    return tableName;
                }
            }
        }
        return aliasname;
    }
}

