/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.select;

import com.adventnet.swissqlapi.SwisSQLAPI;
import com.adventnet.swissqlapi.config.SwisSQLOptions;
import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.statement.SwisSQLStatement;
import com.adventnet.swissqlapi.sql.statement.select.CaseStatement;
import com.adventnet.swissqlapi.sql.statement.select.FromClause;
import com.adventnet.swissqlapi.sql.statement.select.FromTable;
import com.adventnet.swissqlapi.sql.statement.select.LimitClause;
import com.adventnet.swissqlapi.sql.statement.select.RownumClause;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhenStatement;
import com.adventnet.swissqlapi.sql.statement.select.WhereColumn;
import com.adventnet.swissqlapi.sql.statement.select.WhereExpression;
import com.adventnet.swissqlapi.util.SwisSQLUtils;
import com.adventnet.swissqlapi.util.database.MetadataInfoUtil;
import com.adventnet.swissqlapi.util.misc.CustomizeUtil;
import com.adventnet.swissqlapi.util.misc.StringFunctions;
import java.util.ArrayList;
import java.util.Vector;

public class WhereItem {
    private String openBraces = new String("");
    private String closeBraces = new String("");
    private WhereColumn leftWhereExp;
    private WhereColumn rightWhereExp;
    private String LeftJoin;
    private String RightJoin;
    private SelectQueryStatement rightWhereSubQuery;
    private WhereColumn rightWhereSubQueryExp;
    private String beginOperator;
    private UserObjectContext context = null;
    private boolean movedToFromClause = false;
    private boolean isContainsFunction = false;
    private String operator1;
    private String operator;
    private String operator2;
    private String operator3;
    private RownumClause rownumClause;
    private ArrayList fromTableList;
    private String stmtTableName;
    private WhereExpression lnnvlWhereExp;
    private CaseStatement casestmtFromLNNVLClause;
    private WhereItem teradataSysCalendarWI;
    private boolean is_Case_Expression = false;
    private Vector regExp;

    public void setObjectContext(UserObjectContext context) {
        this.context = context;
    }

    public void setLeftWhereExp(WhereColumn lwe) {
        this.leftWhereExp = lwe;
        if (this.leftWhereExp != null) {
            this.leftWhereExp.setLHSExpr(true);
        }
    }

    public void setMovedToFromClause(boolean b) {
        this.movedToFromClause = b;
    }

    public void setOpenBrace(String s_ob) {
        this.openBraces = s_ob;
    }

    public void setCloseBrace(String s_cb) {
        this.closeBraces = s_cb;
    }

    public void setRightWhereExp(WhereColumn rwe) {
        this.rightWhereExp = rwe;
    }

    public void setOperator(String opr) {
        this.operator = opr;
    }

    public void setOperator1(String opr) {
        this.operator1 = opr;
    }

    public void setOperator2(String opr) {
        this.operator2 = opr;
    }

    public void setOperator3(String s_opr) {
        this.operator3 = s_opr;
    }

    public void setBeginOperator(String begin) {
        this.beginOperator = begin;
    }

    public void setRightWhereSubQuery(SelectQueryStatement qs) {
        this.rightWhereSubQuery = qs;
    }

    public void setRightWhereSubQueryExp(WhereColumn wc) {
        this.rightWhereSubQueryExp = wc;
    }

    public void setFromTableList(ArrayList fromTableList) {
        this.fromTableList = fromTableList;
    }

    public void setRightJoin(String s_rj) {
        this.RightJoin = s_rj;
    }

    public void setLeftJoin(String s_lj) {
        this.LeftJoin = s_lj;
    }

    public void setStmtTableName(String stmtTableName) {
        this.stmtTableName = stmtTableName;
    }

    public void setWhereExpForLNNVL(WhereExpression we) {
        this.lnnvlWhereExp = we;
    }

    public void setCaseStatementForLNNVLFunc(CaseStatement cs) {
        this.casestmtFromLNNVLClause = cs;
    }

    public void setTeradataSysCalendarWhereItem(WhereItem tdWI) {
        this.teradataSysCalendarWI = tdWI;
    }

    public void setCaseExpressionBool(boolean boolVal) {
        this.is_Case_Expression = boolVal;
    }

    public void setRegExp(Vector exp2) {
        this.regExp = exp2;
    }

    public CaseStatement getCaseStatementForLNNVLFunc() {
        return this.casestmtFromLNNVLClause;
    }

    public WhereExpression getWhereExpForLNNVL() {
        return this.lnnvlWhereExp;
    }

    public String getRightJoin() {
        return this.RightJoin;
    }

    public String getLeftJoin() {
        return this.LeftJoin;
    }

    public String getBeginOperator() {
        return this.beginOperator;
    }

    public WhereColumn getLeftWhereExp() {
        return this.leftWhereExp;
    }

    public WhereColumn getRightWhereExp() {
        return this.rightWhereExp;
    }

    public SelectQueryStatement getRightWhereSubQuery() {
        return this.rightWhereSubQuery;
    }

    public WhereColumn getRightWhereSubQueryExp() {
        return this.rightWhereSubQueryExp;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getOperator1() {
        return this.operator1;
    }

    public String getOperator2() {
        return this.operator2;
    }

    public String getOperator3() {
        return this.operator3;
    }

    public void setRownumClause(RownumClause rc) {
        this.rownumClause = rc;
    }

    public String getOpenBrace() {
        return this.openBraces;
    }

    public String getCloseBrace() {
        return this.closeBraces;
    }

    public void removeBraces() {
        if (this.openBraces != null && this.openBraces.length() > 0) {
            this.openBraces = this.openBraces.substring(1);
            if (this.closeBraces != null && this.closeBraces.length() > 0) {
                this.closeBraces = this.closeBraces.substring(1);
            }
        }
    }

    public Vector getRegExp() {
        return this.regExp;
    }

    public RownumClause getRownumClause() {
        return this.rownumClause;
    }

    public boolean getMovedToFromClause() {
        return this.movedToFromClause;
    }

    public WhereItem getTeradataSysCalendarWhereItem() {
        return this.teradataSysCalendarWI;
    }

    public WhereItem toMySQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (this.movedToFromClause) {
            return null;
        }
        if (this.rownumClause != null) {
            return null;
        }
        WhereItem wi = new WhereItem();
        wi.setOpenBrace(this.openBraces);
        wi.setCloseBrace(this.closeBraces);
        if (this.beginOperator != null) {
            wi.setBeginOperator(this.beginOperator);
        }
        if (this.operator1 != null) {
            wi.setOperator1(this.operator1);
        }
        if (this.leftWhereExp != null) {
            wi.setLeftWhereExp(this.leftWhereExp.toMySQLSelect(to_sqs, from_sqs));
        }
        if (this.rightWhereExp != null) {
            wi.setRightWhereExp(this.rightWhereExp.toMySQLSelect(to_sqs, from_sqs));
        }
        if (this.rightWhereSubQuery != null) {
            wi.setRightWhereSubQuery(this.rightWhereSubQuery.toMySQLSelect());
            if (this.rightWhereSubQueryExp != null) {
                wi.setRightWhereSubQueryExp(this.rightWhereSubQueryExp.toMySQLSelect(to_sqs, from_sqs));
            }
        }
        if (this.operator != null) {
            WhereColumn wc;
            if (this.operator.equalsIgnoreCase("^=")) {
                wi.setOperator("<>");
            } else if (this.operator.equalsIgnoreCase("!>")) {
                wi.setOperator("<=");
            } else if (this.operator.equalsIgnoreCase("!<")) {
                wi.setOperator(">=");
            } else if (this.operator.equalsIgnoreCase("~") | this.operator.equalsIgnoreCase("~*")) {
                wi.setOperator("LIKE");
                if (wi.getRightWhereSubQuery() != null) {
                    throw new ConvertException("Conversion failure.. Subquery can't be converted");
                }
                wc = wi.getRightWhereExp();
                Vector v_ce = wc.getColumnExpression();
                Vector<String> v_nce = new Vector<String>();
                if (v_ce != null) {
                    if (v_ce.size() != 1) {
                        throw new ConvertException("Conversion failure..Expressions can't be converted");
                    }
                    String s_ce = v_ce.elementAt(0).toString();
                    if (s_ce.charAt(0) == '\'') {
                        s_ce = s_ce.replace('\'', ' ').trim();
                        s_ce = "'%" + s_ce + "%'";
                    } else if (s_ce.charAt(0) == '\"') {
                        s_ce = s_ce.replace('\"', ' ').trim();
                        s_ce = "\"%" + s_ce + "%\"";
                    } else {
                        s_ce = "'%" + s_ce + "%'";
                    }
                    v_nce.addElement(s_ce);
                    wc.setColumnExpression(v_nce);
                }
                wi.setRightWhereExp(wc);
            } else if (this.operator.equalsIgnoreCase("MATCHES") || this.operator.equalsIgnoreCase("NOT MATCHES")) {
                if (this.operator.equalsIgnoreCase("MATCHES")) {
                    wi.setOperator("LIKE");
                } else {
                    wi.setOperator("NOT LIKE");
                }
                WhereColumn whereColumn = wi.getRightWhereExp();
                Vector columnExpression = whereColumn.getColumnExpression();
                Vector<String> newColumnExpression = new Vector<String>();
                if (columnExpression != null) {
                    String ColumnExpressionAsString = columnExpression.elementAt(0).toString();
                    if (ColumnExpressionAsString.indexOf("*") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('*', '%');
                    }
                    if (ColumnExpressionAsString.indexOf("_") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('_', '?');
                    }
                    newColumnExpression.add(ColumnExpressionAsString);
                    whereColumn.setColumnExpression(newColumnExpression);
                }
            } else if (this.operator.equalsIgnoreCase("IN") | this.operator.equalsIgnoreCase("NOT IN") && wi.getRightWhereExp() != null) {
                wc = wi.getRightWhereExp();
                Vector<String> v_nsce = new Vector<String>();
                Vector v_sce = wc.getColumnExpression();
                if (v_sce != null && v_sce.size() > 0 && !(v_sce.elementAt(0) instanceof String)) {
                    v_nsce.addElement("(");
                    for (int i = 0; i < v_sce.size(); ++i) {
                        v_nsce.addElement((String)v_sce.elementAt(i));
                    }
                    v_nsce.addElement(")");
                    wc.setColumnExpression(v_nsce);
                }
                wi.setOperator(this.operator);
            } else {
                wi.setOperator(this.operator);
            }
        }
        if (this.operator2 != null && wi.getRightWhereSubQuery() == null && wi.getRightWhereExp() != null) {
            WhereColumn r_wc = wi.getRightWhereExp();
            WhereColumn l_wc = wi.getLeftWhereExp();
            if (r_wc != null && r_wc.getColumnExpression().size() != 1) {
                String s_ce;
                int i;
                Vector v_nlsce = new Vector();
                Vector v_nrsce = new Vector();
                Vector v_lsce = l_wc.getColumnExpression();
                Vector v_rsce = r_wc.getColumnExpression();
                Vector v_removedcomma_right_column_exp = new Vector();
                Vector v_removedcomma_left_column_exp = new Vector();
                for (i = 0; i < v_lsce.size(); ++i) {
                    if (v_lsce.elementAt(i) instanceof String) {
                        s_ce = (String)v_lsce.elementAt(i);
                        if (s_ce.equalsIgnoreCase(",") || s_ce.equalsIgnoreCase("(") || s_ce.equalsIgnoreCase(")")) continue;
                        v_removedcomma_left_column_exp.addElement(v_lsce.elementAt(i));
                        continue;
                    }
                    v_removedcomma_left_column_exp.addElement(v_lsce.elementAt(i));
                }
                for (i = 0; i < v_rsce.size(); ++i) {
                    if (v_rsce.elementAt(i) instanceof String) {
                        s_ce = (String)v_rsce.elementAt(i);
                        if (s_ce.equalsIgnoreCase(",") || s_ce.equalsIgnoreCase("(") || s_ce.equalsIgnoreCase(")")) continue;
                        v_removedcomma_right_column_exp.addElement(v_rsce.elementAt(i));
                        continue;
                    }
                    v_removedcomma_right_column_exp.addElement(v_rsce.elementAt(i));
                }
                v_nlsce.addElement(v_removedcomma_left_column_exp.elementAt(0));
                v_nrsce.addElement(v_removedcomma_right_column_exp.elementAt(0));
                l_wc.setColumnExpression(v_nlsce);
                r_wc.setColumnExpression(v_nrsce);
                for (i = 1; i < v_removedcomma_right_column_exp.size(); ++i) {
                    WhereItem n_wi = new WhereItem();
                    WhereColumn l_nwc = new WhereColumn();
                    WhereColumn r_nwc = new WhereColumn();
                    Vector v_lnsc = new Vector();
                    Vector v_rnsc = new Vector();
                    v_lnsc.addElement(v_removedcomma_left_column_exp.elementAt(0));
                    v_rnsc.addElement(v_removedcomma_right_column_exp.elementAt(i));
                    l_nwc.setColumnExpression(v_lnsc);
                    r_nwc.setColumnExpression(v_rnsc);
                    n_wi.setLeftWhereExp(l_nwc);
                    n_wi.setRightWhereExp(r_nwc);
                    n_wi.setOperator(this.operator);
                    if (i == v_lsce.size() - 1) {
                        from_sqs.getWhereExpression().addWhereItem(n_wi);
                        continue;
                    }
                    if (this.operator2.equalsIgnoreCase("ALL")) {
                        from_sqs.getWhereExpression().addOperator("AND");
                    } else {
                        from_sqs.getWhereExpression().addOperator("OR");
                    }
                    from_sqs.getWhereExpression().addWhereItem(n_wi);
                }
            }
        }
        if (wi.getRightWhereSubQuery() != null && this.operator2 != null) {
            wi.setOperator2(this.operator2);
        }
        if (this.operator3 != null) {
            wi.setOperator3(this.operator3);
        }
        if (this.LeftJoin != null) {
            wi.setLeftJoin(null);
        }
        if (this.RightJoin != null) {
            wi.setRightJoin(null);
        }
        return wi;
    }

    public boolean convertRownumToLimitClause(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (this.leftWhereExp != null) {
            Vector v_ce = this.leftWhereExp.getColumnExpression();
            if (v_ce != null && v_ce.size() == 1 && v_ce.elementAt(0) instanceof TableColumn) {
                TableColumn tc = (TableColumn)v_ce.elementAt(0);
                if (!tc.getColumnName().equalsIgnoreCase("ROWNUM")) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.operator == null || !this.operator.equals("<")) {
            return false;
        }
        if (this.rightWhereExp != null) {
            if (from_sqs.getLimitClause() != null) {
                throw new ConvertException();
            }
        } else {
            return false;
        }
        LimitClause lc = new LimitClause();
        lc.setLimitClause("LIMIT");
        lc.setLimitValue(this.rightWhereExp.toMySQLSelect(to_sqs, from_sqs).toString());
        to_sqs.setLimitClause(lc);
        return true;
    }

    public WhereItem toDB2Select(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        Vector rColExpr;
        Vector colExpr;
        WhereColumn rwcol;
        if (this.movedToFromClause) {
            return null;
        }
        if (this.rownumClause != null) {
            return null;
        }
        WhereItem wi = new WhereItem();
        wi.setOpenBrace(this.openBraces);
        wi.setCloseBrace(this.closeBraces);
        wi.setFromTableList(this.fromTableList);
        if (this.beginOperator != null) {
            wi.setBeginOperator(this.beginOperator);
        }
        if (this.operator1 != null) {
            wi.setOperator1(this.operator1);
        }
        if (this.leftWhereExp != null) {
            this.leftWhereExp.setStmtTableName(this.stmtTableName);
            this.leftWhereExp.setFromTableList(this.fromTableList);
            wi.setLeftWhereExp(this.leftWhereExp.toDB2Select(to_sqs, from_sqs));
        }
        if (this.rightWhereExp != null) {
            if (this.leftWhereExp != null) {
                this.rightWhereExp.setTargetDataType(this.leftWhereExp.getSourceDataType());
            }
            this.rightWhereExp.setStmtTableName(this.stmtTableName);
            this.rightWhereExp.setFromTableList(this.fromTableList);
            wi.setRightWhereExp(this.rightWhereExp.toDB2Select(to_sqs, from_sqs));
        }
        if (this.rightWhereSubQuery != null) {
            wi.setRightWhereSubQuery(this.rightWhereSubQuery.toDB2Select());
            if (this.rightWhereSubQueryExp != null) {
                wi.setRightWhereSubQueryExp(this.rightWhereSubQueryExp.toDB2Select(to_sqs, from_sqs));
            }
        }
        if (this.operator != null) {
            if (this.operator.equalsIgnoreCase("~") | this.operator.equalsIgnoreCase("~*")) {
                wi.setOperator("LIKE");
                if (wi.getRightWhereSubQuery() != null) {
                    throw new ConvertException("Conversion failure.. Subquery can't be converted");
                }
                WhereColumn wc = wi.getRightWhereExp();
                Vector v_ce = wc.getColumnExpression();
                Vector<String> v_nce = new Vector<String>();
                if (v_ce != null) {
                    if (v_ce.size() != 1) {
                        throw new ConvertException("Conversion failure.. Expressions can't be converted");
                    }
                    String s_ce = v_ce.elementAt(0).toString();
                    if (s_ce.charAt(0) == '\'') {
                        s_ce = s_ce.replace('\'', ' ').trim();
                        s_ce = "'%" + s_ce + "%'";
                    } else if (s_ce.charAt(0) == '\"') {
                        s_ce = s_ce.replace('\"', ' ').trim();
                        s_ce = "\"%" + s_ce + "%\"";
                    } else {
                        s_ce = "'%" + s_ce + "%'";
                    }
                    v_nce.addElement(s_ce);
                    wc.setColumnExpression(v_nce);
                }
                wi.setRightWhereExp(wc);
            } else if (this.operator.equalsIgnoreCase("MATCHES") || this.operator.equalsIgnoreCase("NOT MATCHES")) {
                if (this.operator.equalsIgnoreCase("MATCHES")) {
                    wi.setOperator("LIKE");
                } else {
                    wi.setOperator("NOT LIKE");
                }
                WhereColumn whereColumn = wi.getRightWhereExp();
                Vector columnExpression = whereColumn.getColumnExpression();
                Vector<String> newColumnExpression = new Vector<String>();
                if (columnExpression != null) {
                    String ColumnExpressionAsString = columnExpression.elementAt(0).toString();
                    if (ColumnExpressionAsString.indexOf("*") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('*', '%');
                    }
                    if (ColumnExpressionAsString.indexOf("_") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('_', '?');
                    }
                    newColumnExpression.add(ColumnExpressionAsString);
                    whereColumn.setColumnExpression(newColumnExpression);
                }
            } else {
                wi.setOperator(this.operator);
            }
        }
        if (this.operator2 != null && wi.getRightWhereSubQuery() == null && wi.getRightWhereExp() != null) {
            WhereColumn r_wc = wi.getRightWhereExp();
            WhereColumn l_wc = wi.getLeftWhereExp();
            if (r_wc.getColumnExpression() != null && r_wc.getColumnExpression().size() != 1) {
                String s_ce;
                int i;
                Vector v_nlsce = new Vector();
                Vector v_nrsce = new Vector();
                Vector v_lsce = l_wc.getColumnExpression();
                Vector v_rsce = r_wc.getColumnExpression();
                Vector v_removedcomma_right_column_exp = new Vector();
                Vector v_removedcomma_left_column_exp = new Vector();
                for (i = 0; i < v_lsce.size(); ++i) {
                    if (v_lsce.elementAt(i) instanceof String) {
                        s_ce = (String)v_lsce.elementAt(i);
                        if (s_ce.equalsIgnoreCase(",") || s_ce.equalsIgnoreCase("(") || s_ce.equalsIgnoreCase(")")) continue;
                        v_removedcomma_left_column_exp.addElement(v_lsce.elementAt(i));
                        continue;
                    }
                    v_removedcomma_left_column_exp.addElement(v_lsce.elementAt(i));
                }
                for (i = 0; i < v_rsce.size(); ++i) {
                    if (v_rsce.elementAt(i) instanceof String) {
                        s_ce = (String)v_rsce.elementAt(i);
                        if (s_ce.equalsIgnoreCase(",") || s_ce.equalsIgnoreCase("(") || s_ce.equalsIgnoreCase(")")) continue;
                        v_removedcomma_right_column_exp.addElement(v_rsce.elementAt(i));
                        continue;
                    }
                    v_removedcomma_right_column_exp.addElement(v_rsce.elementAt(i));
                }
                v_nlsce.addElement(v_removedcomma_left_column_exp.elementAt(0));
                v_nrsce.addElement(v_removedcomma_right_column_exp.elementAt(0));
                l_wc.setColumnExpression(v_nlsce);
                r_wc.setColumnExpression(v_nrsce);
                for (i = 1; i < v_removedcomma_right_column_exp.size(); ++i) {
                    WhereItem n_wi = new WhereItem();
                    WhereColumn l_nwc = new WhereColumn();
                    WhereColumn r_nwc = new WhereColumn();
                    Vector v_lnsc = new Vector();
                    Vector v_rnsc = new Vector();
                    v_lnsc.addElement(v_removedcomma_left_column_exp.elementAt(0));
                    v_rnsc.addElement(v_removedcomma_right_column_exp.elementAt(i));
                    l_nwc.setColumnExpression(v_lnsc);
                    r_nwc.setColumnExpression(v_rnsc);
                    n_wi.setLeftWhereExp(l_nwc);
                    n_wi.setRightWhereExp(r_nwc);
                    n_wi.setOperator(this.operator);
                    if (i == v_lsce.size() - 1) {
                        from_sqs.getWhereExpression().addWhereItem(n_wi);
                        continue;
                    }
                    if (this.operator2.equalsIgnoreCase("ALL")) {
                        from_sqs.getWhereExpression().addOperator("AND");
                    } else {
                        from_sqs.getWhereExpression().addOperator("OR");
                    }
                    from_sqs.getWhereExpression().addWhereItem(n_wi);
                }
            }
        }
        if (wi.getRightWhereSubQuery() != null && this.operator2 != null) {
            wi.setOperator2(this.operator2);
        }
        if (this.operator3 != null) {
            wi.setOperator3(this.operator3);
        }
        if (this.LeftJoin != null) {
            wi.setLeftJoin(null);
        }
        if (this.RightJoin != null) {
            wi.setRightJoin(null);
        }
        boolean change_rightwhere_expression = false;
        String leftside_function_name = "";
        WhereColumn lwcol = wi.getLeftWhereExp();
        if (lwcol != null) {
            Object obj = null;
            Vector lwcolexp = lwcol.getColumnExpression();
            if (lwcolexp != null) {
                obj = lwcolexp.get(0);
            }
            if (obj != null && obj instanceof FunctionCalls) {
                Vector args = ((FunctionCalls)obj).getFunctionArguments();
                String functionname = ((FunctionCalls)obj).getFunctionNameAsAString();
                if (functionname != null) {
                    if (functionname.equalsIgnoreCase("TIMESTAMP")) {
                        leftside_function_name = "TIMESTAMP";
                        change_rightwhere_expression = true;
                    } else if (functionname.equalsIgnoreCase("DATE")) {
                        leftside_function_name = "DATE";
                        change_rightwhere_expression = true;
                    }
                }
            }
        }
        if (change_rightwhere_expression && (rwcol = wi.getRightWhereExp()) != null) {
            Object objr = null;
            Vector rwcolexp = rwcol.getColumnExpression();
            if (rwcolexp != null) {
                objr = rwcolexp.get(0);
            }
            if (objr != null && objr instanceof FunctionCalls) {
                FunctionCalls currentFnCall = objr;
                Vector args = currentFnCall.getFunctionArguments();
                String functionname = currentFnCall.getFunctionNameAsAString();
                if (functionname != null && (functionname.equalsIgnoreCase("CHAR") || functionname.equalsIgnoreCase("SUBSTR"))) {
                    Vector<Object> newFunctionArgumentsV = new Vector<Object>();
                    newFunctionArgumentsV.addElement(currentFnCall);
                    newFunctionArgumentsV.addElement("'00.00.00'");
                    FunctionCalls newFnCall = new FunctionCalls();
                    TableColumn tc = new TableColumn();
                    tc.setColumnName("TIMESTAMP");
                    newFnCall.setFunctionName(tc);
                    newFnCall.setFunctionArguments(newFunctionArgumentsV);
                    Vector<FunctionCalls> newColExpV = new Vector<FunctionCalls>();
                    newColExpV.addElement(newFnCall);
                    rwcol.setColumnExpression(newColExpV);
                    wi.setRightWhereExp(rwcol);
                }
            }
        }
        WhereColumn db2LWE = wi.getLeftWhereExp();
        String leftDataType = null;
        if (db2LWE != null && (colExpr = db2LWE.getColumnExpression()) != null) {
            for (int i = 0; i < colExpr.size(); ++i) {
                Object obj = colExpr.get(i);
                if (!(obj instanceof TableColumn)) continue;
                leftDataType = MetadataInfoUtil.getDatatypeName(from_sqs, (TableColumn)obj);
            }
        }
        WhereColumn db2RWE = wi.getRightWhereExp();
        if (leftDataType != null && (leftDataType.indexOf("int") != -1 || leftDataType.indexOf("num") != -1) && db2RWE != null && db2RWE.getColumnExpression() != null && db2RWE.toString().trim().startsWith("'") && (rColExpr = db2RWE.getColumnExpression()) != null && rColExpr.size() == 1) {
            rColExpr.setElementAt(rColExpr.get(0).toString().trim().substring(1, rColExpr.get(0).toString().trim().length() - 1), 0);
        }
        return wi;
    }

    public WhereItem toANSISelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (this.movedToFromClause) {
            return null;
        }
        if (this.rownumClause != null) {
            return null;
        }
        WhereItem wi = new WhereItem();
        wi.setOpenBrace(this.openBraces);
        wi.setCloseBrace(this.closeBraces);
        if (this.beginOperator != null) {
            wi.setBeginOperator(this.beginOperator);
        }
        if (this.operator1 != null) {
            wi.setOperator1(this.operator1);
        }
        if (this.leftWhereExp != null) {
            wi.setLeftWhereExp(this.leftWhereExp.toANSISelect(to_sqs, from_sqs));
        }
        if (this.rightWhereExp != null) {
            wi.setRightWhereExp(this.rightWhereExp.toANSISelect(to_sqs, from_sqs));
        }
        if (this.rightWhereSubQuery != null) {
            wi.setRightWhereSubQuery(this.rightWhereSubQuery.toANSISelect());
            if (this.rightWhereSubQueryExp != null) {
                wi.setRightWhereSubQueryExp(this.rightWhereSubQueryExp.toANSISelect(to_sqs, from_sqs));
            }
        }
        if (this.operator != null) {
            if (this.operator.equalsIgnoreCase("^=") || this.operator.equalsIgnoreCase("!=")) {
                wi.setOperator("<>");
            } else if (this.operator.equalsIgnoreCase("!>")) {
                wi.setOperator("<=");
            } else if (this.operator.equalsIgnoreCase("!<")) {
                wi.setOperator(">=");
            } else if (this.operator.equalsIgnoreCase("~") | this.operator.equalsIgnoreCase("~*")) {
                wi.setOperator("LIKE");
                if (wi.getRightWhereSubQuery() != null) {
                    throw new ConvertException("Conversion failure.. Subquery can't be converted");
                }
                WhereColumn wc = wi.getRightWhereExp();
                Vector v_ce = wc.getColumnExpression();
                Vector<String> v_nce = new Vector<String>();
                if (v_ce != null) {
                    if (v_ce.size() != 1) {
                        throw new ConvertException("Conversion failure.. Expressions can't be converted");
                    }
                    String s_ce = v_ce.elementAt(0).toString();
                    if (s_ce.charAt(0) == '\'') {
                        s_ce = s_ce.replace('\'', ' ').trim();
                        s_ce = "'%" + s_ce + "%'";
                    } else if (s_ce.charAt(0) == '\"') {
                        s_ce = s_ce.replace('\"', ' ').trim();
                        s_ce = "\"%" + s_ce + "%\"";
                    } else {
                        s_ce = "'%" + s_ce + "%'";
                    }
                    v_nce.addElement(s_ce);
                    wc.setColumnExpression(v_nce);
                }
                wi.setRightWhereExp(wc);
            } else if (this.operator.equalsIgnoreCase("MATCHES") || this.operator.equalsIgnoreCase("NOT MATCHES")) {
                if (this.operator.equalsIgnoreCase("MATCHES")) {
                    wi.setOperator("LIKE");
                } else {
                    wi.setOperator("NOT LIKE");
                }
                WhereColumn whereColumn = wi.getRightWhereExp();
                Vector columnExpression = whereColumn.getColumnExpression();
                Vector<String> newColumnExpression = new Vector<String>();
                if (columnExpression != null) {
                    String ColumnExpressionAsString = columnExpression.elementAt(0).toString();
                    if (ColumnExpressionAsString.indexOf("*") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('*', '%');
                    }
                    if (ColumnExpressionAsString.indexOf("_") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('_', '?');
                    }
                    newColumnExpression.add(ColumnExpressionAsString);
                    whereColumn.setColumnExpression(newColumnExpression);
                }
            } else if (this.operator.equalsIgnoreCase("IN") | this.operator.equalsIgnoreCase("NOT IN") && wi.getRightWhereExp() != null) {
                WhereColumn wc = wi.getRightWhereExp();
                Vector<String> v_nsce = new Vector<String>();
                Vector v_sce = wc.getColumnExpression();
                if (v_sce != null && v_sce.size() > 0 && !(v_sce.elementAt(0) instanceof String)) {
                    v_nsce.addElement("(");
                    for (int i = 0; i < v_sce.size(); ++i) {
                        v_nsce.addElement((String)v_sce.elementAt(i));
                    }
                    v_nsce.addElement(")");
                    wc.setColumnExpression(v_nsce);
                }
                wi.setOperator(this.operator);
            } else {
                wi.setOperator(this.operator);
            }
        }
        if (this.operator2 != null) {
            wi.setOperator2(this.operator2);
        }
        if (this.operator3 != null) {
            wi.setOperator3(this.operator3);
        }
        if (this.LeftJoin != null) {
            wi.setLeftJoin(null);
        }
        if (this.RightJoin != null) {
            wi.setRightJoin(null);
        }
        return wi;
    }

    public WhereItem toTeradataSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (this.movedToFromClause) {
            return null;
        }
        WhereItem wi = new WhereItem();
        if (this.rownumClause != null && !this.is_Case_Expression) {
            to_sqs.setRownumClause(this.rownumClause);
            return null;
        }
        wi.setRownumClause(this.rownumClause);
        wi.setOpenBrace(this.openBraces);
        wi.setCloseBrace(this.closeBraces);
        if (this.beginOperator != null) {
            wi.setBeginOperator(this.beginOperator);
        }
        if (this.operator1 != null) {
            wi.setOperator1(this.operator1);
        }
        if (this.leftWhereExp != null) {
            wi.setLeftWhereExp(this.leftWhereExp.toTeradataSelect(to_sqs, from_sqs));
        }
        if (this.rightWhereExp != null) {
            WhereColumn rwe = this.rightWhereExp;
            rwe = rwe.toTeradataSelect(to_sqs, from_sqs);
            wi.setRightWhereExp(rwe);
        }
        if (this.rightWhereSubQuery != null) {
            SelectQueryStatement subQuery = this.rightWhereSubQuery.toTeradataSelect();
            if (subQuery.getWithStatement() != null) {
                SelectQueryStatement.getListOfWithStatements().add(subQuery.getWithStatement());
                SelectQueryStatement tempSubQuery = subQuery.getWithStatement().getWithSQS();
                subQuery.getWithStatement().setWithSQS(null);
                subQuery = tempSubQuery;
            }
            wi.setRightWhereSubQuery(subQuery);
            if (this.rightWhereSubQueryExp != null) {
                wi.setRightWhereSubQueryExp(this.rightWhereSubQueryExp.toTeradataSelect(to_sqs, from_sqs));
            }
        }
        if (this.operator != null) {
            WhereColumn wc;
            if (this.operator.equalsIgnoreCase("^=") || this.operator.equalsIgnoreCase("!=")) {
                wi.setOperator("<>");
            } else if (this.operator.equalsIgnoreCase("!>")) {
                wi.setOperator("<=");
            } else if (this.operator.equalsIgnoreCase("!<")) {
                wi.setOperator(">=");
            } else if (this.operator.equalsIgnoreCase("~") | this.operator.equalsIgnoreCase("~*")) {
                wi.setOperator("LIKE");
                if (wi.getRightWhereSubQuery() != null) {
                    throw new ConvertException("Conversion failure.. Subquery can't be converted");
                }
                wc = wi.getRightWhereExp();
                Vector v_ce = wc.getColumnExpression();
                Vector<String> v_nce = new Vector<String>();
                if (v_ce != null) {
                    if (v_ce.size() != 1) {
                        throw new ConvertException("Conversion failure.. Expressions can't be converted");
                    }
                    String s_ce = v_ce.elementAt(0).toString();
                    if (s_ce.charAt(0) == '\'') {
                        s_ce = s_ce.replace('\'', ' ').trim();
                        s_ce = "'%" + s_ce + "%'";
                    } else if (s_ce.charAt(0) == '\"') {
                        s_ce = s_ce.replace('\"', ' ').trim();
                        s_ce = "\"%" + s_ce + "%\"";
                    } else {
                        s_ce = "'%" + s_ce + "%'";
                    }
                    v_nce.addElement(s_ce);
                    wc.setColumnExpression(v_nce);
                }
                wi.setRightWhereExp(wc);
            } else if (this.operator.equalsIgnoreCase("MATCHES") || this.operator.equalsIgnoreCase("NOT MATCHES")) {
                if (this.operator.equalsIgnoreCase("MATCHES")) {
                    wi.setOperator("LIKE");
                } else {
                    wi.setOperator("NOT LIKE");
                }
                WhereColumn whereColumn = wi.getRightWhereExp();
                Vector columnExpression = whereColumn.getColumnExpression();
                Vector<String> newColumnExpression = new Vector<String>();
                if (columnExpression != null) {
                    String ColumnExpressionAsString = columnExpression.elementAt(0).toString();
                    if (ColumnExpressionAsString.indexOf("*") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('*', '%');
                    }
                    if (ColumnExpressionAsString.indexOf("_") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('_', '?');
                    }
                    newColumnExpression.add(ColumnExpressionAsString);
                    whereColumn.setColumnExpression(newColumnExpression);
                }
            } else if (this.operator.equalsIgnoreCase("IN") | this.operator.equalsIgnoreCase("NOT IN") && wi.getRightWhereExp() != null) {
                wc = wi.getRightWhereExp();
                Vector<String> v_nsce = new Vector<String>();
                Vector v_sce = wc.getColumnExpression();
                if (v_sce != null && v_sce.size() > 0 && !(v_sce.elementAt(0) instanceof String)) {
                    v_nsce.addElement("(");
                    for (int i = 0; i < v_sce.size(); ++i) {
                        v_nsce.addElement((String)v_sce.elementAt(i));
                    }
                    v_nsce.addElement(")");
                    wc.setColumnExpression(v_nsce);
                }
                Vector<Object> newInItems = new Vector<Object>();
                WhereExpression orWhereExp = new WhereExpression();
                Vector<WhereItem> orWhereItems = new Vector<WhereItem>();
                v_sce = wc.getColumnExpression();
                Vector<String> orWhereOperators = new Vector<String>();
                Vector nonWhereColumnExpr = new Vector();
                for (int k = 0; k < v_sce.size(); ++k) {
                    Object obj = v_sce.get(k);
                    if (obj instanceof WhereColumn) {
                        WhereColumn inWhereCol = (WhereColumn)obj;
                        if (inWhereCol.getColumnExpression().get(0) instanceof String) {
                            newInItems.add(inWhereCol);
                            newInItems.add(",");
                            continue;
                        }
                        WhereItem inWhereItem = new WhereItem();
                        inWhereItem.setLeftWhereExp(wi.getLeftWhereExp());
                        inWhereItem.setRightWhereExp(inWhereCol);
                        if (this.operator.equalsIgnoreCase("IN")) {
                            inWhereItem.setOperator("=");
                        } else {
                            inWhereItem.setOperator("!=");
                        }
                        orWhereItems.add(inWhereItem);
                        orWhereOperators.add("OR");
                        continue;
                    }
                    if (obj instanceof String) continue;
                    if (obj != null && obj.toString().startsWith("/*") && obj.toString().endsWith("*/")) {
                        nonWhereColumnExpr.add(obj);
                        continue;
                    }
                    nonWhereColumnExpr.add("/*" + obj + "*/");
                }
                if (newInItems.size() > 0) {
                    WhereItem newInWhereItem = new WhereItem();
                    newInWhereItem.setLeftWhereExp(wi.getLeftWhereExp());
                    WhereColumn newInWhereRightColumn = new WhereColumn();
                    Vector<String> newInWhereRightColumnExpr = new Vector<String>();
                    newInWhereRightColumnExpr.add("(");
                    newInWhereRightColumnExpr.addAll(newInItems.subList(0, newInItems.size() - 1));
                    newInWhereRightColumnExpr.add(")");
                    newInWhereRightColumn.setColumnExpression(newInWhereRightColumnExpr);
                    newInWhereItem.setRightWhereExp(newInWhereRightColumn);
                    newInWhereItem.setOperator(this.operator);
                    orWhereItems.add(newInWhereItem);
                    orWhereOperators.add("OR");
                }
                if (orWhereItems.size() > 0) {
                    orWhereExp.setWhereItem(orWhereItems);
                    if (orWhereOperators.size() > 0) {
                        orWhereExp.setOperator(new Vector(orWhereOperators.subList(0, orWhereOperators.size() - 1)));
                    }
                    WhereColumn newInLeftCol = new WhereColumn();
                    Vector<WhereExpression> newInLeftColExp = new Vector<WhereExpression>();
                    newInLeftColExp.add(orWhereExp);
                    newInLeftColExp.addAll(nonWhereColumnExpr);
                    newInLeftCol.setColumnExpression(newInLeftColExp);
                    if (orWhereItems.size() > 1) {
                        newInLeftCol.setOpenBrace("(");
                        newInLeftCol.setCloseBrace(")");
                    }
                    wi.setLeftWhereExp(newInLeftCol);
                    wi.setRightWhereExp(null);
                    wi.setOperator(null);
                } else {
                    wi.setOperator(this.operator);
                }
            } else {
                wi.setOperator(this.operator);
            }
        }
        if (this.operator2 != null) {
            wi.setOperator2(this.operator2);
        }
        if (this.operator3 != null) {
            wi.setOperator3(this.operator3);
        }
        if (this.LeftJoin != null) {
            wi.setLeftJoin(null);
        }
        if (this.RightJoin != null) {
            wi.setRightJoin(null);
        }
        return wi;
    }

    public WhereItem toPostgreSQLSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (this.movedToFromClause) {
            return null;
        }
        if (this.rownumClause != null) {
            return null;
        }
        WhereItem wi = new WhereItem();
        wi.setOpenBrace(this.openBraces);
        wi.setCloseBrace(this.closeBraces);
        if (this.beginOperator != null) {
            wi.setBeginOperator(this.beginOperator);
        }
        if (this.operator1 != null) {
            wi.setOperator1(this.operator1);
        }
        if (this.leftWhereExp != null) {
            wi.setLeftWhereExp(this.leftWhereExp.toPostgreSQLSelect(to_sqs, from_sqs));
        }
        if (this.rightWhereExp != null) {
            wi.setRightWhereExp(this.rightWhereExp.toPostgreSQLSelect(to_sqs, from_sqs));
        }
        if (this.rightWhereSubQuery != null) {
            wi.setRightWhereSubQuery(this.rightWhereSubQuery.toPostgreSQLSelect());
            if (this.rightWhereSubQueryExp != null) {
                wi.setRightWhereSubQueryExp(this.rightWhereSubQueryExp.toPostgreSQLSelect(to_sqs, from_sqs));
            }
        }
        if (this.operator != null) {
            if (this.operator.equalsIgnoreCase("^=")) {
                wi.setOperator("<>");
            } else if (this.operator.equalsIgnoreCase("!>")) {
                wi.setOperator("<=");
            } else if (this.operator.equalsIgnoreCase("!<")) {
                wi.setOperator(">=");
            } else if (this.operator.equalsIgnoreCase("MATCHES") || this.operator.equalsIgnoreCase("NOT MATCHES")) {
                if (this.operator.equalsIgnoreCase("MATCHES")) {
                    wi.setOperator("LIKE");
                } else {
                    wi.setOperator("NOT LIKE");
                }
                WhereColumn whereColumn = wi.getRightWhereExp();
                Vector columnExpression = whereColumn.getColumnExpression();
                Vector<String> newColumnExpression = new Vector<String>();
                if (columnExpression != null) {
                    String ColumnExpressionAsString = columnExpression.elementAt(0).toString();
                    if (ColumnExpressionAsString.indexOf("*") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('*', '%');
                    }
                    if (ColumnExpressionAsString.indexOf("_") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('_', '?');
                    }
                    newColumnExpression.add(ColumnExpressionAsString);
                    whereColumn.setColumnExpression(newColumnExpression);
                }
            } else if (this.operator.equalsIgnoreCase("IN") | this.operator.equalsIgnoreCase("NOT IN") && wi.getRightWhereExp() != null) {
                WhereColumn wc = wi.getRightWhereExp();
                Vector<String> v_nsce = new Vector<String>();
                Vector v_sce = wc.getColumnExpression();
                if (v_sce != null && v_sce.size() > 0 && !(v_sce.elementAt(0) instanceof String)) {
                    v_nsce.addElement("(");
                    for (int i = 0; i < v_sce.size(); ++i) {
                        v_nsce.addElement((String)v_sce.elementAt(i));
                    }
                    v_nsce.addElement(")");
                    wc.setColumnExpression(v_nsce);
                }
                wi.setOperator(this.operator);
            } else if (this.operator.trim().equalsIgnoreCase("LNNVl") && this.lnnvlWhereExp != null) {
                WhereExpression we1 = this.lnnvlWhereExp.toPostgreSQLSelect(to_sqs, from_sqs);
                this.convertLNNVLtoStatement(we1);
                wi.setCaseStatementForLNNVLFunc(this.casestmtFromLNNVLClause);
            } else if (this.operator.trim().equalsIgnoreCase("REGEXP_LIKE") && this.regExp != null) {
                wi.setOperator("REGEXP_LIKE");
                Vector<SelectColumn> newExp = new Vector<SelectColumn>();
                for (int i = 0; i < this.regExp.size(); ++i) {
                    if (this.regExp.get(i) instanceof SelectColumn) {
                        SelectColumn sc1 = (SelectColumn)this.regExp.get(i);
                        newExp.add(sc1.toPostgreSQLSelect(to_sqs, from_sqs));
                        continue;
                    }
                    newExp.add((SelectColumn)this.regExp.get(i));
                }
                wi.setRegExp(newExp);
            } else {
                wi.setOperator(this.operator);
            }
        }
        if (this.operator2 != null && wi.getRightWhereSubQuery() == null && wi.getRightWhereExp() != null) {
            WhereColumn r_wc = wi.getRightWhereExp();
            WhereColumn l_wc = wi.getLeftWhereExp();
            if (r_wc.getColumnExpression() != null && r_wc.getColumnExpression().size() != 1) {
                String s_ce;
                int i;
                Vector v_nlsce = new Vector();
                Vector v_nrsce = new Vector();
                Vector v_lsce = l_wc.getColumnExpression();
                Vector v_rsce = r_wc.getColumnExpression();
                Vector v_removedcomma_right_column_exp = new Vector();
                Vector v_removedcomma_left_column_exp = new Vector();
                for (i = 0; i < v_lsce.size(); ++i) {
                    if (v_lsce.elementAt(i) instanceof String) {
                        s_ce = (String)v_lsce.elementAt(i);
                        if (s_ce.equalsIgnoreCase(",") || s_ce.equalsIgnoreCase("(") || s_ce.equalsIgnoreCase(")")) continue;
                        v_removedcomma_left_column_exp.addElement(v_lsce.elementAt(i));
                        continue;
                    }
                    v_removedcomma_left_column_exp.addElement(v_lsce.elementAt(i));
                }
                for (i = 0; i < v_rsce.size(); ++i) {
                    if (v_rsce.elementAt(i) instanceof String) {
                        s_ce = (String)v_rsce.elementAt(i);
                        if (s_ce.equalsIgnoreCase(",") || s_ce.equalsIgnoreCase("(") || s_ce.equalsIgnoreCase(")")) continue;
                        v_removedcomma_right_column_exp.addElement(v_rsce.elementAt(i));
                        continue;
                    }
                    v_removedcomma_right_column_exp.addElement(v_rsce.elementAt(i));
                }
                v_nlsce.addElement(v_removedcomma_left_column_exp.elementAt(0));
                v_nrsce.addElement(v_removedcomma_right_column_exp.elementAt(0));
                l_wc.setColumnExpression(v_nlsce);
                r_wc.setColumnExpression(v_nrsce);
                for (i = 1; i < v_removedcomma_right_column_exp.size(); ++i) {
                    WhereItem n_wi = new WhereItem();
                    WhereColumn l_nwc = new WhereColumn();
                    WhereColumn r_nwc = new WhereColumn();
                    Vector v_lnsc = new Vector();
                    Vector v_rnsc = new Vector();
                    v_lnsc.addElement(v_removedcomma_left_column_exp.elementAt(0));
                    v_rnsc.addElement(v_removedcomma_right_column_exp.elementAt(i));
                    l_nwc.setColumnExpression(v_lnsc);
                    r_nwc.setColumnExpression(v_rnsc);
                    n_wi.setLeftWhereExp(l_nwc);
                    n_wi.setRightWhereExp(r_nwc);
                    n_wi.setOperator(this.operator);
                    if (i == v_lsce.size() - 1) {
                        from_sqs.getWhereExpression().addWhereItem(n_wi);
                        continue;
                    }
                    if (this.operator2.equalsIgnoreCase("ALL")) {
                        from_sqs.getWhereExpression().addOperator("AND");
                    } else {
                        from_sqs.getWhereExpression().addOperator("OR");
                    }
                    from_sqs.getWhereExpression().addWhereItem(n_wi);
                }
            }
        }
        if (wi.getRightWhereSubQuery() != null && this.operator2 != null) {
            wi.setOperator2(this.operator2);
        }
        if (this.operator3 != null) {
            wi.setOperator3(this.operator3);
        }
        if (this.LeftJoin != null) {
            wi.setLeftJoin(null);
        }
        if (this.RightJoin != null) {
            wi.setRightJoin(null);
        }
        return wi;
    }

    public WhereItem toMSSQLServerSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereColumn l_wc;
        WhereColumn r_wc;
        Vector rightColumnExpression;
        if (this.movedToFromClause) {
            return null;
        }
        if (this.rownumClause != null) {
            return null;
        }
        boolean noChangeRequired = false;
        WhereItem wi = new WhereItem();
        wi.setOpenBrace(this.openBraces);
        wi.setCloseBrace(this.closeBraces);
        if (this.beginOperator != null) {
            wi.setBeginOperator(this.beginOperator);
        }
        if (this.operator1 != null) {
            wi.setOperator1(this.operator1);
        }
        if (this.leftWhereExp != null) {
            wi.setLeftWhereExp(this.leftWhereExp.toMSSQLServerSelect(to_sqs, from_sqs));
            Vector leftColumnExpression = this.leftWhereExp.getColumnExpression();
            if (leftColumnExpression != null && this.containsColumnVariable(leftColumnExpression, false)) {
                noChangeRequired = true;
            }
        }
        if (this.rightWhereExp != null && !this.isContainsFunction) {
            wi.setRightWhereExp(this.rightWhereExp.toMSSQLServerSelect(to_sqs, from_sqs));
            rightColumnExpression = this.rightWhereExp.getColumnExpression();
            if (rightColumnExpression != null && this.containsColumnVariable(rightColumnExpression, false)) {
                noChangeRequired = true;
            }
        }
        if (!SwisSQLAPI.MSSQLSERVER_THETA) {
            if (this.LeftJoin != null) {
                wi.setLeftJoin(null);
            }
            if (this.RightJoin != null) {
                wi.setLeftJoin(null);
            }
        } else if (!noChangeRequired) {
            if (this.LeftJoin != null) {
                if (this.LeftJoin.equalsIgnoreCase("+")) {
                    wi.setLeftJoin("*");
                } else {
                    wi.setLeftJoin(this.LeftJoin);
                }
            }
            if (this.RightJoin != null) {
                if (this.RightJoin.equalsIgnoreCase("+")) {
                    wi.setRightJoin("*");
                } else {
                    wi.setRightJoin(this.RightJoin);
                }
            }
        }
        if (this.rightWhereSubQuery != null) {
            wi.setRightWhereSubQuery(this.rightWhereSubQuery.toMSSQLServerSelect());
            if (this.rightWhereSubQueryExp != null) {
                wi.setRightWhereSubQueryExp(this.rightWhereSubQueryExp.toMSSQLServerSelect(to_sqs, from_sqs));
            }
        }
        if (this.operator != null && !this.isContainsFunction) {
            if (this.operator.equalsIgnoreCase("^=")) {
                wi.setOperator("<>");
            } else if (this.operator.equalsIgnoreCase("~") | this.operator.equalsIgnoreCase("~*")) {
                wi.setOperator("LIKE");
                if (wi.getRightWhereSubQuery() != null) {
                    throw new ConvertException("Conversion failure.. Subquery can't be converted");
                }
                WhereColumn wc = wi.getRightWhereExp();
                Vector v_ce = wc.getColumnExpression();
                Vector<String> v_nce = new Vector<String>();
                if (v_ce != null) {
                    if (v_ce.size() != 1) {
                        throw new ConvertException("Conversion failure.. Expressions can't be converted");
                    }
                    String s_ce = v_ce.elementAt(0).toString();
                    if (s_ce.charAt(0) == '\'') {
                        s_ce = s_ce.replace('\'', ' ').trim();
                        s_ce = "'%" + s_ce + "%'";
                    } else if (s_ce.charAt(0) == '\"') {
                        s_ce = s_ce.replace('\"', ' ').trim();
                        s_ce = "\"%" + s_ce + "%\"";
                    } else {
                        s_ce = "'%" + s_ce + "%'";
                    }
                    v_nce.addElement(s_ce);
                    wc.setColumnExpression(v_nce);
                }
                wi.setRightWhereExp(wc);
            } else if (this.operator.equalsIgnoreCase("MATCHES") || this.operator.equalsIgnoreCase("NOT MATCHES")) {
                if (this.operator.equalsIgnoreCase("MATCHES")) {
                    wi.setOperator("LIKE");
                } else {
                    wi.setOperator("NOT LIKE");
                }
                WhereColumn whereColumn = wi.getRightWhereExp();
                Vector columnExpression = whereColumn.getColumnExpression();
                Vector<String> newColumnExpression = new Vector<String>();
                if (columnExpression != null) {
                    String ColumnExpressionAsString = columnExpression.elementAt(0).toString();
                    if (ColumnExpressionAsString.indexOf("*") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('*', '%');
                    }
                    if (ColumnExpressionAsString.indexOf("_") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('_', '?');
                    }
                    newColumnExpression.add(ColumnExpressionAsString);
                    whereColumn.setColumnExpression(newColumnExpression);
                }
            } else if ((this.operator.equalsIgnoreCase("BETWEEN") || this.operator.equalsIgnoreCase("NOT BETWEEN")) && wi.getRightWhereExp() != null) {
                WhereColumn rightSideColumn = wi.getRightWhereExp();
                Vector rightExpr = rightSideColumn.getColumnExpression();
                if (rightExpr != null) {
                    Vector<String> newRightExpr = new Vector<String>();
                    for (int i = 0; i < rightExpr.size(); ++i) {
                        if (rightExpr.get(i) instanceof String) {
                            String rightString = (String)rightExpr.get(i);
                            if (rightString.equalsIgnoreCase("(") || rightString.equalsIgnoreCase(")")) continue;
                            newRightExpr.add(rightString);
                            continue;
                        }
                        newRightExpr.add((String)rightExpr.get(i));
                    }
                    rightSideColumn.setColumnExpression(newRightExpr);
                }
                wi.setOperator(this.operator);
            } else if (this.operator.equalsIgnoreCase("IN") | this.operator.equalsIgnoreCase("NOT IN") && wi.getRightWhereExp() != null && wi.getRightWhereSubQuery() == null) {
                r_wc = wi.getRightWhereExp();
                l_wc = wi.getLeftWhereExp();
                WhereColumn wc = wi.getRightWhereExp();
                Vector<String> v_nsce = new Vector<String>();
                Vector v_sce = wc.getColumnExpression();
                if (v_sce != null && v_sce.size() > 0 && !(v_sce.elementAt(0) instanceof String)) {
                    v_nsce.addElement("(");
                    for (int i = 0; i < v_sce.size(); ++i) {
                        v_nsce.addElement((String)v_sce.elementAt(i));
                    }
                    v_nsce.addElement(")");
                    wc.setColumnExpression(v_nsce);
                }
                wi.setOperator(this.operator);
            } else if ((this.operator.equalsIgnoreCase("IN") || this.operator.equalsIgnoreCase("NOT IN")) && wi.getRightWhereSubQuery() != null) {
                String f_tablename = null;
                if (from_sqs != null) {
                    FromTable ft = null;
                    if (from_sqs.getFromClause() != null && from_sqs.getFromClause().getFromItemList().elementAt(0) instanceof FromTable) {
                        ft = (FromTable)from_sqs.getFromClause().getFromItemList().elementAt(0);
                        if (ft.getAliasName() != null) {
                            f_tablename = ft.getAliasName();
                        } else if (ft.getTableName() instanceof String) {
                            f_tablename = ft.getTableName().toString();
                            int pos = f_tablename.indexOf(".");
                            if (pos == -1) {
                                pos = f_tablename.indexOf("..");
                            }
                            f_tablename = f_tablename.substring(pos + 1);
                        } else {
                            f_tablename = ft.getTableName().toString();
                        }
                    }
                }
                if ((l_wc = wi.getLeftWhereExp()).getColumnExpression() != null && l_wc.getColumnExpression().size() != 1 && l_wc.getColumnExpression().contains(",")) {
                    Vector v_removedcomma_left_column_exp = new Vector();
                    this.removeCommaBracesFromExpressionList(l_wc, v_removedcomma_left_column_exp, f_tablename);
                    wi.setLeftWhereExp(null);
                    if (this.operator.equalsIgnoreCase("IN")) {
                        wi.setOperator("EXISTS");
                    } else if (this.operator.equalsIgnoreCase("NOT IN")) {
                        wi.setOperator("NOT EXISTS");
                    }
                    SelectQueryStatement sqs = wi.getRightWhereSubQuery();
                    String f_tablename_1 = null;
                    FromTable ft_1 = (FromTable)sqs.getFromClause().getFromItemList().elementAt(0);
                    if (ft_1.getAliasName() == null) {
                        // empty if block
                    }
                    f_tablename_1 = ft_1.getAliasName() != null ? ft_1.getAliasName() : ft_1.getTableName().toString();
                    Vector v_sitl = sqs.getSelectStatement().getSelectItemList();
                    for (int i = 0; i < v_sitl.size(); ++i) {
                        WhereItem wi_1 = new WhereItem();
                        WhereColumn l_wc_1 = new WhereColumn();
                        WhereColumn r_wc_1 = new WhereColumn();
                        Vector<String> v_lce = new Vector<String>();
                        Vector v_rce = new Vector();
                        SelectColumn sc = (SelectColumn)v_sitl.elementAt(i);
                        Vector v_ce = sc.getColumnExpression();
                        String where_column_name = null;
                        if (v_ce.elementAt(0) instanceof String) {
                            where_column_name = (String)v_ce.elementAt(0);
                        } else if (v_ce.elementAt(0) instanceof TableColumn) {
                            TableColumn tc = (TableColumn)v_ce.elementAt(0);
                            if (tc.getTableName() == null) {
                                tc.setTableName(f_tablename_1);
                            }
                            where_column_name = tc.toString();
                        } else if (v_ce.elementAt(0) instanceof SelectColumn) {
                            SelectColumn selectColumnInsideSelectColumn = (SelectColumn)v_ce.elementAt(0);
                            Vector newColumnExp = selectColumnInsideSelectColumn.getColumnExpression();
                            if (newColumnExp.elementAt(0) instanceof String) {
                                where_column_name = (String)newColumnExp.elementAt(0);
                            } else if (newColumnExp.elementAt(0) instanceof TableColumn) {
                                TableColumn tableColumn = (TableColumn)newColumnExp.elementAt(0);
                                if (tableColumn.getTableName() == null) {
                                    tableColumn.setTableName(f_tablename_1);
                                }
                                where_column_name = tableColumn.toString();
                            }
                        }
                        v_lce.addElement(where_column_name);
                        l_wc_1.setColumnExpression(v_lce);
                        v_rce.addElement(v_removedcomma_left_column_exp.elementAt(i));
                        r_wc_1.setColumnExpression(v_rce);
                        wi_1.setOperator("=");
                        wi_1.setLeftWhereExp(l_wc_1);
                        wi_1.setRightWhereExp(r_wc_1);
                        if (sqs.getWhereExpression() != null && !sqs.getWhereExpression().toString().equalsIgnoreCase("")) {
                            sqs.getWhereExpression().addWhereItem(wi_1);
                            sqs.getWhereExpression().addOperator("AND");
                            continue;
                        }
                        WhereExpression we = new WhereExpression();
                        we.addWhereItem(wi_1);
                        sqs.setWhereExpression(we);
                    }
                    wi.setRightWhereSubQuery(sqs);
                } else {
                    wi.setOperator(this.operator);
                }
            } else if (this.getOperator().trim().equals("=") || this.getOperator().trim().equals("!=") || this.getOperator().trim().equals("<>")) {
                rightColumnExpression = this.rightWhereExp.getColumnExpression();
                if (rightColumnExpression != null && rightColumnExpression.size() == 1) {
                    Object obj = rightColumnExpression.get(0);
                    if (obj instanceof String && obj.toString().trim().equalsIgnoreCase("null")) {
                        String op = this.getOperator();
                        if (op != null && op.equals("=")) {
                            op = " IS ";
                        }
                        if (op != null && (op.equals("!=") || op.equals("<>"))) {
                            op = " IS NOT ";
                        }
                        wi.setOperator(op);
                    } else {
                        wi.setOperator(this.operator);
                    }
                } else {
                    wi.setOperator(this.operator);
                }
            } else {
                wi.setOperator(this.operator);
            }
        }
        if (this.operator2 != null && wi.getRightWhereSubQuery() == null && wi.getRightWhereExp() != null) {
            r_wc = wi.getRightWhereExp();
            l_wc = wi.getLeftWhereExp();
            if (r_wc.getColumnExpression() != null && r_wc.getColumnExpression().size() != 1) {
                String s_ce;
                int i;
                Vector v_nlsce = new Vector();
                Vector v_nrsce = new Vector();
                Vector v_lsce = l_wc.getColumnExpression();
                Vector v_rsce = r_wc.getColumnExpression();
                Vector v_removedcomma_right_column_exp = new Vector();
                Vector v_removedcomma_left_column_exp = new Vector();
                for (i = 0; i < v_lsce.size(); ++i) {
                    if (v_lsce.elementAt(i) instanceof String) {
                        s_ce = (String)v_lsce.elementAt(i);
                        if (s_ce.equalsIgnoreCase(",") || s_ce.equalsIgnoreCase("(") || s_ce.equalsIgnoreCase(")")) continue;
                        v_removedcomma_left_column_exp.addElement(v_lsce.elementAt(i));
                        continue;
                    }
                    v_removedcomma_left_column_exp.addElement(v_lsce.elementAt(i));
                }
                for (i = 0; i < v_rsce.size(); ++i) {
                    if (v_rsce.elementAt(i) instanceof String) {
                        s_ce = (String)v_rsce.elementAt(i);
                        if (s_ce.equalsIgnoreCase(",") || s_ce.equalsIgnoreCase("(") || s_ce.equalsIgnoreCase(")")) continue;
                        v_removedcomma_right_column_exp.addElement(v_rsce.elementAt(i));
                        continue;
                    }
                    v_removedcomma_right_column_exp.addElement(v_rsce.elementAt(i));
                }
                v_nlsce.addElement(v_removedcomma_left_column_exp.elementAt(0));
                v_nrsce.addElement(v_removedcomma_right_column_exp.elementAt(0));
                l_wc.setColumnExpression(v_nlsce);
                r_wc.setColumnExpression(v_nrsce);
                for (i = 1; i < v_removedcomma_right_column_exp.size(); ++i) {
                    WhereItem n_wi = new WhereItem();
                    WhereColumn l_nwc = new WhereColumn();
                    WhereColumn r_nwc = new WhereColumn();
                    Vector v_lnsc = new Vector();
                    Vector v_rnsc = new Vector();
                    v_lnsc.addElement(v_removedcomma_left_column_exp.elementAt(0));
                    v_rnsc.addElement(v_removedcomma_right_column_exp.elementAt(i));
                    l_nwc.setColumnExpression(v_lnsc);
                    r_nwc.setColumnExpression(v_rnsc);
                    n_wi.setLeftWhereExp(l_nwc);
                    n_wi.setRightWhereExp(r_nwc);
                    n_wi.setOperator(this.operator);
                    if (i == v_lsce.size() - 1) {
                        from_sqs.getWhereExpression().addWhereItem(n_wi);
                        continue;
                    }
                    if (this.operator2.equalsIgnoreCase("ALL")) {
                        from_sqs.getWhereExpression().addOperator("AND");
                    } else {
                        from_sqs.getWhereExpression().addOperator("OR");
                    }
                    from_sqs.getWhereExpression().addWhereItem(n_wi);
                }
            }
        }
        if (wi.getRightWhereSubQuery() != null && this.operator2 != null) {
            wi.setOperator2(this.operator2);
        }
        if (this.operator3 != null) {
            wi.setOperator3(this.operator3);
        }
        if (this.isContainsFunction && (this.getOperator().trim().equals("=") || this.getOperator().trim().equals("<"))) {
            wi.setOperator1("NOT");
        }
        return wi;
    }

    public WhereItem toSybaseSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        WhereColumn l_wc;
        WhereColumn r_wc;
        Vector colExp;
        if (this.movedToFromClause) {
            return null;
        }
        if (this.rownumClause != null) {
            return null;
        }
        boolean noChangeRequired = false;
        WhereItem wi = new WhereItem();
        wi.setOpenBrace(this.openBraces);
        wi.setCloseBrace(this.closeBraces);
        if (this.beginOperator != null) {
            wi.setBeginOperator(this.beginOperator);
        }
        if (this.operator1 != null) {
            wi.setOperator1(this.operator1);
        }
        if (this.leftWhereExp != null) {
            this.leftWhereExp.setObjectContext(this.context);
            colExp = this.leftWhereExp.getColumnExpression();
            if (colExp != null) {
                for (int i = 0; i < colExp.size(); ++i) {
                    if (colExp.elementAt(i) instanceof TableColumn) {
                        ((TableColumn)colExp.elementAt(i)).setObjectContext(this.context);
                        continue;
                    }
                    if (colExp.elementAt(i) instanceof SelectColumn) {
                        ((SelectColumn)colExp.elementAt(i)).setObjectContext(this.context);
                        continue;
                    }
                    if (!(colExp.elementAt(i) instanceof FunctionCalls)) continue;
                    ((FunctionCalls)colExp.elementAt(i)).setObjectContext(this.context);
                }
            }
            wi.setObjectContext(this.context);
            wi.setLeftWhereExp(this.leftWhereExp.toSybaseSelect(to_sqs, from_sqs));
            Vector leftColumnExpression = this.leftWhereExp.getColumnExpression();
            if (leftColumnExpression != null && this.containsColumnVariable(leftColumnExpression, false)) {
                noChangeRequired = true;
            }
        }
        if (this.rightWhereExp != null) {
            this.rightWhereExp.setObjectContext(this.context);
            wi.setObjectContext(this.context);
            colExp = this.rightWhereExp.getColumnExpression();
            if (colExp != null) {
                for (int i = 0; i < colExp.size(); ++i) {
                    if (colExp.elementAt(i) instanceof TableColumn) {
                        ((TableColumn)colExp.elementAt(i)).setObjectContext(this.context);
                        continue;
                    }
                    if (colExp.elementAt(i) instanceof SelectColumn) {
                        ((SelectColumn)colExp.elementAt(i)).setObjectContext(this.context);
                        continue;
                    }
                    if (!(colExp.elementAt(i) instanceof FunctionCalls)) continue;
                    ((FunctionCalls)colExp.elementAt(i)).setObjectContext(this.context);
                }
            }
            wi.setRightWhereExp(this.rightWhereExp.toSybaseSelect(to_sqs, from_sqs));
            Vector rightColumnExpression = this.rightWhereExp.getColumnExpression();
            boolean countVarOrConst = false;
            if (rightColumnExpression != null && this.containsColumnVariable(rightColumnExpression, false)) {
                noChangeRequired = true;
            }
        }
        if (!SwisSQLAPI.MSSQLSERVER_THETA) {
            if (this.LeftJoin != null) {
                wi.setLeftJoin(null);
            }
            if (this.RightJoin != null) {
                wi.setLeftJoin(null);
            }
        } else if (!noChangeRequired) {
            if (this.LeftJoin != null) {
                if (this.LeftJoin.equalsIgnoreCase("+")) {
                    wi.setLeftJoin("*");
                } else {
                    wi.setLeftJoin(this.LeftJoin);
                }
            }
            if (this.RightJoin != null) {
                if (this.RightJoin.equalsIgnoreCase("+")) {
                    wi.setRightJoin("*");
                } else {
                    wi.setRightJoin(this.RightJoin);
                }
            }
        }
        if (this.rightWhereSubQuery != null) {
            this.rightWhereSubQuery.setObjectContext(this.context);
            wi.setRightWhereSubQuery(this.rightWhereSubQuery.toSybaseSelect());
            if (this.rightWhereSubQueryExp != null) {
                wi.setRightWhereSubQueryExp(this.rightWhereSubQueryExp.toSybaseSelect(to_sqs, from_sqs));
            }
        }
        if (this.operator != null) {
            if (this.operator.equalsIgnoreCase("^=")) {
                wi.setOperator("<>");
            } else if (this.operator.equalsIgnoreCase("~") | this.operator.equalsIgnoreCase("~*")) {
                wi.setOperator("LIKE");
                if (wi.getRightWhereSubQuery() != null) {
                    throw new ConvertException("Conversion failure.. Subquery can't be converted");
                }
                WhereColumn wc = wi.getRightWhereExp();
                Vector v_ce = wc.getColumnExpression();
                Vector<String> v_nce = new Vector<String>();
                if (v_ce != null) {
                    if (v_ce.size() != 1) {
                        throw new ConvertException("Conversion failure.. Expressions can't be converted");
                    }
                    String s_ce = v_ce.elementAt(0).toString();
                    if (s_ce.charAt(0) == '\'') {
                        s_ce = s_ce.replace('\'', ' ').trim();
                        s_ce = "'%" + s_ce + "%'";
                    } else if (s_ce.charAt(0) == '\"') {
                        s_ce = s_ce.replace('\"', ' ').trim();
                        s_ce = "\"%" + s_ce + "%\"";
                    } else {
                        s_ce = "'%" + s_ce + "%'";
                    }
                    v_nce.addElement(s_ce);
                    wc.setColumnExpression(v_nce);
                }
                wi.setRightWhereExp(wc);
            } else if ((this.operator.equalsIgnoreCase("BETWEEN") || this.operator.equalsIgnoreCase("NOT BETWEEN")) && wi.getRightWhereExp() != null) {
                WhereColumn rightSideColumn = wi.getRightWhereExp();
                Vector rightExpr = rightSideColumn.getColumnExpression();
                if (rightExpr != null) {
                    Vector<String> newRightExpr = new Vector<String>();
                    for (int i = 0; i < rightExpr.size(); ++i) {
                        if (rightExpr.get(i) instanceof String) {
                            String rightString = (String)rightExpr.get(i);
                            if (rightString.equalsIgnoreCase("(") || rightString.equalsIgnoreCase(")")) continue;
                            newRightExpr.add(rightString);
                            continue;
                        }
                        newRightExpr.add((String)rightExpr.get(i));
                    }
                    rightSideColumn.setColumnExpression(newRightExpr);
                }
                wi.setOperator(this.operator);
            } else if (this.operator.equalsIgnoreCase("MATCHES") || this.operator.equalsIgnoreCase("NOT MATCHES")) {
                if (this.operator.equalsIgnoreCase("MATCHES")) {
                    wi.setOperator("LIKE");
                } else {
                    wi.setOperator("NOT LIKE");
                }
                WhereColumn whereColumn = wi.getRightWhereExp();
                Vector columnExpression = whereColumn.getColumnExpression();
                Vector<String> newColumnExpression = new Vector<String>();
                if (columnExpression != null) {
                    String ColumnExpressionAsString = columnExpression.elementAt(0).toString();
                    if (ColumnExpressionAsString.indexOf("*") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('*', '%');
                    }
                    if (ColumnExpressionAsString.indexOf("_") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('_', '?');
                    }
                    newColumnExpression.add(ColumnExpressionAsString);
                    whereColumn.setColumnExpression(newColumnExpression);
                }
            } else if (this.operator.equalsIgnoreCase("IN") | this.operator.equalsIgnoreCase("NOT IN") && wi.getRightWhereExp() != null && wi.getRightWhereSubQuery() == null) {
                r_wc = wi.getRightWhereExp();
                l_wc = wi.getLeftWhereExp();
                WhereColumn wc = wi.getRightWhereExp();
                Vector<String> v_nsce = new Vector<String>();
                Vector v_sce = wc.getColumnExpression();
                if (v_sce != null && v_sce.size() > 0 && !(v_sce.elementAt(0) instanceof String)) {
                    v_nsce.addElement("(");
                    for (int i = 0; i < v_sce.size(); ++i) {
                        v_nsce.addElement((String)v_sce.elementAt(i));
                    }
                    v_nsce.addElement(")");
                    wc.setColumnExpression(v_nsce);
                }
                wi.setOperator(this.operator);
            } else if ((this.operator.equalsIgnoreCase("IN") || this.operator.equalsIgnoreCase("NOT IN")) && wi.getRightWhereSubQuery() != null) {
                String f_tablename = null;
                if (from_sqs != null) {
                    FromTable ft = null;
                    if (from_sqs.getFromClause().getFromItemList().elementAt(0) instanceof FromTable) {
                        ft = (FromTable)from_sqs.getFromClause().getFromItemList().elementAt(0);
                        if (ft.getAliasName() != null) {
                            f_tablename = ft.getAliasName();
                        } else if (ft.getTableName() instanceof String) {
                            f_tablename = ft.getTableName().toString();
                            int pos = f_tablename.indexOf(".");
                            if (pos == -1) {
                                pos = f_tablename.indexOf("..");
                            }
                            f_tablename = f_tablename.substring(pos + 1);
                        } else {
                            f_tablename = ft.getTableName().toString();
                        }
                    }
                }
                if ((l_wc = wi.getLeftWhereExp()).getColumnExpression() != null && l_wc.getColumnExpression().size() != 1 && l_wc.getColumnExpression().contains(",")) {
                    Vector v_removedcomma_left_column_exp = new Vector();
                    this.removeCommaBracesFromExpressionList(l_wc, v_removedcomma_left_column_exp, f_tablename);
                    wi.setLeftWhereExp(null);
                    if (this.operator.equalsIgnoreCase("IN")) {
                        wi.setOperator("EXISTS");
                    } else if (this.operator.equalsIgnoreCase("NOT IN")) {
                        wi.setOperator("NOT EXISTS");
                    }
                    SelectQueryStatement sqs = wi.getRightWhereSubQuery();
                    String f_tablename_1 = null;
                    FromTable ft_1 = (FromTable)sqs.getFromClause().getFromItemList().elementAt(0);
                    if (ft_1.getAliasName() == null) {
                        // empty if block
                    }
                    f_tablename_1 = ft_1.getAliasName() != null ? ft_1.getAliasName() : ft_1.getTableName().toString();
                    Vector v_sitl = sqs.getSelectStatement().getSelectItemList();
                    for (int i = 0; i < v_sitl.size(); ++i) {
                        WhereItem wi_1 = new WhereItem();
                        wi_1.setObjectContext(this.context);
                        WhereColumn l_wc_1 = new WhereColumn();
                        WhereColumn r_wc_1 = new WhereColumn();
                        Vector<String> v_lce = new Vector<String>();
                        Vector v_rce = new Vector();
                        SelectColumn sc = (SelectColumn)v_sitl.elementAt(i);
                        Vector v_ce = sc.getColumnExpression();
                        String where_column_name = null;
                        if (v_ce.elementAt(0) instanceof String) {
                            where_column_name = (String)v_ce.elementAt(0);
                        } else if (v_ce.elementAt(0) instanceof TableColumn) {
                            TableColumn tc = (TableColumn)v_ce.elementAt(0);
                            if (tc.getTableName() == null) {
                                tc.setTableName(f_tablename_1);
                            }
                            where_column_name = tc.toString();
                        } else if (v_ce.elementAt(0) instanceof SelectColumn) {
                            SelectColumn selectColumnInsideSelectColumn = (SelectColumn)v_ce.elementAt(0);
                            Vector newColumnExp = selectColumnInsideSelectColumn.getColumnExpression();
                            if (newColumnExp.elementAt(0) instanceof String) {
                                where_column_name = (String)newColumnExp.elementAt(0);
                            } else if (newColumnExp.elementAt(0) instanceof TableColumn) {
                                TableColumn tableColumn = (TableColumn)newColumnExp.elementAt(0);
                                if (tableColumn.getTableName() == null) {
                                    tableColumn.setTableName(f_tablename_1);
                                }
                                where_column_name = tableColumn.toString();
                            }
                        }
                        v_lce.addElement(where_column_name);
                        l_wc_1.setColumnExpression(v_lce);
                        v_rce.addElement(v_removedcomma_left_column_exp.elementAt(i));
                        r_wc_1.setColumnExpression(v_rce);
                        wi_1.setOperator("=");
                        wi_1.setLeftWhereExp(l_wc_1);
                        wi_1.setRightWhereExp(r_wc_1);
                        if (sqs.getWhereExpression() != null && !sqs.getWhereExpression().toString().equalsIgnoreCase("")) {
                            sqs.getWhereExpression().addWhereItem(wi_1);
                            sqs.getWhereExpression().addOperator("AND");
                            continue;
                        }
                        WhereExpression we = new WhereExpression();
                        we.addWhereItem(wi_1);
                        sqs.setWhereExpression(we);
                    }
                    Vector<String> tempVector = new Vector<String>();
                    tempVector.add("*");
                    sqs.getSelectStatement().setSelectItemList(tempVector);
                    wi.setRightWhereSubQuery(sqs);
                } else {
                    wi.setOperator(this.operator);
                }
            } else {
                wi.setOperator(this.operator);
            }
        }
        if (this.operator2 != null && wi.getRightWhereSubQuery() == null && wi.getRightWhereExp() != null) {
            r_wc = wi.getRightWhereExp();
            l_wc = wi.getLeftWhereExp();
            if (r_wc.getColumnExpression() != null && r_wc.getColumnExpression().size() != 1) {
                String s_ce;
                int i;
                Vector v_nlsce = new Vector();
                Vector v_nrsce = new Vector();
                Vector v_lsce = l_wc.getColumnExpression();
                Vector v_rsce = r_wc.getColumnExpression();
                Vector v_removedcomma_right_column_exp = new Vector();
                Vector v_removedcomma_left_column_exp = new Vector();
                for (i = 0; i < v_lsce.size(); ++i) {
                    if (v_lsce.elementAt(i) instanceof String) {
                        s_ce = (String)v_lsce.elementAt(i);
                        if (s_ce.equalsIgnoreCase(",") || s_ce.equalsIgnoreCase("(") || s_ce.equalsIgnoreCase(")")) continue;
                        v_removedcomma_left_column_exp.addElement(v_lsce.elementAt(i));
                        continue;
                    }
                    v_removedcomma_left_column_exp.addElement(v_lsce.elementAt(i));
                }
                for (i = 0; i < v_rsce.size(); ++i) {
                    if (v_rsce.elementAt(i) instanceof String) {
                        s_ce = (String)v_rsce.elementAt(i);
                        if (s_ce.equalsIgnoreCase(",") || s_ce.equalsIgnoreCase("(") || s_ce.equalsIgnoreCase(")")) continue;
                        v_removedcomma_right_column_exp.addElement(v_rsce.elementAt(i));
                        continue;
                    }
                    v_removedcomma_right_column_exp.addElement(v_rsce.elementAt(i));
                }
                v_nlsce.addElement(v_removedcomma_left_column_exp.elementAt(0));
                v_nrsce.addElement(v_removedcomma_right_column_exp.elementAt(0));
                l_wc.setColumnExpression(v_nlsce);
                r_wc.setColumnExpression(v_nrsce);
                for (i = 1; i < v_removedcomma_right_column_exp.size(); ++i) {
                    WhereItem n_wi = new WhereItem();
                    WhereColumn l_nwc = new WhereColumn();
                    WhereColumn r_nwc = new WhereColumn();
                    Vector v_lnsc = new Vector();
                    Vector v_rnsc = new Vector();
                    v_lnsc.addElement(v_removedcomma_left_column_exp.elementAt(0));
                    v_rnsc.addElement(v_removedcomma_right_column_exp.elementAt(i));
                    l_nwc.setColumnExpression(v_lnsc);
                    r_nwc.setColumnExpression(v_rnsc);
                    n_wi.setLeftWhereExp(l_nwc);
                    n_wi.setRightWhereExp(r_nwc);
                    n_wi.setOperator(this.operator);
                    if (i == v_lsce.size() - 1) {
                        from_sqs.getWhereExpression().addWhereItem(n_wi);
                        continue;
                    }
                    if (this.operator2.equalsIgnoreCase("ALL")) {
                        from_sqs.getWhereExpression().addOperator("AND");
                    } else {
                        from_sqs.getWhereExpression().addOperator("OR");
                    }
                    from_sqs.getWhereExpression().addWhereItem(n_wi);
                }
            }
        }
        if (wi.getRightWhereSubQuery() != null && this.operator2 != null) {
            wi.setOperator2(this.operator2);
        }
        if (this.operator3 != null) {
            wi.setOperator3(this.operator3);
        }
        return wi;
    }

    public void removeCommaBracesFromExpressionList(WhereColumn wc, Vector v_nce, String table_name) {
        Vector v_ce = wc.getColumnExpression();
        if (v_ce != null) {
            for (int i = 0; i < v_ce.size(); ++i) {
                if (v_ce.elementAt(i) instanceof String) {
                    String s_ce = (String)v_ce.elementAt(i);
                    if (s_ce.equalsIgnoreCase(",") || s_ce.equalsIgnoreCase("(") || s_ce.equalsIgnoreCase(")")) continue;
                    v_nce.addElement(v_ce.elementAt(i));
                    continue;
                }
                if (v_ce.elementAt(i) instanceof TableColumn) {
                    TableColumn tc = (TableColumn)v_ce.elementAt(i);
                    if (tc.getTableName() == null) {
                        tc.setTableName(table_name);
                    }
                    v_nce.addElement(tc);
                    continue;
                }
                if (!(v_ce.elementAt(i) instanceof WhereColumn)) continue;
                this.removeCommaBracesFromExpressionList((WhereColumn)v_ce.elementAt(i), v_nce, table_name);
            }
        }
    }

    public WhereItem toOracleSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (this.movedToFromClause) {
            return null;
        }
        WhereItem wi = new WhereItem();
        if (SwisSQLAPI.convert_OracleThetaJOIN_To_ANSIJOIN) {
            wi.setOpenBrace(this.openBraces);
            wi.setCloseBrace(this.closeBraces);
            if (this.beginOperator != null) {
                wi.setBeginOperator(this.beginOperator);
            }
            if (this.operator1 != null) {
                wi.setOperator1(this.operator1);
            }
            if (this.leftWhereExp != null) {
                wi.setLeftWhereExp(this.leftWhereExp.toOracleSelect(to_sqs, from_sqs));
            }
            if (this.rightWhereExp != null) {
                wi.setRightWhereExp(this.rightWhereExp.toOracleSelect(to_sqs, from_sqs));
            }
            if (this.rightWhereSubQuery != null) {
                wi.setRightWhereSubQuery(this.rightWhereSubQuery.toOracleSelect());
                if (this.rightWhereSubQueryExp != null) {
                    wi.setRightWhereSubQueryExp(this.rightWhereSubQueryExp.toOracleSelect(to_sqs, from_sqs));
                }
            }
            if (this.operator != null) {
                if (this.operator.equalsIgnoreCase("^=") || this.operator.equalsIgnoreCase("!=")) {
                    wi.setOperator("<>");
                } else if (this.operator.equalsIgnoreCase("!>")) {
                    wi.setOperator("<=");
                } else if (this.operator.equalsIgnoreCase("!<")) {
                    wi.setOperator(">=");
                } else if (this.operator.equalsIgnoreCase("~") | this.operator.equalsIgnoreCase("~*")) {
                    wi.setOperator("LIKE");
                    if (wi.getRightWhereSubQuery() != null) {
                        throw new ConvertException("Conversion failure.. Subquery can't be converted");
                    }
                    WhereColumn wc = wi.getRightWhereExp();
                    Vector v_ce = wc.getColumnExpression();
                    Vector<String> v_nce = new Vector<String>();
                    if (v_ce != null) {
                        if (v_ce.size() != 1) {
                            throw new ConvertException("Conversion failure.. Expressions can't be converted");
                        }
                        String s_ce = v_ce.elementAt(0).toString();
                        if (s_ce.charAt(0) == '\'') {
                            s_ce = s_ce.replace('\'', ' ').trim();
                            s_ce = "'%" + s_ce + "%'";
                        } else if (s_ce.charAt(0) == '\"') {
                            s_ce = s_ce.replace('\"', ' ').trim();
                            s_ce = "\"%" + s_ce + "%\"";
                        } else {
                            s_ce = "'%" + s_ce + "%'";
                        }
                        v_nce.addElement(s_ce);
                        wc.setColumnExpression(v_nce);
                    }
                    wi.setRightWhereExp(wc);
                } else if (this.operator.equalsIgnoreCase("MATCHES") || this.operator.equalsIgnoreCase("NOT MATCHES")) {
                    if (this.operator.equalsIgnoreCase("MATCHES")) {
                        wi.setOperator("LIKE");
                    } else {
                        wi.setOperator("NOT LIKE");
                    }
                    WhereColumn whereColumn = wi.getRightWhereExp();
                    Vector columnExpression = whereColumn.getColumnExpression();
                    Vector<String> newColumnExpression = new Vector<String>();
                    if (columnExpression != null) {
                        String ColumnExpressionAsString = columnExpression.elementAt(0).toString();
                        if (ColumnExpressionAsString.indexOf("*") != -1) {
                            ColumnExpressionAsString = ColumnExpressionAsString.replace('*', '%');
                        }
                        if (ColumnExpressionAsString.indexOf("_") != -1) {
                            ColumnExpressionAsString = ColumnExpressionAsString.replace('_', '?');
                        }
                        newColumnExpression.add(ColumnExpressionAsString);
                        whereColumn.setColumnExpression(newColumnExpression);
                    }
                } else if (this.operator.equalsIgnoreCase("IN") | this.operator.equalsIgnoreCase("NOT IN") && wi.getRightWhereExp() != null) {
                    WhereColumn wc = wi.getRightWhereExp();
                    Vector<String> v_nsce = new Vector<String>();
                    Vector v_sce = wc.getColumnExpression();
                    if (v_sce != null && v_sce.size() > 0 && !(v_sce.elementAt(0) instanceof String)) {
                        v_nsce.addElement("(");
                        for (int i = 0; i < v_sce.size(); ++i) {
                            v_nsce.addElement((String)v_sce.elementAt(i));
                        }
                        v_nsce.addElement(")");
                        wc.setColumnExpression(v_nsce);
                    }
                    wi.setOperator(this.operator);
                } else {
                    wi.setOperator(this.operator);
                }
            }
            if (this.operator2 != null) {
                wi.setOperator2(this.operator2);
            }
            if (this.operator3 != null) {
                wi.setOperator3(this.operator3);
            }
            if (this.LeftJoin != null) {
                wi.setLeftJoin(null);
            }
            if (this.RightJoin != null) {
                wi.setRightJoin(null);
            }
        } else {
            wi.setOpenBrace(this.openBraces);
            wi.setCloseBrace(this.closeBraces);
            if (this.rownumClause != null) {
                FromTable ft;
                FromClause fc;
                if (from_sqs != null && (fc = from_sqs.getFromClause()) != null && (ft = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)from_sqs, "rownum")) != null) {
                    this.rownumClause.setRownumClause(CustomizeUtil.objectNamesToQuotedIdentifier(this.rownumClause.getRownumClause(), SwisSQLUtils.getKeywords(1), null, 1));
                }
                wi.setRownumClause(this.rownumClause);
                return wi;
            }
            if (this.beginOperator != null) {
                wi.setBeginOperator(this.beginOperator);
            }
            if (this.operator1 != null) {
                wi.setOperator1(this.operator1);
            }
            if (this.leftWhereExp != null) {
                wi.setObjectContext(this.context);
                wi.setLeftWhereExp(this.leftWhereExp.toOracleSelect(to_sqs, from_sqs));
            }
            if (this.rightWhereExp != null) {
                wi.setObjectContext(this.context);
                Vector rightColExpr = this.rightWhereExp.getColumnExpression();
                if (rightColExpr != null && rightColExpr.size() == 1) {
                    if (SwisSQLOptions.convertNullStringToOracleISNULL && rightColExpr.get(0) instanceof String && rightColExpr.get(0).toString().trim().equalsIgnoreCase("''")) {
                        String condition = rightColExpr.get(0).toString().trim();
                        wi.setRightWhereExp(null);
                        if (this.operator.trim().equals("=")) {
                            this.operator = "IS NULL";
                        } else if (this.operator.trim().equals("<>") || this.operator.trim().equals("!=")) {
                            this.operator = "IS NOT NULL";
                        }
                    } else if (rightColExpr.get(0) instanceof String && rightColExpr.get(0).toString().trim().equalsIgnoreCase("null")) {
                        wi.setRightWhereExp(null);
                        if (this.operator.trim().equalsIgnoreCase("=")) {
                            this.operator = "IS NULL";
                        } else if (this.operator.trim().equalsIgnoreCase("!=") || this.operator.trim().equalsIgnoreCase("<>")) {
                            this.operator = "IS NOT NULL";
                        }
                    } else if (rightColExpr.get(0) instanceof String && rightColExpr.get(0).toString().trim().startsWith("'")) {
                        String datatype;
                        Object obj;
                        WhereColumn lwc = wi.getLeftWhereExp();
                        boolean added = false;
                        if (lwc != null && (obj = lwc.getColumnExpression().get(0)) instanceof TableColumn && (datatype = MetadataInfoUtil.getDatatypeName(to_sqs, (TableColumn)obj)) != null) {
                            String format;
                            String value = rightColExpr.get(0).toString().trim();
                            if (datatype.toLowerCase().endsWith("datetime") && (format = SwisSQLUtils.getDateFormat(value, 1)) != null) {
                                FunctionCalls fc = new FunctionCalls();
                                TableColumn tc = new TableColumn();
                                tc.setColumnName("TO_DATE");
                                Vector<String> fnArgs = new Vector<String>();
                                if (format.startsWith("'1900")) {
                                    fnArgs.add(format);
                                    fnArgs.add("'YYYY-MM-DD HH24:MI:SS'");
                                } else {
                                    fnArgs.add(value);
                                    fnArgs.add(format);
                                }
                                fc.setFunctionName(tc);
                                fc.setFunctionArguments(fnArgs);
                                rightColExpr.setElementAt(fc, 0);
                                wi.setRightWhereExp(this.rightWhereExp);
                                added = true;
                            }
                        }
                        if (!added) {
                            wi.setRightWhereExp(this.rightWhereExp.toOracleSelect(to_sqs, from_sqs));
                        }
                    } else {
                        wi.setRightWhereExp(this.rightWhereExp.toOracleSelect(to_sqs, from_sqs));
                    }
                } else if (rightColExpr != null && rightColExpr.size() > 1 && this.operator.trim().equalsIgnoreCase("IN")) {
                    String value;
                    WhereColumn tempWC;
                    Vector colExp;
                    if (rightColExpr.get(1) instanceof WhereColumn && (colExp = (tempWC = (WhereColumn)rightColExpr.get(1)).getColumnExpression()) != null && colExp.get(0) instanceof String && (value = colExp.get(0).toString().trim()).equals("''") && SwisSQLOptions.convertNullStringToOracleISNULL) {
                        colExp.set(0, "NULL");
                    }
                    wi.setRightWhereExp(this.rightWhereExp.toOracleSelect(to_sqs, from_sqs));
                } else {
                    wi.setRightWhereExp(this.rightWhereExp.toOracleSelect(to_sqs, from_sqs));
                }
            }
            if (from_sqs != null && from_sqs.getFromClause() != null) {
                Vector containsFromItemList = from_sqs.getFromClause().getFromItemList();
                Vector outerFromItemNamesList = from_sqs.getFromClause().getOuterFromTableNames(containsFromItemList);
                boolean isJoinSet = false;
                if (outerFromItemNamesList != null && wi.getLeftWhereExp() != null && wi.getRightWhereExp() != null) {
                    WhereColumn leftWhereColumn = wi.getLeftWhereExp();
                    WhereColumn rightWhereColumn = wi.getRightWhereExp();
                    if (leftWhereColumn.getColumnExpression() != null) {
                        Vector columnExpression = leftWhereColumn.getColumnExpression();
                        String tableOrAliasName = new String();
                        for (int i = 0; i < columnExpression.size(); ++i) {
                            String tableAliasInWhere;
                            String tableAliasInWhere2;
                            if (leftWhereColumn.getColumnExpression().get(i) instanceof TableColumn) {
                                TableColumn tableColumn = (TableColumn)leftWhereColumn.getColumnExpression().get(i);
                                tableOrAliasName = tableColumn.getTableName();
                            } else if (leftWhereColumn.getColumnExpression().get(i) instanceof String && (tableAliasInWhere2 = (String)leftWhereColumn.getColumnExpression().get(i)).indexOf(".") != -1) {
                                tableOrAliasName = tableAliasInWhere2.substring(0, tableAliasInWhere2.indexOf("."));
                            }
                            if (!outerFromItemNamesList.contains(tableOrAliasName)) continue;
                            String tableOrAliasNameRight = new String();
                            if (rightWhereColumn.getColumnExpression().get(i) instanceof TableColumn) {
                                TableColumn tableColumn = (TableColumn)rightWhereColumn.getColumnExpression().get(i);
                                tableOrAliasNameRight = tableColumn.getTableName();
                            } else if (rightWhereColumn.getColumnExpression().get(i) instanceof String && (tableAliasInWhere = (String)rightWhereColumn.getColumnExpression().get(i)).indexOf(".") != -1) {
                                tableOrAliasNameRight = tableAliasInWhere.substring(0, tableAliasInWhere.indexOf("."));
                            }
                            int indexLeft = outerFromItemNamesList.indexOf(tableOrAliasName);
                            int indexRight = outerFromItemNamesList.indexOf(tableOrAliasNameRight);
                            if (indexLeft <= indexRight) continue;
                            wi.setRightJoin("+");
                            isJoinSet = true;
                        }
                    }
                    if (rightWhereColumn.getColumnExpression() != null) {
                        String tableOrAliasName = new String();
                        for (int i = 0; i < rightWhereColumn.getColumnExpression().size(); ++i) {
                            String tableAliasInWhere;
                            if (rightWhereColumn.getColumnExpression().get(i) instanceof TableColumn) {
                                TableColumn tableColumn = (TableColumn)rightWhereColumn.getColumnExpression().get(i);
                                tableOrAliasName = tableColumn.getTableName();
                            } else if (rightWhereColumn.getColumnExpression().get(i) instanceof String && (tableAliasInWhere = (String)rightWhereColumn.getColumnExpression().get(i)).indexOf(".") != -1) {
                                tableOrAliasName = tableAliasInWhere.substring(0, tableAliasInWhere.indexOf("."));
                            }
                            if (!outerFromItemNamesList.contains(tableOrAliasName) || isJoinSet) continue;
                            wi.setLeftJoin("+");
                        }
                    }
                }
            }
            if (this.LeftJoin != null) {
                if (this.LeftJoin.equalsIgnoreCase("*")) {
                    wi.setLeftJoin("+");
                } else {
                    wi.setLeftJoin(this.LeftJoin);
                }
            }
            if (this.RightJoin != null) {
                if (this.RightJoin.equalsIgnoreCase("*")) {
                    wi.setRightJoin("+");
                } else {
                    wi.setRightJoin(this.RightJoin);
                }
            }
            if (this.rightWhereSubQuery != null) {
                wi.setRightWhereSubQuery(this.rightWhereSubQuery.toOracleSelect());
                if (this.rightWhereSubQueryExp != null) {
                    wi.setRightWhereSubQueryExp(this.rightWhereSubQueryExp.toOracleSelect(to_sqs, from_sqs));
                }
            }
            if (this.operator != null) {
                if (this.operator.equalsIgnoreCase("!>")) {
                    wi.setOperator("<=");
                } else if (this.operator.equalsIgnoreCase("!<")) {
                    wi.setOperator(">=");
                } else if (this.operator.equalsIgnoreCase("~") | this.operator.equalsIgnoreCase("~*")) {
                    wi.setOperator("LIKE");
                    if (wi.getRightWhereSubQuery() != null) {
                        throw new ConvertException("Conversion failure.. Subquery can't be converted");
                    }
                    WhereColumn wc = wi.getRightWhereExp();
                    Vector v_ce = wc.getColumnExpression();
                    Vector<String> v_nce = new Vector<String>();
                    if (v_ce != null) {
                        if (v_ce.size() != 1) {
                            throw new ConvertException("Conversion failure.. Expression can't be converted");
                        }
                        String s_ce = v_ce.elementAt(0).toString();
                        if (s_ce.charAt(0) == '\'') {
                            s_ce = s_ce.replace('\'', ' ').trim();
                            s_ce = "'%" + s_ce + "%'";
                        } else if (s_ce.charAt(0) == '\"') {
                            s_ce = s_ce.replace('\"', ' ').trim();
                            s_ce = "\"%" + s_ce + "%\"";
                        } else {
                            s_ce = "'%" + s_ce + "%'";
                        }
                        v_nce.addElement(s_ce);
                        wc.setColumnExpression(v_nce);
                    }
                    wi.setRightWhereExp(wc);
                } else if ((this.operator.equalsIgnoreCase("BETWEEN") || this.operator.equalsIgnoreCase("NOT BETWEEN")) && wi.getRightWhereExp() != null) {
                    WhereColumn rightSideColumn = wi.getRightWhereExp();
                    Vector rightExpr = rightSideColumn.getColumnExpression();
                    if (rightExpr != null) {
                        Vector<String> newRightExpr = new Vector<String>();
                        for (int i = 0; i < rightExpr.size(); ++i) {
                            if (rightExpr.get(i) instanceof String) {
                                String rightString = (String)rightExpr.get(i);
                                if (rightString.equalsIgnoreCase("(") || rightString.equalsIgnoreCase(")")) continue;
                                newRightExpr.add(rightString);
                                continue;
                            }
                            newRightExpr.add((String)rightExpr.get(i));
                        }
                        rightSideColumn.setColumnExpression(newRightExpr);
                    }
                    wi.setOperator(this.operator);
                } else if (this.operator.equalsIgnoreCase("MATCHES") || this.operator.equalsIgnoreCase("NOT MATCHES")) {
                    if (this.operator.equalsIgnoreCase("MATCHES")) {
                        wi.setOperator("LIKE");
                    } else {
                        wi.setOperator("NOT LIKE");
                    }
                    WhereColumn whereColumn = wi.getRightWhereExp();
                    Vector columnExpression = whereColumn.getColumnExpression();
                    Vector<String> newColumnExpression = new Vector<String>();
                    if (columnExpression != null) {
                        String ColumnExpressionAsString = columnExpression.elementAt(0).toString();
                        if (ColumnExpressionAsString.indexOf("*") != -1) {
                            ColumnExpressionAsString = ColumnExpressionAsString.replace('*', '%');
                        }
                        if (ColumnExpressionAsString.indexOf("_") != -1) {
                            ColumnExpressionAsString = ColumnExpressionAsString.replace('_', '?');
                        }
                        newColumnExpression.add(ColumnExpressionAsString);
                        whereColumn.setColumnExpression(newColumnExpression);
                    }
                } else {
                    wi.setOperator(this.operator);
                }
            }
            if (this.operator2 != null) {
                wi.setOperator2(this.operator2);
            }
            if (this.operator3 != null) {
                wi.setOperator3(this.operator3);
            }
        }
        return wi;
    }

    public WhereItem toInformixSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (this.movedToFromClause) {
            return null;
        }
        if (this.rownumClause != null) {
            return null;
        }
        WhereItem wi = new WhereItem();
        wi.setOpenBrace(this.openBraces);
        wi.setCloseBrace(this.closeBraces);
        if (this.beginOperator != null) {
            wi.setBeginOperator(this.beginOperator);
        }
        if (this.operator1 != null) {
            wi.setOperator1(this.operator1);
        }
        if (this.leftWhereExp != null) {
            wi.setLeftWhereExp(this.leftWhereExp.toInformixSelect(to_sqs, from_sqs));
        }
        if (this.rightWhereExp != null) {
            wi.setRightWhereExp(this.rightWhereExp.toInformixSelect(to_sqs, from_sqs));
        }
        if (this.rightWhereSubQuery != null) {
            wi.setRightWhereSubQuery(this.rightWhereSubQuery.toInformixSelect());
            if (this.rightWhereSubQueryExp != null) {
                wi.setRightWhereSubQueryExp(this.rightWhereSubQueryExp.toInformixSelect(to_sqs, from_sqs));
            }
        }
        if (this.operator != null) {
            if (this.operator.equalsIgnoreCase("^=")) {
                wi.setOperator("<>");
            } else if (this.operator.equalsIgnoreCase("!>")) {
                wi.setOperator("<=");
            } else if (this.operator.equalsIgnoreCase("!<")) {
                wi.setOperator(">=");
            } else if (this.operator.equalsIgnoreCase("~") | this.operator.equalsIgnoreCase("~*")) {
                wi.setOperator("LIKE");
                if (wi.getRightWhereSubQuery() != null) {
                    throw new ConvertException("Conversion failure.. Subquery can't be converted");
                }
                WhereColumn wc = wi.getRightWhereExp();
                Vector v_ce = wc.getColumnExpression();
                Vector<String> v_nce = new Vector<String>();
                if (v_ce != null) {
                    if (v_ce.size() != 1) {
                        throw new ConvertException("Conversion failure.. Expressions can't be converted");
                    }
                    String s_ce = v_ce.elementAt(0).toString();
                    if (s_ce.charAt(0) == '\'') {
                        s_ce = s_ce.replace('\'', ' ').trim();
                        s_ce = "'%" + s_ce + "%'";
                    } else if (s_ce.charAt(0) == '\"') {
                        s_ce = s_ce.replace('\"', ' ').trim();
                        s_ce = "\"%" + s_ce + "%\"";
                    } else {
                        s_ce = "'%" + s_ce + "%'";
                    }
                    v_nce.addElement(s_ce);
                    wc.setColumnExpression(v_nce);
                }
                wi.setRightWhereExp(wc);
            } else if (this.operator.equalsIgnoreCase("LIKE") || this.operator.equalsIgnoreCase("NOT LIKE")) {
                WhereColumn whereColumn = wi.getRightWhereExp();
                Vector columnExpression = whereColumn.getColumnExpression();
                Vector<String> newColumnExpression = new Vector<String>();
                if (columnExpression != null) {
                    String ColumnExpressionAsString = columnExpression.elementAt(0).toString();
                    if (ColumnExpressionAsString.indexOf("[") != -1) {
                        if (this.operator.equalsIgnoreCase("LIKE")) {
                            wi.setOperator("MATCHES");
                        } else {
                            wi.setOperator("NOT MATCHES");
                        }
                        if (ColumnExpressionAsString.indexOf("%") != -1) {
                            ColumnExpressionAsString = ColumnExpressionAsString.replace('%', '*');
                        }
                        if (ColumnExpressionAsString.indexOf("?") != -1) {
                            ColumnExpressionAsString = ColumnExpressionAsString.replace('?', '_');
                        }
                        newColumnExpression.add(ColumnExpressionAsString);
                        whereColumn.setColumnExpression(newColumnExpression);
                    } else {
                        wi.setOperator(this.operator);
                    }
                }
            } else if (this.operator.equalsIgnoreCase("IN") | this.operator.equalsIgnoreCase("NOT IN") && wi.getRightWhereExp() != null && wi.getRightWhereSubQuery() == null) {
                WhereColumn r_wc = wi.getRightWhereExp();
                WhereColumn l_wc = wi.getLeftWhereExp();
                WhereColumn wc = wi.getRightWhereExp();
                Vector<String> v_nsce = new Vector<String>();
                Vector v_sce = wc.getColumnExpression();
                if (v_sce != null && v_sce.size() > 0 && !(v_sce.elementAt(0) instanceof String)) {
                    v_nsce.addElement("(");
                    for (int i = 0; i < v_sce.size(); ++i) {
                        v_nsce.addElement((String)v_sce.elementAt(i));
                    }
                    v_nsce.addElement(")");
                    wc.setColumnExpression(v_nsce);
                }
                wi.setOperator(this.operator);
            } else if ((this.operator.equalsIgnoreCase("IN") || this.operator.equalsIgnoreCase("NOT IN")) && wi.getRightWhereSubQuery() != null) {
                WhereColumn l_wc;
                String f_tablename = null;
                if (from_sqs != null) {
                    FromTable ft = null;
                    if (from_sqs.getFromClause().getFromItemList().elementAt(0) instanceof FromTable) {
                        ft = (FromTable)from_sqs.getFromClause().getFromItemList().elementAt(0);
                        if (ft.getAliasName() != null) {
                            f_tablename = ft.getAliasName();
                        } else if (ft.getTableName() instanceof String) {
                            f_tablename = ft.getTableName().toString();
                            int pos = f_tablename.indexOf(".");
                            if (pos == -1) {
                                pos = f_tablename.indexOf("..");
                            }
                            f_tablename = f_tablename.substring(pos + 1);
                        } else {
                            f_tablename = ft.getTableName().toString();
                        }
                    }
                }
                if ((l_wc = wi.getLeftWhereExp()).getColumnExpression() != null && l_wc.getColumnExpression().size() != 1 && l_wc.getColumnExpression().contains(",")) {
                    Vector v_removedcomma_left_column_exp = new Vector();
                    this.removeCommaBracesFromExpressionList(l_wc, v_removedcomma_left_column_exp, f_tablename);
                    wi.setLeftWhereExp(null);
                    if (this.operator.equalsIgnoreCase("IN")) {
                        wi.setOperator("EXISTS");
                    } else if (this.operator.equalsIgnoreCase("NOT IN")) {
                        wi.setOperator("NOT EXISTS");
                    }
                    SelectQueryStatement sqs = wi.getRightWhereSubQuery();
                    String f_tablename_1 = null;
                    FromTable ft_1 = (FromTable)sqs.getFromClause().getFromItemList().elementAt(0);
                    if (ft_1.getAliasName() == null) {
                        // empty if block
                    }
                    f_tablename_1 = ft_1.getAliasName() != null ? ft_1.getAliasName() : ft_1.getTableName().toString();
                    Vector v_sitl = sqs.getSelectStatement().getSelectItemList();
                    for (int i = 0; i < v_sitl.size(); ++i) {
                        WhereItem wi_1 = new WhereItem();
                        WhereColumn l_wc_1 = new WhereColumn();
                        WhereColumn r_wc_1 = new WhereColumn();
                        Vector<String> v_lce = new Vector<String>();
                        Vector v_rce = new Vector();
                        SelectColumn sc = (SelectColumn)v_sitl.elementAt(i);
                        Vector v_ce = sc.getColumnExpression();
                        String where_column_name = null;
                        if (v_ce.elementAt(0) instanceof String) {
                            where_column_name = (String)v_ce.elementAt(0);
                        } else if (v_ce.elementAt(0) instanceof TableColumn) {
                            TableColumn tc = (TableColumn)v_ce.elementAt(0);
                            if (tc.getTableName() == null) {
                                tc.setTableName(f_tablename_1);
                            }
                            where_column_name = tc.toString();
                        } else if (v_ce.elementAt(0) instanceof SelectColumn) {
                            SelectColumn selectColumnInsideSelectColumn = (SelectColumn)v_ce.elementAt(0);
                            Vector newColumnExp = selectColumnInsideSelectColumn.getColumnExpression();
                            if (newColumnExp.elementAt(0) instanceof String) {
                                where_column_name = (String)newColumnExp.elementAt(0);
                            } else if (newColumnExp.elementAt(0) instanceof TableColumn) {
                                TableColumn tableColumn = (TableColumn)newColumnExp.elementAt(0);
                                if (tableColumn.getTableName() == null) {
                                    tableColumn.setTableName(f_tablename_1);
                                }
                                where_column_name = tableColumn.toString();
                            }
                        }
                        v_lce.addElement(where_column_name);
                        l_wc_1.setColumnExpression(v_lce);
                        v_rce.addElement(v_removedcomma_left_column_exp.elementAt(i));
                        r_wc_1.setColumnExpression(v_rce);
                        wi_1.setOperator("=");
                        wi_1.setLeftWhereExp(l_wc_1);
                        wi_1.setRightWhereExp(r_wc_1);
                        if (sqs.getWhereExpression() != null) {
                            sqs.getWhereExpression().addWhereItem(wi_1);
                            sqs.getWhereExpression().addOperator("AND");
                            continue;
                        }
                        WhereExpression we = new WhereExpression();
                        we.addWhereItem(wi_1);
                        sqs.setWhereExpression(we);
                    }
                    wi.setRightWhereSubQuery(sqs);
                } else {
                    wi.setOperator(this.operator);
                }
            } else {
                wi.setOperator(this.operator);
            }
        }
        if (wi.getRightWhereSubQuery() != null && this.operator2 != null) {
            wi.setOperator2(this.operator2);
        }
        if (this.operator3 != null) {
            wi.setOperator3(this.operator3);
        }
        if (this.LeftJoin != null) {
            wi.setLeftJoin(null);
        }
        if (this.RightJoin != null) {
            wi.setRightJoin(null);
        }
        return wi;
    }

    public WhereItem convert(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs, int database) throws ConvertException {
        if (database == 8) {
            return this.toANSISelect(to_sqs, from_sqs);
        }
        if (database == 3) {
            return this.toDB2Select(to_sqs, from_sqs);
        }
        if (database == 2) {
            return this.toMSSQLServerSelect(to_sqs, from_sqs);
        }
        if (database == 7) {
            return this.toSybaseSelect(to_sqs, from_sqs);
        }
        if (database == 5) {
            return this.toMySQLSelect(to_sqs, from_sqs);
        }
        if (database == 4) {
            return this.toPostgreSQLSelect(to_sqs, from_sqs);
        }
        if (database == 6) {
            return this.toInformixSelect(to_sqs, from_sqs);
        }
        if (database == 1) {
            return this.toOracleSelect(to_sqs, from_sqs);
        }
        if (database == 11) {
            return this.toNetezzaSelect(to_sqs, from_sqs);
        }
        if (database == 12) {
            return this.toTeradataSelect(to_sqs, from_sqs);
        }
        return null;
    }

    public WhereItem toTimesTenSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (this.movedToFromClause) {
            return null;
        }
        if (this.rownumClause != null) {
            return null;
        }
        WhereItem wi = new WhereItem();
        wi.setOpenBrace(this.openBraces);
        wi.setCloseBrace(this.closeBraces);
        if (this.beginOperator != null) {
            wi.setBeginOperator(this.beginOperator);
        }
        if (this.operator1 != null) {
            wi.setOperator1(this.operator1);
        }
        if (this.leftWhereExp != null) {
            wi.setObjectContext(this.context);
            wi.setLeftWhereExp(this.leftWhereExp.toTimesTenSelect(to_sqs, from_sqs));
        }
        if (this.rightWhereExp != null) {
            wi.setObjectContext(this.context);
            Vector rightColExpr = this.rightWhereExp.getColumnExpression();
            if (rightColExpr != null && rightColExpr.size() == 1) {
                if (rightColExpr.get(0) instanceof String && rightColExpr.get(0).toString().trim().equalsIgnoreCase("null")) {
                    wi.setRightWhereExp(null);
                    if (this.operator.trim().equalsIgnoreCase("=")) {
                        this.operator = "IS NULL";
                    } else if (this.operator.trim().equalsIgnoreCase("!=") || this.operator.trim().equalsIgnoreCase("<>")) {
                        this.operator = "IS NOT NULL";
                    }
                } else if (rightColExpr.get(0) instanceof String && rightColExpr.get(0).toString().trim().startsWith("'")) {
                    String datatype;
                    Object obj;
                    WhereColumn lwc = wi.getLeftWhereExp();
                    boolean added = false;
                    if (lwc != null && (obj = lwc.getColumnExpression().get(0)) instanceof TableColumn && (datatype = MetadataInfoUtil.getDatatypeName(to_sqs, (TableColumn)obj)) != null) {
                        String value = rightColExpr.get(0).toString().trim();
                        if (datatype.toLowerCase().indexOf("date") != -1 || datatype.toLowerCase().indexOf("time") != -1) {
                            String format = SwisSQLUtils.getDateFormat(value, 10);
                            if (format != null && (format.equals("YYYY-MM-DD") || format.equals("HH24:MI:SS"))) {
                                if (datatype.toLowerCase().indexOf("datetime") != -1) {
                                    value = format.equals("YYYY-MM-DD") ? value.substring(0, value.length() - 1) + " 00:00:00'" : "'1900-01-01 " + value.substring(1);
                                    rightColExpr.setElementAt(value, 0);
                                    wi.setRightWhereExp(this.rightWhereExp);
                                    added = true;
                                }
                                format = null;
                            }
                            if (format != null) {
                                if (format.startsWith("'1900")) {
                                    rightColExpr.setElementAt(format, 0);
                                    wi.setRightWhereExp(this.rightWhereExp);
                                    added = true;
                                } else if (format.equals(value)) {
                                    int len;
                                    value = value.substring(1, value.length() - 1);
                                    String time = "";
                                    int index = 0;
                                    index = value.indexOf(" ");
                                    if (index != -1) {
                                        time = value.substring(index + 1);
                                        value = value.substring(0, index);
                                    }
                                    if ((len = value.length()) == 8) {
                                        value = value.substring(0, 4) + "-" + value.substring(4, 6) + "-" + value.substring(6);
                                    } else if (len == 6) {
                                        String yearStr = value.substring(0, 2);
                                        int year2 = Integer.parseInt(yearStr);
                                        yearStr = year2 < 50 ? "20" + yearStr : "19" + yearStr;
                                        value = yearStr + "-" + value.substring(2, 4) + "-" + value.substring(4);
                                    }
                                    if (datatype.toLowerCase().equalsIgnoreCase("time") && time == "") {
                                        value = value + " 00:00:00";
                                    } else if (time != "") {
                                        value = value + " " + time;
                                    }
                                    rightColExpr.setElementAt(value, 0);
                                    wi.setRightWhereExp(this.rightWhereExp);
                                    added = true;
                                } else {
                                    FunctionCalls fc = new FunctionCalls();
                                    TableColumn tc = new TableColumn();
                                    tc.setColumnName("TO_DATE");
                                    Vector<String> fnArgs = new Vector<String>();
                                    fnArgs.add(value);
                                    fnArgs.add(format);
                                    fc.setFunctionName(tc);
                                    fc.setFunctionArguments(fnArgs);
                                    rightColExpr.setElementAt(fc, 0);
                                    wi.setRightWhereExp(this.rightWhereExp);
                                    added = true;
                                }
                            }
                        } else if (datatype.indexOf("unichar") != -1 || datatype.indexOf("univarchar") != -1 || datatype.indexOf("nchar") != -1 || datatype.indexOf("nvarchar") != -1) {
                            rightColExpr.setElementAt("N" + value, 0);
                            wi.setRightWhereExp(this.rightWhereExp);
                            added = true;
                        }
                    }
                    if (!added) {
                        wi.setRightWhereExp(this.rightWhereExp.toTimesTenSelect(to_sqs, from_sqs));
                    }
                } else if (rightColExpr.get(0).toString().trim().startsWith("\"") && this.operator.equalsIgnoreCase("like")) {
                    rightColExpr.setElementAt(StringFunctions.replaceAll("'", "\"", rightColExpr.get(0).toString()), 0);
                    wi.setRightWhereExp(this.rightWhereExp.toTimesTenSelect(to_sqs, from_sqs));
                } else {
                    wi.setRightWhereExp(this.rightWhereExp.toTimesTenSelect(to_sqs, from_sqs));
                }
            } else if (rightColExpr != null && rightColExpr.size() == 3 && rightColExpr.get(1).toString().equalsIgnoreCase("escape") && this.operator.equals("like")) {
                if (rightColExpr.get(0).toString().trim().startsWith("\"")) {
                    rightColExpr.setElementAt(StringFunctions.replaceAll("'", "\"", rightColExpr.get(0).toString()), 0);
                }
                if (rightColExpr.get(2).toString().trim().startsWith("\"")) {
                    rightColExpr.setElementAt(StringFunctions.replaceAll("'", "\"", rightColExpr.get(2).toString()), 2);
                }
                wi.setRightWhereExp(this.rightWhereExp.toTimesTenSelect(to_sqs, from_sqs));
            } else {
                wi.setRightWhereExp(this.rightWhereExp.toTimesTenSelect(to_sqs, from_sqs));
            }
        }
        if (from_sqs != null && from_sqs.getFromClause() != null) {
            Vector containsFromItemList = from_sqs.getFromClause().getFromItemList();
            Vector outerFromItemNamesList = from_sqs.getFromClause().getOuterFromTableNames(containsFromItemList);
            boolean isJoinSet = false;
            if (outerFromItemNamesList != null && wi.getLeftWhereExp() != null && wi.getRightWhereExp() != null) {
                WhereColumn leftWhereColumn = wi.getLeftWhereExp();
                WhereColumn rightWhereColumn = wi.getRightWhereExp();
                if (leftWhereColumn.getColumnExpression() != null) {
                    Vector columnExpression = leftWhereColumn.getColumnExpression();
                    String tableOrAliasName = new String();
                    for (int i = 0; i < columnExpression.size(); ++i) {
                        String tableAliasInWhere;
                        String tableAliasInWhere2;
                        if (leftWhereColumn.getColumnExpression().get(i) instanceof TableColumn) {
                            TableColumn tableColumn = (TableColumn)leftWhereColumn.getColumnExpression().get(i);
                            tableOrAliasName = tableColumn.getTableName();
                        } else if (leftWhereColumn.getColumnExpression().get(i) instanceof String && (tableAliasInWhere2 = (String)leftWhereColumn.getColumnExpression().get(i)).indexOf(".") != -1) {
                            tableOrAliasName = tableAliasInWhere2.substring(0, tableAliasInWhere2.indexOf("."));
                        }
                        if (!outerFromItemNamesList.contains(tableOrAliasName)) continue;
                        String tableOrAliasNameRight = new String();
                        if (rightWhereColumn.getColumnExpression().get(i) instanceof TableColumn) {
                            TableColumn tableColumn = (TableColumn)rightWhereColumn.getColumnExpression().get(i);
                            tableOrAliasNameRight = tableColumn.getTableName();
                        } else if (rightWhereColumn.getColumnExpression().get(i) instanceof String && (tableAliasInWhere = (String)rightWhereColumn.getColumnExpression().get(i)).indexOf(".") != -1) {
                            tableOrAliasNameRight = tableAliasInWhere.substring(0, tableAliasInWhere.indexOf("."));
                        }
                        int indexLeft = outerFromItemNamesList.indexOf(tableOrAliasName);
                        int indexRight = outerFromItemNamesList.indexOf(tableOrAliasNameRight);
                        if (indexLeft <= indexRight) continue;
                        wi.setRightJoin("+");
                        isJoinSet = true;
                    }
                }
                if (rightWhereColumn.getColumnExpression() != null) {
                    String tableOrAliasName = new String();
                    for (int i = 0; i < rightWhereColumn.getColumnExpression().size(); ++i) {
                        String tableAliasInWhere;
                        if (rightWhereColumn.getColumnExpression().get(i) instanceof TableColumn) {
                            TableColumn tableColumn = (TableColumn)rightWhereColumn.getColumnExpression().get(i);
                            tableOrAliasName = tableColumn.getTableName();
                        } else if (rightWhereColumn.getColumnExpression().get(i) instanceof String && (tableAliasInWhere = (String)rightWhereColumn.getColumnExpression().get(i)).indexOf(".") != -1) {
                            tableOrAliasName = tableAliasInWhere.substring(0, tableAliasInWhere.indexOf("."));
                        }
                        if (!outerFromItemNamesList.contains(tableOrAliasName) || isJoinSet) continue;
                        wi.setLeftJoin("+");
                    }
                }
            }
        }
        if (this.LeftJoin != null) {
            if (this.LeftJoin.equalsIgnoreCase("*")) {
                wi.setLeftJoin("+");
                WhereColumn rwc = wi.getRightWhereExp();
                if (rwc != null && rwc.getColumnExpression().get(0) instanceof String) {
                    wi.setRightJoin("+");
                    wi.setLeftJoin(null);
                }
            } else {
                wi.setLeftJoin(this.LeftJoin);
            }
        }
        if (this.RightJoin != null) {
            if (this.RightJoin.equalsIgnoreCase("*")) {
                wi.setRightJoin("+");
            } else {
                wi.setRightJoin(this.RightJoin);
            }
        }
        if (this.rightWhereSubQuery != null) {
            wi.setRightWhereSubQuery(this.rightWhereSubQuery.toTimesTenSelect());
            if (this.rightWhereSubQueryExp != null) {
                wi.setRightWhereSubQueryExp(this.rightWhereSubQueryExp.toTimesTenSelect(to_sqs, from_sqs));
            }
        }
        if (this.operator != null) {
            if (this.operator.equalsIgnoreCase("!>")) {
                wi.setOperator("<=");
            } else if (this.operator.equalsIgnoreCase("!<")) {
                wi.setOperator(">=");
            } else if (this.operator.equalsIgnoreCase("~") | this.operator.equalsIgnoreCase("~*")) {
                wi.setOperator("LIKE");
                if (wi.getRightWhereSubQuery() != null) {
                    throw new ConvertException("Conversion failure.. Subquery can't be converted");
                }
                WhereColumn wc = wi.getRightWhereExp();
                Vector v_ce = wc.getColumnExpression();
                Vector<String> v_nce = new Vector<String>();
                if (v_ce != null) {
                    if (v_ce.size() != 1) {
                        throw new ConvertException("Conversion failure.. Expression can't be converted");
                    }
                    String s_ce = v_ce.elementAt(0).toString();
                    if (s_ce.charAt(0) == '\'') {
                        s_ce = s_ce.replace('\'', ' ').trim();
                        s_ce = "'%" + s_ce + "%'";
                    } else if (s_ce.charAt(0) == '\"') {
                        s_ce = s_ce.replace('\"', ' ').trim();
                        s_ce = "\"%" + s_ce + "%\"";
                    } else {
                        s_ce = "'%" + s_ce + "%'";
                    }
                    v_nce.addElement(s_ce);
                    wc.setColumnExpression(v_nce);
                }
                wi.setRightWhereExp(wc);
            } else if ((this.operator.equalsIgnoreCase("BETWEEN") || this.operator.equalsIgnoreCase("NOT BETWEEN")) && wi.getRightWhereExp() != null) {
                WhereColumn rightSideColumn = wi.getRightWhereExp();
                Vector rightExpr = rightSideColumn.getColumnExpression();
                if (rightExpr != null) {
                    Vector<String> newRightExpr = new Vector<String>();
                    for (int i = 0; i < rightExpr.size(); ++i) {
                        if (rightExpr.get(i) instanceof String) {
                            String rightString = (String)rightExpr.get(i);
                            if (rightString.equalsIgnoreCase("(") || rightString.equalsIgnoreCase(")")) continue;
                            newRightExpr.add(rightString);
                            continue;
                        }
                        newRightExpr.add((String)rightExpr.get(i));
                    }
                    rightSideColumn.setColumnExpression(newRightExpr);
                }
                wi.setOperator(this.operator);
            } else if (this.operator.equalsIgnoreCase("MATCHES") || this.operator.equalsIgnoreCase("NOT MATCHES")) {
                if (this.operator.equalsIgnoreCase("MATCHES")) {
                    wi.setOperator("LIKE");
                } else {
                    wi.setOperator("NOT LIKE");
                }
                WhereColumn whereColumn = wi.getRightWhereExp();
                Vector columnExpression = whereColumn.getColumnExpression();
                Vector<String> newColumnExpression = new Vector<String>();
                if (columnExpression != null) {
                    String ColumnExpressionAsString = columnExpression.elementAt(0).toString();
                    if (ColumnExpressionAsString.indexOf("*") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('*', '%');
                    }
                    if (ColumnExpressionAsString.indexOf("_") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('_', '?');
                    }
                    newColumnExpression.add(ColumnExpressionAsString);
                    whereColumn.setColumnExpression(newColumnExpression);
                }
            } else {
                wi.setOperator(this.operator);
            }
        }
        if (this.operator2 != null) {
            wi.setOperator2(this.operator2);
        }
        if (this.operator3 != null) {
            wi.setOperator3(this.operator3);
        }
        return wi;
    }

    public WhereItem toNetezzaSelect(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs) throws ConvertException {
        if (this.movedToFromClause) {
            return null;
        }
        if (this.rownumClause != null) {
            return null;
        }
        WhereItem wi = new WhereItem();
        wi.setOpenBrace(this.openBraces);
        wi.setCloseBrace(this.closeBraces);
        if (this.beginOperator != null) {
            wi.setBeginOperator(this.beginOperator);
        }
        if (this.operator1 != null) {
            wi.setOperator1(this.operator1);
        }
        if (this.leftWhereExp != null) {
            wi.setLeftWhereExp(this.leftWhereExp.toNetezzaSelect(to_sqs, from_sqs));
        }
        if (this.rightWhereExp != null) {
            wi.setRightWhereExp(this.rightWhereExp.toNetezzaSelect(to_sqs, from_sqs));
        }
        if (this.rightWhereSubQuery != null) {
            wi.setRightWhereSubQuery(this.rightWhereSubQuery.toNetezzaSelect());
            if (this.rightWhereSubQueryExp != null) {
                wi.setRightWhereSubQueryExp(this.rightWhereSubQueryExp.toNetezzaSelect(to_sqs, from_sqs));
            }
        }
        if (this.operator != null) {
            if (this.operator.equalsIgnoreCase("^=") || this.operator.equalsIgnoreCase("!=")) {
                wi.setOperator("<>");
            } else if (this.operator.equalsIgnoreCase("!>")) {
                wi.setOperator("<=");
            } else if (this.operator.equalsIgnoreCase("!<")) {
                wi.setOperator(">=");
            } else if (this.operator.equalsIgnoreCase("~") | this.operator.equalsIgnoreCase("~*")) {
                wi.setOperator("LIKE");
                if (wi.getRightWhereSubQuery() != null) {
                    throw new ConvertException("Conversion failure.. Subquery can't be converted");
                }
                WhereColumn wc = wi.getRightWhereExp();
                Vector v_ce = wc.getColumnExpression();
                Vector<String> v_nce = new Vector<String>();
                if (v_ce != null) {
                    if (v_ce.size() != 1) {
                        throw new ConvertException("Conversion failure.. Expressions can't be converted");
                    }
                    String s_ce = v_ce.elementAt(0).toString();
                    if (s_ce.charAt(0) == '\'') {
                        s_ce = s_ce.replace('\'', ' ').trim();
                        s_ce = "'%" + s_ce + "%'";
                    } else if (s_ce.charAt(0) == '\"') {
                        s_ce = s_ce.replace('\"', ' ').trim();
                        s_ce = "\"%" + s_ce + "%\"";
                    } else {
                        s_ce = "'%" + s_ce + "%'";
                    }
                    v_nce.addElement(s_ce);
                    wc.setColumnExpression(v_nce);
                }
                wi.setRightWhereExp(wc);
            } else if (this.operator.equalsIgnoreCase("MATCHES") || this.operator.equalsIgnoreCase("NOT MATCHES")) {
                if (this.operator.equalsIgnoreCase("MATCHES")) {
                    wi.setOperator("LIKE");
                } else {
                    wi.setOperator("NOT LIKE");
                }
                WhereColumn whereColumn = wi.getRightWhereExp();
                Vector columnExpression = whereColumn.getColumnExpression();
                Vector<String> newColumnExpression = new Vector<String>();
                if (columnExpression != null) {
                    String ColumnExpressionAsString = columnExpression.elementAt(0).toString();
                    if (ColumnExpressionAsString.indexOf("*") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('*', '%');
                    }
                    if (ColumnExpressionAsString.indexOf("_") != -1) {
                        ColumnExpressionAsString = ColumnExpressionAsString.replace('_', '?');
                    }
                    newColumnExpression.add(ColumnExpressionAsString);
                    whereColumn.setColumnExpression(newColumnExpression);
                }
            } else if (this.operator.equalsIgnoreCase("IN") | this.operator.equalsIgnoreCase("NOT IN") && wi.getRightWhereExp() != null) {
                WhereColumn wc = wi.getRightWhereExp();
                Vector<String> v_nsce = new Vector<String>();
                Vector v_sce = wc.getColumnExpression();
                if (v_sce != null && v_sce.size() > 0 && !(v_sce.elementAt(0) instanceof String)) {
                    v_nsce.addElement("(");
                    for (int i = 0; i < v_sce.size(); ++i) {
                        v_nsce.addElement((String)v_sce.elementAt(i));
                    }
                    v_nsce.addElement(")");
                    wc.setColumnExpression(v_nsce);
                }
                wi.setOperator(this.operator);
            } else {
                wi.setOperator(this.operator);
            }
        }
        if (this.operator2 != null) {
            wi.setOperator2(this.operator2);
        }
        if (this.operator3 != null) {
            wi.setOperator3(this.operator3);
        }
        if (this.LeftJoin != null) {
            wi.setLeftJoin(null);
        }
        if (this.RightJoin != null) {
            wi.setRightJoin(null);
        }
        return wi;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String returnString;
        StringBuffer sb;
        block44: {
            Vector colExp;
            boolean isLeftJoinAdded;
            block45: {
                int i;
                block42: {
                    Vector colExp2;
                    boolean isLeftJoinAdded2;
                    block43: {
                        block41: {
                            if (this.rownumClause != null) {
                                return this.rownumClause.toString();
                            }
                            sb = new StringBuffer();
                            if (this.openBraces != null && !this.openBraces.equals("")) {
                                sb.append(this.openBraces);
                            }
                            if (this.beginOperator != null) {
                                sb.append(this.beginOperator + " ");
                            }
                            if (this.operator1 != null) {
                                sb.append(this.operator1 + " ");
                            }
                            if (this.leftWhereExp != null) {
                                this.leftWhereExp.setObjectContext(this.context);
                                Vector colExp3 = this.leftWhereExp.getColumnExpression();
                                if (colExp3 != null) {
                                    for (int i2 = 0; i2 < colExp3.size(); ++i2) {
                                        if (colExp3.elementAt(i2) instanceof TableColumn) {
                                            ((TableColumn)colExp3.elementAt(i2)).setObjectContext(this.context);
                                            continue;
                                        }
                                        if (colExp3.elementAt(i2) instanceof SelectColumn) {
                                            ((SelectColumn)colExp3.elementAt(i2)).setObjectContext(this.context);
                                            continue;
                                        }
                                        if (!(colExp3.elementAt(i2) instanceof FunctionCalls)) continue;
                                        ((FunctionCalls)colExp3.elementAt(i2)).setObjectContext(this.context);
                                    }
                                }
                                sb.append(this.leftWhereExp.toString());
                                if (this.RightJoin != null && this.RightJoin.equals("+")) {
                                    sb.append("(" + this.RightJoin + ")");
                                }
                                if (this.LeftJoin != null && this.LeftJoin.equals("*")) {
                                    sb.append(" *");
                                }
                            }
                            if (this.operator != null) {
                                if (this.LeftJoin != null && this.LeftJoin.equals("*")) {
                                    sb.append(this.operator);
                                } else {
                                    sb.append(" " + this.operator);
                                }
                                if (this.RightJoin != null && this.RightJoin.equals("*")) {
                                    sb.append(this.RightJoin);
                                }
                            }
                            if (this.lnnvlWhereExp != null) {
                                sb.append(this.lnnvlWhereExp.toString());
                            }
                            if (this.regExp != null) {
                                for (int i3 = 0; i3 < this.regExp.size(); ++i3) {
                                    if (this.regExp.get(i3) instanceof SelectColumn) {
                                        SelectColumn sc = (SelectColumn)this.regExp.get(i3);
                                        sb.append(sc.toString());
                                        continue;
                                    }
                                    sb.append(this.regExp.get(i3).toString());
                                }
                            }
                            if (this.operator2 != null) {
                                sb.append(" " + this.operator2.toUpperCase());
                            }
                            if (this.operator3 != null) {
                                sb.append(" " + this.operator3.toUpperCase());
                            }
                            if (this.rightWhereSubQuery == null) break block41;
                            sb.append("\n");
                            ++SelectQueryStatement.beautyTabCount;
                            for (i = 0; i < SelectQueryStatement.beautyTabCount; ++i) {
                                sb.append("\t");
                            }
                            sb.append("(");
                            sb.append("\n ");
                            this.rightWhereSubQuery.setObjectContext(this.context);
                            sb.append(this.rightWhereSubQuery.toString());
                            if (this.rightWhereSubQueryExp == null) break block42;
                            isLeftJoinAdded2 = false;
                            colExp2 = this.rightWhereSubQueryExp.getColumnExpression();
                            if (colExp2 == null) break block42;
                            break block43;
                        }
                        if (this.rightWhereExp == null) break block44;
                        this.rightWhereExp.setObjectContext(this.context);
                        isLeftJoinAdded = false;
                        if (this.rightWhereExp.getOpenBrace() != null) {
                            sb.append(this.rightWhereExp.getOpenBrace());
                        }
                        if ((colExp = this.rightWhereExp.getColumnExpression()) == null) break block44;
                        break block45;
                    }
                    for (int i4 = 0; i4 < colExp2.size(); ++i4) {
                        if (colExp2.elementAt(i4) instanceof TableColumn) {
                            ((TableColumn)colExp2.elementAt(i4)).setObjectContext(this.context);
                        }
                        if (colExp2.elementAt(i4) instanceof TableColumn && !isLeftJoinAdded2) {
                            sb.append(" " + colExp2.elementAt(i4).toString());
                            if (this.LeftJoin != null && this.LeftJoin.equals("+")) {
                                sb.append(" (" + this.LeftJoin + ")");
                                isLeftJoinAdded2 = true;
                            }
                        } else {
                            sb.append(" " + colExp2.elementAt(i4).toString());
                        }
                        if (this.LeftJoin == null || !this.LeftJoin.equals("+") || isLeftJoinAdded2) continue;
                        sb.append(" (" + this.LeftJoin + ")");
                        isLeftJoinAdded2 = true;
                    }
                }
                for (i = 0; i < SelectQueryStatement.beautyTabCount; ++i) {
                    sb.append("\t");
                }
                sb.append(")");
                --SelectQueryStatement.beautyTabCount;
                break block44;
            }
            for (int i = 0; i < colExp.size(); ++i) {
                if (colExp.elementAt(i) instanceof TableColumn && !isLeftJoinAdded) {
                    ((TableColumn)colExp.elementAt(i)).setObjectContext(this.context);
                    sb.append(" " + colExp.elementAt(i).toString());
                    if (this.LeftJoin != null && this.LeftJoin.equals("+")) {
                        sb.append(" (" + this.LeftJoin + ")");
                        isLeftJoinAdded = true;
                    }
                } else if (colExp.elementAt(i) instanceof SelectColumn) {
                    ((SelectColumn)colExp.elementAt(i)).setObjectContext(this.context);
                    sb.append(" " + colExp.elementAt(i).toString());
                } else if (colExp.elementAt(i) instanceof FunctionCalls) {
                    ((FunctionCalls)colExp.elementAt(i)).setObjectContext(this.context);
                    sb.append(" " + colExp.elementAt(i).toString());
                } else {
                    sb.append(" " + colExp.elementAt(i).toString());
                }
                if (this.LeftJoin == null || !this.LeftJoin.equals("+") || isLeftJoinAdded) continue;
                sb.append(" (" + this.LeftJoin + ")");
                isLeftJoinAdded = true;
            }
            if (this.rightWhereExp.getCloseBrace() != null) {
                sb.append(this.rightWhereExp.getCloseBrace());
            }
        }
        if (this.closeBraces != null && !this.closeBraces.equals("")) {
            sb.append(this.closeBraces);
        }
        if (this.casestmtFromLNNVLClause != null) {
            sb.append(this.casestmtFromLNNVLClause.toString());
        }
        if ((returnString = sb.toString()).equals("()")) {
            return null;
        }
        return returnString;
    }

    public Object clone() {
        WhereItem item = new WhereItem();
        item.setRownumClause(this.rownumClause);
        item.setOpenBrace(this.openBraces);
        item.setOperator1(this.operator1);
        item.setLeftWhereExp(this.leftWhereExp);
        item.setOperator(this.operator);
        item.setOperator2(this.operator2);
        item.setOperator3(this.operator3);
        item.setRightWhereSubQuery(this.rightWhereSubQuery);
        item.setRightWhereExp(this.rightWhereExp);
        item.setOpenBrace(this.closeBraces);
        item.setLeftJoin(this.LeftJoin);
        item.setRightJoin(this.RightJoin);
        item.setObjectContext(this.context);
        return item;
    }

    public boolean isItAJoinItem() {
        WhereColumn rightItem;
        Vector leftColumnExpression = null;
        Vector rightColumnExpression = null;
        WhereColumn leftItem = this.getLeftWhereExp();
        if (leftItem != null) {
            leftColumnExpression = leftItem.getColumnExpression();
        }
        if ((rightItem = this.getRightWhereExp()) != null) {
            rightColumnExpression = rightItem.getColumnExpression();
        }
        return !(leftColumnExpression != null && !(leftColumnExpression.elementAt(0) instanceof TableColumn) || rightColumnExpression != null && !(rightColumnExpression.elementAt(0) instanceof TableColumn) || leftColumnExpression == null) && rightColumnExpression != null;
    }

    public Vector getWhereItemsReplacingInClause() {
        String s_ce;
        int i;
        Vector<WhereItem> whereItemsListReplacingInClause = new Vector<WhereItem>();
        String whereItemOperator = this.getOperator();
        SelectQueryStatement rightWhereSubquery = this.getRightWhereSubQuery();
        WhereColumn rightWhereExpression = this.getRightWhereExp();
        WhereColumn leftWhereColumn = this.getLeftWhereExp();
        WhereColumn rightWhereColumn = this.getRightWhereExp();
        Vector leftWhereColumnExp = leftWhereColumn.getColumnExpression();
        Vector rightWhereColumnExp = rightWhereColumn.getColumnExpression();
        Vector newLeftWhereColumnExp = new Vector();
        Vector newRightWhereColumnExp = new Vector();
        Vector removeCommaInRightColumnExp = new Vector();
        Vector removeCommaInLeftColumnExp = new Vector();
        for (i = 0; i < leftWhereColumnExp.size(); ++i) {
            if (leftWhereColumnExp.elementAt(i) instanceof String) {
                s_ce = (String)leftWhereColumnExp.elementAt(i);
                if (s_ce.equalsIgnoreCase(",") || s_ce.equalsIgnoreCase("(") || s_ce.equalsIgnoreCase(")")) continue;
                removeCommaInLeftColumnExp.addElement(leftWhereColumnExp.elementAt(i));
                continue;
            }
            removeCommaInLeftColumnExp.addElement(leftWhereColumnExp.elementAt(i));
        }
        for (i = 0; i < rightWhereColumnExp.size(); ++i) {
            if (rightWhereColumnExp.elementAt(i) instanceof String) {
                s_ce = (String)rightWhereColumnExp.elementAt(i);
                if (s_ce.equalsIgnoreCase(",") || s_ce.equalsIgnoreCase("(") || s_ce.equalsIgnoreCase(")")) continue;
                removeCommaInRightColumnExp.addElement(rightWhereColumnExp.elementAt(i));
                continue;
            }
            removeCommaInRightColumnExp.addElement(rightWhereColumnExp.elementAt(i));
        }
        for (i = 0; i < removeCommaInLeftColumnExp.size(); ++i) {
            WhereItem newWhereItem = new WhereItem();
            WhereColumn leftWhereColumnInNewWhereItem = new WhereColumn();
            WhereColumn rightWhereColumnInNewWhereItem = new WhereColumn();
            Vector v_lnsc = new Vector();
            Vector v_rnsc = new Vector();
            v_lnsc.addElement(removeCommaInLeftColumnExp.elementAt(i));
            v_rnsc.addElement(removeCommaInRightColumnExp.elementAt(i));
            leftWhereColumnInNewWhereItem.setColumnExpression(v_lnsc);
            rightWhereColumnInNewWhereItem.setColumnExpression(v_rnsc);
            newWhereItem.setLeftWhereExp(leftWhereColumnInNewWhereItem);
            newWhereItem.setRightWhereExp(rightWhereColumnInNewWhereItem);
            if (this.operator.equalsIgnoreCase("IN")) {
                newWhereItem.setOperator("=");
            } else {
                newWhereItem.setOperator("!=");
            }
            whereItemsListReplacingInClause.add(newWhereItem);
        }
        return whereItemsListReplacingInClause;
    }

    public Vector getWhereItemsReplacingEqualsClause() {
        String s_ce;
        int i;
        Vector<WhereItem> whereItemsListReplacingEqualsClause = new Vector<WhereItem>();
        String whereItemOperator = this.getOperator2();
        SelectQueryStatement rightWhereSubquery = this.getRightWhereSubQuery();
        WhereColumn rightWhereExpression = this.getRightWhereExp();
        WhereColumn leftWhereColumn = this.getLeftWhereExp();
        WhereColumn rightWhereColumn = this.getRightWhereExp();
        Vector leftWhereColumnExp = leftWhereColumn.getColumnExpression();
        Vector rightWhereColumnExp = rightWhereColumn.getColumnExpression();
        Vector newLeftWhereColumnExp = new Vector();
        Vector newRightWhereColumnExp = new Vector();
        Vector removeCommaInRightColumnExp = new Vector();
        Vector removeCommaInLeftColumnExp = new Vector();
        for (i = 0; i < leftWhereColumnExp.size(); ++i) {
            if (leftWhereColumnExp.elementAt(i) instanceof String) {
                s_ce = (String)leftWhereColumnExp.elementAt(i);
                if (s_ce.equalsIgnoreCase(",") || s_ce.equalsIgnoreCase("(") || s_ce.equalsIgnoreCase(")")) continue;
                removeCommaInLeftColumnExp.addElement(leftWhereColumnExp.elementAt(i));
                continue;
            }
            removeCommaInLeftColumnExp.addElement(leftWhereColumnExp.elementAt(i));
        }
        for (i = 0; i < rightWhereColumnExp.size(); ++i) {
            if (rightWhereColumnExp.elementAt(i) instanceof String) {
                s_ce = (String)rightWhereColumnExp.elementAt(i);
                if (s_ce.equalsIgnoreCase(",") || s_ce.equalsIgnoreCase("(") || s_ce.equalsIgnoreCase(")")) continue;
                removeCommaInRightColumnExp.addElement(rightWhereColumnExp.elementAt(i));
                continue;
            }
            removeCommaInRightColumnExp.addElement(rightWhereColumnExp.elementAt(i));
        }
        for (i = 0; i < removeCommaInRightColumnExp.size(); ++i) {
            WhereItem newWhereItem = new WhereItem();
            WhereColumn leftWhereColumnInNewWhereItem = new WhereColumn();
            WhereColumn rightWhereColumnInNewWhereItem = new WhereColumn();
            Vector v_lnsc = new Vector();
            Vector v_rnsc = new Vector();
            v_lnsc.addElement(removeCommaInLeftColumnExp.elementAt(0));
            v_rnsc.addElement(removeCommaInRightColumnExp.elementAt(i));
            leftWhereColumnInNewWhereItem.setColumnExpression(v_lnsc);
            rightWhereColumnInNewWhereItem.setColumnExpression(v_rnsc);
            newWhereItem.setLeftWhereExp(leftWhereColumnInNewWhereItem);
            newWhereItem.setRightWhereExp(rightWhereColumnInNewWhereItem);
            if (this.operator2.equalsIgnoreCase("ALL") || this.operator2.equalsIgnoreCase("ANY") || this.operator2.equalsIgnoreCase("SOME")) {
                newWhereItem.setOperator(this.getOperator());
            }
            whereItemsListReplacingEqualsClause.add(newWhereItem);
        }
        return whereItemsListReplacingEqualsClause;
    }

    private boolean containsColumnVariable(Vector colExp, boolean bool) {
        if (colExp != null) {
            for (int i = 0; i < colExp.size(); ++i) {
                if (colExp.get(i) instanceof TableColumn) {
                    if (!((TableColumn)colExp.get(i)).toString().startsWith("@")) continue;
                    bool = true;
                    continue;
                }
                if (colExp.get(i) instanceof SelectColumn) {
                    Vector selColExp = ((SelectColumn)colExp.get(i)).getColumnExpression();
                    bool = this.containsColumnVariable(selColExp, bool);
                    continue;
                }
                if (colExp.get(i) instanceof FunctionCalls) {
                    FunctionCalls fc1 = (FunctionCalls)colExp.get(i);
                    Vector FunctionArgs = fc1.getFunctionArguments();
                    String fc1Name = fc1.getFunctionNameAsAString();
                    if (fc1Name != null && fc1Name.trim().equalsIgnoreCase("CONTAINS")) {
                        this.isContainsFunction = true;
                    }
                    bool = this.containsColumnVariable(FunctionArgs, bool);
                    continue;
                }
                if (!(colExp.get(i) instanceof String)) continue;
                String str2 = (String)colExp.get(i);
                if (str2.trim().startsWith("@")) {
                    bool = true;
                    continue;
                }
                if (str2.trim().startsWith("'")) {
                    bool = true;
                    continue;
                }
                try {
                    int intValue = Integer.parseInt(str2);
                    bool = true;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        return bool;
    }

    private void convertLNNVLtoStatement(WhereExpression we) {
        this.casestmtFromLNNVLClause = new CaseStatement();
        this.operator = null;
        SelectColumn scForThenCondition = new SelectColumn();
        Vector<WhenStatement> colExpForWhenCondition = new Vector<WhenStatement>();
        TableColumn tc = new TableColumn();
        Vector<TableColumn> thenStmts = new Vector<TableColumn>();
        WhenStatement whenClause = new WhenStatement();
        SelectColumn scForElseStmt = new SelectColumn();
        Vector<TableColumn> elseStmts = new Vector<TableColumn>();
        TableColumn tcForElseStmts = new TableColumn();
        this.casestmtFromLNNVLClause.setCaseClause("CASE");
        this.casestmtFromLNNVLClause.setElseClause("ELSE");
        this.casestmtFromLNNVLClause.setEndClause("END");
        whenClause.setWhenClause("WHEN");
        whenClause.setWhenCondition(we);
        whenClause.setThenClause("THEN");
        tc.setColumnName("FALSE");
        thenStmts.add(tc);
        scForThenCondition.setColumnExpression(thenStmts);
        whenClause.setThenStatement(scForThenCondition);
        colExpForWhenCondition.add(whenClause);
        tcForElseStmts.setColumnName("TRUE");
        elseStmts.add(tcForElseStmts);
        scForElseStmt.setColumnExpression(elseStmts);
        this.casestmtFromLNNVLClause.setWhenStatementList(colExpForWhenCondition);
        this.casestmtFromLNNVLClause.setElseStatement(scForElseStmt);
    }

    public boolean checkForWeekOfDayConversion(FunctionCalls funcCall) {
        boolean needsWeekOfDayConversion = false;
        String funcStr = funcCall.toString().toUpperCase();
        if (funcCall.getFunctionName().getColumnName().equalsIgnoreCase("TRUNC") && funcStr.indexOf("MOD") != -1 && funcStr.indexOf("TO_NUMBER") != -1 && funcStr.indexOf("TO_CHAR") != -1 && funcStr.indexOf("TO_DATE") != -1) {
            needsWeekOfDayConversion = true;
        } else if (funcCall.getFunctionName().getColumnName().equalsIgnoreCase("MOD") && funcStr.indexOf("TO_CHAR") != -1) {
            needsWeekOfDayConversion = true;
        }
        return needsWeekOfDayConversion;
    }

    private void handleJulianOrDayFormatForTeradata(SelectQueryStatement to_sqs, SelectQueryStatement from_sqs, WhereItem wi, SelectColumn sc) throws ConvertException {
        Vector colExp = this.rightWhereExp.getColumnExpression();
        Vector<Object> newColExp = new Vector<Object>();
        for (int ci = 0; ci < colExp.size(); ++ci) {
            Object colObj = colExp.elementAt(ci);
            if (colObj instanceof FunctionCalls) {
                FunctionCalls wcFunc = (FunctionCalls)colObj;
                if (ci == 0 && wcFunc.getFunctionName().getColumnName().equalsIgnoreCase("trunc") && colExp.size() == 3 && colExp.lastElement().toString().equalsIgnoreCase("1") && colExp.get(colExp.size() - 2).toString().equalsIgnoreCase("+") && this.checkForWeekOfDayConversion(wcFunc)) {
                    newColExp.add(this.generateTeradataSysCalendarConstructs(to_sqs, wi, sc));
                    colExp.remove(colExp.size() - 1);
                    colExp.remove(colExp.size() - 2);
                    continue;
                }
                if (wcFunc.getFunctionName().getColumnName().equalsIgnoreCase("mod") && this.checkForWeekOfDayConversion(wcFunc)) {
                    newColExp.add(this.generateTeradataSysCalendarConstructs(to_sqs, wi, sc));
                    continue;
                }
                throw new ConvertException("Exception occurred in conversion of Oracle 'J' and 'D' date formats to Teradata");
            }
            if (colObj instanceof TableColumn) {
                newColExp.addElement(((TableColumn)colObj).toTeradataSelect(to_sqs, from_sqs));
                continue;
            }
            if (colObj instanceof WhereColumn) {
                newColExp.addElement(((WhereColumn)colObj).toTeradataSelect(to_sqs, from_sqs));
                continue;
            }
            if (colObj instanceof CaseStatement) {
                newColExp.addElement(((CaseStatement)colObj).toTeradataSelect(to_sqs, from_sqs));
                continue;
            }
            if (colObj instanceof SelectQueryStatement) {
                newColExp.addElement(((SelectQueryStatement)colObj).toTeradataSelect());
                continue;
            }
            if (colObj instanceof SelectColumn) {
                newColExp.addElement(((SelectColumn)colObj).toTeradataSelect(to_sqs, from_sqs));
                continue;
            }
            if (colObj instanceof String) {
                String s_ce = (String)colObj;
                if (s_ce.equalsIgnoreCase("**")) {
                    this.rightWhereExp.createPowerFunction(newColExp, colExp, ci);
                    continue;
                }
                if (s_ce.indexOf(".") != -1 && s_ce.charAt(0) != '\'') {
                    String[] elements = s_ce.split("\\.");
                    int esize = elements.length;
                    if (esize > 0) {
                        StringBuffer newS_ce = new StringBuffer();
                        for (int es = 0; es < esize; ++es) {
                            String elem = elements[es];
                            if ((elem = CustomizeUtil.objectNamesToQuotedIdentifier(elem, SwisSQLUtils.getKeywords("teradata"), null, -1)).equalsIgnoreCase("dual") || elem.equalsIgnoreCase("sys.dual")) {
                                elem = "\"DUAL\"";
                            }
                            if (es == 0) {
                                newS_ce.append(elem);
                                continue;
                            }
                            newS_ce.append("." + elem);
                        }
                        newColExp.addElement(newS_ce.toString());
                        colExp.setElementAt(newS_ce.toString(), ci);
                        continue;
                    }
                    newColExp.addElement(CustomizeUtil.objectNamesToQuotedIdentifier(s_ce, SwisSQLUtils.getKeywords("teradata"), null, -1));
                    continue;
                }
                newColExp.addElement(s_ce);
                continue;
            }
            newColExp.addElement(colObj);
        }
        WhereColumn newWhereCol = new WhereColumn();
        newWhereCol.setColumnExpression(newColExp);
        wi.setRightWhereExp(newWhereCol);
    }

    private TableColumn generateTeradataSysCalendarConstructs(SelectQueryStatement to_sqs, WhereItem wi, SelectColumn sc) throws ConvertException {
        TableColumn tdSysCalColumn = new TableColumn();
        tdSysCalColumn.setColumnName("day_of_week");
        tdSysCalColumn.setTableName("calendar");
        tdSysCalColumn.setOwnerName("sys_calendar");
        FromTable tdSysCalTable = new FromTable();
        tdSysCalTable.setTableName("sys_calendar.calendar");
        to_sqs.getFromClause().getFromItemList().add(tdSysCalTable);
        WhereItem tdSysCalWi = new WhereItem();
        TableColumn tdSysCalWeek = new TableColumn();
        tdSysCalWeek.setColumnName("calendar_date");
        tdSysCalWeek.setTableName("calendar");
        tdSysCalWeek.setOwnerName("sys_calendar");
        WhereColumn tdlwe = new WhereColumn();
        Vector<TableColumn> tdlweExp = new Vector<TableColumn>();
        tdlweExp.add(tdSysCalWeek);
        tdlwe.setColumnExpression(tdlweExp);
        tdSysCalWi.setLeftWhereExp(tdlwe);
        WhereColumn tdrwe = new WhereColumn();
        Vector<SelectColumn> tdrweExp = new Vector<SelectColumn>();
        tdrweExp.add(sc.toTeradataSelect(null, null));
        tdrwe.setColumnExpression(tdrweExp);
        tdSysCalWi.setRightWhereExp(tdrwe);
        tdSysCalWi.setOperator("=");
        wi.setTeradataSysCalendarWhereItem(tdSysCalWi);
        return tdSysCalColumn;
    }

    public void replaceRownumTableColumn(Object newColumn) throws ConvertException {
        if (this.rownumClause != null) {
            this.rownumClause.setRownumClause(newColumn.toString());
        }
        if (this.leftWhereExp != null) {
            this.leftWhereExp.replaceRownumTableColumn(newColumn);
        }
        if (this.rightWhereExp != null) {
            this.rightWhereExp.replaceRownumTableColumn(newColumn);
        }
    }
}

