/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.swissqlapi.sql.statement.update;

import com.adventnet.swissqlapi.sql.UserObjectContext;
import com.adventnet.swissqlapi.sql.exception.ConvertException;
import com.adventnet.swissqlapi.sql.functions.FunctionCalls;
import com.adventnet.swissqlapi.sql.statement.CommentClass;
import com.adventnet.swissqlapi.sql.statement.SwisSQLStatement;
import com.adventnet.swissqlapi.sql.statement.select.FromTable;
import com.adventnet.swissqlapi.sql.statement.select.SelectColumn;
import com.adventnet.swissqlapi.sql.statement.select.SelectQueryStatement;
import com.adventnet.swissqlapi.sql.statement.select.SelectStatement;
import com.adventnet.swissqlapi.sql.statement.select.TableColumn;
import com.adventnet.swissqlapi.sql.statement.update.SetExpression;
import com.adventnet.swissqlapi.sql.statement.update.TableClause;
import com.adventnet.swissqlapi.sql.statement.update.TableObject;
import com.adventnet.swissqlapi.sql.statement.update.UpdateQueryStatement;
import com.adventnet.swissqlapi.util.SwisSQLUtils;
import com.adventnet.swissqlapi.util.database.MetadataInfoUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class SetClause {
    private String set;
    private ArrayList setExpressionList;
    private ArrayList expressionList = new ArrayList();
    private Hashtable originalTableNameList;
    private UpdateQueryStatement fromUQS;
    private UserObjectContext context = null;
    private CommentClass commentObj;

    public void setObjectContext(UserObjectContext context) {
        this.context = context;
    }

    public void setSet(String s) {
        this.set = s;
    }

    public String getSet() {
        return this.set;
    }

    public void setExpression(ArrayList list) {
        this.expressionList = list;
    }

    public void setCommentClass(CommentClass commentObj) {
        this.commentObj = commentObj;
    }

    public CommentClass getCommentClass() {
        return this.commentObj;
    }

    public ArrayList getExpression() {
        return this.expressionList;
    }

    public ArrayList getSetExpressionList() {
        return this.setExpressionList;
    }

    public void setOriginalTableName(Hashtable tableList) {
        this.originalTableNameList = tableList;
    }

    public Hashtable getOriginalTableName() {
        return this.originalTableNameList;
    }

    public void setSetExpressionList(ArrayList list) {
        this.setExpressionList = list;
    }

    public void setFromUpdateQuerySatetemnt(UpdateQueryStatement fromUQS) {
        this.fromUQS = fromUQS;
    }

    public void toMySQL() throws ConvertException {
        ArrayList tabList;
        this.setCommentClass(null);
        String updateTableName = null;
        if (this.fromUQS != null && this.fromUQS.getTableExpression() != null && this.fromUQS.getTableExpression().getTableClauseList() != null && (tabList = this.fromUQS.getTableExpression().getTableClauseList()) != null && tabList.size() == 1 && tabList.get(0) instanceof TableClause) {
            TableClause tc = (TableClause)tabList.get(0);
            TableObject tb = tc.getTableObject();
            updateTableName = tb.getOrigTableName();
        }
        if (this.expressionList == null || this.expressionList.size() == 0) {
            int size = this.setExpressionList.size();
            for (int i = 0; i < size; i += 2) {
                SetExpression setExpression = (SetExpression)this.setExpressionList.get(i);
                setExpression.toMySQL();
            }
            this.convertSetExpressionListToExpressionList(this.setExpressionList, 5);
        } else {
            for (int i = 0; i < this.expressionList.size(); ++i) {
                if (this.expressionList.get(i) instanceof SelectQueryStatement) {
                    this.expressionList.set(i, ((SelectQueryStatement)this.expressionList.get(i)).toMySQLSelect());
                } else if (this.expressionList.get(i) instanceof SelectColumn) {
                    Vector colExp;
                    SelectColumn sc = (SelectColumn)this.expressionList.get(i);
                    if (updateTableName != null && (colExp = sc.getColumnExpression()) != null) {
                        for (int k = 0; k < colExp.size(); ++k) {
                            if (!(colExp.get(k) instanceof TableColumn)) continue;
                            TableColumn tc = (TableColumn)colExp.get(k);
                            tc.setOrigTableName(updateTableName);
                        }
                    }
                    this.expressionList.set(i, sc.toMySQLSelect(null, null));
                }
                if (!(this.expressionList.get(i) instanceof TableColumn)) continue;
                TableColumn tcToBeChanged = (TableColumn)this.expressionList.get(i);
                String checkForAliasName = tcToBeChanged.getTableName() + ".";
                if (this.originalTableNameList != null) {
                    if (this.originalTableNameList.containsKey(checkForAliasName)) {
                        TableColumn tc = (TableColumn)this.originalTableNameList.get(checkForAliasName);
                        tcToBeChanged.setTableName(tc.getTableName());
                        tcToBeChanged.setOwnerName(tc.getOwnerName());
                        this.expressionList.set(i, tcToBeChanged.toMySQLSelect(null, null));
                        continue;
                    }
                    this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toMySQLSelect(null, null));
                    continue;
                }
                this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toMySQLSelect(null, null));
            }
        }
    }

    public void toOracle() throws ConvertException {
        if (this.expressionList == null || this.expressionList.size() == 0) {
            int size = this.setExpressionList.size();
            for (int i = 0; i < size; i += 2) {
                if (!(this.setExpressionList.get(i) instanceof SetExpression)) continue;
                SetExpression setExpression = (SetExpression)this.setExpressionList.get(i);
                setExpression.toOracle();
            }
            this.convertSetExpressionListToExpressionList(this.setExpressionList, 1);
        } else {
            boolean datetime = false;
            for (int i = 0; i < this.expressionList.size(); ++i) {
                if (this.expressionList.get(i) instanceof SelectQueryStatement) {
                    this.expressionList.set(i, ((SelectQueryStatement)this.expressionList.get(i)).toOracleSelect());
                } else if (this.expressionList.get(i) instanceof SelectColumn) {
                    SelectColumn sc = (SelectColumn)this.expressionList.get(i);
                    sc.setFromUQS(this.fromUQS);
                    boolean added = false;
                    Vector colExpr = sc.getColumnExpression();
                    if (colExpr.size() == 1 && colExpr.get(0) instanceof String && colExpr.get(0).toString().trim().startsWith("'")) {
                        String format;
                        String value = colExpr.get(0).toString().trim();
                        if (datetime && (format = SwisSQLUtils.getDateFormat(value, 1)) != null) {
                            FunctionCalls fc = new FunctionCalls();
                            TableColumn tc = new TableColumn();
                            tc.setColumnName("TO_DATE");
                            Vector<String> fnArgs = new Vector<String>();
                            if (format.startsWith("'1900")) {
                                fnArgs.add(format);
                                fnArgs.add("'YYYY-MM-DD HH24:MI:SS'");
                            } else {
                                fnArgs.add(value);
                                fnArgs.add(format);
                            }
                            fc.setFunctionName(tc);
                            fc.setFunctionArguments(fnArgs);
                            colExpr.setElementAt(fc, 0);
                            this.expressionList.set(i, sc);
                            added = true;
                        }
                    }
                    if (!added) {
                        this.expressionList.set(i, ((SelectColumn)this.expressionList.get(i)).toOracleSelect(null, null));
                    }
                }
                if (this.expressionList.get(i) instanceof TableColumn) {
                    TableColumn tc = (TableColumn)this.expressionList.get(i);
                    tc.setFromUQS(this.fromUQS);
                    String datatype = MetadataInfoUtil.getDatatypeName(this.fromUQS, tc);
                    datetime = false;
                    if (datatype != null && datatype.toLowerCase().endsWith("datetime")) {
                        datetime = true;
                    }
                    this.expressionList.set(i, tc.toOracleSelect(null, null));
                }
                if (!(this.expressionList.get(i) instanceof FunctionCalls)) continue;
                FunctionCalls fc = (FunctionCalls)this.expressionList.get(i);
                fc.getFunctionArguments().add(this.expressionList.get(i - 2));
                this.expressionList.set(i - 1, " = ");
                this.expressionList.set(i, ((FunctionCalls)this.expressionList.get(i)).toOracleSelect(null, null));
            }
        }
    }

    public void toMSSQLServer() throws ConvertException {
        this.setCommentClass(null);
        boolean sqsFound = false;
        if (this.expressionList == null || this.expressionList.size() == 0) {
            int size = this.setExpressionList.size();
            for (int i = 0; i < size; i += 2) {
                SetExpression setExpression = (SetExpression)this.setExpressionList.get(i);
                setExpression.toMSSQLServer();
            }
            this.convertSetExpressionListToExpressionList(this.setExpressionList, 2);
        } else {
            int i;
            int count2 = 0;
            int tableColumnCount = 0;
            for (i = 0; i < this.expressionList.size(); ++i) {
                if (this.expressionList.get(i) instanceof SelectQueryStatement) {
                    ++count2;
                    continue;
                }
                if (!(this.expressionList.get(i) instanceof TableColumn)) continue;
                ++tableColumnCount;
            }
            if (count2 == 1) {
                sqsFound = true;
            }
            for (i = 0; i < this.expressionList.size(); ++i) {
                if (this.expressionList.get(i) instanceof SelectColumn) {
                    this.expressionList.set(i, ((SelectColumn)this.expressionList.get(i)).toMSSQLServerSelect(null, null));
                } else if (this.expressionList.get(i) instanceof SelectQueryStatement) {
                    boolean subqueryHasAggregateFunction = false;
                    SelectStatement subSelectStatement = ((SelectQueryStatement)this.expressionList.get(i)).getSelectStatement();
                    Vector subSelectCol = subSelectStatement.getSelectItemList();
                    if (subSelectCol != null) {
                        for (int j = 0; j < subSelectCol.size(); ++j) {
                            if (!(subSelectCol.get(j) instanceof SelectColumn) || !((SelectColumn)subSelectCol.get(j)).isAggregateFunction() && !this.selectColumnHasAggrFunction(((SelectColumn)subSelectCol.get(j)).getColumnExpression(), false)) continue;
                            subqueryHasAggregateFunction = true;
                        }
                    }
                    if (count2 == 1 && !subqueryHasAggregateFunction && tableColumnCount <= 1) {
                        if (i >= 3) {
                            SetExpression setExp = new SetExpression();
                            ArrayList<String> columnList = new ArrayList<String>();
                            columnList.add("(");
                            columnList.add((String)this.expressionList.get(i - 3));
                            columnList.add(")");
                            setExp.setColumnList(columnList);
                            setExp.setEqualTo("=");
                            setExp.setSubQuery((SelectQueryStatement)this.expressionList.get(i));
                            setExp.setExpressionList(null);
                            ArrayList<SetExpression> setExpressionArrayList = new ArrayList<SetExpression>();
                            setExpressionArrayList.add(setExp);
                            this.setSetExpressionList(setExpressionArrayList);
                            setExp.toMSSQLServer();
                            for (int j = i + 1; j > i - 3; --j) {
                                this.expressionList.remove(j);
                            }
                            this.expressionList = setExp.getExpressionList();
                            i -= 3;
                        } else {
                            this.expressionList.set(i, ((SelectQueryStatement)this.expressionList.get(i)).toMSSQLServerSelect());
                        }
                    } else {
                        this.expressionList.set(i, ((SelectQueryStatement)this.expressionList.get(i)).toMSSQLServerSelect());
                    }
                }
                if (!(this.expressionList.get(i) instanceof TableColumn)) continue;
                TableColumn tcToBeChanged = (TableColumn)this.expressionList.get(i);
                String checkForAliasName = tcToBeChanged.getTableName() + ".";
                if (this.originalTableNameList != null && !sqsFound) {
                    if (this.originalTableNameList.containsKey(checkForAliasName)) {
                        TableColumn tc = (TableColumn)this.originalTableNameList.get(checkForAliasName);
                        tcToBeChanged.setTableName(tc.getTableName());
                        tcToBeChanged.setOwnerName(tc.getOwnerName());
                        this.expressionList.set(i, tcToBeChanged.toMSSQLServerSelect(null, null));
                        continue;
                    }
                    this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toMSSQLServerSelect(null, null));
                    continue;
                }
                this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toMSSQLServerSelect(null, null));
            }
        }
    }

    public void toSybase() throws ConvertException {
        this.setCommentClass(null);
        boolean sqsFound = false;
        if (this.expressionList == null || this.expressionList.size() == 0) {
            int size = this.setExpressionList.size();
            for (int i = 0; i < size; i += 2) {
                SetExpression setExpression = (SetExpression)this.setExpressionList.get(i);
                setExpression.toSybase();
            }
            this.convertSetExpressionListToExpressionList(this.setExpressionList, 7);
        } else {
            int i;
            int count2 = 0;
            for (i = 0; i < this.expressionList.size(); ++i) {
                if (!(this.expressionList.get(i) instanceof SelectQueryStatement)) continue;
                ++count2;
            }
            if (count2 == 1) {
                sqsFound = true;
            }
            for (i = 0; i < this.expressionList.size(); ++i) {
                if (this.expressionList.get(i) instanceof SelectColumn) {
                    ((SelectColumn)this.expressionList.get(i)).setObjectContext(this.context);
                    this.expressionList.set(i, ((SelectColumn)this.expressionList.get(i)).toSybaseSelect(null, null));
                } else if (this.expressionList.get(i) instanceof SelectQueryStatement) {
                    boolean subqueryHasAggregateFunction = false;
                    SelectStatement subSelectStatement = ((SelectQueryStatement)this.expressionList.get(i)).getSelectStatement();
                    Vector subSelectCol = subSelectStatement.getSelectItemList();
                    if (subSelectCol != null) {
                        for (int j = 0; j < subSelectCol.size(); ++j) {
                            if (!(subSelectCol.get(j) instanceof SelectColumn) || !((SelectColumn)subSelectCol.get(j)).isAggregateFunction()) continue;
                            subqueryHasAggregateFunction = true;
                        }
                    }
                    if (count2 == 1 && !subqueryHasAggregateFunction) {
                        if (i >= 3) {
                            SetExpression setExp = new SetExpression();
                            ArrayList<String> columnList = new ArrayList<String>();
                            columnList.add("(");
                            columnList.add((String)this.expressionList.get(i - 3));
                            columnList.add(")");
                            setExp.setColumnList(columnList);
                            setExp.setEqualTo("=");
                            setExp.setSubQuery((SelectQueryStatement)this.expressionList.get(i));
                            setExp.setExpressionList(null);
                            ArrayList<SetExpression> setExpressionArrayList = new ArrayList<SetExpression>();
                            setExpressionArrayList.add(setExp);
                            this.setSetExpressionList(setExpressionArrayList);
                            setExp.toSybase();
                            for (int j = i + 1; j > i - 3; --j) {
                                this.expressionList.remove(j);
                            }
                            this.expressionList = setExp.getExpressionList();
                            i -= 3;
                        } else {
                            this.expressionList.set(i, ((SelectQueryStatement)this.expressionList.get(i)).toSybaseSelect());
                        }
                    } else {
                        this.expressionList.set(i, ((SelectQueryStatement)this.expressionList.get(i)).toSybaseSelect());
                    }
                }
                if (!(this.expressionList.get(i) instanceof TableColumn)) continue;
                TableColumn tcToBeChanged = (TableColumn)this.expressionList.get(i);
                String checkForAliasName = tcToBeChanged.getTableName() + ".";
                if (this.originalTableNameList != null && !sqsFound) {
                    if (this.originalTableNameList.containsKey(checkForAliasName)) {
                        TableColumn tc = (TableColumn)this.originalTableNameList.get(checkForAliasName);
                        tcToBeChanged.setTableName(tc.getTableName());
                        tcToBeChanged.setOwnerName(tc.getOwnerName());
                        this.expressionList.set(i, tcToBeChanged.toSybaseSelect(null, null));
                        continue;
                    }
                    this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toSybaseSelect(null, null));
                    continue;
                }
                this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toSybaseSelect(null, null));
            }
        }
    }

    public void toPostgreSQL() throws ConvertException {
        this.setCommentClass(null);
        if (this.expressionList == null || this.expressionList.size() == 0) {
            int size = this.setExpressionList.size();
            for (int i = 0; i < size; i += 2) {
                SetExpression setExpression = (SetExpression)this.setExpressionList.get(i);
                setExpression.toPostgreSQL();
            }
            this.convertSetExpressionListToExpressionList(this.setExpressionList, 4);
        } else {
            for (int i = 0; i < this.expressionList.size(); ++i) {
                if (this.expressionList.get(i) instanceof SelectQueryStatement) {
                    this.expressionList.set(i, ((SelectQueryStatement)this.expressionList.get(i)).toPostgreSQLSelect());
                } else if (this.expressionList.get(i) instanceof SelectColumn) {
                    SelectColumn sc = (SelectColumn)this.expressionList.get(i);
                    if (this.originalTableNameList != null) {
                        sc.setOriginalTableNamesForUpdateSetClause(this.originalTableNameList);
                    }
                    this.expressionList.set(i, sc.toPostgreSQLSelect(null, null));
                }
                if (!(this.expressionList.get(i) instanceof TableColumn)) continue;
                TableColumn tcToBeChanged = (TableColumn)this.expressionList.get(i);
                String checkForAliasName = tcToBeChanged.getTableName() + ".";
                if (this.originalTableNameList != null) {
                    if (this.originalTableNameList.containsKey(checkForAliasName)) {
                        TableColumn tc = (TableColumn)this.originalTableNameList.get(checkForAliasName);
                        tcToBeChanged.setTableName(tc.getTableName());
                        this.expressionList.set(i, tcToBeChanged.toPostgreSQLSelect(null, null));
                        continue;
                    }
                    this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toPostgreSQLSelect(null, null));
                    continue;
                }
                this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toPostgreSQLSelect(null, null));
            }
        }
    }

    public void toDB2() throws ConvertException {
        this.setCommentClass(null);
        if (this.expressionList == null || this.expressionList.size() == 0) {
            int size = this.setExpressionList.size();
            for (int i = 0; i < size; i += 2) {
                SetExpression setExpression = (SetExpression)this.setExpressionList.get(i);
                setExpression.toDB2();
            }
        } else {
            for (int i = 0; i < this.expressionList.size(); ++i) {
                String str2;
                Object scObj;
                SelectColumn sc;
                Vector colExpr;
                Object obj;
                if (this.expressionList.get(i) instanceof SelectQueryStatement) {
                    this.expressionList.set(i, ((SelectQueryStatement)this.expressionList.get(i)).toDB2Select());
                } else if (this.expressionList.get(i) instanceof SelectColumn) {
                    String str3;
                    Object obj2;
                    SelectColumn sc2 = (SelectColumn)this.expressionList.get(i);
                    Vector colExpr2 = sc2.getColumnExpression();
                    boolean added = false;
                    if (colExpr2 != null && colExpr2.size() == 1 && (obj2 = colExpr2.get(0)) instanceof String && (str3 = (String)obj2).equalsIgnoreCase("NULL")) {
                        added = true;
                        this.expressionList.set(i, sc2);
                    }
                    if (!added) {
                        TableColumn tableColumn;
                        FromTable fromTable;
                        if (i - 2 >= 0 && (obj2 = this.expressionList.get(i - 2)) instanceof TableColumn && (fromTable = MetadataInfoUtil.getTableOfColumn((SwisSQLStatement)this.fromUQS, tableColumn = (TableColumn)obj2)) != null) {
                            if (fromTable.getTableName() instanceof String) {
                                tableColumn.setTableName((String)fromTable.getTableName());
                            }
                            sc2.setCorrespondingTableColumn(tableColumn);
                        }
                        this.expressionList.set(i, sc2.toDB2Select(null, null));
                    }
                }
                if (!(this.expressionList.get(i) instanceof TableColumn)) continue;
                this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toDB2Select(null, null));
                String dataType = MetadataInfoUtil.getDatatypeName(this.fromUQS, (TableColumn)this.expressionList.get(i));
                if (dataType == null || dataType.toLowerCase().trim().indexOf("int") == -1 && dataType.toLowerCase().trim().indexOf("num") == -1 || i + 2 >= this.expressionList.size() || !((obj = this.expressionList.get(i + 2)) instanceof SelectColumn) || (colExpr = (sc = (SelectColumn)obj).getColumnExpression()) == null || colExpr.size() != 1 || !((scObj = colExpr.get(0)) instanceof String) || !(str2 = (String)scObj).startsWith("'")) continue;
                colExpr.setElementAt(str2.substring(1, str2.length() - 1), 0);
            }
        }
    }

    public void toInformix() throws ConvertException {
        this.setCommentClass(null);
        if (this.expressionList == null || this.expressionList.size() == 0) {
            int size = this.setExpressionList.size();
            for (int i = 0; i < size; i += 2) {
                SetExpression setExpression = (SetExpression)this.setExpressionList.get(i);
                setExpression.toInformix();
            }
        } else {
            for (int i = 0; i < this.expressionList.size(); ++i) {
                if (this.expressionList.get(i) instanceof SelectQueryStatement) {
                    this.expressionList.set(i, ((SelectQueryStatement)this.expressionList.get(i)).toInformixSelect());
                } else if (this.expressionList.get(i) instanceof SelectColumn) {
                    this.expressionList.set(i, ((SelectColumn)this.expressionList.get(i)).toInformixSelect(null, null));
                }
                if (!(this.expressionList.get(i) instanceof TableColumn)) continue;
                TableColumn tcToBeChanged = (TableColumn)this.expressionList.get(i);
                String checkForAliasName = tcToBeChanged.getTableName() + ".";
                if (this.originalTableNameList != null) {
                    if (this.originalTableNameList.containsKey(checkForAliasName)) {
                        TableColumn tc = (TableColumn)this.originalTableNameList.get(checkForAliasName);
                        tcToBeChanged.setTableName(tc.getTableName());
                        tcToBeChanged.setOwnerName(tc.getOwnerName());
                        this.expressionList.set(i, tcToBeChanged.toInformixSelect(null, null));
                        continue;
                    }
                    this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toInformixSelect(null, null));
                    continue;
                }
                this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toInformixSelect(null, null));
            }
        }
    }

    public void toANSISQL() throws ConvertException {
        this.setCommentClass(null);
        if (this.expressionList == null || this.expressionList.size() == 0) {
            int size = this.setExpressionList.size();
            for (int i = 0; i < size; i += 2) {
                SetExpression setExpression = (SetExpression)this.setExpressionList.get(i);
                setExpression.toANSISQL();
            }
            this.convertSetExpressionListToExpressionList(this.setExpressionList, 8);
        } else {
            for (int i = 0; i < this.expressionList.size(); ++i) {
                if (this.expressionList.get(i) instanceof SelectQueryStatement) {
                    this.expressionList.set(i, ((SelectQueryStatement)this.expressionList.get(i)).toANSISelect());
                } else if (this.expressionList.get(i) instanceof SelectColumn) {
                    this.expressionList.set(i, ((SelectColumn)this.expressionList.get(i)).toANSISelect(null, null));
                }
                if (!(this.expressionList.get(i) instanceof TableColumn)) continue;
                TableColumn tcToBeChanged = (TableColumn)this.expressionList.get(i);
                String checkForAliasName = tcToBeChanged.getTableName() + ".";
                if (this.originalTableNameList != null) {
                    if (this.originalTableNameList.containsKey(checkForAliasName)) {
                        TableColumn tc = (TableColumn)this.originalTableNameList.get(checkForAliasName);
                        tcToBeChanged.setTableName(tc.getTableName());
                        tcToBeChanged.setOwnerName(tc.getOwnerName());
                        this.expressionList.set(i, tcToBeChanged.toANSISelect(null, null));
                        continue;
                    }
                    this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toANSISelect(null, null));
                    continue;
                }
                this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toANSISelect(null, null));
            }
        }
    }

    public void toTeradata() throws ConvertException {
        this.setCommentClass(null);
        if (this.expressionList == null || this.expressionList.size() == 0) {
            int size = this.setExpressionList.size();
            for (int i = 0; i < size; i += 2) {
                SetExpression setExpression = (SetExpression)this.setExpressionList.get(i);
                setExpression.toTeradata();
            }
            this.convertSetExpressionListToExpressionList(this.setExpressionList, 12);
        } else {
            for (int i = 0; i < this.expressionList.size(); ++i) {
                TableColumn tc;
                if (this.expressionList.get(i) instanceof SelectQueryStatement) {
                    this.expressionList.set(i, ((SelectQueryStatement)this.expressionList.get(i)).toTeradataSelect());
                } else if (this.expressionList.get(i) instanceof SelectColumn) {
                    this.expressionList.set(i, ((SelectColumn)this.expressionList.get(i)).toTeradataSelect(null, null));
                }
                if (!(this.expressionList.get(i) instanceof TableColumn)) continue;
                TableColumn tcToBeChanged = (TableColumn)this.expressionList.get(i);
                String checkForAliasName = tcToBeChanged.getTableName() + ".";
                if (this.originalTableNameList != null) {
                    if (this.originalTableNameList.containsKey(checkForAliasName)) {
                        tc = (TableColumn)this.originalTableNameList.get(checkForAliasName);
                        tcToBeChanged.setTableName(tc.getTableName());
                        tcToBeChanged.setOwnerName(tc.getOwnerName());
                        this.expressionList.set(i, tcToBeChanged.toTeradataSelect(null, null));
                        continue;
                    }
                    this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toTeradataSelect(null, null));
                    continue;
                }
                tc = ((TableColumn)this.expressionList.get(i)).toTeradataSelect(null, null);
                if (tc.getTableName() != null) {
                    tc.setTableName(null);
                }
                this.expressionList.set(i, tc);
            }
        }
    }

    public void toTimesTen() throws ConvertException {
        this.setCommentClass(null);
        if (this.expressionList == null || this.expressionList.size() == 0) {
            int size = this.setExpressionList.size();
            for (int i = 0; i < size; i += 2) {
                if (!(this.setExpressionList.get(i) instanceof SetExpression)) continue;
                SetExpression setExpression = (SetExpression)this.setExpressionList.get(i);
                setExpression.toTimesTen();
            }
            this.convertSetExpressionListToExpressionList(this.setExpressionList, 10);
        } else {
            boolean datetime = false;
            boolean timestamp = false;
            boolean unicode = false;
            for (int i = 0; i < this.expressionList.size(); ++i) {
                if (this.expressionList.get(i) instanceof SelectQueryStatement) {
                    throw new ConvertException("\nSubqueries are not supported in UPDATE statement's SET Clause in TimesTen 5.1.21\n");
                }
                if (this.expressionList.get(i) instanceof SelectColumn) {
                    if (this.expressionList.get(i).toString().equalsIgnoreCase("default")) {
                        throw new ConvertException("\nDEFAULT clause not supported in the UPDATE statemnet in TimesTen 5.1.21\n");
                    }
                    boolean added = false;
                    SelectColumn sc = (SelectColumn)this.expressionList.get(i);
                    sc.setFromUQS(this.fromUQS);
                    Vector colExpr = sc.getColumnExpression();
                    if (colExpr.size() == 1 && colExpr.get(0) instanceof String && colExpr.get(0).toString().trim().startsWith("'")) {
                        String value = colExpr.get(0).toString().trim();
                        if (datetime) {
                            String format = SwisSQLUtils.getDateFormat(value, 10);
                            if (format != null && (format.equals("YYYY-MM-DD") || format.equals("HH24:MI:SS"))) {
                                if (timestamp) {
                                    value = format.equals("YYYY-MM-DD") ? value.substring(0, value.length() - 1) + " 00:00:00'" : "'1900-01-01 " + value.substring(1);
                                    colExpr.setElementAt(value, 0);
                                    this.expressionList.set(i, sc);
                                    added = true;
                                }
                                format = null;
                            }
                            if (format != null) {
                                if (format.startsWith("'1900")) {
                                    colExpr.setElementAt(format, 0);
                                    this.expressionList.set(i, sc);
                                    added = true;
                                } else if (format.equals(value)) {
                                    int len;
                                    value = value.substring(1, value.length() - 1);
                                    String time = "";
                                    int index = 0;
                                    index = value.indexOf(" ");
                                    if (index != -1) {
                                        time = value.substring(index + 1);
                                        value = value.substring(0, index);
                                    }
                                    if ((len = value.length()) == 8) {
                                        value = value.substring(0, 4) + "-" + value.substring(4, 6) + "-" + value.substring(6);
                                    } else if (len == 6) {
                                        String yearStr = value.substring(0, 2);
                                        int year2 = Integer.parseInt(yearStr);
                                        yearStr = year2 < 50 ? "20" + yearStr : "19" + yearStr;
                                        value = yearStr + "-" + value.substring(2, 4) + "-" + value.substring(4);
                                    }
                                    if (timestamp && time == "") {
                                        value = value + " 00:00:00";
                                    } else if (time != "") {
                                        value = value + " " + time;
                                    }
                                    colExpr.setElementAt(value, 0);
                                    this.expressionList.set(i, sc);
                                    added = true;
                                } else {
                                    FunctionCalls fc = new FunctionCalls();
                                    TableColumn tc = new TableColumn();
                                    tc.setColumnName("TO_DATE");
                                    Vector<String> fnArgs = new Vector<String>();
                                    fnArgs.add(value);
                                    fnArgs.add(format);
                                    fc.setFunctionName(tc);
                                    fc.setFunctionArguments(fnArgs);
                                    colExpr.setElementAt(fc, 0);
                                    this.expressionList.set(i, sc);
                                    added = true;
                                }
                            }
                        } else if (unicode) {
                            colExpr.setElementAt("N" + value, 0);
                            this.expressionList.set(i, sc);
                            added = true;
                        }
                    }
                    if (!added) {
                        this.expressionList.set(i, ((SelectColumn)this.expressionList.get(i)).toTimesTenSelect(null, null));
                    }
                }
                if (!(this.expressionList.get(i) instanceof TableColumn)) continue;
                TableColumn tc = (TableColumn)this.expressionList.get(i);
                String datatype = MetadataInfoUtil.getDatatypeName(this.fromUQS, tc);
                datetime = false;
                timestamp = false;
                unicode = false;
                if (datatype != null) {
                    if (datatype.indexOf("date") != -1 || datatype.indexOf("time") != -1) {
                        datetime = true;
                        if (datatype.toLowerCase().indexOf("datetime") != -1) {
                            timestamp = true;
                        }
                    } else if (datatype.indexOf("unichar") != -1 || datatype.indexOf("univarchar") != -1 || datatype.indexOf("nchar") != -1 || datatype.indexOf("nvarchar") != -1) {
                        unicode = true;
                    }
                }
                this.expressionList.set(i, tc.toTimesTenSelect(null, null));
            }
        }
    }

    public void toNetezza() throws ConvertException {
        this.setCommentClass(null);
        boolean sqsFound = false;
        if (this.expressionList == null || this.expressionList.size() == 0) {
            int size = this.setExpressionList.size();
            for (int i = 0; i < size; i += 2) {
                SetExpression setExpression = (SetExpression)this.setExpressionList.get(i);
                setExpression.toNetezzaSQL();
            }
            this.convertSetExpressionListToExpressionList(this.setExpressionList, 2);
        } else {
            int i;
            int count2 = 0;
            int tableColumnCount = 0;
            for (i = 0; i < this.expressionList.size(); ++i) {
                if (this.expressionList.get(i) instanceof SelectQueryStatement) {
                    ++count2;
                    continue;
                }
                if (!(this.expressionList.get(i) instanceof TableColumn)) continue;
                ++tableColumnCount;
            }
            if (count2 == 1) {
                sqsFound = true;
            }
            for (i = 0; i < this.expressionList.size(); ++i) {
                if (this.expressionList.get(i) instanceof SelectColumn) {
                    this.expressionList.set(i, ((SelectColumn)this.expressionList.get(i)).toNetezzaSelect(null, null));
                } else if (this.expressionList.get(i) instanceof SelectQueryStatement) {
                    boolean subqueryHasAggregateFunction = false;
                    SelectStatement subSelectStatement = ((SelectQueryStatement)this.expressionList.get(i)).getSelectStatement();
                    Vector subSelectCol = subSelectStatement.getSelectItemList();
                    if (subSelectCol != null) {
                        for (int j = 0; j < subSelectCol.size(); ++j) {
                            if (!(subSelectCol.get(j) instanceof SelectColumn) || !((SelectColumn)subSelectCol.get(j)).isAggregateFunction() && !this.selectColumnHasAggrFunction(((SelectColumn)subSelectCol.get(j)).getColumnExpression(), false)) continue;
                            subqueryHasAggregateFunction = true;
                        }
                    }
                    if (count2 == 1 && !subqueryHasAggregateFunction && tableColumnCount <= 1) {
                        if (i >= 3) {
                            SetExpression setExp = new SetExpression();
                            ArrayList<String> columnList = new ArrayList<String>();
                            columnList.add("(");
                            columnList.add((String)this.expressionList.get(i - 3));
                            columnList.add(")");
                            setExp.setColumnList(columnList);
                            setExp.setEqualTo("=");
                            setExp.setSubQuery((SelectQueryStatement)this.expressionList.get(i));
                            setExp.setExpressionList(null);
                            ArrayList<SetExpression> setExpressionArrayList = new ArrayList<SetExpression>();
                            setExpressionArrayList.add(setExp);
                            this.setSetExpressionList(setExpressionArrayList);
                            setExp.toNetezzaSQL();
                            for (int j = i + 1; j > i - 3; --j) {
                                this.expressionList.remove(j);
                            }
                            this.expressionList = setExp.getExpressionList();
                            i -= 3;
                        } else {
                            this.expressionList.set(i, ((SelectQueryStatement)this.expressionList.get(i)).toNetezzaSelect());
                        }
                    } else {
                        this.expressionList.set(i, ((SelectQueryStatement)this.expressionList.get(i)).toNetezzaSelect());
                    }
                }
                if (!(this.expressionList.get(i) instanceof TableColumn)) continue;
                TableColumn tcToBeChanged = (TableColumn)this.expressionList.get(i);
                String checkForAliasName = tcToBeChanged.getTableName() + ".";
                if (this.originalTableNameList != null && !sqsFound) {
                    if (this.originalTableNameList.containsKey(checkForAliasName)) {
                        TableColumn tc = (TableColumn)this.originalTableNameList.get(checkForAliasName);
                        tcToBeChanged.setTableName(tc.getTableName());
                        tcToBeChanged.setOwnerName(tc.getOwnerName());
                        this.expressionList.set(i, tcToBeChanged.toNetezzaSelect(null, null));
                        continue;
                    }
                    this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toNetezzaSelect(null, null));
                    continue;
                }
                this.expressionList.set(i, ((TableColumn)this.expressionList.get(i)).toNetezzaSelect(null, null));
            }
        }
    }

    private void convertSetExpressionListToExpressionList(ArrayList setExpressionList, int database) throws ConvertException {
        int size = setExpressionList.size();
        for (int i = 0; i < size; ++i) {
            Object obj = setExpressionList.get(i);
            if (!(obj instanceof SetExpression)) {
                this.expressionList.add(obj.toString());
                continue;
            }
            SetExpression setExpression = (SetExpression)setExpressionList.get(i);
            ArrayList columnList = setExpression.getColumnList();
            ArrayList valueList = setExpression.getExpressionList();
            if (database == 10 && columnList.size() > 1) {
                throw new ConvertException("\nSET with multiple LHS COLUMNs is not supported in UPDATE statement in TimesTen 5.1.21\n");
            }
            if (valueList == null) {
                return;
            }
            if (columnList == null && valueList != null) {
                if (database == 11) {
                    boolean j1 = true;
                    if (size == 1) {
                        this.expressionList = valueList;
                        return;
                    }
                    int valueSize = valueList.size();
                    for (int vS = 0; vS < valueSize; ++vS) {
                        this.expressionList.add(valueList.get(vS));
                    }
                    if (i < size - 1) {
                        this.expressionList.add(", ");
                        continue;
                    }
                    return;
                }
                this.expressionList = valueList;
                return;
            }
            int size1 = columnList.size();
            if (size1 == 1) {
                this.expressionList.add(columnList.get(0).toString());
                this.expressionList.add(" = ");
                if (valueList.size() != 1 && valueList.size() != 2) continue;
                this.expressionList.add(valueList.get(0).toString());
                continue;
            }
            for (int i1 = 1; i1 < size1; i1 += 2) {
                this.expressionList.add(columnList.get(i1).toString());
                this.expressionList.add(" = ");
                if (valueList.size() == 1 || valueList.size() == 2) {
                    this.expressionList.add(valueList.get(0).toString());
                } else {
                    this.expressionList.add(valueList.get(i1).toString());
                }
                if (i1 >= size1 - 2) continue;
                this.expressionList.add(", ");
            }
        }
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        if (this.commentObj != null) {
            stringbuffer.append(this.commentObj.toString().trim() + " ");
        }
        stringbuffer.append(this.set.toUpperCase());
        stringbuffer.append("\t");
        if (this.expressionList == null || this.expressionList.size() == 0) {
            int size = this.setExpressionList.size();
            for (int i = 0; i < size; ++i) {
                if (this.setExpressionList.get(i) instanceof TableColumn) {
                    ((TableColumn)this.setExpressionList.get(i)).setObjectContext(this.context);
                }
                stringbuffer.append(this.setExpressionList.get(i).toString());
            }
        } else {
            ++SelectQueryStatement.beautyTabCount;
            int size = this.expressionList.size();
            for (int i = 0; i < size; ++i) {
                if (this.expressionList.get(i) instanceof SelectQueryStatement) {
                    stringbuffer.append("\n");
                    SelectQueryStatement.beautyTabCount += 3;
                    ((SelectQueryStatement)this.expressionList.get(i)).setObjectContext(this.context);
                    stringbuffer.append(this.expressionList.get(i));
                    SelectQueryStatement.beautyTabCount -= 3;
                    stringbuffer.append("\t\t\t\t");
                    ++i;
                } else if (!(this.expressionList.get(i) instanceof String) || ((String)this.expressionList.get(i)).trim().startsWith("(SELECT ")) {
                    // empty if block
                }
                if (this.expressionList.get(i) instanceof TableColumn) {
                    ((TableColumn)this.expressionList.get(i)).setObjectContext(this.context);
                    stringbuffer.append(this.expressionList.get(i));
                } else if (this.expressionList.get(i) instanceof FunctionCalls) {
                    ((FunctionCalls)this.expressionList.get(i)).setObjectContext(this.context);
                    stringbuffer.append(this.expressionList.get(i));
                } else if (this.expressionList.get(i) instanceof SelectColumn) {
                    ((SelectColumn)this.expressionList.get(i)).setObjectContext(this.context);
                    stringbuffer.append(this.expressionList.get(i));
                } else if (this.context != null) {
                    stringbuffer.append(this.context.getEquivalent(this.expressionList.get(i).toString()));
                } else {
                    stringbuffer.append(this.expressionList.get(i));
                }
                if (this.expressionList.get(i) instanceof SelectColumn) {
                    ((SelectColumn)this.expressionList.get(i)).setObjectContext(this.context);
                    if (!this.expressionList.get(i).toString().trim().endsWith(",")) continue;
                    stringbuffer.append("\n\t");
                    continue;
                }
                if (!(this.expressionList.get(i) instanceof String) || !((String)this.expressionList.get(i)).endsWith(",")) continue;
                stringbuffer.append("\t");
            }
            --SelectQueryStatement.beautyTabCount;
        }
        return stringbuffer.toString();
    }

    private boolean selectColumnHasAggrFunction(Vector colExp, boolean inputVal) {
        boolean bool = inputVal;
        if (colExp != null) {
            for (int i = 0; i < colExp.size(); ++i) {
                if (colExp.get(i) instanceof SelectColumn) {
                    if (((SelectColumn)colExp.get(i)).isAggregateFunction()) {
                        return true;
                    }
                    Vector selColExp = ((SelectColumn)colExp.get(i)).getColumnExpression();
                    bool = this.selectColumnHasAggrFunction(selColExp, bool);
                    continue;
                }
                if (!(colExp.get(i) instanceof FunctionCalls)) continue;
                Vector FunctionArgs = ((FunctionCalls)colExp.get(i)).getFunctionArguments();
                bool = this.selectColumnHasAggrFunction(FunctionArgs, bool);
            }
        }
        return bool;
    }
}

