/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.engine.process.handlers;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlTransient;
import org.fao.fi.comet.core.engine.process.handlers.MatchingProcessHandler;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessStatus;
import org.fao.fi.comet.core.patterns.data.providers.ProvidedData;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.classes.ClassUtils;

public abstract class MatchingProcessHandlerSkeleton<SOURCE extends Serializable>
implements MatchingProcessHandler<SOURCE> {
    private boolean _running = false;
    @XmlTransient
    private MatchingEngineProcessStatus _processStatus = new MatchingEngineProcessStatus();

    public MatchingProcessHandlerSkeleton() {
        this._processStatus.setProcessId(ClassUtils.getThis(this));
    }

    public MatchingProcessHandlerSkeleton(String processId) {
        this();
        this._processStatus.setProcessId(processId);
    }

    @Override
    public MatchingEngineProcessStatus getProcessStatus() {
        return this._processStatus;
    }

    @Override
    public final boolean isRunning() {
        return this._running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setRunning(boolean running) {
        MatchingProcessHandlerSkeleton matchingProcessHandlerSkeleton = this;
        synchronized (matchingProcessHandlerSkeleton) {
            this._running = running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void halt() {
        MatchingProcessHandlerSkeleton matchingProcessHandlerSkeleton = this;
        synchronized (matchingProcessHandlerSkeleton) {
            AssertionUtils.$_assert(this._running, "The engine cannot be halted as it is not running!", new Object[0]);
            this.setRunning(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void notifyComparisonProcessStarted(String processId) {
        MatchingProcessHandlerSkeleton matchingProcessHandlerSkeleton = this;
        synchronized (matchingProcessHandlerSkeleton) {
            AssertionUtils.$_nAssert(this._running, "The engine cannot be started as it is already running!", new Object[0]);
            this._processStatus.setProcessId(processId);
            this._processStatus.setProcessStartTimestamp(System.currentTimeMillis());
            this._processStatus.setProcessEndTimestamp(-1L);
            this._running = true;
            this.doNotifyProcessStartEvent(processId);
        }
    }

    protected abstract void doNotifyProcessStartEvent(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void notifyComparisonProcessCompleted() {
        MatchingProcessHandlerSkeleton matchingProcessHandlerSkeleton = this;
        synchronized (matchingProcessHandlerSkeleton) {
            this._processStatus.setProcessEndTimestamp(System.currentTimeMillis());
            this.doNotifyProcessEndEvent();
        }
    }

    protected abstract void doNotifyProcessEndEvent();

    @Override
    public final long getElapsed() {
        long processStartTimestamp = this._processStatus.getProcessStartTimestamp();
        long processEndTimestamp = this._processStatus.getProcessEndTimestamp();
        return processStartTimestamp == -1L ? -1L : (processEndTimestamp == -1L ? System.currentTimeMillis() : processEndTimestamp) - processStartTimestamp;
    }

    @Override
    public final void setNumberOfComparisonRounds(int rounds) {
        this._processStatus.setNumberOfComparisonRounds(rounds);
        this.doNotifyNumberOfComparisonRoundsChanged(rounds);
    }

    protected abstract void doNotifyNumberOfComparisonRoundsChanged(int var1);

    @Override
    public final void notifyComparisonRoundStart(ProvidedData<SOURCE> source) {
        this._processStatus.setCurrentNumberOfAtomicComparisonsPerformedInRound(0);
        this.doNotifyComparisonRoundStart(source);
    }

    protected abstract void doNotifyComparisonRoundStart(ProvidedData<SOURCE> var1);

    @Override
    public final void notifyComparisonRoundPerformed(ProvidedData<SOURCE> source) {
        this._processStatus.increaseCurrentNumberOfComparisonRoundsPerformed();
        this.doNotifyComparisonRoundPerformed(source);
    }

    protected abstract void doNotifyComparisonRoundPerformed(ProvidedData<SOURCE> var1);

    @Override
    public final void setMaximumNumberOfAtomicComparisonsPerformedInRound(int comparisons) {
        this._processStatus.setMaximumNumberOfAtomicComparisonsPerformedInRound(comparisons);
        this._processStatus.setCurrentNumberOfAtomicComparisonsPerformedInRound(0);
        this.doNotifyMaximumNumberOfAtomicComparisonsPerformedInRoundChanged(comparisons);
    }

    protected abstract void doNotifyMaximumNumberOfAtomicComparisonsPerformedInRoundChanged(int var1);

    @Override
    public final void notifyAtomicComparisonStart() {
        this.doNotifyAtomicComparisonStart();
    }

    protected abstract void doNotifyAtomicComparisonStart();

    @Override
    public final void notifyAtomicComparisonPerformed() {
        this._processStatus.increaseCurrentNumberOfAtomicComparisonsPerformedInRound();
        this.doNotifyTotalNumberOfAtomicComparisonsChanged(this._processStatus.increaseTotalNumberOfAtomicComparisonsPerformed());
        this.doNotifyAtomicComparisonPerformed();
    }

    protected abstract void doNotifyTotalNumberOfAtomicComparisonsChanged(int var1);

    protected abstract void doNotifyAtomicComparisonPerformed();

    protected abstract void doNotifyMatchletsProcessStart();

    @Override
    public final void setMaximumNumberOfMatchletsApplied(int matchlets) {
        this._processStatus.setMaximumNumberOfMatchletsApplied(matchlets);
        this.doNotifyMaximumNumberOfMatchletsAppliedChanged(matchlets);
    }

    protected abstract void doNotifyMaximumNumberOfMatchletsAppliedChanged(int var1);

    @Override
    public final void notifyAuthoritativeFullMatch() {
        this.doNotifyNumberOfAuthoritativeFullMatchesChanged(this._processStatus.increaseNumberOfAuthoritativeFullMatches());
    }

    protected abstract void doNotifyNumberOfAuthoritativeFullMatchesChanged(int var1);

    @Override
    public final void notifyAuthoritativeNoMatch() {
        this.doNotifyNumberOfAuthoritativeNoMatchesChanged(this._processStatus.increaseNumberOfAuthoritativeNoMatches());
    }

    protected abstract void doNotifyNumberOfAuthoritativeNoMatchesChanged(int var1);

    @Override
    public final void notifyMatch() {
        this.doNotifyNumberOfMatchesChanged(this._processStatus.increaseNumberOfMatches());
    }

    protected abstract void doNotifyNumberOfMatchesChanged(int var1);

    @Override
    public int getTotalNumberOfMatches() {
        return this._processStatus.getNumberOfMatches() + this._processStatus.getNumberOfAuthoritativeFullMatches();
    }

    @Override
    public final void notifyAtomicComparisonEnd() {
        this.doNotifyAtomicComparisonEnd();
    }

    protected abstract void doNotifyAtomicComparisonEnd();

    @Override
    public final double getAtomicThroughput() {
        long elapsed = this.getElapsed();
        int comparisonRoundsPerformed = this.getTotalNumberOfAtomicComparisonsPerformed();
        if (elapsed == 0L) {
            return comparisonRoundsPerformed == 0 ? 0.0 : Double.POSITIVE_INFINITY;
        }
        return (double)comparisonRoundsPerformed * 1.0 / (double)elapsed;
    }

    @Override
    public final double getThroughput() {
        long elapsed = this.getElapsed();
        int comparisonRoundsPerformed = this.getCurrentNumberOfComparisonRoundsPerformed();
        if (elapsed == 0L) {
            return comparisonRoundsPerformed == 0 ? 0.0 : Double.POSITIVE_INFINITY;
        }
        return (double)comparisonRoundsPerformed * 1.0 / (double)elapsed;
    }

    public void setCurrentNumberOfAtomicComparisonsPerformedInRound(int currentNumberOfAtomicComparisonsPerformedInRound) {
        this._processStatus.setCurrentNumberOfAtomicComparisonsPerformedInRound(currentNumberOfAtomicComparisonsPerformedInRound);
    }

    public void setCurrentNumberOfComparisonRoundsPerformed(int currentNumberOfComparisonRoundsPerformed) {
        this._processStatus.setCurrentNumberOfComparisonRoundsPerformed(currentNumberOfComparisonRoundsPerformed);
    }

    public int getMaximumNumberOfAtomicComparisonsPerformedInRound() {
        return this._processStatus.getMaximumNumberOfAtomicComparisonsPerformedInRound();
    }

    public void setNumberOfAuthoritativeFullMatches(int numberOfAuthoritativeFullMatches) {
        this._processStatus.setNumberOfAuthoritativeFullMatches(numberOfAuthoritativeFullMatches);
    }

    public void setNumberOfAuthoritativeNoMatches(int numberOfAuthoritativeNoMatches) {
        this._processStatus.setNumberOfAuthoritativeNoMatches(numberOfAuthoritativeNoMatches);
    }

    public int getNumberOfComparisonRounds() {
        return this._processStatus.getNumberOfComparisonRounds();
    }

    public void setNumberOfMatches(int numberOfMatches) {
        this._processStatus.setNumberOfMatches(numberOfMatches);
    }

    public void setProcessEndTimestamp(long processEndTimestamp) {
        this._processStatus.setProcessEndTimestamp(processEndTimestamp);
    }

    public void setProcessStartTimestamp(long processStartTimestamp) {
        this._processStatus.setProcessStartTimestamp(processStartTimestamp);
    }

    public void setTotalNumberOfAtomicComparisonsPerformed(int totalNumberOfAtomicComparisonsPerformed) {
        this._processStatus.setTotalNumberOfAtomicComparisonsPerformed(totalNumberOfAtomicComparisonsPerformed);
    }

    @Override
    public int getCurrentNumberOfAtomicComparisonsPerformedInRound() {
        return this._processStatus.getCurrentNumberOfAtomicComparisonsPerformedInRound();
    }

    @Override
    public int getCurrentNumberOfComparisonRoundsPerformed() {
        return this._processStatus.getCurrentNumberOfComparisonRoundsPerformed();
    }

    @Override
    public int getMaximumNumberOfMatchletsApplied() {
        return this._processStatus.getMaximumNumberOfMatchletsApplied();
    }

    @Override
    public int getNumberOfAuthoritativeFullMatches() {
        return this._processStatus.getNumberOfAuthoritativeFullMatches();
    }

    @Override
    public int getNumberOfAuthoritativeNoMatches() {
        return this._processStatus.getNumberOfAuthoritativeNoMatches();
    }

    @Override
    public int getNumberOfMatches() {
        return this._processStatus.getNumberOfMatches();
    }

    @Override
    public long getProcessEndTimestamp() {
        return this._processStatus.getProcessEndTimestamp();
    }

    @Override
    public String getProcessId() {
        return this._processStatus.getProcessId();
    }

    public void setProcessId(String processId) {
        this._processStatus.setProcessId(processId);
    }

    @Override
    public long getProcessStartTimestamp() {
        return this._processStatus.getProcessStartTimestamp();
    }

    @Override
    public int getTotalNumberOfAtomicComparisonsPerformed() {
        return this._processStatus.getTotalNumberOfAtomicComparisonsPerformed();
    }

    @Override
    public void notifyComparisonError() {
        this._processStatus.increaseNumberOfComparisonErrors();
    }

    @Override
    public int getNumberOfComparisonErrors() {
        return this._processStatus.getNumberOfComparisonErrors();
    }

    @Override
    public void notifyAtomicComparisonSkipped() {
        this._processStatus.increaseNumberOfAtomicComparisonsSkipped();
    }

    @Override
    public int getNumberOfAtomicComparisonsSkipped() {
        return this._processStatus.getNumberOfAtomicComparisonsSkipped();
    }
}

