/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.matchlets.skeleton.behaviours;

import java.io.Serializable;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;

public abstract class BehaviourSkeleton<SOURCE, SOURCE_DATA extends Serializable, TARGET, TARGET_DATA extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 600756509504975112L;

    public final MatchingScore updateScore(MatchingScore current, SOURCE source, SOURCE_DATA sourceData, TARGET target, TARGET_DATA targetData) {
        AssertionUtils.$nNull(current, "Current score cannot be null", new Object[0]);
        AssertionUtils.$gte(current.getValue(), 0.0, "Current score value ({}) cannot be lower than the minimum allowed ({})", current.getValue(), 0.0);
        AssertionUtils.$lte(current.getValue(), 1.0, "Current score value ({}) cannot be higher than the maximum allowed ({})", current.getValue(), 1.0);
        MatchingScore updated = new MatchingScore(current);
        if (this.continueComparison(current)) {
            updated = this.doUpdateScore(current, sourceData, targetData);
        }
        AssertionUtils.$gte(updated.getValue(), 0.0, "Updated score ({}) cannot be lower than the minimum allowed ({})", updated.getValue(), 0.0);
        AssertionUtils.$lte(updated.getValue(), 1.0, "Updated score ({}) cannot be higher than the maximum allowed ({})", updated.getValue(), 1.0);
        return updated;
    }

    protected abstract MatchingScore doUpdateScore(MatchingScore var1, SOURCE_DATA var2, TARGET_DATA var3);

    protected final boolean continueComparison(MatchingScore score) {
        AssertionUtils.$nNull(score, "The provided score cannot be null", new Object[0]);
        return score.isNonAuthoritative() && !score.isNoMatch();
    }
}

