/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.matchlets.skeleton.helpers;

import java.io.Serializable;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.core.model.support.MatchingType;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;

public abstract class StringComparisonHelperSkeleton
implements Serializable {
    private static final long serialVersionUID = -7219197782203476211L;
    public static final double DEFAULT_WEIGHT = 1.0;
    public static final boolean MOVE_NUMBERS_TO_RIGHT = true;
    public static final boolean DONT_MOVE_NUMBERS_TO_RIGHT = false;
    public static final boolean REMOVE_ALL_SPACES = true;
    public static final boolean DONT_REMOVE_ALL_SPACES = false;

    public final MatchingScore compareStrings(String first, String second, boolean moveNumbersToRight, boolean removeAllSpaces) {
        return this.compareStrings(1.0, moveNumbersToRight, removeAllSpaces, first, second);
    }

    public final MatchingScore compareStrings(String first, String second, int maximumDistance, boolean moveNumbersToRight, boolean removeAllSpaces) {
        return this.compareStrings(1.0, maximumDistance, moveNumbersToRight, removeAllSpaces, first, second);
    }

    public final MatchingScore compareStrings(double weight, boolean moveNumbersToRight, boolean removeAllSpaces, String first, String second) {
        assert (Double.compare(weight, 0.0) >= 0) : "The comparison weight cannot be lower than zero";
        assert (Double.compare(weight, 1.0) <= 0) : "The comparison weight cannot be higher than one";
        if (first == null && second == null) {
            return MatchingScore.getNonPerformedTemplate();
        }
        if (first == null || second == null) {
            return MatchingScore.getNonAuthoritativeNoMatchTemplate();
        }
        double lambda = 0.0;
        String firstString = first.trim().toUpperCase();
        String secondString = second.trim().toUpperCase();
        if (first.trim().equalsIgnoreCase(second)) {
            lambda = 1.0;
        } else {
            if (moveNumbersToRight) {
                firstString = StringUtils.shiftNumbersToRight(firstString);
                secondString = StringUtils.shiftNumbersToRight(secondString);
            }
            if (removeAllSpaces) {
                firstString = StringUtils.removeAllSpaces(firstString);
                secondString = StringUtils.removeAllSpaces(secondString);
            } else {
                firstString = StringUtils.removeMultipleSpaces(firstString);
                secondString = StringUtils.removeMultipleSpaces(secondString);
            }
            lambda = 1.0 * (1.0 - StringUtils.computeRelativeDistance(firstString, secondString));
        }
        return new MatchingScore(lambda * weight, MatchingType.NON_AUTHORITATIVE);
    }

    protected final MatchingScore compareStrings(double weight, int maximumDistance, boolean moveNumbersToRight, boolean removeAllSpaces, String first, String second) {
        String secondString;
        assert (Double.compare(weight, 0.0) >= 0) : "The comparison weight cannot be lower than zero";
        assert (Double.compare(weight, 1.0) <= 0) : "The comparison weight cannot be higher than one";
        assert (maximumDistance >= 0) : "The maximum distance cannot be lower than zero";
        if (first == null && second == null) {
            return MatchingScore.getNonPerformedTemplate();
        }
        if (first == null || second == null) {
            return MatchingScore.getNonAuthoritativeNoMatchTemplate();
        }
        double lambda = 0.0;
        String firstString = first.trim().toUpperCase();
        if (firstString.equals(secondString = second.trim().toUpperCase())) {
            lambda = 1.0;
        } else {
            if (moveNumbersToRight) {
                firstString = StringUtils.shiftNumbersToRight(firstString);
                secondString = StringUtils.shiftNumbersToRight(secondString);
            }
            if (removeAllSpaces) {
                firstString = StringUtils.removeAllSpaces(firstString);
                secondString = StringUtils.removeAllSpaces(secondString);
            } else {
                firstString = StringUtils.removeMultipleSpaces(firstString);
                secondString = StringUtils.removeMultipleSpaces(secondString);
            }
            int distance = StringUtils.computeDistance(firstString, secondString);
            lambda = distance <= maximumDistance ? 1.0 * (1.0 - (maximumDistance > 0 ? (double)distance * 1.0 / (double)maximumDistance : (distance == 0 ? 0.0 : 1.0))) : 0.0;
        }
        return new MatchingScore(lambda * weight, MatchingType.NON_AUTHORITATIVE);
    }
}

