/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.model.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.engine.MatchingResult;
import org.fao.fi.comet.core.model.engine.adapters.MatchingResultAdapter;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.core.model.support.MatchingType;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;

@XmlType(name="Matching")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Matching<SOURCE, TARGET>
implements Serializable {
    private static final long serialVersionUID = 8023951008448179546L;
    @XmlAttribute(name="processID")
    private String _processID;
    @XmlTransient
    private DataIdentifier _sourceIdentifier;
    @XmlTransient
    private DataIdentifier _targetIdentifier;
    @XmlElement(name="Target")
    private TARGET _target;
    @XmlTransient
    private MatchingScore _score;
    @XmlElementWrapper(name="MatchingResults")
    @XmlElement(name="MatchingResult")
    @XmlJavaTypeAdapter(value=MatchingResultAdapter.class)
    private Collection<MatchingResult<?, ?>> _matchingResults;

    public Matching() {
        this._matchingResults = Collections.synchronizedCollection(new ArrayList());
    }

    public Matching(String processID, DataIdentifier sourceIdentifier, TARGET target, DataIdentifier targetIdentifier, MatchingScore score, Collection<MatchingResult<?, ?>> matchingResults) {
        this._processID = processID;
        this._sourceIdentifier = sourceIdentifier;
        this._targetIdentifier = targetIdentifier;
        this._target = target;
        this._score = score;
        this._matchingResults = Collections.synchronizedCollection(matchingResults);
    }

    public String getProcessID() {
        return this._processID;
    }

    public void setProcessID(String processID) {
        this._processID = processID;
    }

    @XmlAttribute(name="score")
    public double getScoreValue() {
        return this._score.getValue();
    }

    public void setScoreValue(double scoreValue) {
        if (this._score == null) {
            this._score = new MatchingScore();
        }
        this._score.setValue(scoreValue);
    }

    @XmlAttribute(name="type")
    public MatchingType getScoreType() {
        return this._score.getMatchingType();
    }

    public void setScoreType(MatchingType scoreType) {
        if (this._score == null) {
            this._score = new MatchingScore();
        }
        this._score.setMatchingType(scoreType);
    }

    public DataIdentifier getSourceIdentifier() {
        return this._sourceIdentifier;
    }

    public void setSourceIdentifier(DataIdentifier sourceIdentifier) {
        this._sourceIdentifier = sourceIdentifier;
    }

    @XmlAttribute(name="sourceId")
    public String getSourceId() {
        return this._sourceIdentifier.getId();
    }

    public void setSourceId(String sourceId) {
        if (this._sourceIdentifier == null) {
            this._sourceIdentifier = new DataIdentifier();
        }
        this._sourceIdentifier.setId(sourceId);
    }

    @XmlAttribute(name="sourceProviderId")
    public String getSourceProviderId() {
        return this._sourceIdentifier.getProviderId();
    }

    public void setSourceProviderId(String sourceProviderId) {
        if (this._sourceIdentifier == null) {
            this._sourceIdentifier = new DataIdentifier();
        }
        this._sourceIdentifier.setProviderId(sourceProviderId);
    }

    public DataIdentifier getTargetIdentifier() {
        return this._targetIdentifier;
    }

    public void setTargetIdentifier(DataIdentifier targetIdentifier) {
        this._targetIdentifier = targetIdentifier;
    }

    @XmlAttribute(name="targetId")
    public String getTargetId() {
        return this._targetIdentifier.getId();
    }

    public void setTargetId(String targetId) {
        if (this._targetIdentifier == null) {
            this._targetIdentifier = new DataIdentifier();
        }
        this._targetIdentifier.setId(targetId);
    }

    @XmlAttribute(name="targetProviderId")
    public String getTargetProviderId() {
        return this._targetIdentifier.getProviderId();
    }

    public void setTargetProviderId(String targetProviderId) {
        if (this._targetIdentifier == null) {
            this._targetIdentifier = new DataIdentifier();
        }
        this._targetIdentifier.setProviderId(targetProviderId);
    }

    public Object getTarget() {
        return this._target;
    }

    public void setTarget(TARGET target) {
        this._target = target;
    }

    @XmlTransient
    public MatchingScore getScore() {
        return this._score;
    }

    public void setScore(MatchingScore score) {
        AssertionUtils.$nNull(score, "The score cannot be null", new Object[0]);
        this._score = score;
    }

    public boolean isNoMatch() {
        return this._score.isNoMatch();
    }

    public boolean isFullMatch() {
        return this._score.isFullMatch();
    }

    public boolean isAuthoritative() {
        return this._score.isAuthoritative();
    }

    public boolean isNonAuthoritative() {
        return this._score.isNonAuthoritative();
    }

    public boolean isNonPerformed() {
        return this._score.isNonPerformed();
    }

    public Collection<MatchingResult<?, ?>> getMatchingResults() {
        return this._matchingResults;
    }

    public void updateMatchingResult(MatchingResult<?, ?> toAdd) {
        AssertionUtils.$nNull(toAdd, "Matching result cannot be null", new Object[0]);
        MatchingScore providedScore = toAdd.getScore();
        if (!toAdd.isNonPerformed()) {
            this._score.setMatchingType(providedScore.getMatchingType());
        }
        if (toAdd.isAuthoritative()) {
            this._matchingResults.clear();
            this._score.setValue(toAdd.getMatchletScoreValue());
        }
        this._matchingResults.add(toAdd);
    }

    public Matching<SOURCE, TARGET> join(Matching<SOURCE, TARGET> source) {
        AssertionUtils.$nNull(source, "Source matching cannot be null", new Object[0]);
        AssertionUtils.$_uOp(this.getSourceIdentifier() != null, "Cannot join a matching with null source ID", new Object[0]);
        AssertionUtils.$_uOp(this.getTargetIdentifier() != null, "Cannot join a matching with null target ID", new Object[0]);
        AssertionUtils.$_uOp(source.getSourceIdentifier() != null, "Cannot join a matching with null source ID", new Object[0]);
        AssertionUtils.$_uOp(source.getTargetIdentifier() != null, "Cannot join a matching with null target ID", new Object[0]);
        AssertionUtils.$_uOp(this.getSourceIdentifier().equals(source.getSourceIdentifier()), "Cannot join matchings with different source IDs", new Object[0]);
        try {
            AssertionUtils.$_uOp(this.getTargetIdentifier().equals(source.getTargetIdentifier()), "Cannot join matchings with different target IDs", new Object[0]);
        }
        catch (Throwable t) {
            System.out.println("This should not happen...");
        }
        if (source.isAuthoritative()) {
            return ObjectsUtils.rawClone(source);
        }
        if (this.isAuthoritative() || source.getScore().isNonPerformed()) {
            return ObjectsUtils.rawClone(this);
        }
        if (Double.compare(source.getScore().getValue(), this.getScore().getValue()) > 0) {
            return ObjectsUtils.rawClone(source);
        }
        return ObjectsUtils.rawClone(this);
    }

    public Matching<SOURCE, TARGET> merge(Matching<SOURCE, TARGET> another) {
        AssertionUtils.$eq(this._sourceIdentifier, another._sourceIdentifier, "Source IDs must be equal between current and joined matching", new Object[0]);
        AssertionUtils.$eq(this._targetIdentifier, another._targetIdentifier, "Target IDs must be equal between current and joined matching", new Object[0]);
        Matching<SOURCE, TARGET> joined = new Matching<SOURCE, TARGET>();
        joined.setSourceIdentifier(this._sourceIdentifier);
        joined.setTargetIdentifier(another._targetIdentifier);
        joined.setTarget(another._target);
        joined.setScore(this._score.multiply(another._score));
        joined._matchingResults = new ArrayList(this._matchingResults);
        for (MatchingResult<?, ?> otherResult : another._matchingResults) {
            joined._matchingResults.add(otherResult);
        }
        return joined;
    }

    public String toString() {
        return "[ WTS: " + this._score + ", " + "SPID: " + this._sourceIdentifier.getProviderId() + ", " + "TPID: " + this._targetIdentifier.getProviderId() + ", " + "SID: " + this._sourceIdentifier.getId() + ", " + "TID: " + this._targetIdentifier.getId() + ", " + "MRS: " + this._matchingResults + " ]";
    }

    public int hashCode() {
        AssertionUtils.$nNull(this._targetIdentifier, "Cannot compute hashcode of matching with NULL targetID", new Object[0]);
        return this._targetIdentifier.hashCode();
    }
}

